//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __GNUG__
#pragma implementation
#endif
#include "ioprivate.h"
#include <strstream.h>
#include <std.h>

istrstream::istrstream(char *cp) : istream(NULL)
{
    _strbuf = new strstreambuf(cp, 0, NULL);
}

istrstream::istrstream(char *cp, int n) : istream(NULL)
{
    _strbuf = new strstreambuf(cp, n, NULL);
}

ostrstream::ostrstream() : ostream(NULL)
{
    _strbuf = new strstreambuf;
}

ostrstream::ostrstream(char *cp, int n, int mode) : ostream(NULL)
{
    char *pstart;
    if (mode == ios::app || mode == ios::ate)
	pstart = cp + strlen(cp);
    else
	pstart = cp;
    _strbuf = new strstreambuf(cp, n, pstart);
}


char *strstreambuf::str()
{
    freeze(1);
    return buf;
}

size_t strstreambuf::pcount()
{
    size_t put_len = pptr() - pbase();
    if (put_len < *lenp) put_len = *lenp;
    return put_len;
}

int strstreambuf::overflow(int c = EOF)
{
  const int flush_only = c == EOF;
  size_t pos = pptr() - pbase();
  size_t get_pos = gptr() - pbase();
  if (pos > *lenp) *lenp = pos;
  if (pos >= *sizep + flush_only) {
      char *new_buf;
      size_t new_size = 2 * *sizep;
      if (_frozen) /* not allowed to enlarge */
	  return EOF;
      else {
	  new_buf = ALLOC_BUF(new_size);
	  memcpy(new_buf, buf, *sizep);
      }
      if (new_buf == NULL) {
//	  __ferror(fp) = 1;
	  return EOF;
      }
      *sizep = new_size;
      if (lenp == &_len) /* use '\0'-filling */
	  memset(new_buf + pos, 0, *sizep - pos);
      buf = new_buf;
      if (bufp) *bufp = buf;
      setb(new_buf, new_buf + *sizep, 1);
    }

  setp(buf, buf + *sizep);
  pbump(pos);
  setg(buf, buf + get_pos, buf + *lenp);
  if (!flush_only) {
      *pptr() = (unsigned char) c;
      pbump(1);
  }
  return c;
}

strstreambuf::strstreambuf()
{
    _frozen = 0;
//    _flags &= ~ios::dont_close; 
    _len = 0;
    _size = 128;
    sizep = &_size;
    lenp = &_len;
    buf = ALLOC_BUF(_size);
    bufp = &buf;
    setb(buf, buf+_size);
    setp(buf, buf+_size);
    xsetflags(_S_CAN_READ | _S_CAN_WRITE);
}

strstreambuf::strstreambuf(int initial)
{
    _frozen = 0;
//    _flags &= ~ios::dont_close; 
    _len = 0;
    if (initial < 16)
	initial = 16;
    _size = initial;
    sizep = &_size;
    lenp = &_len;
    buf = ALLOC_BUF(_size);
    bufp = &buf;
    setb(buf, buf+_size);
    setp(buf, buf+_size);
    xsetflags(_S_CAN_READ | _S_CAN_WRITE);
}

strstreambuf::strstreambuf(char *ptr, int size, char *pstart)
{
//    _flags &= ~ios::dont_close; 
    _frozen = 1;
    _len = 0;
    if (size == 0)
	size = strlen(ptr);
    else if (size < 0)
	size = 0x7FFFFFFF; // !!!
    _size = size;
    sizep = &_size;
    lenp = &_len;
    buf = ptr;
    bufp = &buf;
    int new_flags = _S_CAN_READ;
    setb(buf, buf+_size);
    if (pstart) {
	new_flags |= _S_CAN_WRITE;
	setp(buf, buf+_size);
	pbump(pstart-buf);
	setg(buf, buf, pstart);
    }
    else {
	setp(buf, buf); 
	setg(buf, buf, buf+_size);
    }
    xsetflags(new_flags);
}

strstreambuf::~strstreambuf()
{
    if (_frozen == 0)
        FREE_BUF(buf);
}
