/* { dg-do run { target { riscv_v } } } */
/* { dg-options "-O2" } */

#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"
using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}



int main()
{
int return_value = 0;

size_t var_117 = 54u;
uint16_t var_116 [] = {0u, 0u, 0u, 65535u, 0u, 0u, 0u, 0u, 0u, 0u, 65535u, 0u, 0u, 1u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u};
size_t var_114 = 4u;
int32_t var_113 [] = {1131231630};
size_t var_111 = 28u;
int32_t var_110 [] = {1482257973, -2080211897, -1425005568, -772921329, 2039222333, -1571066816, -188946235};
size_t var_108 = 32u;
int32_t var_107 [] = {813369075, 1204827914, 1528599370, 1275800932, -2129835614, -1571066816, -13757896, -2057974591};
size_t var_105 = 8u;
int8_t var_104 [] = {-73, -22, -38, 19, -63, -62, -54, -19};
uint16_t var_102 [] = {52140u, 59943u, 63965u, 9648u, 63559u, 28713u, 30184u, 12417u, 41389u, 14500u, 15113u, 56595u, 42619u, 2896u, 47283u, 58428u, 29398u, 37618u, 46357u, 24160u, 39915u, 34372u, 12510u, 42546u, 18411u, 60003u, 43401u};
int32_t var_101 [] = {2069013122, -1368940921, -2080211897, 631650388, -1314194581, 69574056, -1878864342, -2037063984, 2137209457, 1014980535, 909383812, -910413246, -1431785962, 590505332, 2039222333, -347077016, -1858298303, 1578278808, -1050337408, -72583627, -1099928980, 1772484196, -386537109, 1102076145, 869454379, -2134514169, -1556682087, 718017706, 383122722, -2103455017, -259297483, -521905245, -1427561998, 624230573, -13757896, -1330338529, -1219765796, -1127570029, 1207018851, 613427774, -1220354627, -2026904039, -1502721560, -633869536, 362147503, -1480610983, -1574779941, 207768905, 1839325720, 2059147515, 1460874286, -1942707504, -1684874627, 293684054, -1742524516, -1187457535, -88417097, -1475702784, -1780376525, -839989115, 1550010305, -2047737914, 979761741, -875216019};
uint16_t var_99 [] = {144u, 8u, 148u, 24u, 56u, 152u, 136u, 48u, 12u, 204u, 4u, 128u, 0u, 176u, 40u, 196u, 84u, 208u, 108u, 212u, 188u, 120u, 92u, 20u, 80u, 96u, 72u};
uint32_t var_97 = 7u;
uint32_t var_95 [] = {1724306898u, 1160725831u, 519600880u, 3968407808u, 2394542848u, 1724357472u, 658497049u, 3234608948u};
int8_t var_94 [] = {-73, -22, 108, 90, 1, -62, -54, 114};
int8_t var_93 [] = {125, -71, -38, 19, -63, -115, -52, -19};
float64_t var_92 [] = {f64(12922509399134607095u), f64(13681792908481616153u), f64(12961200966296176724u), f64(14056580188338608325u), f64(5165498436007611196u), f64(5891026634065631128u), f64(11585749923629966909u), f64(4313307776925509365u)};
// -2.1368188023093786e-61, -1.1457019892378542e-10, -7.825060027673582e-59, -1337337735665201.2, 2.0959899369128604e+37, 6.655935256786952e+85, -9.490248727914318e-151, 2.367248714068789e-20

float64_t var_91 [] = {f64(2782416797552003540u), f64(17887890837946723391u), f64(1899994729740199155u), f64(10761954294193513069u), f64(14073813696208453008u), f64(13681301065814324064u), f64(13575220409714312128u), f64(1467011674835775258u)};
// 1.101654707111875e-122, -1.6141756689152726e+271, 1.1348186875896591e-181, -8.1426474651423e-206, -1.8273841212094016e+16, -1.0821328144237315e-10, -9.051458507964313e-18, 1.324701712596762e-210

uint8_t var_90 [] = {48u, 14u, 163u, 186u, 77u, 121u, 66u, 189u};
uint8_t var_89 [] = {44u, 174u, 62u, 152u, 190u, 184u, 211u, 207u};
int32_t var_88 [] = {-1862105746, 785328569, -186089231, 800073162, 700994575, 2001118506, 491632681, 2012279744};
int32_t var_87 [] = {-1426460805, 1391224153, 391018314, 1747488700, 171852085, -26969920, 1491273002, -1037517631};
int32_t var_86 [] = {-1007131310, -1935237840, 2131743138, 1562448120, 554248768, 1043844959, -272924185, 1908950866};
uint32_t var_85 [] = {331199451u, 2147245828u, 2310560262u, 1691746756u, 3884722626u, 185329475u, 335670251u, 3708458775u};
uint32_t var_84 [] = {4142322270u, 4074305254u, 3445223658u, 2300853929u, 590829748u, 3453669629u, 2059468991u, 4136545759u};
int32_t var_83 [] = {-1482257973, -1918917804, 1664313015, 772921329, -1080281711, -81955995, 188946235};
int32_t var_82 [] = {-1199710090, -1526593688, 1087685446, 451331814, 2120591979, -1929369621, 1851976937};
int8_t var_81 [] = {116, -64, -85, 53, 96, 29, -23};
int8_t var_80 [] = {-55, -33, 121, -59, 117, 95, -128};
int32_t var_79 [] = {313413364, -1948452097, 48968472, 1638685938, -1253448876, -892478863, -1372364897, -1645124752, -1249167956, -1192514844, 1426594924, -377916957, -76355607, -1487562927, 1352608927, 2006772863, -1590277543, 897536043, 1045648728, 1685555981, 1015388771, 1922565890, 1107673669, -144112029, -1911947830, 1598134864, 1604618821};
int32_t var_78 [] = {-2101808540, -1703952474, 826896624, -371182456, 1757221438, -597812672, -1652792312, -445713936, 453236293, 1341711666, 1820293097, -1104906842, -2016988437, -1553335267, -412524033, 1420433669, -1471236009, 582768780, 531897192, -418517458, 200863626, 1099229305, 849131599, 1720583698, 867992649, -232197794, -1758985822};
int16_t var_77 [] = {-3313, -20409, 29551, 5558, 16767, 22583, 27835, -31801, -10322, 26191, -12956, -9551, -2709, 6812, 4448, -4942, 2086, -25819, 9684, -17645, -7317, -1044, -9028, -13237, 27006, -16655, -27798};
int8_t var_76 [] = {-62, 22, 41, -128, 83, -29, -90, 82, 72, -125, 33, -52, 79, -26, -92, 3, 75, 122, -1, -97, 37, -15, 82, -34, 2, -35, -116};
int8_t var_75 [] = {-48, 24, -127, 32, -58, -44, 118, 62, -114, 64, 22, -24, -20, -71, 75, 113, 12, 14, 58, -89, -103, -29, 63, 37, 25, -99, -109};
int32_t var_74 [] = {-507451025, -125565381, 408231117, -158162944, 1085647217, 508923779, -1948095886, 218780494};
int32_t var_73 [] = {2043236272, 992773258, 1599815252, 166211673, 1255185392, 2077252875, -243558405, -745426821};
uint32_t var_72 [] = {219915149u, 1691908340u, 2049727508u, 117249866u, 3502211068u, 608209970u, 178777369u, 133747942u};
int32_t var_71 [] = {1777702579, 933403794, -574300082, -13421362, -1463117709, -367080915, 1435942936, -909349460};
uint16_t var_70 [] = {62618u, 22279u, 49831u, 34050u, 16290u, 59215u, 40971u, 32430u, 59269u, 56222u, 25121u, 14592u, 23259u, 442u, 13488u, 1844u, 21166u, 29064u, 11869u, 21037u, 23003u, 38279u, 41308u, 21144u, 49608u, 42546u, 58026u};
uint16_t var_69 [] = {43304u, 20248u, 25263u, 2691u, 51778u, 58152u, 54408u, 6177u, 49900u, 18701u, 57281u, 38757u, 38171u, 31182u, 13543u, 38368u, 55068u, 23109u, 11144u, 45588u, 47327u, 47070u, 26446u, 55734u, 19514u, 49821u, 15823u};
float32_t var_68 [] = {f32(2847156718u), f32(2322089025u), f32(2472203265u), f32(9086869u), f32(544251513u), f32(3232380532u), f32(2637100406u), f32(3904304908u), f32(4094724758u), f32(1810767428u), f32(3705495664u), f32(228437819u), f32(507805196u), f32(1255296302u), f32(3284790541u), f32(3509915205u), f32(2924424021u), f32(2548605725u), f32(2148948796u), f32(204929039u), f32(657024717u), f32(907854480u), f32(3641195928u), f32(4161344434u), f32(3260203264u), f32(1285405376u), f32(1147886346u)};
// -8.000879418625789e-14, -1.1183230810440917e-32, -2.761999436998062e-27, 1.2733415575220786e-38, 2.038122493765112e-19, -5.319147109985352, -2.3155608583875722e-21, -6.912223282876881e+24, -4.580698268912941e+31, 5.757345408827297e+26, -4.98496032045269e+17, 9.718057241468303e-31, 1.0402219486683403e-20, 6891159.0, -403.8519592285156, -48601780224.0, -4.710483739178706e-11, -1.5033824183547769e-24, -2.053109642408577e-39, 1.4095417412899345e-31, 2.350918981038866e-15, 2.335906174266711e-06, -2396769992310784.0, -1.1121002156479192e+34, -52.6884765625, 82695680.0, 941.4224853515625

int16_t var_67 [] = {-25082, -28599, -25747, 20638, -17688, 12146, -30280, 30663, -25770, 13683, 25809, -3140, -8481, -13306, -7345, 17811, -8185, -20020, -28257, 30298, 26059, 8780, -8531, 5466, 7024, 6714, 1604};
int16_t var_66 [] = {25003, 7408, -29306, -20538, 24896, -10180, 17648, 15137, -1835, 300, -16330, 618, 29527, 25340, -15466, -17361, -18568, -19657, 16349, 26319, -10598, 19199, 8860, 14834, -10463, -20815, -17872};
int32_t var_65 [] = {-837045230, -882942322, 1581645895, 626004745, 897210368, 172502132, 1272779112, 1136503917, 1812560846, 1483165492, -973576091, -47436677, 337814556, -211558845, 755078495, 1403626389, 1606078406, 2126743853, -1073923665, 833202120, 268872639, 1641317818, -270559000, -735594549, -1072867814, -1994709512, -897229444};
int32_t var_64 [] = {886219385};
float32_t var_63 [] = {f32(3557688729u), f32(2472673958u), f32(3060341569u), f32(1284824831u), f32(2851110045u), f32(3369008656u), f32(831471122u), f32(2388863590u), f32(3600055344u), f32(222911681u), f32(2052676798u), f32(2359679597u), f32(4000009057u), f32(1060570104u), f32(4014415006u), f32(113339578u), f32(2330632585u), f32(3225802533u), f32(2461484160u), f32(2851489446u), f32(627545295u), f32(24199786u), f32(3732703771u), f32(1484387u), f32(4203645669u), f32(2702868363u), f32(3908083212u)};
// -2439917076480.0, -2.852651611329408e-27, -3.4735569443000713e-06, 78051320.0, -1.067975799484179e-13, -423920.5, 4.168904332857437e-09, -2.8000324337151883e-30, -81630551080960.0, 6.204955546493461e-31, 2.821523633341178e+35, -2.5553735501141373e-31, -1.8205026203509007e+28, 0.7149043083190918, -6.162211301130117e+28, 7.275829043178832e-35, -2.2594143121692602e-32, -3.0912563800811768, -1.1565810206188e-27, -1.0936850112618773e-13, 2.0086474460228454e-16, 4.4312358901132665e-38, -4.549346732789465e+18, 2.0800692235637222e-39, -3.700616348432326e+35, -5.234603126449283e-19, -9.090267249147915e+24

int32_t var_62 = 1131231630;
int32_t var_61 = -284499481;
float32_t var_60 = f32(3372864583u);
// -564548.4375

__riscv_vsetvl_e8mf2(8);
vbool16_t var_23 = __riscv_vmset_m_b16(8);
// 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m4(27);
vuint16m4_t var_98 = __riscv_vle16_v_u16m4(var_99, 27);
// 144, 8, 148, 24, 56, 152, 136, 48, 12, 204, 4, 128, 0, 176, 40, 196, 84, 208, 108, 212, 188, 120, 92, 20, 80, 96, 72

__riscv_vsetvl_e32m8(8);
vuint32m8_t var_20 = __riscv_vle32_v_u32m8(var_95, 8);
// 1724306898, 1160725831, 519600880, 3968407808, 2394542848, 1724357472, 658497049, 3234608948

vint8m2_t var_22 = __riscv_vle8_v_i8m2(var_93, 8);
// 125, -71, -38, 19, -63, -115, -52, -19

__riscv_vsetvl_e64m4(8);
vfloat64m4_t var_25 = __riscv_vle64_v_f64m4(var_92, 8);
// -2.1368188023093786e-61, -1.1457019892378542e-10, -7.825060027673582e-59, -1337337735665201.2, 2.0959899369128604e+37, 6.655935256786952e+85, -9.490248727914318e-151, 2.367248714068789e-20

vfloat64m4_t var_26 = __riscv_vle64_v_f64m4(var_91, 8);
// 1.101654707111875e-122, -1.6141756689152726e+271, 1.1348186875896591e-181, -8.1426474651423e-206, -1.8273841212094016e+16, -1.0821328144237315e-10, -9.051458507964313e-18, 1.324701712596762e-210

vuint8mf2_t var_27 = __riscv_vle8_v_u8mf2(var_90, 8);
// 48, 14, 163, 186, 77, 121, 66, 189

vuint8mf2_t var_28 = __riscv_vle8_v_u8mf2(var_89, 8);
// 44, 174, 62, 152, 190, 184, 211, 207

__riscv_vsetvl_e32m8(8);
vint32m8_t var_30 = __riscv_vle32_v_i32m8(var_88, 8);
// -1862105746, 785328569, -186089231, 800073162, 700994575, 2001118506, 491632681, 2012279744

vint32m8_t var_31 = __riscv_vle32_v_i32m8(var_87, 8);
// -1426460805, 1391224153, 391018314, 1747488700, 171852085, -26969920, 1491273002, -1037517631

vuint32m8_t var_33 = __riscv_vle32_v_u32m8(var_85, 8);
// 331199451, 2147245828, 2310560262, 1691746756, 3884722626, 185329475, 335670251, 3708458775

vuint32m8_t var_34 = __riscv_vle32_v_u32m8(var_84, 8);
// 4142322270, 4074305254, 3445223658, 2300853929, 590829748, 3453669629, 2059468991, 4136545759

__riscv_vsetvl_e32m8(7);
vint32m8_t var_36 = __riscv_vle32_v_i32m8(var_83, 7);
// -1482257973, -1918917804, 1664313015, 772921329, -1080281711, -81955995, 188946235

vint8m2_t var_38 = __riscv_vle8_v_i8m2(var_81, 7);
// 116, -64, -85, 53, 96, 29, -23

vint8m2_t var_39 = __riscv_vle8_v_i8m2(var_80, 7);
// -55, -33, 121, -59, 117, 95, -128

__riscv_vsetvl_e32m8(27);
vint32m8_t var_41 = __riscv_vle32_v_i32m8(var_79, 27);
// 313413364, -1948452097, 48968472, 1638685938, -1253448876, -892478863, -1372364897, -1645124752, -1249167956, -1192514844, 1426594924, -377916957, -76355607, -1487562927, 1352608927, 2006772863, -1590277543, 897536043, 1045648728, 1685555981, 1015388771, 1922565890, 1107673669, -144112029, -1911947830, 1598134864, 1604618821

vint32m8_t var_42 = __riscv_vle32_v_i32m8(var_78, 27);
// -2101808540, -1703952474, 826896624, -371182456, 1757221438, -597812672, -1652792312, -445713936, 453236293, 1341711666, 1820293097, -1104906842, -2016988437, -1553335267, -412524033, 1420433669, -1471236009, 582768780, 531897192, -418517458, 200863626, 1099229305, 849131599, 1720583698, 867992649, -232197794, -1758985822

vint16m4_t var_43 = __riscv_vle16_v_i16m4(var_77, 27);
// -3313, -20409, 29551, 5558, 16767, 22583, 27835, -31801, -10322, 26191, -12956, -9551, -2709, 6812, 4448, -4942, 2086, -25819, 9684, -17645, -7317, -1044, -9028, -13237, 27006, -16655, -27798

vint8m2_t var_44 = __riscv_vle8_v_i8m2(var_76, 27);
// -62, 22, 41, -128, 83, -29, -90, 82, 72, -125, 33, -52, 79, -26, -92, 3, 75, 122, -1, -97, 37, -15, 82, -34, 2, -35, -116

vint8m2_t var_45 = __riscv_vle8_v_i8m2(var_75, 27);
// -48, 24, -127, 32, -58, -44, 118, 62, -114, 64, 22, -24, -20, -71, 75, 113, 12, 14, 58, -89, -103, -29, 63, 37, 25, -99, -109

__riscv_vsetvl_e32m2(8);
vint32m2_t var_46 = __riscv_vle32_v_i32m2(var_74, 8);
// -507451025, -125565381, 408231117, -158162944, 1085647217, 508923779, -1948095886, 218780494

vint32m2_t var_47 = __riscv_vle32_v_i32m2(var_73, 8);
// 2043236272, 992773258, 1599815252, 166211673, 1255185392, 2077252875, -243558405, -745426821

vuint32m2_t var_48 = __riscv_vle32_v_u32m2(var_72, 8);
// 219915149, 1691908340, 2049727508, 117249866, 3502211068, 608209970, 178777369, 133747942

vint32m2_t var_49 = __riscv_vle32_v_i32m2(var_71, 8);
// 1777702579, 933403794, -574300082, -13421362, -1463117709, -367080915, 1435942936, -909349460

__riscv_vsetvl_e16m4(27);
vuint16m4_t var_52 = __riscv_vle16_v_u16m4(var_70, 27);
// 62618, 22279, 49831, 34050, 16290, 59215, 40971, 32430, 59269, 56222, 25121, 14592, 23259, 442, 13488, 1844, 21166, 29064, 11869, 21037, 23003, 38279, 41308, 21144, 49608, 42546, 58026

vuint16m4_t var_53 = __riscv_vle16_v_u16m4(var_69, 27);
// 43304, 20248, 25263, 2691, 51778, 58152, 54408, 6177, 49900, 18701, 57281, 38757, 38171, 31182, 13543, 38368, 55068, 23109, 11144, 45588, 47327, 47070, 26446, 55734, 19514, 49821, 15823

vfloat32m8_t var_54 = __riscv_vle32_v_f32m8(var_68, 27);
// -8.000879418625789e-14, -1.1183230810440917e-32, -2.761999436998062e-27, 1.2733415575220786e-38, 2.038122493765112e-19, -5.319147109985352, -2.3155608583875722e-21, -6.912223282876881e+24, -4.580698268912941e+31, 5.757345408827297e+26, -4.98496032045269e+17, 9.718057241468303e-31, 1.0402219486683403e-20, 6891159.0, -403.8519592285156, -48601780224.0, -4.710483739178706e-11, -1.5033824183547769e-24, -2.053109642408577e-39, 1.4095417412899345e-31, 2.350918981038866e-15, 2.335906174266711e-06, -2396769992310784.0, -1.1121002156479192e+34, -52.6884765625, 82695680.0, 941.4224853515625

vint16m4_t var_55 = __riscv_vle16_v_i16m4(var_67, 27);
// -25082, -28599, -25747, 20638, -17688, 12146, -30280, 30663, -25770, 13683, 25809, -3140, -8481, -13306, -7345, 17811, -8185, -20020, -28257, 30298, 26059, 8780, -8531, 5466, 7024, 6714, 1604

vint16m4_t var_56 = __riscv_vle16_v_i16m4(var_66, 27);
// 25003, 7408, -29306, -20538, 24896, -10180, 17648, 15137, -1835, 300, -16330, 618, 29527, 25340, -15466, -17361, -18568, -19657, 16349, 26319, -10598, 19199, 8860, 14834, -10463, -20815, -17872

vint32m8_t var_57 = __riscv_vle32_v_i32m8(var_65, 27);
// -837045230, -882942322, 1581645895, 626004745, 897210368, 172502132, 1272779112, 1136503917, 1812560846, 1483165492, -973576091, -47436677, 337814556, -211558845, 755078495, 1403626389, 1606078406, 2126743853, -1073923665, 833202120, 268872639, 1641317818, -270559000, -735594549, -1072867814, -1994709512, -897229444

vfloat32m8_t var_59 = __riscv_vle32_v_f32m8(var_63, 27);
// -2439917076480.0, -2.852651611329408e-27, -3.4735569443000713e-06, 78051320.0, -1.067975799484179e-13, -423920.5, 4.168904332857437e-09, -2.8000324337151883e-30, -81630551080960.0, 6.204955546493461e-31, 2.821523633341178e+35, -2.5553735501141373e-31, -1.8205026203509007e+28, 0.7149043083190918, -6.162211301130117e+28, 7.275829043178832e-35, -2.2594143121692602e-32, -3.0912563800811768, -1.1565810206188e-27, -1.0936850112618773e-13, 2.0086474460228454e-16, 4.4312358901132665e-38, -4.549346732789465e+18, 2.0800692235637222e-39, -3.700616348432326e+35, -5.234603126449283e-19, -9.090267249147915e+24

vint32m8_t var_0 = __riscv_vluxei16_v_i32m8(var_101, var_98, 27);
// -1219765796, -2080211897, -1127570029, -1878864342, 2039222333, 1207018851, -13757896, -1431785962, 631650388, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -1684874627, 718017706, 293684054, 207768905, -259297483, 1102076145, 69574056, -1099928980, 869454379, -1050337408

__riscv_vsetvl_e8mf2(8);
vbool16_t var_24 = __riscv_vmsbc_vv_u8mf2_b16(var_27, var_28, 8);
// 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m8(8);
vbool4_t var_29 = __riscv_vmadc_vv_u32m8_b4(var_33, var_34, 8);
// 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m2(7);
vbool4_t var_35 = __riscv_vmsgt_vv_i8m2_b4(var_38, var_39, 7);
// 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m2(27);
vbool4_t var_40 = __riscv_vmsgt_vv_i8m2_b4(var_44, var_45, 27);
// 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m2(8);
vuint32m2_t var_96 = __riscv_vminu_vx_u32m2(var_48, var_97, 8);
// 7, 7, 7, 7, 7, 7, 7, 7

__riscv_vsetvl_e32m8(27);
vbool4_t var_51 = __riscv_vmflt_vf_f32m8_b4(var_54, var_60, 27);
// 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool4_t var_50 = __riscv_vmadc_vv_i16m4_b4(var_55, var_56, 27);
// 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vuint16m4_t var_5 = __riscv_vfncvt_xu_f_w_u16m4(var_59, 27);
// 0, 0, 0, 65535, 0, 0, 0, 0, 0, 0, 65535, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e64m4(8);
vbool16_t var_18 = __riscv_vmfne_vv_f64m4_b16_mu(var_23, var_24, var_25, var_26, 8);
// 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m4(27);
vint32m8_t var_14 = __riscv_vwadd_wv_i32m8_mu(var_40, var_41, var_42, var_43, 27);
// 313413364, -1948452097, 826926175, 1638685938, 1757238205, -597790089, -1372364897, -445745737, 453225971, -1192514844, 1820280141, -377916957, -2016991146, -1553328455, 1352608927, 2006772863, -1471233923, 582742961, 1045648728, 1685555981, 200856309, 1099228261, 849122571, -144112029, -1911947830, -232214449, 1604618821

vbool4_t var_10 = __riscv_vmsgtu_vv_u16m4_b4_mu(var_50, var_51, var_52, var_53, 27);
// 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vse16_v_u16m4(var_102, var_5, 27);
__riscv_vsetvl_e32m2(8);
vint32m2_t var_13 = __riscv_vrgather_vv_i32m2_mu(var_18, var_46, var_47, var_96, 8);
// -745426821, -745426821, -745426821, -745426821, -745426821, -745426821, -745426821, -745426821

__riscv_vsetvl_e32m8(27);
vint32m8_t var_8 = __riscv_vnmsac_vv_i32m8(var_14, var_14, var_57, 27);
// -2027081268, 2038374285, 835816966, 571941488, 1256348605, -294772597, 1589114887, 825516748, -135335063, 1301584020, -2037799444, -225921582, 79406830, 2053551694, -1594486114, -1579456108, -1880175409, -1267374956, 358835760, -1563922971, -1498691798, 866810371, 1117911827, -1099222814, 1652710214, -1712490297, -35815463

__riscv_vsetvl_e32m8(8);
vint32m8_t var_9 = __riscv_vmul_vx_i32m8_mu(var_10, var_0, var_14, var_61, 8);
// -1219765796, -2080211897, 135958713, 799838302, 2039222333, 1836703841, -13757896, -1907880159, 631650388, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -1684874627, 718017706, 293684054, 207768905, -259297483, 1102076145, 69574056, -1099928980, 869454379, -1050337408

if(!check(var_102, var_116, var_117)) {cerr << "check 115 fails" << endl; return_value = 1;}
__riscv_vsetvl_e32m2(8);
vint32m2_t var_12 = __riscv_vneg_v_i32m2_mu(var_18, var_13, var_49, 8);
// -1777702579, -933403794, 574300082, 13421362, 1463117709, 367080915, -1435942936, 909349460

__riscv_vsetvl_e32m8(27);
int32_t var_4 = __riscv_vmv_x_s_i32m8_i32(var_8);
// -2027081268

__riscv_vsetvl_e32m8(8);
vuint32m8_t var_16 = __riscv_vreinterpret_v_i32m8_u32m8(var_9);
// 3075201500, 2214755399, 135958713, 799838302, 2039222333, 1836703841, 4281209400, 2387087137, 631650388, 2352259792, 2926026375, 2867405298, 2069013122, 362147503, 909383812, 2059147515, 1772484196, 2610092669, 718017706, 293684054, 207768905, 4035669813, 1102076145, 69574056, 3195038316, 869454379, 3244629888

__riscv_vsetvl_e32m2(8);
int32_t var_11 = __riscv_vmv_x_s_i32m2_i32(var_12);
// -1777702579

__riscv_vsetvl_e32m8(8);
vbool4_t var_19 = __riscv_vmsleu_vv_u32m8_b4(var_16, var_20, 8);
// 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m8(27);
vint32m8_t var_7 = __riscv_vmv_v_x_i32m8(var_11, 27);
// -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579

__riscv_vsetvl_e8m2(8);
__riscv_vse8_v_i8m2_m(var_19, var_94, var_22, 8);
__riscv_vsetvl_e32m8(27);
vint32m8_t var_3 = __riscv_vmax_vx_i32m8_mu(var_10, var_7, var_14, var_4, 27);
// -1777702579, -1777702579, 826926175, 1638685938, -1777702579, -597790089, -1777702579, -445745737, 453225971, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, -1777702579, 582742961, -1777702579, -1777702579, -1777702579, -1777702579, 849122571, -144112029, -1777702579, -1777702579, -1777702579

if(!check(var_94, var_104, var_105)) {cerr << "check 103 fails" << endl; return_value = 1;}
vint32m8_t var_2 = __riscv_vmadd_vv_i32m8(var_3, var_3, var_14, 27);
// -1274900451, 758201384, -1724825696, -862244426, 168924390, -1494178360, 1334288584, -1428996472, -421002596, 1514138637, 231966326, -1966230772, 689662335, 1153325026, -235704888, 418459048, 1235419558, 323712018, -542665087, 97242166, -1387457506, -489085554, 2060084100, 1053282476, 794705651, -1820528264, 16305006

vint32m8_t var_1 = __riscv_vmul_vv_i32m8_mu(var_10, var_0, var_2, var_2, 27);
// -1219765796, -2080211897, -1425005568, 1275800932, 2039222333, -1571066816, -13757896, -1015666624, 180801296, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -483634876, 718017706, 293684054, 207768905, -259297483, 50289680, 1702884240, -1099928980, 869454379, -1050337408

vint32m8_t var_6 = __riscv_vmv_s_x_i32m8_tu(var_1, var_62, 27);
// 1131231630, -2080211897, -1425005568, 1275800932, 2039222333, -1571066816, -13757896, -1015666624, 180801296, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -483634876, 718017706, 293684054, 207768905, -259297483, 50289680, 1702884240, -1099928980, 869454379, -1050337408

__riscv_vsetvl_e32m8(7);
vint32m8_t var_15 = __riscv_vneg_v_i32m8_mu(var_35, var_1, var_36, 7);
// 1482257973, -2080211897, -1425005568, -772921329, 2039222333, -1571066816, -188946235, -1015666624, 180801296, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -483634876, 718017706, 293684054, 207768905, -259297483, 50289680, 1702884240, -1099928980, 869454379, -1050337408

__riscv_vsetvl_e32m8(8);
vint32m8_t var_17 = __riscv_vnmsub_vv_i32m8_mu(var_29, var_1, var_30, var_31, 8);
// 813369075, 1204827914, 1528599370, 1275800932, -2129835614, -1571066816, -13757896, -2057974591, 180801296, -1942707504, -1368940921, -1427561998, 2069013122, 362147503, 909383812, 2059147515, 1772484196, -483634876, 718017706, 293684054, 207768905, -259297483, 50289680, 1702884240, -1099928980, 869454379, -1050337408

__riscv_vsetvl_e32m8(1);
__riscv_vse32_v_i32m8(var_64, var_6, 1);
__riscv_vsetvl_e32m8(7);
__riscv_vse32_v_i32m8(var_82, var_15, 7);
__riscv_vsetvl_e32m8(8);
__riscv_vse32_v_i32m8(var_86, var_17, 8);
if(!check(var_64, var_113, var_114)) {cerr << "check 112 fails" << endl; return_value = 1;}
if(!check(var_82, var_110, var_111)) {cerr << "check 109 fails" << endl; return_value = 1;}
if(!check(var_86, var_107, var_108)) {cerr << "check 106 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
