/* { dg-additional-options "-fdiagnostics-text-art-charset=unicode" } */
/* { dg-skip-if "" { powerpc-ibm-aix* } } */

#include <string.h>

#define LOREM_IPSUM \
  "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod" \
  " tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim" \
  " veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea" \
  " commodo consequat. Duis aute irure dolor in reprehenderit in voluptate" \
  " velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint" \
  " occaecat cupidatat non proident, sunt in culpa qui officia deserunt" \
  " mollit anim id est laborum."

void test (void)
{
  char buf[500];
  strcpy (buf, LOREM_IPSUM);
  strcat (buf, LOREM_IPSUM); /* { dg-warning "stack-based buffer overflow" } */
}

/* { dg-begin-multiline-output "" }

                                                   ┌─────┬───┬───┬───┬───┬───┬────────┬─────┬─────┬─────┬─────┬─────┬─────┐
                                                   │ [0] │[1]│[2]│[3]│[4]│[5]│        │[440]│[441]│[442]│[443]│[444]│[445]│
                                                   ├─────┼───┼───┼───┼───┼───┤  ...   ├─────┼─────┼─────┼─────┼─────┼─────┤
                                                   │ 'L' │'o'│'r'│'e'│'m'│' '│        │ 'o' │ 'r' │ 'u' │ 'm' │ '.' │ NUL │
                                                   ├─────┴───┴───┴───┴───┴───┴────────┴─────┴─────┴─────┴─────┴─────┴─────┤
                                                   │                  string literal (type: 'char[446]')                  │
                                                   └──────────────────────────────────────────────────────────────────────┘
                                                      │    │   │   │   │   │ │   │   │   │     │     │     │     │     │
                                                      │    │   │   │   │   │ │   │   │   │     │     │     │     │     │
                                                      v    v   v   v   v   v v   v   v   v     v     v     v     v     v
  ┌───┬────────────────────────────────────────────┬─────┬────────────────────┬─────┐┌────────────────────────────────────┐
  │[0]│                    ...                     │[445]│        ...         │[499]││                                    │
  ├───┼───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬┼─────┼────────────────────┴─────┘│                                    │
  │'L'│'o'│'r'│'e'│'m'│' '│...│'o'│'r'│'u'│'m'│'.'││ NUL │                           │         after valid range          │
  ├───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴┴─────┴──────────────────────────┐│                                    │
  │                            'buf' (type: 'char[500]')                            ││                                    │
  └─────────────────────────────────────────────────────────────────────────────────┘└────────────────────────────────────┘
  ├────────────────────────────────────────┬────────────────────────────────────────┤├─────────────────┬──────────────────┤
                                           │                                                           │
                                 ╭─────────┴─────────╮                                      ╭──────────┴──────────╮
                                 │capacity: 500 bytes│                                      │overflow of 391 bytes│
                                 ╰───────────────────╯                                      ╰─────────────────────╯

   { dg-end-multiline-output "" { target c } } */

/* { dg-begin-multiline-output "" }

                                                   ┌─────┬───┬───┬───┬───┬───┬────────┬─────┬─────┬─────┬─────┬─────┬─────┐
                                                   │ [0] │[1]│[2]│[3]│[4]│[5]│        │[440]│[441]│[442]│[443]│[444]│[445]│
                                                   ├─────┼───┼───┼───┼───┼───┤  ...   ├─────┼─────┼─────┼─────┼─────┼─────┤
                                                   │ 'L' │'o'│'r'│'e'│'m'│' '│        │ 'o' │ 'r' │ 'u' │ 'm' │ '.' │ NUL │
                                                   ├─────┴───┴───┴───┴───┴───┴────────┴─────┴─────┴─────┴─────┴─────┴─────┤
                                                   │               string literal (type: 'const char[446]')               │
                                                   └──────────────────────────────────────────────────────────────────────┘
                                                      │    │   │   │   │   │ │   │   │   │     │     │     │     │     │
                                                      │    │   │   │   │   │ │   │   │   │     │     │     │     │     │
                                                      v    v   v   v   v   v v   v   v   v     v     v     v     v     v
  ┌───┬────────────────────────────────────────────┬─────┬────────────────────┬─────┐┌────────────────────────────────────┐
  │[0]│                    ...                     │[445]│        ...         │[499]││                                    │
  ├───┼───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬┼─────┼────────────────────┴─────┘│                                    │
  │'L'│'o'│'r'│'e'│'m'│' '│...│'o'│'r'│'u'│'m'│'.'││ NUL │                           │         after valid range          │
  ├───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴───┴┴─────┴──────────────────────────┐│                                    │
  │                      'char buf [500]' (type: 'char[500]')                       ││                                    │
  └─────────────────────────────────────────────────────────────────────────────────┘└────────────────────────────────────┘
  ├────────────────────────────────────────┬────────────────────────────────────────┤├─────────────────┬──────────────────┤
                                           │                                                           │
                                 ╭─────────┴─────────╮                                      ╭──────────┴──────────╮
                                 │capacity: 500 bytes│                                      │overflow of 391 bytes│
                                 ╰───────────────────╯                                      ╰─────────────────────╯

   { dg-end-multiline-output "" { target c++ } } */
