; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes="attributor-cgscc,argpromotion" -S < %s | FileCheck %s --check-prefix=CGSCC

; This used to crash because the attributor-cgscc pass rewrote the
; flag_GetFlagValue function but did not clear the cached analysis for the
; deleted function. Argument promotion got an invalid cache entry for the
; dominator tree of list_Car and things exploded.

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i32 @clause_LiteralComputeWeight(ptr %call23) {
; CGSCC: Function Attrs: nofree noreturn nounwind
; CGSCC-LABEL: define {{[^@]+}}@clause_LiteralComputeWeight
; CGSCC-SAME: (ptr nofree nonnull readonly align 8 captures(none) dereferenceable(8) [[CALL23:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    br label [[DO_BODY:%.*]]
; CGSCC:       do.body:
; CGSCC-NEXT:    [[TERM_0:%.*]] = phi ptr [ null, [[ENTRY:%.*]] ], [ [[CALL24:%.*]], [[DO_BODY]] ]
; CGSCC-NEXT:    [[CALL2:%.*]] = load volatile i32, ptr [[TERM_0]], align 4
; CGSCC-NEXT:    [[CALL23_VAL:%.*]] = load ptr, ptr [[CALL23]], align 8
; CGSCC-NEXT:    [[CALL24]] = call ptr @list_Car(ptr nofree readonly [[CALL23_VAL]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    br label [[DO_BODY]]
;
entry:
  br label %do.body

do.body:                                          ; preds = %do.body, %entry
  %Term.0 = phi ptr [ null, %entry ], [ %call24, %do.body ]
  %call2 = load volatile i32, ptr %Term.0, align 4
  %call3 = call i32 @flag_GetFlagValue(ptr null)
  %call24 = call ptr @list_Car(ptr %call23)
  br label %do.body
}

define internal i32 @flag_GetFlagValue(ptr %Store) #1 {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@flag_GetFlagValue
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret i32 undef
;
entry:
  ret i32 0
}

define internal ptr @list_Car(ptr %L) #0 {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read)
; CGSCC-LABEL: define {{[^@]+}}@list_Car
; CGSCC-SAME: (ptr nofree [[L_0_VAL:%.*]]) #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret ptr [[L_0_VAL]]
;
entry:
  %0 = load ptr, ptr %L, align 8
  ret ptr %0
}
;.
; CGSCC: attributes #[[ATTR0]] = { nofree noreturn nounwind }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read) }
; CGSCC: attributes #[[ATTR3]] = { nofree }
;.
