; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve    < %s | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2p2 < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sve,+sme2p2 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+sme    -force-streaming < %s | FileCheck %s -check-prefixes=CHECK,STREAMING-SVE
; RUN: llc -mattr=+sme2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sme,+sve2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 8 x half> @test_svrinta_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrinta_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinta.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrinta_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrinta_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinta.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrinta_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrinta_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinta.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrinta_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrinta_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinta.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrinta_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrinta_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinta.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrinta_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrinta_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinta.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrinta_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrinta_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinta.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrinta_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrinta_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinta.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrinta_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrinta_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinta.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrinta_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrinta_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinta.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrinta_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrinta_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinta.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrinta_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrinta_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinta.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrinta_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrinta_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinta.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrinta_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrinta_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinta.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrinta_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrinta_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinta.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrinta_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrinta_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinta.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrinta_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrinta_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinta.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrinta_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrinta_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinta z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinta_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinta z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinta_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frinta z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinta.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrinti_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrinti_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinti.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrinti_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrinti_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinti.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrinti_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrinti_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinti.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrinti_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrinti_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinti.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrinti_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrinti_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinti.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrinti_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrinti_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinti.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrinti_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrinti_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinti.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrinti_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrinti_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinti.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrinti_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrinti_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinti.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrinti_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrinti_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinti.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrinti_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrinti_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinti.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrinti_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrinti_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinti.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrinti_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrinti_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinti.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrinti_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrinti_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinti.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrinti_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrinti_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinti.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrinti_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrinti_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinti.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrinti_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrinti_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinti.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}


define <vscale x 2 x double> @test_svrinti_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrinti_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frinti z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrinti_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frinti z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrinti_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frinti z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinti.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svrintm_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintm_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintm.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintm_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintm_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintm.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}


define <vscale x 8 x half> @test_svrintm_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrintm_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintm.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrintm_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintm_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintm.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintm_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintm_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintm.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintm_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrintm_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintm.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrintm_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintm_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintm.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintm_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintm_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintm.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintm_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrintm_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintm.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrintm_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintm_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintm.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintm_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintm_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintm.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintm_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrintm_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintm.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrintm_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintm_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintm.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintm_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintm_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintm.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintm_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrintm_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintm.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrintm_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintm_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintm.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintm_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintm_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintm.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintm_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrintm_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintm z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintm_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintm z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintm_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frintm z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintm.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrintn_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintn_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintn.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintn_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintn_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintn.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintn_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrintn_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintn.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrintn_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintn_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintn.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintn_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintn_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintn.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintn_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrintn_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintn.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrintn_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintn_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintn.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintn_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintn_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintn.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintn_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrintn_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintn.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrintn_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintn_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintn.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintn_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintn_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintn.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintn_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrintn_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintn.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrintn_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintn_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintn.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintn_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintn_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintn.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintn_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrintn_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintn.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrintn_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintn_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintn.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintn_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintn_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintn.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintn_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrintn_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintn z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintn_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintn z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintn_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frintn z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintn.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrintp_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintp_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintp.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintp_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintp_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintp.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintp_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrintp_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintp.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrintp_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintp_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintp.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintp_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintp_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintp.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintp_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrintp_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintp.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrintp_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintp_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintp.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintp_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintp_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintp.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintp_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrintp_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintp.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrintp_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintp_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintp.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintp_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintp_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintp.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintp_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrintp_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintp.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrintp_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintp_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintp.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintp_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintp_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintp.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintp_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrintp_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintp.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrintp_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintp_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintp.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintp_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintp_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintp.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}


define <vscale x 2 x double> @test_svrintp_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrintp_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintp z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintp_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintp z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintp_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frintp z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintp.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrintx_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintx_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintx.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintx_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintx_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintx.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintx_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrintx_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintx.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrintx_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintx_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintx.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintx_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintx_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintx.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintx_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrintx_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintx.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrintx_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintx_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintx.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintx_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintx_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintx.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintx_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrintx_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintx.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrintx_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintx_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintx.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintx_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintx_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintx.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintx_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrintx_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintx.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrintx_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintx_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintx.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintx_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintx_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintx.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintx_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrintx_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintx.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrintx_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintx_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintx.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintx_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintx_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintx.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintx_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrintx_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintx z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintx_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintx_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frintx z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintx.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrintz_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintz_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintz.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintz_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrintz_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintz.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrintz_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrintz_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintz.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrintz_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintz_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintz.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintz_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrintz_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintz.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrintz_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrintz_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintz.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrintz_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintz_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintz.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintz_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrintz_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintz.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrintz_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrintz_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintz.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrintz_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintz_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintz.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintz_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrintz_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintz.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrintz_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrintz_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintz.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrintz_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintz_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintz.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintz_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrintz_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintz.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrintz_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrintz_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintz.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrintz_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintz_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintz.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintz_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrintz_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintz.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrintz_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrintz_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frintz z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrintz_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frintz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrintz_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frintz z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintz.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svrecpx_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrecpx_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frecpx.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrecpx_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svrecpx_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frecpx.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svrecpx_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svrecpx_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frecpx.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svrecpx_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrecpx_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frecpx.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrecpx_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svrecpx_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frecpx.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svrecpx_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svrecpx_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frecpx.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svrecpx_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrecpx_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frecpx.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrecpx_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svrecpx_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frecpx.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svrecpx_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svrecpx_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frecpx.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svrecpx_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrecpx_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frecpx.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrecpx_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svrecpx_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frecpx.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svrecpx_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svrecpx_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frecpx.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svrecpx_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrecpx_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frecpx.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrecpx_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svrecpx_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frecpx.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svrecpx_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svrecpx_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frecpx.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svrecpx_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrecpx_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frecpx z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frecpx.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrecpx_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svrecpx_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frecpx.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svrecpx_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svrecpx_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    frecpx z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpx_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    frecpx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpx_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    frecpx z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frecpx.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svsqrt_f16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svsqrt_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fsqrt.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svsqrt_f16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svsqrt_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fsqrt.nxv8f16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svsqrt_f16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svsqrt_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fsqrt.nxv8f16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x half> @test_svsqrt_4f16_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svsqrt_4f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_4f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.fsqrt.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svsqrt_4f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svsqrt_4f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_4f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.fsqrt.nxv4f16(<vscale x 4 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svsqrt_4f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x half> %x) {
; SVE-LABEL: test_svsqrt_4f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_4f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_4f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.fsqrt.nxv4f16(<vscale x 4 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 2 x half> @test_svsqrt_2f16_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svsqrt_2f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.fsqrt.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svsqrt_2f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svsqrt_2f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.fsqrt.nxv2f16(<vscale x 2 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svsqrt_2f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x half> %x) {
; SVE-LABEL: test_svsqrt_2f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_2f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.fsqrt.nxv2f16(<vscale x 2 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x float> @test_svsqrt_2f32_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svsqrt_2f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.fsqrt.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svsqrt_2f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svsqrt_2f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.fsqrt.nxv2f32(<vscale x 2 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svsqrt_2f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x float> %x) {
; SVE-LABEL: test_svsqrt_2f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_2f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_2f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.fsqrt.nxv2f32(<vscale x 2 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 4 x float> @test_svsqrt_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svsqrt_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fsqrt.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svsqrt_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svsqrt_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fsqrt.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svsqrt_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svsqrt_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fsqrt.nxv4f32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svsqrt_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svsqrt_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fsqrt.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svsqrt_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svsqrt_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fsqrt.nxv2f64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svsqrt_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svsqrt_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fsqrt z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqrt_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fsqrt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svsqrt_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    fsqrt z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fsqrt.nxv2f64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svfrinta_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrinta_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinta.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrinta_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrinta_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinta.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrinta_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrinta_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinta.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrinta_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrinta_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinta.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrinta_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrinta_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinta.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrinta_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrinta_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinta.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrinta_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrinta_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinta.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrinta_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrinta_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinta.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrinta_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrinta_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinta.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrinta_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrinta_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinta z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinta.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrinta_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrinta_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinta z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinta.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrinta_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrinta_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinta z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinta_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinta z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinta.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrinti_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrinti_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinti.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrinti_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrinti_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frinti.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrinti_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrinti_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinti.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrinti_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrinti_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frinti.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrinti_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrinti_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinti.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrinti_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrinti_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frinti.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrinti_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrinti_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinti.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrinti_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrinti_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frinti.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrinti_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrinti_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinti.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrinti_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrinti_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frinti z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frinti.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrinti_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrinti_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frinti z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinti.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrinti_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrinti_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frinti z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrinti_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frinti z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frinti.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrintm_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrintm_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintm.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrintm_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrintm_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintm.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrintm_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrintm_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintm.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrintm_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrintm_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintm.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrintm_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrintm_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintm.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrintm_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrintm_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintm.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrintm_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrintm_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintm.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrintm_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrintm_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintm.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrintm_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrintm_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintm.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrintm_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrintm_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintm z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintm.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrintm_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrintm_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintm z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintm.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrintm_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrintm_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintm z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintm_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintm z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintm.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrintn_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrintn_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintn.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrintn_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrintn_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintn.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrintn_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrintn_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintn.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrintn_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrintn_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintn.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrintn_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrintn_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintn.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrintn_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrintn_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintn.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrintn_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrintn_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintn.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrintn_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrintn_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintn.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrintn_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrintn_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintn.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrintn_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrintn_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintn z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintn.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrintn_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrintn_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintn z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintn.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrintn_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrintn_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintn z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintn_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintn z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintn.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrintp_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrintp_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintp.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrintp_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrintp_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintp.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrintp_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrintp_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintp.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrintp_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrintp_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintp.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrintp_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrintp_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintp.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrintp_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrintp_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintp.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrintp_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrintp_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintp.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrintp_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrintp_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintp.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrintp_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrintp_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintp.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrintp_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrintp_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintp z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintp.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrintp_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrintp_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintp z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintp.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrintp_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrintp_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintp z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintp_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintp z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintp.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrintx_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrintx_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintx.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrintx_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrintx_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintx.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrintx_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrintx_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintx.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrintx_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrintx_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintx.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrintx_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrintx_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintx.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrintx_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrintx_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintx.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrintx_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrintx_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintx.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrintx_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrintx_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintx.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrintx_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrintx_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintx.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrintx_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrintx_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintx z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintx.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrintx_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrintx_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintx z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintx.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrintx_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrintx_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintx z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintx_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintx z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintx.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrintz_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrintz_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintz.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrintz_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrintz_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frintz.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrintz_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrintz_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintz.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrintz_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrintz_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frintz.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrintz_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrintz_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintz.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrintz_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrintz_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frintz.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrintz_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrintz_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintz.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrintz_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrintz_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frintz.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrintz_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrintz_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintz.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrintz_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrintz_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frintz z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frintz.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrintz_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrintz_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frintz z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintz.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrintz_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrintz_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frintz z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrintz_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frintz z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frintz.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfrecpx_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfrecpx_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frecpx.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfrecpx_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfrecpx_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.frecpx.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfrecpx_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfrecpx_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frecpx.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfrecpx_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfrecpx_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.frecpx.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfrecpx_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfrecpx_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frecpx.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfrecpx_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfrecpx_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.frecpx.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfrecpx_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfrecpx_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frecpx.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfrecpx_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfrecpx_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.frecpx.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfrecpx_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfrecpx_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frecpx.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfrecpx_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfrecpx_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    frecpx z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.frecpx.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfrecpx_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfrecpx_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    frecpx z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frecpx.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfrecpx_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfrecpx_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    frecpx z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfrecpx_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    frecpx z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.frecpx.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}


define <vscale x 8 x half> @test_svfsqrt_nxv8f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svfsqrt_nxv8f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv8f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fsqrt.nxv8f16(<vscale x 8 x half> poison,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svfsqrt_nxv8f16_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: test_svfsqrt_nxv8f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv8f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fsqrt.nxv8f16(<vscale x 8 x half> %x,  <vscale x 8 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 8 x half> %0
}


define <vscale x 4 x half> @test_svfsqrt_nxv4f16_ptrue_u(double %z0, <vscale x 4 x half> %x) {
; CHECK-LABEL: test_svfsqrt_nxv4f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv4f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.fsqrt.nxv4f16(<vscale x 4 x half> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %x)
  ret <vscale x 4 x half> %0
}

define <vscale x 4 x half> @test_svfsqrt_nxv4f16_ptrue(double %z0, <vscale x 4 x half> %x, <vscale x 4 x half> %y) {
; CHECK-LABEL: test_svfsqrt_nxv4f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv4f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x half> @llvm.aarch64.sve.fsqrt.nxv4f16(<vscale x 4 x half> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x half> %y)
  ret <vscale x 4 x half> %0
}


define <vscale x 2 x half> @test_svfsqrt_nxv2f16_ptrue_u(double %z0, <vscale x 2 x half> %x) {
; CHECK-LABEL: test_svfsqrt_nxv2f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.fsqrt.nxv2f16(<vscale x 2 x half> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %x)
  ret <vscale x 2 x half> %0
}

define <vscale x 2 x half> @test_svfsqrt_nxv2f16_ptrue(double %z0, <vscale x 2 x half> %x, <vscale x 2 x half> %y) {
; CHECK-LABEL: test_svfsqrt_nxv2f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x half> @llvm.aarch64.sve.fsqrt.nxv2f16(<vscale x 2 x half> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x half> %y)
  ret <vscale x 2 x half> %0
}


define <vscale x 2 x float> @test_svfsqrt_nxv2f32_ptrue_u(double %z0, <vscale x 2 x float> %x) {
; CHECK-LABEL: test_svfsqrt_nxv2f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.fsqrt.nxv2f32(<vscale x 2 x float> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %x)
  ret <vscale x 2 x float> %0
}

define <vscale x 2 x float> @test_svfsqrt_nxv2f32_ptrue(double %z0, <vscale x 2 x float> %x, <vscale x 2 x float> %y) {
; CHECK-LABEL: test_svfsqrt_nxv2f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x float> @llvm.aarch64.sve.fsqrt.nxv2f32(<vscale x 2 x float> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x float> %y)
  ret <vscale x 2 x float> %0
}


define <vscale x 4 x float> @test_svfsqrt_nxv4f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svfsqrt_nxv4f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv4f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fsqrt.nxv4f32(<vscale x 4 x float> poison,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svfsqrt_nxv4f32_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: test_svfsqrt_nxv4f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv4f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fsqrt z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fsqrt.nxv4f32(<vscale x 4 x float> %x,  <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 4 x float> %0
}


define <vscale x 2 x double> @test_svfsqrt_nxv2f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svfsqrt_nxv2f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fsqrt z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fsqrt.nxv2f64(<vscale x 2 x double> poison,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svfsqrt_nxv2f64_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 2 x double> %y) {
; CHECK-LABEL: test_svfsqrt_nxv2f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fsqrt z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svfsqrt_nxv2f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fsqrt z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call  <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fsqrt.nxv2f64(<vscale x 2 x double> %x,  <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 2 x double> %0
}

