// This file is generated by kconfig_compiler_kf5 from knetwalk.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Settings : public KConfigSkeleton
{
  public:

    static Settings *self();
    ~Settings();

    /**
      Set Default user name
    */
    static
    void setUsername( const QString & v )
    {
      if (!self()->isImmutable( QStringLiteral( "username" ) ))
        self()->mUsername = v;
    }

    /**
      Get Default user name
    */
    static
    QString username()
    {
      return self()->mUsername;
    }

    /**
      Set Whether game sounds are played.
    */
    static
    void setPlaySounds( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "PlaySounds" ) ))
        self()->mPlaySounds = v;
    }

    /**
      Get Whether game sounds are played.
    */
    static
    bool playSounds()
    {
      return self()->mPlaySounds;
    }

    /**
      Set Whether lock cell after rotation.
    */
    static
    void setAutolock( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "Autolock" ) ))
        self()->mAutolock = v;
    }

    /**
      Get Whether lock cell after rotation.
    */
    static
    bool autolock()
    {
      return self()->mAutolock;
    }

    /**
      Set Duration for cell to complete one rotation.
    */
    static
    void setRotateDuration( int v )
    {
      if (v < 100)
      {
        qDebug() << "setRotateDuration: value " << v << " is less than the minimum value of 100";
        v = 100;
      }

      if (v > 500)
      {
        qDebug() << "setRotateDuration: value " << v << " is greater than the maximum value of 500";
        v = 500;
      }

      if (!self()->isImmutable( QStringLiteral( "RotateDuration" ) ))
        self()->mRotateDuration = v;
    }

    /**
      Get Duration for cell to complete one rotation.
    */
    static
    int rotateDuration()
    {
      return self()->mRotateDuration;
    }

    /**
      Set The width of the board.
    */
    static
    void setWidth( int v )
    {
      if (v < 3)
      {
        qDebug() << "setWidth: value " << v << " is less than the minimum value of 3";
        v = 3;
      }

      if (v > 11)
      {
        qDebug() << "setWidth: value " << v << " is greater than the maximum value of 11";
        v = 11;
      }

      if (!self()->isImmutable( QStringLiteral( "Width" ) ))
        self()->mWidth = v;
    }

    /**
      Get The width of the board.
    */
    static
    int width()
    {
      return self()->mWidth;
    }

    /**
      Set The height of the board.
    */
    static
    void setHeight( int v )
    {
      if (v < 3)
      {
        qDebug() << "setHeight: value " << v << " is less than the minimum value of 3";
        v = 3;
      }

      if (v > 11)
      {
        qDebug() << "setHeight: value " << v << " is greater than the maximum value of 11";
        v = 11;
      }

      if (!self()->isImmutable( QStringLiteral( "Height" ) ))
        self()->mHeight = v;
    }

    /**
      Get The height of the board.
    */
    static
    int height()
    {
      return self()->mHeight;
    }

    /**
      Set Whether wrap from left to right and from top to bottom is enabled.
    */
    static
    void setWrapping( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "Wrapping" ) ))
        self()->mWrapping = v;
    }

    /**
      Get Whether wrap from left to right and from top to bottom is enabled.
    */
    static
    bool wrapping()
    {
      return self()->mWrapping;
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // Preferences
    QString mUsername;

    // General
    bool mPlaySounds;
    bool mAutolock;
    int mRotateDuration;

    // Custom
    int mWidth;
    int mHeight;
    bool mWrapping;

  private:
};

#endif

