; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=x86_64 -mattr=+cf -passes='simplifycfg<hoist-loads-stores-with-cond-faulting>' -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefixes=CHECK,LOADSTORE
; RUN: opt < %s -mtriple=x86_64 -mattr=+cf -passes='simplifycfg<hoist-loads-stores-with-cond-faulting>' -simplifycfg-require-and-preserve-domtree=1 -simplifycfg-hoist-loads-with-cond-faulting=false -S | FileCheck %s --check-prefixes=CHECK,NONE,STOREONLY
; RUN: opt < %s -mtriple=x86_64 -mattr=+cf -passes='simplifycfg<hoist-loads-stores-with-cond-faulting>' -simplifycfg-require-and-preserve-domtree=1 -simplifycfg-hoist-stores-with-cond-faulting=false -S | FileCheck %s --check-prefixes=CHECK,NONE,LOADONLY
; RUN: opt < %s -mtriple=x86_64 -mattr=+cf -passes='simplifycfg<hoist-loads-stores-with-cond-faulting>' -simplifycfg-require-and-preserve-domtree=1 -simplifycfg-hoist-stores-with-cond-faulting=false -simplifycfg-hoist-loads-with-cond-faulting=false -S | FileCheck %s --check-prefixes=CHECK,NONE,NONEONLY

;; Basic case: check masked.load/store is generated for i16/i32/i64.
define void @basic(i1 %cond, ptr %b, ptr %p, ptr %q) {
; LOADSTORE-LABEL: @basic(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP1:%.*]] = call <1 x i16> @llvm.masked.load.v1i16.p0(ptr [[P:%.*]], i32 2, <1 x i1> [[TMP0]], <1 x i16> poison)
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i16> [[TMP1]] to i16
; LOADSTORE-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[Q:%.*]], i32 4, <1 x i1> [[TMP0]], <1 x i32> poison)
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADSTORE-NEXT:    [[TMP5:%.*]] = call <1 x i64> @llvm.masked.load.v1i64.p0(ptr [[B:%.*]], i32 8, <1 x i1> [[TMP0]], <1 x i64> poison)
; LOADSTORE-NEXT:    [[TMP6:%.*]] = bitcast <1 x i64> [[TMP5]] to i64
; LOADSTORE-NEXT:    [[TMP7:%.*]] = bitcast i16 [[TMP2]] to <1 x i16>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i16.p0(<1 x i16> [[TMP7]], ptr [[B]], i32 2, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    [[TMP8:%.*]] = bitcast i32 [[TMP4]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP8]], ptr [[P]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    [[TMP9:%.*]] = bitcast i64 [[TMP6]] to <1 x i64>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i64.p0(<1 x i64> [[TMP9]], ptr [[Q]], i32 8, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    ret void
;
; NONE-LABEL: @basic(
; NONE-NEXT:  entry:
; NONE-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_END:%.*]]
; NONE:       if.true:
; NONE-NEXT:    [[TMP0:%.*]] = load i16, ptr [[P:%.*]], align 2
; NONE-NEXT:    [[TMP1:%.*]] = load i32, ptr [[Q:%.*]], align 4
; NONE-NEXT:    [[TMP2:%.*]] = load i64, ptr [[B:%.*]], align 8
; NONE-NEXT:    store i16 [[TMP0]], ptr [[B]], align 2
; NONE-NEXT:    store i32 [[TMP1]], ptr [[P]], align 4
; NONE-NEXT:    store i64 [[TMP2]], ptr [[Q]], align 8
; NONE-NEXT:    br label [[IF_END]]
; NONE:       if.end:
; NONE-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.false:
  br label %if.end

if.true:
  %0 = load i16, ptr %p, align 2
  %1 = load i32, ptr %q, align 4
  %2 = load i64, ptr %b, align 8
  store i16 %0, ptr %b, align 2
  store i32 %1, ptr %p, align 4
  store i64 %2, ptr %q, align 8
  br label %if.false

if.end:
  ret void
}

;; Successor 1 branches to successor 0.
define void @succ1to0(ptr %p, ptr %q, i32 %a) {
; LOADSTORE-LABEL: @succ1to0(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[TOBOOL]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[Q:%.*]], i32 4, <1 x i1> [[TMP1]], <1 x i32> poison)
; LOADSTORE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast i32 [[TMP3]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP4]], ptr [[P:%.*]], i32 4, <1 x i1> [[TMP1]])
; LOADSTORE-NEXT:    ret void
;
; NONE-LABEL: @succ1to0(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; NONE-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; NONE:       if.end:
; NONE-NEXT:    ret void
; NONE:       if.then:
; NONE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; NONE-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; NONE-NEXT:    br label [[IF_END]]
;
entry:
  %tobool = icmp ne i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then

if.end:
  ret void

if.then:
  %0 = load i32, ptr %q
  store i32 %0, ptr %p
  br label %if.end
}

;; Successor 1 branches to successor 0 and there is a phi node.
define i32 @succ1to0_phi(ptr %p)  {
; LOADSTORE-LABEL: @succ1to0_phi(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[P]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADSTORE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADSTORE-NEXT:    ret i32 [[TMP3]]
;
; STOREONLY-LABEL: @succ1to0_phi(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; STOREONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; STOREONLY:       if.false:
; STOREONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[P]], align 4
; STOREONLY-NEXT:    br label [[IF_TRUE]]
; STOREONLY:       if.true:
; STOREONLY-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; STOREONLY-NEXT:    ret i32 [[RES]]
;
; LOADONLY-LABEL: @succ1to0_phi(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADONLY-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADONLY-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADONLY-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[P]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADONLY-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADONLY-NEXT:    ret i32 [[TMP3]]
;
; NONEONLY-LABEL: @succ1to0_phi(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; NONEONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[P]], align 4
; NONEONLY-NEXT:    br label [[IF_TRUE]]
; NONEONLY:       if.true:
; NONEONLY-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; NONEONLY-NEXT:    ret i32 [[RES]]
;
entry:
  %cond = icmp eq ptr %p, null
  br i1 %cond, label %if.true, label %if.false

if.false:
  %0 = load i32, ptr %p
  br label %if.true

if.true:
  %res = phi i32 [ %0, %if.false ], [ 0, %entry ]
  ret i32 %res
}

;; Successor 0 branches to successor 1.
define void @succ0to1(i32 %a, ptr %b, ptr %p, ptr %q) {
; LOADSTORE-LABEL: @succ0to1(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP1:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[B:%.*]], i32 4, <1 x i1> [[TMP0]], <1 x i32> poison)
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i32> [[TMP1]] to i32
; LOADSTORE-NEXT:    [[TMP3:%.*]] = bitcast i32 [[TMP2]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP3]], ptr [[P:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; LOADSTORE-NEXT:    ret void
;
; NONE-LABEL: @succ0to1(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; NONE-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONE:       if.false:
; NONE-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; NONE-NEXT:    ret void
; NONE:       if.true:
; NONE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[B:%.*]], align 4
; NONE-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; NONE-NEXT:    br label [[IF_FALSE]]
;
entry:
  %cond = icmp eq i32 %a, 0
  br i1 %cond, label %if.true, label %if.false

if.false:
  store i32 1, ptr %q
  br label %if.end

if.true:
  %0 = load i32, ptr %b
  store i32 %0, ptr %p
  br label %if.false

if.end:
  ret void
}

;; Load after store can be hoisted.
define i64 @load_after_store(i32 %a, ptr %b, ptr %p) {
; LOADSTORE-LABEL: @load_after_store(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND]] to <1 x i1>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 1), ptr [[B:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    [[TMP1:%.*]] = call <1 x i16> @llvm.masked.load.v1i16.p0(ptr [[P:%.*]], i32 2, <1 x i1> [[TMP0]], <1 x i16> poison)
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i16> [[TMP1]] to i16
; LOADSTORE-NEXT:    [[ZEXT:%.*]] = zext i16 [[TMP2]] to i64
; LOADSTORE-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND]], i64 [[ZEXT]], i64 0
; LOADSTORE-NEXT:    ret i64 [[SPEC_SELECT]]
;
; NONE-LABEL: @load_after_store(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; NONE-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[COMMON_RET:%.*]]
; NONE:       common.ret:
; NONE-NEXT:    [[COMMON_RET_OP:%.*]] = phi i64 [ [[ZEXT:%.*]], [[IF_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; NONE-NEXT:    ret i64 [[COMMON_RET_OP]]
; NONE:       if.true:
; NONE-NEXT:    store i32 1, ptr [[B:%.*]], align 4
; NONE-NEXT:    [[TMP0:%.*]] = load i16, ptr [[P:%.*]], align 2
; NONE-NEXT:    [[ZEXT]] = zext i16 [[TMP0]] to i64
; NONE-NEXT:    br label [[COMMON_RET]]
;
entry:
  %cond = icmp eq i32 %a, 0
  br i1 %cond, label %if.true, label %if.end

if.true:
  store i32 1, ptr %b
  %0 = load i16, ptr %p
  %zext = zext i16 %0 to i64
  ret i64 %zext

if.end:
  ret i64 0
}

;; Speculatable memory read doesn't prevent the hoist.
define void @load_skip_speculatable_memory_read(i32 %a, ptr %p, ptr %q) {
; LOADSTORE-LABEL: @load_skip_speculatable_memory_read(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    [[READ:%.*]] = call i32 @read_memory_only()
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i32 [[READ]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP1]], ptr [[P:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; LOADSTORE-NEXT:    ret void
;
; STOREONLY-LABEL: @load_skip_speculatable_memory_read(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; STOREONLY-NEXT:    [[READ:%.*]] = call i32 @read_memory_only()
; STOREONLY-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND]] to <1 x i1>
; STOREONLY-NEXT:    [[TMP1:%.*]] = bitcast i32 [[READ]] to <1 x i32>
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP1]], ptr [[P:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; STOREONLY-NEXT:    ret void
;
; LOADONLY-LABEL: @load_skip_speculatable_memory_read(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; LOADONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; LOADONLY:       if.false:
; LOADONLY-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; LOADONLY-NEXT:    ret void
; LOADONLY:       if.true:
; LOADONLY-NEXT:    [[READ:%.*]] = call i32 @read_memory_only()
; LOADONLY-NEXT:    store i32 [[READ]], ptr [[P:%.*]], align 4
; LOADONLY-NEXT:    br label [[IF_FALSE]]
;
; NONEONLY-LABEL: @load_skip_speculatable_memory_read(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; NONEONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; NONEONLY-NEXT:    ret void
; NONEONLY:       if.true:
; NONEONLY-NEXT:    [[READ:%.*]] = call i32 @read_memory_only()
; NONEONLY-NEXT:    store i32 [[READ]], ptr [[P:%.*]], align 4
; NONEONLY-NEXT:    br label [[IF_FALSE]]
;
entry:
  %cond = icmp eq i32 %a, 0
  br i1 %cond, label %if.true, label %if.false

if.false:
  store i32 1, ptr %q
  br label %if.end

if.true:
  %read = call i32 @read_memory_only()
  store i32 %read, ptr %p
  br label %if.false

if.end:
  ret void
}

;; Source of the load can be a GEP.
define i32 @load_from_gep(ptr %p)  {
; LOADSTORE-LABEL: @load_from_gep(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADSTORE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 16
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[ARRAYIDX]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADSTORE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADSTORE-NEXT:    ret i32 [[TMP3]]
;
; STOREONLY-LABEL: @load_from_gep(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; STOREONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; STOREONLY:       if.false:
; STOREONLY-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 16
; STOREONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; STOREONLY-NEXT:    br label [[IF_TRUE]]
; STOREONLY:       if.true:
; STOREONLY-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; STOREONLY-NEXT:    ret i32 [[RES]]
;
; LOADONLY-LABEL: @load_from_gep(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADONLY-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 16
; LOADONLY-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADONLY-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADONLY-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[ARRAYIDX]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADONLY-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADONLY-NEXT:    ret i32 [[TMP3]]
;
; NONEONLY-LABEL: @load_from_gep(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; NONEONLY-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 16
; NONEONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; NONEONLY-NEXT:    br label [[IF_TRUE]]
; NONEONLY:       if.true:
; NONEONLY-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; NONEONLY-NEXT:    ret i32 [[RES]]
;
entry:
  %cond = icmp eq ptr %p, null
  br i1 %cond, label %if.true, label %if.false

if.false:
  %arrayidx = getelementptr inbounds i8, ptr %p, i64 16
  %0 = load i32, ptr %arrayidx
  br label %if.true

if.true:
  %res = phi i32 [ %0, %if.false ], [ 0, %entry ]
  ret i32 %res
}

;; Metadata range/annotation are kept.
define void @nondebug_metadata(i1 %cond, ptr %p, ptr %q) {
; LOADSTORE-LABEL: @nondebug_metadata(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP1:%.*]] = call range(i16 0, 10) <1 x i16> @llvm.masked.load.v1i16.p0(ptr [[P:%.*]], i32 2, <1 x i1> [[TMP0]], <1 x i16> poison)
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i16> [[TMP1]] to i16
; LOADSTORE-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[Q:%.*]], i32 4, <1 x i1> [[TMP0]], <1 x i32> poison), !annotation [[META5:![0-9]+]]
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADSTORE-NEXT:    [[TMP5:%.*]] = bitcast i16 [[TMP2]] to <1 x i16>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i16.p0(<1 x i16> [[TMP5]], ptr [[Q]], i32 4, <1 x i1> [[TMP0]]), !annotation [[META5]]
; LOADSTORE-NEXT:    [[TMP6:%.*]] = bitcast i32 [[TMP4]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP6]], ptr [[P]], i32 2, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    ret void
;
; NONE-LABEL: @nondebug_metadata(
; NONE-NEXT:  entry:
; NONE-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONE:       if.false:
; NONE-NEXT:    ret void
; NONE:       if.true:
; NONE-NEXT:    [[TMP0:%.*]] = load i16, ptr [[P:%.*]], align 2, !range [[RNG5:![0-9]+]]
; NONE-NEXT:    [[TMP1:%.*]] = load i32, ptr [[Q:%.*]], align 4, !annotation [[META6:![0-9]+]]
; NONE-NEXT:    store i16 [[TMP0]], ptr [[Q]], align 4, !annotation [[META6]]
; NONE-NEXT:    store i32 [[TMP1]], ptr [[P]], align 2
; NONE-NEXT:    br label [[IF_FALSE]]
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.false:
  ret void

if.true:
  %0 = load i16, ptr %p, align 2, !range !{i16 0, i16 10}
  %1 = load i32, ptr %q, align 4, !annotation !11
  store i16 %0, ptr %q, align 4, !annotation !11
  store i32 %1, ptr %p, align 2
  br label %if.false
}

define i16 @debug_metadata_diassign(i1 %cond, i16 %a, ptr %p) {
; LOADSTORE-LABEL: @debug_metadata_diassign(
; LOADSTORE-NEXT:  bb0:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i16.p0(<1 x i16> splat (i16 7), ptr [[P:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND]], i16 3, i16 2
; LOADSTORE-NEXT:    ret i16 [[SPEC_SELECT]]
;
; STOREONLY-LABEL: @debug_metadata_diassign(
; STOREONLY-NEXT:  bb0:
; STOREONLY-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i16.p0(<1 x i16> splat (i16 7), ptr [[P:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND]], i16 3, i16 2
; STOREONLY-NEXT:    ret i16 [[SPEC_SELECT]]
;
; LOADONLY-LABEL: @debug_metadata_diassign(
; LOADONLY-NEXT:  bb0:
; LOADONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; LOADONLY:       if.true:
; LOADONLY-NEXT:    store i16 7, ptr [[P:%.*]], align 4, !DIAssignID [[DIASSIGNID7:![0-9]+]]
; LOADONLY-NEXT:    br label [[IF_FALSE]]
; LOADONLY:       if.false:
; LOADONLY-NEXT:    [[RET:%.*]] = phi i16 [ 2, [[BB0:%.*]] ], [ 3, [[IF_TRUE]] ]
; LOADONLY-NEXT:      #dbg_assign(i16 [[RET]], [[META8:![0-9]+]], !DIExpression(), [[DIASSIGNID7]], ptr [[P]], !DIExpression(), [[META11:![0-9]+]])
; LOADONLY-NEXT:    ret i16 [[RET]]
;
; NONEONLY-LABEL: @debug_metadata_diassign(
; NONEONLY-NEXT:  bb0:
; NONEONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.true:
; NONEONLY-NEXT:    store i16 7, ptr [[P:%.*]], align 4, !DIAssignID [[DIASSIGNID7:![0-9]+]]
; NONEONLY-NEXT:    br label [[IF_FALSE]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    [[RET:%.*]] = phi i16 [ 2, [[BB0:%.*]] ], [ 3, [[IF_TRUE]] ]
; NONEONLY-NEXT:      #dbg_assign(i16 [[RET]], [[META8:![0-9]+]], !DIExpression(), [[DIASSIGNID7]], ptr [[P]], !DIExpression(), [[META11:![0-9]+]])
; NONEONLY-NEXT:    ret i16 [[RET]]
;
bb0:
  br i1 %cond, label %if.true, label %if.false

if.true:
  store i16 7, ptr %p, align 4, !DIAssignID !9
  br label %if.false

if.false:
  %ret = phi i16 [ 2, %bb0 ], [ 3, %if.true ]
  call void @llvm.dbg.assign(metadata i16 %ret, metadata !8, metadata !DIExpression(), metadata !9, metadata ptr %p, metadata !DIExpression()), !dbg !7
  ret i16 %ret
}

;; Not crash when working with opt controlled by simplifycfg-hoist-cond-stores.
define i32 @hoist_cond_stores(i1 %cond, ptr %p) {
; LOADSTORE-LABEL: @hoist_cond_stores(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    store i1 false, ptr [[P:%.*]], align 2
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    [[SPEC_STORE_SELECT:%.*]] = select i1 [[COND]], i1 false, i1 false
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> zeroinitializer, ptr [[P]], i32 8, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    store i1 [[SPEC_STORE_SELECT]], ptr [[P]], align 2
; LOADSTORE-NEXT:    ret i32 0
;
; STOREONLY-LABEL: @hoist_cond_stores(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    store i1 false, ptr [[P:%.*]], align 2
; STOREONLY-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; STOREONLY-NEXT:    [[SPEC_STORE_SELECT:%.*]] = select i1 [[COND]], i1 false, i1 false
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> zeroinitializer, ptr [[P]], i32 8, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    store i1 [[SPEC_STORE_SELECT]], ptr [[P]], align 2
; STOREONLY-NEXT:    ret i32 0
;
; LOADONLY-LABEL: @hoist_cond_stores(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    store i1 false, ptr [[P:%.*]], align 2
; LOADONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; LOADONLY:       if.true:
; LOADONLY-NEXT:    store i32 0, ptr [[P]], align 8
; LOADONLY-NEXT:    store i1 false, ptr [[P]], align 2
; LOADONLY-NEXT:    br label [[IF_FALSE]]
; LOADONLY:       if.false:
; LOADONLY-NEXT:    ret i32 0
;
; NONEONLY-LABEL: @hoist_cond_stores(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    store i1 false, ptr [[P:%.*]], align 2
; NONEONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.true:
; NONEONLY-NEXT:    store i32 0, ptr [[P]], align 8
; NONEONLY-NEXT:    store i1 false, ptr [[P]], align 2
; NONEONLY-NEXT:    br label [[IF_FALSE]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    ret i32 0
;
entry:
  store i1 false, ptr %p, align 2
  br i1 %cond, label %if.true, label %if.false

if.true:                            ; preds = %entry
  store i32 0, ptr %p, align 8
  store i1 false, ptr %p, align 2
  br label %if.false

if.false:                                    ; preds = %if.true, %entry
  ret i32 0
}

;; Both of successor 0 and successor 1 have a single predecessor.
define i32 @single_predecessor(ptr %p, ptr %q, i32 %a) {
; LOADSTORE-LABEL: @single_predecessor(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[TOBOOL]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast i1 [[TOBOOL]] to <1 x i1>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 1), ptr [[Q:%.*]], i32 4, <1 x i1> [[TMP2]])
; LOADSTORE-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[Q]], i32 4, <1 x i1> [[TMP1]], <1 x i32> poison)
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP3]], ptr [[P:%.*]], i32 4, <1 x i1> [[TMP1]])
; LOADSTORE-NEXT:    [[DOT:%.*]] = select i1 [[TOBOOL]], i32 2, i32 3
; LOADSTORE-NEXT:    ret i32 [[DOT]]
;
; NONE-LABEL: @single_predecessor(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; NONE-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; NONE:       common.ret:
; NONE-NEXT:    [[COMMON_RET_OP:%.*]] = phi i32 [ 2, [[IF_END]] ], [ 3, [[IF_THEN]] ]
; NONE-NEXT:    ret i32 [[COMMON_RET_OP]]
; NONE:       if.end:
; NONE-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; NONE-NEXT:    br label [[COMMON_RET:%.*]]
; NONE:       if.then:
; NONE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q]], align 4
; NONE-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; NONE-NEXT:    br label [[COMMON_RET]]
;
entry:
  %tobool = icmp ne i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then

if.end:
  store i32 1, ptr %q
  ret i32 2

if.then:
  %0 = load i32, ptr %q
  store i32 %0, ptr %p
  ret i32 3
}

;; Hoist 6 stores.
define void @threshold_6(i1 %cond, ptr %p1, ptr %p2, ptr %p3, ptr %p4, ptr %p5, ptr %p6) {
; LOADSTORE-LABEL: @threshold_6(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 1), ptr [[P1:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 2), ptr [[P2:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 3), ptr [[P3:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 4), ptr [[P4:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 5), ptr [[P5:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 6), ptr [[P6:%.*]], i32 4, <1 x i1> [[TMP0]])
; LOADSTORE-NEXT:    ret void
;
; STOREONLY-LABEL: @threshold_6(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND:%.*]] to <1 x i1>
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 1), ptr [[P1:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 2), ptr [[P2:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 3), ptr [[P3:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 4), ptr [[P4:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 5), ptr [[P5:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> splat (i32 6), ptr [[P6:%.*]], i32 4, <1 x i1> [[TMP0]])
; STOREONLY-NEXT:    ret void
;
; LOADONLY-LABEL: @threshold_6(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; LOADONLY:       if.true:
; LOADONLY-NEXT:    store i32 1, ptr [[P1:%.*]], align 4
; LOADONLY-NEXT:    store i32 2, ptr [[P2:%.*]], align 4
; LOADONLY-NEXT:    store i32 3, ptr [[P3:%.*]], align 4
; LOADONLY-NEXT:    store i32 4, ptr [[P4:%.*]], align 4
; LOADONLY-NEXT:    store i32 5, ptr [[P5:%.*]], align 4
; LOADONLY-NEXT:    store i32 6, ptr [[P6:%.*]], align 4
; LOADONLY-NEXT:    br label [[IF_FALSE]]
; LOADONLY:       if.false:
; LOADONLY-NEXT:    ret void
;
; NONEONLY-LABEL: @threshold_6(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONEONLY:       if.true:
; NONEONLY-NEXT:    store i32 1, ptr [[P1:%.*]], align 4
; NONEONLY-NEXT:    store i32 2, ptr [[P2:%.*]], align 4
; NONEONLY-NEXT:    store i32 3, ptr [[P3:%.*]], align 4
; NONEONLY-NEXT:    store i32 4, ptr [[P4:%.*]], align 4
; NONEONLY-NEXT:    store i32 5, ptr [[P5:%.*]], align 4
; NONEONLY-NEXT:    store i32 6, ptr [[P6:%.*]], align 4
; NONEONLY-NEXT:    br label [[IF_FALSE]]
; NONEONLY:       if.false:
; NONEONLY-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.true:
  store i32 1, ptr %p1, align 4
  store i32 2, ptr %p2, align 4
  store i32 3, ptr %p3, align 4
  store i32 4, ptr %p4, align 4
  store i32 5, ptr %p5, align 4
  store i32 6, ptr %p6, align 4
  br label %if.false

if.false:
  ret void
}

;; Not hoist 7 stores.
define void @threshold_7(i1 %cond, ptr %p1, ptr %p2, ptr %p3, ptr %p4, ptr %p5, ptr %p6, ptr %p7) {
; CHECK-LABEL: @threshold_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    store i32 1, ptr [[P1:%.*]], align 4
; CHECK-NEXT:    store i32 2, ptr [[P2:%.*]], align 4
; CHECK-NEXT:    store i32 3, ptr [[P3:%.*]], align 4
; CHECK-NEXT:    store i32 4, ptr [[P4:%.*]], align 4
; CHECK-NEXT:    store i32 5, ptr [[P5:%.*]], align 4
; CHECK-NEXT:    store i32 6, ptr [[P6:%.*]], align 4
; CHECK-NEXT:    store i32 7, ptr [[P7:%.*]], align 4
; CHECK-NEXT:    br label [[IF_FALSE]]
; CHECK:       if.false:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.true:
  store i32 1, ptr %p1, align 4
  store i32 2, ptr %p2, align 4
  store i32 3, ptr %p3, align 4
  store i32 4, ptr %p4, align 4
  store i32 5, ptr %p5, align 4
  store i32 6, ptr %p6, align 4
  store i32 7, ptr %p7, align 4
  br label %if.false

if.false:
  ret void
}

;; Not do hoist if the cost of instructions to be hoisted is expensive.
define i32 @not_cheap_to_hoist(i32 %a, ptr %b, ptr %p, ptr %q, i32 %v0, i32 %v1, i32 %v2, i1 %cc) {
; CHECK-LABEL: @not_cheap_to_hoist(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       common.ret:
; CHECK-NEXT:    [[COMMON_RET_OP:%.*]] = phi i32 [ [[VVVV:%.*]], [[IF_FALSE]] ], [ 0, [[IF_TRUE]] ]
; CHECK-NEXT:    ret i32 [[COMMON_RET_OP]]
; CHECK:       if.false:
; CHECK-NEXT:    store i64 1, ptr [[P:%.*]], align 8
; CHECK-NEXT:    store i16 2, ptr [[Q:%.*]], align 2
; CHECK-NEXT:    [[V:%.*]] = udiv i32 [[A]], 12345
; CHECK-NEXT:    [[VV:%.*]] = mul i32 [[V]], [[V0:%.*]]
; CHECK-NEXT:    [[VVV:%.*]] = mul i32 [[VV]], [[V1:%.*]]
; CHECK-NEXT:    [[VVVV]] = select i1 [[CC:%.*]], i32 [[V2:%.*]], i32 [[VVV]]
; CHECK-NEXT:    br label [[COMMON_RET:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[P]], align 4
; CHECK-NEXT:    br label [[COMMON_RET]]
;
entry:
  %cond = icmp eq i32 %a, 0
  br i1 %cond, label %if.true, label %if.false

if.false:
  store i64 1, ptr %p
  store i16 2, ptr %q

  %v = udiv i32 %a, 12345
  %vv = mul i32 %v, %v0
  %vvv = mul i32 %vv, %v1
  %vvvv = select i1 %cc, i32 %v2, i32 %vvv
  ret i32 %vvvv

if.true:
  %0 = load i32, ptr %b
  store i32 %0, ptr %p
  br label %if.end

if.end:
  ret i32 0
}

;; Not hoist if there is more than 1 prodecessor.
define void @not_single_predecessor(ptr %p, ptr %q, i32 %a) {
; CHECK-LABEL: @not_single_predecessor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    br label [[IF_THEN]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
;
entry:
  %tobool = icmp ne i32 %a, 0
  br i1 %tobool, label %if.end, label %if.then

if.end:
  br label %if.then

if.then:
  %1 = load i32, ptr %q
  store i32 %1, ptr %p
  br label %if.end
}

;; Not hoist b/c i8 is not supported by conditional faulting.
define void @not_supported_type(i8 %a, ptr %b, ptr %p, ptr %q) {
; CHECK-LABEL: @not_supported_type(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i8 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.false:
; CHECK-NEXT:    store i8 1, ptr [[Q:%.*]], align 1
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[B:%.*]], align 1
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %cond = icmp eq i8 %a, 0
  br i1 %cond, label %if.true, label %if.false

if.false:
  store i8 1, ptr %q
  br label %if.end

if.true:
  %0 = load i8, ptr %b
  store i8 %0, ptr %p
  br label %if.end

if.end:
  ret void
}

;; Not hoist if the terminator is not br.
define void @not_br_terminator(i32 %a, ptr %b, ptr %p, ptr %q) {
; CHECK-LABEL: @not_br_terminator(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[A:%.*]], label [[IF_END:%.*]] [
; CHECK-NEXT:      i32 1, label [[IF_FALSE:%.*]]
; CHECK-NEXT:      i32 2, label [[IF_TRUE:%.*]]
; CHECK-NEXT:    ]
; CHECK:       if.false:
; CHECK-NEXT:    store i32 1, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.true:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    br label [[IF_FALSE]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  switch i32 %a, label %if.end [
  i32 1, label %if.false
  i32 2, label %if.true
  ]

if.false:
  store i32 1, ptr %q, align 4
  br label %if.end

if.true:
  %0 = load i32, ptr %b, align 4
  store i32 %0, ptr %p, align 4
  br label %if.false

if.end:
  ret void
}

;; Not hoist if the instruction to be hoist is atomic.
define void @not_atomic(i1 %cond, ptr %p) {
; CHECK-LABEL: @not_atomic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.false:
; CHECK-NEXT:    store atomic i32 1, ptr [[P:%.*]] seq_cst, align 4
; CHECK-NEXT:    br label [[IF_TRUE]]
; CHECK:       if.true:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.false:
  store atomic i32 1, ptr %p seq_cst, align 4
  br label %if.true

if.true:
  ret void
}

;; Not hoist if the instruction to be hoist is volatile.
define void @not_volatile(i1 %cond, ptr %p) {
; CHECK-LABEL: @not_volatile(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.false:
; CHECK-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    br label [[IF_TRUE]]
; CHECK:       if.true:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.false:
  %0 = load volatile i32, ptr %p, align 4
  br label %if.true

if.true:
  ret void
}

;; Not hoist if there is an instruction that has side effect in the same bb.
define void @not_hoistable_sideeffect(i1 %cond, ptr %p, ptr %q) {
; CHECK-LABEL: @not_hoistable_sideeffect(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.false:
; CHECK-NEXT:    [[RMW:%.*]] = atomicrmw xchg ptr [[Q:%.*]], double 4.000000e+00 seq_cst, align 8
; CHECK-NEXT:    store i32 1, ptr [[P:%.*]], align 4
; CHECK-NEXT:    br label [[IF_TRUE]]
; CHECK:       if.true:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.false:
  %rmw= atomicrmw xchg ptr %q, double 4.0 seq_cst
  store i32 1, ptr %p, align 4
  br label %if.true

if.true:
  ret void
}

;; Not hoist if the branch is predictable and the `then` BB is not likely to execute.
define void @not_likely_to_execute(ptr %p, ptr %q, i32 %a) {
; LOADSTORE-LABEL: @not_likely_to_execute(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; LOADSTORE-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]], !prof [[PROF6:![0-9]+]]
; LOADSTORE:       if.end:
; LOADSTORE-NEXT:    ret void
; LOADSTORE:       if.then:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; LOADSTORE-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; LOADSTORE-NEXT:    br label [[IF_END]]
;
; STOREONLY-LABEL: @not_likely_to_execute(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; STOREONLY-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]], !prof [[PROF7:![0-9]+]]
; STOREONLY:       if.end:
; STOREONLY-NEXT:    ret void
; STOREONLY:       if.then:
; STOREONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; STOREONLY-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; STOREONLY-NEXT:    br label [[IF_END]]
;
; LOADONLY-LABEL: @not_likely_to_execute(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; LOADONLY-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]], !prof [[PROF12:![0-9]+]]
; LOADONLY:       if.end:
; LOADONLY-NEXT:    ret void
; LOADONLY:       if.then:
; LOADONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; LOADONLY-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; LOADONLY-NEXT:    br label [[IF_END]]
;
; NONEONLY-LABEL: @not_likely_to_execute(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[A:%.*]], 0
; NONEONLY-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]], !prof [[PROF12:![0-9]+]]
; NONEONLY:       if.end:
; NONEONLY-NEXT:    ret void
; NONEONLY:       if.then:
; NONEONLY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Q:%.*]], align 4
; NONEONLY-NEXT:    store i32 [[TMP0]], ptr [[P:%.*]], align 4
; NONEONLY-NEXT:    br label [[IF_END]]
;
entry:
  %tobool = icmp ne i32 %a, 0
  br i1 %tobool, label %if.then, label %if.end, !prof !10

if.end:
  ret void

if.then:
  %0 = load i32, ptr %q
  store i32 %0, ptr %p
  br label %if.end
}

;; Now the optimization hoist-loads-stores-with-cond-faulting is run in codegen,
;; which is after sroa and alloca is optimized away. So we don't need to do the transform
;; for this case. But in the future, it is probably moved before sroa.
define void @not_alloca(ptr %p, ptr %q, i32 %a) {
; CHECK-LABEL: @not_alloca(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    [[Q_ADDR:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store ptr [[P:%.*]], ptr [[P_ADDR]], align 8
; CHECK-NEXT:    store ptr [[Q:%.*]], ptr [[Q_ADDR]], align 8
; CHECK-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[Q_ADDR]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[P_ADDR]], align 8
; CHECK-NEXT:    store i32 [[TMP2]], ptr [[TMP3]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %p.addr = alloca ptr
  %q.addr = alloca ptr
  %a.addr = alloca i32
  store ptr %p, ptr %p.addr
  store ptr %q, ptr %q.addr
  store i32 %a, ptr %a.addr
  %0 = load i32, ptr %a.addr
  %tobool = icmp ne i32 %0, 0
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %1 = load ptr, ptr %q.addr
  %2 = load i32, ptr %1
  %3 = load ptr, ptr %p.addr
  store i32 %2, ptr %3
  br label %if.end

if.end:
  ret void
}

;; Not transform if alignment = 2^32.
define void @not_maximum_alignment(i1 %cond, ptr %p) {
; CHECK-LABEL: @not_maximum_alignment(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    store i32 0, ptr [[P:%.*]], align 4294967296
; CHECK-NEXT:    br label [[IF_FALSE]]
; CHECK:       if.false:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if.true, label %if.false

if.true:
  store i32 0, ptr %p, align 4294967296
  br label %if.false

if.false:
  ret void
}

define i32 @succ_phi_has_3input(i1 %cond1, ptr %p, i1 %cond2) {
; LOADSTORE-LABEL: @succ_phi_has_3input(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    br i1 [[COND1:%.*]], label [[BB3:%.*]], label [[BB1:%.*]]
; LOADSTORE:       bb1:
; LOADSTORE-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND2:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP1:%.*]] = call <1 x i64> @llvm.masked.load.v1i64.p0(ptr [[P:%.*]], i32 8, <1 x i1> [[TMP0]], <1 x i64> zeroinitializer)
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i64> [[TMP1]] to i64
; LOADSTORE-NEXT:    br label [[BB3]]
; LOADSTORE:       bb3:
; LOADSTORE-NEXT:    [[Y:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[TMP2]], [[BB1]] ]
; LOADSTORE-NEXT:    store i64 [[Y]], ptr [[P]], align 8
; LOADSTORE-NEXT:    ret i32 0
;
; STOREONLY-LABEL: @succ_phi_has_3input(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    [[COND2_NOT:%.*]] = xor i1 [[COND2:%.*]], true
; STOREONLY-NEXT:    [[BRMERGE:%.*]] = select i1 [[COND1:%.*]], i1 true, i1 [[COND2_NOT]]
; STOREONLY-NEXT:    br i1 [[BRMERGE]], label [[BB3:%.*]], label [[BB2:%.*]]
; STOREONLY:       bb2:
; STOREONLY-NEXT:    [[X:%.*]] = load i64, ptr [[P:%.*]], align 8
; STOREONLY-NEXT:    br label [[BB3]]
; STOREONLY:       bb3:
; STOREONLY-NEXT:    [[Y:%.*]] = phi i64 [ [[X]], [[BB2]] ], [ 0, [[ENTRY:%.*]] ]
; STOREONLY-NEXT:    store i64 [[Y]], ptr [[P]], align 8
; STOREONLY-NEXT:    ret i32 0
;
; LOADONLY-LABEL: @succ_phi_has_3input(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    br i1 [[COND1:%.*]], label [[BB3:%.*]], label [[BB1:%.*]]
; LOADONLY:       bb1:
; LOADONLY-NEXT:    [[TMP0:%.*]] = bitcast i1 [[COND2:%.*]] to <1 x i1>
; LOADONLY-NEXT:    [[TMP1:%.*]] = call <1 x i64> @llvm.masked.load.v1i64.p0(ptr [[P:%.*]], i32 8, <1 x i1> [[TMP0]], <1 x i64> zeroinitializer)
; LOADONLY-NEXT:    [[TMP2:%.*]] = bitcast <1 x i64> [[TMP1]] to i64
; LOADONLY-NEXT:    br label [[BB3]]
; LOADONLY:       bb3:
; LOADONLY-NEXT:    [[Y:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[TMP2]], [[BB1]] ]
; LOADONLY-NEXT:    store i64 [[Y]], ptr [[P]], align 8
; LOADONLY-NEXT:    ret i32 0
;
; NONEONLY-LABEL: @succ_phi_has_3input(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    [[COND2_NOT:%.*]] = xor i1 [[COND2:%.*]], true
; NONEONLY-NEXT:    [[BRMERGE:%.*]] = select i1 [[COND1:%.*]], i1 true, i1 [[COND2_NOT]]
; NONEONLY-NEXT:    br i1 [[BRMERGE]], label [[BB3:%.*]], label [[BB2:%.*]]
; NONEONLY:       bb2:
; NONEONLY-NEXT:    [[X:%.*]] = load i64, ptr [[P:%.*]], align 8
; NONEONLY-NEXT:    br label [[BB3]]
; NONEONLY:       bb3:
; NONEONLY-NEXT:    [[Y:%.*]] = phi i64 [ [[X]], [[BB2]] ], [ 0, [[ENTRY:%.*]] ]
; NONEONLY-NEXT:    store i64 [[Y]], ptr [[P]], align 8
; NONEONLY-NEXT:    ret i32 0
;
entry:
  br i1 %cond1, label %bb3, label %bb1

bb1:                                                ; preds = %entry
  br i1 %cond2, label %bb2, label %bb3

bb2:                                                ; preds = %bb1
  %x = load i64, ptr %p, align 8
  br label %bb3

bb3:                                                ; preds = %bb2, %bb1, %entry
  %y = phi i64 [ %x, %bb2 ], [ 0, %bb1 ], [ 0, %entry ]
  store i64 %y, ptr %p, align 8
  ret i32 0
}

define i32 @succ1to0_phi2(ptr %p, ptr %p2) {
; LOADSTORE-LABEL: @succ1to0_phi2(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[P]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADSTORE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i32> [[TMP2]] to i32
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast i32 [[TMP3]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP4]], ptr [[P2:%.*]], i32 4, <1 x i1> [[TMP1]])
; LOADSTORE-NEXT:    ret i32 [[TMP3]]
;
; NONE-LABEL: @succ1to0_phi2(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; NONE-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONE:       if.false:
; NONE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[P]], align 4
; NONE-NEXT:    store i32 [[TMP0]], ptr [[P2:%.*]], align 4
; NONE-NEXT:    br label [[IF_TRUE]]
; NONE:       if.true:
; NONE-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; NONE-NEXT:    ret i32 [[RES]]
;
entry:
  %cond = icmp eq ptr %p, null
  br i1 %cond, label %if.true, label %if.false

if.false:
  %0 = load i32, ptr %p
  store i32 %0, ptr %p2
  br label %if.true

if.true:
  %res = phi i32 [ %0, %if.false ], [ 0, %entry ]
  ret i32 %res
}

define i32 @succ1to0_phi3(ptr %p, ptr %p2, i32 %x) {
; LOADSTORE-LABEL: @succ1to0_phi3(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; LOADSTORE-NEXT:    [[TMP0:%.*]] = xor i1 [[COND]], true
; LOADSTORE-NEXT:    [[TMP1:%.*]] = bitcast i1 [[TMP0]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast i32 [[X:%.*]] to <1 x i32>
; LOADSTORE-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[P]], i32 4, <1 x i1> [[TMP1]], <1 x i32> zeroinitializer)
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADSTORE-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP5]], ptr [[P2:%.*]], i32 4, <1 x i1> [[TMP1]])
; LOADSTORE-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND]], i32 [[X]], i32 [[TMP4]]
; LOADSTORE-NEXT:    [[RES:%.*]] = add i32 [[TMP4]], [[SPEC_SELECT]]
; LOADSTORE-NEXT:    ret i32 [[RES]]
;
; NONE-LABEL: @succ1to0_phi3(
; NONE-NEXT:  entry:
; NONE-NEXT:    [[COND:%.*]] = icmp eq ptr [[P:%.*]], null
; NONE-NEXT:    br i1 [[COND]], label [[IF_TRUE:%.*]], label [[IF_FALSE:%.*]]
; NONE:       if.false:
; NONE-NEXT:    [[TMP0:%.*]] = load i32, ptr [[P]], align 4
; NONE-NEXT:    store i32 [[TMP0]], ptr [[P2:%.*]], align 4
; NONE-NEXT:    br label [[IF_TRUE]]
; NONE:       if.true:
; NONE-NEXT:    [[RES0:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ 0, [[ENTRY:%.*]] ]
; NONE-NEXT:    [[RES1:%.*]] = phi i32 [ [[TMP0]], [[IF_FALSE]] ], [ [[X:%.*]], [[ENTRY]] ]
; NONE-NEXT:    [[RES:%.*]] = add i32 [[RES0]], [[RES1]]
; NONE-NEXT:    ret i32 [[RES]]
;
entry:
  %cond = icmp eq ptr %p, null
  br i1 %cond, label %if.true, label %if.false

if.false:
  %0 = load i32, ptr %p
  store i32 %0, ptr %p2
  br label %if.true

if.true:
  %res0 = phi i32 [ %0, %if.false ], [ 0, %entry ]
  %res1 = phi i32 [ %0, %if.false ], [ %x, %entry ]
  %res = add i32 %res0, %res1
  ret i32 %res
}

;; Not transform if either BB has multiple successors.
define i32 @not_multi_successors(i1 %c1, i32 %c2, ptr %p) {
; CHECK-LABEL: @not_multi_successors(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[ENTRY_IF:%.*]], label [[COMMON_RET:%.*]]
; CHECK:       entry.if:
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    switch i32 [[C2:%.*]], label [[COMMON_RET]] [
; CHECK-NEXT:      i32 0, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 1, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       common.ret:
; CHECK-NEXT:    [[COMMON_RET_OP:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[VAL]], [[ENTRY_IF]] ], [ 0, [[SW_BB]] ]
; CHECK-NEXT:    ret i32 [[COMMON_RET_OP]]
; CHECK:       sw.bb:
; CHECK-NEXT:    br label [[COMMON_RET]]
;
entry:
  br i1 %c1, label %entry.if, label %entry.else

entry.if:                                         ; preds = %entry
  %val = load i32, ptr %p, align 4
  switch i32 %c2, label %return [
  i32 0, label %sw.bb
  i32 1, label %sw.bb
  ]

entry.else:                                       ; preds = %entry
  ret i32 0

sw.bb:                                            ; preds = %entry.if, %entry.if
  br label %return

return:                                           ; preds = %sw.bb, %entry.if
  %ret = phi i32 [ %val, %entry.if ], [ 0, %sw.bb ]
  ret i32 %ret
}

;; Check cond-faulting-load can work with hoisted store when no cond-faulting-store.
define void @hoist_store_without_cstore(ptr %0, ptr %1, i1 %cmp) {
; LOADSTORE-LABEL: @hoist_store_without_cstore(
; LOADSTORE-NEXT:  entry:
; LOADSTORE-NEXT:    store i32 0, ptr [[TMP1:%.*]], align 8
; LOADSTORE-NEXT:    [[TMP2:%.*]] = bitcast i1 [[CMP:%.*]] to <1 x i1>
; LOADSTORE-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[TMP0:%.*]], i32 4, <1 x i1> [[TMP2]], <1 x i32> poison)
; LOADSTORE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADSTORE-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to <1 x i32>
; LOADSTORE-NEXT:    call void @llvm.masked.store.v1i32.p0(<1 x i32> [[TMP5]], ptr [[TMP1]], i32 8, <1 x i1> [[TMP2]])
; LOADSTORE-NEXT:    ret void
;
; STOREONLY-LABEL: @hoist_store_without_cstore(
; STOREONLY-NEXT:  entry:
; STOREONLY-NEXT:    store i32 0, ptr [[TMP1:%.*]], align 8
; STOREONLY-NEXT:    br i1 [[CMP:%.*]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; STOREONLY:       if.then1:
; STOREONLY-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0:%.*]], align 4
; STOREONLY-NEXT:    store i32 [[TMP2]], ptr [[TMP1]], align 8
; STOREONLY-NEXT:    br label [[IF_END]]
; STOREONLY:       if.end:
; STOREONLY-NEXT:    ret void
;
; LOADONLY-LABEL: @hoist_store_without_cstore(
; LOADONLY-NEXT:  entry:
; LOADONLY-NEXT:    store i32 0, ptr [[TMP1:%.*]], align 8
; LOADONLY-NEXT:    [[TMP2:%.*]] = bitcast i1 [[CMP:%.*]] to <1 x i1>
; LOADONLY-NEXT:    [[TMP3:%.*]] = call <1 x i32> @llvm.masked.load.v1i32.p0(ptr [[TMP0:%.*]], i32 4, <1 x i1> [[TMP2]], <1 x i32> poison)
; LOADONLY-NEXT:    [[TMP4:%.*]] = bitcast <1 x i32> [[TMP3]] to i32
; LOADONLY-NEXT:    [[SPEC_STORE_SELECT:%.*]] = select i1 [[CMP]], i32 [[TMP4]], i32 0
; LOADONLY-NEXT:    store i32 [[SPEC_STORE_SELECT]], ptr [[TMP1]], align 8
; LOADONLY-NEXT:    ret void
;
; NONEONLY-LABEL: @hoist_store_without_cstore(
; NONEONLY-NEXT:  entry:
; NONEONLY-NEXT:    store i32 0, ptr [[TMP1:%.*]], align 8
; NONEONLY-NEXT:    br i1 [[CMP:%.*]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; NONEONLY:       if.then1:
; NONEONLY-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP0:%.*]], align 4
; NONEONLY-NEXT:    store i32 [[TMP2]], ptr [[TMP1]], align 8
; NONEONLY-NEXT:    br label [[IF_END]]
; NONEONLY:       if.end:
; NONEONLY-NEXT:    ret void
;
entry:
  store i32 0, ptr %1, align 8
  br i1 %cmp, label %if.then1, label %if.end

if.then1:                                         ; preds = %entry
  %2 = load i32, ptr %0, align 4
  store i32 %2, ptr %1, align 8
  br label %if.end

if.end:                                           ; preds = %if.then1, %entry
  ret void
}

declare i32 @read_memory_only() readonly nounwind willreturn speculatable

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!2, !3}
!llvm.ident = !{!4}

!0 = distinct !DICompileUnit(language: DW_LANG_C, file: !1, producer: "clang")
!1 = !DIFile(filename: "foo.c", directory: "/tmp")
!2 = !{i32 2, !"Dwarf Version", i32 4}
!3 = !{i32 2, !"Debug Info Version", i32 3}
!4 = !{!"clang"}
!5 = !DIBasicType(name: "int", size: 16, encoding: DW_ATE_signed)
!6 = distinct !DISubprogram(name: "foo", scope: !1, file: !1, line: 4, unit: !0)
!7 = !DILocation(line: 5, column: 7, scope: !6)
!8 = !DILocalVariable(name: "a", scope: !6, line: 6, type: !5)
!9 = distinct !DIAssignID()
!10 = !{!"branch_weights", i32 1, i32 99}
!11 = !{ !"auto-init" }
