// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --sort --version 5
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -show-encoding %s | FileCheck --check-prefix=GFX11 --implicit-check-not=_e32 %s

v_ceil_f16 v128, 0xfe0b
// GFX11: v_ceil_f16_e64 v128, 0xfe0b             ; encoding: [0x80,0x00,0xdc,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_ceil_f16 v255, -1
// GFX11: v_ceil_f16_e64 v255, -1                 ; encoding: [0xff,0x00,0xdc,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f16 v255, 0.5
// GFX11: v_ceil_f16_e64 v255, 0.5                ; encoding: [0xff,0x00,0xdc,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f16 v255, exec_hi
// GFX11: v_ceil_f16_e64 v255, exec_hi            ; encoding: [0xff,0x00,0xdc,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f16 v255, exec_lo
// GFX11: v_ceil_f16_e64 v255, exec_lo            ; encoding: [0xff,0x00,0xdc,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f16 v255, m0
// GFX11: v_ceil_f16_e64 v255, m0                 ; encoding: [0xff,0x00,0xdc,0xd5,0x7d,0x00,0x00,0x00]

v_ceil_f16 v255, null
// GFX11: v_ceil_f16_e64 v255, null               ; encoding: [0xff,0x00,0xdc,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f16 v255, s1
// GFX11: v_ceil_f16_e64 v255, s1                 ; encoding: [0xff,0x00,0xdc,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f16 v255, s105
// GFX11: v_ceil_f16_e64 v255, s105               ; encoding: [0xff,0x00,0xdc,0xd5,0x69,0x00,0x00,0x00]

v_ceil_f16 v255, src_scc
// GFX11: v_ceil_f16_e64 v255, src_scc            ; encoding: [0xff,0x00,0xdc,0xd5,0xfd,0x00,0x00,0x00]

v_ceil_f16 v255, ttmp15
// GFX11: v_ceil_f16_e64 v255, ttmp15             ; encoding: [0xff,0x00,0xdc,0xd5,0x7b,0x00,0x00,0x00]

v_ceil_f16 v255, v1
// GFX11: v_ceil_f16_e64 v255, v1                 ; encoding: [0xff,0x00,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdc,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_ceil_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f16 v255, v127
// GFX11: v_ceil_f16_e64 v255, v127               ; encoding: [0xff,0x00,0xdc,0xd5,0x7f,0x01,0x00,0x00]

v_ceil_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdc,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_ceil_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_ceil_f16 v255, vcc_hi
// GFX11: v_ceil_f16_e64 v255, vcc_hi             ; encoding: [0xff,0x00,0xdc,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f16 v255, vcc_lo
// GFX11: v_ceil_f16_e64 v255, vcc_lo             ; encoding: [0xff,0x00,0xdc,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f16 v5, v199
// GFX11: v_ceil_f16_e64 v5, v199                 ; encoding: [0x05,0x00,0xdc,0xd5,0xc7,0x01,0x00,0x00]

v_ceil_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xdc,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_ceil_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_ceil_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cos_f16 v128, 0xfe0b
// GFX11: v_cos_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xe1,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cos_f16 v255, -1
// GFX11: v_cos_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xe1,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f16 v255, 0.5
// GFX11: v_cos_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xe1,0xd5,0xf0,0x00,0x00,0x00]

v_cos_f16 v255, exec_hi
// GFX11: v_cos_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xe1,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f16 v255, exec_lo
// GFX11: v_cos_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xe1,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f16 v255, m0
// GFX11: v_cos_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xe1,0xd5,0x7d,0x00,0x00,0x00]

v_cos_f16 v255, null
// GFX11: v_cos_f16_e64 v255, null                ; encoding: [0xff,0x00,0xe1,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f16 v255, s1
// GFX11: v_cos_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xe1,0xd5,0x01,0x00,0x00,0x00]

v_cos_f16 v255, s105
// GFX11: v_cos_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xe1,0xd5,0x69,0x00,0x00,0x00]

v_cos_f16 v255, src_scc
// GFX11: v_cos_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xe1,0xd5,0xfd,0x00,0x00,0x00]

v_cos_f16 v255, ttmp15
// GFX11: v_cos_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xe1,0xd5,0x7b,0x00,0x00,0x00]

v_cos_f16 v255, v1
// GFX11: v_cos_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe1,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cos_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f16 v255, v127
// GFX11: v_cos_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xe1,0xd5,0x7f,0x01,0x00,0x00]

v_cos_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe1,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cos_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cos_f16 v255, vcc_hi
// GFX11: v_cos_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xe1,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f16 v255, vcc_lo
// GFX11: v_cos_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xe1,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f16 v5, v199
// GFX11: v_cos_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xe1,0xd5,0xc7,0x01,0x00,0x00]

v_cos_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xe1,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cos_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cos_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_f16_f32 v128, 0xaf123456
// GFX11: v_cvt_f16_f32_e64 v128, 0xaf123456      ; encoding: [0x80,0x00,0x8a,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v255, -1
// GFX11: v_cvt_f16_f32_e64 v255, -1              ; encoding: [0xff,0x00,0x8a,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32 v255, 0.5
// GFX11: v_cvt_f16_f32_e64 v255, 0.5             ; encoding: [0xff,0x00,0x8a,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32 v255, exec_hi
// GFX11: v_cvt_f16_f32_e64 v255, exec_hi         ; encoding: [0xff,0x00,0x8a,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32 v255, exec_lo
// GFX11: v_cvt_f16_f32_e64 v255, exec_lo         ; encoding: [0xff,0x00,0x8a,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32 v255, m0
// GFX11: v_cvt_f16_f32_e64 v255, m0              ; encoding: [0xff,0x00,0x8a,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_f32 v255, null
// GFX11: v_cvt_f16_f32_e64 v255, null            ; encoding: [0xff,0x00,0x8a,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32 v255, s1
// GFX11: v_cvt_f16_f32_e64 v255, s1              ; encoding: [0xff,0x00,0x8a,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_f32 v255, s105
// GFX11: v_cvt_f16_f32_e64 v255, s105            ; encoding: [0xff,0x00,0x8a,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_f32 v255, src_scc
// GFX11: v_cvt_f16_f32_e64 v255, src_scc         ; encoding: [0xff,0x00,0x8a,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_f16_f32 v255, ttmp15
// GFX11: v_cvt_f16_f32_e64 v255, ttmp15          ; encoding: [0xff,0x00,0x8a,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_f32 v255, v1
// GFX11: v_cvt_f16_f32_e64 v255, v1              ; encoding: [0xff,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_f32_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0x8a,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_f16_f32 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_f32_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_f32 v255, v255
// GFX11: v_cvt_f16_f32_e64 v255, v255            ; encoding: [0xff,0x00,0x8a,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_f32 v255, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_f32_e64_dpp v255, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0x8a,0xd5,0xe9,0x00,0x00,0x00,0xff,0x77,0x39,0x05]

v_cvt_f16_f32 v255, v255 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_f32_e64_dpp v255, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0xff,0x1b,0x00,0xff]

v_cvt_f16_f32 v255, vcc_hi
// GFX11: v_cvt_f16_f32_e64 v255, vcc_hi          ; encoding: [0xff,0x00,0x8a,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32 v255, vcc_lo
// GFX11: v_cvt_f16_f32_e64 v255, vcc_lo          ; encoding: [0xff,0x00,0x8a,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_i16 v128, 0xfe0b
// GFX11: v_cvt_f16_i16_e64 v128, 0xfe0b          ; encoding: [0x80,0x00,0xd1,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_f16_i16 v255, -1
// GFX11: v_cvt_f16_i16_e64 v255, -1              ; encoding: [0xff,0x00,0xd1,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_i16 v255, 0.5
// GFX11: v_cvt_f16_i16_e64 v255, 0.5             ; encoding: [0xff,0x00,0xd1,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_i16 v255, exec_hi
// GFX11: v_cvt_f16_i16_e64 v255, exec_hi         ; encoding: [0xff,0x00,0xd1,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_i16 v255, exec_lo
// GFX11: v_cvt_f16_i16_e64 v255, exec_lo         ; encoding: [0xff,0x00,0xd1,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_i16 v255, m0
// GFX11: v_cvt_f16_i16_e64 v255, m0              ; encoding: [0xff,0x00,0xd1,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_i16 v255, null
// GFX11: v_cvt_f16_i16_e64 v255, null            ; encoding: [0xff,0x00,0xd1,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_i16 v255, s1
// GFX11: v_cvt_f16_i16_e64 v255, s1              ; encoding: [0xff,0x00,0xd1,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_i16 v255, s105
// GFX11: v_cvt_f16_i16_e64 v255, s105            ; encoding: [0xff,0x00,0xd1,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_i16 v255, src_scc
// GFX11: v_cvt_f16_i16_e64 v255, src_scc         ; encoding: [0xff,0x00,0xd1,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_f16_i16 v255, ttmp15
// GFX11: v_cvt_f16_i16_e64 v255, ttmp15          ; encoding: [0xff,0x00,0xd1,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_i16 v255, v1
// GFX11: v_cvt_f16_i16_e64 v255, v1              ; encoding: [0xff,0x00,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd1,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_f16_i16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_i16 v255, v127
// GFX11: v_cvt_f16_i16_e64 v255, v127            ; encoding: [0xff,0x00,0xd1,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_f16_i16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd1,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_f16_i16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_f16_i16 v255, vcc_hi
// GFX11: v_cvt_f16_i16_e64 v255, vcc_hi          ; encoding: [0xff,0x00,0xd1,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_i16 v255, vcc_lo
// GFX11: v_cvt_f16_i16_e64 v255, vcc_lo          ; encoding: [0xff,0x00,0xd1,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_i16 v5, v199
// GFX11: v_cvt_f16_i16_e64 v5, v199              ; encoding: [0x05,0x00,0xd1,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_f16_i16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd1,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_f16_i16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_i16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_f16_u16 v128, 0xfe0b
// GFX11: v_cvt_f16_u16_e64 v128, 0xfe0b          ; encoding: [0x80,0x00,0xd0,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_f16_u16 v255, -1
// GFX11: v_cvt_f16_u16_e64 v255, -1              ; encoding: [0xff,0x00,0xd0,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_u16 v255, 0.5
// GFX11: v_cvt_f16_u16_e64 v255, 0.5             ; encoding: [0xff,0x00,0xd0,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_u16 v255, exec_hi
// GFX11: v_cvt_f16_u16_e64 v255, exec_hi         ; encoding: [0xff,0x00,0xd0,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_u16 v255, exec_lo
// GFX11: v_cvt_f16_u16_e64 v255, exec_lo         ; encoding: [0xff,0x00,0xd0,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_u16 v255, m0
// GFX11: v_cvt_f16_u16_e64 v255, m0              ; encoding: [0xff,0x00,0xd0,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_u16 v255, null
// GFX11: v_cvt_f16_u16_e64 v255, null            ; encoding: [0xff,0x00,0xd0,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_u16 v255, s1
// GFX11: v_cvt_f16_u16_e64 v255, s1              ; encoding: [0xff,0x00,0xd0,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_u16 v255, s105
// GFX11: v_cvt_f16_u16_e64 v255, s105            ; encoding: [0xff,0x00,0xd0,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_u16 v255, src_scc
// GFX11: v_cvt_f16_u16_e64 v255, src_scc         ; encoding: [0xff,0x00,0xd0,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_f16_u16 v255, ttmp15
// GFX11: v_cvt_f16_u16_e64 v255, ttmp15          ; encoding: [0xff,0x00,0xd0,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_u16 v255, v1
// GFX11: v_cvt_f16_u16_e64 v255, v1              ; encoding: [0xff,0x00,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd0,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_f16_u16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_u16 v255, v127
// GFX11: v_cvt_f16_u16_e64 v255, v127            ; encoding: [0xff,0x00,0xd0,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_f16_u16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd0,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_f16_u16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_f16_u16 v255, vcc_hi
// GFX11: v_cvt_f16_u16_e64 v255, vcc_hi          ; encoding: [0xff,0x00,0xd0,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_u16 v255, vcc_lo
// GFX11: v_cvt_f16_u16_e64 v255, vcc_lo          ; encoding: [0xff,0x00,0xd0,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_u16 v5, v199
// GFX11: v_cvt_f16_u16_e64 v5, v199              ; encoding: [0x05,0x00,0xd0,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_f16_u16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd0,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_f16_u16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f16_u16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_f32_f16 v5, v199
// GFX11: v_cvt_f32_f16_e64 v5, v199              ; encoding: [0x05,0x00,0x8b,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_f32_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_f32_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0x8b,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_f32_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_f32_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_i16_f16 v128, 0xfe0b
// GFX11: v_cvt_i16_f16_e64 v128, 0xfe0b          ; encoding: [0x80,0x00,0xd3,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_i16_f16 v255, -1
// GFX11: v_cvt_i16_f16_e64 v255, -1              ; encoding: [0xff,0x00,0xd3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i16_f16 v255, 0.5
// GFX11: v_cvt_i16_f16_e64 v255, 0.5             ; encoding: [0xff,0x00,0xd3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i16_f16 v255, exec_hi
// GFX11: v_cvt_i16_f16_e64 v255, exec_hi         ; encoding: [0xff,0x00,0xd3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i16_f16 v255, exec_lo
// GFX11: v_cvt_i16_f16_e64 v255, exec_lo         ; encoding: [0xff,0x00,0xd3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i16_f16 v255, m0
// GFX11: v_cvt_i16_f16_e64 v255, m0              ; encoding: [0xff,0x00,0xd3,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_i16_f16 v255, null
// GFX11: v_cvt_i16_f16_e64 v255, null            ; encoding: [0xff,0x00,0xd3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i16_f16 v255, s1
// GFX11: v_cvt_i16_f16_e64 v255, s1              ; encoding: [0xff,0x00,0xd3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i16_f16 v255, s105
// GFX11: v_cvt_i16_f16_e64 v255, s105            ; encoding: [0xff,0x00,0xd3,0xd5,0x69,0x00,0x00,0x00]

v_cvt_i16_f16 v255, src_scc
// GFX11: v_cvt_i16_f16_e64 v255, src_scc         ; encoding: [0xff,0x00,0xd3,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_i16_f16 v255, ttmp15
// GFX11: v_cvt_i16_f16_e64 v255, ttmp15          ; encoding: [0xff,0x00,0xd3,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_i16_f16 v255, v1
// GFX11: v_cvt_i16_f16_e64 v255, v1              ; encoding: [0xff,0x00,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd3,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_i16_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i16_f16 v255, v127
// GFX11: v_cvt_i16_f16_e64 v255, v127            ; encoding: [0xff,0x00,0xd3,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_i16_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd3,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_i16_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_i16_f16 v255, vcc_hi
// GFX11: v_cvt_i16_f16_e64 v255, vcc_hi          ; encoding: [0xff,0x00,0xd3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i16_f16 v255, vcc_lo
// GFX11: v_cvt_i16_f16_e64 v255, vcc_lo          ; encoding: [0xff,0x00,0xd3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i16_f16 v5, v199
// GFX11: v_cvt_i16_f16_e64 v5, v199              ; encoding: [0x05,0x00,0xd3,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_i16_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd3,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_i16_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_i16_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_i32_i16 v5, v199
// GFX11: v_cvt_i32_i16_e64 v5, v199              ; encoding: [0x05,0x00,0xea,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_i32_i16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_i32_i16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xea,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_i32_i16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_i32_i16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_norm_i16_f16 v128, 0xfe0b
// GFX11: v_cvt_norm_i16_f16_e64 v128, 0xfe0b     ; encoding: [0x80,0x00,0xe3,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_norm_i16_f16 v255, -1
// GFX11: v_cvt_norm_i16_f16_e64 v255, -1         ; encoding: [0xff,0x00,0xe3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, 0.5
// GFX11: v_cvt_norm_i16_f16_e64 v255, 0.5        ; encoding: [0xff,0x00,0xe3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, exec_hi
// GFX11: v_cvt_norm_i16_f16_e64 v255, exec_hi    ; encoding: [0xff,0x00,0xe3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, exec_lo
// GFX11: v_cvt_norm_i16_f16_e64 v255, exec_lo    ; encoding: [0xff,0x00,0xe3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, m0
// GFX11: v_cvt_norm_i16_f16_e64 v255, m0         ; encoding: [0xff,0x00,0xe3,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, null
// GFX11: v_cvt_norm_i16_f16_e64 v255, null       ; encoding: [0xff,0x00,0xe3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, s1
// GFX11: v_cvt_norm_i16_f16_e64 v255, s1         ; encoding: [0xff,0x00,0xe3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, s105
// GFX11: v_cvt_norm_i16_f16_e64 v255, s105       ; encoding: [0xff,0x00,0xe3,0xd5,0x69,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, src_scc
// GFX11: v_cvt_norm_i16_f16_e64 v255, src_scc    ; encoding: [0xff,0x00,0xe3,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, ttmp15
// GFX11: v_cvt_norm_i16_f16_e64 v255, ttmp15     ; encoding: [0xff,0x00,0xe3,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, v1
// GFX11: v_cvt_norm_i16_f16_e64 v255, v1         ; encoding: [0xff,0x00,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe3,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_norm_i16_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_i16_f16 v255, v127
// GFX11: v_cvt_norm_i16_f16_e64 v255, v127       ; encoding: [0xff,0x00,0xe3,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_norm_i16_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe3,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_norm_i16_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_norm_i16_f16 v255, vcc_hi
// GFX11: v_cvt_norm_i16_f16_e64 v255, vcc_hi     ; encoding: [0xff,0x00,0xe3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v255, vcc_lo
// GFX11: v_cvt_norm_i16_f16_e64 v255, vcc_lo     ; encoding: [0xff,0x00,0xe3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_i16_f16 v5, v199
// GFX11: v_cvt_norm_i16_f16_e64 v5, v199         ; encoding: [0x05,0x00,0xe3,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_norm_i16_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xe3,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_norm_i16_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_i16_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_norm_u16_f16 v128, 0xfe0b
// GFX11: v_cvt_norm_u16_f16_e64 v128, 0xfe0b     ; encoding: [0x80,0x00,0xe4,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_norm_u16_f16 v255, -1
// GFX11: v_cvt_norm_u16_f16_e64 v255, -1         ; encoding: [0xff,0x00,0xe4,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, 0.5
// GFX11: v_cvt_norm_u16_f16_e64 v255, 0.5        ; encoding: [0xff,0x00,0xe4,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, exec_hi
// GFX11: v_cvt_norm_u16_f16_e64 v255, exec_hi    ; encoding: [0xff,0x00,0xe4,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, exec_lo
// GFX11: v_cvt_norm_u16_f16_e64 v255, exec_lo    ; encoding: [0xff,0x00,0xe4,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, m0
// GFX11: v_cvt_norm_u16_f16_e64 v255, m0         ; encoding: [0xff,0x00,0xe4,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, null
// GFX11: v_cvt_norm_u16_f16_e64 v255, null       ; encoding: [0xff,0x00,0xe4,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, s1
// GFX11: v_cvt_norm_u16_f16_e64 v255, s1         ; encoding: [0xff,0x00,0xe4,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, s105
// GFX11: v_cvt_norm_u16_f16_e64 v255, s105       ; encoding: [0xff,0x00,0xe4,0xd5,0x69,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, src_scc
// GFX11: v_cvt_norm_u16_f16_e64 v255, src_scc    ; encoding: [0xff,0x00,0xe4,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, ttmp15
// GFX11: v_cvt_norm_u16_f16_e64 v255, ttmp15     ; encoding: [0xff,0x00,0xe4,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, v1
// GFX11: v_cvt_norm_u16_f16_e64 v255, v1         ; encoding: [0xff,0x00,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe4,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_norm_u16_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_u16_f16 v255, v127
// GFX11: v_cvt_norm_u16_f16_e64 v255, v127       ; encoding: [0xff,0x00,0xe4,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_norm_u16_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe4,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_norm_u16_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_norm_u16_f16 v255, vcc_hi
// GFX11: v_cvt_norm_u16_f16_e64 v255, vcc_hi     ; encoding: [0xff,0x00,0xe4,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v255, vcc_lo
// GFX11: v_cvt_norm_u16_f16_e64 v255, vcc_lo     ; encoding: [0xff,0x00,0xe4,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_u16_f16 v5, v199
// GFX11: v_cvt_norm_u16_f16_e64 v5, v199         ; encoding: [0x05,0x00,0xe4,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_norm_u16_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xe4,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_norm_u16_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_norm_u16_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_u16_f16 v128, 0xfe0b
// GFX11: v_cvt_u16_f16_e64 v128, 0xfe0b          ; encoding: [0x80,0x00,0xd2,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_u16_f16 v255, -1
// GFX11: v_cvt_u16_f16_e64 v255, -1              ; encoding: [0xff,0x00,0xd2,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u16_f16 v255, 0.5
// GFX11: v_cvt_u16_f16_e64 v255, 0.5             ; encoding: [0xff,0x00,0xd2,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u16_f16 v255, exec_hi
// GFX11: v_cvt_u16_f16_e64 v255, exec_hi         ; encoding: [0xff,0x00,0xd2,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u16_f16 v255, exec_lo
// GFX11: v_cvt_u16_f16_e64 v255, exec_lo         ; encoding: [0xff,0x00,0xd2,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u16_f16 v255, m0
// GFX11: v_cvt_u16_f16_e64 v255, m0              ; encoding: [0xff,0x00,0xd2,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_u16_f16 v255, null
// GFX11: v_cvt_u16_f16_e64 v255, null            ; encoding: [0xff,0x00,0xd2,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u16_f16 v255, s1
// GFX11: v_cvt_u16_f16_e64 v255, s1              ; encoding: [0xff,0x00,0xd2,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u16_f16 v255, s105
// GFX11: v_cvt_u16_f16_e64 v255, s105            ; encoding: [0xff,0x00,0xd2,0xd5,0x69,0x00,0x00,0x00]

v_cvt_u16_f16 v255, src_scc
// GFX11: v_cvt_u16_f16_e64 v255, src_scc         ; encoding: [0xff,0x00,0xd2,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_u16_f16 v255, ttmp15
// GFX11: v_cvt_u16_f16_e64 v255, ttmp15          ; encoding: [0xff,0x00,0xd2,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_u16_f16 v255, v1
// GFX11: v_cvt_u16_f16_e64 v255, v1              ; encoding: [0xff,0x00,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd2,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_cvt_u16_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u16_f16 v255, v127
// GFX11: v_cvt_u16_f16_e64 v255, v127            ; encoding: [0xff,0x00,0xd2,0xd5,0x7f,0x01,0x00,0x00]

v_cvt_u16_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd2,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_cvt_u16_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_cvt_u16_f16 v255, vcc_hi
// GFX11: v_cvt_u16_f16_e64 v255, vcc_hi          ; encoding: [0xff,0x00,0xd2,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u16_f16 v255, vcc_lo
// GFX11: v_cvt_u16_f16_e64 v255, vcc_lo          ; encoding: [0xff,0x00,0xd2,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u16_f16 v5, v199
// GFX11: v_cvt_u16_f16_e64 v5, v199              ; encoding: [0x05,0x00,0xd2,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_u16_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd2,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_u16_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_u16_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_cvt_u32_u16 v5, v199
// GFX11: v_cvt_u32_u16_e64 v5, v199              ; encoding: [0x05,0x00,0xeb,0xd5,0xc7,0x01,0x00,0x00]

v_cvt_u32_u16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cvt_u32_u16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xeb,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_cvt_u32_u16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_cvt_u32_u16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_exp_f16 v128, 0xfe0b
// GFX11: v_exp_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xd8,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_exp_f16 v255, -1
// GFX11: v_exp_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xd8,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f16 v255, 0.5
// GFX11: v_exp_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xd8,0xd5,0xf0,0x00,0x00,0x00]

v_exp_f16 v255, exec_hi
// GFX11: v_exp_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xd8,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f16 v255, exec_lo
// GFX11: v_exp_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xd8,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f16 v255, m0
// GFX11: v_exp_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xd8,0xd5,0x7d,0x00,0x00,0x00]

v_exp_f16 v255, null
// GFX11: v_exp_f16_e64 v255, null                ; encoding: [0xff,0x00,0xd8,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f16 v255, s1
// GFX11: v_exp_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xd8,0xd5,0x01,0x00,0x00,0x00]

v_exp_f16 v255, s105
// GFX11: v_exp_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xd8,0xd5,0x69,0x00,0x00,0x00]

v_exp_f16 v255, src_scc
// GFX11: v_exp_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xd8,0xd5,0xfd,0x00,0x00,0x00]

v_exp_f16 v255, ttmp15
// GFX11: v_exp_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xd8,0xd5,0x7b,0x00,0x00,0x00]

v_exp_f16 v255, v1
// GFX11: v_exp_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd8,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_exp_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f16 v255, v127
// GFX11: v_exp_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xd8,0xd5,0x7f,0x01,0x00,0x00]

v_exp_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd8,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_exp_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_exp_f16 v255, vcc_hi
// GFX11: v_exp_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xd8,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f16 v255, vcc_lo
// GFX11: v_exp_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xd8,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f16 v5, v199
// GFX11: v_exp_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xd8,0xd5,0xc7,0x01,0x00,0x00]

v_exp_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd8,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_exp_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_exp_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_floor_f16 v128, 0xfe0b
// GFX11: v_floor_f16_e64 v128, 0xfe0b            ; encoding: [0x80,0x00,0xdb,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_floor_f16 v255, -1
// GFX11: v_floor_f16_e64 v255, -1                ; encoding: [0xff,0x00,0xdb,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f16 v255, 0.5
// GFX11: v_floor_f16_e64 v255, 0.5               ; encoding: [0xff,0x00,0xdb,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f16 v255, exec_hi
// GFX11: v_floor_f16_e64 v255, exec_hi           ; encoding: [0xff,0x00,0xdb,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f16 v255, exec_lo
// GFX11: v_floor_f16_e64 v255, exec_lo           ; encoding: [0xff,0x00,0xdb,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f16 v255, m0
// GFX11: v_floor_f16_e64 v255, m0                ; encoding: [0xff,0x00,0xdb,0xd5,0x7d,0x00,0x00,0x00]

v_floor_f16 v255, null
// GFX11: v_floor_f16_e64 v255, null              ; encoding: [0xff,0x00,0xdb,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f16 v255, s1
// GFX11: v_floor_f16_e64 v255, s1                ; encoding: [0xff,0x00,0xdb,0xd5,0x01,0x00,0x00,0x00]

v_floor_f16 v255, s105
// GFX11: v_floor_f16_e64 v255, s105              ; encoding: [0xff,0x00,0xdb,0xd5,0x69,0x00,0x00,0x00]

v_floor_f16 v255, src_scc
// GFX11: v_floor_f16_e64 v255, src_scc           ; encoding: [0xff,0x00,0xdb,0xd5,0xfd,0x00,0x00,0x00]

v_floor_f16 v255, ttmp15
// GFX11: v_floor_f16_e64 v255, ttmp15            ; encoding: [0xff,0x00,0xdb,0xd5,0x7b,0x00,0x00,0x00]

v_floor_f16 v255, v1
// GFX11: v_floor_f16_e64 v255, v1                ; encoding: [0xff,0x00,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdb,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_floor_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f16 v255, v127
// GFX11: v_floor_f16_e64 v255, v127              ; encoding: [0xff,0x00,0xdb,0xd5,0x7f,0x01,0x00,0x00]

v_floor_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdb,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_floor_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_floor_f16 v255, vcc_hi
// GFX11: v_floor_f16_e64 v255, vcc_hi            ; encoding: [0xff,0x00,0xdb,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f16 v255, vcc_lo
// GFX11: v_floor_f16_e64 v255, vcc_lo            ; encoding: [0xff,0x00,0xdb,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f16 v5, v199
// GFX11: v_floor_f16_e64 v5, v199                ; encoding: [0x05,0x00,0xdb,0xd5,0xc7,0x01,0x00,0x00]

v_floor_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xdb,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_floor_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_floor_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_fract_f16 v128, 0xfe0b
// GFX11: v_fract_f16_e64 v128, 0xfe0b            ; encoding: [0x80,0x00,0xdf,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_fract_f16 v255, -1
// GFX11: v_fract_f16_e64 v255, -1                ; encoding: [0xff,0x00,0xdf,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f16 v255, 0.5
// GFX11: v_fract_f16_e64 v255, 0.5               ; encoding: [0xff,0x00,0xdf,0xd5,0xf0,0x00,0x00,0x00]

v_fract_f16 v255, exec_hi
// GFX11: v_fract_f16_e64 v255, exec_hi           ; encoding: [0xff,0x00,0xdf,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f16 v255, exec_lo
// GFX11: v_fract_f16_e64 v255, exec_lo           ; encoding: [0xff,0x00,0xdf,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f16 v255, m0
// GFX11: v_fract_f16_e64 v255, m0                ; encoding: [0xff,0x00,0xdf,0xd5,0x7d,0x00,0x00,0x00]

v_fract_f16 v255, null
// GFX11: v_fract_f16_e64 v255, null              ; encoding: [0xff,0x00,0xdf,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f16 v255, s1
// GFX11: v_fract_f16_e64 v255, s1                ; encoding: [0xff,0x00,0xdf,0xd5,0x01,0x00,0x00,0x00]

v_fract_f16 v255, s105
// GFX11: v_fract_f16_e64 v255, s105              ; encoding: [0xff,0x00,0xdf,0xd5,0x69,0x00,0x00,0x00]

v_fract_f16 v255, src_scc
// GFX11: v_fract_f16_e64 v255, src_scc           ; encoding: [0xff,0x00,0xdf,0xd5,0xfd,0x00,0x00,0x00]

v_fract_f16 v255, ttmp15
// GFX11: v_fract_f16_e64 v255, ttmp15            ; encoding: [0xff,0x00,0xdf,0xd5,0x7b,0x00,0x00,0x00]

v_fract_f16 v255, v1
// GFX11: v_fract_f16_e64 v255, v1                ; encoding: [0xff,0x00,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdf,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_fract_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f16 v255, v127
// GFX11: v_fract_f16_e64 v255, v127              ; encoding: [0xff,0x00,0xdf,0xd5,0x7f,0x01,0x00,0x00]

v_fract_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdf,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_fract_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_fract_f16 v255, vcc_hi
// GFX11: v_fract_f16_e64 v255, vcc_hi            ; encoding: [0xff,0x00,0xdf,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f16 v255, vcc_lo
// GFX11: v_fract_f16_e64 v255, vcc_lo            ; encoding: [0xff,0x00,0xdf,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f16 v5, v199
// GFX11: v_fract_f16_e64 v5, v199                ; encoding: [0x05,0x00,0xdf,0xd5,0xc7,0x01,0x00,0x00]

v_fract_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xdf,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_fract_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_fract_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_frexp_exp_i16_f16 v128, 0xfe0b
// GFX11: v_frexp_exp_i16_f16_e64 v128, 0xfe0b    ; encoding: [0x80,0x00,0xda,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_frexp_exp_i16_f16 v255, -1
// GFX11: v_frexp_exp_i16_f16_e64 v255, -1        ; encoding: [0xff,0x00,0xda,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, 0.5
// GFX11: v_frexp_exp_i16_f16_e64 v255, 0.5       ; encoding: [0xff,0x00,0xda,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, exec_hi
// GFX11: v_frexp_exp_i16_f16_e64 v255, exec_hi   ; encoding: [0xff,0x00,0xda,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, exec_lo
// GFX11: v_frexp_exp_i16_f16_e64 v255, exec_lo   ; encoding: [0xff,0x00,0xda,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, m0
// GFX11: v_frexp_exp_i16_f16_e64 v255, m0        ; encoding: [0xff,0x00,0xda,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, null
// GFX11: v_frexp_exp_i16_f16_e64 v255, null      ; encoding: [0xff,0x00,0xda,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, s1
// GFX11: v_frexp_exp_i16_f16_e64 v255, s1        ; encoding: [0xff,0x00,0xda,0xd5,0x01,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, s105
// GFX11: v_frexp_exp_i16_f16_e64 v255, s105      ; encoding: [0xff,0x00,0xda,0xd5,0x69,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, src_scc
// GFX11: v_frexp_exp_i16_f16_e64 v255, src_scc   ; encoding: [0xff,0x00,0xda,0xd5,0xfd,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, ttmp15
// GFX11: v_frexp_exp_i16_f16_e64 v255, ttmp15    ; encoding: [0xff,0x00,0xda,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, v1
// GFX11: v_frexp_exp_i16_f16_e64 v255, v1        ; encoding: [0xff,0x00,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xda,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_frexp_exp_i16_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i16_f16 v255, v127
// GFX11: v_frexp_exp_i16_f16_e64 v255, v127      ; encoding: [0xff,0x00,0xda,0xd5,0x7f,0x01,0x00,0x00]

v_frexp_exp_i16_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xda,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_frexp_exp_i16_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_frexp_exp_i16_f16 v255, vcc_hi
// GFX11: v_frexp_exp_i16_f16_e64 v255, vcc_hi    ; encoding: [0xff,0x00,0xda,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v255, vcc_lo
// GFX11: v_frexp_exp_i16_f16_e64 v255, vcc_lo    ; encoding: [0xff,0x00,0xda,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i16_f16 v5, v199
// GFX11: v_frexp_exp_i16_f16_e64 v5, v199        ; encoding: [0x05,0x00,0xda,0xd5,0xc7,0x01,0x00,0x00]

v_frexp_exp_i16_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xda,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_frexp_exp_i16_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_frexp_exp_i16_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_frexp_mant_f16 v128, 0xfe0b
// GFX11: v_frexp_mant_f16_e64 v128, 0xfe0b       ; encoding: [0x80,0x00,0xd9,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_frexp_mant_f16 v255, -1
// GFX11: v_frexp_mant_f16_e64 v255, -1           ; encoding: [0xff,0x00,0xd9,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f16 v255, 0.5
// GFX11: v_frexp_mant_f16_e64 v255, 0.5          ; encoding: [0xff,0x00,0xd9,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_mant_f16 v255, exec_hi
// GFX11: v_frexp_mant_f16_e64 v255, exec_hi      ; encoding: [0xff,0x00,0xd9,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_mant_f16 v255, exec_lo
// GFX11: v_frexp_mant_f16_e64 v255, exec_lo      ; encoding: [0xff,0x00,0xd9,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f16 v255, m0
// GFX11: v_frexp_mant_f16_e64 v255, m0           ; encoding: [0xff,0x00,0xd9,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_mant_f16 v255, null
// GFX11: v_frexp_mant_f16_e64 v255, null         ; encoding: [0xff,0x00,0xd9,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f16 v255, s1
// GFX11: v_frexp_mant_f16_e64 v255, s1           ; encoding: [0xff,0x00,0xd9,0xd5,0x01,0x00,0x00,0x00]

v_frexp_mant_f16 v255, s105
// GFX11: v_frexp_mant_f16_e64 v255, s105         ; encoding: [0xff,0x00,0xd9,0xd5,0x69,0x00,0x00,0x00]

v_frexp_mant_f16 v255, src_scc
// GFX11: v_frexp_mant_f16_e64 v255, src_scc      ; encoding: [0xff,0x00,0xd9,0xd5,0xfd,0x00,0x00,0x00]

v_frexp_mant_f16 v255, ttmp15
// GFX11: v_frexp_mant_f16_e64 v255, ttmp15       ; encoding: [0xff,0x00,0xd9,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_mant_f16 v255, v1
// GFX11: v_frexp_mant_f16_e64 v255, v1           ; encoding: [0xff,0x00,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd9,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_frexp_mant_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f16 v255, v127
// GFX11: v_frexp_mant_f16_e64 v255, v127         ; encoding: [0xff,0x00,0xd9,0xd5,0x7f,0x01,0x00,0x00]

v_frexp_mant_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd9,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_frexp_mant_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_frexp_mant_f16 v255, vcc_hi
// GFX11: v_frexp_mant_f16_e64 v255, vcc_hi       ; encoding: [0xff,0x00,0xd9,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_mant_f16 v255, vcc_lo
// GFX11: v_frexp_mant_f16_e64 v255, vcc_lo       ; encoding: [0xff,0x00,0xd9,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f16 v5, v199
// GFX11: v_frexp_mant_f16_e64 v5, v199           ; encoding: [0x05,0x00,0xd9,0xd5,0xc7,0x01,0x00,0x00]

v_frexp_mant_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd9,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_frexp_mant_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_frexp_mant_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_log_f16 v128, 0xfe0b
// GFX11: v_log_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xd7,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_log_f16 v255, -1
// GFX11: v_log_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xd7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f16 v255, 0.5
// GFX11: v_log_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xd7,0xd5,0xf0,0x00,0x00,0x00]

v_log_f16 v255, exec_hi
// GFX11: v_log_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xd7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f16 v255, exec_lo
// GFX11: v_log_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xd7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f16 v255, m0
// GFX11: v_log_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xd7,0xd5,0x7d,0x00,0x00,0x00]

v_log_f16 v255, null
// GFX11: v_log_f16_e64 v255, null                ; encoding: [0xff,0x00,0xd7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f16 v255, s1
// GFX11: v_log_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xd7,0xd5,0x01,0x00,0x00,0x00]

v_log_f16 v255, s105
// GFX11: v_log_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xd7,0xd5,0x69,0x00,0x00,0x00]

v_log_f16 v255, src_scc
// GFX11: v_log_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xd7,0xd5,0xfd,0x00,0x00,0x00]

v_log_f16 v255, ttmp15
// GFX11: v_log_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xd7,0xd5,0x7b,0x00,0x00,0x00]

v_log_f16 v255, v1
// GFX11: v_log_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_log_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd7,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_log_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_log_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f16 v255, v127
// GFX11: v_log_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xd7,0xd5,0x7f,0x01,0x00,0x00]

v_log_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_log_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd7,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_log_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_log_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_log_f16 v255, vcc_hi
// GFX11: v_log_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xd7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f16 v255, vcc_lo
// GFX11: v_log_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xd7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f16 v5, v199
// GFX11: v_log_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xd7,0xd5,0xc7,0x01,0x00,0x00]

v_log_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_log_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd7,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_log_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_log_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_not_b16 v128, 0xfe0b
// GFX11: v_not_b16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xe9,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_not_b16 v255, -1
// GFX11: v_not_b16_e64 v255, -1                  ; encoding: [0xff,0x00,0xe9,0xd5,0xc1,0x00,0x00,0x00]

v_not_b16 v255, 0.5
// GFX11: v_not_b16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xe9,0xd5,0xf0,0x00,0x00,0x00]

v_not_b16 v255, exec_hi
// GFX11: v_not_b16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xe9,0xd5,0x7f,0x00,0x00,0x00]

v_not_b16 v255, exec_lo
// GFX11: v_not_b16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xe9,0xd5,0x7e,0x00,0x00,0x00]

v_not_b16 v255, m0
// GFX11: v_not_b16_e64 v255, m0                  ; encoding: [0xff,0x00,0xe9,0xd5,0x7d,0x00,0x00,0x00]

v_not_b16 v255, null
// GFX11: v_not_b16_e64 v255, null                ; encoding: [0xff,0x00,0xe9,0xd5,0x7c,0x00,0x00,0x00]

v_not_b16 v255, s1
// GFX11: v_not_b16_e64 v255, s1                  ; encoding: [0xff,0x00,0xe9,0xd5,0x01,0x00,0x00,0x00]

v_not_b16 v255, s105
// GFX11: v_not_b16_e64 v255, s105                ; encoding: [0xff,0x00,0xe9,0xd5,0x69,0x00,0x00,0x00]

v_not_b16 v255, src_scc
// GFX11: v_not_b16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xe9,0xd5,0xfd,0x00,0x00,0x00]

v_not_b16 v255, ttmp15
// GFX11: v_not_b16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xe9,0xd5,0x7b,0x00,0x00,0x00]

v_not_b16 v255, v1
// GFX11: v_not_b16_e64 v255, v1                  ; encoding: [0xff,0x00,0xe9,0xd5,0x01,0x01,0x00,0x00]

v_not_b16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_not_b16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe9,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_not_b16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_not_b16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b16 v255, v127
// GFX11: v_not_b16_e64 v255, v127                ; encoding: [0xff,0x00,0xe9,0xd5,0x7f,0x01,0x00,0x00]

v_not_b16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_not_b16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe9,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_not_b16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_not_b16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_not_b16 v255, vcc_hi
// GFX11: v_not_b16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xe9,0xd5,0x6b,0x00,0x00,0x00]

v_not_b16 v255, vcc_lo
// GFX11: v_not_b16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xe9,0xd5,0x6a,0x00,0x00,0x00]

v_not_b16 v5, v199
// GFX11: v_not_b16_e64 v5, v199                  ; encoding: [0x05,0x00,0xe9,0xd5,0xc7,0x01,0x00,0x00]

v_not_b16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_not_b16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xe9,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_not_b16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_not_b16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_rcp_f16 v128, 0xfe0b
// GFX11: v_rcp_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xd4,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_rcp_f16 v255, -1
// GFX11: v_rcp_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xd4,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f16 v255, 0.5
// GFX11: v_rcp_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xd4,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f16 v255, exec_hi
// GFX11: v_rcp_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xd4,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f16 v255, exec_lo
// GFX11: v_rcp_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xd4,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f16 v255, m0
// GFX11: v_rcp_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xd4,0xd5,0x7d,0x00,0x00,0x00]

v_rcp_f16 v255, null
// GFX11: v_rcp_f16_e64 v255, null                ; encoding: [0xff,0x00,0xd4,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f16 v255, s1
// GFX11: v_rcp_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xd4,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f16 v255, s105
// GFX11: v_rcp_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xd4,0xd5,0x69,0x00,0x00,0x00]

v_rcp_f16 v255, src_scc
// GFX11: v_rcp_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xd4,0xd5,0xfd,0x00,0x00,0x00]

v_rcp_f16 v255, ttmp15
// GFX11: v_rcp_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xd4,0xd5,0x7b,0x00,0x00,0x00]

v_rcp_f16 v255, v1
// GFX11: v_rcp_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd4,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_rcp_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f16 v255, v127
// GFX11: v_rcp_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xd4,0xd5,0x7f,0x01,0x00,0x00]

v_rcp_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd4,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_rcp_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_rcp_f16 v255, vcc_hi
// GFX11: v_rcp_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xd4,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f16 v255, vcc_lo
// GFX11: v_rcp_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xd4,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f16 v5, v199
// GFX11: v_rcp_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xd4,0xd5,0xc7,0x01,0x00,0x00]

v_rcp_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd4,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_rcp_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_rcp_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_rndne_f16 v128, 0xfe0b
// GFX11: v_rndne_f16_e64 v128, 0xfe0b            ; encoding: [0x80,0x00,0xde,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_rndne_f16 v255, -1
// GFX11: v_rndne_f16_e64 v255, -1                ; encoding: [0xff,0x00,0xde,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f16 v255, 0.5
// GFX11: v_rndne_f16_e64 v255, 0.5               ; encoding: [0xff,0x00,0xde,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f16 v255, exec_hi
// GFX11: v_rndne_f16_e64 v255, exec_hi           ; encoding: [0xff,0x00,0xde,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f16 v255, exec_lo
// GFX11: v_rndne_f16_e64 v255, exec_lo           ; encoding: [0xff,0x00,0xde,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f16 v255, m0
// GFX11: v_rndne_f16_e64 v255, m0                ; encoding: [0xff,0x00,0xde,0xd5,0x7d,0x00,0x00,0x00]

v_rndne_f16 v255, null
// GFX11: v_rndne_f16_e64 v255, null              ; encoding: [0xff,0x00,0xde,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f16 v255, s1
// GFX11: v_rndne_f16_e64 v255, s1                ; encoding: [0xff,0x00,0xde,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f16 v255, s105
// GFX11: v_rndne_f16_e64 v255, s105              ; encoding: [0xff,0x00,0xde,0xd5,0x69,0x00,0x00,0x00]

v_rndne_f16 v255, src_scc
// GFX11: v_rndne_f16_e64 v255, src_scc           ; encoding: [0xff,0x00,0xde,0xd5,0xfd,0x00,0x00,0x00]

v_rndne_f16 v255, ttmp15
// GFX11: v_rndne_f16_e64 v255, ttmp15            ; encoding: [0xff,0x00,0xde,0xd5,0x7b,0x00,0x00,0x00]

v_rndne_f16 v255, v1
// GFX11: v_rndne_f16_e64 v255, v1                ; encoding: [0xff,0x00,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xde,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_rndne_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f16 v255, v127
// GFX11: v_rndne_f16_e64 v255, v127              ; encoding: [0xff,0x00,0xde,0xd5,0x7f,0x01,0x00,0x00]

v_rndne_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xde,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_rndne_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_rndne_f16 v255, vcc_hi
// GFX11: v_rndne_f16_e64 v255, vcc_hi            ; encoding: [0xff,0x00,0xde,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f16 v255, vcc_lo
// GFX11: v_rndne_f16_e64 v255, vcc_lo            ; encoding: [0xff,0x00,0xde,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f16 v5, v199
// GFX11: v_rndne_f16_e64 v5, v199                ; encoding: [0x05,0x00,0xde,0xd5,0xc7,0x01,0x00,0x00]

v_rndne_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xde,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_rndne_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_rndne_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_rsq_f16 v128, 0xfe0b
// GFX11: v_rsq_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xd6,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_rsq_f16 v255, -1
// GFX11: v_rsq_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xd6,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f16 v255, 0.5
// GFX11: v_rsq_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xd6,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f16 v255, exec_hi
// GFX11: v_rsq_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xd6,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f16 v255, exec_lo
// GFX11: v_rsq_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xd6,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f16 v255, m0
// GFX11: v_rsq_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xd6,0xd5,0x7d,0x00,0x00,0x00]

v_rsq_f16 v255, null
// GFX11: v_rsq_f16_e64 v255, null                ; encoding: [0xff,0x00,0xd6,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f16 v255, s1
// GFX11: v_rsq_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xd6,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f16 v255, s105
// GFX11: v_rsq_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xd6,0xd5,0x69,0x00,0x00,0x00]

v_rsq_f16 v255, src_scc
// GFX11: v_rsq_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xd6,0xd5,0xfd,0x00,0x00,0x00]

v_rsq_f16 v255, ttmp15
// GFX11: v_rsq_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xd6,0xd5,0x7b,0x00,0x00,0x00]

v_rsq_f16 v255, v1
// GFX11: v_rsq_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd6,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_rsq_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f16 v255, v127
// GFX11: v_rsq_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xd6,0xd5,0x7f,0x01,0x00,0x00]

v_rsq_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd6,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_rsq_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_rsq_f16 v255, vcc_hi
// GFX11: v_rsq_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xd6,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f16 v255, vcc_lo
// GFX11: v_rsq_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xd6,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f16 v5, v199
// GFX11: v_rsq_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xd6,0xd5,0xc7,0x01,0x00,0x00]

v_rsq_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd6,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_rsq_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_rsq_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_sat_pk_u8_i16 v199, v5
// GFX11: v_sat_pk_u8_i16_e64 v199, v5            ; encoding: [0xc7,0x00,0xe2,0xd5,0x05,0x01,0x00,0x00]

v_sat_pk_u8_i16 v199, v5 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sat_pk_u8_i16_e64_dpp v199, v5 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xc7,0x00,0xe2,0xd5,0xe9,0x00,0x00,0x00,0x05,0x77,0x39,0x05]

v_sat_pk_u8_i16 v199, v5 quad_perm:[3,2,1,0]
// GFX11: v_sat_pk_u8_i16_e64_dpp v199, v5 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xc7,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x05,0x1b,0x00,0xff]

v_sin_f16 v128, 0xfe0b
// GFX11: v_sin_f16_e64 v128, 0xfe0b              ; encoding: [0x80,0x00,0xe0,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_sin_f16 v255, -1
// GFX11: v_sin_f16_e64 v255, -1                  ; encoding: [0xff,0x00,0xe0,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f16 v255, 0.5
// GFX11: v_sin_f16_e64 v255, 0.5                 ; encoding: [0xff,0x00,0xe0,0xd5,0xf0,0x00,0x00,0x00]

v_sin_f16 v255, exec_hi
// GFX11: v_sin_f16_e64 v255, exec_hi             ; encoding: [0xff,0x00,0xe0,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f16 v255, exec_lo
// GFX11: v_sin_f16_e64 v255, exec_lo             ; encoding: [0xff,0x00,0xe0,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f16 v255, m0
// GFX11: v_sin_f16_e64 v255, m0                  ; encoding: [0xff,0x00,0xe0,0xd5,0x7d,0x00,0x00,0x00]

v_sin_f16 v255, null
// GFX11: v_sin_f16_e64 v255, null                ; encoding: [0xff,0x00,0xe0,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f16 v255, s1
// GFX11: v_sin_f16_e64 v255, s1                  ; encoding: [0xff,0x00,0xe0,0xd5,0x01,0x00,0x00,0x00]

v_sin_f16 v255, s105
// GFX11: v_sin_f16_e64 v255, s105                ; encoding: [0xff,0x00,0xe0,0xd5,0x69,0x00,0x00,0x00]

v_sin_f16 v255, src_scc
// GFX11: v_sin_f16_e64 v255, src_scc             ; encoding: [0xff,0x00,0xe0,0xd5,0xfd,0x00,0x00,0x00]

v_sin_f16 v255, ttmp15
// GFX11: v_sin_f16_e64 v255, ttmp15              ; encoding: [0xff,0x00,0xe0,0xd5,0x7b,0x00,0x00,0x00]

v_sin_f16 v255, v1
// GFX11: v_sin_f16_e64 v255, v1                  ; encoding: [0xff,0x00,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe0,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_sin_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f16 v255, v127
// GFX11: v_sin_f16_e64 v255, v127                ; encoding: [0xff,0x00,0xe0,0xd5,0x7f,0x01,0x00,0x00]

v_sin_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xe0,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_sin_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_sin_f16 v255, vcc_hi
// GFX11: v_sin_f16_e64 v255, vcc_hi              ; encoding: [0xff,0x00,0xe0,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f16 v255, vcc_lo
// GFX11: v_sin_f16_e64 v255, vcc_lo              ; encoding: [0xff,0x00,0xe0,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f16 v5, v199
// GFX11: v_sin_f16_e64 v5, v199                  ; encoding: [0x05,0x00,0xe0,0xd5,0xc7,0x01,0x00,0x00]

v_sin_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xe0,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_sin_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_sin_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_sqrt_f16 v128, 0xfe0b
// GFX11: v_sqrt_f16_e64 v128, 0xfe0b             ; encoding: [0x80,0x00,0xd5,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_sqrt_f16 v255, -1
// GFX11: v_sqrt_f16_e64 v255, -1                 ; encoding: [0xff,0x00,0xd5,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f16 v255, 0.5
// GFX11: v_sqrt_f16_e64 v255, 0.5                ; encoding: [0xff,0x00,0xd5,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f16 v255, exec_hi
// GFX11: v_sqrt_f16_e64 v255, exec_hi            ; encoding: [0xff,0x00,0xd5,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f16 v255, exec_lo
// GFX11: v_sqrt_f16_e64 v255, exec_lo            ; encoding: [0xff,0x00,0xd5,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f16 v255, m0
// GFX11: v_sqrt_f16_e64 v255, m0                 ; encoding: [0xff,0x00,0xd5,0xd5,0x7d,0x00,0x00,0x00]

v_sqrt_f16 v255, null
// GFX11: v_sqrt_f16_e64 v255, null               ; encoding: [0xff,0x00,0xd5,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f16 v255, s1
// GFX11: v_sqrt_f16_e64 v255, s1                 ; encoding: [0xff,0x00,0xd5,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f16 v255, s105
// GFX11: v_sqrt_f16_e64 v255, s105               ; encoding: [0xff,0x00,0xd5,0xd5,0x69,0x00,0x00,0x00]

v_sqrt_f16 v255, src_scc
// GFX11: v_sqrt_f16_e64 v255, src_scc            ; encoding: [0xff,0x00,0xd5,0xd5,0xfd,0x00,0x00,0x00]

v_sqrt_f16 v255, ttmp15
// GFX11: v_sqrt_f16_e64 v255, ttmp15             ; encoding: [0xff,0x00,0xd5,0xd5,0x7b,0x00,0x00,0x00]

v_sqrt_f16 v255, v1
// GFX11: v_sqrt_f16_e64 v255, v1                 ; encoding: [0xff,0x00,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd5,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_sqrt_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f16 v255, v127
// GFX11: v_sqrt_f16_e64 v255, v127               ; encoding: [0xff,0x00,0xd5,0xd5,0x7f,0x01,0x00,0x00]

v_sqrt_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xd5,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_sqrt_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_sqrt_f16 v255, vcc_hi
// GFX11: v_sqrt_f16_e64 v255, vcc_hi             ; encoding: [0xff,0x00,0xd5,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f16 v255, vcc_lo
// GFX11: v_sqrt_f16_e64 v255, vcc_lo             ; encoding: [0xff,0x00,0xd5,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f16 v5, v199
// GFX11: v_sqrt_f16_e64 v5, v199                 ; encoding: [0x05,0x00,0xd5,0xd5,0xc7,0x01,0x00,0x00]

v_sqrt_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xd5,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_sqrt_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_sqrt_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]

v_trunc_f16 v128, 0xfe0b
// GFX11: v_trunc_f16_e64 v128, 0xfe0b            ; encoding: [0x80,0x00,0xdd,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_trunc_f16 v255, -1
// GFX11: v_trunc_f16_e64 v255, -1                ; encoding: [0xff,0x00,0xdd,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f16 v255, 0.5
// GFX11: v_trunc_f16_e64 v255, 0.5               ; encoding: [0xff,0x00,0xdd,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f16 v255, exec_hi
// GFX11: v_trunc_f16_e64 v255, exec_hi           ; encoding: [0xff,0x00,0xdd,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f16 v255, exec_lo
// GFX11: v_trunc_f16_e64 v255, exec_lo           ; encoding: [0xff,0x00,0xdd,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f16 v255, m0
// GFX11: v_trunc_f16_e64 v255, m0                ; encoding: [0xff,0x00,0xdd,0xd5,0x7d,0x00,0x00,0x00]

v_trunc_f16 v255, null
// GFX11: v_trunc_f16_e64 v255, null              ; encoding: [0xff,0x00,0xdd,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f16 v255, s1
// GFX11: v_trunc_f16_e64 v255, s1                ; encoding: [0xff,0x00,0xdd,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f16 v255, s105
// GFX11: v_trunc_f16_e64 v255, s105              ; encoding: [0xff,0x00,0xdd,0xd5,0x69,0x00,0x00,0x00]

v_trunc_f16 v255, src_scc
// GFX11: v_trunc_f16_e64 v255, src_scc           ; encoding: [0xff,0x00,0xdd,0xd5,0xfd,0x00,0x00,0x00]

v_trunc_f16 v255, ttmp15
// GFX11: v_trunc_f16_e64 v255, ttmp15            ; encoding: [0xff,0x00,0xdd,0xd5,0x7b,0x00,0x00,0x00]

v_trunc_f16 v255, v1
// GFX11: v_trunc_f16_e64 v255, v1                ; encoding: [0xff,0x00,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16 v255, v1 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v255, v1 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdd,0xd5,0xe9,0x00,0x00,0x00,0x01,0x77,0x39,0x05]

v_trunc_f16 v255, v1 quad_perm:[3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v255, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f16 v255, v127
// GFX11: v_trunc_f16_e64 v255, v127              ; encoding: [0xff,0x00,0xdd,0xd5,0x7f,0x01,0x00,0x00]

v_trunc_f16 v255, v127 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v255, v127 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0xff,0x00,0xdd,0xd5,0xe9,0x00,0x00,0x00,0x7f,0x77,0x39,0x05]

v_trunc_f16 v255, v127 quad_perm:[3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v255, v127 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0xff,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x7f,0x1b,0x00,0xff]

v_trunc_f16 v255, vcc_hi
// GFX11: v_trunc_f16_e64 v255, vcc_hi            ; encoding: [0xff,0x00,0xdd,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f16 v255, vcc_lo
// GFX11: v_trunc_f16_e64 v255, vcc_lo            ; encoding: [0xff,0x00,0xdd,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f16 v5, v199
// GFX11: v_trunc_f16_e64 v5, v199                ; encoding: [0x05,0x00,0xdd,0xd5,0xc7,0x01,0x00,0x00]

v_trunc_f16 v5, v199 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v5, v199 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x05,0x00,0xdd,0xd5,0xe9,0x00,0x00,0x00,0xc7,0x77,0x39,0x05]

v_trunc_f16 v5, v199 quad_perm:[3,2,1,0]
// GFX11: v_trunc_f16_e64_dpp v5, v199 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0xc7,0x1b,0x00,0xff]
