; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare { i64, i1 } @llvm.umul.with.overflow.i64(i64, i64)
declare { i8, i1 } @llvm.umul.with.overflow.i8(i8, i8)
declare { i1, i1 } @llvm.umul.with.overflow.i1(i1, i1)
declare { <2 x i1>, <2 x i1> } @llvm.umul.with.overflow.v2i1(<2 x i1>, <2 x i1>)

define i1 @test_generic(i64 %a, i64 %b) {
; CHECK-LABEL: @test_generic(
; CHECK-NEXT:    [[RES:%.*]] = tail call { i64, i1 } @llvm.umul.with.overflow.i64(i64 [[A:%.*]], i64 [[B:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i64, i1 } [[RES]], 1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i64, i1 } @llvm.umul.with.overflow.i64(i64 %a, i64 %b)
  %overflow = extractvalue { i64, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant0(i8 %a) {
; CHECK-LABEL: @test_constant0(
; CHECK-NEXT:    ret i1 false
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 0)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant1(i8 %a) {
; CHECK-LABEL: @test_constant1(
; CHECK-NEXT:    ret i1 false
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 1)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant2(i8 %a) {
; CHECK-LABEL: @test_constant2(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp slt i8 [[A:%.*]], 0
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 2)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant3(i8 %a) {
; CHECK-LABEL: @test_constant3(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i8 [[A:%.*]], 85
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 3)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant4(i8 %a) {
; CHECK-LABEL: @test_constant4(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i8 [[A:%.*]], 63
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 4)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}


define i1 @test_constant127(i8 %a) {
; CHECK-LABEL: @test_constant127(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i8 [[A:%.*]], 2
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 127)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant128(i8 %a) {
; CHECK-LABEL: @test_constant128(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i8 [[A:%.*]], 1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 128)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @test_constant255(i8 %a) {
; CHECK-LABEL: @test_constant255(
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i8 [[A:%.*]], 1
; CHECK-NEXT:    ret i1 [[OVERFLOW]]
;
  %res = tail call { i8, i1 } @llvm.umul.with.overflow.i8(i8 %a, i8 255)
  %overflow = extractvalue { i8, i1 } %res, 1
  ret i1 %overflow
}

define i1 @i1_res(i1 %x, i1 %y) {
; CHECK-LABEL: @i1_res(
; CHECK-NEXT:    [[M:%.*]] = and i1 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[M]]
;
  %m = call {i1, i1} @llvm.umul.with.overflow.i1(i1 %x, i1 %y)
  %r = extractvalue {i1, i1} %m, 0
  ret i1 %r
}

define <2 x i1> @v2i1_res(<2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @v2i1_res(
; CHECK-NEXT:    [[M:%.*]] = and <2 x i1> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[M]]
;
  %m = call {<2 x i1>, <2 x i1>} @llvm.umul.with.overflow.v2i1(<2 x i1> %x, <2 x i1> %y)
  %r = extractvalue {<2 x i1>, <2 x i1>} %m, 0
  ret <2 x i1> %r
}

define i1 @i1_res_by_one(i1 %x) {
; CHECK-LABEL: @i1_res_by_one(
; CHECK-NEXT:    ret i1 [[X:%.*]]
;
  %m = call {i1, i1} @llvm.umul.with.overflow.i1(i1 %x, i1 1)
  %r = extractvalue {i1, i1} %m, 0
  ret i1 %r
}

define <2 x i1> @v2i1_res_by_one(<2 x i1> %x) {
; CHECK-LABEL: @v2i1_res_by_one(
; CHECK-NEXT:    ret <2 x i1> [[X:%.*]]
;
  %m = call {<2 x i1>, <2 x i1>} @llvm.umul.with.overflow.v2i1(<2 x i1> %x, <2 x i1> <i1 1, i1 1>)
  %r = extractvalue {<2 x i1>, <2 x i1>} %m, 0
  ret <2 x i1> %r
}

define i1 @i1_ov(i1 %x, i1 %y) {
; CHECK-LABEL: @i1_ov(
; CHECK-NEXT:    ret i1 false
;
  %m = call {i1, i1} @llvm.umul.with.overflow.i1(i1 %x, i1 %y)
  %ov = extractvalue {i1, i1} %m, 1
  ret i1 %ov
}

define <2 x i1> @v2i1_ov(<2 x i1> %x, <2 x i1> %y) {
; CHECK-LABEL: @v2i1_ov(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %m = call {<2 x i1>, <2 x i1>} @llvm.umul.with.overflow.v2i1(<2 x i1> %x, <2 x i1> %y)
  %ov = extractvalue {<2 x i1>, <2 x i1>} %m, 1
  ret <2 x i1> %ov
}

define i1 @i1_ov_by_one(i1 %x) {
; CHECK-LABEL: @i1_ov_by_one(
; CHECK-NEXT:    ret i1 false
;
  %m = call {i1, i1} @llvm.umul.with.overflow.i1(i1 %x, i1 1)
  %ov = extractvalue {i1, i1} %m, 1
  ret i1 %ov
}

define <2 x i1> @v2i1_ov_by_one(<2 x i1> %x) {
; CHECK-LABEL: @v2i1_ov_by_one(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %m = call {<2 x i1>, <2 x i1>} @llvm.umul.with.overflow.v2i1(<2 x i1> %x, <2 x i1> <i1 1, i1 1>)
  %ov = extractvalue {<2 x i1>, <2 x i1>} %m, 1
  ret <2 x i1> %ov
}
