; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=riscv32 -global-isel -mattr=+d -stop-after=legalizer -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK %s

define i64 @double_to_i64(double %a) {
  ; CHECK-LABEL: name: double_to_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $f10_d
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $f10_d
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[COPY]](s64)
  ; CHECK-NEXT:   $x10 = COPY [[UV]](s32)
  ; CHECK-NEXT:   $x11 = COPY [[UV1]](s32)
  ; CHECK-NEXT:   PseudoRET implicit $x10, implicit $x11
  %1 = bitcast double %a to i64
  ret i64 %1
}

define double @i64_to_double(i64 %a) {
  ; CHECK-LABEL: name: i64_to_double
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x10, $x11
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK-NEXT:   $f10_d = COPY [[MV]](s64)
  ; CHECK-NEXT:   PseudoRET implicit $f10_d
  %1 = bitcast i64 %a to double
  ret double %1
}
