; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 -mattr=+sve2 | FileCheck %s

define i64 @smlsl_i64(i64 %a, i32 %b, i32 %c, i32 %d, i32 %e) {
; CHECK-LABEL: smlsl_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smsubl x8, w4, w3, x0
; CHECK-NEXT:    smsubl x0, w2, w1, x8
; CHECK-NEXT:    ret
  %be = sext i32 %b to i64
  %ce = sext i32 %c to i64
  %de = sext i32 %d to i64
  %ee = sext i32 %e to i64
  %m1.neg = mul nsw i64 %ce, %be
  %m2.neg = mul nsw i64 %ee, %de
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 %a, %reass.add
  ret i64 %s2
}

define i64 @umlsl_i64(i64 %a, i32 %b, i32 %c, i32 %d, i32 %e) {
; CHECK-LABEL: umlsl_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umsubl x8, w4, w3, x0
; CHECK-NEXT:    umsubl x0, w2, w1, x8
; CHECK-NEXT:    ret
  %be = zext i32 %b to i64
  %ce = zext i32 %c to i64
  %de = zext i32 %d to i64
  %ee = zext i32 %e to i64
  %m1.neg = mul nuw i64 %ce, %be
  %m2.neg = mul nuw i64 %ee, %de
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 %a, %reass.add
  ret i64 %s2
}

define i64 @mls_i64(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mls_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    msub x8, x4, x3, x0
; CHECK-NEXT:    msub x0, x2, x1, x8
; CHECK-NEXT:    ret
  %m1.neg = mul i64 %c, %b
  %m2.neg = mul i64 %e, %d
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 %a, %reass.add
  ret i64 %s2
}

define i16 @mls_i16(i16 %a, i16 %b, i16 %c, i16 %d, i16 %e) {
; CHECK-LABEL: mls_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    msub w8, w4, w3, w0
; CHECK-NEXT:    msub w0, w2, w1, w8
; CHECK-NEXT:    ret
  %m1.neg = mul i16 %c, %b
  %m2.neg = mul i16 %e, %d
  %reass.add = add i16 %m2.neg, %m1.neg
  %s2 = sub i16 %a, %reass.add
  ret i16 %s2
}

define i64 @mla_i64(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mla_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x4, x3
; CHECK-NEXT:    madd x8, x2, x1, x8
; CHECK-NEXT:    add x0, x8, x0
; CHECK-NEXT:    ret
  %m1 = mul i64 %c, %b
  %m2 = mul i64 %e, %d
  %s1 = add i64 %m1, %m2
  %s2 = add i64 %s1, %a
  ret i64 %s2
}

define i64 @mls_i64_C(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mls_i64_C:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x2, x1
; CHECK-NEXT:    mov w9, #10 // =0xa
; CHECK-NEXT:    madd x8, x4, x3, x8
; CHECK-NEXT:    sub x0, x9, x8
; CHECK-NEXT:    ret
  %m1.neg = mul i64 %c, %b
  %m2.neg = mul i64 %e, %d
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 10, %reass.add
  ret i64 %s2
}

define i64 @umlsl_i64_muls(i64 %a, i32 %b, i32 %c, i32 %d, i32 %e) {
; CHECK-LABEL: umlsl_i64_muls:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umull x8, w2, w3
; CHECK-NEXT:    umsubl x8, w4, w3, x8
; CHECK-NEXT:    umsubl x0, w2, w1, x8
; CHECK-NEXT:    ret
  %be = zext i32 %b to i64
  %ce = zext i32 %c to i64
  %de = zext i32 %d to i64
  %ee = zext i32 %e to i64
  %m1.neg = mul nuw i64 %ce, %be
  %m2.neg = mul nuw i64 %ee, %de
  %m3 = mul nuw i64 %ce, %de
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 %m3, %reass.add
  ret i64 %s2
}

define i64 @umlsl_i64_uses(i64 %a, i32 %b, i32 %c, i32 %d, i32 %e) {
; CHECK-LABEL: umlsl_i64_uses:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umull x8, w4, w3
; CHECK-NEXT:    umaddl x8, w2, w1, x8
; CHECK-NEXT:    sub x9, x0, x8
; CHECK-NEXT:    and x0, x8, x9
; CHECK-NEXT:    ret
  %be = zext i32 %b to i64
  %ce = zext i32 %c to i64
  %de = zext i32 %d to i64
  %ee = zext i32 %e to i64
  %m1.neg = mul nuw i64 %ce, %be
  %m2.neg = mul nuw i64 %ee, %de
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = sub i64 %a, %reass.add
  %o = and i64 %reass.add, %s2
  ret i64 %o
}

define i64 @mla_i64_C(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mla_i64_C:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x2, x1
; CHECK-NEXT:    madd x8, x4, x3, x8
; CHECK-NEXT:    add x0, x8, #10
; CHECK-NEXT:    ret
  %m1.neg = mul i64 %c, %b
  %m2.neg = mul i64 %e, %d
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = add i64 10, %reass.add
  ret i64 %s2
}

define i64 @mla_i64_uses(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mla_i64_uses:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x2, x1
; CHECK-NEXT:    madd x8, x4, x3, x8
; CHECK-NEXT:    add x9, x0, x8
; CHECK-NEXT:    eor x0, x8, x9
; CHECK-NEXT:    ret
  %m1.neg = mul i64 %c, %b
  %m2.neg = mul i64 %e, %d
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = add i64 %a, %reass.add
  %o = xor i64 %reass.add, %s2
  ret i64 %o
}

define i64 @mla_i64_mul(i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) {
; CHECK-LABEL: mla_i64_mul:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x2, x1
; CHECK-NEXT:    madd x9, x4, x3, x8
; CHECK-NEXT:    add x0, x8, x9
; CHECK-NEXT:    ret
  %m1.neg = mul i64 %c, %b
  %m2.neg = mul i64 %e, %d
  %reass.add = add i64 %m2.neg, %m1.neg
  %s2 = add i64 %m1.neg, %reass.add
  ret i64 %s2
}


define <8 x i16> @smlsl_v8i16(<8 x i16> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d, <8 x i8> %e) {
; CHECK-LABEL: smlsl_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smlsl v0.8h, v4.8b, v3.8b
; CHECK-NEXT:    smlsl v0.8h, v2.8b, v1.8b
; CHECK-NEXT:    ret
  %be = sext <8 x i8> %b to <8 x i16>
  %ce = sext <8 x i8> %c to <8 x i16>
  %de = sext <8 x i8> %d to <8 x i16>
  %ee = sext <8 x i8> %e to <8 x i16>
  %m1.neg = mul nsw <8 x i16> %ce, %be
  %m2.neg = mul nsw <8 x i16> %ee, %de
  %reass.add = add <8 x i16> %m2.neg, %m1.neg
  %s2 = sub <8 x i16> %a, %reass.add
  ret <8 x i16> %s2
}

define <8 x i16> @umlsl_v8i16(<8 x i16> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d, <8 x i8> %e) {
; CHECK-LABEL: umlsl_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umlsl v0.8h, v4.8b, v3.8b
; CHECK-NEXT:    umlsl v0.8h, v2.8b, v1.8b
; CHECK-NEXT:    ret
  %be = zext <8 x i8> %b to <8 x i16>
  %ce = zext <8 x i8> %c to <8 x i16>
  %de = zext <8 x i8> %d to <8 x i16>
  %ee = zext <8 x i8> %e to <8 x i16>
  %m1.neg = mul nuw <8 x i16> %ce, %be
  %m2.neg = mul nuw <8 x i16> %ee, %de
  %reass.add = add <8 x i16> %m2.neg, %m1.neg
  %s2 = sub <8 x i16> %a, %reass.add
  ret <8 x i16> %s2
}

define <8 x i16> @mls_v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: mls_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mls v0.8h, v4.8h, v3.8h
; CHECK-NEXT:    mls v0.8h, v2.8h, v1.8h
; CHECK-NEXT:    ret
  %m1.neg = mul <8 x i16> %c, %b
  %m2.neg = mul <8 x i16> %e, %d
  %reass.add = add <8 x i16> %m2.neg, %m1.neg
  %s2 = sub <8 x i16> %a, %reass.add
  ret <8 x i16> %s2
}

define <8 x i16> @mla_v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: mla_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul v3.8h, v4.8h, v3.8h
; CHECK-NEXT:    mla v3.8h, v2.8h, v1.8h
; CHECK-NEXT:    add v0.8h, v3.8h, v0.8h
; CHECK-NEXT:    ret
  %m1 = mul <8 x i16> %c, %b
  %m2 = mul <8 x i16> %e, %d
  %s1 = add <8 x i16> %m1, %m2
  %s2 = add <8 x i16> %s1, %a
  ret <8 x i16> %s2
}

define <8 x i16> @mls_v8i16_C(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: mls_v8i16_C:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v0.8h, #10
; CHECK-NEXT:    mls v0.8h, v4.8h, v3.8h
; CHECK-NEXT:    mls v0.8h, v2.8h, v1.8h
; CHECK-NEXT:    ret
  %m1.neg = mul <8 x i16> %c, %b
  %m2.neg = mul <8 x i16> %e, %d
  %reass.add = add <8 x i16> %m2.neg, %m1.neg
  %s2 = sub <8 x i16> <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>, %reass.add
  ret <8 x i16> %s2
}

define <8 x i16> @mla_v8i16_C(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d, <8 x i16> %e) {
; CHECK-LABEL: mla_v8i16_C:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul v1.8h, v2.8h, v1.8h
; CHECK-NEXT:    movi v0.8h, #10
; CHECK-NEXT:    mla v1.8h, v4.8h, v3.8h
; CHECK-NEXT:    add v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %m1.neg = mul <8 x i16> %c, %b
  %m2.neg = mul <8 x i16> %e, %d
  %reass.add = add <8 x i16> %m2.neg, %m1.neg
  %s2 = add <8 x i16> <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>, %reass.add
  ret <8 x i16> %s2
}


define <vscale x 8 x i16> @smlsl_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i8> %b, <vscale x 8 x i8> %c, <vscale x 8 x i8> %d, <vscale x 8 x i8> %e) {
; CHECK-LABEL: smlsl_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sxtb z3.h, p0/m, z3.h
; CHECK-NEXT:    sxtb z4.h, p0/m, z4.h
; CHECK-NEXT:    sxtb z1.h, p0/m, z1.h
; CHECK-NEXT:    sxtb z2.h, p0/m, z2.h
; CHECK-NEXT:    mls z0.h, p0/m, z4.h, z3.h
; CHECK-NEXT:    mls z0.h, p0/m, z2.h, z1.h
; CHECK-NEXT:    ret
  %be = sext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %ce = sext <vscale x 8 x i8> %c to <vscale x 8 x i16>
  %de = sext <vscale x 8 x i8> %d to <vscale x 8 x i16>
  %ee = sext <vscale x 8 x i8> %e to <vscale x 8 x i16>
  %m1.neg = mul nsw <vscale x 8 x i16> %ce, %be
  %m2.neg = mul nsw <vscale x 8 x i16> %ee, %de
  %reass.add = add <vscale x 8 x i16> %m2.neg, %m1.neg
  %s2 = sub <vscale x 8 x i16> %a, %reass.add
  ret <vscale x 8 x i16> %s2
}

define <vscale x 8 x i16> @umlsl_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i8> %b, <vscale x 8 x i8> %c, <vscale x 8 x i8> %d, <vscale x 8 x i8> %e) {
; CHECK-LABEL: umlsl_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z3.h, z3.h, #0xff
; CHECK-NEXT:    and z4.h, z4.h, #0xff
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    and z2.h, z2.h, #0xff
; CHECK-NEXT:    mls z0.h, p0/m, z4.h, z3.h
; CHECK-NEXT:    mls z0.h, p0/m, z2.h, z1.h
; CHECK-NEXT:    ret
  %be = zext <vscale x 8 x i8> %b to <vscale x 8 x i16>
  %ce = zext <vscale x 8 x i8> %c to <vscale x 8 x i16>
  %de = zext <vscale x 8 x i8> %d to <vscale x 8 x i16>
  %ee = zext <vscale x 8 x i8> %e to <vscale x 8 x i16>
  %m1.neg = mul nuw <vscale x 8 x i16> %ce, %be
  %m2.neg = mul nuw <vscale x 8 x i16> %ee, %de
  %reass.add = add <vscale x 8 x i16> %m2.neg, %m1.neg
  %s2 = sub <vscale x 8 x i16> %a, %reass.add
  ret <vscale x 8 x i16> %s2
}

define <vscale x 8 x i16> @mls_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, <vscale x 8 x i16> %c, <vscale x 8 x i16> %d, <vscale x 8 x i16> %e) {
; CHECK-LABEL: mls_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mls z0.h, p0/m, z4.h, z3.h
; CHECK-NEXT:    mls z0.h, p0/m, z2.h, z1.h
; CHECK-NEXT:    ret
  %m1.neg = mul <vscale x 8 x i16> %c, %b
  %m2.neg = mul <vscale x 8 x i16> %e, %d
  %reass.add = add <vscale x 8 x i16> %m2.neg, %m1.neg
  %s2 = sub <vscale x 8 x i16> %a, %reass.add
  ret <vscale x 8 x i16> %s2
}

define <vscale x 8 x i16> @mla_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, <vscale x 8 x i16> %c, <vscale x 8 x i16> %d, <vscale x 8 x i16> %e) {
; CHECK-LABEL: mla_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul z1.h, z2.h, z1.h
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mla z1.h, p0/m, z4.h, z3.h
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    ret
  %m1 = mul <vscale x 8 x i16> %c, %b
  %m2 = mul <vscale x 8 x i16> %e, %d
  %s1 = add <vscale x 8 x i16> %m1, %m2
  %s2 = add <vscale x 8 x i16> %s1, %a
  ret <vscale x 8 x i16> %s2
}
