; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

define i32 @slt_trip_count_with_range(ptr %ptr0, ptr %ptr1) {
;
; CHECK-LABEL: 'slt_trip_count_with_range'
; CHECK-NEXT:  Determining loop execution counts for: @slt_trip_count_with_range
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 98
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  %limit = load i32, ptr %ptr0, !range !0
  br label %loop

 loop:
  %index = phi i32 [ 0, %entry ], [ %index.inc, %loop ]
  %index.inc = add i32 %index, 1
  %continue = icmp slt i32 %index.inc, %limit
  br i1 %continue, label %loop, label %loop.exit

 loop.exit:
  ret i32 0
}

define i32 @ult_trip_count_with_range(ptr %ptr0, ptr %ptr1) {
;
; CHECK-LABEL: 'ult_trip_count_with_range'
; CHECK-NEXT:  Determining loop execution counts for: @ult_trip_count_with_range
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 98
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  %limit = load i32, ptr %ptr0, !range !0
  br label %loop

 loop:
  %index = phi i32 [ 0, %entry ], [ %index.inc, %loop ]
  %index.inc = add i32 %index, 1
  %continue = icmp ult i32 %index.inc, %limit
  br i1 %continue, label %loop, label %loop.exit

 loop.exit:
  ret i32 0
}

!0 = !{i32 1, i32 100}
