; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;; For `double` parameters and return values, compiling on loongarch32 with `-mattr=+d` and
;; `-target-abi=ilp32s` is incompatible, resulting in the error 'Passing f64 with GPR on LA32 is undefined'.
;; Therefore, such case is currently skipped in testing.
; RUN: llc -mtriple=loongarch32 -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA32
; RUN: llc -mtriple=loongarch64 -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA64
; RUN: llc -mtriple=loongarch32 -mattr=+f -target-abi=ilp32s -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA32F-ILP32S
; RUN: llc -mtriple=loongarch32 -mattr=+f -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA32F-ILP32D
; RUN: llc -mtriple=loongarch32 -mattr=+d -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA32D-ILP32D
; RUN: llc -mtriple=loongarch64 -mattr=+f -target-abi=lp64s -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA64F-LP64S
; RUN: llc -mtriple=loongarch64 -mattr=+f -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s -check-prefix=LA64F-LP64D
; RUN: llc -mtriple=loongarch64 -mattr=+d -target-abi=lp64s -verify-machineinstrs < %s  | FileCheck %s -check-prefix=LA64D-LP64S
; RUN: llc -mtriple=loongarch64 -mattr=+d -target-abi=lp64d -verify-machineinstrs < %s  | FileCheck %s -check-prefix=LA64D-LP64D

define bfloat @float_to_bfloat(float %a) nounwind {
; LA32-LABEL: float_to_bfloat:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl __truncsfbf2
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: float_to_bfloat:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64-NEXT:    jirl $ra, $ra, 0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    lu12i.w $a1, -16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: float_to_bfloat:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    bl __truncsfbf2
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: float_to_bfloat:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    bl __truncsfbf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: float_to_bfloat:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    bl __truncsfbf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: float_to_bfloat:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: float_to_bfloat:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: float_to_bfloat:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: float_to_bfloat:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64D-NEXT:    ret
  %1 = fptrunc float %a to bfloat
  ret bfloat %1
}

define bfloat @double_to_bfloat(double %a) nounwind {
; LA32-LABEL: double_to_bfloat:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl __truncdfbf2
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: double_to_bfloat:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(__truncdfbf2)
; LA64-NEXT:    jirl $ra, $ra, 0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    lu12i.w $a1, -16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: double_to_bfloat:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    bl __truncdfbf2
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: double_to_bfloat:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    bl __truncdfbf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: double_to_bfloat:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    bl __truncdfbf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: double_to_bfloat:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncdfbf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: double_to_bfloat:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncdfbf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: double_to_bfloat:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncdfbf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: double_to_bfloat:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncdfbf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64D-NEXT:    ret
  %1 = fptrunc double %a to bfloat
  ret bfloat %1
}

define float @bfloat_to_float(bfloat %a) nounwind {
; LA32-LABEL: bfloat_to_float:
; LA32:       # %bb.0:
; LA32-NEXT:    slli.w $a0, $a0, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_to_float:
; LA64:       # %bb.0:
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_to_float:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_to_float:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_to_float:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_to_float:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_to_float:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_to_float:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_to_float:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ret
  %1 = fpext bfloat %a to float
  ret float %1
}

define double @bfloat_to_double(bfloat %a) nounwind {
; LA32-LABEL: bfloat_to_double:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    slli.w $a0, $a0, 16
; LA32-NEXT:    bl __extendsfdf2
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_to_double:
; LA64:       # %bb.0:
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    fcvt.d.s $fa0, $fa0
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_to_double:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32S-NEXT:    bl __extendsfdf2
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_to_double:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    bl __extendsfdf2
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_to_double:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    fcvt.d.s $fa0, $fa0
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_to_double:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    fcvt.d.s $fa0, $fa0
; LA64F-LP64S-NEXT:    movfr2gr.d $a0, $fa0
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_to_double:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    fcvt.d.s $fa0, $fa0
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_to_double:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    fcvt.d.s $fa0, $fa0
; LA64D-LP64S-NEXT:    movfr2gr.d $a0, $fa0
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_to_double:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    fcvt.d.s $fa0, $fa0
; LA64D-LP64D-NEXT:    ret
  %1 = fpext bfloat %a to double
  ret double %1
}

define bfloat @i16_to_bfloat(i16 %a) nounwind {
; LA32-LABEL: i16_to_bfloat:
; LA32:       # %bb.0:
; LA32-NEXT:    ret
;
; LA64-LABEL: i16_to_bfloat:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, -16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: i16_to_bfloat:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: i16_to_bfloat:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: i16_to_bfloat:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: i16_to_bfloat:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: i16_to_bfloat:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: i16_to_bfloat:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: i16_to_bfloat:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ret
  %1 = bitcast i16 %a to bfloat
  ret bfloat %1
}

define i16 @bfloat_to_i16(bfloat %a) nounwind {
; LA32-LABEL: bfloat_to_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_to_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_to_i16:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_to_i16:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_to_i16:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_to_i16:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_to_i16:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_to_i16:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_to_i16:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    ret
  %1 = bitcast bfloat %a to i16
  ret i16 %1
}

define bfloat @bfloat_add(bfloat %a, bfloat %b) nounwind {
; LA32-LABEL: bfloat_add:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    slli.w $a0, $a0, 16
; LA32-NEXT:    slli.w $a1, $a1, 16
; LA32-NEXT:    bl __addsf3
; LA32-NEXT:    bl __truncsfbf2
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_add:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    movfr2gr.s $a1, $fa1
; LA64-NEXT:    slli.d $a1, $a1, 16
; LA64-NEXT:    movgr2fr.w $fa0, $a1
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    movgr2fr.w $fa1, $a0
; LA64-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64-NEXT:    jirl $ra, $ra, 0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    lu12i.w $a1, -16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_add:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    slli.w $a1, $a1, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a1
; LA32F-ILP32S-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32S-NEXT:    bl __truncsfbf2
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_add:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    movfr2gr.s $a1, $fa1
; LA32F-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32F-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32D-NEXT:    bl __truncsfbf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_add:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    movfr2gr.s $a1, $fa1
; LA32D-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32D-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-ILP32D-NEXT:    bl __truncsfbf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_add:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    slli.d $a1, $a1, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a1
; LA64F-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_add:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    movfr2gr.s $a1, $fa1
; LA64F-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64F-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_add:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    slli.d $a1, $a1, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a1
; LA64D-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_add:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    movfr2gr.s $a1, $fa1
; LA64D-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64D-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64D-NEXT:    ret
  %1 = fadd bfloat %a, %b
  ret bfloat %1
}

define bfloat @bfloat_load(ptr %a) nounwind {
; LA32-LABEL: bfloat_load:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    ld.h $a1, $a0, 0
; LA32-NEXT:    ld.h $a2, $a0, 6
; LA32-NEXT:    slli.w $a0, $a1, 16
; LA32-NEXT:    slli.w $a1, $a2, 16
; LA32-NEXT:    bl __addsf3
; LA32-NEXT:    bl __truncsfbf2
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_load:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    ld.hu $a1, $a0, 6
; LA64-NEXT:    ld.hu $a0, $a0, 0
; LA64-NEXT:    slli.d $a1, $a1, 16
; LA64-NEXT:    movgr2fr.w $fa0, $a1
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    movgr2fr.w $fa1, $a0
; LA64-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64-NEXT:    jirl $ra, $ra, 0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    lu12i.w $a1, -16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    movgr2fr.w $fa0, $a0
; LA64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_load:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    ld.hu $a1, $a0, 6
; LA32F-ILP32S-NEXT:    ld.hu $a0, $a0, 0
; LA32F-ILP32S-NEXT:    slli.w $a1, $a1, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a1
; LA32F-ILP32S-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32S-NEXT:    bl __truncsfbf2
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_load:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    ld.hu $a1, $a0, 6
; LA32F-ILP32D-NEXT:    ld.hu $a0, $a0, 0
; LA32F-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32F-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32D-NEXT:    bl __truncsfbf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_load:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    ld.hu $a1, $a0, 6
; LA32D-ILP32D-NEXT:    ld.hu $a0, $a0, 0
; LA32D-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32D-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-ILP32D-NEXT:    bl __truncsfbf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_load:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    ld.hu $a1, $a0, 6
; LA64F-LP64S-NEXT:    ld.hu $a0, $a0, 0
; LA64F-LP64S-NEXT:    slli.d $a1, $a1, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a1
; LA64F-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_load:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    ld.hu $a1, $a0, 6
; LA64F-LP64D-NEXT:    ld.hu $a0, $a0, 0
; LA64F-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64F-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_load:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    ld.hu $a1, $a0, 6
; LA64D-LP64S-NEXT:    ld.hu $a0, $a0, 0
; LA64D-LP64S-NEXT:    slli.d $a1, $a1, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a1
; LA64D-LP64S-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_load:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    ld.hu $a1, $a0, 6
; LA64D-LP64D-NEXT:    ld.hu $a0, $a0, 0
; LA64D-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64D-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64D-NEXT:    ret
  %1 = load bfloat, ptr %a
  %2 = getelementptr bfloat, ptr %a, i32 3
  %3 = load bfloat, ptr %2
  %4 = fadd bfloat %1, %3
  ret bfloat %4
}

define void @bfloat_store(ptr %a, bfloat %b, bfloat %c) nounwind {
; LA32-LABEL: bfloat_store:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32-NEXT:    move $fp, $a0
; LA32-NEXT:    slli.w $a0, $a1, 16
; LA32-NEXT:    slli.w $a1, $a2, 16
; LA32-NEXT:    bl __addsf3
; LA32-NEXT:    bl __truncsfbf2
; LA32-NEXT:    st.h $a0, $fp, 0
; LA32-NEXT:    st.h $a0, $fp, 16
; LA32-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: bfloat_store:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; LA64-NEXT:    move $fp, $a0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    movfr2gr.s $a1, $fa1
; LA64-NEXT:    slli.d $a1, $a1, 16
; LA64-NEXT:    movgr2fr.w $fa0, $a1
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    movgr2fr.w $fa1, $a0
; LA64-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64-NEXT:    jirl $ra, $ra, 0
; LA64-NEXT:    movfr2gr.s $a0, $fa0
; LA64-NEXT:    st.h $a0, $fp, 0
; LA64-NEXT:    st.h $a0, $fp, 16
; LA64-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; LA64-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
;
; LA32F-ILP32S-LABEL: bfloat_store:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    move $fp, $a0
; LA32F-ILP32S-NEXT:    slli.w $a0, $a2, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32S-NEXT:    slli.w $a0, $a1, 16
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32S-NEXT:    bl __truncsfbf2
; LA32F-ILP32S-NEXT:    st.h $a0, $fp, 0
; LA32F-ILP32S-NEXT:    st.h $a0, $fp, 16
; LA32F-ILP32S-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: bfloat_store:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    move $fp, $a0
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    movfr2gr.s $a1, $fa1
; LA32F-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32F-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32F-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32D-NEXT:    bl __truncsfbf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    st.h $a0, $fp, 0
; LA32F-ILP32D-NEXT:    st.h $a0, $fp, 16
; LA32F-ILP32D-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32D-LABEL: bfloat_store:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    move $fp, $a0
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    movfr2gr.s $a1, $fa1
; LA32D-ILP32D-NEXT:    slli.w $a1, $a1, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a1
; LA32D-ILP32D-NEXT:    slli.w $a0, $a0, 16
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; LA32D-ILP32D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-ILP32D-NEXT:    bl __truncsfbf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    st.h $a0, $fp, 0
; LA32D-ILP32D-NEXT:    st.h $a0, $fp, 16
; LA32D-ILP32D-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32D-NEXT:    ret
;
; LA64F-LP64S-LABEL: bfloat_store:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    move $fp, $a0
; LA64F-LP64S-NEXT:    slli.d $a0, $a2, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    slli.d $a0, $a1, 16
; LA64F-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    st.h $a0, $fp, 0
; LA64F-LP64S-NEXT:    st.h $a0, $fp, 16
; LA64F-LP64S-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: bfloat_store:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    move $fp, $a0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    movfr2gr.s $a1, $fa1
; LA64F-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64F-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64F-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64F-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    st.h $a0, $fp, 0
; LA64F-LP64D-NEXT:    st.h $a0, $fp, 16
; LA64F-LP64D-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: bfloat_store:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    move $fp, $a0
; LA64D-LP64S-NEXT:    slli.d $a0, $a2, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    slli.d $a0, $a1, 16
; LA64D-LP64S-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    st.h $a0, $fp, 0
; LA64D-LP64S-NEXT:    st.h $a0, $fp, 16
; LA64D-LP64S-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: bfloat_store:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -16
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    st.d $fp, $sp, 0 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    move $fp, $a0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    movfr2gr.s $a1, $fa1
; LA64D-LP64D-NEXT:    slli.d $a1, $a1, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a1
; LA64D-LP64D-NEXT:    slli.d $a0, $a0, 16
; LA64D-LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LA64D-LP64D-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfbf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    st.h $a0, $fp, 0
; LA64D-LP64D-NEXT:    st.h $a0, $fp, 16
; LA64D-LP64D-NEXT:    ld.d $fp, $sp, 0 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 16
; LA64D-LP64D-NEXT:    ret
  %1 = fadd bfloat %b, %c
  store bfloat %1, ptr %a
  %2 = getelementptr bfloat, ptr %a, i32 8
  store bfloat %1, ptr %2
  ret void
}
