# A LaTeX template for a journal rebuttal letter (response to editors/reviewers)
[![CTAN](https://img.shields.io/ctan/v/jourrr.svg)](https://ctan.org/pkg/jourrr)
![GitHub repo size](https://img.shields.io/github/repo-size/firefly-cpp/latex-response-reviewers?style=flat-square)
[![GitHub license](https://img.shields.io/github/license/firefly-cpp/latex-response-reviewers.svg)](https://github.com/firefly-cpp/latex-response-reviewers/blob/master/LICENSE)
[![All Contributors](https://img.shields.io/badge/all_contributors-2-orange.svg?style=flat-square)](#contributors-)

## About

The repository hosts a template for writing responses to editors'/reviewers' comments for journal submissions written in LaTex that is minimalistic in one way while pre-defined with several commands that drastically speed up the process of preparing letters during the revision process.

### Main Features of this template:
- With front page included
- **Response ticks** to mark as completed
- Custom response color 
- Minimalistic design
- Everything is customizable
- Predefined commands for a journal name, submission ID, author, editor, associate editor, date, etc.
- Many macros included
- Predefined different valedictions for different types of submissions (e.g., Yours sincerely, Yours faithfully, Best regards, etc.)
- Custom greeting (e.g., "Dear Editor" or "Dear Editor-in-Chief" for regular submission, etc.)
- (Optional) Table of contents, jump to the reply you wish to address
- Option to add custom Signature (i.e. an image of your hand-written signature)


## Download/Install

Please install the `jourrr` package through the package manager of your TeX distribution or download it directly from: [CTAN](https://www.ctan.org/pkg/jourrr).

## Related templates

[A cover letter template for a journal paper submission in LaTex](https://github.com/firefly-cpp/cover-letter-latex)

# Disclaimer
This software is provided as-is, and there are no guarantees that it fits your purposes or that it is bug-free. Use it at your own risk!

## License
Material in this folder is licensed under a
[Creative Commons Attribution-ShareAlike 4.0 International License][cc-by-sa].

[![CC BY-SA 4.0][cc-by-sa-image]][cc-by-sa]

[cc-by-sa]: http://creativecommons.org/licenses/by-sa/4.0/
[cc-by-sa-image]: https://licensebuttons.net/l/by-sa/4.0/88x31.png
[cc-by-sa-shield]: https://img.shields.io/badge/License-CC%20BY--SA%204.0-lightgrey.svg

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/KukovecRok"><img src="https://avatars.githubusercontent.com/u/33880044?v=4?s=100" width="100px;" alt="Tatookie"/><br /><sub><b>Tatookie</b></sub></a><br /><a href="https://github.com/firefly-cpp/latex-response-reviewers/commits?author=KukovecRok" title="Code">💻</a> <a href="https://github.com/firefly-cpp/latex-response-reviewers/commits?author=KukovecRok" title="Documentation">📖</a> <a href="https://github.com/firefly-cpp/latex-response-reviewers/issues?q=author%3AKukovecRok" title="Bug reports">🐛</a> <a href="#example-KukovecRok" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.iztok-jr-fister.eu/"><img src="https://avatars.githubusercontent.com/u/1633361?v=4?s=100" width="100px;" alt="Iztok Fister Jr."/><br /><sub><b>Iztok Fister Jr.</b></sub></a><br /><a href="https://github.com/firefly-cpp/latex-response-reviewers/commits?author=firefly-cpp" title="Code">💻</a> <a href="#mentoring-firefly-cpp" title="Mentoring">🧑‍🏫</a> <a href="#ideas-firefly-cpp" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
