# Clean Thesis
*-- A Clean LaTeX Style for Thesis Documents --*

## Table of contents

* [About](#about)
* [Getting started](#getting-started)
* [Documentation and Support](#documentation-and-support)
* [Contributing](#contributing)
* [License Information](#license-information)

## About

**Clean, Simple, Elegant**
*Clean Thesis* is a LaTeX style for thesis documents, developed for my diploma thesis (Diplomarbeit). The style can be understood as my personal compromise — a typical clean looking scientific document combined and polished with minor beautifications.

The design of this *Clean Thesis* style is inspired by user guide documents from Apple Inc.

Note: If you are looking for an exact and correct style regarding typographic rules, please have a look at the "[Classic Thesis Style](see http://www.miede.de/#classicthesis)".

**Donation = Postcard**
Based on the idea of André Miede: If you like the *Clean Thesis* style I would be very pleased about a donation in the form of a POSTCARD. You can find my address at the *Clean Thesis* [website](http://cleanthesis.der-ric.de/) as well as in the [documentation](doc/cleanthesis-doc.pdf). I am going to collect all postcards and exhibit them at the website I mentioned.

**Idea and Inspiration**
The idea of providing my customized style for thesis documents passed through my mind while writing my own thesis. Motivated and inspired by the superb "[Classic Thesis Style](http://www.miede.de/#classicthesis)" by André Miede (thanks to André for doing a great job) I decided to collect all design and style related functionality in a separate LaTeX style and provide this style to other thesis writers.

## Getting started

* Make sure you have an up-to-date TeX distribution
* Download the latest [release](https://github.com/derric/cleanthesis/releases) or clone the repository with `git clone https://github.com/derric/cleanthesis.git`
* Check out the included [example thesis](my-thesis.tex)
* [Read the documentation](doc/cleanthesis-doc.pdf) to learn more about *Clean Thesis* and available package options

## Documentation and Support

The [documentation](doc/cleanthesis-doc.pdf) gives an overview of available package options.

Please ask **questions** or start **discussions** about *Clean Thesis* at [Stack Exchange](http://tex.stackexchange.com/questions/tagged/cleanthesis) (tagged [cleanthesis](http://tex.stackexchange.com/questions/tagged/cleanthesis)). GitHub issues are for development purposes, e.g, reporting bugs or requesting new features.

## Contributing

Did you find an error or a bug? Do you have a feature request? Before opening a [new issue](https://github.com/derric/cleanthesis/issues/new), please check out the list of [existing](https://github.com/derric/cleanthesis/issues) and [closed](https://github.com/derric/cleanthesis/issues?q=is%3Aissue+is%3Aclosed) issues.

## License Information

README.md
Copyright 2019 R. Langner

This work may be distributed and/or modified under the
conditions of the LaTeX Project Public License, either version 1.3
of this license or (at your option) any later version.
The latest version of this license is in
  http://www.latex-project.org/lppl.txt
and version 1.3 or later is part of all distributions of LaTeX
version 2005/12/01 or later.

This work has the LPPL maintenance status `maintained'.

The Current Maintainer of this work is R. Langner.

This work consists of all files listed in MANIFEST.md.
