#ifndef CHATDLG_H
#define CHATDLG_H
/*
   This file is part of the KDE games kwin4 program
   Copyright (c) 2006 Martin Heni <kde@heni-online.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

// Qt includes
#include <QDialog>

class KGame;
class KGameChat;
class KChatDialog;
class KWin4Player;

/**
 * Subclass of the chat dialog provided by the KGame lib.
 * It supports a user defined chat and the setting of the
 * owner player
 **/
class ChatDlg : public QDialog
{
  Q_OBJECT

  public:
    explicit ChatDlg(KGame *game,QWidget* parent=0);

  public slots:  
    void setPlayer(KWin4Player *p);
  
  private:  
    KGameChat*   mChat;
    KChatDialog* mChatDlg;
};

#endif // CHATDLG_H

