/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class DoubleTypeDeserializer
extends AbstractNumberDeserializer<Double> {
    private static final String POSITIVE_INFINITY = "POSITIVE_INFINITY";
    private static final String NEGATIVE_INFINITY = "NEGATIVE_INFINITY";
    private static final String NAN = "NaN";

    DoubleTypeDeserializer(Customization customization) {
        super(Double.class, customization);
    }

    @Override
    protected Double deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        switch (jsonValue) {
            case "NaN": {
                return Double.NaN;
            }
            case "POSITIVE_INFINITY": {
                return Double.POSITIVE_INFINITY;
            }
            case "NEGATIVE_INFINITY": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return this.deserializeFormatted(jsonValue, false, unmarshaller.getJsonbContext()).map(num -> Double.parseDouble(num.toString())).orElseGet(() -> {
            try {
                return Double.parseDouble(jsonValue);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, Double.class));
            }
        });
    }
}

