/* automatically generated by rust-bindgen 0.72.0 */

#![allow(clippy::all)]
#![allow(improper_ctypes)]
#![allow(unused_unsafe)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(unsafe_op_in_unsafe_fn)]
#![allow(unnecessary_transmutes)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        unsafe { ::std::slice::from_raw_parts(self.as_ptr(), len) }
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        unsafe { ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len) }
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const NIR_ALU_TYPE_SIZE_MASK: u32 = 121;
pub const NIR_ALU_TYPE_BASE_TYPE_MASK: u32 = 134;
pub const NIR_DEBUG_CLONE: u32 = 1;
pub const NIR_DEBUG_SERIALIZE: u32 = 2;
pub const NIR_DEBUG_NOVALIDATE: u32 = 4;
pub const NIR_DEBUG_EXTENDED_VALIDATION: u32 = 8;
pub const NIR_DEBUG_TGSI: u32 = 16;
pub const NIR_DEBUG_PRINT_VS: u32 = 32;
pub const NIR_DEBUG_PRINT_TCS: u32 = 64;
pub const NIR_DEBUG_PRINT_TES: u32 = 128;
pub const NIR_DEBUG_PRINT_GS: u32 = 256;
pub const NIR_DEBUG_PRINT_FS: u32 = 512;
pub const NIR_DEBUG_PRINT_CS: u32 = 1024;
pub const NIR_DEBUG_PRINT_TS: u32 = 2048;
pub const NIR_DEBUG_PRINT_MS: u32 = 4096;
pub const NIR_DEBUG_PRINT_RGS: u32 = 8192;
pub const NIR_DEBUG_PRINT_AHS: u32 = 16384;
pub const NIR_DEBUG_PRINT_CHS: u32 = 32768;
pub const NIR_DEBUG_PRINT_MHS: u32 = 65536;
pub const NIR_DEBUG_PRINT_IS: u32 = 131072;
pub const NIR_DEBUG_PRINT_CBS: u32 = 262144;
pub const NIR_DEBUG_PRINT_KS: u32 = 524288;
pub const NIR_DEBUG_PRINT_NO_INLINE_CONSTS: u32 = 1048576;
pub const NIR_DEBUG_PRINT_INTERNAL: u32 = 2097152;
pub const NIR_DEBUG_PRINT_PASS_FLAGS: u32 = 4194304;
pub const NIR_DEBUG_INVALIDATE_METADATA: u32 = 8388608;
pub const NIR_DEBUG_PRINT_STRUCT_DECLS: u32 = 16777216;
pub const NIR_DEBUG_PROGRESS_VALIDATION: u32 = 33554432;
pub const NIR_DEBUG_PRINT: u32 = 1048544;
pub const NIR_FALSE: u32 = 0;
pub const NIR_TRUE: i32 = -1;
pub const NIR_MAX_VEC_COMPONENTS: u32 = 16;
pub const NIR_MAX_MATRIX_COLUMNS: u32 = 4;
pub const NIR_STREAM_PACKED: u32 = 256;
pub const NIR_VARIABLE_NO_INDEX: i32 = -1;
pub const NIR_SRC_PARENT_IS_IF: u32 = 1;
pub const NIR_ALU_MAX_INPUTS: u32 = 16;
pub const NIR_INTRINSIC_MAX_CONST_INDEX: u32 = 8;
pub const NIR_ALIGN_MUL_MAX: u32 = 1073741824;
pub const NIR_INTRINSIC_MAX_INPUTS: u32 = 11;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub _short_backupbuf: [::std::os::raw::c_char; 1usize],
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub _prevchain: *mut *mut _IO_FILE,
    pub _mode: ::std::os::raw::c_int,
    pub _unused3: ::std::os::raw::c_int,
    pub _total_written: __uint64_t,
    pub _unused2: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _IO_FILE"][::std::mem::size_of::<_IO_FILE>() - 216usize];
    ["Alignment of _IO_FILE"][::std::mem::align_of::<_IO_FILE>() - 8usize];
    ["Offset of field: _IO_FILE::_flags"][::std::mem::offset_of!(_IO_FILE, _flags) - 0usize];
    ["Offset of field: _IO_FILE::_IO_read_ptr"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_ptr) - 8usize];
    ["Offset of field: _IO_FILE::_IO_read_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_end) - 16usize];
    ["Offset of field: _IO_FILE::_IO_read_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_base) - 24usize];
    ["Offset of field: _IO_FILE::_IO_write_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_base) - 32usize];
    ["Offset of field: _IO_FILE::_IO_write_ptr"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_ptr) - 40usize];
    ["Offset of field: _IO_FILE::_IO_write_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_end) - 48usize];
    ["Offset of field: _IO_FILE::_IO_buf_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_buf_base) - 56usize];
    ["Offset of field: _IO_FILE::_IO_buf_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_buf_end) - 64usize];
    ["Offset of field: _IO_FILE::_IO_save_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_save_base) - 72usize];
    ["Offset of field: _IO_FILE::_IO_backup_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_backup_base) - 80usize];
    ["Offset of field: _IO_FILE::_IO_save_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_save_end) - 88usize];
    ["Offset of field: _IO_FILE::_markers"][::std::mem::offset_of!(_IO_FILE, _markers) - 96usize];
    ["Offset of field: _IO_FILE::_chain"][::std::mem::offset_of!(_IO_FILE, _chain) - 104usize];
    ["Offset of field: _IO_FILE::_fileno"][::std::mem::offset_of!(_IO_FILE, _fileno) - 112usize];
    ["Offset of field: _IO_FILE::_short_backupbuf"]
        [::std::mem::offset_of!(_IO_FILE, _short_backupbuf) - 119usize];
    ["Offset of field: _IO_FILE::_old_offset"]
        [::std::mem::offset_of!(_IO_FILE, _old_offset) - 120usize];
    ["Offset of field: _IO_FILE::_cur_column"]
        [::std::mem::offset_of!(_IO_FILE, _cur_column) - 128usize];
    ["Offset of field: _IO_FILE::_vtable_offset"]
        [::std::mem::offset_of!(_IO_FILE, _vtable_offset) - 130usize];
    ["Offset of field: _IO_FILE::_shortbuf"]
        [::std::mem::offset_of!(_IO_FILE, _shortbuf) - 131usize];
    ["Offset of field: _IO_FILE::_lock"][::std::mem::offset_of!(_IO_FILE, _lock) - 136usize];
    ["Offset of field: _IO_FILE::_offset"][::std::mem::offset_of!(_IO_FILE, _offset) - 144usize];
    ["Offset of field: _IO_FILE::_codecvt"][::std::mem::offset_of!(_IO_FILE, _codecvt) - 152usize];
    ["Offset of field: _IO_FILE::_wide_data"]
        [::std::mem::offset_of!(_IO_FILE, _wide_data) - 160usize];
    ["Offset of field: _IO_FILE::_freeres_list"]
        [::std::mem::offset_of!(_IO_FILE, _freeres_list) - 168usize];
    ["Offset of field: _IO_FILE::_freeres_buf"]
        [::std::mem::offset_of!(_IO_FILE, _freeres_buf) - 176usize];
    ["Offset of field: _IO_FILE::_prevchain"]
        [::std::mem::offset_of!(_IO_FILE, _prevchain) - 184usize];
    ["Offset of field: _IO_FILE::_mode"][::std::mem::offset_of!(_IO_FILE, _mode) - 192usize];
    ["Offset of field: _IO_FILE::_unused3"][::std::mem::offset_of!(_IO_FILE, _unused3) - 196usize];
    ["Offset of field: _IO_FILE::_total_written"]
        [::std::mem::offset_of!(_IO_FILE, _total_written) - 200usize];
    ["Offset of field: _IO_FILE::_unused2"][::std::mem::offset_of!(_IO_FILE, _unused2) - 208usize];
};
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl _IO_FILE {
    #[inline]
    pub fn _flags2(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set__flags2(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn _flags2_raw(this: *const Self) -> ::std::os::raw::c_int {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set__flags2_raw(this: *mut Self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(_flags2: ::std::os::raw::c_int) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let _flags2: u32 = unsafe { ::std::mem::transmute(_flags2) };
            _flags2 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct u_memstream {
    pub f: *mut FILE,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of u_memstream"][::std::mem::size_of::<u_memstream>() - 8usize];
    ["Alignment of u_memstream"][::std::mem::align_of::<u_memstream>() - 8usize];
    ["Offset of field: u_memstream::f"][::std::mem::offset_of!(u_memstream, f) - 0usize];
};
impl Default for u_memstream {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn u_memstream_open(
        mem: *mut u_memstream,
        bufp: *mut *mut ::std::os::raw::c_char,
        sizep: *mut usize,
    ) -> bool;
}
unsafe extern "C" {
    pub fn u_memstream_close(mem: *mut u_memstream);
}
unsafe extern "C" {
    pub fn u_memstream_flush(mem: *mut u_memstream) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn compiler_rs_free(ptr: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn compiler_rs_ftell(f: *mut FILE) -> ::std::os::raw::c_long;
}
unsafe extern "C" {
    pub fn compiler_rs_fseek(
        f: *mut FILE,
        offset: ::std::os::raw::c_long,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn compiler_rs_fwrite(
        ptr: *const ::std::os::raw::c_void,
        size: usize,
        nmemb: usize,
        stream: *mut FILE,
    ) -> usize;
}
pub const MESA_SHADER_NONE: mesa_shader_stage = -1;
pub const MESA_SHADER_VERTEX: mesa_shader_stage = 0;
pub const MESA_SHADER_TESS_CTRL: mesa_shader_stage = 1;
pub const MESA_SHADER_TESS_EVAL: mesa_shader_stage = 2;
pub const MESA_SHADER_GEOMETRY: mesa_shader_stage = 3;
pub const MESA_SHADER_FRAGMENT: mesa_shader_stage = 4;
pub const MESA_SHADER_COMPUTE: mesa_shader_stage = 5;
pub const MESA_SHADER_TASK: mesa_shader_stage = 6;
pub const MESA_SHADER_MESH: mesa_shader_stage = 7;
pub const MESA_SHADER_RAYGEN: mesa_shader_stage = 8;
pub const MESA_SHADER_ANY_HIT: mesa_shader_stage = 9;
pub const MESA_SHADER_CLOSEST_HIT: mesa_shader_stage = 10;
pub const MESA_SHADER_MISS: mesa_shader_stage = 11;
pub const MESA_SHADER_INTERSECTION: mesa_shader_stage = 12;
pub const MESA_SHADER_CALLABLE: mesa_shader_stage = 13;
pub const MESA_SHADER_KERNEL: mesa_shader_stage = 14;
#[doc = " Shader stages.\n\n For vertex/tessallation/geometry/fragment shaders:\n The order must match how shaders are ordered in the pipeline.\n The GLSL linker assumes that if i<j, then the j-th shader is\n executed later than the i-th shader."]
pub type mesa_shader_stage = ::std::os::raw::c_int;
pub type gl_state_index16 = ::std::os::raw::c_short;
unsafe extern "C" {
    #[doc = " Translate a mesa_shader_stage to a short shader stage name for debug\n printouts and error messages."]
    pub fn _mesa_shader_stage_to_string(
        stage: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
pub const VERT_ATTRIB_POS: gl_vert_attrib = 0;
pub const VERT_ATTRIB_NORMAL: gl_vert_attrib = 1;
pub const VERT_ATTRIB_COLOR0: gl_vert_attrib = 2;
pub const VERT_ATTRIB_COLOR1: gl_vert_attrib = 3;
pub const VERT_ATTRIB_FOG: gl_vert_attrib = 4;
pub const VERT_ATTRIB_COLOR_INDEX: gl_vert_attrib = 5;
pub const VERT_ATTRIB_TEX0: gl_vert_attrib = 6;
pub const VERT_ATTRIB_TEX1: gl_vert_attrib = 7;
pub const VERT_ATTRIB_TEX2: gl_vert_attrib = 8;
pub const VERT_ATTRIB_TEX3: gl_vert_attrib = 9;
pub const VERT_ATTRIB_TEX4: gl_vert_attrib = 10;
pub const VERT_ATTRIB_TEX5: gl_vert_attrib = 11;
pub const VERT_ATTRIB_TEX6: gl_vert_attrib = 12;
pub const VERT_ATTRIB_TEX7: gl_vert_attrib = 13;
pub const VERT_ATTRIB_POINT_SIZE: gl_vert_attrib = 14;
pub const VERT_ATTRIB_GENERIC0: gl_vert_attrib = 15;
pub const VERT_ATTRIB_GENERIC1: gl_vert_attrib = 16;
pub const VERT_ATTRIB_GENERIC2: gl_vert_attrib = 17;
pub const VERT_ATTRIB_GENERIC3: gl_vert_attrib = 18;
pub const VERT_ATTRIB_GENERIC4: gl_vert_attrib = 19;
pub const VERT_ATTRIB_GENERIC5: gl_vert_attrib = 20;
pub const VERT_ATTRIB_GENERIC6: gl_vert_attrib = 21;
pub const VERT_ATTRIB_GENERIC7: gl_vert_attrib = 22;
pub const VERT_ATTRIB_GENERIC8: gl_vert_attrib = 23;
pub const VERT_ATTRIB_GENERIC9: gl_vert_attrib = 24;
pub const VERT_ATTRIB_GENERIC10: gl_vert_attrib = 25;
pub const VERT_ATTRIB_GENERIC11: gl_vert_attrib = 26;
pub const VERT_ATTRIB_GENERIC12: gl_vert_attrib = 27;
pub const VERT_ATTRIB_GENERIC13: gl_vert_attrib = 28;
pub const VERT_ATTRIB_GENERIC14: gl_vert_attrib = 29;
pub const VERT_ATTRIB_GENERIC15: gl_vert_attrib = 30;
pub const VERT_ATTRIB_EDGEFLAG: gl_vert_attrib = 31;
pub const VERT_ATTRIB_MAX: gl_vert_attrib = 32;
#[doc = " Indexes for vertex program attributes.\n GL_NV_vertex_program aliases generic attributes over the conventional\n attributes.  In GL_ARB_vertex_program shader the aliasing is optional.\n In GL_ARB_vertex_shader / OpenGL 2.0 the aliasing is disallowed (the\n generic attributes are distinct/separate)."]
pub type gl_vert_attrib = ::std::os::raw::c_uint;
pub const VARYING_SLOT_POS: gl_varying_slot = 0;
pub const VARYING_SLOT_COL0: gl_varying_slot = 1;
pub const VARYING_SLOT_COL1: gl_varying_slot = 2;
pub const VARYING_SLOT_FOGC: gl_varying_slot = 3;
pub const VARYING_SLOT_TEX0: gl_varying_slot = 4;
pub const VARYING_SLOT_TEX1: gl_varying_slot = 5;
pub const VARYING_SLOT_TEX2: gl_varying_slot = 6;
pub const VARYING_SLOT_TEX3: gl_varying_slot = 7;
pub const VARYING_SLOT_TEX4: gl_varying_slot = 8;
pub const VARYING_SLOT_TEX5: gl_varying_slot = 9;
pub const VARYING_SLOT_TEX6: gl_varying_slot = 10;
pub const VARYING_SLOT_TEX7: gl_varying_slot = 11;
pub const VARYING_SLOT_PSIZ: gl_varying_slot = 12;
pub const VARYING_SLOT_BFC0: gl_varying_slot = 13;
pub const VARYING_SLOT_BFC1: gl_varying_slot = 14;
pub const VARYING_SLOT_EDGE: gl_varying_slot = 15;
pub const VARYING_SLOT_CLIP_VERTEX: gl_varying_slot = 16;
pub const VARYING_SLOT_CLIP_DIST0: gl_varying_slot = 17;
pub const VARYING_SLOT_CLIP_DIST1: gl_varying_slot = 18;
pub const VARYING_SLOT_CULL_DIST0: gl_varying_slot = 19;
pub const VARYING_SLOT_CULL_DIST1: gl_varying_slot = 20;
pub const VARYING_SLOT_PRIMITIVE_ID: gl_varying_slot = 21;
pub const VARYING_SLOT_LAYER: gl_varying_slot = 22;
pub const VARYING_SLOT_VIEWPORT: gl_varying_slot = 23;
pub const VARYING_SLOT_FACE: gl_varying_slot = 24;
pub const VARYING_SLOT_PNTC: gl_varying_slot = 25;
pub const VARYING_SLOT_TESS_LEVEL_OUTER: gl_varying_slot = 26;
pub const VARYING_SLOT_TESS_LEVEL_INNER: gl_varying_slot = 27;
pub const VARYING_SLOT_BOUNDING_BOX0: gl_varying_slot = 28;
pub const VARYING_SLOT_BOUNDING_BOX1: gl_varying_slot = 29;
pub const VARYING_SLOT_VIEW_INDEX: gl_varying_slot = 30;
pub const VARYING_SLOT_VIEWPORT_MASK: gl_varying_slot = 31;
pub const VARYING_SLOT_PRIMITIVE_SHADING_RATE: gl_varying_slot = 24;
pub const VARYING_SLOT_PRIMITIVE_COUNT: gl_varying_slot = 26;
pub const VARYING_SLOT_PRIMITIVE_INDICES: gl_varying_slot = 27;
pub const VARYING_SLOT_TASK_COUNT: gl_varying_slot = 28;
pub const VARYING_SLOT_CULL_PRIMITIVE: gl_varying_slot = 28;
pub const VARYING_SLOT_VAR0: gl_varying_slot = 32;
pub const VARYING_SLOT_VAR1: gl_varying_slot = 33;
pub const VARYING_SLOT_VAR2: gl_varying_slot = 34;
pub const VARYING_SLOT_VAR3: gl_varying_slot = 35;
pub const VARYING_SLOT_VAR4: gl_varying_slot = 36;
pub const VARYING_SLOT_VAR5: gl_varying_slot = 37;
pub const VARYING_SLOT_VAR6: gl_varying_slot = 38;
pub const VARYING_SLOT_VAR7: gl_varying_slot = 39;
pub const VARYING_SLOT_VAR8: gl_varying_slot = 40;
pub const VARYING_SLOT_VAR9: gl_varying_slot = 41;
pub const VARYING_SLOT_VAR10: gl_varying_slot = 42;
pub const VARYING_SLOT_VAR11: gl_varying_slot = 43;
pub const VARYING_SLOT_VAR12: gl_varying_slot = 44;
pub const VARYING_SLOT_VAR13: gl_varying_slot = 45;
pub const VARYING_SLOT_VAR14: gl_varying_slot = 46;
pub const VARYING_SLOT_VAR15: gl_varying_slot = 47;
pub const VARYING_SLOT_VAR16: gl_varying_slot = 48;
pub const VARYING_SLOT_VAR17: gl_varying_slot = 49;
pub const VARYING_SLOT_VAR18: gl_varying_slot = 50;
pub const VARYING_SLOT_VAR19: gl_varying_slot = 51;
pub const VARYING_SLOT_VAR20: gl_varying_slot = 52;
pub const VARYING_SLOT_VAR21: gl_varying_slot = 53;
pub const VARYING_SLOT_VAR22: gl_varying_slot = 54;
pub const VARYING_SLOT_VAR23: gl_varying_slot = 55;
pub const VARYING_SLOT_VAR24: gl_varying_slot = 56;
pub const VARYING_SLOT_VAR25: gl_varying_slot = 57;
pub const VARYING_SLOT_VAR26: gl_varying_slot = 58;
pub const VARYING_SLOT_VAR27: gl_varying_slot = 59;
pub const VARYING_SLOT_VAR28: gl_varying_slot = 60;
pub const VARYING_SLOT_VAR29: gl_varying_slot = 61;
pub const VARYING_SLOT_VAR30: gl_varying_slot = 62;
pub const VARYING_SLOT_VAR31: gl_varying_slot = 63;
pub const VARYING_SLOT_PATCH0: gl_varying_slot = 64;
pub const VARYING_SLOT_PATCH1: gl_varying_slot = 65;
pub const VARYING_SLOT_PATCH2: gl_varying_slot = 66;
pub const VARYING_SLOT_PATCH3: gl_varying_slot = 67;
pub const VARYING_SLOT_PATCH4: gl_varying_slot = 68;
pub const VARYING_SLOT_PATCH5: gl_varying_slot = 69;
pub const VARYING_SLOT_PATCH6: gl_varying_slot = 70;
pub const VARYING_SLOT_PATCH7: gl_varying_slot = 71;
pub const VARYING_SLOT_PATCH8: gl_varying_slot = 72;
pub const VARYING_SLOT_PATCH9: gl_varying_slot = 73;
pub const VARYING_SLOT_PATCH10: gl_varying_slot = 74;
pub const VARYING_SLOT_PATCH11: gl_varying_slot = 75;
pub const VARYING_SLOT_PATCH12: gl_varying_slot = 76;
pub const VARYING_SLOT_PATCH13: gl_varying_slot = 77;
pub const VARYING_SLOT_PATCH14: gl_varying_slot = 78;
pub const VARYING_SLOT_PATCH15: gl_varying_slot = 79;
pub const VARYING_SLOT_PATCH16: gl_varying_slot = 80;
pub const VARYING_SLOT_PATCH17: gl_varying_slot = 81;
pub const VARYING_SLOT_PATCH18: gl_varying_slot = 82;
pub const VARYING_SLOT_PATCH19: gl_varying_slot = 83;
pub const VARYING_SLOT_PATCH20: gl_varying_slot = 84;
pub const VARYING_SLOT_PATCH21: gl_varying_slot = 85;
pub const VARYING_SLOT_PATCH22: gl_varying_slot = 86;
pub const VARYING_SLOT_PATCH23: gl_varying_slot = 87;
pub const VARYING_SLOT_PATCH24: gl_varying_slot = 88;
pub const VARYING_SLOT_PATCH25: gl_varying_slot = 89;
pub const VARYING_SLOT_PATCH26: gl_varying_slot = 90;
pub const VARYING_SLOT_PATCH27: gl_varying_slot = 91;
pub const VARYING_SLOT_PATCH28: gl_varying_slot = 92;
pub const VARYING_SLOT_PATCH29: gl_varying_slot = 93;
pub const VARYING_SLOT_PATCH30: gl_varying_slot = 94;
pub const VARYING_SLOT_PATCH31: gl_varying_slot = 95;
pub const VARYING_SLOT_VAR0_16BIT: gl_varying_slot = 96;
pub const VARYING_SLOT_VAR1_16BIT: gl_varying_slot = 97;
pub const VARYING_SLOT_VAR2_16BIT: gl_varying_slot = 98;
pub const VARYING_SLOT_VAR3_16BIT: gl_varying_slot = 99;
pub const VARYING_SLOT_VAR4_16BIT: gl_varying_slot = 100;
pub const VARYING_SLOT_VAR5_16BIT: gl_varying_slot = 101;
pub const VARYING_SLOT_VAR6_16BIT: gl_varying_slot = 102;
pub const VARYING_SLOT_VAR7_16BIT: gl_varying_slot = 103;
pub const VARYING_SLOT_VAR8_16BIT: gl_varying_slot = 104;
pub const VARYING_SLOT_VAR9_16BIT: gl_varying_slot = 105;
pub const VARYING_SLOT_VAR10_16BIT: gl_varying_slot = 106;
pub const VARYING_SLOT_VAR11_16BIT: gl_varying_slot = 107;
pub const VARYING_SLOT_VAR12_16BIT: gl_varying_slot = 108;
pub const VARYING_SLOT_VAR13_16BIT: gl_varying_slot = 109;
pub const VARYING_SLOT_VAR14_16BIT: gl_varying_slot = 110;
pub const VARYING_SLOT_VAR15_16BIT: gl_varying_slot = 111;
pub const NUM_TOTAL_VARYING_SLOTS: gl_varying_slot = 112;
#[doc = " Indexes for vertex shader outputs, geometry shader inputs/outputs, and\n fragment shader inputs.\n\n Note that some of these values are not available to all pipeline stages.\n\n When this enum is updated, the following code must be updated too:\n - vertResults (in prog_print.c's arb_output_attrib_string())\n - fragAttribs (in prog_print.c's arb_input_attrib_string())\n - _mesa_varying_slot_in_fs()\n - gl_varying_slot_name_for_stage()"]
pub type gl_varying_slot = ::std::os::raw::c_uint;
#[doc = " From the GL_ARB_shader-ballot spec:\n\n    \"A sub-group is a collection of invocations which execute in lockstep.\n     The variable <gl_SubGroupSizeARB> is the maximum number of\n     invocations in a sub-group. The maximum <gl_SubGroupSizeARB>\n     supported in this extension is 64.\"\n\n The spec defines this as a uniform. However, it's highly unlikely that\n implementations actually treat it as a uniform (which is loaded from a\n constant buffer). Most likely, this is an implementation-wide constant,\n or perhaps something that depends on the shader stage."]
pub const SYSTEM_VALUE_SUBGROUP_SIZE: gl_system_value = 0;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The variable <gl_SubGroupInvocationARB> holds the index of the\n     invocation within sub-group. This variable is in the range 0 to\n     <gl_SubGroupSizeARB>-1, where <gl_SubGroupSizeARB> is the total\n     number of invocations in a sub-group.\""]
pub const SYSTEM_VALUE_SUBGROUP_INVOCATION: gl_system_value = 1;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
pub const SYSTEM_VALUE_SUBGROUP_EQ_MASK: gl_system_value = 2;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
pub const SYSTEM_VALUE_SUBGROUP_GE_MASK: gl_system_value = 3;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
pub const SYSTEM_VALUE_SUBGROUP_GT_MASK: gl_system_value = 4;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
pub const SYSTEM_VALUE_SUBGROUP_LE_MASK: gl_system_value = 5;
#[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
pub const SYSTEM_VALUE_SUBGROUP_LT_MASK: gl_system_value = 6;
pub const SYSTEM_VALUE_NUM_SUBGROUPS: gl_system_value = 7;
pub const SYSTEM_VALUE_SUBGROUP_ID: gl_system_value = 8;
#[doc = " OpenGL-style vertex ID.\n\n Section 2.11.7 (Shader Execution), subsection Shader Inputs, of the\n OpenGL 3.3 core profile spec says:\n\n     \"gl_VertexID holds the integer index i implicitly passed by\n     DrawArrays or one of the other drawing commands defined in section\n     2.8.3.\"\n\n Section 2.8.3 (Drawing Commands) of the same spec says:\n\n     \"The commands....are equivalent to the commands with the same base\n     name (without the BaseVertex suffix), except that the ith element\n     transferred by the corresponding draw call will be taken from\n     element indices[i] + basevertex of each enabled array.\"\n\n Additionally, the overview in the GL_ARB_shader_draw_parameters spec\n says:\n\n     \"In unextended GL, vertex shaders have inputs named gl_VertexID and\n     gl_InstanceID, which contain, respectively the index of the vertex\n     and instance. The value of gl_VertexID is the implicitly passed\n     index of the vertex being processed, which includes the value of\n     baseVertex, for those commands that accept it.\"\n\n gl_VertexID gets basevertex added in.  This differs from DirectX where\n SV_VertexID does \\b not get basevertex added in.\n\n \\note\n If all system values are available, \\c SYSTEM_VALUE_VERTEX_ID will be\n equal to \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus\n \\c SYSTEM_VALUE_BASE_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_BASE_VERTEX"]
pub const SYSTEM_VALUE_VERTEX_ID: gl_system_value = 9;
#[doc = " Instanced ID as supplied to gl_InstanceID\n\n Values assigned to gl_InstanceID always begin with zero, regardless of\n the value of baseinstance.\n\n Section 11.1.3.9 (Shader Inputs) of the OpenGL 4.4 core profile spec\n says:\n\n     \"gl_InstanceID holds the integer instance number of the current\n     primitive in an instanced draw call (see section 10.5).\"\n\n Through a big chain of pseudocode, section 10.5 describes that\n baseinstance is not counted by gl_InstanceID.  In that section, notice\n\n     \"If an enabled vertex attribute array is instanced (it has a\n     non-zero divisor as specified by VertexAttribDivisor), the element\n     index that is transferred to the GL, for all vertices, is given by\n\n         floor(instance/divisor) + baseinstance\n\n     If an array corresponding to an attribute required by a vertex\n     shader is not enabled, then the corresponding element is taken from\n     the current attribute state (see section 10.2).\"\n\n Note that baseinstance is \\b not included in the value of instance."]
pub const SYSTEM_VALUE_INSTANCE_ID: gl_system_value = 10;
#[doc = " Vulkan InstanceIndex.\n\n InstanceIndex = gl_InstanceID + gl_BaseInstance"]
pub const SYSTEM_VALUE_INSTANCE_INDEX: gl_system_value = 11;
#[doc = " DirectX-style vertex ID.\n\n Unlike \\c SYSTEM_VALUE_VERTEX_ID, this system value does \\b not include\n the value of basevertex.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_BASE_VERTEX"]
pub const SYSTEM_VALUE_VERTEX_ID_ZERO_BASE: gl_system_value = 12;
#[doc = " Value of \\c basevertex passed to \\c glDrawElementsBaseVertex and similar\n functions.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_VERTEX_ID_ZERO_BASE"]
pub const SYSTEM_VALUE_BASE_VERTEX: gl_system_value = 13;
#[doc = " Depending on the type of the draw call (indexed or non-indexed),\n is the value of \\c basevertex passed to \\c glDrawElementsBaseVertex and\n similar, or is the value of \\c first passed to \\c glDrawArrays and\n similar.\n\n \\note\n It can be used to calculate the \\c SYSTEM_VALUE_VERTEX_ID as\n \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus \\c SYSTEM_VALUE_FIRST_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_VERTEX_ID"]
pub const SYSTEM_VALUE_FIRST_VERTEX: gl_system_value = 14;
#[doc = " If the Draw command used to start the rendering was an indexed draw\n or not (~0/0). Useful to calculate \\c SYSTEM_VALUE_BASE_VERTEX as\n \\c SYSTEM_VALUE_IS_INDEXED_DRAW & \\c SYSTEM_VALUE_FIRST_VERTEX."]
pub const SYSTEM_VALUE_IS_INDEXED_DRAW: gl_system_value = 15;
#[doc = " Value of \\c baseinstance passed to instanced draw entry points\n\n \\sa SYSTEM_VALUE_INSTANCE_ID"]
pub const SYSTEM_VALUE_BASE_INSTANCE: gl_system_value = 16;
#[doc = " From _ARB_shader_draw_parameters:\n\n   \"Additionally, this extension adds a further built-in variable,\n    gl_DrawID to the shading language. This variable contains the index\n    of the draw currently being processed by a Multi* variant of a\n    drawing command (such as MultiDrawElements or\n    MultiDrawArraysIndirect).\"\n\n If GL_ARB_multi_draw_indirect is not supported, this is always 0."]
pub const SYSTEM_VALUE_DRAW_ID: gl_system_value = 17;
#[doc = "< (Also in Tessellation Control shader)"]
pub const SYSTEM_VALUE_INVOCATION_ID: gl_system_value = 18;
pub const SYSTEM_VALUE_FRAG_COORD: gl_system_value = 19;
pub const SYSTEM_VALUE_PIXEL_COORD: gl_system_value = 20;
pub const SYSTEM_VALUE_FRAG_COORD_Z: gl_system_value = 21;
pub const SYSTEM_VALUE_FRAG_COORD_W: gl_system_value = 22;
pub const SYSTEM_VALUE_POINT_COORD: gl_system_value = 23;
#[doc = "< Coord along axis perpendicular to line"]
pub const SYSTEM_VALUE_LINE_COORD: gl_system_value = 24;
pub const SYSTEM_VALUE_FRONT_FACE: gl_system_value = 25;
pub const SYSTEM_VALUE_FRONT_FACE_FSIGN: gl_system_value = 26;
pub const SYSTEM_VALUE_SAMPLE_ID: gl_system_value = 27;
pub const SYSTEM_VALUE_SAMPLE_POS: gl_system_value = 28;
pub const SYSTEM_VALUE_SAMPLE_POS_OR_CENTER: gl_system_value = 29;
pub const SYSTEM_VALUE_SAMPLE_MASK_IN: gl_system_value = 30;
pub const SYSTEM_VALUE_LAYER_ID: gl_system_value = 31;
pub const SYSTEM_VALUE_HELPER_INVOCATION: gl_system_value = 32;
pub const SYSTEM_VALUE_COLOR0: gl_system_value = 33;
pub const SYSTEM_VALUE_COLOR1: gl_system_value = 34;
pub const SYSTEM_VALUE_TESS_COORD: gl_system_value = 35;
#[doc = "< Tessellation vertices in input patch"]
pub const SYSTEM_VALUE_VERTICES_IN: gl_system_value = 36;
pub const SYSTEM_VALUE_PRIMITIVE_ID: gl_system_value = 37;
#[doc = "< TES input"]
pub const SYSTEM_VALUE_TESS_LEVEL_OUTER: gl_system_value = 38;
#[doc = "< TES input"]
pub const SYSTEM_VALUE_TESS_LEVEL_INNER: gl_system_value = 39;
#[doc = "< TCS input for passthru TCS"]
pub const SYSTEM_VALUE_TESS_LEVEL_OUTER_DEFAULT: gl_system_value = 40;
#[doc = "< TCS input for passthru TCS"]
pub const SYSTEM_VALUE_TESS_LEVEL_INNER_DEFAULT: gl_system_value = 41;
pub const SYSTEM_VALUE_LOCAL_INVOCATION_ID: gl_system_value = 42;
pub const SYSTEM_VALUE_LOCAL_INVOCATION_INDEX: gl_system_value = 43;
pub const SYSTEM_VALUE_GLOBAL_INVOCATION_ID: gl_system_value = 44;
pub const SYSTEM_VALUE_BASE_GLOBAL_INVOCATION_ID: gl_system_value = 45;
pub const SYSTEM_VALUE_GLOBAL_INVOCATION_INDEX: gl_system_value = 46;
pub const SYSTEM_VALUE_WORKGROUP_ID: gl_system_value = 47;
pub const SYSTEM_VALUE_BASE_WORKGROUP_ID: gl_system_value = 48;
pub const SYSTEM_VALUE_WORKGROUP_INDEX: gl_system_value = 49;
pub const SYSTEM_VALUE_NUM_WORKGROUPS: gl_system_value = 50;
pub const SYSTEM_VALUE_WORKGROUP_SIZE: gl_system_value = 51;
pub const SYSTEM_VALUE_GLOBAL_GROUP_SIZE: gl_system_value = 52;
pub const SYSTEM_VALUE_WORK_DIM: gl_system_value = 53;
pub const SYSTEM_VALUE_USER_DATA_AMD: gl_system_value = 54;
#[doc = " Required for VK_KHR_device_group"]
pub const SYSTEM_VALUE_DEVICE_INDEX: gl_system_value = 55;
#[doc = " Required for VK_KHX_multiview"]
pub const SYSTEM_VALUE_VIEW_INDEX: gl_system_value = 56;
#[doc = " Driver internal vertex-count, used (for example) for drivers to\n calculate stride for stream-out outputs.  Not externally visible."]
pub const SYSTEM_VALUE_VERTEX_CNT: gl_system_value = 57;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_PERSP_PIXEL: gl_system_value = 58;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_PERSP_SAMPLE: gl_system_value = 59;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTROID: gl_system_value = 60;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTER_RHW: gl_system_value = 61;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_LINEAR_PIXEL: gl_system_value = 62;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_LINEAR_CENTROID: gl_system_value = 63;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_LINEAR_SAMPLE: gl_system_value = 64;
#[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
pub const SYSTEM_VALUE_BARYCENTRIC_PULL_MODEL: gl_system_value = 65;
pub const SYSTEM_VALUE_BARYCENTRIC_PERSP_COORD: gl_system_value = 66;
pub const SYSTEM_VALUE_BARYCENTRIC_LINEAR_COORD: gl_system_value = 67;
pub const SYSTEM_VALUE_RAY_LAUNCH_ID: gl_system_value = 68;
pub const SYSTEM_VALUE_RAY_LAUNCH_SIZE: gl_system_value = 69;
pub const SYSTEM_VALUE_RAY_WORLD_ORIGIN: gl_system_value = 70;
pub const SYSTEM_VALUE_RAY_WORLD_DIRECTION: gl_system_value = 71;
pub const SYSTEM_VALUE_RAY_OBJECT_ORIGIN: gl_system_value = 72;
pub const SYSTEM_VALUE_RAY_OBJECT_DIRECTION: gl_system_value = 73;
pub const SYSTEM_VALUE_RAY_T_MIN: gl_system_value = 74;
pub const SYSTEM_VALUE_RAY_T_MAX: gl_system_value = 75;
pub const SYSTEM_VALUE_RAY_OBJECT_TO_WORLD: gl_system_value = 76;
pub const SYSTEM_VALUE_RAY_WORLD_TO_OBJECT: gl_system_value = 77;
pub const SYSTEM_VALUE_RAY_HIT_KIND: gl_system_value = 78;
pub const SYSTEM_VALUE_RAY_FLAGS: gl_system_value = 79;
pub const SYSTEM_VALUE_RAY_GEOMETRY_INDEX: gl_system_value = 80;
pub const SYSTEM_VALUE_RAY_INSTANCE_CUSTOM_INDEX: gl_system_value = 81;
pub const SYSTEM_VALUE_CULL_MASK: gl_system_value = 82;
pub const SYSTEM_VALUE_RAY_TRIANGLE_VERTEX_POSITIONS: gl_system_value = 83;
pub const SYSTEM_VALUE_MESH_VIEW_COUNT: gl_system_value = 84;
pub const SYSTEM_VALUE_MESH_VIEW_INDICES: gl_system_value = 85;
#[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
pub const SYSTEM_VALUE_GS_HEADER_IR3: gl_system_value = 86;
#[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
pub const SYSTEM_VALUE_TCS_HEADER_IR3: gl_system_value = 87;
#[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
pub const SYSTEM_VALUE_REL_PATCH_ID_IR3: gl_system_value = 88;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_FRAG_SHADING_RATE: gl_system_value = 89;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_FULLY_COVERED: gl_system_value = 90;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_FRAG_SIZE: gl_system_value = 91;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_FRAG_INVOCATION_COUNT: gl_system_value = 92;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_SHADER_INDEX: gl_system_value = 93;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_COALESCED_INPUT_COUNT: gl_system_value = 94;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_WARPS_PER_SM_NV: gl_system_value = 95;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_SM_COUNT_NV: gl_system_value = 96;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_WARP_ID_NV: gl_system_value = 97;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_SM_ID_NV: gl_system_value = 98;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_CORE_ID: gl_system_value = 99;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_CORE_COUNT_ARM: gl_system_value = 100;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_CORE_MAX_ID_ARM: gl_system_value = 101;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_WARP_ID_ARM: gl_system_value = 102;
#[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
pub const SYSTEM_VALUE_WARP_MAX_ID_ARM: gl_system_value = 103;
#[doc = "< Number of values"]
pub const SYSTEM_VALUE_MAX: gl_system_value = 104;
#[doc = " If a NIR variable's mode is nir_var_system_value, it will be one of these\n values."]
pub type gl_system_value = ::std::os::raw::c_uint;
pub const INTERP_MODE_NONE: glsl_interp_mode = 0;
pub const INTERP_MODE_SMOOTH: glsl_interp_mode = 1;
pub const INTERP_MODE_FLAT: glsl_interp_mode = 2;
pub const INTERP_MODE_NOPERSPECTIVE: glsl_interp_mode = 3;
pub const INTERP_MODE_EXPLICIT: glsl_interp_mode = 4;
#[doc = "< Number of interpolation qualifiers"]
pub const INTERP_MODE_COUNT: glsl_interp_mode = 5;
#[doc = " The possible interpolation qualifiers that can be applied to a fragment\n shader input in GLSL.\n\n Note: INTERP_MODE_NONE must be 0 so that memsetting the\n ir_variable data structure to 0 causes the default behavior."]
pub type glsl_interp_mode = ::std::os::raw::c_uint;
pub const GLSL_INTERFACE_PACKING_STD140: glsl_interface_packing = 0;
pub const GLSL_INTERFACE_PACKING_SHARED: glsl_interface_packing = 1;
pub const GLSL_INTERFACE_PACKING_PACKED: glsl_interface_packing = 2;
pub const GLSL_INTERFACE_PACKING_STD430: glsl_interface_packing = 3;
pub type glsl_interface_packing = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn glsl_interp_mode_name(qual: glsl_interp_mode) -> *const ::std::os::raw::c_char;
}
pub const FRAG_RESULT_DEPTH: gl_frag_result = 0;
pub const FRAG_RESULT_STENCIL: gl_frag_result = 1;
pub const FRAG_RESULT_COLOR: gl_frag_result = 2;
pub const FRAG_RESULT_SAMPLE_MASK: gl_frag_result = 3;
pub const FRAG_RESULT_DATA0: gl_frag_result = 4;
pub const FRAG_RESULT_DATA1: gl_frag_result = 5;
pub const FRAG_RESULT_DATA2: gl_frag_result = 6;
pub const FRAG_RESULT_DATA3: gl_frag_result = 7;
pub const FRAG_RESULT_DATA4: gl_frag_result = 8;
pub const FRAG_RESULT_DATA5: gl_frag_result = 9;
pub const FRAG_RESULT_DATA6: gl_frag_result = 10;
pub const FRAG_RESULT_DATA7: gl_frag_result = 11;
#[doc = " Fragment program results"]
pub type gl_frag_result = ::std::os::raw::c_uint;
#[doc = "< No layout is specified."]
pub const FRAG_DEPTH_LAYOUT_NONE: gl_frag_depth_layout = 0;
pub const FRAG_DEPTH_LAYOUT_ANY: gl_frag_depth_layout = 1;
pub const FRAG_DEPTH_LAYOUT_GREATER: gl_frag_depth_layout = 2;
pub const FRAG_DEPTH_LAYOUT_LESS: gl_frag_depth_layout = 3;
pub const FRAG_DEPTH_LAYOUT_UNCHANGED: gl_frag_depth_layout = 4;
#[doc = " \\brief Layout qualifiers for gl_FragDepth.\n\n Extension AMD_conservative_depth allows gl_FragDepth to be redeclared with\n a layout qualifier.\n\n \\see enum ir_depth_layout"]
pub type gl_frag_depth_layout = ::std::os::raw::c_uint;
#[doc = "< No layout is specified."]
pub const FRAG_STENCIL_LAYOUT_NONE: gl_frag_stencil_layout = 0;
pub const FRAG_STENCIL_LAYOUT_ANY: gl_frag_stencil_layout = 1;
pub const FRAG_STENCIL_LAYOUT_GREATER: gl_frag_stencil_layout = 2;
pub const FRAG_STENCIL_LAYOUT_LESS: gl_frag_stencil_layout = 3;
pub const FRAG_STENCIL_LAYOUT_UNCHANGED: gl_frag_stencil_layout = 4;
#[doc = " \\brief Layout qualifiers for AMD_shader_early_and_late_fragment_tests."]
pub type gl_frag_stencil_layout = ::std::os::raw::c_uint;
#[doc = " This means that the memory scope is the current device. It indicates\n that reads and writes are coherent with reads and writes from other\n shader invocations and other workgroups.\n\n This is not necessary for shared access. It is always workgroup\n coherent."]
pub const ACCESS_COHERENT: gl_access_qualifier = 1;
#[doc = " This means non-aliased. It indicates that the accessed address is not\n accessible through any other memory resource in the shader."]
pub const ACCESS_RESTRICT: gl_access_qualifier = 2;
#[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
pub const ACCESS_VOLATILE: gl_access_qualifier = 4;
#[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
pub const ACCESS_NON_READABLE: gl_access_qualifier = 8;
#[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
pub const ACCESS_NON_WRITEABLE: gl_access_qualifier = 16;
#[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
pub const ACCESS_NON_UNIFORM: gl_access_qualifier = 32;
#[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
pub const ACCESS_CAN_REORDER: gl_access_qualifier = 64;
#[doc = " Hints that the accessed address is not likely to be accessed again\n in the near future. This reduces data retention in caches."]
pub const ACCESS_NON_TEMPORAL: gl_access_qualifier = 128;
#[doc = " Execute instruction also in helpers."]
pub const ACCESS_INCLUDE_HELPERS: gl_access_qualifier = 256;
#[doc = " Whether the address bits are swizzled by the hw. This practically means\n that loads can't be vectorized and must be exactly 32 bits on some chips.\n The swizzle amount is determined by the descriptor."]
pub const ACCESS_IS_SWIZZLED_AMD: gl_access_qualifier = 512;
#[doc = " Whether an AMD-specific buffer intrinsic uses a format conversion.\n\n If unset, the intrinsic will access raw memory without any conversion.\n\n If set, the memory opcode performs a format conversion according to\n the format determined by the descriptor (in a manner identical to image\n buffers and sampler buffers)."]
pub const ACCESS_USES_FORMAT_AMD: gl_access_qualifier = 1024;
#[doc = " Whether a multi sample image load intrinsic uses sample index extracted\n from fragment mask buffer."]
pub const ACCESS_FMASK_LOWERED_AMD: gl_access_qualifier = 2048;
#[doc = " Whether it is safe to speculatively execute this load. This allows\n hoisting loads out of conditional control flow (including out of software\n bounds checks). Setting this optimally depends on knowledge of the\n hardware. Speculation is safe if out-of-bounds access does not trigger\n undefined behaviour (even though the returned value of the speculated load\n is bogus). This is the case if there is hardware-level bounds checking, or\n if MMU faults are suppressed for the load."]
pub const ACCESS_CAN_SPECULATE: gl_access_qualifier = 4096;
#[doc = " Whether coherency with CP (command processor) or GE (geometry engine)\n is required."]
pub const ACCESS_CP_GE_COHERENT_AMD: gl_access_qualifier = 8192;
#[doc = " Whether coherency with CP (command processor) or GE (geometry engine)\n is required."]
pub const ACCESS_IN_BOUNDS: gl_access_qualifier = 16384;
#[doc = " Disallow vectorization.\n\n On some hw (AMD), sparse buffer loads return 0 for all components if\n a sparse load starts on a non-resident page, crosses the page boundary,\n and ends on a resident page. Sometimes we want it to return 0 only for\n the portion of the load that's non-resident, and load values for\n the portion that's resident. The workaround is to scalarize such loads\n and disallow vectorization. This is used by an internal copy_buffer\n shader where the API wants to copy all bytes that are resident."]
pub const ACCESS_KEEP_SCALAR: gl_access_qualifier = 32768;
#[doc = " Indicates that this load will use SMEM."]
pub const ACCESS_SMEM_AMD: gl_access_qualifier = 65536;
#[doc = " Indicates that this load must be skipped by helper invocations."]
pub const ACCESS_SKIP_HELPERS: gl_access_qualifier = 131072;
#[doc = " Indicates that this is an atomic load/store. Atomic RMW, swap, and other\n intrinsics which are always atomic such as atomic_counter_read_deref do\n not need this flag.\n\n If this is a vector load/store, then each component is considered its\n own atomic access.\n\n For non-shared load/store, instructions with this flag should also have\n ACCESS_COHERENT.\n\n The differences between atomic and non-atomic accesses can be summarized\n as follows:\n - Bounds checking of a 64-bit atomic access must be done per-component,\n   and not for each 32-bit part.\n - Atomics accesses are always coherent. Non-shared atomic load/store\n   should have the ACCESS_COHERENT flag.\n - Data races do not happen with two atomic accesses, with each access\n   instead reading/writing a valid value. Two non-atomic accesses or an\n   atomic access and a non-atomic access can data race, which is either\n   undefined behaviour or undefined value, depending on\n   shader_info::assume_no_data_races.\n - Because of data races, atomics are necessary for sychronization\n   without barriers. In the Vulkan memory model, synchronizes-with\n   relations only form between two memory barriers if control barriers or\n   atomic accesses are involved.\n\n Some hardware can \"tear\" loads with a subgroup uniform address, which\n means that a store from a different subgroup interrupts the load,\n causing the result to not be subgroup uniform and instead be a mix of\n the old and new values, despite the address being subgroup uniform. If\n a load is not atomic and assume_no_data_races=true, we can assume that\n the load never tears."]
pub const ACCESS_ATOMIC: gl_access_qualifier = 262144;
#[doc = " Indicates that access should be serialized with regard to the Intel EU\n fusion feature."]
pub const ACCESS_FUSED_EU_DISABLE_INTEL: gl_access_qualifier = 524288;
#[doc = " \\brief Memory access qualifiers"]
pub type gl_access_qualifier = ::std::os::raw::c_uint;
pub const TESS_SPACING_UNSPECIFIED: gl_tess_spacing = 0;
pub const TESS_SPACING_EQUAL: gl_tess_spacing = 1;
pub const TESS_SPACING_FRACTIONAL_ODD: gl_tess_spacing = 2;
pub const TESS_SPACING_FRACTIONAL_EVEN: gl_tess_spacing = 3;
pub type gl_tess_spacing = ::std::os::raw::c_uint;
pub const TESS_PRIMITIVE_UNSPECIFIED: tess_primitive_mode = 0;
pub const TESS_PRIMITIVE_TRIANGLES: tess_primitive_mode = 1;
pub const TESS_PRIMITIVE_QUADS: tess_primitive_mode = 2;
pub const TESS_PRIMITIVE_ISOLINES: tess_primitive_mode = 3;
pub type tess_primitive_mode = ::std::os::raw::c_uint;
pub const MESA_PRIM_POINTS: mesa_prim = 0;
pub const MESA_PRIM_LINES: mesa_prim = 1;
pub const MESA_PRIM_LINE_LOOP: mesa_prim = 2;
pub const MESA_PRIM_LINE_STRIP: mesa_prim = 3;
pub const MESA_PRIM_TRIANGLES: mesa_prim = 4;
pub const MESA_PRIM_TRIANGLE_STRIP: mesa_prim = 5;
pub const MESA_PRIM_TRIANGLE_FAN: mesa_prim = 6;
pub const MESA_PRIM_QUADS: mesa_prim = 7;
pub const MESA_PRIM_QUAD_STRIP: mesa_prim = 8;
pub const MESA_PRIM_POLYGON: mesa_prim = 9;
pub const MESA_PRIM_LINES_ADJACENCY: mesa_prim = 10;
pub const MESA_PRIM_LINE_STRIP_ADJACENCY: mesa_prim = 11;
pub const MESA_PRIM_TRIANGLES_ADJACENCY: mesa_prim = 12;
pub const MESA_PRIM_TRIANGLE_STRIP_ADJACENCY: mesa_prim = 13;
pub const MESA_PRIM_PATCHES: mesa_prim = 14;
pub const MESA_PRIM_MAX: mesa_prim = 14;
pub const MESA_PRIM_COUNT: mesa_prim = 15;
pub const MESA_PRIM_UNKNOWN: mesa_prim = 28;
#[doc = " Mesa primitive types for both GL and Vulkan:"]
pub type mesa_prim = ::std::os::raw::c_uchar;
pub const COMPARE_FUNC_NEVER: compare_func = 0;
pub const COMPARE_FUNC_LESS: compare_func = 1;
pub const COMPARE_FUNC_EQUAL: compare_func = 2;
pub const COMPARE_FUNC_LEQUAL: compare_func = 3;
pub const COMPARE_FUNC_GREATER: compare_func = 4;
pub const COMPARE_FUNC_NOTEQUAL: compare_func = 5;
pub const COMPARE_FUNC_GEQUAL: compare_func = 6;
pub const COMPARE_FUNC_ALWAYS: compare_func = 7;
#[doc = " A compare function enum for use in compiler lowering passes.  This is in\n the same order as GL's compare functions (shifted down by GL_NEVER), and is\n exactly the same as gallium's PIPE_FUNC_*."]
pub type compare_func = ::std::os::raw::c_uint;
pub const DERIVATIVE_GROUP_NONE: gl_derivative_group = 0;
pub const DERIVATIVE_GROUP_QUADS: gl_derivative_group = 1;
pub const DERIVATIVE_GROUP_LINEAR: gl_derivative_group = 2;
#[doc = " Arrangements for grouping invocations from NV_compute_shader_derivatives.\n\n   The extension provides new layout qualifiers that support two different\n   arrangements of compute shader invocations for the purpose of derivative\n   computation.  When specifying\n\n     layout(derivative_group_quadsNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation ID values follow the pattern:\n\n       +-----------------+------------------+\n       | (2x+0, 2y+0, z) |  (2x+1, 2y+0, z) |\n       +-----------------+------------------+\n       | (2x+0, 2y+1, z) |  (2x+1, 2y+1, z) |\n       +-----------------+------------------+\n\n   where Y increases from bottom to top.  When specifying\n\n     layout(derivative_group_linearNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation index values follow the pattern:\n\n       +------+------+\n       | 4n+0 | 4n+1 |\n       +------+------+\n       | 4n+2 | 4n+3 |\n       +------+------+\n\n   If neither layout qualifier is specified, derivatives in compute shaders\n   return zero, which is consistent with the handling of built-in texture\n   functions like texture() in GLSL 4.50 compute shaders."]
pub type gl_derivative_group = ::std::os::raw::c_uint;
pub const FLOAT_CONTROLS_DEFAULT_FLOAT_CONTROL_MODE: float_controls = 0;
pub const FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP16: float_controls = 1;
pub const FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP32: float_controls = 2;
pub const FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP64: float_controls = 4;
pub const FLOAT_CONTROLS_INF_PRESERVE_FP16: float_controls = 8;
pub const FLOAT_CONTROLS_INF_PRESERVE_FP32: float_controls = 16;
pub const FLOAT_CONTROLS_INF_PRESERVE_FP64: float_controls = 32;
pub const FLOAT_CONTROLS_NAN_PRESERVE_FP16: float_controls = 64;
pub const FLOAT_CONTROLS_NAN_PRESERVE_FP32: float_controls = 128;
pub const FLOAT_CONTROLS_NAN_PRESERVE_FP64: float_controls = 256;
pub const FLOAT_CONTROLS_DENORM_PRESERVE_FP16: float_controls = 512;
pub const FLOAT_CONTROLS_DENORM_PRESERVE_FP32: float_controls = 1024;
pub const FLOAT_CONTROLS_DENORM_PRESERVE_FP64: float_controls = 2048;
pub const FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP16: float_controls = 4096;
pub const FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP32: float_controls = 8192;
pub const FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP64: float_controls = 16384;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP16: float_controls = 32768;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP32: float_controls = 65536;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP64: float_controls = 131072;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP16: float_controls = 262144;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP32: float_controls = 524288;
pub const FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP64: float_controls = 1048576;
pub const FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP16: float_controls = 73;
pub const FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP32: float_controls = 146;
pub const FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP64: float_controls = 292;
pub const FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE: float_controls = 7;
pub const FLOAT_CONTROLS_INF_PRESERVE: float_controls = 56;
pub const FLOAT_CONTROLS_NAN_PRESERVE: float_controls = 448;
pub type float_controls = ::std::os::raw::c_uint;
pub const SCOPE_NONE: mesa_scope = 0;
pub const SCOPE_INVOCATION: mesa_scope = 1;
pub const SCOPE_SUBGROUP: mesa_scope = 2;
pub const SCOPE_SHADER_CALL: mesa_scope = 3;
pub const SCOPE_WORKGROUP: mesa_scope = 4;
pub const SCOPE_QUEUE_FAMILY: mesa_scope = 5;
pub const SCOPE_DEVICE: mesa_scope = 6;
pub type mesa_scope = ::std::os::raw::c_uint;
pub const GLSL_SAMPLER_DIM_1D: glsl_sampler_dim = 0;
pub const GLSL_SAMPLER_DIM_2D: glsl_sampler_dim = 1;
pub const GLSL_SAMPLER_DIM_3D: glsl_sampler_dim = 2;
pub const GLSL_SAMPLER_DIM_CUBE: glsl_sampler_dim = 3;
pub const GLSL_SAMPLER_DIM_RECT: glsl_sampler_dim = 4;
pub const GLSL_SAMPLER_DIM_BUF: glsl_sampler_dim = 5;
pub const GLSL_SAMPLER_DIM_EXTERNAL: glsl_sampler_dim = 6;
pub const GLSL_SAMPLER_DIM_MS: glsl_sampler_dim = 7;
pub const GLSL_SAMPLER_DIM_SUBPASS: glsl_sampler_dim = 8;
pub const GLSL_SAMPLER_DIM_SUBPASS_MS: glsl_sampler_dim = 9;
pub type glsl_sampler_dim = ::std::os::raw::c_uint;
pub const PIPE_FORMAT_NONE: pipe_format = 0;
pub const PIPE_FORMAT_VERTEX_START: pipe_format = 1;
pub const PIPE_FORMAT_R64_UINT: pipe_format = 1;
pub const PIPE_FORMAT_R64G64_UINT: pipe_format = 2;
pub const PIPE_FORMAT_R64G64B64_UINT: pipe_format = 3;
pub const PIPE_FORMAT_R64G64B64A64_UINT: pipe_format = 4;
pub const PIPE_FORMAT_R64_SINT: pipe_format = 5;
pub const PIPE_FORMAT_R64G64_SINT: pipe_format = 6;
pub const PIPE_FORMAT_R64G64B64_SINT: pipe_format = 7;
pub const PIPE_FORMAT_R64G64B64A64_SINT: pipe_format = 8;
pub const PIPE_FORMAT_R64_FLOAT: pipe_format = 9;
pub const PIPE_FORMAT_R64G64_FLOAT: pipe_format = 10;
pub const PIPE_FORMAT_R64G64B64_FLOAT: pipe_format = 11;
pub const PIPE_FORMAT_R64G64B64A64_FLOAT: pipe_format = 12;
pub const PIPE_FORMAT_R32_UINT: pipe_format = 13;
pub const PIPE_FORMAT_R32G32_UINT: pipe_format = 14;
pub const PIPE_FORMAT_R32G32B32_UINT: pipe_format = 15;
pub const PIPE_FORMAT_R32G32B32A32_UINT: pipe_format = 16;
pub const PIPE_FORMAT_R32_SINT: pipe_format = 17;
pub const PIPE_FORMAT_R32G32_SINT: pipe_format = 18;
pub const PIPE_FORMAT_R32G32B32_SINT: pipe_format = 19;
pub const PIPE_FORMAT_R32G32B32A32_SINT: pipe_format = 20;
pub const PIPE_FORMAT_R32_FLOAT: pipe_format = 21;
pub const PIPE_FORMAT_R32G32_FLOAT: pipe_format = 22;
pub const PIPE_FORMAT_R32G32B32_FLOAT: pipe_format = 23;
pub const PIPE_FORMAT_R32G32B32A32_FLOAT: pipe_format = 24;
pub const PIPE_FORMAT_R32_UNORM: pipe_format = 25;
pub const PIPE_FORMAT_R32G32_UNORM: pipe_format = 26;
pub const PIPE_FORMAT_R32G32B32_UNORM: pipe_format = 27;
pub const PIPE_FORMAT_R32G32B32A32_UNORM: pipe_format = 28;
pub const PIPE_FORMAT_R32_SNORM: pipe_format = 29;
pub const PIPE_FORMAT_R32G32_SNORM: pipe_format = 30;
pub const PIPE_FORMAT_R32G32B32_SNORM: pipe_format = 31;
pub const PIPE_FORMAT_R32G32B32A32_SNORM: pipe_format = 32;
pub const PIPE_FORMAT_R32_USCALED: pipe_format = 33;
pub const PIPE_FORMAT_R32G32_USCALED: pipe_format = 34;
pub const PIPE_FORMAT_R32G32B32_USCALED: pipe_format = 35;
pub const PIPE_FORMAT_R32G32B32A32_USCALED: pipe_format = 36;
pub const PIPE_FORMAT_R32_SSCALED: pipe_format = 37;
pub const PIPE_FORMAT_R32G32_SSCALED: pipe_format = 38;
pub const PIPE_FORMAT_R32G32B32_SSCALED: pipe_format = 39;
pub const PIPE_FORMAT_R32G32B32A32_SSCALED: pipe_format = 40;
pub const PIPE_FORMAT_R32_FIXED: pipe_format = 41;
pub const PIPE_FORMAT_R32G32_FIXED: pipe_format = 42;
pub const PIPE_FORMAT_R32G32B32_FIXED: pipe_format = 43;
pub const PIPE_FORMAT_R32G32B32A32_FIXED: pipe_format = 44;
pub const PIPE_FORMAT_R16_UINT: pipe_format = 45;
pub const PIPE_FORMAT_R16G16_UINT: pipe_format = 46;
pub const PIPE_FORMAT_R16G16B16_UINT: pipe_format = 47;
pub const PIPE_FORMAT_R16G16B16A16_UINT: pipe_format = 48;
pub const PIPE_FORMAT_R16_SINT: pipe_format = 49;
pub const PIPE_FORMAT_R16G16_SINT: pipe_format = 50;
pub const PIPE_FORMAT_R16G16B16_SINT: pipe_format = 51;
pub const PIPE_FORMAT_R16G16B16A16_SINT: pipe_format = 52;
pub const PIPE_FORMAT_R16_FLOAT: pipe_format = 53;
pub const PIPE_FORMAT_R16G16_FLOAT: pipe_format = 54;
pub const PIPE_FORMAT_R16G16B16_FLOAT: pipe_format = 55;
pub const PIPE_FORMAT_R16G16B16A16_FLOAT: pipe_format = 56;
pub const PIPE_FORMAT_R16_UNORM: pipe_format = 57;
pub const PIPE_FORMAT_R16G16_UNORM: pipe_format = 58;
pub const PIPE_FORMAT_R16G16B16_UNORM: pipe_format = 59;
pub const PIPE_FORMAT_R16G16B16A16_UNORM: pipe_format = 60;
pub const PIPE_FORMAT_R16_SNORM: pipe_format = 61;
pub const PIPE_FORMAT_R16G16_SNORM: pipe_format = 62;
pub const PIPE_FORMAT_R16G16B16_SNORM: pipe_format = 63;
pub const PIPE_FORMAT_R16G16B16A16_SNORM: pipe_format = 64;
pub const PIPE_FORMAT_R16_USCALED: pipe_format = 65;
pub const PIPE_FORMAT_R16G16_USCALED: pipe_format = 66;
pub const PIPE_FORMAT_R16G16B16_USCALED: pipe_format = 67;
pub const PIPE_FORMAT_R16G16B16A16_USCALED: pipe_format = 68;
pub const PIPE_FORMAT_R16_SSCALED: pipe_format = 69;
pub const PIPE_FORMAT_R16G16_SSCALED: pipe_format = 70;
pub const PIPE_FORMAT_R16G16B16_SSCALED: pipe_format = 71;
pub const PIPE_FORMAT_R16G16B16A16_SSCALED: pipe_format = 72;
pub const PIPE_FORMAT_R8_UINT: pipe_format = 73;
pub const PIPE_FORMAT_R8G8_UINT: pipe_format = 74;
pub const PIPE_FORMAT_R8G8B8_UINT: pipe_format = 75;
pub const PIPE_FORMAT_R8G8B8A8_UINT: pipe_format = 76;
pub const PIPE_FORMAT_R8_SINT: pipe_format = 77;
pub const PIPE_FORMAT_R8G8_SINT: pipe_format = 78;
pub const PIPE_FORMAT_R8G8B8_SINT: pipe_format = 79;
pub const PIPE_FORMAT_R8G8B8A8_SINT: pipe_format = 80;
pub const PIPE_FORMAT_R8_UNORM: pipe_format = 81;
pub const PIPE_FORMAT_R8G8_UNORM: pipe_format = 82;
pub const PIPE_FORMAT_R8G8B8_UNORM: pipe_format = 83;
pub const PIPE_FORMAT_R8G8B8A8_UNORM: pipe_format = 84;
pub const PIPE_FORMAT_R8_SNORM: pipe_format = 85;
pub const PIPE_FORMAT_R8G8_SNORM: pipe_format = 86;
pub const PIPE_FORMAT_R8G8B8_SNORM: pipe_format = 87;
pub const PIPE_FORMAT_R8G8B8A8_SNORM: pipe_format = 88;
pub const PIPE_FORMAT_R8_USCALED: pipe_format = 89;
pub const PIPE_FORMAT_R8G8_USCALED: pipe_format = 90;
pub const PIPE_FORMAT_R8G8B8_USCALED: pipe_format = 91;
pub const PIPE_FORMAT_R8G8B8A8_USCALED: pipe_format = 92;
pub const PIPE_FORMAT_R8_SSCALED: pipe_format = 93;
pub const PIPE_FORMAT_R8G8_SSCALED: pipe_format = 94;
pub const PIPE_FORMAT_R8G8B8_SSCALED: pipe_format = 95;
pub const PIPE_FORMAT_R8G8B8A8_SSCALED: pipe_format = 96;
pub const PIPE_FORMAT_B8G8R8_UINT: pipe_format = 97;
pub const PIPE_FORMAT_B8G8R8_SINT: pipe_format = 98;
pub const PIPE_FORMAT_B8G8R8_UNORM: pipe_format = 99;
pub const PIPE_FORMAT_B8G8R8_SNORM: pipe_format = 100;
pub const PIPE_FORMAT_B8G8R8_USCALED: pipe_format = 101;
pub const PIPE_FORMAT_B8G8R8_SSCALED: pipe_format = 102;
pub const PIPE_FORMAT_B8G8R8A8_UINT: pipe_format = 103;
pub const PIPE_FORMAT_B8G8R8A8_SINT: pipe_format = 104;
pub const PIPE_FORMAT_B8G8R8A8_UNORM: pipe_format = 105;
pub const PIPE_FORMAT_B8G8R8A8_SNORM: pipe_format = 106;
pub const PIPE_FORMAT_B8G8R8A8_USCALED: pipe_format = 107;
pub const PIPE_FORMAT_B8G8R8A8_SSCALED: pipe_format = 108;
pub const PIPE_FORMAT_A8B8G8R8_USCALED: pipe_format = 109;
pub const PIPE_FORMAT_A8B8G8R8_SSCALED: pipe_format = 110;
pub const PIPE_FORMAT_A8R8G8B8_UNORM: pipe_format = 111;
pub const PIPE_FORMAT_R10G10B10A2_UINT: pipe_format = 112;
pub const PIPE_FORMAT_R10G10B10A2_SINT: pipe_format = 113;
pub const PIPE_FORMAT_R10G10B10A2_UNORM: pipe_format = 114;
pub const PIPE_FORMAT_R10G10B10A2_SNORM: pipe_format = 115;
pub const PIPE_FORMAT_R10G10B10A2_USCALED: pipe_format = 116;
pub const PIPE_FORMAT_R10G10B10A2_SSCALED: pipe_format = 117;
pub const PIPE_FORMAT_B10G10R10A2_UINT: pipe_format = 118;
pub const PIPE_FORMAT_B10G10R10A2_SINT: pipe_format = 119;
pub const PIPE_FORMAT_B10G10R10A2_UNORM: pipe_format = 120;
pub const PIPE_FORMAT_B10G10R10A2_SNORM: pipe_format = 121;
pub const PIPE_FORMAT_B10G10R10A2_USCALED: pipe_format = 122;
pub const PIPE_FORMAT_B10G10R10A2_SSCALED: pipe_format = 123;
pub const PIPE_FORMAT_R11G11B10_FLOAT: pipe_format = 124;
pub const PIPE_FORMAT_VERTEX_END: pipe_format = 124;
pub const PIPE_FORMAT_YUV_START: pipe_format = 125;
pub const PIPE_FORMAT_U8Y8V8Y8_422_UNORM: pipe_format = 125;
pub const PIPE_FORMAT_V8Y8U8Y8_422_UNORM: pipe_format = 126;
pub const PIPE_FORMAT_Y8U8Y8V8_422_UNORM: pipe_format = 127;
pub const PIPE_FORMAT_Y8V8Y8U8_422_UNORM: pipe_format = 128;
pub const PIPE_FORMAT_A8Y8U8V8_444_UNORM: pipe_format = 129;
pub const PIPE_FORMAT_X8Y8U8V8_444_UNORM: pipe_format = 130;
pub const PIPE_FORMAT_Y8_V8_U8_420_UNORM: pipe_format = 131;
pub const PIPE_FORMAT_Y8_V8_U8_422_UNORM: pipe_format = 132;
pub const PIPE_FORMAT_Y8_U8_V8_420_UNORM: pipe_format = 133;
pub const PIPE_FORMAT_Y8_U8V8_420_UNORM: pipe_format = 134;
pub const PIPE_FORMAT_Y8_V8U8_420_UNORM: pipe_format = 135;
pub const PIPE_FORMAT_Y8_400_UNORM: pipe_format = 136;
pub const PIPE_FORMAT_Y10_U10V10_420_UNORM: pipe_format = 137;
pub const PIPE_FORMAT_Y10_U10V10_422_UNORM: pipe_format = 138;
pub const PIPE_FORMAT_Y16_U16V16_444_UNORM: pipe_format = 139;
pub const PIPE_FORMAT_Y8_UNORM: pipe_format = 140;
pub const PIPE_FORMAT_Y8_U8_V8_422_UNORM: pipe_format = 141;
pub const PIPE_FORMAT_Y8_U8V8_422_UNORM: pipe_format = 142;
pub const PIPE_FORMAT_Y8_V8U8_422_UNORM: pipe_format = 143;
pub const PIPE_FORMAT_Y8_U8V8_444_UNORM: pipe_format = 144;
pub const PIPE_FORMAT_Y8_V8U8_444_UNORM: pipe_format = 145;
pub const PIPE_FORMAT_Y8_U8_V8_444_UNORM: pipe_format = 146;
pub const PIPE_FORMAT_Y8_U8_V8_440_UNORM: pipe_format = 147;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_420_UNORM: pipe_format = 148;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_420_UNORM: pipe_format = 149;
pub const PIPE_FORMAT_Y16_U16_V16_420_UNORM: pipe_format = 150;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_422_UNORM: pipe_format = 151;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_422_UNORM: pipe_format = 152;
pub const PIPE_FORMAT_Y16_U16_V16_422_UNORM: pipe_format = 153;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_444_UNORM: pipe_format = 154;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_444_UNORM: pipe_format = 155;
pub const PIPE_FORMAT_Y16_U16_V16_444_UNORM: pipe_format = 156;
pub const PIPE_FORMAT_Y16_U16V16_422_UNORM: pipe_format = 157;
pub const PIPE_FORMAT_X6Y10_X6U10X6V10_420_UNORM: pipe_format = 158;
pub const PIPE_FORMAT_X4Y12_X4U12X4V12_420_UNORM: pipe_format = 159;
pub const PIPE_FORMAT_Y16_U16V16_420_UNORM: pipe_format = 160;
pub const PIPE_FORMAT_Y10Y10Y10X2_U10V10U10X2V10U10V10X2_420_UNORM: pipe_format = 161;
pub const PIPE_FORMAT_X6Y10X6U10X6Y10X6V10_422_UNORM: pipe_format = 162;
pub const PIPE_FORMAT_X4Y12X4U12X4Y12X4V12_422_UNORM: pipe_format = 163;
pub const PIPE_FORMAT_Y16U16Y16V16_422_UNORM: pipe_format = 164;
pub const PIPE_FORMAT_U10Y10V10A2_444_UNORM: pipe_format = 165;
pub const PIPE_FORMAT_X4U12X4Y12X4V12X4A12_444_UNORM: pipe_format = 166;
pub const PIPE_FORMAT_U16Y16V16A16_444_UNORM: pipe_format = 167;
pub const PIPE_FORMAT_Y8U8V8_420_UNORM_PACKED: pipe_format = 168;
pub const PIPE_FORMAT_Y10U10V10_420_UNORM_PACKED: pipe_format = 169;
pub const PIPE_FORMAT_YUV_END: pipe_format = 169;
pub const PIPE_FORMAT_COMPR_START: pipe_format = 170;
pub const PIPE_FORMAT_DXT1_RGB: pipe_format = 170;
pub const PIPE_FORMAT_DXT1_RGBA: pipe_format = 171;
pub const PIPE_FORMAT_DXT3_RGBA: pipe_format = 172;
pub const PIPE_FORMAT_DXT5_RGBA: pipe_format = 173;
pub const PIPE_FORMAT_DXT1_SRGB: pipe_format = 174;
pub const PIPE_FORMAT_DXT1_SRGBA: pipe_format = 175;
pub const PIPE_FORMAT_DXT3_SRGBA: pipe_format = 176;
pub const PIPE_FORMAT_DXT5_SRGBA: pipe_format = 177;
pub const PIPE_FORMAT_RGTC1_UNORM: pipe_format = 178;
pub const PIPE_FORMAT_RGTC1_SNORM: pipe_format = 179;
pub const PIPE_FORMAT_RGTC2_UNORM: pipe_format = 180;
pub const PIPE_FORMAT_RGTC2_SNORM: pipe_format = 181;
pub const PIPE_FORMAT_LATC1_UNORM: pipe_format = 182;
pub const PIPE_FORMAT_LATC1_SNORM: pipe_format = 183;
pub const PIPE_FORMAT_LATC2_UNORM: pipe_format = 184;
pub const PIPE_FORMAT_LATC2_SNORM: pipe_format = 185;
pub const PIPE_FORMAT_ETC1_RGB8: pipe_format = 186;
pub const PIPE_FORMAT_ETC2_RGB8: pipe_format = 187;
pub const PIPE_FORMAT_ETC2_RGB8A1: pipe_format = 188;
pub const PIPE_FORMAT_ETC2_RGBA8: pipe_format = 189;
pub const PIPE_FORMAT_ETC2_R11_UNORM: pipe_format = 190;
pub const PIPE_FORMAT_ETC2_R11_SNORM: pipe_format = 191;
pub const PIPE_FORMAT_ETC2_RG11_UNORM: pipe_format = 192;
pub const PIPE_FORMAT_ETC2_RG11_SNORM: pipe_format = 193;
pub const PIPE_FORMAT_ETC2_SRGB8: pipe_format = 194;
pub const PIPE_FORMAT_ETC2_SRGB8A1: pipe_format = 195;
pub const PIPE_FORMAT_ETC2_SRGBA8: pipe_format = 196;
pub const PIPE_FORMAT_BPTC_RGBA_UNORM: pipe_format = 197;
pub const PIPE_FORMAT_BPTC_RGB_FLOAT: pipe_format = 198;
pub const PIPE_FORMAT_BPTC_RGB_UFLOAT: pipe_format = 199;
pub const PIPE_FORMAT_BPTC_SRGBA: pipe_format = 200;
pub const PIPE_FORMAT_ASTC_4x4: pipe_format = 201;
pub const PIPE_FORMAT_ASTC_5x4: pipe_format = 202;
pub const PIPE_FORMAT_ASTC_5x5: pipe_format = 203;
pub const PIPE_FORMAT_ASTC_6x5: pipe_format = 204;
pub const PIPE_FORMAT_ASTC_6x6: pipe_format = 205;
pub const PIPE_FORMAT_ASTC_8x5: pipe_format = 206;
pub const PIPE_FORMAT_ASTC_8x6: pipe_format = 207;
pub const PIPE_FORMAT_ASTC_8x8: pipe_format = 208;
pub const PIPE_FORMAT_ASTC_10x5: pipe_format = 209;
pub const PIPE_FORMAT_ASTC_10x6: pipe_format = 210;
pub const PIPE_FORMAT_ASTC_10x8: pipe_format = 211;
pub const PIPE_FORMAT_ASTC_10x10: pipe_format = 212;
pub const PIPE_FORMAT_ASTC_12x10: pipe_format = 213;
pub const PIPE_FORMAT_ASTC_12x12: pipe_format = 214;
pub const PIPE_FORMAT_ASTC_3x3x3: pipe_format = 215;
pub const PIPE_FORMAT_ASTC_4x3x3: pipe_format = 216;
pub const PIPE_FORMAT_ASTC_4x4x3: pipe_format = 217;
pub const PIPE_FORMAT_ASTC_4x4x4: pipe_format = 218;
pub const PIPE_FORMAT_ASTC_5x4x4: pipe_format = 219;
pub const PIPE_FORMAT_ASTC_5x5x4: pipe_format = 220;
pub const PIPE_FORMAT_ASTC_5x5x5: pipe_format = 221;
pub const PIPE_FORMAT_ASTC_6x5x5: pipe_format = 222;
pub const PIPE_FORMAT_ASTC_6x6x5: pipe_format = 223;
pub const PIPE_FORMAT_ASTC_6x6x6: pipe_format = 224;
pub const PIPE_FORMAT_ASTC_4x4_FLOAT: pipe_format = 225;
pub const PIPE_FORMAT_ASTC_5x4_FLOAT: pipe_format = 226;
pub const PIPE_FORMAT_ASTC_5x5_FLOAT: pipe_format = 227;
pub const PIPE_FORMAT_ASTC_6x5_FLOAT: pipe_format = 228;
pub const PIPE_FORMAT_ASTC_6x6_FLOAT: pipe_format = 229;
pub const PIPE_FORMAT_ASTC_8x5_FLOAT: pipe_format = 230;
pub const PIPE_FORMAT_ASTC_8x6_FLOAT: pipe_format = 231;
pub const PIPE_FORMAT_ASTC_8x8_FLOAT: pipe_format = 232;
pub const PIPE_FORMAT_ASTC_10x5_FLOAT: pipe_format = 233;
pub const PIPE_FORMAT_ASTC_10x6_FLOAT: pipe_format = 234;
pub const PIPE_FORMAT_ASTC_10x8_FLOAT: pipe_format = 235;
pub const PIPE_FORMAT_ASTC_10x10_FLOAT: pipe_format = 236;
pub const PIPE_FORMAT_ASTC_12x10_FLOAT: pipe_format = 237;
pub const PIPE_FORMAT_ASTC_12x12_FLOAT: pipe_format = 238;
pub const PIPE_FORMAT_ASTC_4x4_SRGB: pipe_format = 239;
pub const PIPE_FORMAT_ASTC_5x4_SRGB: pipe_format = 240;
pub const PIPE_FORMAT_ASTC_5x5_SRGB: pipe_format = 241;
pub const PIPE_FORMAT_ASTC_6x5_SRGB: pipe_format = 242;
pub const PIPE_FORMAT_ASTC_6x6_SRGB: pipe_format = 243;
pub const PIPE_FORMAT_ASTC_8x5_SRGB: pipe_format = 244;
pub const PIPE_FORMAT_ASTC_8x6_SRGB: pipe_format = 245;
pub const PIPE_FORMAT_ASTC_8x8_SRGB: pipe_format = 246;
pub const PIPE_FORMAT_ASTC_10x5_SRGB: pipe_format = 247;
pub const PIPE_FORMAT_ASTC_10x6_SRGB: pipe_format = 248;
pub const PIPE_FORMAT_ASTC_10x8_SRGB: pipe_format = 249;
pub const PIPE_FORMAT_ASTC_10x10_SRGB: pipe_format = 250;
pub const PIPE_FORMAT_ASTC_12x10_SRGB: pipe_format = 251;
pub const PIPE_FORMAT_ASTC_12x12_SRGB: pipe_format = 252;
pub const PIPE_FORMAT_ASTC_3x3x3_SRGB: pipe_format = 253;
pub const PIPE_FORMAT_ASTC_4x3x3_SRGB: pipe_format = 254;
pub const PIPE_FORMAT_ASTC_4x4x3_SRGB: pipe_format = 255;
pub const PIPE_FORMAT_ASTC_4x4x4_SRGB: pipe_format = 256;
pub const PIPE_FORMAT_ASTC_5x4x4_SRGB: pipe_format = 257;
pub const PIPE_FORMAT_ASTC_5x5x4_SRGB: pipe_format = 258;
pub const PIPE_FORMAT_ASTC_5x5x5_SRGB: pipe_format = 259;
pub const PIPE_FORMAT_ASTC_6x5x5_SRGB: pipe_format = 260;
pub const PIPE_FORMAT_ASTC_6x6x5_SRGB: pipe_format = 261;
pub const PIPE_FORMAT_ASTC_6x6x6_SRGB: pipe_format = 262;
pub const PIPE_FORMAT_ATC_RGB: pipe_format = 263;
pub const PIPE_FORMAT_ATC_RGBA_EXPLICIT: pipe_format = 264;
pub const PIPE_FORMAT_ATC_RGBA_INTERPOLATED: pipe_format = 265;
pub const PIPE_FORMAT_FXT1_RGB: pipe_format = 266;
pub const PIPE_FORMAT_FXT1_RGBA: pipe_format = 267;
pub const PIPE_FORMAT_COMPR_END: pipe_format = 267;
pub const PIPE_FORMAT_ZS_START: pipe_format = 268;
pub const PIPE_FORMAT_S8_UINT: pipe_format = 268;
pub const PIPE_FORMAT_Z16_UNORM: pipe_format = 269;
pub const PIPE_FORMAT_Z16_UNORM_S8_UINT: pipe_format = 270;
pub const PIPE_FORMAT_Z32_UNORM: pipe_format = 271;
pub const PIPE_FORMAT_Z32_FLOAT: pipe_format = 272;
pub const PIPE_FORMAT_Z24_UNORM_S8_UINT: pipe_format = 273;
pub const PIPE_FORMAT_S8_UINT_Z24_UNORM: pipe_format = 274;
pub const PIPE_FORMAT_X24S8_UINT: pipe_format = 275;
pub const PIPE_FORMAT_S8X24_UINT: pipe_format = 276;
pub const PIPE_FORMAT_Z24X8_UNORM: pipe_format = 277;
pub const PIPE_FORMAT_X8Z24_UNORM: pipe_format = 278;
pub const PIPE_FORMAT_Z24_UNORM_PACKED: pipe_format = 279;
pub const PIPE_FORMAT_Z32_FLOAT_S8X24_UINT: pipe_format = 280;
pub const PIPE_FORMAT_X32_S8X24_UINT: pipe_format = 281;
pub const PIPE_FORMAT_ZS_END: pipe_format = 281;
pub const PIPE_FORMAT_B8G8R8X8_UNORM: pipe_format = 282;
pub const PIPE_FORMAT_B8G8R8X8_SNORM: pipe_format = 283;
pub const PIPE_FORMAT_B8G8R8X8_UINT: pipe_format = 284;
pub const PIPE_FORMAT_B8G8R8X8_SINT: pipe_format = 285;
pub const PIPE_FORMAT_A8R8G8B8_SNORM: pipe_format = 286;
pub const PIPE_FORMAT_A8R8G8B8_SINT: pipe_format = 287;
pub const PIPE_FORMAT_X8R8G8B8_UNORM: pipe_format = 288;
pub const PIPE_FORMAT_X8R8G8B8_SNORM: pipe_format = 289;
pub const PIPE_FORMAT_X8R8G8B8_SINT: pipe_format = 290;
pub const PIPE_FORMAT_A8B8G8R8_UNORM: pipe_format = 291;
pub const PIPE_FORMAT_X8B8G8R8_UNORM: pipe_format = 292;
pub const PIPE_FORMAT_R8G8B8X8_UNORM: pipe_format = 293;
pub const PIPE_FORMAT_R5G5B5A1_UNORM: pipe_format = 294;
pub const PIPE_FORMAT_R5G5B5X1_UNORM: pipe_format = 295;
pub const PIPE_FORMAT_B5G5R5X1_UNORM: pipe_format = 296;
pub const PIPE_FORMAT_B5G5R5A1_UNORM: pipe_format = 297;
pub const PIPE_FORMAT_X1B5G5R5_UNORM: pipe_format = 298;
pub const PIPE_FORMAT_A1R5G5B5_UNORM: pipe_format = 299;
pub const PIPE_FORMAT_X1R5G5B5_UNORM: pipe_format = 300;
pub const PIPE_FORMAT_A1B5G5R5_UNORM: pipe_format = 301;
pub const PIPE_FORMAT_R4G4B4A4_UNORM: pipe_format = 302;
pub const PIPE_FORMAT_R4G4B4X4_UNORM: pipe_format = 303;
pub const PIPE_FORMAT_B4G4R4A4_UNORM: pipe_format = 304;
pub const PIPE_FORMAT_B4G4R4X4_UNORM: pipe_format = 305;
pub const PIPE_FORMAT_A4R4G4B4_UNORM: pipe_format = 306;
pub const PIPE_FORMAT_A4B4G4R4_UNORM: pipe_format = 307;
pub const PIPE_FORMAT_R5G6B5_UNORM: pipe_format = 308;
pub const PIPE_FORMAT_B5G6R5_UNORM: pipe_format = 309;
pub const PIPE_FORMAT_R10G10B10X2_UNORM: pipe_format = 310;
pub const PIPE_FORMAT_A2R10G10B10_UNORM: pipe_format = 311;
pub const PIPE_FORMAT_A2B10G10R10_UNORM: pipe_format = 312;
pub const PIPE_FORMAT_R3G3B2_UNORM: pipe_format = 313;
pub const PIPE_FORMAT_B2G3R3_UNORM: pipe_format = 314;
pub const PIPE_FORMAT_L8_UNORM: pipe_format = 315;
pub const PIPE_FORMAT_A8_UNORM: pipe_format = 316;
pub const PIPE_FORMAT_I8_UNORM: pipe_format = 317;
pub const PIPE_FORMAT_L4A4_UNORM: pipe_format = 318;
pub const PIPE_FORMAT_L8A8_UNORM: pipe_format = 319;
pub const PIPE_FORMAT_L16_UNORM: pipe_format = 320;
pub const PIPE_FORMAT_A16_UNORM: pipe_format = 321;
pub const PIPE_FORMAT_I16_UNORM: pipe_format = 322;
pub const PIPE_FORMAT_L16A16_UNORM: pipe_format = 323;
pub const PIPE_FORMAT_A8_SNORM: pipe_format = 324;
pub const PIPE_FORMAT_L8_SNORM: pipe_format = 325;
pub const PIPE_FORMAT_L8A8_SNORM: pipe_format = 326;
pub const PIPE_FORMAT_I8_SNORM: pipe_format = 327;
pub const PIPE_FORMAT_A16_SNORM: pipe_format = 328;
pub const PIPE_FORMAT_L16_SNORM: pipe_format = 329;
pub const PIPE_FORMAT_L16A16_SNORM: pipe_format = 330;
pub const PIPE_FORMAT_I16_SNORM: pipe_format = 331;
pub const PIPE_FORMAT_A16_FLOAT: pipe_format = 332;
pub const PIPE_FORMAT_L16_FLOAT: pipe_format = 333;
pub const PIPE_FORMAT_L16A16_FLOAT: pipe_format = 334;
pub const PIPE_FORMAT_I16_FLOAT: pipe_format = 335;
pub const PIPE_FORMAT_A32_FLOAT: pipe_format = 336;
pub const PIPE_FORMAT_L32_FLOAT: pipe_format = 337;
pub const PIPE_FORMAT_L32A32_FLOAT: pipe_format = 338;
pub const PIPE_FORMAT_I32_FLOAT: pipe_format = 339;
pub const PIPE_FORMAT_L8_SRGB: pipe_format = 340;
pub const PIPE_FORMAT_R8_SRGB: pipe_format = 341;
pub const PIPE_FORMAT_L8A8_SRGB: pipe_format = 342;
pub const PIPE_FORMAT_R8G8_SRGB: pipe_format = 343;
pub const PIPE_FORMAT_R8G8B8_SRGB: pipe_format = 344;
pub const PIPE_FORMAT_B8G8R8_SRGB: pipe_format = 345;
pub const PIPE_FORMAT_R8G8B8A8_SRGB: pipe_format = 346;
pub const PIPE_FORMAT_A8B8G8R8_SRGB: pipe_format = 347;
pub const PIPE_FORMAT_X8B8G8R8_SRGB: pipe_format = 348;
pub const PIPE_FORMAT_B8G8R8A8_SRGB: pipe_format = 349;
pub const PIPE_FORMAT_B8G8R8X8_SRGB: pipe_format = 350;
pub const PIPE_FORMAT_A8R8G8B8_SRGB: pipe_format = 351;
pub const PIPE_FORMAT_X8R8G8B8_SRGB: pipe_format = 352;
pub const PIPE_FORMAT_R8SG8SB8UX8U_NORM: pipe_format = 353;
pub const PIPE_FORMAT_R10SG10SB10SA2U_NORM: pipe_format = 354;
pub const PIPE_FORMAT_R5SG5SB6U_NORM: pipe_format = 355;
pub const PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8: pipe_format = 356;
pub const PIPE_FORMAT_R8G8_B8G8_422_UNORM: pipe_format = 357;
pub const PIPE_FORMAT_G8R8_G8B8_422_UNORM: pipe_format = 358;
pub const PIPE_FORMAT_G8R8_B8R8_422_UNORM: pipe_format = 359;
pub const PIPE_FORMAT_R8G8_R8B8_422_UNORM: pipe_format = 360;
pub const PIPE_FORMAT_B8R8_G8R8_422_UNORM: pipe_format = 361;
pub const PIPE_FORMAT_R8B8_R8G8_422_UNORM: pipe_format = 362;
pub const PIPE_FORMAT_G8B8_G8R8_422_UNORM: pipe_format = 363;
pub const PIPE_FORMAT_B8G8_R8G8_422_UNORM: pipe_format = 364;
pub const PIPE_FORMAT_R9G9B9E5_FLOAT: pipe_format = 365;
pub const PIPE_FORMAT_R1_UNORM: pipe_format = 366;
pub const PIPE_FORMAT_R8G8Bx_SNORM: pipe_format = 367;
pub const PIPE_FORMAT_R10G10B10X2_USCALED: pipe_format = 368;
pub const PIPE_FORMAT_R10G10B10X2_SNORM: pipe_format = 369;
pub const PIPE_FORMAT_R10G10B10X2_SINT: pipe_format = 370;
pub const PIPE_FORMAT_R8_G8B8_420_UNORM: pipe_format = 371;
pub const PIPE_FORMAT_R8_B8G8_420_UNORM: pipe_format = 372;
pub const PIPE_FORMAT_G8_B8R8_420_UNORM: pipe_format = 373;
pub const PIPE_FORMAT_R8_G8B8_422_UNORM: pipe_format = 374;
pub const PIPE_FORMAT_R8_B8G8_422_UNORM: pipe_format = 375;
pub const PIPE_FORMAT_G8_B8R8_422_UNORM: pipe_format = 376;
pub const PIPE_FORMAT_R10_G10B10_420_UNORM: pipe_format = 377;
pub const PIPE_FORMAT_R10_G10B10_422_UNORM: pipe_format = 378;
pub const PIPE_FORMAT_R8_G8_B8_420_UNORM: pipe_format = 379;
pub const PIPE_FORMAT_R8_B8_G8_420_UNORM: pipe_format = 380;
pub const PIPE_FORMAT_G8_B8_R8_420_UNORM: pipe_format = 381;
pub const PIPE_FORMAT_R8_G8_B8_444_UNORM: pipe_format = 382;
pub const PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM: pipe_format = 383;
pub const PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM: pipe_format = 384;
pub const PIPE_FORMAT_G8_B8R8_444_UNORM: pipe_format = 385;
pub const PIPE_FORMAT_X6G10_X6B10X6R10_444_UNORM: pipe_format = 386;
pub const PIPE_FORMAT_X4G12_X4B12X4R12_444_UNORM: pipe_format = 387;
pub const PIPE_FORMAT_R8G8B8_420_UNORM_PACKED: pipe_format = 388;
pub const PIPE_FORMAT_R10G10B10_420_UNORM_PACKED: pipe_format = 389;
pub const PIPE_FORMAT_X6R10_UNORM: pipe_format = 390;
pub const PIPE_FORMAT_X6R10X6G10_UNORM: pipe_format = 391;
pub const PIPE_FORMAT_X4R12_UNORM: pipe_format = 392;
pub const PIPE_FORMAT_X4R12X4G12_UNORM: pipe_format = 393;
pub const PIPE_FORMAT_A4R4_UNORM: pipe_format = 394;
pub const PIPE_FORMAT_R4A4_UNORM: pipe_format = 395;
pub const PIPE_FORMAT_R8A8_UNORM: pipe_format = 396;
pub const PIPE_FORMAT_A8R8_UNORM: pipe_format = 397;
pub const PIPE_FORMAT_A8_UINT: pipe_format = 398;
pub const PIPE_FORMAT_I8_UINT: pipe_format = 399;
pub const PIPE_FORMAT_L8_UINT: pipe_format = 400;
pub const PIPE_FORMAT_L8A8_UINT: pipe_format = 401;
pub const PIPE_FORMAT_A8_SINT: pipe_format = 402;
pub const PIPE_FORMAT_I8_SINT: pipe_format = 403;
pub const PIPE_FORMAT_L8_SINT: pipe_format = 404;
pub const PIPE_FORMAT_L8A8_SINT: pipe_format = 405;
pub const PIPE_FORMAT_A16_UINT: pipe_format = 406;
pub const PIPE_FORMAT_I16_UINT: pipe_format = 407;
pub const PIPE_FORMAT_L16_UINT: pipe_format = 408;
pub const PIPE_FORMAT_L16A16_UINT: pipe_format = 409;
pub const PIPE_FORMAT_A16_SINT: pipe_format = 410;
pub const PIPE_FORMAT_I16_SINT: pipe_format = 411;
pub const PIPE_FORMAT_L16_SINT: pipe_format = 412;
pub const PIPE_FORMAT_L16A16_SINT: pipe_format = 413;
pub const PIPE_FORMAT_A32_UINT: pipe_format = 414;
pub const PIPE_FORMAT_I32_UINT: pipe_format = 415;
pub const PIPE_FORMAT_L32_UINT: pipe_format = 416;
pub const PIPE_FORMAT_L32A32_UINT: pipe_format = 417;
pub const PIPE_FORMAT_A32_SINT: pipe_format = 418;
pub const PIPE_FORMAT_I32_SINT: pipe_format = 419;
pub const PIPE_FORMAT_L32_SINT: pipe_format = 420;
pub const PIPE_FORMAT_L32A32_SINT: pipe_format = 421;
pub const PIPE_FORMAT_A8R8G8B8_UINT: pipe_format = 422;
pub const PIPE_FORMAT_A8B8G8R8_UINT: pipe_format = 423;
pub const PIPE_FORMAT_A2R10G10B10_UINT: pipe_format = 424;
pub const PIPE_FORMAT_A2B10G10R10_UINT: pipe_format = 425;
pub const PIPE_FORMAT_R5G6B5_UINT: pipe_format = 426;
pub const PIPE_FORMAT_B5G6R5_UINT: pipe_format = 427;
pub const PIPE_FORMAT_R3G3B2_UINT: pipe_format = 428;
pub const PIPE_FORMAT_B2G3R3_UINT: pipe_format = 429;
pub const PIPE_FORMAT_R4G4B4A4_UINT: pipe_format = 430;
pub const PIPE_FORMAT_B4G4R4A4_UINT: pipe_format = 431;
pub const PIPE_FORMAT_A4R4G4B4_UINT: pipe_format = 432;
pub const PIPE_FORMAT_A4B4G4R4_UINT: pipe_format = 433;
pub const PIPE_FORMAT_A1R5G5B5_UINT: pipe_format = 434;
pub const PIPE_FORMAT_A1B5G5R5_UINT: pipe_format = 435;
pub const PIPE_FORMAT_R5G5B5A1_UINT: pipe_format = 436;
pub const PIPE_FORMAT_B5G5R5A1_UINT: pipe_format = 437;
pub const PIPE_FORMAT_R8G8B8X8_SNORM: pipe_format = 438;
pub const PIPE_FORMAT_R8G8B8X8_SRGB: pipe_format = 439;
pub const PIPE_FORMAT_R8G8B8X8_UINT: pipe_format = 440;
pub const PIPE_FORMAT_R8G8B8X8_SINT: pipe_format = 441;
pub const PIPE_FORMAT_B10G10R10X2_UNORM: pipe_format = 442;
pub const PIPE_FORMAT_B10G10R10X2_SNORM: pipe_format = 443;
pub const PIPE_FORMAT_B10G10R10X2_SINT: pipe_format = 444;
pub const PIPE_FORMAT_R16G16B16X16_UNORM: pipe_format = 445;
pub const PIPE_FORMAT_R16G16B16X16_SNORM: pipe_format = 446;
pub const PIPE_FORMAT_R16G16B16X16_FLOAT: pipe_format = 447;
pub const PIPE_FORMAT_R16G16B16X16_UINT: pipe_format = 448;
pub const PIPE_FORMAT_R16G16B16X16_SINT: pipe_format = 449;
pub const PIPE_FORMAT_R32G32B32X32_FLOAT: pipe_format = 450;
pub const PIPE_FORMAT_R32G32B32X32_UINT: pipe_format = 451;
pub const PIPE_FORMAT_R32G32B32X32_SINT: pipe_format = 452;
pub const PIPE_FORMAT_R8A8_SNORM: pipe_format = 453;
pub const PIPE_FORMAT_R16A16_UNORM: pipe_format = 454;
pub const PIPE_FORMAT_R16A16_SNORM: pipe_format = 455;
pub const PIPE_FORMAT_R16A16_FLOAT: pipe_format = 456;
pub const PIPE_FORMAT_R32A32_FLOAT: pipe_format = 457;
pub const PIPE_FORMAT_R8A8_UINT: pipe_format = 458;
pub const PIPE_FORMAT_R8A8_SINT: pipe_format = 459;
pub const PIPE_FORMAT_R16A16_UINT: pipe_format = 460;
pub const PIPE_FORMAT_R16A16_SINT: pipe_format = 461;
pub const PIPE_FORMAT_R32A32_UINT: pipe_format = 462;
pub const PIPE_FORMAT_R32A32_SINT: pipe_format = 463;
pub const PIPE_FORMAT_B5G6R5_SRGB: pipe_format = 464;
pub const PIPE_FORMAT_R5G6B5_SRGB: pipe_format = 465;
pub const PIPE_FORMAT_G8R8_UNORM: pipe_format = 466;
pub const PIPE_FORMAT_G8R8_SNORM: pipe_format = 467;
pub const PIPE_FORMAT_G8R8_SINT: pipe_format = 468;
pub const PIPE_FORMAT_G16R16_UNORM: pipe_format = 469;
pub const PIPE_FORMAT_G16R16_SNORM: pipe_format = 470;
pub const PIPE_FORMAT_G16R16_SINT: pipe_format = 471;
pub const PIPE_FORMAT_A8B8G8R8_SNORM: pipe_format = 472;
pub const PIPE_FORMAT_A8B8G8R8_SINT: pipe_format = 473;
pub const PIPE_FORMAT_X8B8G8R8_SNORM: pipe_format = 474;
pub const PIPE_FORMAT_X8B8G8R8_SINT: pipe_format = 475;
pub const PIPE_FORMAT_COUNT: pipe_format = 476;
#[doc = " Formats for textures, surfaces and vertex data"]
pub type pipe_format = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn glsl_type_singleton_init_or_ref();
}
unsafe extern "C" {
    pub fn glsl_type_singleton_decref();
}
pub type glsl_type_size_align_func = ::std::option::Option<
    unsafe extern "C" fn(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ),
>;
pub const GLSL_TYPE_UINT: glsl_base_type = 0;
pub const GLSL_TYPE_INT: glsl_base_type = 1;
pub const GLSL_TYPE_FLOAT: glsl_base_type = 2;
pub const GLSL_TYPE_FLOAT16: glsl_base_type = 3;
pub const GLSL_TYPE_BFLOAT16: glsl_base_type = 4;
pub const GLSL_TYPE_FLOAT_E4M3FN: glsl_base_type = 5;
pub const GLSL_TYPE_FLOAT_E5M2: glsl_base_type = 6;
pub const GLSL_TYPE_DOUBLE: glsl_base_type = 7;
pub const GLSL_TYPE_UINT8: glsl_base_type = 8;
pub const GLSL_TYPE_INT8: glsl_base_type = 9;
pub const GLSL_TYPE_UINT16: glsl_base_type = 10;
pub const GLSL_TYPE_INT16: glsl_base_type = 11;
pub const GLSL_TYPE_UINT64: glsl_base_type = 12;
pub const GLSL_TYPE_INT64: glsl_base_type = 13;
pub const GLSL_TYPE_BOOL: glsl_base_type = 14;
pub const GLSL_TYPE_COOPERATIVE_MATRIX: glsl_base_type = 15;
pub const GLSL_TYPE_SAMPLER: glsl_base_type = 16;
pub const GLSL_TYPE_TEXTURE: glsl_base_type = 17;
pub const GLSL_TYPE_IMAGE: glsl_base_type = 18;
pub const GLSL_TYPE_ATOMIC_UINT: glsl_base_type = 19;
pub const GLSL_TYPE_STRUCT: glsl_base_type = 20;
pub const GLSL_TYPE_INTERFACE: glsl_base_type = 21;
pub const GLSL_TYPE_ARRAY: glsl_base_type = 22;
pub const GLSL_TYPE_VOID: glsl_base_type = 23;
pub const GLSL_TYPE_SUBROUTINE: glsl_base_type = 24;
pub const GLSL_TYPE_ERROR: glsl_base_type = 25;
pub type glsl_base_type = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn glsl_apply_signedness_to_base_type(
        type_: glsl_base_type,
        signedness: bool,
    ) -> glsl_base_type;
}
unsafe extern "C" {
    pub fn glsl_get_sampler_dim_coordinate_components(
        dim: glsl_sampler_dim,
    ) -> ::std::os::raw::c_int;
}
#[doc = " The layout of the matrix is inherited from the object containing the\n matrix (the top level structure or the uniform block)."]
pub const GLSL_MATRIX_LAYOUT_INHERITED: glsl_matrix_layout = 0;
#[doc = " Explicit column-major layout\n\n If a uniform block doesn't have an explicit layout set, it will default\n to this layout."]
pub const GLSL_MATRIX_LAYOUT_COLUMN_MAJOR: glsl_matrix_layout = 1;
#[doc = " Row-major layout"]
pub const GLSL_MATRIX_LAYOUT_ROW_MAJOR: glsl_matrix_layout = 2;
pub type glsl_matrix_layout = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct glsl_cmat_description {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub rows: u8,
    pub cols: u8,
    pub use_: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_cmat_description"][::std::mem::size_of::<glsl_cmat_description>() - 4usize];
    ["Alignment of glsl_cmat_description"]
        [::std::mem::align_of::<glsl_cmat_description>() - 1usize];
    ["Offset of field: glsl_cmat_description::rows"]
        [::std::mem::offset_of!(glsl_cmat_description, rows) - 1usize];
    ["Offset of field: glsl_cmat_description::cols"]
        [::std::mem::offset_of!(glsl_cmat_description, cols) - 2usize];
    ["Offset of field: glsl_cmat_description::use_"]
        [::std::mem::offset_of!(glsl_cmat_description, use_) - 3usize];
};
impl glsl_cmat_description {
    #[inline]
    pub fn element_type(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u8) }
    }
    #[inline]
    pub fn set_element_type(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn element_type_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                5u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_element_type_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn scope(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_scope(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn scope_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                3u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_scope_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(element_type: u8, scope: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let element_type: u8 = unsafe { ::std::mem::transmute(element_type) };
            element_type as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let scope: u8 = unsafe { ::std::mem::transmute(scope) };
            scope as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn glsl_get_type_name(type_: *const glsl_type) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_type {
    pub gl_type: u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub cmat_desc: glsl_cmat_description,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = "< 1, 2, 3, or 4 vector elements."]
    pub vector_elements: u8,
    #[doc = "< 1, 2, 3, or 4 matrix columns."]
    pub matrix_columns: u8,
    #[doc = " For \\c GLSL_TYPE_ARRAY, this is the length of the array.  For\n \\c GLSL_TYPE_STRUCT or \\c GLSL_TYPE_INTERFACE, it is the number of\n elements in the structure and the number of values pointed to by\n \\c fields.structure (below)."]
    pub length: ::std::os::raw::c_uint,
    #[doc = " Identifier to the name of the data type\n\n Use glsl_get_type_name() to access the actual name."]
    pub name_id: usize,
    #[doc = " Explicit array, matrix, or vector stride.  This is used to communicate\n explicit array layouts from SPIR-V.  Should be 0 if the type has no\n explicit stride."]
    pub explicit_stride: ::std::os::raw::c_uint,
    #[doc = " Explicit alignment. This is used to communicate explicit alignment\n constraints. Should be 0 if the type has no explicit alignment\n constraint."]
    pub explicit_alignment: ::std::os::raw::c_uint,
    pub fields: glsl_type__bindgen_ty_1,
}
#[doc = " Subtype of composite data types."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_type__bindgen_ty_1 {
    #[doc = "< Type of array elements."]
    pub array: *const glsl_type,
    #[doc = "< List of struct fields."]
    pub structure: *const glsl_struct_field,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_type__bindgen_ty_1"][::std::mem::size_of::<glsl_type__bindgen_ty_1>() - 8usize];
    ["Alignment of glsl_type__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_type__bindgen_ty_1>() - 8usize];
    ["Offset of field: glsl_type__bindgen_ty_1::array"]
        [::std::mem::offset_of!(glsl_type__bindgen_ty_1, array) - 0usize];
    ["Offset of field: glsl_type__bindgen_ty_1::structure"]
        [::std::mem::offset_of!(glsl_type__bindgen_ty_1, structure) - 0usize];
};
impl Default for glsl_type__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_type"][::std::mem::size_of::<glsl_type>() - 48usize];
    ["Alignment of glsl_type"][::std::mem::align_of::<glsl_type>() - 8usize];
    ["Offset of field: glsl_type::gl_type"][::std::mem::offset_of!(glsl_type, gl_type) - 0usize];
    ["Offset of field: glsl_type::cmat_desc"]
        [::std::mem::offset_of!(glsl_type, cmat_desc) - 8usize];
    ["Offset of field: glsl_type::vector_elements"]
        [::std::mem::offset_of!(glsl_type, vector_elements) - 13usize];
    ["Offset of field: glsl_type::matrix_columns"]
        [::std::mem::offset_of!(glsl_type, matrix_columns) - 14usize];
    ["Offset of field: glsl_type::length"][::std::mem::offset_of!(glsl_type, length) - 16usize];
    ["Offset of field: glsl_type::name_id"][::std::mem::offset_of!(glsl_type, name_id) - 24usize];
    ["Offset of field: glsl_type::explicit_stride"]
        [::std::mem::offset_of!(glsl_type, explicit_stride) - 32usize];
    ["Offset of field: glsl_type::explicit_alignment"]
        [::std::mem::offset_of!(glsl_type, explicit_alignment) - 36usize];
    ["Offset of field: glsl_type::fields"][::std::mem::offset_of!(glsl_type, fields) - 40usize];
};
impl Default for glsl_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl glsl_type {
    #[inline]
    pub fn base_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_base_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn base_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_base_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampled_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sampled_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampled_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampled_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_dimensionality(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_dimensionality(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_dimensionality_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                4u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_dimensionality_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_shadow(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_shadow(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_shadow_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_shadow_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interface_packing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interface_packing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interface_packing_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interface_packing_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interface_row_major(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interface_row_major(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interface_row_major_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interface_row_major_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        base_type: glsl_base_type,
        sampled_type: glsl_base_type,
        sampler_dimensionality: ::std::os::raw::c_uint,
        sampler_shadow: ::std::os::raw::c_uint,
        sampler_array: ::std::os::raw::c_uint,
        interface_packing: ::std::os::raw::c_uint,
        interface_row_major: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let base_type: u32 = unsafe { ::std::mem::transmute(base_type) };
            base_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let sampled_type: u32 = unsafe { ::std::mem::transmute(sampled_type) };
            sampled_type as u64
        });
        __bindgen_bitfield_unit.set(16usize, 4u8, {
            let sampler_dimensionality: u32 =
                unsafe { ::std::mem::transmute(sampler_dimensionality) };
            sampler_dimensionality as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let sampler_shadow: u32 = unsafe { ::std::mem::transmute(sampler_shadow) };
            sampler_shadow as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let sampler_array: u32 = unsafe { ::std::mem::transmute(sampler_array) };
            sampler_array as u64
        });
        __bindgen_bitfield_unit.set(22usize, 2u8, {
            let interface_packing: u32 = unsafe { ::std::mem::transmute(interface_packing) };
            interface_packing as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let interface_row_major: u32 = unsafe { ::std::mem::transmute(interface_row_major) };
            interface_row_major as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn packed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_packed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn packed_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_packed_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_builtin_name(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_builtin_name(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_builtin_name_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_has_builtin_name_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        packed: ::std::os::raw::c_uint,
        has_builtin_name: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let packed: u32 = unsafe { ::std::mem::transmute(packed) };
            packed as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_builtin_name: u32 = unsafe { ::std::mem::transmute(has_builtin_name) };
            has_builtin_name as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_struct_field {
    pub type_: *const glsl_type,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " For interface blocks, gl_varying_slot corresponding to the input/output\n if this is a built-in input/output (i.e. a member of the built-in\n gl_PerVertex interface block); -1 otherwise.\n\n Ignored for structs."]
    pub location: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may explicitly assign the component used\n by a varying. Ignored for structs."]
    pub component: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may have an explicit byte offset\n specified; -1 otherwise. Also used for xfb_offset layout qualifier.\n\n Unless used for xfb_offset this field is ignored for structs."]
    pub offset: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback buffer;\n -1 otherwise."]
    pub xfb_buffer: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback stride;\n -1 otherwise."]
    pub xfb_stride: ::std::os::raw::c_int,
    #[doc = " Layout format, applicable to image variables only."]
    pub image_format: pipe_format,
    pub __bindgen_anon_1: glsl_struct_field__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_struct_field__bindgen_ty_1 {
    pub __bindgen_anon_1: glsl_struct_field__bindgen_ty_1__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Alignment of glsl_struct_field__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>() - 4usize];
};
impl glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interpolation_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interpolation_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn centroid_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_centroid_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sample_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn matrix_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_matrix_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn patch_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_patch_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_read_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_read_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_write_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_write_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_write_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_write_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_coherent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_coherent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_coherent_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_coherent_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_volatile(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_volatile(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_volatile_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_volatile_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_restrict(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_restrict(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_restrict_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_restrict_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_buffer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_buffer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn implicit_sized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_implicit_sized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_primitive(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_primitive(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_primitive_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_primitive_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        interpolation: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        memory_read_only: ::std::os::raw::c_uint,
        memory_write_only: ::std::os::raw::c_uint,
        memory_coherent: ::std::os::raw::c_uint,
        memory_volatile: ::std::os::raw::c_uint,
        memory_restrict: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
        per_primitive: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(5usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let memory_read_only: u32 = unsafe { ::std::mem::transmute(memory_read_only) };
            memory_read_only as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let memory_write_only: u32 = unsafe { ::std::mem::transmute(memory_write_only) };
            memory_write_only as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let memory_coherent: u32 = unsafe { ::std::mem::transmute(memory_coherent) };
            memory_coherent as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let memory_volatile: u32 = unsafe { ::std::mem::transmute(memory_volatile) };
            memory_volatile as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let memory_restrict: u32 = unsafe { ::std::mem::transmute(memory_restrict) };
            memory_restrict as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let per_primitive: u32 = unsafe { ::std::mem::transmute(per_primitive) };
            per_primitive as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field__bindgen_ty_1"]
        [::std::mem::size_of::<glsl_struct_field__bindgen_ty_1>() - 4usize];
    ["Alignment of glsl_struct_field__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_struct_field__bindgen_ty_1>() - 4usize];
    ["Offset of field: glsl_struct_field__bindgen_ty_1::flags"]
        [::std::mem::offset_of!(glsl_struct_field__bindgen_ty_1, flags) - 0usize];
};
impl Default for glsl_struct_field__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field"][::std::mem::size_of::<glsl_struct_field>() - 48usize];
    ["Alignment of glsl_struct_field"][::std::mem::align_of::<glsl_struct_field>() - 8usize];
    ["Offset of field: glsl_struct_field::type_"]
        [::std::mem::offset_of!(glsl_struct_field, type_) - 0usize];
    ["Offset of field: glsl_struct_field::name"]
        [::std::mem::offset_of!(glsl_struct_field, name) - 8usize];
    ["Offset of field: glsl_struct_field::location"]
        [::std::mem::offset_of!(glsl_struct_field, location) - 16usize];
    ["Offset of field: glsl_struct_field::component"]
        [::std::mem::offset_of!(glsl_struct_field, component) - 20usize];
    ["Offset of field: glsl_struct_field::offset"]
        [::std::mem::offset_of!(glsl_struct_field, offset) - 24usize];
    ["Offset of field: glsl_struct_field::xfb_buffer"]
        [::std::mem::offset_of!(glsl_struct_field, xfb_buffer) - 28usize];
    ["Offset of field: glsl_struct_field::xfb_stride"]
        [::std::mem::offset_of!(glsl_struct_field, xfb_stride) - 32usize];
    ["Offset of field: glsl_struct_field::image_format"]
        [::std::mem::offset_of!(glsl_struct_field, image_format) - 36usize];
};
impl Default for glsl_struct_field {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn glsl_type_is_vector(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_scalar(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_vector_or_scalar(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_matrix(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_array_or_matrix(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Query whether a 64-bit type takes two slots."]
    pub fn glsl_type_is_dual_slot(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_leaf(type_: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Gets the \"bare\" type without any decorations or layout information."]
    pub fn glsl_get_bare_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the basic scalar type which this type aggregates.\n\n If the type is a numeric or boolean scalar, vector, or matrix, or an\n array of any of those, this function gets the scalar type of the\n individual components.  For structs and arrays of structs, this function\n returns the struct type.  For samplers and arrays of samplers, this\n function returns the sampler type."]
    pub fn glsl_get_scalar_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " For numeric and boolean derived types returns the basic scalar type\n\n If the type is a numeric or boolean scalar, vector, or matrix type,\n this function gets the scalar type of the individual components.  For\n all other types, including arrays of numeric or boolean types, the\n error type is returned."]
    pub fn glsl_get_base_glsl_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_length(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_wrap_in_arrays(
        t: *const glsl_type,
        arrays: *const glsl_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Return the total number of elements in an array including the elements\n in arrays of arrays."]
    pub fn glsl_get_aoa_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_array_element(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the type stripped of any arrays\n\n \\return\n Pointer to the type of elements of the first non-array type for array\n types, or pointer to itself for non-array types."]
    pub fn glsl_without_array(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_without_array_or_matrix(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_cmat_element(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_cmat_description(t: *const glsl_type) -> *const glsl_cmat_description;
}
unsafe extern "C" {
    #[doc = " Return the amount of atomic counter storage required for a type."]
    pub fn glsl_atomic_size(type_: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Type A contains type B if A is B or A is a composite type (struct,\n interface, array) that has an element that contains B."]
    pub fn glsl_type_contains_32bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_contains_64bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_contains_image(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_atomic(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_double(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_integer(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_opaque(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_sampler(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_array(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_subroutine(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Return the number of coordinate components needed for this\n sampler or image type.\n\n This is based purely on the sampler's dimensionality.  For example, this\n returns 1 for sampler1D, and 3 for sampler2DArray.\n\n Note that this is often different than actual coordinate type used in\n a texturing built-in function, since those pack additional values (such\n as the shadow comparator or projector) into the coordinate type."]
    pub fn glsl_get_sampler_coordinate_components(t: *const glsl_type) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Compares whether this type matches another type without taking into\n account the precision in structures.\n\n This is applied recursively so that structures containing structure\n members can also ignore the precision."]
    pub fn glsl_type_compare_no_precision(a: *const glsl_type, b: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Compare a record type against another record type.\n\n This is useful for matching record types declared on the same shader\n stage as well as across different shader stages.\n The option to not match name is needed for matching record types\n declared across different shader stages.\n The option to not match locations is to deal with places where the\n same struct is defined in a block which has a location set on it."]
    pub fn glsl_record_compare(
        a: *const glsl_type,
        b: *const glsl_type,
        match_name: bool,
        match_locations: bool,
        match_precision: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn glsl_get_struct_field(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_struct_field_data(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_struct_field;
}
unsafe extern "C" {
    #[doc = " Calculate offset between the base location of the struct in\n uniform storage and a struct member.\n For the initial call, length is the index of the member to find the\n offset for."]
    pub fn glsl_get_struct_location_offset(
        t: *const glsl_type,
        length: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Get the location of a field within a record type"]
    pub fn glsl_get_field_index(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Get the type of a structure field\n\n \\return\n Pointer to the type of the named field.  If the type is not a structure\n or the named field does not exist, \\c &glsl_type_builtin_error is returned."]
    pub fn glsl_get_field_type(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_f16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bf16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_e4m3fnvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_e5m2vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_dvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_ivec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_uvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_simple_explicit_type(
        base_type: ::std::os::raw::c_uint,
        rows: ::std::os::raw::c_uint,
        columns: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
        row_major: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_sampler_type(
        dim: glsl_sampler_dim,
        shadow: bool,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bare_sampler_type() -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bare_shadow_sampler_type() -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_texture_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_image_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_array_type(
        element: *const glsl_type,
        array_size: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_cmat_type(desc: *const glsl_cmat_description) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_struct_type_with_explicit_alignment(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        name: *const ::std::os::raw::c_char,
        packed: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_interface_type(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        packing: glsl_interface_packing,
        row_major: bool,
        block_name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_subroutine_type(subroutine_name: *const ::std::os::raw::c_char)
        -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Query the full type of a matrix row\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the rows of the matrix is returned."]
    pub fn glsl_get_row_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Query the full type of a matrix column\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the columns of the matrix is returned."]
    pub fn glsl_get_column_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Returns an explicitly laid out type given a type and size/align func\n\n The size/align func is only called for scalar and vector types and the\n returned type is otherwise laid out in the natural way as follows:\n\n  - Arrays and matrices have a stride of align(elem_size, elem_align).\n\n  - Structure types have their elements in-order and as tightly packed as\n    possible following the alignment required by the size/align func.\n\n  - All composite types (structures, matrices, and arrays) have an\n    alignment equal to the highest alignment of any member of the composite.\n\n The types returned by this function are likely not suitable for most UBO\n or SSBO layout because they do not add the extra array and substructure\n alignment that is required by std140 and std430."]
    pub fn glsl_get_explicit_type_for_size_align(
        type_: *const glsl_type,
        type_info: glsl_type_size_align_func,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_replace_vec3_with_vec4(type_: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the float16 version of this type."]
    pub fn glsl_float16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the int16 version of this type."]
    pub fn glsl_int16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the uint16 version of this type."]
    pub fn glsl_uint16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_to_16bit(old_type: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_replace_vector_type(
        t: *const glsl_type,
        components: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_channel_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the type resulting from a multiplication of \\p type_a * \\p type_b"]
    pub fn glsl_get_mul_type(
        type_a: *const glsl_type,
        type_b: *const glsl_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_get_sampler_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_get_texture_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_get_image_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n count_attribute_slots() (vertex inputs and varyings) but also for\n gallium's !pipe_caps.packed_uniforms case."]
    pub fn glsl_count_vec4_slots(
        t: *const glsl_type,
        is_gl_vertex_input: bool,
        is_bindless: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n gallium's pipe_caps.packed_uniforms case."]
    pub fn glsl_count_dword_slots(t: *const glsl_type, is_bindless: bool)
        -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of components slots required to hold this type\n\n This is used to determine how many uniform or varying locations a type\n might occupy."]
    pub fn glsl_get_component_slots(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_component_slots_aligned(
        t: *const glsl_type,
        offset: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Used to count the number of varyings contained in the type ignoring\n innermost array elements."]
    pub fn glsl_varying_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of unique values from glGetUniformLocation for the\n elements of the type.\n\n This is used to allocate slots in the UniformRemapTable, the amount of\n locations may not match with actual used storage space by the driver."]
    pub fn glsl_type_uniform_locations(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in OpenCL memory"]
    pub fn glsl_get_cl_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in OpenCL memory."]
    pub fn glsl_get_cl_alignment(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_cl_type_size_align(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Get the type interface packing used internally. For shared and packing\n layouts this is implementation defined."]
    pub fn glsl_get_internal_ifc_packing(
        t: *const glsl_type,
        std430_supported: bool,
    ) -> glsl_interface_packing;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std140 uniform\n block."]
    pub fn glsl_get_std140_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in a std140 uniform block.\n\n Note that this is not GL_UNIFORM_SIZE (which is the number of\n elements in the array)"]
    pub fn glsl_get_std140_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate array stride in bytes of this type in a std430 shader storage\n block."]
    pub fn glsl_get_std430_array_stride(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std430 shader\n storage block."]
    pub fn glsl_get_std430_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in a std430 shader storage block.\n\n Note that this is not GL_BUFFER_SIZE"]
    pub fn glsl_get_std430_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type based on its explicit data.\n\n When using SPIR-V shaders (ARB_gl_spirv), memory layouts are expressed\n through explicit offset, stride and matrix layout, so the size\n can/should be computed used those values.\n\n Note that the value returned by this method is only correct if such\n values are set, so only with SPIR-V shaders. Should not be used with\n GLSL shaders."]
    pub fn glsl_get_explicit_size(
        t: *const glsl_type,
        align_to_stride: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Gets an explicitly laid out type with the std140 layout."]
    pub fn glsl_get_explicit_std140_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets an explicitly laid out type with the std430 layout."]
    pub fn glsl_get_explicit_std430_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_size_align_handle_array_and_structs(
        type_: *const glsl_type,
        size_align: glsl_type_size_align_func,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_natural_size_align_bytes(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_word_size_align_bytes(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_vec4_size_align_bytes(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gc_ctx {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct exec_node {
    pub next: *mut exec_node,
    pub prev: *mut exec_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of exec_node"][::std::mem::size_of::<exec_node>() - 16usize];
    ["Alignment of exec_node"][::std::mem::align_of::<exec_node>() - 8usize];
    ["Offset of field: exec_node::next"][::std::mem::offset_of!(exec_node, next) - 0usize];
    ["Offset of field: exec_node::prev"][::std::mem::offset_of!(exec_node, prev) - 8usize];
};
impl Default for exec_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct exec_list {
    pub head_sentinel: exec_node,
    pub tail_sentinel: exec_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of exec_list"][::std::mem::size_of::<exec_list>() - 32usize];
    ["Alignment of exec_list"][::std::mem::align_of::<exec_list>() - 8usize];
    ["Offset of field: exec_list::head_sentinel"]
        [::std::mem::offset_of!(exec_list, head_sentinel) - 0usize];
    ["Offset of field: exec_list::tail_sentinel"]
        [::std::mem::offset_of!(exec_list, tail_sentinel) - 16usize];
};
impl Default for exec_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type blake3_hash = [u8; 32usize];
#[repr(C)]
#[derive(Copy, Clone)]
pub struct shader_info {
    pub name: *const ::std::os::raw::c_char,
    pub label: *const ::std::os::raw::c_char,
    pub internal: bool,
    pub source_blake3: blake3_hash,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub prev_stage_has_xfb: bool,
    pub num_textures: u8,
    pub num_ubos: u8,
    pub num_abos: u8,
    pub num_ssbos: u8,
    pub num_images: u8,
    pub inputs_read: u64,
    pub dual_slot_inputs: u64,
    pub outputs_written: u64,
    pub outputs_read: u64,
    pub system_values_read: [::std::os::raw::c_uint; 4usize],
    pub perspective_varyings: u64,
    pub linear_varyings: u64,
    pub per_primitive_inputs: u64,
    pub per_primitive_outputs: u64,
    pub per_view_outputs: u64,
    pub view_mask: u32,
    pub inputs_read_16bit: u16,
    pub outputs_written_16bit: u16,
    pub outputs_read_16bit: u16,
    pub inputs_read_indirectly_16bit: u16,
    pub outputs_read_indirectly_16bit: u16,
    pub outputs_written_indirectly_16bit: u16,
    pub patch_inputs_read: u32,
    pub patch_outputs_written: u32,
    pub patch_outputs_read: u32,
    pub inputs_read_indirectly: u64,
    pub outputs_read_indirectly: u64,
    pub outputs_written_indirectly: u64,
    pub patch_inputs_read_indirectly: u32,
    pub patch_outputs_read_indirectly: u32,
    pub patch_outputs_written_indirectly: u32,
    #[doc = " Bitfield of which textures are used"]
    pub textures_used: [::std::os::raw::c_uint; 4usize],
    #[doc = " Bitfield of which textures are used by texelFetch()"]
    pub textures_used_by_txf: [::std::os::raw::c_uint; 4usize],
    #[doc = " Bitfield of which samplers are used"]
    pub samplers_used: [::std::os::raw::c_uint; 1usize],
    #[doc = " Bitfield of which images are used"]
    pub images_used: [::std::os::raw::c_uint; 2usize],
    #[doc = " Bitfield of which images are buffers."]
    pub image_buffers: [::std::os::raw::c_uint; 2usize],
    #[doc = " Bitfield of which images are MSAA."]
    pub msaa_images: [::std::os::raw::c_uint; 2usize],
    pub float_controls_execution_mode: u32,
    #[doc = " Size of shared variables accessed by compute/task/mesh shaders."]
    pub shared_size: ::std::os::raw::c_uint,
    #[doc = " Size of task payload variables accessed by task/mesh shaders."]
    pub task_payload_size: ::std::os::raw::c_uint,
    #[doc = " Number of ray tracing queries in the shader (counts all elements of all\n variables)."]
    pub ray_queries: ::std::os::raw::c_uint,
    #[doc = " Local workgroup size used by compute/task/mesh shaders."]
    pub workgroup_size: [u16; 3usize],
    pub num_subgroups: u8,
    pub api_subgroup_size: u8,
    pub max_subgroup_size: u8,
    pub min_subgroup_size: u8,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub xfb_stride: [u8; 4usize],
    pub inlinable_uniform_dw_offsets: [u16; 4usize],
    pub _bitfield_align_3: [u8; 0],
    pub _bitfield_3: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub bit_sizes_float: u8,
    pub bit_sizes_int: u8,
    pub _bitfield_align_4: [u8; 0],
    pub _bitfield_4: __BindgenBitfieldUnit<[u8; 3usize]>,
    #[doc = " Set if this shader uses legacy (DX9 or ARB assembly) math rules.\n\n From the ARB_fragment_program specification:\n\n    \"The following rules apply to multiplication:\n\n      1. <x> * <y> == <y> * <x>, for all <x> and <y>.\n      2. +/-0.0 * <x> = +/-0.0, at least for all <x> that correspond to\n         *representable numbers (IEEE \"not a number\" and \"infinity\"\n         *encodings may be exceptions).\n      3. +1.0 * <x> = <x>, for all <x>.\"\"\n\n However, in effect this was due to DX9 semantics implying that 0*x=0 even\n for inf/nan if the hardware generated them instead of float_min/max.  So,\n you should not have an exception for inf/nan to rule 2 above.\n\n One implementation of this behavior would be to flush all generated NaNs\n to zero, at which point 0*Inf=Nan=0.  Most DX9/ARB-asm hardware did not\n generate NaNs, and the only way the GPU saw one was to possibly feed it\n in as a uniform."]
    pub use_legacy_math_rules: bool,
    pub _bitfield_align_5: [u8; 0],
    pub _bitfield_5: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_anon_1: shader_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union shader_info__bindgen_ty_1 {
    pub vs: shader_info__bindgen_ty_1__bindgen_ty_1,
    pub gs: shader_info__bindgen_ty_1__bindgen_ty_2,
    pub fs: shader_info__bindgen_ty_1__bindgen_ty_3,
    pub cs: shader_info__bindgen_ty_1__bindgen_ty_4,
    pub tess: shader_info__bindgen_ty_1__bindgen_ty_5,
    pub mesh: shader_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_1 {
    pub double_inputs: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 16usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_1::double_inputs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_1, double_inputs) - 0usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn blit_sgprs_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_blit_sgprs_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn blit_sgprs_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_blit_sgprs_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn tes_agx(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_tes_agx(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn tes_agx_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_tes_agx_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn window_space_position(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_window_space_position(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn window_space_position_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_window_space_position_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_edge_flag(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_edge_flag(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_edge_flag_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_edge_flag_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        blit_sgprs_amd: u8,
        tes_agx: bool,
        window_space_position: bool,
        needs_edge_flag: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let blit_sgprs_amd: u8 = unsafe { ::std::mem::transmute(blit_sgprs_amd) };
            blit_sgprs_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let tes_agx: u8 = unsafe { ::std::mem::transmute(tes_agx) };
            tes_agx as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let window_space_position: u8 = unsafe { ::std::mem::transmute(window_space_position) };
            window_space_position as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_edge_flag: u8 = unsafe { ::std::mem::transmute(needs_edge_flag) };
            needs_edge_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " The output primitive type"]
    pub output_primitive: mesa_prim,
    #[doc = " The input primitive type"]
    pub input_primitive: mesa_prim,
    #[doc = " The maximum number of vertices the geometry shader might write."]
    pub vertices_out: u16,
    #[doc = " 1 .. MAX_GEOMETRY_SHADER_INVOCATIONS"]
    pub invocations: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 6usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::output_primitive"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_2,
        output_primitive
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::input_primitive"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, input_primitive) - 1usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::vertices_out"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, vertices_out) - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::invocations"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, invocations) - 4usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn vertices_in(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_vertices_in(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn vertices_in_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_vertices_in_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_end_primitive(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_end_primitive(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_end_primitive_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_end_primitive_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn active_stream_mask(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_active_stream_mask(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn active_stream_mask_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_active_stream_mask_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vertices_in: u8,
        uses_end_primitive: bool,
        active_stream_mask: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let vertices_in: u8 = unsafe { ::std::mem::transmute(vertices_in) };
            vertices_in as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let uses_end_primitive: u8 = unsafe { ::std::mem::transmute(uses_end_primitive) };
            uses_end_primitive as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let active_stream_mask: u8 = unsafe { ::std::mem::transmute(active_stream_mask) };
            active_stream_mask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 5usize]>,
    pub advanced_blend_modes: ::std::os::raw::c_uint,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 16usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_3::advanced_blend_modes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_3,
        advanced_blend_modes
    ) - 8usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn uses_discard(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_discard(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_discard_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_discard_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_fbfetch_output(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_fbfetch_output(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_fbfetch_output_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_fbfetch_output_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fbfetch_coherent(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fbfetch_coherent(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fbfetch_coherent_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fbfetch_coherent_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color_is_dual_source(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color_is_dual_source(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color_is_dual_source_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color_is_dual_source_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn require_full_quads(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_require_full_quads(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn require_full_quads_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_require_full_quads_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn quad_derivatives_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_quad_derivatives_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_coarse_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_coarse_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_coarse_quad_helper_invocations_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_coarse_quad_helper_invocations_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_full_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_full_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_full_quad_helper_invocations_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_full_quad_helper_invocations_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_qualifier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_qualifier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_qualifier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_qualifier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_shading(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_shading(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_shading_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_shading_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn early_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn inner_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_inner_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn inner_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_inner_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn post_depth_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_post_depth_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn post_depth_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_post_depth_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_center_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_center_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn origin_upper_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_origin_upper_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn untyped_color_outputs(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_untyped_color_outputs(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn untyped_color_outputs_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_untyped_color_outputs_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> gl_frag_depth_layout {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn depth_layout_raw(this: *const Self) -> gl_frag_depth_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_depth_layout_raw(this: *mut Self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color0_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color0_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color1_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color1_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 5usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                32usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 5usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                32usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uses_discard: bool,
        uses_fbfetch_output: bool,
        fbfetch_coherent: bool,
        color_is_dual_source: bool,
        require_full_quads: bool,
        quad_derivatives: bool,
        needs_coarse_quad_helper_invocations: bool,
        needs_full_quad_helper_invocations: bool,
        uses_sample_qualifier: bool,
        uses_sample_shading: bool,
        early_fragment_tests: bool,
        inner_coverage: bool,
        post_depth_coverage: bool,
        pixel_center_integer: bool,
        origin_upper_left: bool,
        pixel_interlock_ordered: bool,
        pixel_interlock_unordered: bool,
        sample_interlock_ordered: bool,
        sample_interlock_unordered: bool,
        untyped_color_outputs: bool,
        depth_layout: gl_frag_depth_layout,
        color0_interp: ::std::os::raw::c_uint,
        color0_sample: bool,
        color0_centroid: bool,
        color1_interp: ::std::os::raw::c_uint,
        color1_sample: bool,
        color1_centroid: bool,
    ) -> __BindgenBitfieldUnit<[u8; 5usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 5usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uses_discard: u8 = unsafe { ::std::mem::transmute(uses_discard) };
            uses_discard as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uses_fbfetch_output: u8 = unsafe { ::std::mem::transmute(uses_fbfetch_output) };
            uses_fbfetch_output as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fbfetch_coherent: u8 = unsafe { ::std::mem::transmute(fbfetch_coherent) };
            fbfetch_coherent as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let color_is_dual_source: u8 = unsafe { ::std::mem::transmute(color_is_dual_source) };
            color_is_dual_source as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let require_full_quads: u8 = unsafe { ::std::mem::transmute(require_full_quads) };
            require_full_quads as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let quad_derivatives: u8 = unsafe { ::std::mem::transmute(quad_derivatives) };
            quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_coarse_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_coarse_quad_helper_invocations) };
            needs_coarse_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let needs_full_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_full_quad_helper_invocations) };
            needs_full_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_sample_qualifier: u8 = unsafe { ::std::mem::transmute(uses_sample_qualifier) };
            uses_sample_qualifier as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_sample_shading: u8 = unsafe { ::std::mem::transmute(uses_sample_shading) };
            uses_sample_shading as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let early_fragment_tests: u8 = unsafe { ::std::mem::transmute(early_fragment_tests) };
            early_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let inner_coverage: u8 = unsafe { ::std::mem::transmute(inner_coverage) };
            inner_coverage as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let post_depth_coverage: u8 = unsafe { ::std::mem::transmute(post_depth_coverage) };
            post_depth_coverage as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let pixel_center_integer: u8 = unsafe { ::std::mem::transmute(pixel_center_integer) };
            pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let origin_upper_left: u8 = unsafe { ::std::mem::transmute(origin_upper_left) };
            origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pixel_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_ordered) };
            pixel_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let pixel_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_unordered) };
            pixel_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let sample_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_ordered) };
            sample_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let sample_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_unordered) };
            sample_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let untyped_color_outputs: u8 = unsafe { ::std::mem::transmute(untyped_color_outputs) };
            untyped_color_outputs as u64
        });
        __bindgen_bitfield_unit.set(20usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(23usize, 3u8, {
            let color0_interp: u32 = unsafe { ::std::mem::transmute(color0_interp) };
            color0_interp as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let color0_sample: u8 = unsafe { ::std::mem::transmute(color0_sample) };
            color0_sample as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let color0_centroid: u8 = unsafe { ::std::mem::transmute(color0_centroid) };
            color0_centroid as u64
        });
        __bindgen_bitfield_unit.set(28usize, 3u8, {
            let color1_interp: u32 = unsafe { ::std::mem::transmute(color1_interp) };
            color1_interp as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let color1_sample: u8 = unsafe { ::std::mem::transmute(color1_sample) };
            color1_sample as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let color1_centroid: u8 = unsafe { ::std::mem::transmute(color1_centroid) };
            color1_centroid as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn early_and_late_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_and_late_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_and_late_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_and_late_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_front_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_front_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_front_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_front_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_back_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_back_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_back_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_back_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        early_and_late_fragment_tests: bool,
        stencil_front_layout: gl_frag_stencil_layout,
        stencil_back_layout: gl_frag_stencil_layout,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let early_and_late_fragment_tests: u8 =
                unsafe { ::std::mem::transmute(early_and_late_fragment_tests) };
            early_and_late_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let stencil_front_layout: u32 = unsafe { ::std::mem::transmute(stencil_front_layout) };
            stencil_front_layout as u64
        });
        __bindgen_bitfield_unit.set(4usize, 3u8, {
            let stencil_back_layout: u32 = unsafe { ::std::mem::transmute(stencil_back_layout) };
            stencil_back_layout as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_4 {
    pub workgroup_size_hint: [u16; 3usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Number of bytes of shared imageblock memory per thread. Currently,\n this requires that the workgroup size is 32x32x1 and that\n shared_size = 0. These requirements could be lifted in the future.\n However, there is no current OpenGL/Vulkan API support for\n imageblocks. This is only used internally to accelerate blit/copy."]
    pub image_block_size_per_thread_agx: u8,
    #[doc = " pointer size is:\n   AddressingModelLogical:    0    (default)\n   AddressingModelPhysical32: 32\n   AddressingModelPhysical64: 64"]
    pub ptr_size: ::std::os::raw::c_uint,
    #[doc = " Index provided by VkPipelineShaderStageNodeCreateInfoAMDX or ShaderIndexAMDX"]
    pub shader_index: u32,
    #[doc = " Maximum size required by any output node payload array"]
    pub node_payloads_size: u32,
    #[doc = " Static workgroup count for overwriting the enqueued workgroup count. (0 if dynamic)"]
    pub workgroup_count: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_size_hint"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_size_hint
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::image_block_size_per_thread_agx"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        image_block_size_per_thread_agx
    )
        - 7usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::ptr_size"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, ptr_size) - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::shader_index"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, shader_index) - 12usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::node_payloads_size"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        node_payloads_size
    ) - 16usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_count"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_count
    ) - 20usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_4 {
    #[inline]
    pub fn user_data_components_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_user_data_components_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn user_data_components_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_user_data_components_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_variable_shared_mem(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_variable_shared_mem(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_variable_shared_mem_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_variable_shared_mem_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_cooperative_matrix(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_cooperative_matrix(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_cooperative_matrix_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_cooperative_matrix_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        user_data_components_amd: u8,
        has_variable_shared_mem: bool,
        has_cooperative_matrix: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let user_data_components_amd: u8 =
                unsafe { ::std::mem::transmute(user_data_components_amd) };
            user_data_components_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let has_variable_shared_mem: u8 =
                unsafe { ::std::mem::transmute(has_variable_shared_mem) };
            has_variable_shared_mem as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let has_cooperative_matrix: u8 =
                unsafe { ::std::mem::transmute(has_cooperative_matrix) };
            has_cooperative_matrix as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_5 {
    pub _primitive_mode: tess_primitive_mode,
    #[doc = " The number of vertices in the TCS output patch."]
    pub tcs_vertices_out: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub tcs_same_invocation_inputs_read: u64,
    pub tcs_cross_invocation_inputs_read: u64,
    pub tcs_cross_invocation_outputs_read: u64,
    pub tcs_cross_invocation_outputs_written: u64,
    pub tcs_outputs_read_by_tes: u64,
    pub tcs_patch_outputs_read_by_tes: u32,
    pub tcs_outputs_read_by_tes_16bit: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 56usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::_primitive_mode"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_5, _primitive_mode) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_vertices_out
    ) - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_same_invocation_inputs_read"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_same_invocation_inputs_read
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_inputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_inputs_read) - 16usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_outputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_outputs_read) - 24usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_outputs_written"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_outputs_written) - 32usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_outputs_read_by_tes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_outputs_read_by_tes
    )
        - 40usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_patch_outputs_read_by_tes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_patch_outputs_read_by_tes
    )
        - 48usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_outputs_read_by_tes_16bit"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_outputs_read_by_tes_16bit
    )
        - 52usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_5 {
    #[inline]
    pub fn spacing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_spacing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn spacing_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_spacing_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ccw(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_ccw(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ccw_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_ccw_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn point_mode(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_mode(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn point_mode_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_point_mode_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        spacing: ::std::os::raw::c_uint,
        ccw: bool,
        point_mode: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let spacing: u32 = unsafe { ::std::mem::transmute(spacing) };
            spacing as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let ccw: u8 = unsafe { ::std::mem::transmute(ccw) };
            ccw as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let point_mode: u8 = unsafe { ::std::mem::transmute(point_mode) };
            point_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_6 {
    pub ms_cross_invocation_output_access: u64,
    pub ts_mesh_dispatch_dimensions: [u32; 3usize],
    pub max_vertices_out: u16,
    pub max_primitives_out: u16,
    pub primitive_type: mesa_prim,
    pub nv: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ms_cross_invocation_output_access"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_6 , ms_cross_invocation_output_access) - 0usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ts_mesh_dispatch_dimensions"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        ts_mesh_dispatch_dimensions
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_vertices_out
    ) - 20usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_primitives_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_primitives_out
    ) - 22usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::primitive_type"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, primitive_type) - 24usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::nv"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, nv) - 25usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1>() - 56usize];
    ["Alignment of shader_info__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1>() - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1::vs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, vs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::gs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, gs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::fs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, fs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::cs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, cs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::tess"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, tess) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::mesh"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, mesh) - 0usize];
};
impl Default for shader_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info"][::std::mem::size_of::<shader_info>() - 392usize];
    ["Alignment of shader_info"][::std::mem::align_of::<shader_info>() - 8usize];
    ["Offset of field: shader_info::name"][::std::mem::offset_of!(shader_info, name) - 0usize];
    ["Offset of field: shader_info::label"][::std::mem::offset_of!(shader_info, label) - 8usize];
    ["Offset of field: shader_info::internal"]
        [::std::mem::offset_of!(shader_info, internal) - 16usize];
    ["Offset of field: shader_info::source_blake3"]
        [::std::mem::offset_of!(shader_info, source_blake3) - 17usize];
    ["Offset of field: shader_info::prev_stage_has_xfb"]
        [::std::mem::offset_of!(shader_info, prev_stage_has_xfb) - 52usize];
    ["Offset of field: shader_info::num_textures"]
        [::std::mem::offset_of!(shader_info, num_textures) - 53usize];
    ["Offset of field: shader_info::num_ubos"]
        [::std::mem::offset_of!(shader_info, num_ubos) - 54usize];
    ["Offset of field: shader_info::num_abos"]
        [::std::mem::offset_of!(shader_info, num_abos) - 55usize];
    ["Offset of field: shader_info::num_ssbos"]
        [::std::mem::offset_of!(shader_info, num_ssbos) - 56usize];
    ["Offset of field: shader_info::num_images"]
        [::std::mem::offset_of!(shader_info, num_images) - 57usize];
    ["Offset of field: shader_info::inputs_read"]
        [::std::mem::offset_of!(shader_info, inputs_read) - 64usize];
    ["Offset of field: shader_info::dual_slot_inputs"]
        [::std::mem::offset_of!(shader_info, dual_slot_inputs) - 72usize];
    ["Offset of field: shader_info::outputs_written"]
        [::std::mem::offset_of!(shader_info, outputs_written) - 80usize];
    ["Offset of field: shader_info::outputs_read"]
        [::std::mem::offset_of!(shader_info, outputs_read) - 88usize];
    ["Offset of field: shader_info::system_values_read"]
        [::std::mem::offset_of!(shader_info, system_values_read) - 96usize];
    ["Offset of field: shader_info::perspective_varyings"]
        [::std::mem::offset_of!(shader_info, perspective_varyings) - 112usize];
    ["Offset of field: shader_info::linear_varyings"]
        [::std::mem::offset_of!(shader_info, linear_varyings) - 120usize];
    ["Offset of field: shader_info::per_primitive_inputs"]
        [::std::mem::offset_of!(shader_info, per_primitive_inputs) - 128usize];
    ["Offset of field: shader_info::per_primitive_outputs"]
        [::std::mem::offset_of!(shader_info, per_primitive_outputs) - 136usize];
    ["Offset of field: shader_info::per_view_outputs"]
        [::std::mem::offset_of!(shader_info, per_view_outputs) - 144usize];
    ["Offset of field: shader_info::view_mask"]
        [::std::mem::offset_of!(shader_info, view_mask) - 152usize];
    ["Offset of field: shader_info::inputs_read_16bit"]
        [::std::mem::offset_of!(shader_info, inputs_read_16bit) - 156usize];
    ["Offset of field: shader_info::outputs_written_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_written_16bit) - 158usize];
    ["Offset of field: shader_info::outputs_read_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_read_16bit) - 160usize];
    ["Offset of field: shader_info::inputs_read_indirectly_16bit"]
        [::std::mem::offset_of!(shader_info, inputs_read_indirectly_16bit) - 162usize];
    ["Offset of field: shader_info::outputs_read_indirectly_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_read_indirectly_16bit) - 164usize];
    ["Offset of field: shader_info::outputs_written_indirectly_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_written_indirectly_16bit) - 166usize];
    ["Offset of field: shader_info::patch_inputs_read"]
        [::std::mem::offset_of!(shader_info, patch_inputs_read) - 168usize];
    ["Offset of field: shader_info::patch_outputs_written"]
        [::std::mem::offset_of!(shader_info, patch_outputs_written) - 172usize];
    ["Offset of field: shader_info::patch_outputs_read"]
        [::std::mem::offset_of!(shader_info, patch_outputs_read) - 176usize];
    ["Offset of field: shader_info::inputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, inputs_read_indirectly) - 184usize];
    ["Offset of field: shader_info::outputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, outputs_read_indirectly) - 192usize];
    ["Offset of field: shader_info::outputs_written_indirectly"]
        [::std::mem::offset_of!(shader_info, outputs_written_indirectly) - 200usize];
    ["Offset of field: shader_info::patch_inputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, patch_inputs_read_indirectly) - 208usize];
    ["Offset of field: shader_info::patch_outputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, patch_outputs_read_indirectly) - 212usize];
    ["Offset of field: shader_info::patch_outputs_written_indirectly"]
        [::std::mem::offset_of!(shader_info, patch_outputs_written_indirectly) - 216usize];
    ["Offset of field: shader_info::textures_used"]
        [::std::mem::offset_of!(shader_info, textures_used) - 220usize];
    ["Offset of field: shader_info::textures_used_by_txf"]
        [::std::mem::offset_of!(shader_info, textures_used_by_txf) - 236usize];
    ["Offset of field: shader_info::samplers_used"]
        [::std::mem::offset_of!(shader_info, samplers_used) - 252usize];
    ["Offset of field: shader_info::images_used"]
        [::std::mem::offset_of!(shader_info, images_used) - 256usize];
    ["Offset of field: shader_info::image_buffers"]
        [::std::mem::offset_of!(shader_info, image_buffers) - 264usize];
    ["Offset of field: shader_info::msaa_images"]
        [::std::mem::offset_of!(shader_info, msaa_images) - 272usize];
    ["Offset of field: shader_info::float_controls_execution_mode"]
        [::std::mem::offset_of!(shader_info, float_controls_execution_mode) - 280usize];
    ["Offset of field: shader_info::shared_size"]
        [::std::mem::offset_of!(shader_info, shared_size) - 284usize];
    ["Offset of field: shader_info::task_payload_size"]
        [::std::mem::offset_of!(shader_info, task_payload_size) - 288usize];
    ["Offset of field: shader_info::ray_queries"]
        [::std::mem::offset_of!(shader_info, ray_queries) - 292usize];
    ["Offset of field: shader_info::workgroup_size"]
        [::std::mem::offset_of!(shader_info, workgroup_size) - 296usize];
    ["Offset of field: shader_info::num_subgroups"]
        [::std::mem::offset_of!(shader_info, num_subgroups) - 302usize];
    ["Offset of field: shader_info::api_subgroup_size"]
        [::std::mem::offset_of!(shader_info, api_subgroup_size) - 303usize];
    ["Offset of field: shader_info::max_subgroup_size"]
        [::std::mem::offset_of!(shader_info, max_subgroup_size) - 304usize];
    ["Offset of field: shader_info::min_subgroup_size"]
        [::std::mem::offset_of!(shader_info, min_subgroup_size) - 305usize];
    ["Offset of field: shader_info::xfb_stride"]
        [::std::mem::offset_of!(shader_info, xfb_stride) - 307usize];
    ["Offset of field: shader_info::inlinable_uniform_dw_offsets"]
        [::std::mem::offset_of!(shader_info, inlinable_uniform_dw_offsets) - 312usize];
    ["Offset of field: shader_info::bit_sizes_float"]
        [::std::mem::offset_of!(shader_info, bit_sizes_float) - 322usize];
    ["Offset of field: shader_info::bit_sizes_int"]
        [::std::mem::offset_of!(shader_info, bit_sizes_int) - 323usize];
    ["Offset of field: shader_info::use_legacy_math_rules"]
        [::std::mem::offset_of!(shader_info, use_legacy_math_rules) - 327usize];
};
impl Default for shader_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info {
    #[inline]
    pub fn stage(&self) -> mesa_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_stage(&mut self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stage_raw(this: *const Self) -> mesa_shader_stage {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stage_raw(this: *mut Self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn prev_stage(&self) -> mesa_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_prev_stage(&mut self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn prev_stage_raw(this: *const Self) -> mesa_shader_stage {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_prev_stage_raw(this: *mut Self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn next_stage(&self) -> mesa_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_next_stage(&mut self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn next_stage_raw(this: *const Self) -> mesa_shader_stage {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_next_stage_raw(this: *mut Self, val: mesa_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        stage: mesa_shader_stage,
        prev_stage: mesa_shader_stage,
        next_stage: mesa_shader_stage,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let stage: u32 = unsafe { ::std::mem::transmute(stage) };
            stage as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let prev_stage: u32 = unsafe { ::std::mem::transmute(prev_stage) };
            prev_stage as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let next_stage: u32 = unsafe { ::std::mem::transmute(next_stage) };
            next_stage as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn api_subgroup_size_draw_uniform(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_api_subgroup_size_draw_uniform(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn api_subgroup_size_draw_uniform_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_api_subgroup_size_draw_uniform_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_wide_subgroup_intrinsics(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_wide_subgroup_intrinsics(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_wide_subgroup_intrinsics_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_wide_subgroup_intrinsics_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        api_subgroup_size_draw_uniform: bool,
        uses_wide_subgroup_intrinsics: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let api_subgroup_size_draw_uniform: u8 =
                unsafe { ::std::mem::transmute(api_subgroup_size_draw_uniform) };
            api_subgroup_size_draw_uniform as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uses_wide_subgroup_intrinsics: u8 =
                unsafe { ::std::mem::transmute(uses_wide_subgroup_intrinsics) };
            uses_wide_subgroup_intrinsics as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn num_inlinable_uniforms(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_num_inlinable_uniforms(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_inlinable_uniforms_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_num_inlinable_uniforms_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn clip_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_clip_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn clip_distance_array_size_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_clip_distance_array_size_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn cull_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(8usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_cull_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(8usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn cull_distance_array_size_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                8usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_cull_distance_array_size_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                8usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_texture_gather(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_texture_gather(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_texture_gather_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_texture_gather_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_resource_info_query(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_resource_info_query(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_resource_info_query_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_resource_info_query_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_3(
        num_inlinable_uniforms: u8,
        clip_distance_array_size: u8,
        cull_distance_array_size: u8,
        uses_texture_gather: bool,
        uses_resource_info_query: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let num_inlinable_uniforms: u8 =
                unsafe { ::std::mem::transmute(num_inlinable_uniforms) };
            num_inlinable_uniforms as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let clip_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(clip_distance_array_size) };
            clip_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(8usize, 4u8, {
            let cull_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(cull_distance_array_size) };
            cull_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let uses_texture_gather: u8 = unsafe { ::std::mem::transmute(uses_texture_gather) };
            uses_texture_gather as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uses_resource_info_query: u8 =
                unsafe { ::std::mem::transmute(uses_resource_info_query) };
            uses_resource_info_query as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn first_ubo_is_default_ubo(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_first_ubo_is_default_ubo(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn first_ubo_is_default_ubo_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_first_ubo_is_default_ubo_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn separate_shader(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_separate_shader(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn separate_shader_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_separate_shader_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn known_interpolation_qualifiers(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_known_interpolation_qualifiers(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn known_interpolation_qualifiers_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_known_interpolation_qualifiers_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_transform_feedback_varyings(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_transform_feedback_varyings(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_transform_feedback_varyings_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_transform_feedback_varyings_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn flrp_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_flrp_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn flrp_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_flrp_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn io_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_io_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn io_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_io_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn var_copies_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_var_copies_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn var_copies_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_var_copies_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn writes_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_writes_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn writes_memory_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_writes_memory_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn layer_viewport_relative(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_layer_viewport_relative(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn layer_viewport_relative_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_layer_viewport_relative_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_control_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_control_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_control_barrier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_control_barrier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_memory_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_memory_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_memory_barrier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_memory_barrier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_bindless(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_bindless(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_bindless_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_bindless_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shared_memory_explicit_layout(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shared_memory_explicit_layout(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shared_memory_explicit_layout_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shared_memory_explicit_layout_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn zero_initialize_shared_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_zero_initialize_shared_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn zero_initialize_shared_memory_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_zero_initialize_shared_memory_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn workgroup_size_variable(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_workgroup_size_variable(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn workgroup_size_variable_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_workgroup_size_variable_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_printf(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_printf(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_printf_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_printf_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn maximally_reconverges(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_maximally_reconverges(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn maximally_reconverges_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_maximally_reconverges_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn use_aco_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_use_aco_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn use_aco_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_use_aco_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn use_lowered_image_to_global(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_use_lowered_image_to_global(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_4.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn use_lowered_image_to_global_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_use_lowered_image_to_global_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_4(
        first_ubo_is_default_ubo: bool,
        separate_shader: bool,
        known_interpolation_qualifiers: bool,
        has_transform_feedback_varyings: bool,
        flrp_lowered: bool,
        io_lowered: bool,
        var_copies_lowered: bool,
        writes_memory: bool,
        layer_viewport_relative: bool,
        uses_control_barrier: bool,
        uses_memory_barrier: bool,
        uses_bindless: bool,
        shared_memory_explicit_layout: bool,
        zero_initialize_shared_memory: bool,
        workgroup_size_variable: bool,
        uses_printf: bool,
        maximally_reconverges: bool,
        use_aco_amd: bool,
        use_lowered_image_to_global: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_ubo_is_default_ubo: u8 =
                unsafe { ::std::mem::transmute(first_ubo_is_default_ubo) };
            first_ubo_is_default_ubo as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_shader: u8 = unsafe { ::std::mem::transmute(separate_shader) };
            separate_shader as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let known_interpolation_qualifiers: u8 =
                unsafe { ::std::mem::transmute(known_interpolation_qualifiers) };
            known_interpolation_qualifiers as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let has_transform_feedback_varyings: u8 =
                unsafe { ::std::mem::transmute(has_transform_feedback_varyings) };
            has_transform_feedback_varyings as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let flrp_lowered: u8 = unsafe { ::std::mem::transmute(flrp_lowered) };
            flrp_lowered as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let io_lowered: u8 = unsafe { ::std::mem::transmute(io_lowered) };
            io_lowered as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let var_copies_lowered: u8 = unsafe { ::std::mem::transmute(var_copies_lowered) };
            var_copies_lowered as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let writes_memory: u8 = unsafe { ::std::mem::transmute(writes_memory) };
            writes_memory as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let layer_viewport_relative: u8 =
                unsafe { ::std::mem::transmute(layer_viewport_relative) };
            layer_viewport_relative as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_control_barrier: u8 = unsafe { ::std::mem::transmute(uses_control_barrier) };
            uses_control_barrier as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let uses_memory_barrier: u8 = unsafe { ::std::mem::transmute(uses_memory_barrier) };
            uses_memory_barrier as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let uses_bindless: u8 = unsafe { ::std::mem::transmute(uses_bindless) };
            uses_bindless as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let shared_memory_explicit_layout: u8 =
                unsafe { ::std::mem::transmute(shared_memory_explicit_layout) };
            shared_memory_explicit_layout as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let zero_initialize_shared_memory: u8 =
                unsafe { ::std::mem::transmute(zero_initialize_shared_memory) };
            zero_initialize_shared_memory as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let workgroup_size_variable: u8 =
                unsafe { ::std::mem::transmute(workgroup_size_variable) };
            workgroup_size_variable as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let uses_printf: u8 = unsafe { ::std::mem::transmute(uses_printf) };
            uses_printf as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let maximally_reconverges: u8 = unsafe { ::std::mem::transmute(maximally_reconverges) };
            maximally_reconverges as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let use_aco_amd: u8 = unsafe { ::std::mem::transmute(use_aco_amd) };
            use_aco_amd as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let use_lowered_image_to_global: u8 =
                unsafe { ::std::mem::transmute(use_lowered_image_to_global) };
            use_lowered_image_to_global as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn derivative_group(&self) -> gl_derivative_group {
        unsafe { ::std::mem::transmute(self._bitfield_5.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_derivative_group(&mut self, val: gl_derivative_group) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_5.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn derivative_group_raw(this: *const Self) -> gl_derivative_group {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_5),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_derivative_group_raw(this: *mut Self, val: gl_derivative_group) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_5),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn assume_no_data_races(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_5.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_assume_no_data_races(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_5.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn assume_no_data_races_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_5),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_assume_no_data_races_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_5),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_5(
        derivative_group: gl_derivative_group,
        assume_no_data_races: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let derivative_group: u32 = unsafe { ::std::mem::transmute(derivative_group) };
            derivative_group as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let assume_no_data_races: u8 = unsafe { ::std::mem::transmute(assume_no_data_races) };
            assume_no_data_races as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hash_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_entry"][::std::mem::size_of::<hash_entry>() - 24usize];
    ["Alignment of hash_entry"][::std::mem::align_of::<hash_entry>() - 8usize];
    ["Offset of field: hash_entry::hash"][::std::mem::offset_of!(hash_entry, hash) - 0usize];
    ["Offset of field: hash_entry::key"][::std::mem::offset_of!(hash_entry, key) - 8usize];
    ["Offset of field: hash_entry::data"][::std::mem::offset_of!(hash_entry, data) - 16usize];
};
impl Default for hash_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hash_table {
    pub mem_ctx: *mut ::std::os::raw::c_void,
    pub table: *mut hash_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub deleted_key: *const ::std::os::raw::c_void,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
    pub _initial_storage: [hash_entry; 19usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_table"][::std::mem::size_of::<hash_table>() - 536usize];
    ["Alignment of hash_table"][::std::mem::align_of::<hash_table>() - 8usize];
    ["Offset of field: hash_table::mem_ctx"][::std::mem::offset_of!(hash_table, mem_ctx) - 0usize];
    ["Offset of field: hash_table::table"][::std::mem::offset_of!(hash_table, table) - 8usize];
    ["Offset of field: hash_table::key_hash_function"]
        [::std::mem::offset_of!(hash_table, key_hash_function) - 16usize];
    ["Offset of field: hash_table::key_equals_function"]
        [::std::mem::offset_of!(hash_table, key_equals_function) - 24usize];
    ["Offset of field: hash_table::deleted_key"]
        [::std::mem::offset_of!(hash_table, deleted_key) - 32usize];
    ["Offset of field: hash_table::size"][::std::mem::offset_of!(hash_table, size) - 40usize];
    ["Offset of field: hash_table::rehash"][::std::mem::offset_of!(hash_table, rehash) - 44usize];
    ["Offset of field: hash_table::size_magic"]
        [::std::mem::offset_of!(hash_table, size_magic) - 48usize];
    ["Offset of field: hash_table::rehash_magic"]
        [::std::mem::offset_of!(hash_table, rehash_magic) - 56usize];
    ["Offset of field: hash_table::max_entries"]
        [::std::mem::offset_of!(hash_table, max_entries) - 64usize];
    ["Offset of field: hash_table::size_index"]
        [::std::mem::offset_of!(hash_table, size_index) - 68usize];
    ["Offset of field: hash_table::entries"][::std::mem::offset_of!(hash_table, entries) - 72usize];
    ["Offset of field: hash_table::deleted_entries"]
        [::std::mem::offset_of!(hash_table, deleted_entries) - 76usize];
    ["Offset of field: hash_table::_initial_storage"]
        [::std::mem::offset_of!(hash_table, _initial_storage) - 80usize];
};
impl Default for hash_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_head {
    pub prev: *mut list_head,
    pub next: *mut list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of list_head"][::std::mem::size_of::<list_head>() - 16usize];
    ["Alignment of list_head"][::std::mem::align_of::<list_head>() - 8usize];
    ["Offset of field: list_head::prev"][::std::mem::offset_of!(list_head, prev) - 0usize];
    ["Offset of field: list_head::next"][::std::mem::offset_of!(list_head, next) - 8usize];
};
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MESA_LOG_ERROR: mesa_log_level = 0;
pub const MESA_LOG_WARN: mesa_log_level = 1;
pub const MESA_LOG_INFO: mesa_log_level = 2;
pub const MESA_LOG_DEBUG: mesa_log_level = 3;
pub const MESA_NUM_LOG_LEVELS: mesa_log_level = 4;
pub type mesa_log_level = ::std::os::raw::c_uint;
#[doc = " Find the smallest integer in a portion of an array.\n\n We use the simple RMQ algorithm that uses O(n log n) preprcessing time and\n O(1) query time (see eg. Bender and Colton section 3).\n\n Bender, M.A., Farach-Colton, M. (2000). The LCA Problem Revisited. In:\n     Gonnet, G.H., Viola, A. (eds) LATIN 2000: Theoretical Informatics. LATIN\n     2000. Lecture Notes in Computer Science, vol 1776. Springer, Berlin,\n     Heidelberg. https://doi.org/10.1007/10719839_9"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct range_minimum_query_table {
    pub table: *mut u32,
    pub width: u32,
    pub height: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of range_minimum_query_table"]
        [::std::mem::size_of::<range_minimum_query_table>() - 16usize];
    ["Alignment of range_minimum_query_table"]
        [::std::mem::align_of::<range_minimum_query_table>() - 8usize];
    ["Offset of field: range_minimum_query_table::table"]
        [::std::mem::offset_of!(range_minimum_query_table, table) - 0usize];
    ["Offset of field: range_minimum_query_table::width"]
        [::std::mem::offset_of!(range_minimum_query_table, width) - 8usize];
    ["Offset of field: range_minimum_query_table::height"]
        [::std::mem::offset_of!(range_minimum_query_table, height) - 12usize];
};
impl Default for range_minimum_query_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct set_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_entry"][::std::mem::size_of::<set_entry>() - 16usize];
    ["Alignment of set_entry"][::std::mem::align_of::<set_entry>() - 8usize];
    ["Offset of field: set_entry::hash"][::std::mem::offset_of!(set_entry, hash) - 0usize];
    ["Offset of field: set_entry::key"][::std::mem::offset_of!(set_entry, key) - 8usize];
};
impl Default for set_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct set {
    pub mem_ctx: *mut ::std::os::raw::c_void,
    pub table: *mut set_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
    pub _initial_storage: [set_entry; 19usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set"][::std::mem::size_of::<set>() - 376usize];
    ["Alignment of set"][::std::mem::align_of::<set>() - 8usize];
    ["Offset of field: set::mem_ctx"][::std::mem::offset_of!(set, mem_ctx) - 0usize];
    ["Offset of field: set::table"][::std::mem::offset_of!(set, table) - 8usize];
    ["Offset of field: set::key_hash_function"]
        [::std::mem::offset_of!(set, key_hash_function) - 16usize];
    ["Offset of field: set::key_equals_function"]
        [::std::mem::offset_of!(set, key_equals_function) - 24usize];
    ["Offset of field: set::size"][::std::mem::offset_of!(set, size) - 32usize];
    ["Offset of field: set::rehash"][::std::mem::offset_of!(set, rehash) - 36usize];
    ["Offset of field: set::size_magic"][::std::mem::offset_of!(set, size_magic) - 40usize];
    ["Offset of field: set::rehash_magic"][::std::mem::offset_of!(set, rehash_magic) - 48usize];
    ["Offset of field: set::max_entries"][::std::mem::offset_of!(set, max_entries) - 56usize];
    ["Offset of field: set::size_index"][::std::mem::offset_of!(set, size_index) - 60usize];
    ["Offset of field: set::entries"][::std::mem::offset_of!(set, entries) - 64usize];
    ["Offset of field: set::deleted_entries"]
        [::std::mem::offset_of!(set, deleted_entries) - 68usize];
    ["Offset of field: set::_initial_storage"]
        [::std::mem::offset_of!(set, _initial_storage) - 72usize];
};
impl Default for set {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_builder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_xfb_info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_tcs_info {
    _unused: [u8; 0],
}
pub const nir_var_system_value: nir_variable_mode = 1;
pub const nir_var_uniform: nir_variable_mode = 2;
pub const nir_var_shader_in: nir_variable_mode = 4;
pub const nir_var_shader_out: nir_variable_mode = 8;
pub const nir_var_image: nir_variable_mode = 16;
#[doc = " Incoming call or ray payload data for ray-tracing shaders"]
pub const nir_var_shader_call_data: nir_variable_mode = 32;
#[doc = " Ray hit attributes"]
pub const nir_var_ray_hit_attrib: nir_variable_mode = 64;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_ubo: nir_variable_mode = 128;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_push_const: nir_variable_mode = 256;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_ssbo: nir_variable_mode = 512;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_constant: nir_variable_mode = 1024;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_task_payload: nir_variable_mode = 2048;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_node_payload: nir_variable_mode = 4096;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_node_payload_in: nir_variable_mode = 8192;
#[doc = " Ray hit attributes"]
pub const nir_var_function_in: nir_variable_mode = 16384;
#[doc = " Ray hit attributes"]
pub const nir_var_function_out: nir_variable_mode = 32768;
#[doc = " Ray hit attributes"]
pub const nir_var_function_inout: nir_variable_mode = 65536;
#[doc = " Ray hit attributes"]
pub const nir_var_shader_temp: nir_variable_mode = 131072;
#[doc = " Ray hit attributes"]
pub const nir_var_function_temp: nir_variable_mode = 262144;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_shared: nir_variable_mode = 524288;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_global: nir_variable_mode = 1048576;
#[doc = " Ray hit attributes"]
pub const nir_var_mem_generic: nir_variable_mode = 1966080;
#[doc = " Ray hit attributes"]
pub const nir_var_read_only_modes: nir_variable_mode = 1159;
#[doc = " Ray hit attributes"]
pub const nir_var_vec_indexable_modes: nir_variable_mode = 1969033;
#[doc = " Ray hit attributes"]
pub const nir_num_variable_modes: nir_variable_mode = 21;
#[doc = " Ray hit attributes"]
pub const nir_var_all: nir_variable_mode = 2097151;
pub type nir_variable_mode = ::std::os::raw::c_uint;
pub const nir_type_invalid: nir_alu_type = 0;
pub const nir_type_int: nir_alu_type = 2;
pub const nir_type_uint: nir_alu_type = 4;
pub const nir_type_bool: nir_alu_type = 6;
pub const nir_type_float: nir_alu_type = 128;
pub const nir_type_bool1: nir_alu_type = 7;
pub const nir_type_bool8: nir_alu_type = 14;
pub const nir_type_bool16: nir_alu_type = 22;
pub const nir_type_bool32: nir_alu_type = 38;
pub const nir_type_int1: nir_alu_type = 3;
pub const nir_type_int8: nir_alu_type = 10;
pub const nir_type_int16: nir_alu_type = 18;
pub const nir_type_int32: nir_alu_type = 34;
pub const nir_type_int64: nir_alu_type = 66;
pub const nir_type_uint1: nir_alu_type = 5;
pub const nir_type_uint8: nir_alu_type = 12;
pub const nir_type_uint16: nir_alu_type = 20;
pub const nir_type_uint32: nir_alu_type = 36;
pub const nir_type_uint64: nir_alu_type = 68;
pub const nir_type_float16: nir_alu_type = 144;
pub const nir_type_float32: nir_alu_type = 160;
pub const nir_type_float64: nir_alu_type = 192;
#[doc = " NIR sized and unsized types\n\n The values in this enum are carefully chosen so that the sized type is\n just the unsized type OR the number of bits."]
pub type nir_alu_type = ::std::os::raw::c_uchar;
#[doc = " An address format which is a simple 32-bit global GPU address."]
pub const nir_address_format_32bit_global: nir_address_format = 0;
#[doc = " An address format which is a simple 64-bit global GPU address."]
pub const nir_address_format_64bit_global: nir_address_format = 1;
#[doc = " An address format which is a 64-bit global GPU address encoded as a\n 2x32-bit vector."]
pub const nir_address_format_2x32bit_global: nir_address_format = 2;
#[doc = " An address format which is a 64-bit global base address and a 32-bit\n offset.\n\n This is identical to 64bit_bounded_global except that bounds checking\n is not applied when lowering to global access.  Even though the size is\n never used for an actual bounds check, it needs to be valid so we can\n lower deref_buffer_array_length properly."]
pub const nir_address_format_64bit_global_32bit_offset: nir_address_format = 3;
#[doc = " An address format which is a bounds-checked 64-bit global GPU address.\n\n The address is comprised as a 32-bit vec4 where .xy are a uint64_t base\n address stored with the low bits in .x and high bits in .y, .z is a\n size, and .w is an offset.  When the final I/O operation is lowered, .w\n is checked against .z and the operation is predicated on the result."]
pub const nir_address_format_64bit_bounded_global: nir_address_format = 4;
#[doc = " An address format which is comprised of a vec2 where the first\n component is a buffer index and the second is an offset."]
pub const nir_address_format_32bit_index_offset: nir_address_format = 5;
#[doc = " An address format which is a 64-bit value, where the high 32 bits\n are a buffer index, and the low 32 bits are an offset."]
pub const nir_address_format_32bit_index_offset_pack64: nir_address_format = 6;
#[doc = " An address format which is comprised of a vec3 where the first two\n components specify the buffer and the third is an offset."]
pub const nir_address_format_vec2_index_32bit_offset: nir_address_format = 7;
#[doc = " An address format which represents generic pointers with a 62-bit\n pointer and a 2-bit enum in the top two bits.  The top two bits have\n the following meanings:\n\n  - 0x0: Global memory\n  - 0x1: Shared memory\n  - 0x2: Scratch memory\n  - 0x3: Global memory\n\n The redundancy between 0x0 and 0x3 is because of Intel sign-extension of\n addresses.  Valid global memory addresses may naturally have either 0 or\n ~0 as their high bits.\n\n Shared and scratch pointers are represented as 32-bit offsets with the\n top 32 bits only being used for the enum.  This allows us to avoid\n 64-bit address calculations in a bunch of cases."]
pub const nir_address_format_62bit_generic: nir_address_format = 8;
#[doc = " An address format which is a simple 32-bit offset."]
pub const nir_address_format_32bit_offset: nir_address_format = 9;
#[doc = " An address format which is a simple 32-bit offset cast to 64-bit."]
pub const nir_address_format_32bit_offset_as_64bit: nir_address_format = 10;
#[doc = " An address format representing a purely logical addressing model.  In\n this model, all deref chains must be complete from the dereference\n operation to the variable.  Cast derefs are not allowed.  These\n addresses will be 32-bit scalars but the format is immaterial because\n you can always chase the chain."]
pub const nir_address_format_logical: nir_address_format = 11;
pub type nir_address_format = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_const_value {
    pub b: bool,
    pub f32_: f32,
    pub f64_: f64,
    pub i8_: i8,
    pub u8_: u8,
    pub i16_: i16,
    pub u16_: u16,
    pub i32_: i32,
    pub u32_: u32,
    pub i64_: i64,
    pub u64_: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_const_value"][::std::mem::size_of::<nir_const_value>() - 8usize];
    ["Alignment of nir_const_value"][::std::mem::align_of::<nir_const_value>() - 8usize];
    ["Offset of field: nir_const_value::b"][::std::mem::offset_of!(nir_const_value, b) - 0usize];
    ["Offset of field: nir_const_value::f32_"]
        [::std::mem::offset_of!(nir_const_value, f32_) - 0usize];
    ["Offset of field: nir_const_value::f64_"]
        [::std::mem::offset_of!(nir_const_value, f64_) - 0usize];
    ["Offset of field: nir_const_value::i8_"]
        [::std::mem::offset_of!(nir_const_value, i8_) - 0usize];
    ["Offset of field: nir_const_value::u8_"]
        [::std::mem::offset_of!(nir_const_value, u8_) - 0usize];
    ["Offset of field: nir_const_value::i16_"]
        [::std::mem::offset_of!(nir_const_value, i16_) - 0usize];
    ["Offset of field: nir_const_value::u16_"]
        [::std::mem::offset_of!(nir_const_value, u16_) - 0usize];
    ["Offset of field: nir_const_value::i32_"]
        [::std::mem::offset_of!(nir_const_value, i32_) - 0usize];
    ["Offset of field: nir_const_value::u32_"]
        [::std::mem::offset_of!(nir_const_value, u32_) - 0usize];
    ["Offset of field: nir_const_value::i64_"]
        [::std::mem::offset_of!(nir_const_value, i64_) - 0usize];
    ["Offset of field: nir_const_value::u64_"]
        [::std::mem::offset_of!(nir_const_value, u64_) - 0usize];
};
impl Default for nir_const_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_lower_imul64: nir_lower_int64_options = 1;
pub const nir_lower_isign64: nir_lower_int64_options = 2;
#[doc = " Lower all int64 modulus and division opcodes"]
pub const nir_lower_divmod64: nir_lower_int64_options = 4;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_imul_high64: nir_lower_int64_options = 8;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_bcsel64: nir_lower_int64_options = 16;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_icmp64: nir_lower_int64_options = 32;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_iadd64: nir_lower_int64_options = 64;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_iabs64: nir_lower_int64_options = 128;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_ineg64: nir_lower_int64_options = 256;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_logic64: nir_lower_int64_options = 512;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_minmax64: nir_lower_int64_options = 1024;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_shift64: nir_lower_int64_options = 2048;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_imul_2x32_64: nir_lower_int64_options = 4096;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_extract64: nir_lower_int64_options = 8192;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_ufind_msb64: nir_lower_int64_options = 16384;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_bit_count64: nir_lower_int64_options = 32768;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_subgroup_shuffle64: nir_lower_int64_options = 65536;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_scan_reduce_bitwise64: nir_lower_int64_options = 131072;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_scan_reduce_iadd64: nir_lower_int64_options = 262144;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_vote_ieq64: nir_lower_int64_options = 524288;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_usub_sat64: nir_lower_int64_options = 1048576;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_iadd_sat64: nir_lower_int64_options = 2097152;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_find_lsb64: nir_lower_int64_options = 4194304;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_conv64: nir_lower_int64_options = 8388608;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_uadd_sat64: nir_lower_int64_options = 16777216;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_iadd3_64: nir_lower_int64_options = 33554432;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_bitfield_reverse64: nir_lower_int64_options = 67108864;
#[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
pub const nir_lower_bitfield_extract64: nir_lower_int64_options = 134217728;
pub type nir_lower_int64_options = ::std::os::raw::c_uint;
pub const nir_lower_drcp: nir_lower_doubles_options = 1;
pub const nir_lower_dsqrt: nir_lower_doubles_options = 2;
pub const nir_lower_drsq: nir_lower_doubles_options = 4;
pub const nir_lower_dtrunc: nir_lower_doubles_options = 8;
pub const nir_lower_dfloor: nir_lower_doubles_options = 16;
pub const nir_lower_dceil: nir_lower_doubles_options = 32;
pub const nir_lower_dfract: nir_lower_doubles_options = 64;
pub const nir_lower_dround_even: nir_lower_doubles_options = 128;
pub const nir_lower_dmod: nir_lower_doubles_options = 256;
pub const nir_lower_dsub: nir_lower_doubles_options = 512;
pub const nir_lower_ddiv: nir_lower_doubles_options = 1024;
pub const nir_lower_dsign: nir_lower_doubles_options = 2048;
pub const nir_lower_dminmax: nir_lower_doubles_options = 4096;
pub const nir_lower_dsat: nir_lower_doubles_options = 8192;
pub const nir_lower_fp64_full_software: nir_lower_doubles_options = 16384;
pub type nir_lower_doubles_options = ::std::os::raw::c_uint;
pub const nir_divergence_single_prim_per_subgroup: nir_divergence_options = 1;
pub const nir_divergence_single_patch_per_tcs_subgroup: nir_divergence_options = 2;
pub const nir_divergence_single_patch_per_tes_subgroup: nir_divergence_options = 4;
pub const nir_divergence_view_index_uniform: nir_divergence_options = 8;
pub const nir_divergence_single_frag_shading_rate_per_subgroup: nir_divergence_options = 16;
pub const nir_divergence_multiple_workgroup_per_compute_subgroup: nir_divergence_options = 32;
pub const nir_divergence_shader_record_ptr_uniform: nir_divergence_options = 64;
pub const nir_divergence_uniform_load_tears: nir_divergence_options = 128;
pub const nir_divergence_ignore_undef_if_phi_srcs: nir_divergence_options = 256;
pub const nir_divergence_vertex: nir_divergence_options = 2048;
pub const nir_divergence_across_subgroups: nir_divergence_options = 4096;
pub type nir_divergence_options = ::std::os::raw::c_uint;
#[doc = " An instruction filtering callback\n\n Returns true if the instruction should be processed and false otherwise."]
pub type nir_instr_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> bool,
>;
#[doc = " Whether a fragment shader can interpolate the same input multiple times\n with different modes (smooth, noperspective) and locations (pixel,\n centroid, sample, at_offset, at_sample), excluding the flat mode.\n\n This matches AMD GPU flexibility and limitations and is a superset of\n the GL4 requirement that each input can be interpolated at its specified\n location, and then also as centroid, at_offset, and at_sample."]
pub const nir_io_has_flexible_input_interpolation_except_flat: nir_io_options = 1;
#[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
pub const nir_io_dont_use_pos_for_non_fs_varyings: nir_io_options = 2;
#[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
pub const nir_io_16bit_input_output_support: nir_io_options = 4;
#[doc = " Implement mediump inputs and outputs as normal 32-bit IO.\n Causes the mediump flag to be not set for IO semantics, essentially\n destroying any mediump-related IO information in the shader."]
pub const nir_io_mediump_is_32bit: nir_io_options = 8;
#[doc = " Whether nir_opt_vectorize_io should ignore FS inputs."]
pub const nir_io_prefer_scalar_fs_inputs: nir_io_options = 16;
#[doc = " Whether interpolated fragment shader vec4 slots can use load_input for\n a subset of its components to skip interpolation for those components.\n The result of such load_input is a value from a random (not necessarily\n provoking) vertex. If a value from the provoking vertex is required,\n the vec4 slot should have no load_interpolated_input instructions.\n\n This exposes the AMD capability that allows packing flat inputs with\n interpolated inputs in a limited number of cases. Normally, flat\n components must be in a separate vec4 slot to get the value from\n the provoking vertex. If the compiler can prove that all per-vertex\n values are equal (convergent, i.e. the provoking vertex doesn't matter),\n it can put such flat components into any interpolated vec4 slot.\n\n It should also be set if the hw can mix flat and interpolated components\n in the same vec4 slot.\n\n This causes nir_opt_varyings to skip interpolation for all varyings\n that are convergent, and enables better compaction and inter-shader code\n motion for convergent varyings."]
pub const nir_io_mix_convergent_flat_with_interpolated: nir_io_options = 32;
#[doc = " Whether src_type and dest_type of IO intrinsics are irrelevant and\n should be ignored by nir_opt_vectorize_io. All drivers that always treat\n load_input and store_output as untyped and load_interpolated_input as\n float##bit_size should set this."]
pub const nir_io_vectorizer_ignores_types: nir_io_options = 64;
#[doc = " Whether nir_opt_varyings should never promote convergent FS inputs\n to flat."]
pub const nir_io_always_interpolate_convergent_fs_inputs: nir_io_options = 128;
#[doc = " Whether the first assigned color channel component should be equal to\n the first unused VARn component.\n\n For example, if the first unused VARn channel is VAR0.z, color channels\n are assigned in this order:\n       COL0.z, COL0.w, COL0.x, COL0.y, COL1.z, COL1.w, COL1.x, COL1.y\n\n This allows certain drivers to merge outputs if each output sets\n different components, for example 2 outputs writing VAR0.xy and COL0.z\n will only use 1 HW output."]
pub const nir_io_compaction_rotates_color_channels: nir_io_options = 256;
#[doc = " Whether to group TES inputs as follows:\n - inputs used to compute only POS/CLIP outputs are first\n - inputs used to compute both POS/CLIP outputs and other outputs are next\n - inputs used to compute only other outputs are last"]
pub const nir_io_compaction_groups_tes_inputs_into_pos_and_var_groups: nir_io_options = 512;
#[doc = " RADV expects that high 16 bits of outputs set component >= 4. That's not\n legal in NIR, but RADV unfortunately relies on it because it's not\n validated."]
pub const nir_io_radv_intrinsic_component_workaround: nir_io_options = 1024;
#[doc = " Lower load_deref/store_deref to load_input/store_output/etc. intrinsics.\n This is only affects GLSL compilation and Gallium."]
pub const nir_io_has_intrinsics: nir_io_options = 65536;
#[doc = " Whether clip and cull distance arrays should be separate. If this is not\n set, cull distances will be moved into VARYING_SLOT_CLIP_DISTn after clip\n distances, and shader_info::clip_distance_array_size will be the index\n of the first cull distance. nir_lower_clip_cull_distance_array_vars does\n that."]
pub const nir_io_separate_clip_cull_distance_arrays: nir_io_options = 131072;
pub type nir_io_options = ::std::os::raw::c_uint;
pub const nir_lower_packing_op_pack_64_2x32: nir_lower_packing_op = 0;
pub const nir_lower_packing_op_unpack_64_2x32: nir_lower_packing_op = 1;
pub const nir_lower_packing_op_pack_64_4x16: nir_lower_packing_op = 2;
pub const nir_lower_packing_op_unpack_64_4x16: nir_lower_packing_op = 3;
pub const nir_lower_packing_op_pack_32_2x16: nir_lower_packing_op = 4;
pub const nir_lower_packing_op_unpack_32_2x16: nir_lower_packing_op = 5;
pub const nir_lower_packing_op_pack_32_4x8: nir_lower_packing_op = 6;
pub const nir_lower_packing_op_unpack_32_4x8: nir_lower_packing_op = 7;
pub const nir_lower_packing_num_ops: nir_lower_packing_op = 8;
pub type nir_lower_packing_op = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_shader_compiler_options {
    pub lower_fdiv: bool,
    pub lower_ffma16: bool,
    pub lower_ffma32: bool,
    pub lower_ffma64: bool,
    pub fuse_ffma16: bool,
    pub fuse_ffma32: bool,
    pub fuse_ffma64: bool,
    pub lower_flrp16: bool,
    pub lower_flrp32: bool,
    #[doc = " Lowers flrp when it does not support doubles"]
    pub lower_flrp64: bool,
    pub lower_fpow: bool,
    pub lower_fsat: bool,
    pub lower_fsqrt: bool,
    pub lower_sincos: bool,
    pub lower_fmod: bool,
    #[doc = " Lowers ibitfield_extract/ubitfield_extract for 8, 16 & 32 bits."]
    pub lower_bitfield_extract8: bool,
    pub lower_bitfield_extract16: bool,
    pub lower_bitfield_extract: bool,
    #[doc = " Lowers bitfield_insert."]
    pub lower_bitfield_insert: bool,
    #[doc = " Lowers bitfield_reverse to shifts."]
    pub lower_bitfield_reverse: bool,
    #[doc = " Lowers bit_count to shifts."]
    pub lower_bit_count: bool,
    #[doc = " Lowers ifind_msb."]
    pub lower_ifind_msb: bool,
    #[doc = " Lowers ufind_msb."]
    pub lower_ufind_msb: bool,
    #[doc = " Lowers find_lsb to ufind_msb and logic ops"]
    pub lower_find_lsb: bool,
    pub lower_uadd_carry: bool,
    pub lower_usub_borrow: bool,
    #[doc = " Lowers imul_high/umul_high to 16-bit multiplies and carry operations."]
    pub lower_mul_high: bool,
    pub lower_mul_high16: bool,
    #[doc = " lowers fneg to fmul(x, -1.0). Driver must call nir_opt_algebraic_late()"]
    pub lower_fneg: bool,
    #[doc = " lowers ineg to isub. Driver must call nir_opt_algebraic_late()."]
    pub lower_ineg: bool,
    #[doc = " lowers fisnormal to alu ops."]
    pub lower_fisnormal: bool,
    pub lower_scmp: bool,
    pub lower_vector_cmp: bool,
    #[doc = " enable rules to avoid bit ops"]
    pub lower_bitops: bool,
    #[doc = " enables rules to lower isign to imin+imax"]
    pub lower_isign: bool,
    #[doc = " enables rules to lower fsign to fsub and flt"]
    pub lower_fsign: bool,
    #[doc = " enables rules to lower iabs to ineg+imax"]
    pub lower_iabs: bool,
    #[doc = " enable rules that avoid generating umax from signed integer ops"]
    pub lower_umax: bool,
    #[doc = " enable rules that avoid generating umin from signed integer ops"]
    pub lower_umin: bool,
    pub lower_fminmax_signed_zero: bool,
    pub lower_fdph: bool,
    pub fdot_replicates: bool,
    #[doc = " lowers ffloor to fsub+ffract:"]
    pub lower_ffloor: bool,
    #[doc = " lowers ffract to fsub+ffloor:"]
    pub lower_ffract: bool,
    #[doc = " lowers fceil to fneg+ffloor+fneg:"]
    pub lower_fceil: bool,
    pub lower_ftrunc: bool,
    #[doc = " Lowers fround_even to ffract+feq+csel.\n\n Not correct in that it doesn't correctly handle the \"_even\" part of the\n rounding, but good enough for DX9 array indexing handling on DX9-class\n hardware."]
    pub lower_fround_even: bool,
    pub lower_ldexp: bool,
    pub lower_pack_half_2x16: bool,
    pub lower_pack_unorm_2x16: bool,
    pub lower_pack_snorm_2x16: bool,
    pub lower_pack_unorm_4x8: bool,
    pub lower_pack_snorm_4x8: bool,
    pub lower_pack_64_2x32: bool,
    pub lower_pack_64_4x16: bool,
    pub lower_pack_32_2x16: bool,
    pub lower_pack_64_2x32_split: bool,
    pub lower_pack_32_2x16_split: bool,
    pub lower_unpack_half_2x16: bool,
    pub lower_unpack_unorm_2x16: bool,
    pub lower_unpack_snorm_2x16: bool,
    pub lower_unpack_unorm_4x8: bool,
    pub lower_unpack_snorm_4x8: bool,
    pub lower_unpack_64_2x32_split: bool,
    pub lower_unpack_32_2x16_split: bool,
    pub lower_pack_split: bool,
    pub lower_extract_byte: bool,
    pub lower_extract_word: bool,
    pub lower_insert_byte: bool,
    pub lower_insert_word: bool,
    pub vertex_id_zero_based: bool,
    #[doc = " If enabled, gl_BaseVertex will be lowered as:\n is_indexed_draw (~0/0) & firstvertex"]
    pub lower_base_vertex: bool,
    pub instance_id_includes_base_index: bool,
    #[doc = " If enabled, gl_HelperInvocation will be lowered as:\n\n - non-sample-shading: sample_mask_in == 0.\n - sample shading:     !((1 << sample_id) & sample_mask_in))\n\n For this to be correct, it requires that fs.uses_sample_shading is set to\n true when sample shading is enabled.  This means that you need shader\n variants to set the flag when Vulkan's\n VkPipelineMultisampleStateCreateInfo->sampleShadingEnable or GL's\n glMinSampleshading() are enabled.\n\n This depends on some possibly hw implementation details, which may\n not be true for all hw.  In particular that the FS is only executed\n for covered samples or for helper invocations.  So, do not blindly\n enable this option.\n\n Note: See also issue #22 in ARB_shader_image_load_store"]
    pub lower_helper_invocation: bool,
    #[doc = " Convert gl_SampleMaskIn to gl_HelperInvocation as follows:\n\n   gl_SampleMaskIn == 0 ---> gl_HelperInvocation\n   gl_SampleMaskIn != 0 ---> !gl_HelperInvocation"]
    pub optimize_sample_mask_in: bool,
    #[doc = " Optimize load_front_face ? a : -a to load_front_face_fsign * a"]
    pub optimize_load_front_face_fsign: bool,
    #[doc = " Optimize boolean reductions of quad broadcasts. This should only be enabled if\n nir_intrinsic_reduce supports INCLUDE_HELPERS."]
    pub optimize_quad_vote_to_reduce: bool,
    pub lower_cs_local_index_to_id: bool,
    pub lower_cs_local_id_to_index: bool,
    pub has_cs_global_id: bool,
    pub lower_device_index_to_zero: bool,
    pub lower_wpos_pntc: bool,
    #[doc = " Set if nir_op_[iu]hadd and nir_op_[iu]rhadd instructions should be\n lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions.\n\n :c:member:`lower_hadd64`"]
    pub lower_hadd: bool,
    #[doc = " Set if only 64-bit nir_op_[iu]hadd and nir_op_[iu]rhadd instructions\n should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to only 64-bit\n versions of these instructions.\n\n :c:member:`lower_hadd`"]
    pub lower_hadd64: bool,
    #[doc = " Set if nir_op_uadd_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_uadd_sat: bool,
    #[doc = " Set if nir_op_usub_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_usub_sat: bool,
    #[doc = " Set if nir_op_iadd_sat and nir_op_isub_sat should be lowered to simple\n arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_iadd_sat: bool,
    #[doc = " Set if imul_32x16 and umul_32x16 should be lowered to simple\n arithmetic."]
    pub lower_mul_32x16: bool,
    #[doc = " Set if bf2f and f2bf should be lowered to arithmetic."]
    pub lower_bfloat16_conversions: bool,
    #[doc = " Set if f2u_sat (or f2i_sat) is supported for converting from 16-, 32-,\n or 64-bit float types to 8-, 16-, or 32-bit integer types (with small\n exceptions).\n\n Due to the prevalence of drivers using \\c nir_split_conversion for\n conversions from 64-bit float to 8-bit integer, these flags will not\n enable generation of f2u_sat from 64-bit float types to 8-bit integer\n types."]
    pub has_f2u_sat: bool,
    pub has_f2i_sat: bool,
    pub vectorize_tess_levels: bool,
    pub lower_to_scalar: bool,
    pub lower_to_scalar_filter: nir_instr_filter_cb,
    #[doc = " Disables potentially harmful algebraic transformations for architectures\n with SIMD-within-a-register semantics.\n\n Note, to actually vectorize 16bit instructions, use nir_opt_vectorize()\n with a suitable callback function."]
    pub vectorize_vec2_16bit: bool,
    #[doc = " Should the linker unify inputs_read/outputs_written between adjacent\n shader stages which are linked into a single program?"]
    pub unify_interfaces: bool,
    #[doc = " Whether nir_lower_io() will lower interpolateAt functions to\n load_interpolated_input intrinsics.\n\n Unlike nir_lower_io_use_interpolated_input_intrinsics this will only\n lower these functions and leave input load intrinsics untouched."]
    pub lower_interpolate_at: bool,
    pub lower_mul_2x32_64: bool,
    pub has_rotate8: bool,
    pub has_rotate16: bool,
    pub has_rotate32: bool,
    #[doc = " Backend supports shfr"]
    pub has_shfr32: bool,
    #[doc = " Backend supports ternary addition"]
    pub has_iadd3: bool,
    #[doc = " Backend supports amul and would like them generated whenever\n possible. This is stronger than has_imul24 for amul, but does not imply\n support for imul24."]
    pub has_amul: bool,
    #[doc = " Backend supports imul24, and would like to use it (when possible)\n for address/offset calculation.  If true, driver should call\n nir_lower_amul().  (If not set, amul will automatically be lowered\n to imul.)"]
    pub has_imul24: bool,
    #[doc = " Backend supports umul24, if not set  umul24 will automatically be lowered\n to imul with masked inputs"]
    pub has_umul24: bool,
    #[doc = " Backend supports imul24_relaxed and umul24_relaxed, if not set they will be lowered\n to imul24, umul24 or imul."]
    pub has_mul24_relaxed: bool,
    #[doc = " Backend supports 32-bit imad"]
    pub has_imad32: bool,
    #[doc = " Backend supports umad24, if not set  umad24 will automatically be lowered\n to imul with masked inputs and iadd"]
    pub has_umad24: bool,
    pub has_fused_comp_and_csel: bool,
    pub has_icsel_eqz64: bool,
    pub has_icsel_eqz32: bool,
    pub has_icsel_eqz16: bool,
    pub has_fneo_fcmpu: bool,
    pub has_ford_funord: bool,
    #[doc = " Backend supports fsub, if not set fsub will automatically be lowered to\n fadd(x, fneg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_fsub: bool,
    #[doc = " Backend supports isub, if not set isub will automatically be lowered to\n iadd(x, ineg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_isub: bool,
    #[doc = " Backend supports pack_32_4x8 or pack_32_4x8_split."]
    pub has_pack_32_4x8: bool,
    #[doc = " Backend supports nir_load_texture_scale and prefers it over txs for nir\n lowerings."]
    pub has_texture_scaling: bool,
    #[doc = " Backend supports sdot_4x8_iadd."]
    pub has_sdot_4x8: bool,
    #[doc = " Backend supports udot_4x8_uadd."]
    pub has_udot_4x8: bool,
    #[doc = " Backend supports sudot_4x8_iadd."]
    pub has_sudot_4x8: bool,
    #[doc = " Backend supports sdot_4x8_iadd_sat."]
    pub has_sdot_4x8_sat: bool,
    #[doc = " Backend supports udot_4x8_uadd_sat."]
    pub has_udot_4x8_sat: bool,
    #[doc = " Backend supports sudot_4x8_iadd_sat."]
    pub has_sudot_4x8_sat: bool,
    #[doc = " Backend supports sdot_2x16 and udot_2x16 opcodes."]
    pub has_dot_2x16: bool,
    #[doc = " Backend supports bfdot2_bfadd opcode."]
    pub has_bfdot2_bfadd: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false)"]
    pub has_fmulz: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false) but only if\n FLOAT_CONTROLS_DENORM_PRESERVE_FP32 is not set"]
    pub has_fmulz_no_denorms: bool,
    #[doc = " Backend supports 32bit ufind_msb_rev and ifind_msb_rev."]
    pub has_find_msb_rev: bool,
    #[doc = " Backend supports pack_half_2x16_rtz_split."]
    pub has_pack_half_2x16_rtz: bool,
    #[doc = " Backend supports bitz/bitnz."]
    pub has_bit_test: bool,
    #[doc = " Backend supports ubfe/ibfe."]
    pub has_bfe: bool,
    #[doc = " Backend supports bfm."]
    pub has_bfm: bool,
    #[doc = " Backend supports bfi."]
    pub has_bfi: bool,
    #[doc = " Backend supports bitfield_select."]
    pub has_bitfield_select: bool,
    #[doc = " Backend supports uclz."]
    pub has_uclz: bool,
    #[doc = " Backend support msad_u4x8."]
    pub has_msad: bool,
    #[doc = " Backend supports f2e4m3fn_satfn"]
    pub has_f2e4m3fn_satfn: bool,
    #[doc = " Backend supports load_global_bounded intrinsics."]
    pub has_load_global_bounded: bool,
    #[doc = " Backend supports f2i32_rtne opcode."]
    pub has_f2i32_rtne: bool,
    #[doc = " Backend supports atomic isub."]
    pub has_atomic_isub: bool,
    #[doc = " Backend supports atomic load/store."]
    pub has_atomic_load_store: bool,
    #[doc = " Is this the Intel vec4 backend?\n\n Used to inhibit algebraic optimizations that are known to be harmful on\n the Intel vec4 backend.  This is generally applicable to any\n optimization that might cause more immediate values to be used in\n 3-source (e.g., ffma and flrp) instructions."]
    pub intel_vec4: bool,
    #[doc = " For most Intel GPUs, all ternary operations such as FMA and BFE cannot\n have immediates, so two to three instructions may eventually be needed."]
    pub avoid_ternary_with_two_constants: bool,
    pub avoid_ternary_with_fabs: bool,
    #[doc = " Whether 8-bit ALU is supported."]
    pub support_8bit_alu: bool,
    #[doc = " Whether 16-bit ALU is supported."]
    pub support_16bit_alu: bool,
    pub max_unroll_iterations: ::std::os::raw::c_uint,
    pub max_unroll_iterations_aggressive: ::std::os::raw::c_uint,
    pub max_unroll_iterations_fp64: ::std::os::raw::c_uint,
    pub lower_uniforms_to_ubo: bool,
    pub force_indirect_unrolling_sampler: bool,
    pub no_integers: bool,
    #[doc = " Specifies which type of indirectly accessed variables should force\n loop unrolling."]
    pub force_indirect_unrolling: nir_variable_mode,
    pub driver_functions: bool,
    #[doc = " If true, the driver will call nir_lower_int64 itself and the frontend\n should not do so. This may enable better optimization around address\n modes."]
    pub late_lower_int64: bool,
    pub lower_int64_options: nir_lower_int64_options,
    pub lower_doubles_options: nir_lower_doubles_options,
    pub divergence_analysis_options: nir_divergence_options,
    #[doc = " The masks of shader stages that support indirect indexing with\n load_input and store_output intrinsics. It's used by\n nir_lower_io_passes."]
    pub support_indirect_inputs: u8,
    pub support_indirect_outputs: u8,
    #[doc = " Lower fmulz to `min(abs(a), abs(b)) == 0.0 ? 0.0 : a * b`."]
    pub lower_fmulz_with_abs_min: bool,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the image index."]
    pub lower_image_offset_to_range_base: bool,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the atomic source"]
    pub lower_atomic_offset_to_range_base: bool,
    #[doc = " Don't convert medium-precision casts (e.g. f2fmp) into concrete\n  type casts (e.g. f2f16)."]
    pub preserve_mediump: bool,
    #[doc = " lowers fquantize2f16 to alu ops."]
    pub lower_fquantize2f16: bool,
    #[doc = " Lower f2f16 to f2f16_rtz when execution mode is not rtne."]
    pub force_f2f16_rtz: bool,
    #[doc = " Lower VARYING_SLOT_LAYER in FS to SYSTEM_VALUE_LAYER_ID."]
    pub lower_layer_fs_input_to_sysval: bool,
    #[doc = " clip/cull distance and tess level arrays use compact semantics"]
    pub compact_arrays: bool,
    #[doc = " Whether discard gets emitted as nir_intrinsic_demote.\n Otherwise, nir_intrinsic_terminate is being used."]
    pub discard_is_demote: bool,
    #[doc = " Whether derivative intrinsics must be scalarized."]
    pub scalarize_ddx: bool,
    #[doc = " Assign a range of driver locations to per-view outputs, with unique\n slots for each view. If unset, per-view outputs will be treated\n similarly to other arrayed IO, and only slots for one view will be\n assigned. Regardless of this setting, per-view outputs are only assigned\n slots for one value in var->data.location."]
    pub per_view_unique_driver_locations: bool,
    #[doc = " Emit nir_intrinsic_store_per_view_output with compacted view indices\n rather than absolute view indices. When using compacted indices, the Nth\n index refers to the Nth enabled view, not the Nth absolute view. For\n example, with view mask 0b1010, compacted index 0 is absolute index 1,\n and compacted index 1 is absolute index 3. Note that compacted view\n indices do not correspond directly to gl_ViewIndex.\n\n If compact_view_index is unset, per-view indices must be constant before\n nir_lower_io. This can be guaranteed by calling nir_lower_io_temporaries\n first."]
    pub compact_view_index: bool,
    #[doc = " Options determining lowering and behavior of inputs and outputs."]
    pub io_options: nir_io_options,
    #[doc = " Bit mask of nir_lower_packing_op to skip lowering some nir ops in\n nir_lower_packing()."]
    pub skip_lower_packing_ops: ::std::os::raw::c_uint,
    #[doc = " Driver callback where drivers can define how to lower mediump.\n  Used by nir_lower_io_passes."]
    pub lower_mediump_io: ::std::option::Option<unsafe extern "C" fn(nir: *mut nir_shader)>,
    #[doc = " Return the maximum cost of an expression that's written to a shader\n output that can be moved into the next shader to remove that output.\n\n Currently only uniform expressions are moved. A uniform expression is\n any ALU expression sourcing only constants, uniforms, and UBO loads.\n\n Set to NULL or return 0 if you only want to propagate constants from\n outputs to inputs.\n\n Drivers can set the maximum cost based on the types of consecutive\n shaders or shader SHA1s.\n\n Drivers should also set \"varying_estimate_instr_cost\"."]
    pub varying_expression_max_cost: ::std::option::Option<
        unsafe extern "C" fn(
            consumer: *mut nir_shader,
            producer: *mut nir_shader,
        ) -> ::std::os::raw::c_uint,
    >,
    #[doc = " Return the cost of an instruction that could be moved into the next\n shader. If the cost of all instructions in an expression is <=\n varying_expression_max_cost(), the instruction is moved.\n\n When this callback isn't set, nir_opt_varyings uses its own version."]
    pub varying_estimate_instr_cost: ::std::option::Option<
        unsafe extern "C" fn(instr: *mut nir_instr) -> ::std::os::raw::c_uint,
    >,
    #[doc = " When the varying_expression_max_cost callback isn't set, this specifies\n the maximum cost of a uniform expression that is allowed to be moved\n from output stores into the next shader stage to eliminate those output\n stores and corresponding inputs.\n\n 0 only allows propagating constants written to output stores to\n the next shader.\n\n At least 2 is required for moving a uniform stored in an output into\n the next shader according to default_varying_estimate_instr_cost."]
    pub max_varying_expression_cost: ::std::os::raw::c_uint,
    #[doc = " Used by nir_lower_explicit_io to determine the maximum offset_shift to\n use when lowering the deref address of the given intrinsic."]
    pub max_offset_shift: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut nir_intrinsic_instr,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_uint,
    >,
    #[doc = " Passed to the callbacks that accept a data pointer."]
    pub cb_data: *const ::std::os::raw::c_void,
    #[doc = " Maximum amount of invocations per workgroup."]
    pub max_workgroup_invocations: ::std::os::raw::c_uint,
    #[doc = " Maximum compute shader / kernel dispatchable work size."]
    pub max_workgroup_count: [::std::os::raw::c_uint; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_shader_compiler_options"]
        [::std::mem::size_of::<nir_shader_compiler_options>() - 288usize];
    ["Alignment of nir_shader_compiler_options"]
        [::std::mem::align_of::<nir_shader_compiler_options>() - 8usize];
    ["Offset of field: nir_shader_compiler_options::lower_fdiv"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fdiv) - 0usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma16) - 1usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma32) - 2usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma64) - 3usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma16) - 4usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma32) - 5usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma64) - 6usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp16) - 7usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp32) - 8usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp64) - 9usize];
    ["Offset of field: nir_shader_compiler_options::lower_fpow"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fpow) - 10usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsat) - 11usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsqrt"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsqrt) - 12usize];
    ["Offset of field: nir_shader_compiler_options::lower_sincos"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_sincos) - 13usize];
    ["Offset of field: nir_shader_compiler_options::lower_fmod"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fmod) - 14usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_extract8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_extract8) - 15usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_extract16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_extract16) - 16usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_extract"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_extract) - 17usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_insert"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_insert) - 18usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_reverse"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_reverse) - 19usize];
    ["Offset of field: nir_shader_compiler_options::lower_bit_count"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bit_count) - 20usize];
    ["Offset of field: nir_shader_compiler_options::lower_ifind_msb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ifind_msb) - 21usize];
    ["Offset of field: nir_shader_compiler_options::lower_ufind_msb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ufind_msb) - 22usize];
    ["Offset of field: nir_shader_compiler_options::lower_find_lsb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_find_lsb) - 23usize];
    ["Offset of field: nir_shader_compiler_options::lower_uadd_carry"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uadd_carry) - 24usize];
    ["Offset of field: nir_shader_compiler_options::lower_usub_borrow"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_usub_borrow) - 25usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_high"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_high) - 26usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_high16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_high16) - 27usize];
    ["Offset of field: nir_shader_compiler_options::lower_fneg"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fneg) - 28usize];
    ["Offset of field: nir_shader_compiler_options::lower_ineg"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ineg) - 29usize];
    ["Offset of field: nir_shader_compiler_options::lower_fisnormal"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fisnormal) - 30usize];
    ["Offset of field: nir_shader_compiler_options::lower_scmp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_scmp) - 31usize];
    ["Offset of field: nir_shader_compiler_options::lower_vector_cmp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_vector_cmp) - 32usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitops"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitops) - 33usize];
    ["Offset of field: nir_shader_compiler_options::lower_isign"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_isign) - 34usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsign"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsign) - 35usize];
    ["Offset of field: nir_shader_compiler_options::lower_iabs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_iabs) - 36usize];
    ["Offset of field: nir_shader_compiler_options::lower_umax"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_umax) - 37usize];
    ["Offset of field: nir_shader_compiler_options::lower_umin"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_umin) - 38usize];
    ["Offset of field: nir_shader_compiler_options::lower_fminmax_signed_zero"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fminmax_signed_zero) - 39usize];
    ["Offset of field: nir_shader_compiler_options::lower_fdph"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fdph) - 40usize];
    ["Offset of field: nir_shader_compiler_options::fdot_replicates"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fdot_replicates) - 41usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffloor"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffloor) - 42usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffract"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffract) - 43usize];
    ["Offset of field: nir_shader_compiler_options::lower_fceil"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fceil) - 44usize];
    ["Offset of field: nir_shader_compiler_options::lower_ftrunc"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ftrunc) - 45usize];
    ["Offset of field: nir_shader_compiler_options::lower_fround_even"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fround_even) - 46usize];
    ["Offset of field: nir_shader_compiler_options::lower_ldexp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ldexp) - 47usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_half_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_half_2x16) - 48usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_unorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_unorm_2x16) - 49usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_snorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_snorm_2x16) - 50usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_unorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_unorm_4x8) - 51usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_snorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_snorm_4x8) - 52usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_2x32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_2x32) - 53usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_4x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_4x16) - 54usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_32_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_32_2x16) - 55usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_2x32_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_2x32_split) - 56usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_32_2x16_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_32_2x16_split) - 57usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_half_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_half_2x16) - 58usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_unorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_unorm_2x16) - 59usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_snorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_snorm_2x16) - 60usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_unorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_unorm_4x8) - 61usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_snorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_snorm_4x8) - 62usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_64_2x32_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_64_2x32_split) - 63usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_32_2x16_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_32_2x16_split) - 64usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_split) - 65usize];
    ["Offset of field: nir_shader_compiler_options::lower_extract_byte"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_extract_byte) - 66usize];
    ["Offset of field: nir_shader_compiler_options::lower_extract_word"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_extract_word) - 67usize];
    ["Offset of field: nir_shader_compiler_options::lower_insert_byte"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_insert_byte) - 68usize];
    ["Offset of field: nir_shader_compiler_options::lower_insert_word"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_insert_word) - 69usize];
    ["Offset of field: nir_shader_compiler_options::vertex_id_zero_based"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vertex_id_zero_based) - 70usize];
    ["Offset of field: nir_shader_compiler_options::lower_base_vertex"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_base_vertex) - 71usize];
    ["Offset of field: nir_shader_compiler_options::instance_id_includes_base_index"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        instance_id_includes_base_index
    ) - 72usize];
    ["Offset of field: nir_shader_compiler_options::lower_helper_invocation"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_helper_invocation) - 73usize];
    ["Offset of field: nir_shader_compiler_options::optimize_sample_mask_in"]
        [::std::mem::offset_of!(nir_shader_compiler_options, optimize_sample_mask_in) - 74usize];
    ["Offset of field: nir_shader_compiler_options::optimize_load_front_face_fsign"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        optimize_load_front_face_fsign
    ) - 75usize];
    ["Offset of field: nir_shader_compiler_options::optimize_quad_vote_to_reduce"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        optimize_quad_vote_to_reduce
    ) - 76usize];
    ["Offset of field: nir_shader_compiler_options::lower_cs_local_index_to_id"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_cs_local_index_to_id) - 77usize];
    ["Offset of field: nir_shader_compiler_options::lower_cs_local_id_to_index"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_cs_local_id_to_index) - 78usize];
    ["Offset of field: nir_shader_compiler_options::has_cs_global_id"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_cs_global_id) - 79usize];
    ["Offset of field: nir_shader_compiler_options::lower_device_index_to_zero"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_device_index_to_zero) - 80usize];
    ["Offset of field: nir_shader_compiler_options::lower_wpos_pntc"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_wpos_pntc) - 81usize];
    ["Offset of field: nir_shader_compiler_options::lower_hadd"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_hadd) - 82usize];
    ["Offset of field: nir_shader_compiler_options::lower_hadd64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_hadd64) - 83usize];
    ["Offset of field: nir_shader_compiler_options::lower_uadd_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uadd_sat) - 84usize];
    ["Offset of field: nir_shader_compiler_options::lower_usub_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_usub_sat) - 85usize];
    ["Offset of field: nir_shader_compiler_options::lower_iadd_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_iadd_sat) - 86usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_32x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_32x16) - 87usize];
    ["Offset of field: nir_shader_compiler_options::lower_bfloat16_conversions"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bfloat16_conversions) - 88usize];
    ["Offset of field: nir_shader_compiler_options::has_f2u_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_f2u_sat) - 89usize];
    ["Offset of field: nir_shader_compiler_options::has_f2i_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_f2i_sat) - 90usize];
    ["Offset of field: nir_shader_compiler_options::vectorize_tess_levels"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vectorize_tess_levels) - 91usize];
    ["Offset of field: nir_shader_compiler_options::lower_to_scalar"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_to_scalar) - 92usize];
    ["Offset of field: nir_shader_compiler_options::lower_to_scalar_filter"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_to_scalar_filter) - 96usize];
    ["Offset of field: nir_shader_compiler_options::vectorize_vec2_16bit"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vectorize_vec2_16bit) - 104usize];
    ["Offset of field: nir_shader_compiler_options::unify_interfaces"]
        [::std::mem::offset_of!(nir_shader_compiler_options, unify_interfaces) - 105usize];
    ["Offset of field: nir_shader_compiler_options::lower_interpolate_at"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_interpolate_at) - 106usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_2x32_64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_2x32_64) - 107usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate8) - 108usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate16) - 109usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate32) - 110usize];
    ["Offset of field: nir_shader_compiler_options::has_shfr32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_shfr32) - 111usize];
    ["Offset of field: nir_shader_compiler_options::has_iadd3"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_iadd3) - 112usize];
    ["Offset of field: nir_shader_compiler_options::has_amul"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_amul) - 113usize];
    ["Offset of field: nir_shader_compiler_options::has_imul24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_imul24) - 114usize];
    ["Offset of field: nir_shader_compiler_options::has_umul24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_umul24) - 115usize];
    ["Offset of field: nir_shader_compiler_options::has_mul24_relaxed"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_mul24_relaxed) - 116usize];
    ["Offset of field: nir_shader_compiler_options::has_imad32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_imad32) - 117usize];
    ["Offset of field: nir_shader_compiler_options::has_umad24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_umad24) - 118usize];
    ["Offset of field: nir_shader_compiler_options::has_fused_comp_and_csel"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fused_comp_and_csel) - 119usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz64) - 120usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz32) - 121usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz16) - 122usize];
    ["Offset of field: nir_shader_compiler_options::has_fneo_fcmpu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fneo_fcmpu) - 123usize];
    ["Offset of field: nir_shader_compiler_options::has_ford_funord"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_ford_funord) - 124usize];
    ["Offset of field: nir_shader_compiler_options::has_fsub"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fsub) - 125usize];
    ["Offset of field: nir_shader_compiler_options::has_isub"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_isub) - 126usize];
    ["Offset of field: nir_shader_compiler_options::has_pack_32_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_pack_32_4x8) - 127usize];
    ["Offset of field: nir_shader_compiler_options::has_texture_scaling"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_texture_scaling) - 128usize];
    ["Offset of field: nir_shader_compiler_options::has_sdot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sdot_4x8) - 129usize];
    ["Offset of field: nir_shader_compiler_options::has_udot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_udot_4x8) - 130usize];
    ["Offset of field: nir_shader_compiler_options::has_sudot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sudot_4x8) - 131usize];
    ["Offset of field: nir_shader_compiler_options::has_sdot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sdot_4x8_sat) - 132usize];
    ["Offset of field: nir_shader_compiler_options::has_udot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_udot_4x8_sat) - 133usize];
    ["Offset of field: nir_shader_compiler_options::has_sudot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sudot_4x8_sat) - 134usize];
    ["Offset of field: nir_shader_compiler_options::has_dot_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_dot_2x16) - 135usize];
    ["Offset of field: nir_shader_compiler_options::has_bfdot2_bfadd"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfdot2_bfadd) - 136usize];
    ["Offset of field: nir_shader_compiler_options::has_fmulz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fmulz) - 137usize];
    ["Offset of field: nir_shader_compiler_options::has_fmulz_no_denorms"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fmulz_no_denorms) - 138usize];
    ["Offset of field: nir_shader_compiler_options::has_find_msb_rev"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_find_msb_rev) - 139usize];
    ["Offset of field: nir_shader_compiler_options::has_pack_half_2x16_rtz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_pack_half_2x16_rtz) - 140usize];
    ["Offset of field: nir_shader_compiler_options::has_bit_test"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bit_test) - 141usize];
    ["Offset of field: nir_shader_compiler_options::has_bfe"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfe) - 142usize];
    ["Offset of field: nir_shader_compiler_options::has_bfm"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfm) - 143usize];
    ["Offset of field: nir_shader_compiler_options::has_bfi"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfi) - 144usize];
    ["Offset of field: nir_shader_compiler_options::has_bitfield_select"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bitfield_select) - 145usize];
    ["Offset of field: nir_shader_compiler_options::has_uclz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_uclz) - 146usize];
    ["Offset of field: nir_shader_compiler_options::has_msad"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_msad) - 147usize];
    ["Offset of field: nir_shader_compiler_options::has_f2e4m3fn_satfn"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_f2e4m3fn_satfn) - 148usize];
    ["Offset of field: nir_shader_compiler_options::has_load_global_bounded"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_load_global_bounded) - 149usize];
    ["Offset of field: nir_shader_compiler_options::has_f2i32_rtne"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_f2i32_rtne) - 150usize];
    ["Offset of field: nir_shader_compiler_options::has_atomic_isub"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_atomic_isub) - 151usize];
    ["Offset of field: nir_shader_compiler_options::has_atomic_load_store"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_atomic_load_store) - 152usize];
    ["Offset of field: nir_shader_compiler_options::intel_vec4"]
        [::std::mem::offset_of!(nir_shader_compiler_options, intel_vec4) - 153usize];
    ["Offset of field: nir_shader_compiler_options::avoid_ternary_with_two_constants"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        avoid_ternary_with_two_constants
    )
        - 154usize];
    ["Offset of field: nir_shader_compiler_options::avoid_ternary_with_fabs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, avoid_ternary_with_fabs) - 155usize];
    ["Offset of field: nir_shader_compiler_options::support_8bit_alu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_8bit_alu) - 156usize];
    ["Offset of field: nir_shader_compiler_options::support_16bit_alu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_16bit_alu) - 157usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations"]
        [::std::mem::offset_of!(nir_shader_compiler_options, max_unroll_iterations) - 160usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations_aggressive"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_unroll_iterations_aggressive
    )
        - 164usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations_fp64"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_unroll_iterations_fp64
    ) - 168usize];
    ["Offset of field: nir_shader_compiler_options::lower_uniforms_to_ubo"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uniforms_to_ubo) - 172usize];
    ["Offset of field: nir_shader_compiler_options::force_indirect_unrolling_sampler"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        force_indirect_unrolling_sampler
    )
        - 173usize];
    ["Offset of field: nir_shader_compiler_options::no_integers"]
        [::std::mem::offset_of!(nir_shader_compiler_options, no_integers) - 174usize];
    ["Offset of field: nir_shader_compiler_options::force_indirect_unrolling"]
        [::std::mem::offset_of!(nir_shader_compiler_options, force_indirect_unrolling) - 176usize];
    ["Offset of field: nir_shader_compiler_options::driver_functions"]
        [::std::mem::offset_of!(nir_shader_compiler_options, driver_functions) - 180usize];
    ["Offset of field: nir_shader_compiler_options::late_lower_int64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, late_lower_int64) - 181usize];
    ["Offset of field: nir_shader_compiler_options::lower_int64_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_int64_options) - 184usize];
    ["Offset of field: nir_shader_compiler_options::lower_doubles_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_doubles_options) - 188usize];
    ["Offset of field: nir_shader_compiler_options::divergence_analysis_options"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        divergence_analysis_options
    ) - 192usize];
    ["Offset of field: nir_shader_compiler_options::support_indirect_inputs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_indirect_inputs) - 196usize];
    ["Offset of field: nir_shader_compiler_options::support_indirect_outputs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_indirect_outputs) - 197usize];
    ["Offset of field: nir_shader_compiler_options::lower_fmulz_with_abs_min"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fmulz_with_abs_min) - 198usize];
    ["Offset of field: nir_shader_compiler_options::lower_image_offset_to_range_base"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_image_offset_to_range_base
    )
        - 199usize];
    ["Offset of field: nir_shader_compiler_options::lower_atomic_offset_to_range_base"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_atomic_offset_to_range_base
    )
        - 200usize];
    ["Offset of field: nir_shader_compiler_options::preserve_mediump"]
        [::std::mem::offset_of!(nir_shader_compiler_options, preserve_mediump) - 201usize];
    ["Offset of field: nir_shader_compiler_options::lower_fquantize2f16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fquantize2f16) - 202usize];
    ["Offset of field: nir_shader_compiler_options::force_f2f16_rtz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, force_f2f16_rtz) - 203usize];
    ["Offset of field: nir_shader_compiler_options::lower_layer_fs_input_to_sysval"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_layer_fs_input_to_sysval
    ) - 204usize];
    ["Offset of field: nir_shader_compiler_options::compact_arrays"]
        [::std::mem::offset_of!(nir_shader_compiler_options, compact_arrays) - 205usize];
    ["Offset of field: nir_shader_compiler_options::discard_is_demote"]
        [::std::mem::offset_of!(nir_shader_compiler_options, discard_is_demote) - 206usize];
    ["Offset of field: nir_shader_compiler_options::scalarize_ddx"]
        [::std::mem::offset_of!(nir_shader_compiler_options, scalarize_ddx) - 207usize];
    ["Offset of field: nir_shader_compiler_options::per_view_unique_driver_locations"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        per_view_unique_driver_locations
    )
        - 208usize];
    ["Offset of field: nir_shader_compiler_options::compact_view_index"]
        [::std::mem::offset_of!(nir_shader_compiler_options, compact_view_index) - 209usize];
    ["Offset of field: nir_shader_compiler_options::io_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, io_options) - 212usize];
    ["Offset of field: nir_shader_compiler_options::skip_lower_packing_ops"]
        [::std::mem::offset_of!(nir_shader_compiler_options, skip_lower_packing_ops) - 216usize];
    ["Offset of field: nir_shader_compiler_options::lower_mediump_io"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mediump_io) - 224usize];
    ["Offset of field: nir_shader_compiler_options::varying_expression_max_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        varying_expression_max_cost
    ) - 232usize];
    ["Offset of field: nir_shader_compiler_options::varying_estimate_instr_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        varying_estimate_instr_cost
    ) - 240usize];
    ["Offset of field: nir_shader_compiler_options::max_varying_expression_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_varying_expression_cost
    ) - 248usize];
    ["Offset of field: nir_shader_compiler_options::max_offset_shift"]
        [::std::mem::offset_of!(nir_shader_compiler_options, max_offset_shift) - 256usize];
    ["Offset of field: nir_shader_compiler_options::cb_data"]
        [::std::mem::offset_of!(nir_shader_compiler_options, cb_data) - 264usize];
    ["Offset of field: nir_shader_compiler_options::max_workgroup_invocations"]
        [::std::mem::offset_of!(nir_shader_compiler_options, max_workgroup_invocations) - 272usize];
    ["Offset of field: nir_shader_compiler_options::max_workgroup_count"]
        [::std::mem::offset_of!(nir_shader_compiler_options, max_workgroup_count) - 276usize];
};
impl Default for nir_shader_compiler_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_op_alignbyte_amd: nir_op = 0;
pub const nir_op_amul: nir_op = 1;
pub const nir_op_andg_ir3: nir_op = 2;
pub const nir_op_b16all_fequal16: nir_op = 3;
pub const nir_op_b16all_fequal2: nir_op = 4;
pub const nir_op_b16all_fequal3: nir_op = 5;
pub const nir_op_b16all_fequal4: nir_op = 6;
pub const nir_op_b16all_fequal5: nir_op = 7;
pub const nir_op_b16all_fequal8: nir_op = 8;
pub const nir_op_b16all_iequal16: nir_op = 9;
pub const nir_op_b16all_iequal2: nir_op = 10;
pub const nir_op_b16all_iequal3: nir_op = 11;
pub const nir_op_b16all_iequal4: nir_op = 12;
pub const nir_op_b16all_iequal5: nir_op = 13;
pub const nir_op_b16all_iequal8: nir_op = 14;
pub const nir_op_b16any_fnequal16: nir_op = 15;
pub const nir_op_b16any_fnequal2: nir_op = 16;
pub const nir_op_b16any_fnequal3: nir_op = 17;
pub const nir_op_b16any_fnequal4: nir_op = 18;
pub const nir_op_b16any_fnequal5: nir_op = 19;
pub const nir_op_b16any_fnequal8: nir_op = 20;
pub const nir_op_b16any_inequal16: nir_op = 21;
pub const nir_op_b16any_inequal2: nir_op = 22;
pub const nir_op_b16any_inequal3: nir_op = 23;
pub const nir_op_b16any_inequal4: nir_op = 24;
pub const nir_op_b16any_inequal5: nir_op = 25;
pub const nir_op_b16any_inequal8: nir_op = 26;
pub const nir_op_b16csel: nir_op = 27;
pub const nir_op_b2b1: nir_op = 28;
pub const nir_op_b2b16: nir_op = 29;
pub const nir_op_b2b32: nir_op = 30;
pub const nir_op_b2b8: nir_op = 31;
pub const nir_op_b2f16: nir_op = 32;
pub const nir_op_b2f32: nir_op = 33;
pub const nir_op_b2f64: nir_op = 34;
pub const nir_op_b2i1: nir_op = 35;
pub const nir_op_b2i16: nir_op = 36;
pub const nir_op_b2i32: nir_op = 37;
pub const nir_op_b2i64: nir_op = 38;
pub const nir_op_b2i8: nir_op = 39;
pub const nir_op_b32all_fequal16: nir_op = 40;
pub const nir_op_b32all_fequal2: nir_op = 41;
pub const nir_op_b32all_fequal3: nir_op = 42;
pub const nir_op_b32all_fequal4: nir_op = 43;
pub const nir_op_b32all_fequal5: nir_op = 44;
pub const nir_op_b32all_fequal8: nir_op = 45;
pub const nir_op_b32all_iequal16: nir_op = 46;
pub const nir_op_b32all_iequal2: nir_op = 47;
pub const nir_op_b32all_iequal3: nir_op = 48;
pub const nir_op_b32all_iequal4: nir_op = 49;
pub const nir_op_b32all_iequal5: nir_op = 50;
pub const nir_op_b32all_iequal8: nir_op = 51;
pub const nir_op_b32any_fnequal16: nir_op = 52;
pub const nir_op_b32any_fnequal2: nir_op = 53;
pub const nir_op_b32any_fnequal3: nir_op = 54;
pub const nir_op_b32any_fnequal4: nir_op = 55;
pub const nir_op_b32any_fnequal5: nir_op = 56;
pub const nir_op_b32any_fnequal8: nir_op = 57;
pub const nir_op_b32any_inequal16: nir_op = 58;
pub const nir_op_b32any_inequal2: nir_op = 59;
pub const nir_op_b32any_inequal3: nir_op = 60;
pub const nir_op_b32any_inequal4: nir_op = 61;
pub const nir_op_b32any_inequal5: nir_op = 62;
pub const nir_op_b32any_inequal8: nir_op = 63;
pub const nir_op_b32csel: nir_op = 64;
pub const nir_op_b32fcsel_mdg: nir_op = 65;
pub const nir_op_b8all_fequal16: nir_op = 66;
pub const nir_op_b8all_fequal2: nir_op = 67;
pub const nir_op_b8all_fequal3: nir_op = 68;
pub const nir_op_b8all_fequal4: nir_op = 69;
pub const nir_op_b8all_fequal5: nir_op = 70;
pub const nir_op_b8all_fequal8: nir_op = 71;
pub const nir_op_b8all_iequal16: nir_op = 72;
pub const nir_op_b8all_iequal2: nir_op = 73;
pub const nir_op_b8all_iequal3: nir_op = 74;
pub const nir_op_b8all_iequal4: nir_op = 75;
pub const nir_op_b8all_iequal5: nir_op = 76;
pub const nir_op_b8all_iequal8: nir_op = 77;
pub const nir_op_b8any_fnequal16: nir_op = 78;
pub const nir_op_b8any_fnequal2: nir_op = 79;
pub const nir_op_b8any_fnequal3: nir_op = 80;
pub const nir_op_b8any_fnequal4: nir_op = 81;
pub const nir_op_b8any_fnequal5: nir_op = 82;
pub const nir_op_b8any_fnequal8: nir_op = 83;
pub const nir_op_b8any_inequal16: nir_op = 84;
pub const nir_op_b8any_inequal2: nir_op = 85;
pub const nir_op_b8any_inequal3: nir_op = 86;
pub const nir_op_b8any_inequal4: nir_op = 87;
pub const nir_op_b8any_inequal5: nir_op = 88;
pub const nir_op_b8any_inequal8: nir_op = 89;
pub const nir_op_b8csel: nir_op = 90;
pub const nir_op_ball_fequal16: nir_op = 91;
pub const nir_op_ball_fequal2: nir_op = 92;
pub const nir_op_ball_fequal3: nir_op = 93;
pub const nir_op_ball_fequal4: nir_op = 94;
pub const nir_op_ball_fequal5: nir_op = 95;
pub const nir_op_ball_fequal8: nir_op = 96;
pub const nir_op_ball_iequal16: nir_op = 97;
pub const nir_op_ball_iequal2: nir_op = 98;
pub const nir_op_ball_iequal3: nir_op = 99;
pub const nir_op_ball_iequal4: nir_op = 100;
pub const nir_op_ball_iequal5: nir_op = 101;
pub const nir_op_ball_iequal8: nir_op = 102;
pub const nir_op_bany_fnequal16: nir_op = 103;
pub const nir_op_bany_fnequal2: nir_op = 104;
pub const nir_op_bany_fnequal3: nir_op = 105;
pub const nir_op_bany_fnequal4: nir_op = 106;
pub const nir_op_bany_fnequal5: nir_op = 107;
pub const nir_op_bany_fnequal8: nir_op = 108;
pub const nir_op_bany_inequal16: nir_op = 109;
pub const nir_op_bany_inequal2: nir_op = 110;
pub const nir_op_bany_inequal3: nir_op = 111;
pub const nir_op_bany_inequal4: nir_op = 112;
pub const nir_op_bany_inequal5: nir_op = 113;
pub const nir_op_bany_inequal8: nir_op = 114;
pub const nir_op_bcsel: nir_op = 115;
pub const nir_op_bf2f: nir_op = 116;
pub const nir_op_bfdot16: nir_op = 117;
pub const nir_op_bfdot2: nir_op = 118;
pub const nir_op_bfdot2_bfadd: nir_op = 119;
pub const nir_op_bfdot3: nir_op = 120;
pub const nir_op_bfdot4: nir_op = 121;
pub const nir_op_bfdot5: nir_op = 122;
pub const nir_op_bfdot8: nir_op = 123;
pub const nir_op_bffma: nir_op = 124;
pub const nir_op_bfi: nir_op = 125;
pub const nir_op_bfm: nir_op = 126;
pub const nir_op_bfmul: nir_op = 127;
pub const nir_op_bit_count: nir_op = 128;
pub const nir_op_bitfield_insert: nir_op = 129;
pub const nir_op_bitfield_reverse: nir_op = 130;
pub const nir_op_bitfield_select: nir_op = 131;
pub const nir_op_bitnz: nir_op = 132;
pub const nir_op_bitnz16: nir_op = 133;
pub const nir_op_bitnz32: nir_op = 134;
pub const nir_op_bitnz8: nir_op = 135;
pub const nir_op_bitz: nir_op = 136;
pub const nir_op_bitz16: nir_op = 137;
pub const nir_op_bitz32: nir_op = 138;
pub const nir_op_bitz8: nir_op = 139;
pub const nir_op_bounds_agx: nir_op = 140;
pub const nir_op_byte_perm_amd: nir_op = 141;
pub const nir_op_cube_amd: nir_op = 142;
pub const nir_op_e4m3fn2f: nir_op = 143;
pub const nir_op_e5m22f: nir_op = 144;
pub const nir_op_extr_agx: nir_op = 145;
pub const nir_op_extract_i16: nir_op = 146;
pub const nir_op_extract_i8: nir_op = 147;
pub const nir_op_extract_u16: nir_op = 148;
pub const nir_op_extract_u8: nir_op = 149;
pub const nir_op_f2bf: nir_op = 150;
pub const nir_op_f2e4m3fn: nir_op = 151;
pub const nir_op_f2e4m3fn_sat: nir_op = 152;
pub const nir_op_f2e4m3fn_satfn: nir_op = 153;
pub const nir_op_f2e5m2: nir_op = 154;
pub const nir_op_f2e5m2_sat: nir_op = 155;
pub const nir_op_f2f16: nir_op = 156;
pub const nir_op_f2f16_rtne: nir_op = 157;
pub const nir_op_f2f16_rtz: nir_op = 158;
pub const nir_op_f2f32: nir_op = 159;
pub const nir_op_f2f64: nir_op = 160;
pub const nir_op_f2fmp: nir_op = 161;
pub const nir_op_f2i1: nir_op = 162;
pub const nir_op_f2i16: nir_op = 163;
pub const nir_op_f2i16_sat: nir_op = 164;
pub const nir_op_f2i32: nir_op = 165;
pub const nir_op_f2i32_rtne: nir_op = 166;
pub const nir_op_f2i32_sat: nir_op = 167;
pub const nir_op_f2i64: nir_op = 168;
pub const nir_op_f2i8: nir_op = 169;
pub const nir_op_f2i8_sat: nir_op = 170;
pub const nir_op_f2imp: nir_op = 171;
pub const nir_op_f2snorm_16_v3d: nir_op = 172;
pub const nir_op_f2u1: nir_op = 173;
pub const nir_op_f2u16: nir_op = 174;
pub const nir_op_f2u16_sat: nir_op = 175;
pub const nir_op_f2u32: nir_op = 176;
pub const nir_op_f2u32_sat: nir_op = 177;
pub const nir_op_f2u64: nir_op = 178;
pub const nir_op_f2u8: nir_op = 179;
pub const nir_op_f2u8_sat: nir_op = 180;
pub const nir_op_f2ump: nir_op = 181;
pub const nir_op_f2unorm_16_v3d: nir_op = 182;
pub const nir_op_fabs: nir_op = 183;
pub const nir_op_fadd: nir_op = 184;
pub const nir_op_fall_equal16: nir_op = 185;
pub const nir_op_fall_equal2: nir_op = 186;
pub const nir_op_fall_equal3: nir_op = 187;
pub const nir_op_fall_equal4: nir_op = 188;
pub const nir_op_fall_equal5: nir_op = 189;
pub const nir_op_fall_equal8: nir_op = 190;
pub const nir_op_fany_nequal16: nir_op = 191;
pub const nir_op_fany_nequal2: nir_op = 192;
pub const nir_op_fany_nequal3: nir_op = 193;
pub const nir_op_fany_nequal4: nir_op = 194;
pub const nir_op_fany_nequal5: nir_op = 195;
pub const nir_op_fany_nequal8: nir_op = 196;
pub const nir_op_fceil: nir_op = 197;
pub const nir_op_fclamp_pos: nir_op = 198;
pub const nir_op_fcopysign_pco: nir_op = 199;
pub const nir_op_fcos: nir_op = 200;
pub const nir_op_fcos_amd: nir_op = 201;
pub const nir_op_fcos_mdg: nir_op = 202;
pub const nir_op_fcsel: nir_op = 203;
pub const nir_op_fcsel_ge: nir_op = 204;
pub const nir_op_fcsel_gt: nir_op = 205;
pub const nir_op_fdiv: nir_op = 206;
pub const nir_op_fdot16: nir_op = 207;
pub const nir_op_fdot16_replicated: nir_op = 208;
pub const nir_op_fdot2: nir_op = 209;
pub const nir_op_fdot2_replicated: nir_op = 210;
pub const nir_op_fdot3: nir_op = 211;
pub const nir_op_fdot3_replicated: nir_op = 212;
pub const nir_op_fdot4: nir_op = 213;
pub const nir_op_fdot4_replicated: nir_op = 214;
pub const nir_op_fdot5: nir_op = 215;
pub const nir_op_fdot5_replicated: nir_op = 216;
pub const nir_op_fdot8: nir_op = 217;
pub const nir_op_fdot8_replicated: nir_op = 218;
pub const nir_op_fdph: nir_op = 219;
pub const nir_op_fdph_replicated: nir_op = 220;
pub const nir_op_feq: nir_op = 221;
pub const nir_op_feq16: nir_op = 222;
pub const nir_op_feq32: nir_op = 223;
pub const nir_op_feq8: nir_op = 224;
pub const nir_op_fequ: nir_op = 225;
pub const nir_op_fequ16: nir_op = 226;
pub const nir_op_fequ32: nir_op = 227;
pub const nir_op_fequ8: nir_op = 228;
pub const nir_op_fexp2: nir_op = 229;
pub const nir_op_ffloor: nir_op = 230;
pub const nir_op_ffma: nir_op = 231;
pub const nir_op_ffmaz: nir_op = 232;
pub const nir_op_ffract: nir_op = 233;
pub const nir_op_fge: nir_op = 234;
pub const nir_op_fge16: nir_op = 235;
pub const nir_op_fge32: nir_op = 236;
pub const nir_op_fge8: nir_op = 237;
pub const nir_op_fgeu: nir_op = 238;
pub const nir_op_fgeu16: nir_op = 239;
pub const nir_op_fgeu32: nir_op = 240;
pub const nir_op_fgeu8: nir_op = 241;
pub const nir_op_find_lsb: nir_op = 242;
pub const nir_op_fisfinite: nir_op = 243;
pub const nir_op_fisfinite32: nir_op = 244;
pub const nir_op_fisnormal: nir_op = 245;
pub const nir_op_flog2: nir_op = 246;
pub const nir_op_flrp: nir_op = 247;
pub const nir_op_flt: nir_op = 248;
pub const nir_op_flt16: nir_op = 249;
pub const nir_op_flt32: nir_op = 250;
pub const nir_op_flt8: nir_op = 251;
pub const nir_op_fltu: nir_op = 252;
pub const nir_op_fltu16: nir_op = 253;
pub const nir_op_fltu32: nir_op = 254;
pub const nir_op_fltu8: nir_op = 255;
pub const nir_op_fmax: nir_op = 256;
pub const nir_op_fmax_agx: nir_op = 257;
pub const nir_op_fmin: nir_op = 258;
pub const nir_op_fmin_agx: nir_op = 259;
pub const nir_op_fmod: nir_op = 260;
pub const nir_op_fmul: nir_op = 261;
pub const nir_op_fmulz: nir_op = 262;
pub const nir_op_fneg: nir_op = 263;
pub const nir_op_fneo: nir_op = 264;
pub const nir_op_fneo16: nir_op = 265;
pub const nir_op_fneo32: nir_op = 266;
pub const nir_op_fneo8: nir_op = 267;
pub const nir_op_fneu: nir_op = 268;
pub const nir_op_fneu16: nir_op = 269;
pub const nir_op_fneu32: nir_op = 270;
pub const nir_op_fneu8: nir_op = 271;
pub const nir_op_ford: nir_op = 272;
pub const nir_op_ford16: nir_op = 273;
pub const nir_op_ford32: nir_op = 274;
pub const nir_op_ford8: nir_op = 275;
pub const nir_op_fpow: nir_op = 276;
pub const nir_op_fquantize2f16: nir_op = 277;
pub const nir_op_frcp: nir_op = 278;
pub const nir_op_frem: nir_op = 279;
pub const nir_op_frexp_exp: nir_op = 280;
pub const nir_op_frexp_sig: nir_op = 281;
pub const nir_op_fround_even: nir_op = 282;
pub const nir_op_frsq: nir_op = 283;
pub const nir_op_fsat: nir_op = 284;
pub const nir_op_fsat_signed: nir_op = 285;
pub const nir_op_fsign: nir_op = 286;
pub const nir_op_fsin: nir_op = 287;
pub const nir_op_fsin_agx: nir_op = 288;
pub const nir_op_fsin_amd: nir_op = 289;
pub const nir_op_fsin_mdg: nir_op = 290;
pub const nir_op_fsqrt: nir_op = 291;
pub const nir_op_fsub: nir_op = 292;
pub const nir_op_fsum2: nir_op = 293;
pub const nir_op_fsum3: nir_op = 294;
pub const nir_op_fsum4: nir_op = 295;
pub const nir_op_ftrunc: nir_op = 296;
pub const nir_op_funord: nir_op = 297;
pub const nir_op_funord16: nir_op = 298;
pub const nir_op_funord32: nir_op = 299;
pub const nir_op_funord8: nir_op = 300;
pub const nir_op_i2f16: nir_op = 301;
pub const nir_op_i2f32: nir_op = 302;
pub const nir_op_i2f64: nir_op = 303;
pub const nir_op_i2fmp: nir_op = 304;
pub const nir_op_i2i1: nir_op = 305;
pub const nir_op_i2i16: nir_op = 306;
pub const nir_op_i2i32: nir_op = 307;
pub const nir_op_i2i64: nir_op = 308;
pub const nir_op_i2i8: nir_op = 309;
pub const nir_op_i2imp: nir_op = 310;
pub const nir_op_i32csel_ge: nir_op = 311;
pub const nir_op_i32csel_gt: nir_op = 312;
pub const nir_op_iabs: nir_op = 313;
pub const nir_op_iadd: nir_op = 314;
pub const nir_op_iadd3: nir_op = 315;
pub const nir_op_iadd_sat: nir_op = 316;
pub const nir_op_iand: nir_op = 317;
pub const nir_op_ibfe: nir_op = 318;
pub const nir_op_ibitfield_extract: nir_op = 319;
pub const nir_op_icsel_eqz: nir_op = 320;
pub const nir_op_idiv: nir_op = 321;
pub const nir_op_ieq: nir_op = 322;
pub const nir_op_ieq16: nir_op = 323;
pub const nir_op_ieq32: nir_op = 324;
pub const nir_op_ieq8: nir_op = 325;
pub const nir_op_ifind_msb: nir_op = 326;
pub const nir_op_ifind_msb_rev: nir_op = 327;
pub const nir_op_ige: nir_op = 328;
pub const nir_op_ige16: nir_op = 329;
pub const nir_op_ige32: nir_op = 330;
pub const nir_op_ige8: nir_op = 331;
pub const nir_op_ihadd: nir_op = 332;
pub const nir_op_ilea_agx: nir_op = 333;
pub const nir_op_ilt: nir_op = 334;
pub const nir_op_ilt16: nir_op = 335;
pub const nir_op_ilt32: nir_op = 336;
pub const nir_op_ilt8: nir_op = 337;
pub const nir_op_imad: nir_op = 338;
pub const nir_op_imad24_ir3: nir_op = 339;
pub const nir_op_imadsh_mix16: nir_op = 340;
pub const nir_op_imadshl_agx: nir_op = 341;
pub const nir_op_imax: nir_op = 342;
pub const nir_op_imin: nir_op = 343;
pub const nir_op_imod: nir_op = 344;
pub const nir_op_imsubshl_agx: nir_op = 345;
pub const nir_op_imul: nir_op = 346;
pub const nir_op_imul24: nir_op = 347;
pub const nir_op_imul24_relaxed: nir_op = 348;
pub const nir_op_imul_2x32_64: nir_op = 349;
pub const nir_op_imul_32x16: nir_op = 350;
pub const nir_op_imul_high: nir_op = 351;
pub const nir_op_ine: nir_op = 352;
pub const nir_op_ine16: nir_op = 353;
pub const nir_op_ine32: nir_op = 354;
pub const nir_op_ine8: nir_op = 355;
pub const nir_op_ineg: nir_op = 356;
pub const nir_op_inot: nir_op = 357;
pub const nir_op_insert_u16: nir_op = 358;
pub const nir_op_insert_u8: nir_op = 359;
pub const nir_op_interleave: nir_op = 360;
pub const nir_op_ior: nir_op = 361;
pub const nir_op_irem: nir_op = 362;
pub const nir_op_irhadd: nir_op = 363;
pub const nir_op_ishl: nir_op = 364;
pub const nir_op_ishr: nir_op = 365;
pub const nir_op_isign: nir_op = 366;
pub const nir_op_isub: nir_op = 367;
pub const nir_op_isub_sat: nir_op = 368;
pub const nir_op_ixor: nir_op = 369;
pub const nir_op_ldexp: nir_op = 370;
pub const nir_op_ldexp16_pan: nir_op = 371;
pub const nir_op_lea_nv: nir_op = 372;
pub const nir_op_mov: nir_op = 373;
pub const nir_op_mqsad_4x8: nir_op = 374;
pub const nir_op_msad_4x8: nir_op = 375;
pub const nir_op_pack_2x16_to_snorm_2x8_v3d: nir_op = 376;
pub const nir_op_pack_2x16_to_unorm_10_2_v3d: nir_op = 377;
pub const nir_op_pack_2x16_to_unorm_2x10_v3d: nir_op = 378;
pub const nir_op_pack_2x16_to_unorm_2x8_v3d: nir_op = 379;
pub const nir_op_pack_2x32_to_2x16_v3d: nir_op = 380;
pub const nir_op_pack_32_2x16: nir_op = 381;
pub const nir_op_pack_32_2x16_split: nir_op = 382;
pub const nir_op_pack_32_4x8: nir_op = 383;
pub const nir_op_pack_32_4x8_split: nir_op = 384;
pub const nir_op_pack_32_to_r11g11b10_v3d: nir_op = 385;
pub const nir_op_pack_4x16_to_4x8_v3d: nir_op = 386;
pub const nir_op_pack_64_2x32: nir_op = 387;
pub const nir_op_pack_64_2x32_split: nir_op = 388;
pub const nir_op_pack_64_4x16: nir_op = 389;
pub const nir_op_pack_double_2x32_dxil: nir_op = 390;
pub const nir_op_pack_half_2x16: nir_op = 391;
pub const nir_op_pack_half_2x16_rtz_split: nir_op = 392;
pub const nir_op_pack_half_2x16_split: nir_op = 393;
pub const nir_op_pack_sint_2x16: nir_op = 394;
pub const nir_op_pack_snorm_2x16: nir_op = 395;
pub const nir_op_pack_snorm_4x8: nir_op = 396;
pub const nir_op_pack_uint_2x16: nir_op = 397;
pub const nir_op_pack_uint_32_to_r10g10b10a2_v3d: nir_op = 398;
pub const nir_op_pack_unorm_2x16: nir_op = 399;
pub const nir_op_pack_unorm_4x8: nir_op = 400;
pub const nir_op_pack_uvec2_to_uint: nir_op = 401;
pub const nir_op_pack_uvec4_to_uint: nir_op = 402;
pub const nir_op_prmt_nv: nir_op = 403;
pub const nir_op_sdot_2x16_iadd: nir_op = 404;
pub const nir_op_sdot_2x16_iadd_sat: nir_op = 405;
pub const nir_op_sdot_4x8_iadd: nir_op = 406;
pub const nir_op_sdot_4x8_iadd_sat: nir_op = 407;
pub const nir_op_seq: nir_op = 408;
pub const nir_op_sge: nir_op = 409;
pub const nir_op_shfr: nir_op = 410;
pub const nir_op_shlg_ir3: nir_op = 411;
pub const nir_op_shlm_ir3: nir_op = 412;
pub const nir_op_shrg_ir3: nir_op = 413;
pub const nir_op_shrm_ir3: nir_op = 414;
pub const nir_op_slt: nir_op = 415;
pub const nir_op_sne: nir_op = 416;
pub const nir_op_snorm2f_16_v3d: nir_op = 417;
pub const nir_op_sudot_4x8_iadd: nir_op = 418;
pub const nir_op_sudot_4x8_iadd_sat: nir_op = 419;
pub const nir_op_u2f16: nir_op = 420;
pub const nir_op_u2f32: nir_op = 421;
pub const nir_op_u2f64: nir_op = 422;
pub const nir_op_u2fmp: nir_op = 423;
pub const nir_op_u2u1: nir_op = 424;
pub const nir_op_u2u16: nir_op = 425;
pub const nir_op_u2u32: nir_op = 426;
pub const nir_op_u2u64: nir_op = 427;
pub const nir_op_u2u8: nir_op = 428;
pub const nir_op_uabs_isub: nir_op = 429;
pub const nir_op_uabs_usub: nir_op = 430;
pub const nir_op_uadd64_32: nir_op = 431;
pub const nir_op_uadd_carry: nir_op = 432;
pub const nir_op_uadd_sat: nir_op = 433;
pub const nir_op_ubfe: nir_op = 434;
pub const nir_op_ubitfield_extract: nir_op = 435;
pub const nir_op_uclz: nir_op = 436;
pub const nir_op_udiv: nir_op = 437;
pub const nir_op_udiv_aligned_4: nir_op = 438;
pub const nir_op_udot_2x16_uadd: nir_op = 439;
pub const nir_op_udot_2x16_uadd_sat: nir_op = 440;
pub const nir_op_udot_4x8_uadd: nir_op = 441;
pub const nir_op_udot_4x8_uadd_sat: nir_op = 442;
pub const nir_op_ufind_msb: nir_op = 443;
pub const nir_op_ufind_msb_rev: nir_op = 444;
pub const nir_op_uge: nir_op = 445;
pub const nir_op_uge16: nir_op = 446;
pub const nir_op_uge32: nir_op = 447;
pub const nir_op_uge8: nir_op = 448;
pub const nir_op_uhadd: nir_op = 449;
pub const nir_op_ulea_agx: nir_op = 450;
pub const nir_op_ult: nir_op = 451;
pub const nir_op_ult16: nir_op = 452;
pub const nir_op_ult32: nir_op = 453;
pub const nir_op_ult8: nir_op = 454;
pub const nir_op_umad24: nir_op = 455;
pub const nir_op_umad24_relaxed: nir_op = 456;
pub const nir_op_umad64_32: nir_op = 457;
pub const nir_op_umax: nir_op = 458;
pub const nir_op_umax_4x8_vc4: nir_op = 459;
pub const nir_op_umin: nir_op = 460;
pub const nir_op_umin_4x8_vc4: nir_op = 461;
pub const nir_op_umod: nir_op = 462;
pub const nir_op_umul24: nir_op = 463;
pub const nir_op_umul24_relaxed: nir_op = 464;
pub const nir_op_umul_16x16: nir_op = 465;
pub const nir_op_umul_2x32_64: nir_op = 466;
pub const nir_op_umul_32x16: nir_op = 467;
pub const nir_op_umul_high: nir_op = 468;
pub const nir_op_umul_unorm_4x8_vc4: nir_op = 469;
pub const nir_op_unorm2f_16_v3d: nir_op = 470;
pub const nir_op_unpack_32_2x16: nir_op = 471;
pub const nir_op_unpack_32_2x16_split_x: nir_op = 472;
pub const nir_op_unpack_32_2x16_split_y: nir_op = 473;
pub const nir_op_unpack_32_4x8: nir_op = 474;
pub const nir_op_unpack_64_2x32: nir_op = 475;
pub const nir_op_unpack_64_2x32_split_x: nir_op = 476;
pub const nir_op_unpack_64_2x32_split_y: nir_op = 477;
pub const nir_op_unpack_64_4x16: nir_op = 478;
pub const nir_op_unpack_double_2x32_dxil: nir_op = 479;
pub const nir_op_unpack_half_2x16: nir_op = 480;
pub const nir_op_unpack_half_2x16_split_x: nir_op = 481;
pub const nir_op_unpack_half_2x16_split_y: nir_op = 482;
pub const nir_op_unpack_snorm_2x16: nir_op = 483;
pub const nir_op_unpack_snorm_4x8: nir_op = 484;
pub const nir_op_unpack_unorm_2x16: nir_op = 485;
pub const nir_op_unpack_unorm_4x8: nir_op = 486;
pub const nir_op_urhadd: nir_op = 487;
pub const nir_op_urol: nir_op = 488;
pub const nir_op_uror: nir_op = 489;
pub const nir_op_usadd_4x8_vc4: nir_op = 490;
pub const nir_op_ushr: nir_op = 491;
pub const nir_op_ussub_4x8_vc4: nir_op = 492;
pub const nir_op_usub_borrow: nir_op = 493;
pub const nir_op_usub_sat: nir_op = 494;
pub const nir_op_vec16: nir_op = 495;
pub const nir_op_vec2: nir_op = 496;
pub const nir_op_vec3: nir_op = 497;
pub const nir_op_vec4: nir_op = 498;
pub const nir_op_vec5: nir_op = 499;
pub const nir_op_vec8: nir_op = 500;
pub const nir_last_opcode: nir_op = 500;
pub const nir_num_opcodes: nir_op = 501;
pub type nir_op = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct u_printf_info {
    _unused: [u8; 0],
}
pub type nir_component_mask_t = u16;
unsafe extern "C" {
    pub fn nir_process_debug_variable();
}
unsafe extern "C" {
    pub fn nir_component_mask_can_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_component_mask_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
#[doc = " Description of built-in state associated with a uniform\n\n :c:member:`nir_variable.state_slots`"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_state_slot {
    pub tokens: [gl_state_index16; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_state_slot"][::std::mem::size_of::<nir_state_slot>() - 8usize];
    ["Alignment of nir_state_slot"][::std::mem::align_of::<nir_state_slot>() - 2usize];
    ["Offset of field: nir_state_slot::tokens"]
        [::std::mem::offset_of!(nir_state_slot, tokens) - 0usize];
};
pub const nir_rounding_mode_undef: nir_rounding_mode = 0;
pub const nir_rounding_mode_rtne: nir_rounding_mode = 1;
pub const nir_rounding_mode_ru: nir_rounding_mode = 2;
pub const nir_rounding_mode_rd: nir_rounding_mode = 3;
pub const nir_rounding_mode_rtz: nir_rounding_mode = 4;
#[doc = " Rounding modes."]
pub type nir_rounding_mode = ::std::os::raw::c_uint;
pub const nir_ray_query_value_intersection_type: nir_ray_query_value = 0;
pub const nir_ray_query_value_intersection_t: nir_ray_query_value = 1;
pub const nir_ray_query_value_intersection_instance_custom_index: nir_ray_query_value = 2;
pub const nir_ray_query_value_intersection_instance_id: nir_ray_query_value = 3;
pub const nir_ray_query_value_intersection_instance_sbt_index: nir_ray_query_value = 4;
pub const nir_ray_query_value_intersection_geometry_index: nir_ray_query_value = 5;
pub const nir_ray_query_value_intersection_primitive_index: nir_ray_query_value = 6;
pub const nir_ray_query_value_intersection_barycentrics: nir_ray_query_value = 7;
pub const nir_ray_query_value_intersection_front_face: nir_ray_query_value = 8;
pub const nir_ray_query_value_intersection_object_ray_direction: nir_ray_query_value = 9;
pub const nir_ray_query_value_intersection_object_ray_origin: nir_ray_query_value = 10;
pub const nir_ray_query_value_intersection_object_to_world: nir_ray_query_value = 11;
pub const nir_ray_query_value_intersection_world_to_object: nir_ray_query_value = 12;
pub const nir_ray_query_value_intersection_candidate_aabb_opaque: nir_ray_query_value = 13;
pub const nir_ray_query_value_tmin: nir_ray_query_value = 14;
pub const nir_ray_query_value_flags: nir_ray_query_value = 15;
pub const nir_ray_query_value_world_ray_direction: nir_ray_query_value = 16;
pub const nir_ray_query_value_world_ray_origin: nir_ray_query_value = 17;
pub const nir_ray_query_value_intersection_triangle_vertex_positions: nir_ray_query_value = 18;
#[doc = " Ray query values that can read from a RayQueryKHR object."]
pub type nir_ray_query_value = ::std::os::raw::c_uint;
pub const nir_resource_intel_bindless: nir_resource_data_intel = 1;
pub const nir_resource_intel_pushable: nir_resource_data_intel = 2;
pub const nir_resource_intel_sampler: nir_resource_data_intel = 4;
pub const nir_resource_intel_non_uniform: nir_resource_data_intel = 8;
pub const nir_resource_intel_sampler_embedded: nir_resource_data_intel = 16;
#[doc = " Intel resource flags"]
pub type nir_resource_data_intel = ::std::os::raw::c_uint;
pub const nir_preamble_class_general: nir_preamble_class = 0;
pub const nir_preamble_class_image: nir_preamble_class = 1;
pub const nir_preamble_class_sampler: nir_preamble_class = 2;
pub const nir_preamble_num_classes: nir_preamble_class = 3;
#[doc = " Register class for registers managed by nir_opt_preamble. General can handle\n anything, the others are driver-specific but with common names for nir_print."]
pub type nir_preamble_class = ::std::os::raw::c_uint;
pub const NIR_CMAT_A_SIGNED: nir_cmat_signed = 1;
pub const NIR_CMAT_B_SIGNED: nir_cmat_signed = 2;
pub const NIR_CMAT_C_SIGNED: nir_cmat_signed = 4;
pub const NIR_CMAT_RESULT_SIGNED: nir_cmat_signed = 8;
#[doc = " Which components to interpret as signed in cmat_muladd.\n See 'Cooperative Matrix Operands' in SPV_KHR_cooperative_matrix."]
pub type nir_cmat_signed = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_const_value_for_float(b: f64, bit_size: ::std::os::raw::c_uint) -> nir_const_value;
}
unsafe extern "C" {
    pub fn nir_const_value_as_float(
        value: nir_const_value,
        bit_size: ::std::os::raw::c_uint,
    ) -> f64;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_constant {
    #[doc = " Value of the constant.\n\n The field used to back the values supplied by the constant is determined\n by the type associated with the ``nir_variable``.  Constants may be\n scalars, vectors, or matrices."]
    pub values: [nir_const_value; 16usize],
    pub is_null_constant: bool,
    pub num_elements: ::std::os::raw::c_uint,
    pub elements: *mut *mut nir_constant,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_constant"][::std::mem::size_of::<nir_constant>() - 144usize];
    ["Alignment of nir_constant"][::std::mem::align_of::<nir_constant>() - 8usize];
    ["Offset of field: nir_constant::values"]
        [::std::mem::offset_of!(nir_constant, values) - 0usize];
    ["Offset of field: nir_constant::is_null_constant"]
        [::std::mem::offset_of!(nir_constant, is_null_constant) - 128usize];
    ["Offset of field: nir_constant::num_elements"]
        [::std::mem::offset_of!(nir_constant, num_elements) - 132usize];
    ["Offset of field: nir_constant::elements"]
        [::std::mem::offset_of!(nir_constant, elements) - 136usize];
};
impl Default for nir_constant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " No depth layout is specified."]
pub const nir_depth_layout_none: nir_depth_layout = 0;
#[doc = " No depth layout is specified."]
pub const nir_depth_layout_any: nir_depth_layout = 1;
#[doc = " No depth layout is specified."]
pub const nir_depth_layout_greater: nir_depth_layout = 2;
#[doc = " No depth layout is specified."]
pub const nir_depth_layout_less: nir_depth_layout = 3;
#[doc = " No depth layout is specified."]
pub const nir_depth_layout_unchanged: nir_depth_layout = 4;
#[doc = " Layout qualifiers for gl_FragDepth.\n\n The AMD/ARB_conservative_depth extensions allow gl_FragDepth to be redeclared\n with a layout qualifier."]
pub type nir_depth_layout = ::std::os::raw::c_uint;
#[doc = " Normal declaration."]
pub const nir_var_declared_normally: nir_var_declaration_type = 0;
#[doc = " Variable is an implicitly declared built-in that has not been explicitly\n re-declared by the shader."]
pub const nir_var_declared_implicitly: nir_var_declaration_type = 1;
#[doc = " Variable is implicitly generated by the compiler and should not be\n visible via the API."]
pub const nir_var_hidden: nir_var_declaration_type = 2;
#[doc = " Enum keeping track of how a variable was declared."]
pub type nir_var_declaration_type = ::std::os::raw::c_uint;
#[doc = " Either a uniform, global variable, shader input, or shader output. Based on\n ir_variable - it should be easy to translate between the two."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable {
    pub node: exec_node,
    #[doc = " Declared type of the variable"]
    pub type_: *const glsl_type,
    #[doc = " Declared name of the variable"]
    pub name: *mut ::std::os::raw::c_char,
    pub data: nir_variable_data,
    #[doc = " Identifier for this variable generated by nir_index_vars() that is unique\n among other variables in the same exec_list."]
    pub index: ::std::os::raw::c_uint,
    pub num_members: u16,
    #[doc = " For variables with non NULL interface_type, this points to an array of\n integers such that if the ith member of the interface block is an array,\n max_ifc_array_access[i] is the maximum array element of that member that\n has been accessed.  If the ith member of the interface block is not an\n array, max_ifc_array_access[i] is unused.\n\n For variables whose type is not an interface block, this pointer is\n NULL."]
    pub max_ifc_array_access: *mut ::std::os::raw::c_int,
    #[doc = " Built-in state that backs this uniform\n\n Once set at variable creation, ``state_slots`` must remain invariant.\n This is because, ideally, this array would be shared by all clones of\n this variable in the IR tree.  In other words, we'd really like for it\n to be a fly-weight.\n\n If the variable is not a uniform, ``num_state_slots`` will be zero and\n ``state_slots`` will be ``NULL``.\n\n Number of state slots used."]
    pub num_state_slots: u16,
    #[doc = " State descriptors."]
    pub state_slots: *mut nir_state_slot,
    #[doc = " Constant expression assigned in the initializer of the variable\n\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub constant_initializer: *mut nir_constant,
    #[doc = " Global variable assigned in the initializer of the variable\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub pointer_initializer: *mut nir_variable,
    #[doc = " For variables that are in an interface block or are an instance of an\n interface block, this is the ``GLSL_TYPE_INTERFACE`` type for that block.\n\n ``ir_variable.location``"]
    pub interface_type: *const glsl_type,
    #[doc = " Description of per-member data for per-member struct variables\n\n This is used for variables which are actually an amalgamation of\n multiple entities such as a struct of built-in values or a struct of\n inputs each with their own layout specifier.  This is only allowed on\n variables with a struct or array of array of struct type."]
    pub members: *mut nir_variable_data,
    #[doc = " This is the backing storage for \"name\" if the name is short enough\n to fit in it, so that we don't have to ralloc the name.\n\n It eliminates 95.6% ralloc calls for variable names when compiling\n my GLSL shader-db."]
    pub _name_storage: [::std::os::raw::c_char; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable_data {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " Highest element accessed with a constant array index\n\n Not used for non-array variables. -1 is never accessed."]
    pub max_array_access: ::std::os::raw::c_int,
    pub _bitfield_align_2: [u16; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " Output index for dual source blending or input attachment index. If\n it is not declared it is NIR_VARIABLE_NO_INDEX."]
    pub index: ::std::os::raw::c_uint,
    #[doc = " Initial binding point for a sampler or UBO.\n\n For array types, this represents the binding point for the first element."]
    pub binding: ::std::os::raw::c_uint,
    #[doc = " Storage location of the base of this variable\n\n The precise meaning of this field depends on the nature of the variable.\n\n   - Vertex shader input: one of the values from ``gl_vert_attrib``.\n   - Vertex shader output: one of the values from ``gl_varying_slot``.\n   - Geometry shader input: one of the values from ``gl_varying_slot``.\n   - Geometry shader output: one of the values from ``gl_varying_slot``.\n   - Fragment shader input: one of the values from ``gl_varying_slot``.\n   - Fragment shader output: one of the values from ``gl_frag_result``.\n   - Task shader output: one of the values from ``gl_varying_slot``.\n   - Mesh shader input: one of the values from ``gl_varying_slot``.\n   - Mesh shader output: one of the values from ``gl_varying_slot``.\n   - Uniforms: Per-stage uniform slot number for default uniform block.\n   - Uniforms: Index within the uniform block definition for UBO members.\n   - Non-UBO Uniforms: uniform slot number.\n   - Other: This field is not currently used.\n\n If the variable is a uniform, shader input, or shader output, and the\n slot has not been assigned, the value will be -1."]
    pub location: ::std::os::raw::c_int,
    #[doc = " Required alignment of this variable"]
    pub alignment: ::std::os::raw::c_uint,
    #[doc = " The actual location of the variable in the IR. Only valid for inputs,\n outputs, uniforms (including samplers and images), and for UBO and SSBO\n variables in GLSL."]
    pub driver_location: ::std::os::raw::c_uint,
    #[doc = " Location an atomic counter or transform feedback is stored at."]
    pub offset: ::std::os::raw::c_uint,
    pub __bindgen_anon_1: nir_variable_data__bindgen_ty_1,
    #[doc = " Name of the node this payload will be enqueued to."]
    pub node_name: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_variable_data__bindgen_ty_1 {
    pub image: nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    pub sampler: nir_variable_data__bindgen_ty_1__bindgen_ty_2,
    pub xfb: nir_variable_data__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Image internal format if specified explicitly, otherwise PIPE_FORMAT_NONE."]
    pub format: pipe_format,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_data__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Alignment of nir_variable_data__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_variable_data__bindgen_ty_1__bindgen_ty_1::format"]
        [::std::mem::offset_of!(nir_variable_data__bindgen_ty_1__bindgen_ty_1, format) - 0usize];
};
impl Default for nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_data__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_2>() - 4usize];
    ["Alignment of nir_variable_data__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_2>() - 4usize];
};
impl nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn is_inline_sampler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_inline_sampler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_inline_sampler_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_inline_sampler_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn addressing_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_addressing_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn addressing_mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_addressing_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn normalized_coordinates(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized_coordinates(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn normalized_coordinates_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_normalized_coordinates_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn filter_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_filter_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn filter_mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_filter_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_inline_sampler: ::std::os::raw::c_uint,
        addressing_mode: ::std::os::raw::c_uint,
        normalized_coordinates: ::std::os::raw::c_uint,
        filter_mode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_inline_sampler: u32 = unsafe { ::std::mem::transmute(is_inline_sampler) };
            is_inline_sampler as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let addressing_mode: u32 = unsafe { ::std::mem::transmute(addressing_mode) };
            addressing_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let normalized_coordinates: u32 =
                unsafe { ::std::mem::transmute(normalized_coordinates) };
            normalized_coordinates as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let filter_mode: u32 = unsafe { ::std::mem::transmute(filter_mode) };
            filter_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Transform feedback stride."]
    pub stride: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_data__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Alignment of nir_variable_data__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<nir_variable_data__bindgen_ty_1__bindgen_ty_3>() - 2usize];
    ["Offset of field: nir_variable_data__bindgen_ty_1__bindgen_ty_3::stride"]
        [::std::mem::offset_of!(nir_variable_data__bindgen_ty_1__bindgen_ty_3, stride) - 2usize];
};
impl nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn buffer(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_buffer(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn buffer_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_buffer_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(buffer: u16) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let buffer: u16 = unsafe { ::std::mem::transmute(buffer) };
            buffer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_data__bindgen_ty_1"]
        [::std::mem::size_of::<nir_variable_data__bindgen_ty_1>() - 4usize];
    ["Alignment of nir_variable_data__bindgen_ty_1"]
        [::std::mem::align_of::<nir_variable_data__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_variable_data__bindgen_ty_1::image"]
        [::std::mem::offset_of!(nir_variable_data__bindgen_ty_1, image) - 0usize];
    ["Offset of field: nir_variable_data__bindgen_ty_1::sampler"]
        [::std::mem::offset_of!(nir_variable_data__bindgen_ty_1, sampler) - 0usize];
    ["Offset of field: nir_variable_data__bindgen_ty_1::xfb"]
        [::std::mem::offset_of!(nir_variable_data__bindgen_ty_1, xfb) - 0usize];
};
impl Default for nir_variable_data__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_data"][::std::mem::size_of::<nir_variable_data>() - 56usize];
    ["Alignment of nir_variable_data"][::std::mem::align_of::<nir_variable_data>() - 8usize];
    ["Offset of field: nir_variable_data::max_array_access"]
        [::std::mem::offset_of!(nir_variable_data, max_array_access) - 8usize];
    ["Offset of field: nir_variable_data::index"]
        [::std::mem::offset_of!(nir_variable_data, index) - 20usize];
    ["Offset of field: nir_variable_data::binding"]
        [::std::mem::offset_of!(nir_variable_data, binding) - 24usize];
    ["Offset of field: nir_variable_data::location"]
        [::std::mem::offset_of!(nir_variable_data, location) - 28usize];
    ["Offset of field: nir_variable_data::alignment"]
        [::std::mem::offset_of!(nir_variable_data, alignment) - 32usize];
    ["Offset of field: nir_variable_data::driver_location"]
        [::std::mem::offset_of!(nir_variable_data, driver_location) - 36usize];
    ["Offset of field: nir_variable_data::offset"]
        [::std::mem::offset_of!(nir_variable_data, offset) - 40usize];
    ["Offset of field: nir_variable_data::node_name"]
        [::std::mem::offset_of!(nir_variable_data, node_name) - 48usize];
};
impl Default for nir_variable_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_variable_data {
    #[inline]
    pub fn mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 21u8) as u32) }
    }
    #[inline]
    pub fn set_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 21u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                21u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                21u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn read_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_read_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn centroid_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_centroid_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sample_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn patch_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_patch_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn invariant_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_invariant_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_invariant_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_invariant_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ray_query(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ray_query(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ray_query_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_ray_query_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn assigned(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_assigned(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn assigned_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_assigned_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn cannot_coalesce(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cannot_coalesce(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn cannot_coalesce_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_cannot_coalesce_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn always_active_io(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_always_active_io(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn always_active_io_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                32usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_always_active_io_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                32usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(33usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(33usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interpolation_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                33usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interpolation_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                33usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn location_frac(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(36usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_location_frac(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(36usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn location_frac_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                36usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_location_frac_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                36usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn compact(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(38usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compact(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(38usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn compact_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                38usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_compact_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                38usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(39usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(39usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                39usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                39usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn bindless(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bindless(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn bindless_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                40usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_bindless_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                40usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_binding(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(41usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_binding(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(41usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_binding_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                41usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_binding_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                41usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_location(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(42usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_location(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(42usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_location_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                42usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_location_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                42usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(43usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(43usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn implicit_sized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                43usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_implicit_sized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                43usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mode: ::std::os::raw::c_uint,
        read_only: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        invariant: ::std::os::raw::c_uint,
        explicit_invariant: ::std::os::raw::c_uint,
        ray_query: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        assigned: ::std::os::raw::c_uint,
        cannot_coalesce: ::std::os::raw::c_uint,
        always_active_io: ::std::os::raw::c_uint,
        interpolation: ::std::os::raw::c_uint,
        location_frac: ::std::os::raw::c_uint,
        compact: ::std::os::raw::c_uint,
        fb_fetch_output: ::std::os::raw::c_uint,
        bindless: ::std::os::raw::c_uint,
        explicit_binding: ::std::os::raw::c_uint,
        explicit_location: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 21u8, {
            let mode: u32 = unsafe { ::std::mem::transmute(mode) };
            mode as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let read_only: u32 = unsafe { ::std::mem::transmute(read_only) };
            read_only as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let invariant: u32 = unsafe { ::std::mem::transmute(invariant) };
            invariant as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let explicit_invariant: u32 = unsafe { ::std::mem::transmute(explicit_invariant) };
            explicit_invariant as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let ray_query: u32 = unsafe { ::std::mem::transmute(ray_query) };
            ray_query as u64
        });
        __bindgen_bitfield_unit.set(28usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let assigned: u32 = unsafe { ::std::mem::transmute(assigned) };
            assigned as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let cannot_coalesce: u32 = unsafe { ::std::mem::transmute(cannot_coalesce) };
            cannot_coalesce as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let always_active_io: u32 = unsafe { ::std::mem::transmute(always_active_io) };
            always_active_io as u64
        });
        __bindgen_bitfield_unit.set(33usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(36usize, 2u8, {
            let location_frac: u32 = unsafe { ::std::mem::transmute(location_frac) };
            location_frac as u64
        });
        __bindgen_bitfield_unit.set(38usize, 1u8, {
            let compact: u32 = unsafe { ::std::mem::transmute(compact) };
            compact as u64
        });
        __bindgen_bitfield_unit.set(39usize, 1u8, {
            let fb_fetch_output: u32 = unsafe { ::std::mem::transmute(fb_fetch_output) };
            fb_fetch_output as u64
        });
        __bindgen_bitfield_unit.set(40usize, 1u8, {
            let bindless: u32 = unsafe { ::std::mem::transmute(bindless) };
            bindless as u64
        });
        __bindgen_bitfield_unit.set(41usize, 1u8, {
            let explicit_binding: u32 = unsafe { ::std::mem::transmute(explicit_binding) };
            explicit_binding as u64
        });
        __bindgen_bitfield_unit.set(42usize, 1u8, {
            let explicit_location: u32 = unsafe { ::std::mem::transmute(explicit_location) };
            explicit_location as u64
        });
        __bindgen_bitfield_unit.set(43usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn has_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_initializer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_has_initializer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_implicit_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_implicit_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_implicit_initializer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_implicit_initializer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_xfb(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_xfb_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_xfb_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_xfb_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_xfb_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_xfb_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_buffer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_buffer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_stride(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_stride(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_stride_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_stride_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_offset(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_offset(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_offset_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_offset_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn matrix_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                7usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_matrix_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                7usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn from_named_ifc_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_named_ifc_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn from_named_ifc_block_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                9usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_from_named_ifc_block_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn from_ssbo_unsized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_ssbo_unsized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn from_ssbo_unsized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                10usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_from_ssbo_unsized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn must_be_shader_input(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_must_be_shader_input(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn must_be_shader_input_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                11usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_must_be_shader_input_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn used(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn used_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                12usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_used_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn how_declared(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(13usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_how_declared(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(13usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn how_declared_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                13usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_how_declared_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                13usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_view(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_view(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_view_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_view_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_primitive(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_primitive(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_primitive_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                16usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_primitive_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_vertex(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_vertex(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_vertex_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                17usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_vertex_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn aliased_shared_memory(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aliased_shared_memory(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn aliased_shared_memory_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                18usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_aliased_shared_memory_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(19usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(19usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn depth_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                19usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_depth_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                19usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stream(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(22usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_stream(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(22usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stream_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                22usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stream_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                22usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn access(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(32usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_access(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(32usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn access_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                32usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_access_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                32usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn descriptor_set(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(41usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_descriptor_set(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(41usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn descriptor_set_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                41usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_descriptor_set_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                41usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        has_initializer: ::std::os::raw::c_uint,
        is_implicit_initializer: ::std::os::raw::c_uint,
        is_xfb: ::std::os::raw::c_uint,
        is_xfb_only: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        explicit_xfb_stride: ::std::os::raw::c_uint,
        explicit_offset: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        from_named_ifc_block: ::std::os::raw::c_uint,
        from_ssbo_unsized_array: ::std::os::raw::c_uint,
        must_be_shader_input: ::std::os::raw::c_uint,
        used: ::std::os::raw::c_uint,
        how_declared: ::std::os::raw::c_uint,
        per_view: ::std::os::raw::c_uint,
        per_primitive: ::std::os::raw::c_uint,
        per_vertex: ::std::os::raw::c_uint,
        aliased_shared_memory: ::std::os::raw::c_uint,
        depth_layout: ::std::os::raw::c_uint,
        stream: ::std::os::raw::c_uint,
        access: ::std::os::raw::c_uint,
        descriptor_set: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_initializer: u32 = unsafe { ::std::mem::transmute(has_initializer) };
            has_initializer as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_implicit_initializer: u32 =
                unsafe { ::std::mem::transmute(is_implicit_initializer) };
            is_implicit_initializer as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_xfb: u32 = unsafe { ::std::mem::transmute(is_xfb) };
            is_xfb as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_xfb_only: u32 = unsafe { ::std::mem::transmute(is_xfb_only) };
            is_xfb_only as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let explicit_xfb_stride: u32 = unsafe { ::std::mem::transmute(explicit_xfb_stride) };
            explicit_xfb_stride as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let explicit_offset: u32 = unsafe { ::std::mem::transmute(explicit_offset) };
            explicit_offset as u64
        });
        __bindgen_bitfield_unit.set(7usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let from_named_ifc_block: u32 = unsafe { ::std::mem::transmute(from_named_ifc_block) };
            from_named_ifc_block as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let from_ssbo_unsized_array: u32 =
                unsafe { ::std::mem::transmute(from_ssbo_unsized_array) };
            from_ssbo_unsized_array as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let must_be_shader_input: u32 = unsafe { ::std::mem::transmute(must_be_shader_input) };
            must_be_shader_input as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let used: u32 = unsafe { ::std::mem::transmute(used) };
            used as u64
        });
        __bindgen_bitfield_unit.set(13usize, 2u8, {
            let how_declared: u32 = unsafe { ::std::mem::transmute(how_declared) };
            how_declared as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let per_view: u32 = unsafe { ::std::mem::transmute(per_view) };
            per_view as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let per_primitive: u32 = unsafe { ::std::mem::transmute(per_primitive) };
            per_primitive as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let per_vertex: u32 = unsafe { ::std::mem::transmute(per_vertex) };
            per_vertex as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let aliased_shared_memory: u32 =
                unsafe { ::std::mem::transmute(aliased_shared_memory) };
            aliased_shared_memory as u64
        });
        __bindgen_bitfield_unit.set(19usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(22usize, 9u8, {
            let stream: u32 = unsafe { ::std::mem::transmute(stream) };
            stream as u64
        });
        __bindgen_bitfield_unit.set(32usize, 9u8, {
            let access: u32 = unsafe { ::std::mem::transmute(access) };
            access as u64
        });
        __bindgen_bitfield_unit.set(41usize, 5u8, {
            let descriptor_set: u32 = unsafe { ::std::mem::transmute(descriptor_set) };
            descriptor_set as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable"][::std::mem::size_of::<nir_variable>() - 168usize];
    ["Alignment of nir_variable"][::std::mem::align_of::<nir_variable>() - 8usize];
    ["Offset of field: nir_variable::node"][::std::mem::offset_of!(nir_variable, node) - 0usize];
    ["Offset of field: nir_variable::type_"][::std::mem::offset_of!(nir_variable, type_) - 16usize];
    ["Offset of field: nir_variable::name"][::std::mem::offset_of!(nir_variable, name) - 24usize];
    ["Offset of field: nir_variable::data"][::std::mem::offset_of!(nir_variable, data) - 32usize];
    ["Offset of field: nir_variable::index"][::std::mem::offset_of!(nir_variable, index) - 88usize];
    ["Offset of field: nir_variable::num_members"]
        [::std::mem::offset_of!(nir_variable, num_members) - 92usize];
    ["Offset of field: nir_variable::max_ifc_array_access"]
        [::std::mem::offset_of!(nir_variable, max_ifc_array_access) - 96usize];
    ["Offset of field: nir_variable::num_state_slots"]
        [::std::mem::offset_of!(nir_variable, num_state_slots) - 104usize];
    ["Offset of field: nir_variable::state_slots"]
        [::std::mem::offset_of!(nir_variable, state_slots) - 112usize];
    ["Offset of field: nir_variable::constant_initializer"]
        [::std::mem::offset_of!(nir_variable, constant_initializer) - 120usize];
    ["Offset of field: nir_variable::pointer_initializer"]
        [::std::mem::offset_of!(nir_variable, pointer_initializer) - 128usize];
    ["Offset of field: nir_variable::interface_type"]
        [::std::mem::offset_of!(nir_variable, interface_type) - 136usize];
    ["Offset of field: nir_variable::members"]
        [::std::mem::offset_of!(nir_variable, members) - 144usize];
    ["Offset of field: nir_variable::_name_storage"]
        [::std::mem::offset_of!(nir_variable, _name_storage) - 152usize];
};
impl Default for nir_variable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_instr_type_alu: nir_instr_type = 0;
pub const nir_instr_type_deref: nir_instr_type = 1;
pub const nir_instr_type_call: nir_instr_type = 2;
pub const nir_instr_type_tex: nir_instr_type = 3;
pub const nir_instr_type_intrinsic: nir_instr_type = 4;
pub const nir_instr_type_load_const: nir_instr_type = 5;
pub const nir_instr_type_jump: nir_instr_type = 6;
pub const nir_instr_type_undef: nir_instr_type = 7;
pub const nir_instr_type_phi: nir_instr_type = 8;
pub const nir_instr_type_parallel_copy: nir_instr_type = 9;
pub type nir_instr_type = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_instr {
    pub node: exec_node,
    pub block: *mut nir_block,
    pub type_: nir_instr_type,
    pub pass_flags: u8,
    pub has_debug_info: bool,
    #[doc = " generic instruction index."]
    pub index: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_instr"][::std::mem::size_of::<nir_instr>() - 32usize];
    ["Alignment of nir_instr"][::std::mem::align_of::<nir_instr>() - 8usize];
    ["Offset of field: nir_instr::node"][::std::mem::offset_of!(nir_instr, node) - 0usize];
    ["Offset of field: nir_instr::block"][::std::mem::offset_of!(nir_instr, block) - 16usize];
    ["Offset of field: nir_instr::type_"][::std::mem::offset_of!(nir_instr, type_) - 24usize];
    ["Offset of field: nir_instr::pass_flags"]
        [::std::mem::offset_of!(nir_instr, pass_flags) - 25usize];
    ["Offset of field: nir_instr::has_debug_info"]
        [::std::mem::offset_of!(nir_instr, has_debug_info) - 26usize];
    ["Offset of field: nir_instr::index"][::std::mem::offset_of!(nir_instr, index) - 28usize];
};
impl Default for nir_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_def {
    #[doc = " Instruction which produces this SSA value."]
    pub parent_instr: *mut nir_instr,
    #[doc = " set of nir_instrs where this register is used (read from)"]
    pub uses: list_head,
    #[doc = " generic SSA definition index."]
    pub index: ::std::os::raw::c_uint,
    pub num_components: u8,
    pub bit_size: u8,
    #[doc = " True if this SSA value may have different values in different SIMD\n invocations of the shader.  This is set by nir_divergence_analysis."]
    pub divergent: bool,
    #[doc = " True if this SSA value is loop invariant w.r.t. the innermost parent\n loop.  This is set by nir_divergence_analysis and used to determine\n the divergence of a nir_src."]
    pub loop_invariant: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_def"][::std::mem::size_of::<nir_def>() - 32usize];
    ["Alignment of nir_def"][::std::mem::align_of::<nir_def>() - 8usize];
    ["Offset of field: nir_def::parent_instr"]
        [::std::mem::offset_of!(nir_def, parent_instr) - 0usize];
    ["Offset of field: nir_def::uses"][::std::mem::offset_of!(nir_def, uses) - 8usize];
    ["Offset of field: nir_def::index"][::std::mem::offset_of!(nir_def, index) - 24usize];
    ["Offset of field: nir_def::num_components"]
        [::std::mem::offset_of!(nir_def, num_components) - 28usize];
    ["Offset of field: nir_def::bit_size"][::std::mem::offset_of!(nir_def, bit_size) - 29usize];
    ["Offset of field: nir_def::divergent"][::std::mem::offset_of!(nir_def, divergent) - 30usize];
    ["Offset of field: nir_def::loop_invariant"]
        [::std::mem::offset_of!(nir_def, loop_invariant) - 31usize];
};
impl Default for nir_def {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_src {
    pub _parent: usize,
    pub use_link: list_head,
    pub ssa: *mut nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_src"][::std::mem::size_of::<nir_src>() - 32usize];
    ["Alignment of nir_src"][::std::mem::align_of::<nir_src>() - 8usize];
    ["Offset of field: nir_src::_parent"][::std::mem::offset_of!(nir_src, _parent) - 0usize];
    ["Offset of field: nir_src::use_link"][::std::mem::offset_of!(nir_src, use_link) - 8usize];
    ["Offset of field: nir_src::ssa"][::std::mem::offset_of!(nir_src, ssa) - 24usize];
};
impl Default for nir_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_src_is_divergent(src: *mut nir_src) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_alu_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " For each input component, says which component of the register it is\n chosen from.\n\n Note that which elements of the swizzle are used and which are ignored\n are based on the write mask for most opcodes - for example, a statement\n like \"foo.xzw = bar.zyx\" would have a writemask of 1101b and a swizzle\n of {2, 1, x, 0} where x means \"don't care.\""]
    pub swizzle: [u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_alu_src"][::std::mem::size_of::<nir_alu_src>() - 48usize];
    ["Alignment of nir_alu_src"][::std::mem::align_of::<nir_alu_src>() - 8usize];
    ["Offset of field: nir_alu_src::src"][::std::mem::offset_of!(nir_alu_src, src) - 0usize];
    ["Offset of field: nir_alu_src::swizzle"]
        [::std::mem::offset_of!(nir_alu_src, swizzle) - 32usize];
};
impl Default for nir_alu_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_get_nir_type_for_glsl_base_type(base_type: glsl_base_type) -> nir_alu_type;
}
unsafe extern "C" {
    pub fn nir_get_glsl_base_type_for_nir_type(base_type: nir_alu_type) -> glsl_base_type;
}
unsafe extern "C" {
    pub fn nir_type_conversion_op(
        src: nir_alu_type,
        dst: nir_alu_type,
        rnd: nir_rounding_mode,
    ) -> nir_op;
}
pub const nir_atomic_op_iadd: nir_atomic_op = 0;
pub const nir_atomic_op_isub: nir_atomic_op = 1;
pub const nir_atomic_op_imin: nir_atomic_op = 2;
pub const nir_atomic_op_umin: nir_atomic_op = 3;
pub const nir_atomic_op_imax: nir_atomic_op = 4;
pub const nir_atomic_op_umax: nir_atomic_op = 5;
pub const nir_atomic_op_iand: nir_atomic_op = 6;
pub const nir_atomic_op_ior: nir_atomic_op = 7;
pub const nir_atomic_op_ixor: nir_atomic_op = 8;
pub const nir_atomic_op_xchg: nir_atomic_op = 9;
pub const nir_atomic_op_fadd: nir_atomic_op = 10;
pub const nir_atomic_op_fmin: nir_atomic_op = 11;
pub const nir_atomic_op_fmax: nir_atomic_op = 12;
pub const nir_atomic_op_cmpxchg: nir_atomic_op = 13;
pub const nir_atomic_op_fcmpxchg: nir_atomic_op = 14;
pub const nir_atomic_op_inc_wrap: nir_atomic_op = 15;
pub const nir_atomic_op_dec_wrap: nir_atomic_op = 16;
pub const nir_atomic_op_ordered_add_gfx12_amd: nir_atomic_op = 17;
#[doc = " Atomic intrinsics perform different operations depending on the value of\n their atomic_op constant index. nir_atomic_op defines the operations."]
pub type nir_atomic_op = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_atomic_op_to_alu(op: nir_atomic_op) -> nir_op;
}
unsafe extern "C" {
    #[doc = " Returns nir_op_vec<num_components> or nir_op_mov if num_components == 1\n\n This is subtly different from nir_op_is_vec() which returns false for\n nir_op_mov.  Returning nir_op_mov from nir_op_vec() when num_components == 1\n makes sense under the assumption that the num_components of the resulting\n nir_def will same as what is passed in here because a single-component mov\n is effectively a vec1.  However, if alu->def.num_components > 1, nir_op_mov\n has different semantics from nir_op_vec* so so code which detects \"is this\n a vec?\" typically needs to handle nir_op_mov separate from nir_op_vecN.\n\n In the unlikely case where you can handle nir_op_vecN and nir_op_mov\n together, use nir_op_is_vec_or_mov()."]
    pub fn nir_op_vec(num_components: ::std::os::raw::c_uint) -> nir_op;
}
unsafe extern "C" {
    #[doc = " Returns true if this op is one of nir_op_vec*\n\n Returns false for nir_op_mov.  See nir_op_vec() for more details."]
    pub fn nir_op_is_vec(op: nir_op) -> bool;
}
#[doc = " Operation where the first two sources are commutative.\n\n For 2-source operations, this just mathematical commutativity.  Some\n 3-source operations, like ffma, are only commutative in the first two\n sources."]
pub const NIR_OP_IS_2SRC_COMMUTATIVE: nir_op_algebraic_property = 1;
#[doc = " Operation is associative"]
pub const NIR_OP_IS_ASSOCIATIVE: nir_op_algebraic_property = 2;
#[doc = " Operation where src[0] is used to select src[1] on true or src[2] false.\n src[0] may be Boolean, or it may be another type used in an implicit\n comparison."]
pub const NIR_OP_IS_SELECTION: nir_op_algebraic_property = 4;
#[doc = " Operation is associative mathematically (as real numbers), but not\n associative with floating-point math. This can be treated as associative\n iff the operation's exact bit is not set."]
pub const NIR_OP_IS_INEXACT_ASSOCIATIVE: nir_op_algebraic_property = 8;
pub type nir_op_algebraic_property = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_op_info {
    #[doc = " Name of the NIR ALU opcode"]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Number of inputs (sources)"]
    pub num_inputs: u8,
    #[doc = " The number of components in the output\n\n If non-zero, this is the size of the output and input sizes are\n explicitly given; swizzle and writemask are still in effect, but if\n the output component is masked out, then the input component may\n still be in use.\n\n If zero, the opcode acts in the standard, per-component manner; the\n operation is performed on each component (except the ones that are\n masked out) with the input being taken from the input swizzle for\n that component.\n\n The size of some of the inputs may be given (i.e. non-zero) even\n though output_size is zero; in that case, the inputs with a zero\n size act per-component, while the inputs with non-zero size don't."]
    pub output_size: u8,
    #[doc = " The type of vector that the instruction outputs."]
    pub output_type: nir_alu_type,
    #[doc = " The number of components in each input\n\n See nir_op_infos::output_size for more detail about the relationship\n between input and output sizes."]
    pub input_sizes: [u8; 16usize],
    #[doc = " The type of vector that each input takes."]
    pub input_types: [nir_alu_type; 16usize],
    #[doc = " Algebraic properties of this opcode"]
    pub algebraic_properties: nir_op_algebraic_property,
    #[doc = " Whether this represents a numeric conversion opcode"]
    pub is_conversion: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_op_info"][::std::mem::size_of::<nir_op_info>() - 56usize];
    ["Alignment of nir_op_info"][::std::mem::align_of::<nir_op_info>() - 8usize];
    ["Offset of field: nir_op_info::name"][::std::mem::offset_of!(nir_op_info, name) - 0usize];
    ["Offset of field: nir_op_info::num_inputs"]
        [::std::mem::offset_of!(nir_op_info, num_inputs) - 8usize];
    ["Offset of field: nir_op_info::output_size"]
        [::std::mem::offset_of!(nir_op_info, output_size) - 9usize];
    ["Offset of field: nir_op_info::output_type"]
        [::std::mem::offset_of!(nir_op_info, output_type) - 10usize];
    ["Offset of field: nir_op_info::input_sizes"]
        [::std::mem::offset_of!(nir_op_info, input_sizes) - 11usize];
    ["Offset of field: nir_op_info::input_types"]
        [::std::mem::offset_of!(nir_op_info, input_types) - 27usize];
    ["Offset of field: nir_op_info::algebraic_properties"]
        [::std::mem::offset_of!(nir_op_info, algebraic_properties) - 44usize];
    ["Offset of field: nir_op_info::is_conversion"]
        [::std::mem::offset_of!(nir_op_info, is_conversion) - 48usize];
};
impl Default for nir_op_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Metadata for each nir_op, indexed by opcode"]
    pub static nir_op_infos: [nir_op_info; 501usize];
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_alu_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Opcode"]
    pub op: nir_op,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Sources\n\n The size of the array is given by :c:member:`nir_op_info.num_inputs`."]
    pub src: __IncompleteArrayField<nir_alu_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_alu_instr"][::std::mem::size_of::<nir_alu_instr>() - 72usize];
    ["Alignment of nir_alu_instr"][::std::mem::align_of::<nir_alu_instr>() - 8usize];
    ["Offset of field: nir_alu_instr::instr"]
        [::std::mem::offset_of!(nir_alu_instr, instr) - 0usize];
    ["Offset of field: nir_alu_instr::op"][::std::mem::offset_of!(nir_alu_instr, op) - 32usize];
    ["Offset of field: nir_alu_instr::def"][::std::mem::offset_of!(nir_alu_instr, def) - 40usize];
    ["Offset of field: nir_alu_instr::src"][::std::mem::offset_of!(nir_alu_instr, src) - 72usize];
};
impl Default for nir_alu_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_alu_instr {
    #[inline]
    pub fn exact(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_exact(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn exact_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_exact_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_signed_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_signed_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_signed_wrap_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_no_signed_wrap_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_unsigned_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_unsigned_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_unsigned_wrap_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_no_unsigned_wrap_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fp_fast_math(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_fp_fast_math(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fp_fast_math_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fp_fast_math_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        exact: bool,
        no_signed_wrap: bool,
        no_unsigned_wrap: bool,
        fp_fast_math: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let exact: u8 = unsafe { ::std::mem::transmute(exact) };
            exact as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let no_signed_wrap: u8 = unsafe { ::std::mem::transmute(no_signed_wrap) };
            no_signed_wrap as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_unsigned_wrap: u8 = unsafe { ::std::mem::transmute(no_unsigned_wrap) };
            no_unsigned_wrap as u64
        });
        __bindgen_bitfield_unit.set(3usize, 9u8, {
            let fp_fast_math: u32 = unsafe { ::std::mem::transmute(fp_fast_math) };
            fp_fast_math as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_alu_src_copy(dest: *mut nir_alu_src, src: *const nir_alu_src);
}
unsafe extern "C" {
    pub fn nir_alu_instr_src_read_mask(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
unsafe extern "C" {
    #[doc = " Get the number of channels used for a source"]
    pub fn nir_ssa_alu_instr_src_components(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_alu_instr_is_comparison(instr: *const nir_alu_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_const_value_negative_equal(
        c1: nir_const_value,
        c2: nir_const_value,
        full_type: nir_alu_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_negative_equal_typed(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
        base_type: nir_alu_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_negative_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_src_is_trivial_ssa(
        alu: *const nir_alu_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> bool;
}
pub const nir_deref_type_var: nir_deref_type = 0;
pub const nir_deref_type_array: nir_deref_type = 1;
pub const nir_deref_type_array_wildcard: nir_deref_type = 2;
pub const nir_deref_type_ptr_as_array: nir_deref_type = 3;
pub const nir_deref_type_struct: nir_deref_type = 4;
pub const nir_deref_type_cast: nir_deref_type = 5;
pub type nir_deref_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_deref_instr {
    pub instr: nir_instr,
    #[doc = " The type of this deref instruction"]
    pub deref_type: nir_deref_type,
    #[doc = " Bitmask what modes the underlying variable might be\n\n For OpenCL-style generic pointers, we may not know exactly what mode it\n is at any given point in time in the compile process.  This bitfield\n contains the set of modes which it MAY be.\n\n Generally, this field should not be accessed directly.  Use one of the\n nir_deref_mode_ helpers instead."]
    pub modes: nir_variable_mode,
    #[doc = " The dereferenced type of the resulting pointer value"]
    pub type_: *const glsl_type,
    pub __bindgen_anon_1: nir_deref_instr__bindgen_ty_1,
    pub __bindgen_anon_2: nir_deref_instr__bindgen_ty_2,
    #[doc = " Destination to store the resulting \"pointer\""]
    pub def: nir_def,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_1 {
    #[doc = " Variable being dereferenced if deref_type is a deref_var"]
    pub var: *mut nir_variable,
    #[doc = " Parent deref if deref_type is not deref_var"]
    pub parent: nir_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_1"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_1>() - 32usize];
    ["Alignment of nir_deref_instr__bindgen_ty_1"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_1>() - 8usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_1::var"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_1, var) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_1::parent"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_1, parent) - 0usize];
};
impl Default for nir_deref_instr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Additional deref parameters"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_2 {
    pub arr: nir_deref_instr__bindgen_ty_2__bindgen_ty_1,
    pub strct: nir_deref_instr__bindgen_ty_2__bindgen_ty_2,
    pub cast: nir_deref_instr__bindgen_ty_2__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    pub index: nir_src,
    pub in_bounds: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>() - 40usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>() - 8usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_1::index"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1, index) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_1::in_bounds"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1, in_bounds) - 32usize];
};
impl Default for nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_2 {
    pub index: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>() - 4usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_2::index"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_2, index) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_3 {
    pub ptr_stride: ::std::os::raw::c_uint,
    pub align_mul: ::std::os::raw::c_uint,
    pub align_offset: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_3"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>() - 12usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_3"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::ptr_stride"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3, ptr_stride) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::align_mul"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3, align_mul) - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::align_offset"][::std::mem::offset_of!(
        nir_deref_instr__bindgen_ty_2__bindgen_ty_3,
        align_offset
    ) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2>() - 40usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2>() - 8usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::arr"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, arr) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::strct"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, strct) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::cast"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, cast) - 0usize];
};
impl Default for nir_deref_instr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr"][::std::mem::size_of::<nir_deref_instr>() - 152usize];
    ["Alignment of nir_deref_instr"][::std::mem::align_of::<nir_deref_instr>() - 8usize];
    ["Offset of field: nir_deref_instr::instr"]
        [::std::mem::offset_of!(nir_deref_instr, instr) - 0usize];
    ["Offset of field: nir_deref_instr::deref_type"]
        [::std::mem::offset_of!(nir_deref_instr, deref_type) - 32usize];
    ["Offset of field: nir_deref_instr::modes"]
        [::std::mem::offset_of!(nir_deref_instr, modes) - 36usize];
    ["Offset of field: nir_deref_instr::type_"]
        [::std::mem::offset_of!(nir_deref_instr, type_) - 40usize];
    ["Offset of field: nir_deref_instr::def"]
        [::std::mem::offset_of!(nir_deref_instr, def) - 120usize];
};
impl Default for nir_deref_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Returns true if the cast is trivial, i.e. the source and destination type is\n the same."]
    pub fn nir_deref_cast_is_trivial(cast: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_has_indirect(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_is_known_out_of_bounds(instr: *mut nir_deref_instr) -> bool;
}
pub const nir_deref_instr_has_complex_use_allow_memcpy_src:
    nir_deref_instr_has_complex_use_options = 1;
pub const nir_deref_instr_has_complex_use_allow_memcpy_dst:
    nir_deref_instr_has_complex_use_options = 2;
pub const nir_deref_instr_has_complex_use_allow_atomics: nir_deref_instr_has_complex_use_options =
    4;
pub type nir_deref_instr_has_complex_use_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_deref_instr_has_complex_use(
        instr: *mut nir_deref_instr,
        opts: nir_deref_instr_has_complex_use_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_remove_if_unused(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_array_stride(instr: *mut nir_deref_instr) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_call_instr {
    pub instr: nir_instr,
    pub callee: *mut nir_function,
    pub indirect_callee: nir_src,
    pub num_params: ::std::os::raw::c_uint,
    pub params: __IncompleteArrayField<nir_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_call_instr"][::std::mem::size_of::<nir_call_instr>() - 80usize];
    ["Alignment of nir_call_instr"][::std::mem::align_of::<nir_call_instr>() - 8usize];
    ["Offset of field: nir_call_instr::instr"]
        [::std::mem::offset_of!(nir_call_instr, instr) - 0usize];
    ["Offset of field: nir_call_instr::callee"]
        [::std::mem::offset_of!(nir_call_instr, callee) - 32usize];
    ["Offset of field: nir_call_instr::indirect_callee"]
        [::std::mem::offset_of!(nir_call_instr, indirect_callee) - 40usize];
    ["Offset of field: nir_call_instr::num_params"]
        [::std::mem::offset_of!(nir_call_instr, num_params) - 72usize];
    ["Offset of field: nir_call_instr::params"]
        [::std::mem::offset_of!(nir_call_instr, params) - 80usize];
};
impl Default for nir_call_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_intrinsic_accept_ray_intersection: nir_intrinsic_op = 0;
pub const nir_intrinsic_addr_mode_is: nir_intrinsic_op = 1;
pub const nir_intrinsic_al2p_nv: nir_intrinsic_op = 2;
pub const nir_intrinsic_ald_nv: nir_intrinsic_op = 3;
pub const nir_intrinsic_alpha_to_coverage: nir_intrinsic_op = 4;
pub const nir_intrinsic_alphatst_pco: nir_intrinsic_op = 5;
pub const nir_intrinsic_as_uniform: nir_intrinsic_op = 6;
pub const nir_intrinsic_ast_nv: nir_intrinsic_op = 7;
pub const nir_intrinsic_atomic_add_gen_prim_count_amd: nir_intrinsic_op = 8;
pub const nir_intrinsic_atomic_add_gs_emit_prim_count_amd: nir_intrinsic_op = 9;
pub const nir_intrinsic_atomic_add_shader_invocation_count_amd: nir_intrinsic_op = 10;
pub const nir_intrinsic_atomic_add_xfb_prim_count_amd: nir_intrinsic_op = 11;
pub const nir_intrinsic_atomic_counter_add: nir_intrinsic_op = 12;
pub const nir_intrinsic_atomic_counter_add_deref: nir_intrinsic_op = 13;
pub const nir_intrinsic_atomic_counter_and: nir_intrinsic_op = 14;
pub const nir_intrinsic_atomic_counter_and_deref: nir_intrinsic_op = 15;
pub const nir_intrinsic_atomic_counter_comp_swap: nir_intrinsic_op = 16;
pub const nir_intrinsic_atomic_counter_comp_swap_deref: nir_intrinsic_op = 17;
pub const nir_intrinsic_atomic_counter_exchange: nir_intrinsic_op = 18;
pub const nir_intrinsic_atomic_counter_exchange_deref: nir_intrinsic_op = 19;
pub const nir_intrinsic_atomic_counter_inc: nir_intrinsic_op = 20;
pub const nir_intrinsic_atomic_counter_inc_deref: nir_intrinsic_op = 21;
pub const nir_intrinsic_atomic_counter_max: nir_intrinsic_op = 22;
pub const nir_intrinsic_atomic_counter_max_deref: nir_intrinsic_op = 23;
pub const nir_intrinsic_atomic_counter_min: nir_intrinsic_op = 24;
pub const nir_intrinsic_atomic_counter_min_deref: nir_intrinsic_op = 25;
pub const nir_intrinsic_atomic_counter_or: nir_intrinsic_op = 26;
pub const nir_intrinsic_atomic_counter_or_deref: nir_intrinsic_op = 27;
pub const nir_intrinsic_atomic_counter_post_dec: nir_intrinsic_op = 28;
pub const nir_intrinsic_atomic_counter_post_dec_deref: nir_intrinsic_op = 29;
pub const nir_intrinsic_atomic_counter_pre_dec: nir_intrinsic_op = 30;
pub const nir_intrinsic_atomic_counter_pre_dec_deref: nir_intrinsic_op = 31;
pub const nir_intrinsic_atomic_counter_read: nir_intrinsic_op = 32;
pub const nir_intrinsic_atomic_counter_read_deref: nir_intrinsic_op = 33;
pub const nir_intrinsic_atomic_counter_xor: nir_intrinsic_op = 34;
pub const nir_intrinsic_atomic_counter_xor_deref: nir_intrinsic_op = 35;
pub const nir_intrinsic_ballot: nir_intrinsic_op = 36;
pub const nir_intrinsic_ballot_bit_count_exclusive: nir_intrinsic_op = 37;
pub const nir_intrinsic_ballot_bit_count_inclusive: nir_intrinsic_op = 38;
pub const nir_intrinsic_ballot_bit_count_reduce: nir_intrinsic_op = 39;
pub const nir_intrinsic_ballot_bitfield_extract: nir_intrinsic_op = 40;
pub const nir_intrinsic_ballot_find_lsb: nir_intrinsic_op = 41;
pub const nir_intrinsic_ballot_find_msb: nir_intrinsic_op = 42;
pub const nir_intrinsic_ballot_relaxed: nir_intrinsic_op = 43;
pub const nir_intrinsic_bar_break_nv: nir_intrinsic_op = 44;
pub const nir_intrinsic_bar_set_nv: nir_intrinsic_op = 45;
pub const nir_intrinsic_bar_sync_nv: nir_intrinsic_op = 46;
pub const nir_intrinsic_barrier: nir_intrinsic_op = 47;
pub const nir_intrinsic_begin_invocation_interlock: nir_intrinsic_op = 48;
pub const nir_intrinsic_bindgen_return: nir_intrinsic_op = 49;
pub const nir_intrinsic_bindless_image_agx: nir_intrinsic_op = 50;
pub const nir_intrinsic_bindless_image_atomic: nir_intrinsic_op = 51;
pub const nir_intrinsic_bindless_image_atomic_swap: nir_intrinsic_op = 52;
pub const nir_intrinsic_bindless_image_descriptor_amd: nir_intrinsic_op = 53;
pub const nir_intrinsic_bindless_image_format: nir_intrinsic_op = 54;
pub const nir_intrinsic_bindless_image_fragment_mask_load_amd: nir_intrinsic_op = 55;
pub const nir_intrinsic_bindless_image_levels: nir_intrinsic_op = 56;
pub const nir_intrinsic_bindless_image_load: nir_intrinsic_op = 57;
pub const nir_intrinsic_bindless_image_load_raw_intel: nir_intrinsic_op = 58;
pub const nir_intrinsic_bindless_image_order: nir_intrinsic_op = 59;
pub const nir_intrinsic_bindless_image_samples: nir_intrinsic_op = 60;
pub const nir_intrinsic_bindless_image_samples_identical: nir_intrinsic_op = 61;
pub const nir_intrinsic_bindless_image_size: nir_intrinsic_op = 62;
pub const nir_intrinsic_bindless_image_sparse_load: nir_intrinsic_op = 63;
pub const nir_intrinsic_bindless_image_store: nir_intrinsic_op = 64;
pub const nir_intrinsic_bindless_image_store_block_agx: nir_intrinsic_op = 65;
pub const nir_intrinsic_bindless_image_store_raw_intel: nir_intrinsic_op = 66;
pub const nir_intrinsic_bindless_image_texel_address: nir_intrinsic_op = 67;
pub const nir_intrinsic_bindless_resource_ir3: nir_intrinsic_op = 68;
pub const nir_intrinsic_bindless_sampler_agx: nir_intrinsic_op = 69;
pub const nir_intrinsic_brcst_active_ir3: nir_intrinsic_op = 70;
pub const nir_intrinsic_btd_retire_intel: nir_intrinsic_op = 71;
pub const nir_intrinsic_btd_spawn_intel: nir_intrinsic_op = 72;
pub const nir_intrinsic_btd_stack_push_intel: nir_intrinsic_op = 73;
pub const nir_intrinsic_bvh64_intersect_ray_amd: nir_intrinsic_op = 74;
pub const nir_intrinsic_bvh8_intersect_ray_amd: nir_intrinsic_op = 75;
pub const nir_intrinsic_bvh_stack_rtn_amd: nir_intrinsic_op = 76;
pub const nir_intrinsic_cmat_binary_op: nir_intrinsic_op = 77;
pub const nir_intrinsic_cmat_bitcast: nir_intrinsic_op = 78;
pub const nir_intrinsic_cmat_construct: nir_intrinsic_op = 79;
pub const nir_intrinsic_cmat_convert: nir_intrinsic_op = 80;
pub const nir_intrinsic_cmat_copy: nir_intrinsic_op = 81;
pub const nir_intrinsic_cmat_extract: nir_intrinsic_op = 82;
pub const nir_intrinsic_cmat_insert: nir_intrinsic_op = 83;
pub const nir_intrinsic_cmat_length: nir_intrinsic_op = 84;
pub const nir_intrinsic_cmat_load: nir_intrinsic_op = 85;
pub const nir_intrinsic_cmat_load_shared_nv: nir_intrinsic_op = 86;
pub const nir_intrinsic_cmat_muladd: nir_intrinsic_op = 87;
pub const nir_intrinsic_cmat_muladd_amd: nir_intrinsic_op = 88;
pub const nir_intrinsic_cmat_muladd_nv: nir_intrinsic_op = 89;
pub const nir_intrinsic_cmat_scalar_op: nir_intrinsic_op = 90;
pub const nir_intrinsic_cmat_store: nir_intrinsic_op = 91;
pub const nir_intrinsic_cmat_transpose: nir_intrinsic_op = 92;
pub const nir_intrinsic_cmat_unary_op: nir_intrinsic_op = 93;
pub const nir_intrinsic_convert_alu_types: nir_intrinsic_op = 94;
pub const nir_intrinsic_convert_cmat_intel: nir_intrinsic_op = 95;
pub const nir_intrinsic_copy_deref: nir_intrinsic_op = 96;
pub const nir_intrinsic_copy_fs_outputs_nv: nir_intrinsic_op = 97;
pub const nir_intrinsic_copy_global_to_uniform_ir3: nir_intrinsic_op = 98;
pub const nir_intrinsic_copy_push_const_to_uniform_ir3: nir_intrinsic_op = 99;
pub const nir_intrinsic_copy_ubo_to_uniform_ir3: nir_intrinsic_op = 100;
pub const nir_intrinsic_ddx: nir_intrinsic_op = 101;
pub const nir_intrinsic_ddx_coarse: nir_intrinsic_op = 102;
pub const nir_intrinsic_ddx_fine: nir_intrinsic_op = 103;
pub const nir_intrinsic_ddy: nir_intrinsic_op = 104;
pub const nir_intrinsic_ddy_coarse: nir_intrinsic_op = 105;
pub const nir_intrinsic_ddy_fine: nir_intrinsic_op = 106;
pub const nir_intrinsic_debug_break: nir_intrinsic_op = 107;
pub const nir_intrinsic_decl_reg: nir_intrinsic_op = 108;
pub const nir_intrinsic_demote: nir_intrinsic_op = 109;
pub const nir_intrinsic_demote_if: nir_intrinsic_op = 110;
pub const nir_intrinsic_demote_samples: nir_intrinsic_op = 111;
pub const nir_intrinsic_deref_atomic: nir_intrinsic_op = 112;
pub const nir_intrinsic_deref_atomic_swap: nir_intrinsic_op = 113;
pub const nir_intrinsic_deref_buffer_array_length: nir_intrinsic_op = 114;
pub const nir_intrinsic_deref_implicit_array_length: nir_intrinsic_op = 115;
pub const nir_intrinsic_deref_mode_is: nir_intrinsic_op = 116;
pub const nir_intrinsic_deref_texture_src: nir_intrinsic_op = 117;
pub const nir_intrinsic_dma_ld_pco: nir_intrinsic_op = 118;
pub const nir_intrinsic_dma_ld_shregs_pco: nir_intrinsic_op = 119;
pub const nir_intrinsic_dma_st_pco: nir_intrinsic_op = 120;
pub const nir_intrinsic_dma_st_shregs_pco: nir_intrinsic_op = 121;
pub const nir_intrinsic_dma_st_tiled_pco: nir_intrinsic_op = 122;
pub const nir_intrinsic_doorbell_agx: nir_intrinsic_op = 123;
pub const nir_intrinsic_dpas_intel: nir_intrinsic_op = 124;
pub const nir_intrinsic_dpp16_shift_amd: nir_intrinsic_op = 125;
pub const nir_intrinsic_dummy_load_store_pco: nir_intrinsic_op = 126;
pub const nir_intrinsic_elect: nir_intrinsic_op = 127;
pub const nir_intrinsic_elect_any_ir3: nir_intrinsic_op = 128;
pub const nir_intrinsic_emit_primitive_poly: nir_intrinsic_op = 129;
pub const nir_intrinsic_emit_vertex: nir_intrinsic_op = 130;
pub const nir_intrinsic_emit_vertex_nv: nir_intrinsic_op = 131;
pub const nir_intrinsic_emit_vertex_with_counter: nir_intrinsic_op = 132;
pub const nir_intrinsic_emitpix_pco: nir_intrinsic_op = 133;
pub const nir_intrinsic_end_invocation_interlock: nir_intrinsic_op = 134;
pub const nir_intrinsic_end_primitive: nir_intrinsic_op = 135;
pub const nir_intrinsic_end_primitive_nv: nir_intrinsic_op = 136;
pub const nir_intrinsic_end_primitive_with_counter: nir_intrinsic_op = 137;
pub const nir_intrinsic_enqueue_node_payloads: nir_intrinsic_op = 138;
pub const nir_intrinsic_exclusive_scan: nir_intrinsic_op = 139;
pub const nir_intrinsic_exclusive_scan_clusters_ir3: nir_intrinsic_op = 140;
pub const nir_intrinsic_execute_callable: nir_intrinsic_op = 141;
pub const nir_intrinsic_execute_closest_hit_amd: nir_intrinsic_op = 142;
pub const nir_intrinsic_execute_miss_amd: nir_intrinsic_op = 143;
pub const nir_intrinsic_export_agx: nir_intrinsic_op = 144;
pub const nir_intrinsic_export_amd: nir_intrinsic_op = 145;
pub const nir_intrinsic_export_dual_src_blend_amd: nir_intrinsic_op = 146;
pub const nir_intrinsic_export_row_amd: nir_intrinsic_op = 147;
pub const nir_intrinsic_fence_helper_exit_agx: nir_intrinsic_op = 148;
pub const nir_intrinsic_fence_mem_to_tex_agx: nir_intrinsic_op = 149;
pub const nir_intrinsic_fence_pbe_to_tex_agx: nir_intrinsic_op = 150;
pub const nir_intrinsic_fence_pbe_to_tex_pixel_agx: nir_intrinsic_op = 151;
pub const nir_intrinsic_final_primitive_nv: nir_intrinsic_op = 152;
pub const nir_intrinsic_finalize_incoming_node_payload: nir_intrinsic_op = 153;
pub const nir_intrinsic_first_invocation: nir_intrinsic_op = 154;
pub const nir_intrinsic_flush_tile_buffer_pco: nir_intrinsic_op = 155;
pub const nir_intrinsic_frag_store_pco: nir_intrinsic_op = 156;
pub const nir_intrinsic_fs_out_nv: nir_intrinsic_op = 157;
pub const nir_intrinsic_gds_atomic_add_amd: nir_intrinsic_op = 158;
pub const nir_intrinsic_get_ssbo_size: nir_intrinsic_op = 159;
pub const nir_intrinsic_get_ubo_size: nir_intrinsic_op = 160;
pub const nir_intrinsic_global_atomic: nir_intrinsic_op = 161;
pub const nir_intrinsic_global_atomic_2x32: nir_intrinsic_op = 162;
pub const nir_intrinsic_global_atomic_agx: nir_intrinsic_op = 163;
pub const nir_intrinsic_global_atomic_amd: nir_intrinsic_op = 164;
pub const nir_intrinsic_global_atomic_pco: nir_intrinsic_op = 165;
pub const nir_intrinsic_global_atomic_swap: nir_intrinsic_op = 166;
pub const nir_intrinsic_global_atomic_swap_2x32: nir_intrinsic_op = 167;
pub const nir_intrinsic_global_atomic_swap_agx: nir_intrinsic_op = 168;
pub const nir_intrinsic_global_atomic_swap_amd: nir_intrinsic_op = 169;
pub const nir_intrinsic_global_atomic_swap_pco: nir_intrinsic_op = 170;
pub const nir_intrinsic_ignore_ray_intersection: nir_intrinsic_op = 171;
pub const nir_intrinsic_imadsp_nv: nir_intrinsic_op = 172;
pub const nir_intrinsic_image_atomic: nir_intrinsic_op = 173;
pub const nir_intrinsic_image_atomic_swap: nir_intrinsic_op = 174;
pub const nir_intrinsic_image_deref_atomic: nir_intrinsic_op = 175;
pub const nir_intrinsic_image_deref_atomic_swap: nir_intrinsic_op = 176;
pub const nir_intrinsic_image_deref_descriptor_amd: nir_intrinsic_op = 177;
pub const nir_intrinsic_image_deref_format: nir_intrinsic_op = 178;
pub const nir_intrinsic_image_deref_fragment_mask_load_amd: nir_intrinsic_op = 179;
pub const nir_intrinsic_image_deref_levels: nir_intrinsic_op = 180;
pub const nir_intrinsic_image_deref_load: nir_intrinsic_op = 181;
pub const nir_intrinsic_image_deref_load_info_nv: nir_intrinsic_op = 182;
pub const nir_intrinsic_image_deref_load_param_intel: nir_intrinsic_op = 183;
pub const nir_intrinsic_image_deref_load_raw_intel: nir_intrinsic_op = 184;
pub const nir_intrinsic_image_deref_order: nir_intrinsic_op = 185;
pub const nir_intrinsic_image_deref_samples: nir_intrinsic_op = 186;
pub const nir_intrinsic_image_deref_samples_identical: nir_intrinsic_op = 187;
pub const nir_intrinsic_image_deref_size: nir_intrinsic_op = 188;
pub const nir_intrinsic_image_deref_sparse_load: nir_intrinsic_op = 189;
pub const nir_intrinsic_image_deref_store: nir_intrinsic_op = 190;
pub const nir_intrinsic_image_deref_store_block_agx: nir_intrinsic_op = 191;
pub const nir_intrinsic_image_deref_store_raw_intel: nir_intrinsic_op = 192;
pub const nir_intrinsic_image_deref_texel_address: nir_intrinsic_op = 193;
pub const nir_intrinsic_image_descriptor_amd: nir_intrinsic_op = 194;
pub const nir_intrinsic_image_format: nir_intrinsic_op = 195;
pub const nir_intrinsic_image_fragment_mask_load_amd: nir_intrinsic_op = 196;
pub const nir_intrinsic_image_levels: nir_intrinsic_op = 197;
pub const nir_intrinsic_image_load: nir_intrinsic_op = 198;
pub const nir_intrinsic_image_load_raw_intel: nir_intrinsic_op = 199;
pub const nir_intrinsic_image_order: nir_intrinsic_op = 200;
pub const nir_intrinsic_image_samples: nir_intrinsic_op = 201;
pub const nir_intrinsic_image_samples_identical: nir_intrinsic_op = 202;
pub const nir_intrinsic_image_size: nir_intrinsic_op = 203;
pub const nir_intrinsic_image_sparse_load: nir_intrinsic_op = 204;
pub const nir_intrinsic_image_store: nir_intrinsic_op = 205;
pub const nir_intrinsic_image_store_block_agx: nir_intrinsic_op = 206;
pub const nir_intrinsic_image_store_raw_intel: nir_intrinsic_op = 207;
pub const nir_intrinsic_image_texel_address: nir_intrinsic_op = 208;
pub const nir_intrinsic_inclusive_scan: nir_intrinsic_op = 209;
pub const nir_intrinsic_inclusive_scan_clusters_ir3: nir_intrinsic_op = 210;
pub const nir_intrinsic_initialize_node_payloads: nir_intrinsic_op = 211;
pub const nir_intrinsic_interp_deref_at_centroid: nir_intrinsic_op = 212;
pub const nir_intrinsic_interp_deref_at_offset: nir_intrinsic_op = 213;
pub const nir_intrinsic_interp_deref_at_sample: nir_intrinsic_op = 214;
pub const nir_intrinsic_interp_deref_at_vertex: nir_intrinsic_op = 215;
pub const nir_intrinsic_inverse_ballot: nir_intrinsic_op = 216;
pub const nir_intrinsic_ipa_nv: nir_intrinsic_op = 217;
pub const nir_intrinsic_is_helper_invocation: nir_intrinsic_op = 218;
pub const nir_intrinsic_is_null_descriptor: nir_intrinsic_op = 219;
pub const nir_intrinsic_is_sparse_resident_zink: nir_intrinsic_op = 220;
pub const nir_intrinsic_is_sparse_texels_resident: nir_intrinsic_op = 221;
pub const nir_intrinsic_is_subgroup_invocation_lt_amd: nir_intrinsic_op = 222;
pub const nir_intrinsic_isberd_nv: nir_intrinsic_op = 223;
pub const nir_intrinsic_isp_feedback_pco: nir_intrinsic_op = 224;
pub const nir_intrinsic_lane_permute_16_amd: nir_intrinsic_op = 225;
pub const nir_intrinsic_last_invocation: nir_intrinsic_op = 226;
pub const nir_intrinsic_launch_mesh_workgroups: nir_intrinsic_op = 227;
pub const nir_intrinsic_launch_mesh_workgroups_with_payload_deref: nir_intrinsic_op = 228;
pub const nir_intrinsic_ldc_nv: nir_intrinsic_op = 229;
pub const nir_intrinsic_ldcx_nv: nir_intrinsic_op = 230;
pub const nir_intrinsic_ldtram_nv: nir_intrinsic_op = 231;
pub const nir_intrinsic_load_aa_line_width: nir_intrinsic_op = 232;
pub const nir_intrinsic_load_accel_struct_amd: nir_intrinsic_op = 233;
pub const nir_intrinsic_load_active_samples_agx: nir_intrinsic_op = 234;
pub const nir_intrinsic_load_active_subgroup_count_agx: nir_intrinsic_op = 235;
pub const nir_intrinsic_load_active_subgroup_invocation_agx: nir_intrinsic_op = 236;
pub const nir_intrinsic_load_agx: nir_intrinsic_op = 237;
pub const nir_intrinsic_load_alpha_reference_amd: nir_intrinsic_op = 238;
pub const nir_intrinsic_load_api_sample_mask_agx: nir_intrinsic_op = 239;
pub const nir_intrinsic_load_attrib_clamp_agx: nir_intrinsic_op = 240;
pub const nir_intrinsic_load_attribute_pan: nir_intrinsic_op = 241;
pub const nir_intrinsic_load_back_face_agx: nir_intrinsic_op = 242;
pub const nir_intrinsic_load_barycentric_at_offset: nir_intrinsic_op = 243;
pub const nir_intrinsic_load_barycentric_at_offset_nv: nir_intrinsic_op = 244;
pub const nir_intrinsic_load_barycentric_at_sample: nir_intrinsic_op = 245;
pub const nir_intrinsic_load_barycentric_centroid: nir_intrinsic_op = 246;
pub const nir_intrinsic_load_barycentric_coord_at_offset: nir_intrinsic_op = 247;
pub const nir_intrinsic_load_barycentric_coord_at_sample: nir_intrinsic_op = 248;
pub const nir_intrinsic_load_barycentric_coord_centroid: nir_intrinsic_op = 249;
pub const nir_intrinsic_load_barycentric_coord_pixel: nir_intrinsic_op = 250;
pub const nir_intrinsic_load_barycentric_coord_sample: nir_intrinsic_op = 251;
pub const nir_intrinsic_load_barycentric_model: nir_intrinsic_op = 252;
pub const nir_intrinsic_load_barycentric_optimize_amd: nir_intrinsic_op = 253;
pub const nir_intrinsic_load_barycentric_pixel: nir_intrinsic_op = 254;
pub const nir_intrinsic_load_barycentric_sample: nir_intrinsic_op = 255;
pub const nir_intrinsic_load_base_global_invocation_id: nir_intrinsic_op = 256;
pub const nir_intrinsic_load_base_instance: nir_intrinsic_op = 257;
pub const nir_intrinsic_load_base_vertex: nir_intrinsic_op = 258;
pub const nir_intrinsic_load_base_workgroup_id: nir_intrinsic_op = 259;
pub const nir_intrinsic_load_blend_const_color_a_float: nir_intrinsic_op = 260;
pub const nir_intrinsic_load_blend_const_color_aaaa8888_unorm: nir_intrinsic_op = 261;
pub const nir_intrinsic_load_blend_const_color_b_float: nir_intrinsic_op = 262;
pub const nir_intrinsic_load_blend_const_color_g_float: nir_intrinsic_op = 263;
pub const nir_intrinsic_load_blend_const_color_r_float: nir_intrinsic_op = 264;
pub const nir_intrinsic_load_blend_const_color_rgba: nir_intrinsic_op = 265;
pub const nir_intrinsic_load_blend_const_color_rgba8888_unorm: nir_intrinsic_op = 266;
pub const nir_intrinsic_load_btd_global_arg_addr_intel: nir_intrinsic_op = 267;
pub const nir_intrinsic_load_btd_local_arg_addr_intel: nir_intrinsic_op = 268;
pub const nir_intrinsic_load_btd_resume_sbt_addr_intel: nir_intrinsic_op = 269;
pub const nir_intrinsic_load_btd_shader_type_intel: nir_intrinsic_op = 270;
pub const nir_intrinsic_load_btd_stack_id_intel: nir_intrinsic_op = 271;
pub const nir_intrinsic_load_buffer_amd: nir_intrinsic_op = 272;
pub const nir_intrinsic_load_callable_sbt_addr_intel: nir_intrinsic_op = 273;
pub const nir_intrinsic_load_callable_sbt_stride_intel: nir_intrinsic_op = 274;
pub const nir_intrinsic_load_clamp_vertex_color_amd: nir_intrinsic_op = 275;
pub const nir_intrinsic_load_clip_half_line_width_amd: nir_intrinsic_op = 276;
pub const nir_intrinsic_load_clip_z_coeff_agx: nir_intrinsic_op = 277;
pub const nir_intrinsic_load_coalesced_input_count: nir_intrinsic_op = 278;
pub const nir_intrinsic_load_coeff_pco: nir_intrinsic_op = 279;
pub const nir_intrinsic_load_coefficients_agx: nir_intrinsic_op = 280;
pub const nir_intrinsic_load_color0: nir_intrinsic_op = 281;
pub const nir_intrinsic_load_color1: nir_intrinsic_op = 282;
pub const nir_intrinsic_load_const_buf_base_addr_lvp: nir_intrinsic_op = 283;
pub const nir_intrinsic_load_const_ir3: nir_intrinsic_op = 284;
pub const nir_intrinsic_load_constant: nir_intrinsic_op = 285;
pub const nir_intrinsic_load_constant_agx: nir_intrinsic_op = 286;
pub const nir_intrinsic_load_constant_base_ptr: nir_intrinsic_op = 287;
pub const nir_intrinsic_load_converted_output_pan: nir_intrinsic_op = 288;
pub const nir_intrinsic_load_core_count_arm: nir_intrinsic_op = 289;
pub const nir_intrinsic_load_core_id: nir_intrinsic_op = 290;
pub const nir_intrinsic_load_core_max_id_arm: nir_intrinsic_op = 291;
pub const nir_intrinsic_load_cull_any_enabled_amd: nir_intrinsic_op = 292;
pub const nir_intrinsic_load_cull_back_face_enabled_amd: nir_intrinsic_op = 293;
pub const nir_intrinsic_load_cull_ccw_amd: nir_intrinsic_op = 294;
pub const nir_intrinsic_load_cull_front_face_enabled_amd: nir_intrinsic_op = 295;
pub const nir_intrinsic_load_cull_line_viewport_xy_scale_and_offset_amd: nir_intrinsic_op = 296;
pub const nir_intrinsic_load_cull_mask: nir_intrinsic_op = 297;
pub const nir_intrinsic_load_cull_mask_and_flags_amd: nir_intrinsic_op = 298;
pub const nir_intrinsic_load_cull_small_line_precision_amd: nir_intrinsic_op = 299;
pub const nir_intrinsic_load_cull_small_lines_enabled_amd: nir_intrinsic_op = 300;
pub const nir_intrinsic_load_cull_small_triangle_precision_amd: nir_intrinsic_op = 301;
pub const nir_intrinsic_load_cull_small_triangles_enabled_amd: nir_intrinsic_op = 302;
pub const nir_intrinsic_load_cull_triangle_viewport_xy_scale_and_offset_amd: nir_intrinsic_op = 303;
pub const nir_intrinsic_load_debug_log_desc_amd: nir_intrinsic_op = 304;
pub const nir_intrinsic_load_depth_never_agx: nir_intrinsic_op = 305;
pub const nir_intrinsic_load_deref: nir_intrinsic_op = 306;
pub const nir_intrinsic_load_deref_block_intel: nir_intrinsic_op = 307;
pub const nir_intrinsic_load_descriptor_set_agx: nir_intrinsic_op = 308;
pub const nir_intrinsic_load_draw_id: nir_intrinsic_op = 309;
pub const nir_intrinsic_load_esgs_vertex_stride_amd: nir_intrinsic_op = 310;
pub const nir_intrinsic_load_exported_agx: nir_intrinsic_op = 311;
pub const nir_intrinsic_load_face_ccw_pco: nir_intrinsic_op = 312;
pub const nir_intrinsic_load_fb_layers_v3d: nir_intrinsic_op = 313;
pub const nir_intrinsic_load_fbfetch_image_desc_amd: nir_intrinsic_op = 314;
pub const nir_intrinsic_load_fbfetch_image_fmask_desc_amd: nir_intrinsic_op = 315;
pub const nir_intrinsic_load_fep_w_v3d: nir_intrinsic_op = 316;
pub const nir_intrinsic_load_first_vertex: nir_intrinsic_op = 317;
pub const nir_intrinsic_load_fixed_point_size_agx: nir_intrinsic_op = 318;
pub const nir_intrinsic_load_flat_mask: nir_intrinsic_op = 319;
pub const nir_intrinsic_load_force_vrs_rates_amd: nir_intrinsic_op = 320;
pub const nir_intrinsic_load_frag_coord: nir_intrinsic_op = 321;
pub const nir_intrinsic_load_frag_coord_unscaled_ir3: nir_intrinsic_op = 322;
pub const nir_intrinsic_load_frag_coord_w: nir_intrinsic_op = 323;
pub const nir_intrinsic_load_frag_coord_z: nir_intrinsic_op = 324;
pub const nir_intrinsic_load_frag_coord_zw_pan: nir_intrinsic_op = 325;
pub const nir_intrinsic_load_frag_invocation_count: nir_intrinsic_op = 326;
pub const nir_intrinsic_load_frag_offset_ir3: nir_intrinsic_op = 327;
pub const nir_intrinsic_load_frag_shading_rate: nir_intrinsic_op = 328;
pub const nir_intrinsic_load_frag_size: nir_intrinsic_op = 329;
pub const nir_intrinsic_load_frag_size_ir3: nir_intrinsic_op = 330;
pub const nir_intrinsic_load_from_texture_handle_agx: nir_intrinsic_op = 331;
pub const nir_intrinsic_load_front_face: nir_intrinsic_op = 332;
pub const nir_intrinsic_load_front_face_fsign: nir_intrinsic_op = 333;
pub const nir_intrinsic_load_front_face_op_pco: nir_intrinsic_op = 334;
pub const nir_intrinsic_load_fs_coeffs_pco: nir_intrinsic_op = 335;
pub const nir_intrinsic_load_fs_input_interp_deltas: nir_intrinsic_op = 336;
pub const nir_intrinsic_load_fs_meta_pco: nir_intrinsic_op = 337;
pub const nir_intrinsic_load_fs_msaa_intel: nir_intrinsic_op = 338;
pub const nir_intrinsic_load_fully_covered: nir_intrinsic_op = 339;
pub const nir_intrinsic_load_geometry_param_buffer_poly: nir_intrinsic_op = 340;
pub const nir_intrinsic_load_global: nir_intrinsic_op = 341;
pub const nir_intrinsic_load_global_2x32: nir_intrinsic_op = 342;
pub const nir_intrinsic_load_global_amd: nir_intrinsic_op = 343;
pub const nir_intrinsic_load_global_base_ptr: nir_intrinsic_op = 344;
pub const nir_intrinsic_load_global_block_intel: nir_intrinsic_op = 345;
pub const nir_intrinsic_load_global_bounded: nir_intrinsic_op = 346;
pub const nir_intrinsic_load_global_constant: nir_intrinsic_op = 347;
pub const nir_intrinsic_load_global_constant_bounded: nir_intrinsic_op = 348;
pub const nir_intrinsic_load_global_constant_offset: nir_intrinsic_op = 349;
pub const nir_intrinsic_load_global_constant_uniform_block_intel: nir_intrinsic_op = 350;
pub const nir_intrinsic_load_global_etna: nir_intrinsic_op = 351;
pub const nir_intrinsic_load_global_invocation_id: nir_intrinsic_op = 352;
pub const nir_intrinsic_load_global_invocation_index: nir_intrinsic_op = 353;
pub const nir_intrinsic_load_global_ir3: nir_intrinsic_op = 354;
pub const nir_intrinsic_load_global_size: nir_intrinsic_op = 355;
pub const nir_intrinsic_load_gs_header_ir3: nir_intrinsic_op = 356;
pub const nir_intrinsic_load_gs_vertex_offset_amd: nir_intrinsic_op = 357;
pub const nir_intrinsic_load_gs_wave_id_amd: nir_intrinsic_op = 358;
pub const nir_intrinsic_load_helper_arg_hi_agx: nir_intrinsic_op = 359;
pub const nir_intrinsic_load_helper_arg_lo_agx: nir_intrinsic_op = 360;
pub const nir_intrinsic_load_helper_invocation: nir_intrinsic_op = 361;
pub const nir_intrinsic_load_helper_op_id_agx: nir_intrinsic_op = 362;
pub const nir_intrinsic_load_hit_attrib_amd: nir_intrinsic_op = 363;
pub const nir_intrinsic_load_hs_out_patch_data_offset_amd: nir_intrinsic_op = 364;
pub const nir_intrinsic_load_hs_patch_stride_ir3: nir_intrinsic_op = 365;
pub const nir_intrinsic_load_initial_edgeflags_amd: nir_intrinsic_op = 366;
pub const nir_intrinsic_load_inline_data_intel: nir_intrinsic_op = 367;
pub const nir_intrinsic_load_input: nir_intrinsic_op = 368;
pub const nir_intrinsic_load_input_assembly_buffer_poly: nir_intrinsic_op = 369;
pub const nir_intrinsic_load_input_attachment_conv_pan: nir_intrinsic_op = 370;
pub const nir_intrinsic_load_input_attachment_coord: nir_intrinsic_op = 371;
pub const nir_intrinsic_load_input_attachment_target_pan: nir_intrinsic_op = 372;
pub const nir_intrinsic_load_input_topology_poly: nir_intrinsic_op = 373;
pub const nir_intrinsic_load_input_vertex: nir_intrinsic_op = 374;
pub const nir_intrinsic_load_instance_id: nir_intrinsic_op = 375;
pub const nir_intrinsic_load_instance_num_pco: nir_intrinsic_op = 376;
pub const nir_intrinsic_load_interpolated_input: nir_intrinsic_op = 377;
pub const nir_intrinsic_load_intersection_opaque_amd: nir_intrinsic_op = 378;
pub const nir_intrinsic_load_invocation_id: nir_intrinsic_op = 379;
pub const nir_intrinsic_load_is_first_fan_agx: nir_intrinsic_op = 380;
pub const nir_intrinsic_load_is_indexed_draw: nir_intrinsic_op = 381;
pub const nir_intrinsic_load_kernel_input: nir_intrinsic_op = 382;
pub const nir_intrinsic_load_layer_id: nir_intrinsic_op = 383;
pub const nir_intrinsic_load_lds_ngg_gs_out_vertex_base_amd: nir_intrinsic_op = 384;
pub const nir_intrinsic_load_leaf_opaque_intel: nir_intrinsic_op = 385;
pub const nir_intrinsic_load_leaf_procedural_intel: nir_intrinsic_op = 386;
pub const nir_intrinsic_load_line_coord: nir_intrinsic_op = 387;
pub const nir_intrinsic_load_line_width: nir_intrinsic_op = 388;
pub const nir_intrinsic_load_local_invocation_id: nir_intrinsic_op = 389;
pub const nir_intrinsic_load_local_invocation_index: nir_intrinsic_op = 390;
pub const nir_intrinsic_load_local_pixel_agx: nir_intrinsic_op = 391;
pub const nir_intrinsic_load_local_shared_r600: nir_intrinsic_op = 392;
pub const nir_intrinsic_load_lshs_vertex_stride_amd: nir_intrinsic_op = 393;
pub const nir_intrinsic_load_max_polygon_intel: nir_intrinsic_op = 394;
pub const nir_intrinsic_load_merged_wave_info_amd: nir_intrinsic_op = 395;
pub const nir_intrinsic_load_mesh_view_count: nir_intrinsic_op = 396;
pub const nir_intrinsic_load_mesh_view_indices: nir_intrinsic_op = 397;
pub const nir_intrinsic_load_multisampled_pan: nir_intrinsic_op = 398;
pub const nir_intrinsic_load_noperspective_varyings_pan: nir_intrinsic_op = 399;
pub const nir_intrinsic_load_num_subgroups: nir_intrinsic_op = 400;
pub const nir_intrinsic_load_num_vertices: nir_intrinsic_op = 401;
pub const nir_intrinsic_load_num_vertices_per_primitive_amd: nir_intrinsic_op = 402;
pub const nir_intrinsic_load_num_workgroups: nir_intrinsic_op = 403;
pub const nir_intrinsic_load_ordered_id_amd: nir_intrinsic_op = 404;
pub const nir_intrinsic_load_output: nir_intrinsic_op = 405;
pub const nir_intrinsic_load_packed_passthrough_primitive_amd: nir_intrinsic_op = 406;
pub const nir_intrinsic_load_packed_sample_location_pco: nir_intrinsic_op = 407;
pub const nir_intrinsic_load_param: nir_intrinsic_op = 408;
pub const nir_intrinsic_load_patch_vertices_in: nir_intrinsic_op = 409;
pub const nir_intrinsic_load_per_primitive_input: nir_intrinsic_op = 410;
pub const nir_intrinsic_load_per_primitive_output: nir_intrinsic_op = 411;
pub const nir_intrinsic_load_per_primitive_remap_intel: nir_intrinsic_op = 412;
pub const nir_intrinsic_load_per_vertex_input: nir_intrinsic_op = 413;
pub const nir_intrinsic_load_per_vertex_output: nir_intrinsic_op = 414;
pub const nir_intrinsic_load_per_view_output: nir_intrinsic_op = 415;
pub const nir_intrinsic_load_persp_center_rhw_ir3: nir_intrinsic_op = 416;
pub const nir_intrinsic_load_pipeline_stat_query_enabled_amd: nir_intrinsic_op = 417;
pub const nir_intrinsic_load_pixel_coord: nir_intrinsic_op = 418;
pub const nir_intrinsic_load_point_coord: nir_intrinsic_op = 419;
pub const nir_intrinsic_load_point_coord_maybe_flipped: nir_intrinsic_op = 420;
pub const nir_intrinsic_load_poly_line_smooth_enabled: nir_intrinsic_op = 421;
pub const nir_intrinsic_load_polygon_stipple_agx: nir_intrinsic_op = 422;
pub const nir_intrinsic_load_polygon_stipple_buffer_amd: nir_intrinsic_op = 423;
pub const nir_intrinsic_load_preamble: nir_intrinsic_op = 424;
pub const nir_intrinsic_load_prim_gen_query_enabled_amd: nir_intrinsic_op = 425;
pub const nir_intrinsic_load_prim_xfb_query_enabled_amd: nir_intrinsic_op = 426;
pub const nir_intrinsic_load_primitive_id: nir_intrinsic_op = 427;
pub const nir_intrinsic_load_primitive_location_ir3: nir_intrinsic_op = 428;
pub const nir_intrinsic_load_printf_buffer_address: nir_intrinsic_op = 429;
pub const nir_intrinsic_load_printf_buffer_size: nir_intrinsic_op = 430;
pub const nir_intrinsic_load_provoking_last: nir_intrinsic_op = 431;
pub const nir_intrinsic_load_provoking_vtx_amd: nir_intrinsic_op = 432;
pub const nir_intrinsic_load_provoking_vtx_in_prim_amd: nir_intrinsic_op = 433;
pub const nir_intrinsic_load_push_constant: nir_intrinsic_op = 434;
pub const nir_intrinsic_load_push_constant_zink: nir_intrinsic_op = 435;
pub const nir_intrinsic_load_r600_per_vertex_input: nir_intrinsic_op = 436;
pub const nir_intrinsic_load_rasterization_primitive_amd: nir_intrinsic_op = 437;
pub const nir_intrinsic_load_rasterization_samples_amd: nir_intrinsic_op = 438;
pub const nir_intrinsic_load_rasterization_stream: nir_intrinsic_op = 439;
pub const nir_intrinsic_load_raw_output_pan: nir_intrinsic_op = 440;
pub const nir_intrinsic_load_raw_vertex_id_pan: nir_intrinsic_op = 441;
pub const nir_intrinsic_load_raw_vertex_offset_pan: nir_intrinsic_op = 442;
pub const nir_intrinsic_load_ray_base_mem_addr_intel: nir_intrinsic_op = 443;
pub const nir_intrinsic_load_ray_flags: nir_intrinsic_op = 444;
pub const nir_intrinsic_load_ray_geometry_index: nir_intrinsic_op = 445;
pub const nir_intrinsic_load_ray_hit_kind: nir_intrinsic_op = 446;
pub const nir_intrinsic_load_ray_hit_sbt_addr_intel: nir_intrinsic_op = 447;
pub const nir_intrinsic_load_ray_hit_sbt_stride_intel: nir_intrinsic_op = 448;
pub const nir_intrinsic_load_ray_hw_stack_size_intel: nir_intrinsic_op = 449;
pub const nir_intrinsic_load_ray_instance_custom_index: nir_intrinsic_op = 450;
pub const nir_intrinsic_load_ray_launch_id: nir_intrinsic_op = 451;
pub const nir_intrinsic_load_ray_launch_size: nir_intrinsic_op = 452;
pub const nir_intrinsic_load_ray_miss_sbt_addr_intel: nir_intrinsic_op = 453;
pub const nir_intrinsic_load_ray_miss_sbt_stride_intel: nir_intrinsic_op = 454;
pub const nir_intrinsic_load_ray_num_dss_rt_stacks_intel: nir_intrinsic_op = 455;
pub const nir_intrinsic_load_ray_object_direction: nir_intrinsic_op = 456;
pub const nir_intrinsic_load_ray_object_origin: nir_intrinsic_op = 457;
pub const nir_intrinsic_load_ray_object_to_world: nir_intrinsic_op = 458;
pub const nir_intrinsic_load_ray_query_global_intel: nir_intrinsic_op = 459;
pub const nir_intrinsic_load_ray_sw_stack_size_intel: nir_intrinsic_op = 460;
pub const nir_intrinsic_load_ray_t_max: nir_intrinsic_op = 461;
pub const nir_intrinsic_load_ray_t_min: nir_intrinsic_op = 462;
pub const nir_intrinsic_load_ray_tracing_stack_base_lvp: nir_intrinsic_op = 463;
pub const nir_intrinsic_load_ray_triangle_vertex_positions: nir_intrinsic_op = 464;
pub const nir_intrinsic_load_ray_world_direction: nir_intrinsic_op = 465;
pub const nir_intrinsic_load_ray_world_origin: nir_intrinsic_op = 466;
pub const nir_intrinsic_load_ray_world_to_object: nir_intrinsic_op = 467;
pub const nir_intrinsic_load_readonly_output_pan: nir_intrinsic_op = 468;
pub const nir_intrinsic_load_reg: nir_intrinsic_op = 469;
pub const nir_intrinsic_load_reg_indirect: nir_intrinsic_op = 470;
pub const nir_intrinsic_load_rel_patch_id_ir3: nir_intrinsic_op = 471;
pub const nir_intrinsic_load_reloc_const_intel: nir_intrinsic_op = 472;
pub const nir_intrinsic_load_resume_shader_address_amd: nir_intrinsic_op = 473;
pub const nir_intrinsic_load_ring_attr_amd: nir_intrinsic_op = 474;
pub const nir_intrinsic_load_ring_attr_offset_amd: nir_intrinsic_op = 475;
pub const nir_intrinsic_load_ring_es2gs_offset_amd: nir_intrinsic_op = 476;
pub const nir_intrinsic_load_ring_esgs_amd: nir_intrinsic_op = 477;
pub const nir_intrinsic_load_ring_gs2vs_offset_amd: nir_intrinsic_op = 478;
pub const nir_intrinsic_load_ring_gsvs_amd: nir_intrinsic_op = 479;
pub const nir_intrinsic_load_ring_mesh_scratch_amd: nir_intrinsic_op = 480;
pub const nir_intrinsic_load_ring_mesh_scratch_offset_amd: nir_intrinsic_op = 481;
pub const nir_intrinsic_load_ring_task_draw_amd: nir_intrinsic_op = 482;
pub const nir_intrinsic_load_ring_task_payload_amd: nir_intrinsic_op = 483;
pub const nir_intrinsic_load_ring_tess_factors_amd: nir_intrinsic_op = 484;
pub const nir_intrinsic_load_ring_tess_factors_offset_amd: nir_intrinsic_op = 485;
pub const nir_intrinsic_load_ring_tess_offchip_amd: nir_intrinsic_op = 486;
pub const nir_intrinsic_load_ring_tess_offchip_offset_amd: nir_intrinsic_op = 487;
pub const nir_intrinsic_load_root_agx: nir_intrinsic_op = 488;
pub const nir_intrinsic_load_rt_arg_scratch_offset_amd: nir_intrinsic_op = 489;
pub const nir_intrinsic_load_rt_conversion_pan: nir_intrinsic_op = 490;
pub const nir_intrinsic_load_sample_id: nir_intrinsic_op = 491;
pub const nir_intrinsic_load_sample_mask: nir_intrinsic_op = 492;
pub const nir_intrinsic_load_sample_mask_in: nir_intrinsic_op = 493;
pub const nir_intrinsic_load_sample_pos: nir_intrinsic_op = 494;
pub const nir_intrinsic_load_sample_pos_from_id: nir_intrinsic_op = 495;
pub const nir_intrinsic_load_sample_pos_or_center: nir_intrinsic_op = 496;
pub const nir_intrinsic_load_sample_positions_agx: nir_intrinsic_op = 497;
pub const nir_intrinsic_load_sample_positions_amd: nir_intrinsic_op = 498;
pub const nir_intrinsic_load_sample_positions_pan: nir_intrinsic_op = 499;
pub const nir_intrinsic_load_sampler_handle_agx: nir_intrinsic_op = 500;
pub const nir_intrinsic_load_sampler_lod_parameters: nir_intrinsic_op = 501;
pub const nir_intrinsic_load_samples_log2_agx: nir_intrinsic_op = 502;
pub const nir_intrinsic_load_savmsk_vm_pco: nir_intrinsic_op = 503;
pub const nir_intrinsic_load_sbt_base_amd: nir_intrinsic_op = 504;
pub const nir_intrinsic_load_sbt_offset_amd: nir_intrinsic_op = 505;
pub const nir_intrinsic_load_sbt_stride_amd: nir_intrinsic_op = 506;
pub const nir_intrinsic_load_scalar_arg_amd: nir_intrinsic_op = 507;
pub const nir_intrinsic_load_scratch: nir_intrinsic_op = 508;
pub const nir_intrinsic_load_scratch_base_ptr: nir_intrinsic_op = 509;
pub const nir_intrinsic_load_shader_call_data_offset_lvp: nir_intrinsic_op = 510;
pub const nir_intrinsic_load_shader_index: nir_intrinsic_op = 511;
pub const nir_intrinsic_load_shader_output_pan: nir_intrinsic_op = 512;
pub const nir_intrinsic_load_shader_part_tests_zs_agx: nir_intrinsic_op = 513;
pub const nir_intrinsic_load_shader_record_ptr: nir_intrinsic_op = 514;
pub const nir_intrinsic_load_shared: nir_intrinsic_op = 515;
pub const nir_intrinsic_load_shared2_amd: nir_intrinsic_op = 516;
pub const nir_intrinsic_load_shared_base_ptr: nir_intrinsic_op = 517;
pub const nir_intrinsic_load_shared_block_intel: nir_intrinsic_op = 518;
pub const nir_intrinsic_load_shared_ir3: nir_intrinsic_op = 519;
pub const nir_intrinsic_load_shared_lock_nv: nir_intrinsic_op = 520;
pub const nir_intrinsic_load_shared_reg_alloc_size_pco: nir_intrinsic_op = 521;
pub const nir_intrinsic_load_shared_uniform_block_intel: nir_intrinsic_op = 522;
pub const nir_intrinsic_load_simd_width_intel: nir_intrinsic_op = 523;
pub const nir_intrinsic_load_sm_count_nv: nir_intrinsic_op = 524;
pub const nir_intrinsic_load_sm_id_nv: nir_intrinsic_op = 525;
pub const nir_intrinsic_load_smp_meta_pco: nir_intrinsic_op = 526;
pub const nir_intrinsic_load_smp_state_pco: nir_intrinsic_op = 527;
pub const nir_intrinsic_load_ssbo: nir_intrinsic_op = 528;
pub const nir_intrinsic_load_ssbo_address: nir_intrinsic_op = 529;
pub const nir_intrinsic_load_ssbo_block_intel: nir_intrinsic_op = 530;
pub const nir_intrinsic_load_ssbo_intel: nir_intrinsic_op = 531;
pub const nir_intrinsic_load_ssbo_ir3: nir_intrinsic_op = 532;
pub const nir_intrinsic_load_ssbo_uniform_block_intel: nir_intrinsic_op = 533;
pub const nir_intrinsic_load_stack: nir_intrinsic_op = 534;
pub const nir_intrinsic_load_stat_query_address_agx: nir_intrinsic_op = 535;
pub const nir_intrinsic_load_streamout_buffer_amd: nir_intrinsic_op = 536;
pub const nir_intrinsic_load_streamout_config_amd: nir_intrinsic_op = 537;
pub const nir_intrinsic_load_streamout_offset_amd: nir_intrinsic_op = 538;
pub const nir_intrinsic_load_streamout_write_index_amd: nir_intrinsic_op = 539;
pub const nir_intrinsic_load_subgroup_eq_mask: nir_intrinsic_op = 540;
pub const nir_intrinsic_load_subgroup_ge_mask: nir_intrinsic_op = 541;
pub const nir_intrinsic_load_subgroup_gt_mask: nir_intrinsic_op = 542;
pub const nir_intrinsic_load_subgroup_id: nir_intrinsic_op = 543;
pub const nir_intrinsic_load_subgroup_id_shift_ir3: nir_intrinsic_op = 544;
pub const nir_intrinsic_load_subgroup_invocation: nir_intrinsic_op = 545;
pub const nir_intrinsic_load_subgroup_le_mask: nir_intrinsic_op = 546;
pub const nir_intrinsic_load_subgroup_lt_mask: nir_intrinsic_op = 547;
pub const nir_intrinsic_load_subgroup_size: nir_intrinsic_op = 548;
pub const nir_intrinsic_load_sysval_agx: nir_intrinsic_op = 549;
pub const nir_intrinsic_load_sysval_nv: nir_intrinsic_op = 550;
pub const nir_intrinsic_load_task_payload: nir_intrinsic_op = 551;
pub const nir_intrinsic_load_task_ring_entry_amd: nir_intrinsic_op = 552;
pub const nir_intrinsic_load_tcs_header_ir3: nir_intrinsic_op = 553;
pub const nir_intrinsic_load_tcs_in_param_base_r600: nir_intrinsic_op = 554;
pub const nir_intrinsic_load_tcs_mem_attrib_stride: nir_intrinsic_op = 555;
pub const nir_intrinsic_load_tcs_num_patches_amd: nir_intrinsic_op = 556;
pub const nir_intrinsic_load_tcs_out_param_base_r600: nir_intrinsic_op = 557;
pub const nir_intrinsic_load_tcs_primitive_mode_amd: nir_intrinsic_op = 558;
pub const nir_intrinsic_load_tcs_rel_patch_id_r600: nir_intrinsic_op = 559;
pub const nir_intrinsic_load_tcs_tess_factor_base_r600: nir_intrinsic_op = 560;
pub const nir_intrinsic_load_tcs_tess_levels_to_tes_amd: nir_intrinsic_op = 561;
pub const nir_intrinsic_load_tess_config_intel: nir_intrinsic_op = 562;
pub const nir_intrinsic_load_tess_coord: nir_intrinsic_op = 563;
pub const nir_intrinsic_load_tess_coord_xy: nir_intrinsic_op = 564;
pub const nir_intrinsic_load_tess_factor_base_ir3: nir_intrinsic_op = 565;
pub const nir_intrinsic_load_tess_level_inner: nir_intrinsic_op = 566;
pub const nir_intrinsic_load_tess_level_inner_default: nir_intrinsic_op = 567;
pub const nir_intrinsic_load_tess_level_outer: nir_intrinsic_op = 568;
pub const nir_intrinsic_load_tess_level_outer_default: nir_intrinsic_op = 569;
pub const nir_intrinsic_load_tess_param_base_ir3: nir_intrinsic_op = 570;
pub const nir_intrinsic_load_tess_param_buffer_poly: nir_intrinsic_op = 571;
pub const nir_intrinsic_load_tess_rel_patch_id_amd: nir_intrinsic_op = 572;
pub const nir_intrinsic_load_tex_meta_pco: nir_intrinsic_op = 573;
pub const nir_intrinsic_load_tex_sprite_mask_agx: nir_intrinsic_op = 574;
pub const nir_intrinsic_load_tex_state_pco: nir_intrinsic_op = 575;
pub const nir_intrinsic_load_texture_handle_agx: nir_intrinsic_op = 576;
pub const nir_intrinsic_load_texture_scale: nir_intrinsic_op = 577;
pub const nir_intrinsic_load_texture_size_etna: nir_intrinsic_op = 578;
pub const nir_intrinsic_load_tile_coord_pco: nir_intrinsic_op = 579;
pub const nir_intrinsic_load_tiled_offset_pco: nir_intrinsic_op = 580;
pub const nir_intrinsic_load_tlb_color_brcm: nir_intrinsic_op = 581;
pub const nir_intrinsic_load_topology_id_intel: nir_intrinsic_op = 582;
pub const nir_intrinsic_load_typed_buffer_amd: nir_intrinsic_op = 583;
pub const nir_intrinsic_load_uav_ir3: nir_intrinsic_op = 584;
pub const nir_intrinsic_load_ubo: nir_intrinsic_op = 585;
pub const nir_intrinsic_load_ubo_uniform_block_intel: nir_intrinsic_op = 586;
pub const nir_intrinsic_load_ubo_vec4: nir_intrinsic_op = 587;
pub const nir_intrinsic_load_uniform: nir_intrinsic_op = 588;
pub const nir_intrinsic_load_user_clip_plane: nir_intrinsic_op = 589;
pub const nir_intrinsic_load_user_data_amd: nir_intrinsic_op = 590;
pub const nir_intrinsic_load_uvs_index_agx: nir_intrinsic_op = 591;
pub const nir_intrinsic_load_vbo_base_agx: nir_intrinsic_op = 592;
pub const nir_intrinsic_load_vbo_stride_agx: nir_intrinsic_op = 593;
pub const nir_intrinsic_load_vector_arg_amd: nir_intrinsic_op = 594;
pub const nir_intrinsic_load_vertex_id: nir_intrinsic_op = 595;
pub const nir_intrinsic_load_vertex_id_zero_base: nir_intrinsic_op = 596;
pub const nir_intrinsic_load_view_index: nir_intrinsic_op = 597;
pub const nir_intrinsic_load_viewport_offset: nir_intrinsic_op = 598;
pub const nir_intrinsic_load_viewport_scale: nir_intrinsic_op = 599;
pub const nir_intrinsic_load_viewport_x_offset: nir_intrinsic_op = 600;
pub const nir_intrinsic_load_viewport_x_scale: nir_intrinsic_op = 601;
pub const nir_intrinsic_load_viewport_y_offset: nir_intrinsic_op = 602;
pub const nir_intrinsic_load_viewport_y_scale: nir_intrinsic_op = 603;
pub const nir_intrinsic_load_viewport_z_offset: nir_intrinsic_op = 604;
pub const nir_intrinsic_load_viewport_z_scale: nir_intrinsic_op = 605;
pub const nir_intrinsic_load_vs_output_buffer_poly: nir_intrinsic_op = 606;
pub const nir_intrinsic_load_vs_outputs_poly: nir_intrinsic_op = 607;
pub const nir_intrinsic_load_vs_primitive_stride_ir3: nir_intrinsic_op = 608;
pub const nir_intrinsic_load_vs_vertex_stride_ir3: nir_intrinsic_op = 609;
pub const nir_intrinsic_load_vtxin_pco: nir_intrinsic_op = 610;
pub const nir_intrinsic_load_vulkan_descriptor: nir_intrinsic_op = 611;
pub const nir_intrinsic_load_warp_id_arm: nir_intrinsic_op = 612;
pub const nir_intrinsic_load_warp_id_nv: nir_intrinsic_op = 613;
pub const nir_intrinsic_load_warp_max_id_arm: nir_intrinsic_op = 614;
pub const nir_intrinsic_load_warps_per_sm_nv: nir_intrinsic_op = 615;
pub const nir_intrinsic_load_work_dim: nir_intrinsic_op = 616;
pub const nir_intrinsic_load_workgroup_id: nir_intrinsic_op = 617;
pub const nir_intrinsic_load_workgroup_index: nir_intrinsic_op = 618;
pub const nir_intrinsic_load_workgroup_num_input_primitives_amd: nir_intrinsic_op = 619;
pub const nir_intrinsic_load_workgroup_num_input_vertices_amd: nir_intrinsic_op = 620;
pub const nir_intrinsic_load_workgroup_size: nir_intrinsic_op = 621;
pub const nir_intrinsic_load_xfb_address: nir_intrinsic_op = 622;
pub const nir_intrinsic_load_xfb_index_buffer: nir_intrinsic_op = 623;
pub const nir_intrinsic_load_xfb_size: nir_intrinsic_op = 624;
pub const nir_intrinsic_load_xfb_state_address_gfx12_amd: nir_intrinsic_op = 625;
pub const nir_intrinsic_masked_swizzle_amd: nir_intrinsic_op = 626;
pub const nir_intrinsic_mbcnt_amd: nir_intrinsic_op = 627;
pub const nir_intrinsic_memcpy_deref: nir_intrinsic_op = 628;
pub const nir_intrinsic_mutex_pco: nir_intrinsic_op = 629;
pub const nir_intrinsic_nop: nir_intrinsic_op = 630;
pub const nir_intrinsic_nop_amd: nir_intrinsic_op = 631;
pub const nir_intrinsic_optimization_barrier_sgpr_amd: nir_intrinsic_op = 632;
pub const nir_intrinsic_optimization_barrier_vgpr_amd: nir_intrinsic_op = 633;
pub const nir_intrinsic_ordered_add_loop_gfx12_amd: nir_intrinsic_op = 634;
pub const nir_intrinsic_ordered_xfb_counter_add_gfx11_amd: nir_intrinsic_op = 635;
pub const nir_intrinsic_overwrite_tes_arguments_amd: nir_intrinsic_op = 636;
pub const nir_intrinsic_overwrite_vs_arguments_amd: nir_intrinsic_op = 637;
pub const nir_intrinsic_pack_pco: nir_intrinsic_op = 638;
pub const nir_intrinsic_pck_prog_pco: nir_intrinsic_op = 639;
pub const nir_intrinsic_pin_cx_handle_nv: nir_intrinsic_op = 640;
pub const nir_intrinsic_preamble_end_ir3: nir_intrinsic_op = 641;
pub const nir_intrinsic_preamble_start_ir3: nir_intrinsic_op = 642;
pub const nir_intrinsic_prefetch_sam_ir3: nir_intrinsic_op = 643;
pub const nir_intrinsic_prefetch_tex_ir3: nir_intrinsic_op = 644;
pub const nir_intrinsic_prefetch_ubo_ir3: nir_intrinsic_op = 645;
pub const nir_intrinsic_printf: nir_intrinsic_op = 646;
pub const nir_intrinsic_printf_abort: nir_intrinsic_op = 647;
pub const nir_intrinsic_quad_ballot_agx: nir_intrinsic_op = 648;
pub const nir_intrinsic_quad_broadcast: nir_intrinsic_op = 649;
pub const nir_intrinsic_quad_swap_diagonal: nir_intrinsic_op = 650;
pub const nir_intrinsic_quad_swap_horizontal: nir_intrinsic_op = 651;
pub const nir_intrinsic_quad_swap_vertical: nir_intrinsic_op = 652;
pub const nir_intrinsic_quad_swizzle_amd: nir_intrinsic_op = 653;
pub const nir_intrinsic_quad_vote_all: nir_intrinsic_op = 654;
pub const nir_intrinsic_quad_vote_any: nir_intrinsic_op = 655;
pub const nir_intrinsic_r600_indirect_vertex_at_index: nir_intrinsic_op = 656;
pub const nir_intrinsic_ray_intersection_ir3: nir_intrinsic_op = 657;
pub const nir_intrinsic_read_attribute_payload_intel: nir_intrinsic_op = 658;
pub const nir_intrinsic_read_first_invocation: nir_intrinsic_op = 659;
pub const nir_intrinsic_read_getlast_ir3: nir_intrinsic_op = 660;
pub const nir_intrinsic_read_invocation: nir_intrinsic_op = 661;
pub const nir_intrinsic_read_invocation_cond_ir3: nir_intrinsic_op = 662;
pub const nir_intrinsic_reduce: nir_intrinsic_op = 663;
pub const nir_intrinsic_reduce_clusters_ir3: nir_intrinsic_op = 664;
pub const nir_intrinsic_report_ray_intersection: nir_intrinsic_op = 665;
pub const nir_intrinsic_resource_intel: nir_intrinsic_op = 666;
pub const nir_intrinsic_rotate: nir_intrinsic_op = 667;
pub const nir_intrinsic_rq_confirm_intersection: nir_intrinsic_op = 668;
pub const nir_intrinsic_rq_generate_intersection: nir_intrinsic_op = 669;
pub const nir_intrinsic_rq_initialize: nir_intrinsic_op = 670;
pub const nir_intrinsic_rq_load: nir_intrinsic_op = 671;
pub const nir_intrinsic_rq_proceed: nir_intrinsic_op = 672;
pub const nir_intrinsic_rq_terminate: nir_intrinsic_op = 673;
pub const nir_intrinsic_rt_execute_callable: nir_intrinsic_op = 674;
pub const nir_intrinsic_rt_resume: nir_intrinsic_op = 675;
pub const nir_intrinsic_rt_return_amd: nir_intrinsic_op = 676;
pub const nir_intrinsic_rt_trace_ray: nir_intrinsic_op = 677;
pub const nir_intrinsic_sample_mask_agx: nir_intrinsic_op = 678;
pub const nir_intrinsic_select_vertex_poly: nir_intrinsic_op = 679;
pub const nir_intrinsic_sendmsg_amd: nir_intrinsic_op = 680;
pub const nir_intrinsic_set_vertex_and_primitive_count: nir_intrinsic_op = 681;
pub const nir_intrinsic_shader_clock: nir_intrinsic_op = 682;
pub const nir_intrinsic_shared_append_amd: nir_intrinsic_op = 683;
pub const nir_intrinsic_shared_atomic: nir_intrinsic_op = 684;
pub const nir_intrinsic_shared_atomic_swap: nir_intrinsic_op = 685;
pub const nir_intrinsic_shared_consume_amd: nir_intrinsic_op = 686;
pub const nir_intrinsic_shuffle: nir_intrinsic_op = 687;
pub const nir_intrinsic_shuffle_down: nir_intrinsic_op = 688;
pub const nir_intrinsic_shuffle_down_uniform_ir3: nir_intrinsic_op = 689;
pub const nir_intrinsic_shuffle_up: nir_intrinsic_op = 690;
pub const nir_intrinsic_shuffle_up_uniform_ir3: nir_intrinsic_op = 691;
pub const nir_intrinsic_shuffle_xor: nir_intrinsic_op = 692;
pub const nir_intrinsic_shuffle_xor_uniform_ir3: nir_intrinsic_op = 693;
pub const nir_intrinsic_sleep_amd: nir_intrinsic_op = 694;
pub const nir_intrinsic_smp_coeffs_pco: nir_intrinsic_op = 695;
pub const nir_intrinsic_smp_pco: nir_intrinsic_op = 696;
pub const nir_intrinsic_smp_raw_pco: nir_intrinsic_op = 697;
pub const nir_intrinsic_smp_write_pco: nir_intrinsic_op = 698;
pub const nir_intrinsic_sparse_residency_code_and: nir_intrinsic_op = 699;
pub const nir_intrinsic_ssa_bar_nv: nir_intrinsic_op = 700;
pub const nir_intrinsic_ssbo_atomic: nir_intrinsic_op = 701;
pub const nir_intrinsic_ssbo_atomic_ir3: nir_intrinsic_op = 702;
pub const nir_intrinsic_ssbo_atomic_swap: nir_intrinsic_op = 703;
pub const nir_intrinsic_ssbo_atomic_swap_ir3: nir_intrinsic_op = 704;
pub const nir_intrinsic_stack_map_agx: nir_intrinsic_op = 705;
pub const nir_intrinsic_stack_unmap_agx: nir_intrinsic_op = 706;
pub const nir_intrinsic_store_agx: nir_intrinsic_op = 707;
pub const nir_intrinsic_store_buffer_amd: nir_intrinsic_op = 708;
pub const nir_intrinsic_store_combined_output_pan: nir_intrinsic_op = 709;
pub const nir_intrinsic_store_const_ir3: nir_intrinsic_op = 710;
pub const nir_intrinsic_store_deref: nir_intrinsic_op = 711;
pub const nir_intrinsic_store_deref_block_intel: nir_intrinsic_op = 712;
pub const nir_intrinsic_store_global: nir_intrinsic_op = 713;
pub const nir_intrinsic_store_global_2x32: nir_intrinsic_op = 714;
pub const nir_intrinsic_store_global_amd: nir_intrinsic_op = 715;
pub const nir_intrinsic_store_global_block_intel: nir_intrinsic_op = 716;
pub const nir_intrinsic_store_global_etna: nir_intrinsic_op = 717;
pub const nir_intrinsic_store_global_ir3: nir_intrinsic_op = 718;
pub const nir_intrinsic_store_hit_attrib_amd: nir_intrinsic_op = 719;
pub const nir_intrinsic_store_local_pixel_agx: nir_intrinsic_op = 720;
pub const nir_intrinsic_store_local_shared_r600: nir_intrinsic_op = 721;
pub const nir_intrinsic_store_output: nir_intrinsic_op = 722;
pub const nir_intrinsic_store_per_primitive_output: nir_intrinsic_op = 723;
pub const nir_intrinsic_store_per_primitive_payload_intel: nir_intrinsic_op = 724;
pub const nir_intrinsic_store_per_vertex_output: nir_intrinsic_op = 725;
pub const nir_intrinsic_store_per_view_output: nir_intrinsic_op = 726;
pub const nir_intrinsic_store_preamble: nir_intrinsic_op = 727;
pub const nir_intrinsic_store_preamble_dynamic: nir_intrinsic_op = 728;
pub const nir_intrinsic_store_raw_output_pan: nir_intrinsic_op = 729;
pub const nir_intrinsic_store_reg: nir_intrinsic_op = 730;
pub const nir_intrinsic_store_reg_indirect: nir_intrinsic_op = 731;
pub const nir_intrinsic_store_scalar_arg_amd: nir_intrinsic_op = 732;
pub const nir_intrinsic_store_scratch: nir_intrinsic_op = 733;
pub const nir_intrinsic_store_shared: nir_intrinsic_op = 734;
pub const nir_intrinsic_store_shared2_amd: nir_intrinsic_op = 735;
pub const nir_intrinsic_store_shared_block_intel: nir_intrinsic_op = 736;
pub const nir_intrinsic_store_shared_ir3: nir_intrinsic_op = 737;
pub const nir_intrinsic_store_shared_unlock_nv: nir_intrinsic_op = 738;
pub const nir_intrinsic_store_ssbo: nir_intrinsic_op = 739;
pub const nir_intrinsic_store_ssbo_block_intel: nir_intrinsic_op = 740;
pub const nir_intrinsic_store_ssbo_intel: nir_intrinsic_op = 741;
pub const nir_intrinsic_store_ssbo_ir3: nir_intrinsic_op = 742;
pub const nir_intrinsic_store_stack: nir_intrinsic_op = 743;
pub const nir_intrinsic_store_task_payload: nir_intrinsic_op = 744;
pub const nir_intrinsic_store_tf_r600: nir_intrinsic_op = 745;
pub const nir_intrinsic_store_tlb_sample_color_v3d: nir_intrinsic_op = 746;
pub const nir_intrinsic_store_uvs_agx: nir_intrinsic_op = 747;
pub const nir_intrinsic_store_vector_arg_amd: nir_intrinsic_op = 748;
pub const nir_intrinsic_store_zs_agx: nir_intrinsic_op = 749;
pub const nir_intrinsic_strict_wqm_coord_amd: nir_intrinsic_op = 750;
pub const nir_intrinsic_subfm_nv: nir_intrinsic_op = 751;
pub const nir_intrinsic_suclamp_nv: nir_intrinsic_op = 752;
pub const nir_intrinsic_sueau_nv: nir_intrinsic_op = 753;
pub const nir_intrinsic_suldga_nv: nir_intrinsic_op = 754;
pub const nir_intrinsic_sustga_nv: nir_intrinsic_op = 755;
pub const nir_intrinsic_task_payload_atomic: nir_intrinsic_op = 756;
pub const nir_intrinsic_task_payload_atomic_swap: nir_intrinsic_op = 757;
pub const nir_intrinsic_terminate: nir_intrinsic_op = 758;
pub const nir_intrinsic_terminate_if: nir_intrinsic_op = 759;
pub const nir_intrinsic_terminate_ray: nir_intrinsic_op = 760;
pub const nir_intrinsic_trace_ray: nir_intrinsic_op = 761;
pub const nir_intrinsic_trace_ray_intel: nir_intrinsic_op = 762;
pub const nir_intrinsic_unit_test_amd: nir_intrinsic_op = 763;
pub const nir_intrinsic_unit_test_divergent_amd: nir_intrinsic_op = 764;
pub const nir_intrinsic_unit_test_uniform_amd: nir_intrinsic_op = 765;
pub const nir_intrinsic_unpack_pco: nir_intrinsic_op = 766;
pub const nir_intrinsic_unpin_cx_handle_nv: nir_intrinsic_op = 767;
pub const nir_intrinsic_use: nir_intrinsic_op = 768;
pub const nir_intrinsic_uvsw_write_pco: nir_intrinsic_op = 769;
pub const nir_intrinsic_vild_nv: nir_intrinsic_op = 770;
pub const nir_intrinsic_vote_all: nir_intrinsic_op = 771;
pub const nir_intrinsic_vote_any: nir_intrinsic_op = 772;
pub const nir_intrinsic_vote_feq: nir_intrinsic_op = 773;
pub const nir_intrinsic_vote_ieq: nir_intrinsic_op = 774;
pub const nir_intrinsic_vulkan_resource_index: nir_intrinsic_op = 775;
pub const nir_intrinsic_vulkan_resource_reindex: nir_intrinsic_op = 776;
pub const nir_intrinsic_wop_pco: nir_intrinsic_op = 777;
pub const nir_intrinsic_write_invocation_amd: nir_intrinsic_op = 778;
pub const nir_intrinsic_xfb_counter_sub_gfx11_amd: nir_intrinsic_op = 779;
pub const nir_last_intrinsic: nir_intrinsic_op = 779;
pub const nir_num_intrinsics: nir_intrinsic_op = 780;
pub type nir_intrinsic_op = ::std::os::raw::c_uint;
pub const NIR_INTRINSIC_BASE: nir_intrinsic_index_flag = 0;
pub const NIR_INTRINSIC_WRITE_MASK: nir_intrinsic_index_flag = 1;
pub const NIR_INTRINSIC_STREAM_ID: nir_intrinsic_index_flag = 2;
pub const NIR_INTRINSIC_UCP_ID: nir_intrinsic_index_flag = 3;
pub const NIR_INTRINSIC_RANGE_BASE: nir_intrinsic_index_flag = 4;
pub const NIR_INTRINSIC_RANGE: nir_intrinsic_index_flag = 5;
pub const NIR_INTRINSIC_DESC_SET: nir_intrinsic_index_flag = 6;
pub const NIR_INTRINSIC_BINDING: nir_intrinsic_index_flag = 7;
pub const NIR_INTRINSIC_COMPONENT: nir_intrinsic_index_flag = 8;
pub const NIR_INTRINSIC_COLUMN: nir_intrinsic_index_flag = 9;
pub const NIR_INTRINSIC_INTERP_MODE: nir_intrinsic_index_flag = 10;
pub const NIR_INTRINSIC_REDUCTION_OP: nir_intrinsic_index_flag = 11;
pub const NIR_INTRINSIC_CLUSTER_SIZE: nir_intrinsic_index_flag = 12;
pub const NIR_INTRINSIC_PARAM_IDX: nir_intrinsic_index_flag = 13;
pub const NIR_INTRINSIC_IMAGE_DIM: nir_intrinsic_index_flag = 14;
pub const NIR_INTRINSIC_IMAGE_ARRAY: nir_intrinsic_index_flag = 15;
pub const NIR_INTRINSIC_FORMAT: nir_intrinsic_index_flag = 16;
pub const NIR_INTRINSIC_ACCESS: nir_intrinsic_index_flag = 17;
pub const NIR_INTRINSIC_CALL_IDX: nir_intrinsic_index_flag = 18;
pub const NIR_INTRINSIC_STACK_SIZE: nir_intrinsic_index_flag = 19;
pub const NIR_INTRINSIC_ALIGN_MUL: nir_intrinsic_index_flag = 20;
pub const NIR_INTRINSIC_ALIGN_OFFSET: nir_intrinsic_index_flag = 21;
pub const NIR_INTRINSIC_OFFSET_SHIFT: nir_intrinsic_index_flag = 22;
pub const NIR_INTRINSIC_DESC_TYPE: nir_intrinsic_index_flag = 23;
pub const NIR_INTRINSIC_SRC_TYPE: nir_intrinsic_index_flag = 24;
pub const NIR_INTRINSIC_DEST_TYPE: nir_intrinsic_index_flag = 25;
pub const NIR_INTRINSIC_SRC_BASE_TYPE: nir_intrinsic_index_flag = 26;
pub const NIR_INTRINSIC_SRC_BASE_TYPE2: nir_intrinsic_index_flag = 27;
pub const NIR_INTRINSIC_DEST_BASE_TYPE: nir_intrinsic_index_flag = 28;
pub const NIR_INTRINSIC_SWIZZLE_MASK: nir_intrinsic_index_flag = 29;
pub const NIR_INTRINSIC_FETCH_INACTIVE: nir_intrinsic_index_flag = 30;
pub const NIR_INTRINSIC_OFFSET0: nir_intrinsic_index_flag = 31;
pub const NIR_INTRINSIC_OFFSET1: nir_intrinsic_index_flag = 32;
pub const NIR_INTRINSIC_ST64: nir_intrinsic_index_flag = 33;
pub const NIR_INTRINSIC_ARG_UPPER_BOUND_U32_AMD: nir_intrinsic_index_flag = 34;
pub const NIR_INTRINSIC_DST_ACCESS: nir_intrinsic_index_flag = 35;
pub const NIR_INTRINSIC_SRC_ACCESS: nir_intrinsic_index_flag = 36;
pub const NIR_INTRINSIC_DRIVER_LOCATION: nir_intrinsic_index_flag = 37;
pub const NIR_INTRINSIC_MEMORY_SEMANTICS: nir_intrinsic_index_flag = 38;
pub const NIR_INTRINSIC_MEMORY_MODES: nir_intrinsic_index_flag = 39;
pub const NIR_INTRINSIC_MEMORY_SCOPE: nir_intrinsic_index_flag = 40;
pub const NIR_INTRINSIC_EXECUTION_SCOPE: nir_intrinsic_index_flag = 41;
pub const NIR_INTRINSIC_IO_SEMANTICS: nir_intrinsic_index_flag = 42;
pub const NIR_INTRINSIC_IO_XFB: nir_intrinsic_index_flag = 43;
pub const NIR_INTRINSIC_IO_XFB2: nir_intrinsic_index_flag = 44;
pub const NIR_INTRINSIC_RAY_QUERY_VALUE: nir_intrinsic_index_flag = 45;
pub const NIR_INTRINSIC_COMMITTED: nir_intrinsic_index_flag = 46;
pub const NIR_INTRINSIC_ROUNDING_MODE: nir_intrinsic_index_flag = 47;
pub const NIR_INTRINSIC_SATURATE: nir_intrinsic_index_flag = 48;
pub const NIR_INTRINSIC_SYNCHRONOUS: nir_intrinsic_index_flag = 49;
pub const NIR_INTRINSIC_VALUE_ID: nir_intrinsic_index_flag = 50;
pub const NIR_INTRINSIC_SIGN_EXTEND: nir_intrinsic_index_flag = 51;
pub const NIR_INTRINSIC_FLAGS: nir_intrinsic_index_flag = 52;
pub const NIR_INTRINSIC_ATOMIC_OP: nir_intrinsic_index_flag = 53;
pub const NIR_INTRINSIC_RESOURCE_BLOCK_INTEL: nir_intrinsic_index_flag = 54;
pub const NIR_INTRINSIC_RESOURCE_ACCESS_INTEL: nir_intrinsic_index_flag = 55;
pub const NIR_INTRINSIC_NUM_COMPONENTS: nir_intrinsic_index_flag = 56;
pub const NIR_INTRINSIC_NUM_ARRAY_ELEMS: nir_intrinsic_index_flag = 57;
pub const NIR_INTRINSIC_BIT_SIZE: nir_intrinsic_index_flag = 58;
pub const NIR_INTRINSIC_DIVERGENT: nir_intrinsic_index_flag = 59;
pub const NIR_INTRINSIC_LEGACY_FABS: nir_intrinsic_index_flag = 60;
pub const NIR_INTRINSIC_LEGACY_FNEG: nir_intrinsic_index_flag = 61;
pub const NIR_INTRINSIC_LEGACY_FSAT: nir_intrinsic_index_flag = 62;
pub const NIR_INTRINSIC_CMAT_DESC: nir_intrinsic_index_flag = 63;
pub const NIR_INTRINSIC_MATRIX_LAYOUT: nir_intrinsic_index_flag = 64;
pub const NIR_INTRINSIC_CMAT_SIGNED_MASK: nir_intrinsic_index_flag = 65;
pub const NIR_INTRINSIC_ALU_OP: nir_intrinsic_index_flag = 66;
pub const NIR_INTRINSIC_NEG_LO_AMD: nir_intrinsic_index_flag = 67;
pub const NIR_INTRINSIC_NEG_HI_AMD: nir_intrinsic_index_flag = 68;
pub const NIR_INTRINSIC_SYSTOLIC_DEPTH: nir_intrinsic_index_flag = 69;
pub const NIR_INTRINSIC_REPEAT_COUNT: nir_intrinsic_index_flag = 70;
pub const NIR_INTRINSIC_DST_CMAT_DESC: nir_intrinsic_index_flag = 71;
pub const NIR_INTRINSIC_SRC_CMAT_DESC: nir_intrinsic_index_flag = 72;
pub const NIR_INTRINSIC_EXPLICIT_COORD: nir_intrinsic_index_flag = 73;
pub const NIR_INTRINSIC_FMT_IDX: nir_intrinsic_index_flag = 74;
pub const NIR_INTRINSIC_NUM_MATRICES: nir_intrinsic_index_flag = 75;
pub const NIR_INTRINSIC_PREAMBLE_CLASS: nir_intrinsic_index_flag = 76;
pub const NIR_INTRINSIC_SMP_FLAGS_PCO: nir_intrinsic_index_flag = 77;
pub const NIR_INTRINSIC_MUTEX_ID_PCO: nir_intrinsic_index_flag = 78;
pub const NIR_INTRINSIC_MUTEX_OP_PCO: nir_intrinsic_index_flag = 79;
pub const NIR_INTRINSIC_FREEP: nir_intrinsic_index_flag = 80;
pub const NIR_INTRINSIC_SCALE: nir_intrinsic_index_flag = 81;
pub const NIR_INTRINSIC_ROUNDZERO: nir_intrinsic_index_flag = 82;
pub const NIR_INTRINSIC_NUM_INDEX_FLAGS: nir_intrinsic_index_flag = 83;
pub type nir_intrinsic_index_flag = ::std::os::raw::c_uint;
#[doc = " Represents an intrinsic\n\n An intrinsic is an instruction type for handling things that are\n more-or-less regular operations but don't just consume and produce SSA\n values like ALU operations do.  Intrinsics are not for things that have\n special semantic meaning such as phi nodes and parallel copies.\n Examples of intrinsics include variable load/store operations, system\n value loads, and the like.  Even though texturing more-or-less falls\n under this category, texturing is its own instruction type because\n trying to represent texturing with intrinsics would lead to a\n combinatorial explosion of intrinsic opcodes.\n\n By having a single instruction type for handling a lot of different\n cases, optimization passes can look for intrinsics and, for the most\n part, completely ignore them.  Each intrinsic type also has a few\n possible flags that govern whether or not they can be reordered or\n eliminated.  That way passes like dead code elimination can still work\n on intrisics without understanding the meaning of each.\n\n Each intrinsic has some number of constant indices, some number of\n variables, and some number of sources.  What these sources, variables,\n and indices mean depends on the intrinsic and is documented with the\n intrinsic declaration in nir_intrinsics.h.  Intrinsics and texture\n instructions are the only types of instruction that can operate on\n variables."]
#[repr(C)]
#[derive(Debug)]
pub struct nir_intrinsic_instr {
    pub instr: nir_instr,
    pub intrinsic: nir_intrinsic_op,
    pub def: nir_def,
    #[doc = " number of components if this is a vectorized intrinsic\n\n Similarly to ALU operations, some intrinsics are vectorized.\n An intrinsic is vectorized if nir_intrinsic_infos.dest_components == 0.\n For vectorized intrinsics, the num_components field specifies the\n number of destination components and the number of source components\n for all sources with nir_intrinsic_infos.src_components[i] == 0."]
    pub num_components: u8,
    pub const_index: [::std::os::raw::c_int; 8usize],
    pub name: *const ::std::os::raw::c_char,
    pub src: __IncompleteArrayField<nir_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_intrinsic_instr"][::std::mem::size_of::<nir_intrinsic_instr>() - 120usize];
    ["Alignment of nir_intrinsic_instr"][::std::mem::align_of::<nir_intrinsic_instr>() - 8usize];
    ["Offset of field: nir_intrinsic_instr::instr"]
        [::std::mem::offset_of!(nir_intrinsic_instr, instr) - 0usize];
    ["Offset of field: nir_intrinsic_instr::intrinsic"]
        [::std::mem::offset_of!(nir_intrinsic_instr, intrinsic) - 32usize];
    ["Offset of field: nir_intrinsic_instr::def"]
        [::std::mem::offset_of!(nir_intrinsic_instr, def) - 40usize];
    ["Offset of field: nir_intrinsic_instr::num_components"]
        [::std::mem::offset_of!(nir_intrinsic_instr, num_components) - 72usize];
    ["Offset of field: nir_intrinsic_instr::const_index"]
        [::std::mem::offset_of!(nir_intrinsic_instr, const_index) - 76usize];
    ["Offset of field: nir_intrinsic_instr::name"]
        [::std::mem::offset_of!(nir_intrinsic_instr, name) - 112usize];
    ["Offset of field: nir_intrinsic_instr::src"]
        [::std::mem::offset_of!(nir_intrinsic_instr, src) - 120usize];
};
impl Default for nir_intrinsic_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NIR_MEMORY_ACQUIRE: nir_memory_semantics = 1;
pub const NIR_MEMORY_RELEASE: nir_memory_semantics = 2;
pub const NIR_MEMORY_ACQ_REL: nir_memory_semantics = 3;
pub const NIR_MEMORY_MAKE_AVAILABLE: nir_memory_semantics = 4;
pub const NIR_MEMORY_MAKE_VISIBLE: nir_memory_semantics = 8;
pub type nir_memory_semantics = ::std::os::raw::c_uint;
#[doc = " whether the intrinsic can be safely eliminated if none of its output\n value is not being used."]
pub const NIR_INTRINSIC_CAN_ELIMINATE: nir_intrinsic_semantic_flag = 1;
#[doc = " Whether the intrinsic can be reordered with respect to any other\n intrinsic, i.e. whether the only reordering dependencies of the\n intrinsic are due to the register reads/writes."]
pub const NIR_INTRINSIC_CAN_REORDER: nir_intrinsic_semantic_flag = 2;
#[doc = " Identifies any subgroup-like operation whose behaviour depends on other\n logical threads. This is incompatible with CAN_REORDER."]
pub const NIR_INTRINSIC_SUBGROUP: nir_intrinsic_semantic_flag = 4;
#[doc = " Identifies an operation whose behaviour depends (only) on the local quad.\n Any QUADGROUP intrinsic is also SUBGROUP."]
pub const NIR_INTRINSIC_QUADGROUP: nir_intrinsic_semantic_flag = 8;
#[doc = " NIR intrinsics semantic flags\n\n information about what the compiler can do with the intrinsics.\n\n :c:member:`nir_intrinsic_info.flags`"]
pub type nir_intrinsic_semantic_flag = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_io_semantics {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_semantics"][::std::mem::size_of::<nir_io_semantics>() - 4usize];
    ["Alignment of nir_io_semantics"][::std::mem::align_of::<nir_io_semantics>() - 4usize];
};
impl nir_io_semantics {
    #[inline]
    pub fn location(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_location(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn location_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                7u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_location_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn num_slots(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_num_slots(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_slots_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                6u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_num_slots_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                6u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn dual_source_blend_index(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dual_source_blend_index(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn dual_source_blend_index_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_dual_source_blend_index_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output_coherent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output_coherent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_coherent_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_coherent_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn gs_streams(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gs_streams(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gs_streams_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gs_streams_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn medium_precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_medium_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn medium_precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_medium_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_view(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_view(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_view_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_view_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn high_16bits(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_16bits(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn high_16bits_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_high_16bits_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn high_dvec2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_dvec2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn high_dvec2_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_high_dvec2_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_varying(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_varying(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_varying_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_no_varying_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_sysval_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_sysval_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_sysval_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                29usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_no_sysval_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                29usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interp_explicit_strict(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interp_explicit_strict(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interp_explicit_strict_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interp_explicit_strict_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn _pad(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set__pad(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn _pad_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set__pad_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        location: ::std::os::raw::c_uint,
        num_slots: ::std::os::raw::c_uint,
        dual_source_blend_index: ::std::os::raw::c_uint,
        fb_fetch_output: ::std::os::raw::c_uint,
        fb_fetch_output_coherent: ::std::os::raw::c_uint,
        gs_streams: ::std::os::raw::c_uint,
        medium_precision: ::std::os::raw::c_uint,
        per_view: ::std::os::raw::c_uint,
        high_16bits: ::std::os::raw::c_uint,
        high_dvec2: ::std::os::raw::c_uint,
        no_varying: ::std::os::raw::c_uint,
        no_sysval_output: ::std::os::raw::c_uint,
        interp_explicit_strict: ::std::os::raw::c_uint,
        _pad: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let location: u32 = unsafe { ::std::mem::transmute(location) };
            location as u64
        });
        __bindgen_bitfield_unit.set(7usize, 6u8, {
            let num_slots: u32 = unsafe { ::std::mem::transmute(num_slots) };
            num_slots as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let dual_source_blend_index: u32 =
                unsafe { ::std::mem::transmute(dual_source_blend_index) };
            dual_source_blend_index as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let fb_fetch_output: u32 = unsafe { ::std::mem::transmute(fb_fetch_output) };
            fb_fetch_output as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let fb_fetch_output_coherent: u32 =
                unsafe { ::std::mem::transmute(fb_fetch_output_coherent) };
            fb_fetch_output_coherent as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let gs_streams: u32 = unsafe { ::std::mem::transmute(gs_streams) };
            gs_streams as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let medium_precision: u32 = unsafe { ::std::mem::transmute(medium_precision) };
            medium_precision as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let per_view: u32 = unsafe { ::std::mem::transmute(per_view) };
            per_view as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let high_16bits: u32 = unsafe { ::std::mem::transmute(high_16bits) };
            high_16bits as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let high_dvec2: u32 = unsafe { ::std::mem::transmute(high_dvec2) };
            high_dvec2 as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let no_varying: u32 = unsafe { ::std::mem::transmute(no_varying) };
            no_varying as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let no_sysval_output: u32 = unsafe { ::std::mem::transmute(no_sysval_output) };
            no_sysval_output as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let interp_explicit_strict: u32 =
                unsafe { ::std::mem::transmute(interp_explicit_strict) };
            interp_explicit_strict as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let _pad: u32 = unsafe { ::std::mem::transmute(_pad) };
            _pad as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_io_xfb {
    pub out: [nir_io_xfb__bindgen_ty_1; 2usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_io_xfb__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub offset: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_xfb__bindgen_ty_1"]
        [::std::mem::size_of::<nir_io_xfb__bindgen_ty_1>() - 2usize];
    ["Alignment of nir_io_xfb__bindgen_ty_1"]
        [::std::mem::align_of::<nir_io_xfb__bindgen_ty_1>() - 1usize];
    ["Offset of field: nir_io_xfb__bindgen_ty_1::offset"]
        [::std::mem::offset_of!(nir_io_xfb__bindgen_ty_1, offset) - 1usize];
};
impl nir_io_xfb__bindgen_ty_1 {
    #[inline]
    pub fn num_components(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_num_components(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_components_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_num_components_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn buffer(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_buffer(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn buffer_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_buffer_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(num_components: u8, buffer: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let num_components: u8 = unsafe { ::std::mem::transmute(num_components) };
            num_components as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let buffer: u8 = unsafe { ::std::mem::transmute(buffer) };
            buffer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_xfb"][::std::mem::size_of::<nir_io_xfb>() - 4usize];
    ["Alignment of nir_io_xfb"][::std::mem::align_of::<nir_io_xfb>() - 1usize];
    ["Offset of field: nir_io_xfb::out"][::std::mem::offset_of!(nir_io_xfb, out) - 0usize];
};
unsafe extern "C" {
    pub fn nir_instr_xfb_write_mask(instr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_intrinsic_info {
    pub name: *const ::std::os::raw::c_char,
    #[doc = " number of register/SSA inputs"]
    pub num_srcs: u8,
    #[doc = " number of components of each input register\n\n If this value is 0, the number of components is given by the\n num_components field of nir_intrinsic_instr.  If this value is -1, the\n intrinsic consumes however many components are provided and it is not\n validated at all."]
    pub src_components: [i8; 11usize],
    pub has_dest: bool,
    #[doc = " number of components of the output register\n\n If this value is 0, the number of components is given by the\n num_components field of nir_intrinsic_instr."]
    pub dest_components: u8,
    #[doc = " bitfield of legal bit sizes"]
    pub dest_bit_sizes: u8,
    #[doc = " source which the destination bit size must match\n\n Some intrinsics, such as subgroup intrinsics, are data manipulation\n intrinsics and they have similar bit-size rules to ALU ops. This enables\n validation to validate a bit more and enables auto-generated builder code\n to properly determine destination bit sizes automatically."]
    pub bit_size_src: i8,
    #[doc = " the number of constant indices used by the intrinsic"]
    pub num_indices: u8,
    #[doc = " list of indices"]
    pub indices: [u8; 8usize],
    #[doc = " indicates the usage of intr->const_index[n]"]
    pub index_map: [u8; 83usize],
    #[doc = " semantic flags for calls to this intrinsic"]
    pub flags: nir_intrinsic_semantic_flag,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_intrinsic_info"][::std::mem::size_of::<nir_intrinsic_info>() - 120usize];
    ["Alignment of nir_intrinsic_info"][::std::mem::align_of::<nir_intrinsic_info>() - 8usize];
    ["Offset of field: nir_intrinsic_info::name"]
        [::std::mem::offset_of!(nir_intrinsic_info, name) - 0usize];
    ["Offset of field: nir_intrinsic_info::num_srcs"]
        [::std::mem::offset_of!(nir_intrinsic_info, num_srcs) - 8usize];
    ["Offset of field: nir_intrinsic_info::src_components"]
        [::std::mem::offset_of!(nir_intrinsic_info, src_components) - 9usize];
    ["Offset of field: nir_intrinsic_info::has_dest"]
        [::std::mem::offset_of!(nir_intrinsic_info, has_dest) - 20usize];
    ["Offset of field: nir_intrinsic_info::dest_components"]
        [::std::mem::offset_of!(nir_intrinsic_info, dest_components) - 21usize];
    ["Offset of field: nir_intrinsic_info::dest_bit_sizes"]
        [::std::mem::offset_of!(nir_intrinsic_info, dest_bit_sizes) - 22usize];
    ["Offset of field: nir_intrinsic_info::bit_size_src"]
        [::std::mem::offset_of!(nir_intrinsic_info, bit_size_src) - 23usize];
    ["Offset of field: nir_intrinsic_info::num_indices"]
        [::std::mem::offset_of!(nir_intrinsic_info, num_indices) - 24usize];
    ["Offset of field: nir_intrinsic_info::indices"]
        [::std::mem::offset_of!(nir_intrinsic_info, indices) - 25usize];
    ["Offset of field: nir_intrinsic_info::index_map"]
        [::std::mem::offset_of!(nir_intrinsic_info, index_map) - 33usize];
    ["Offset of field: nir_intrinsic_info::flags"]
        [::std::mem::offset_of!(nir_intrinsic_info, flags) - 116usize];
};
impl Default for nir_intrinsic_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub static nir_intrinsic_infos: [nir_intrinsic_info; 780usize];
}
unsafe extern "C" {
    pub fn nir_intrinsic_src_components(
        intr: *const nir_intrinsic_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_intrinsic_dest_components(intr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_src_type(
        intrin: *const nir_intrinsic_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_dest_type(intrin: *const nir_intrinsic_instr) -> nir_alu_type;
}
unsafe extern "C" {
    #[doc = " Helper to copy const_index[] from src to dst, without assuming they\n match in order."]
    pub fn nir_intrinsic_copy_const_indices(
        dst: *mut nir_intrinsic_instr,
        src: *mut nir_intrinsic_instr,
    );
}
unsafe extern "C" {
    pub fn nir_image_intrinsic_coord_components(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_rewrite_image_intrinsic(
        instr: *mut nir_intrinsic_instr,
        handle: *mut nir_def,
        bindless: bool,
    );
}
unsafe extern "C" {
    pub fn nir_intrinsic_can_reorder(instr: *mut nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_instr_can_speculate(instr: *mut nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_intrinsic_writes_external_memory(instr: *const nir_intrinsic_instr) -> bool;
}
#[doc = " Texture coordinate\n\n Must have :c:member:`nir_tex_instr.coord_components` components."]
pub const nir_tex_src_coord: nir_tex_src_type = 0;
#[doc = " Projector\n\n The texture coordinate (except for the array component, if any) is\n divided by this value before LOD computation and sampling.\n\n Must be a float scalar."]
pub const nir_tex_src_projector: nir_tex_src_type = 1;
#[doc = " Shadow comparator\n\n For shadow sampling, the fetched texel values are compared against the\n shadow comparator using the compare op specified by the sampler object\n and converted to 1.0 if the comparison succeeds and 0.0 if it fails.\n Interpolation happens after this conversion so the actual result may be\n anywhere in the range [0.0, 1.0].\n\n Only valid if :c:member:`nir_tex_instr.is_shadow` and must be a float\n scalar."]
pub const nir_tex_src_comparator: nir_tex_src_type = 2;
#[doc = " Coordinate offset\n\n An integer value that is added to the texel address before sampling.\n This is only allowed with operations that take an explicit LOD as it is\n applied in integer texel space after LOD selection and not normalized\n coordinate space."]
pub const nir_tex_src_offset: nir_tex_src_type = 3;
#[doc = " LOD bias\n\n This value is added to the computed LOD before mip-mapping."]
pub const nir_tex_src_bias: nir_tex_src_type = 4;
#[doc = " Explicit LOD"]
pub const nir_tex_src_lod: nir_tex_src_type = 5;
#[doc = " Min LOD\n\n The computed LOD is clamped to be at least as large as min_lod before\n mip-mapping."]
pub const nir_tex_src_min_lod: nir_tex_src_type = 6;
#[doc = " LOD bias + min LOD packed together into 32-bits. This is the common case\n for texturing on Honeykrisp with DX12, where both LOD bias and min LOD are\n emulated and passed in a single hardware source together. So it's\n important to optimize so e.g. nir_opt_preamble can make good decisions\n that avoid extra moves."]
pub const nir_tex_src_lod_bias_min_agx: nir_tex_src_type = 7;
#[doc = " MSAA sample index"]
pub const nir_tex_src_ms_index: nir_tex_src_type = 8;
#[doc = " Intel-specific MSAA compression data"]
pub const nir_tex_src_ms_mcs_intel: nir_tex_src_type = 9;
#[doc = " Explicit horizontal (X-major) coordinate derivative"]
pub const nir_tex_src_ddx: nir_tex_src_type = 10;
#[doc = " Explicit vertical (Y-major) coordinate derivative"]
pub const nir_tex_src_ddy: nir_tex_src_type = 11;
#[doc = " Texture variable dereference"]
pub const nir_tex_src_texture_deref: nir_tex_src_type = 12;
#[doc = " Sampler variable dereference"]
pub const nir_tex_src_sampler_deref: nir_tex_src_type = 13;
#[doc = " Texture index offset\n\n This is added to :c:member:`nir_tex_instr.texture_index`.  Unless\n :c:member:`nir_tex_instr.texture_non_uniform` is set, this is guaranteed\n to be dynamically uniform."]
pub const nir_tex_src_texture_offset: nir_tex_src_type = 14;
#[doc = " Dynamically uniform sampler index offset\n\n This is added to :c:member:`nir_tex_instr.sampler_index`.  Unless\n :c:member:`nir_tex_instr.sampler_non_uniform` is set, this is guaranteed to be\n dynamically uniform.  This should not be present until GLSL ES 3.20, GLSL\n 4.00, or ARB_gpu_shader5, because in ES 3.10 and GL 3.30 samplers said\n \"When aggregated into arrays within a shader, samplers can only be indexed\n with a constant integral expression.\""]
pub const nir_tex_src_sampler_offset: nir_tex_src_type = 15;
#[doc = " Bindless texture handle\n\n This is, unfortunately, a bit overloaded at the moment.  There are\n generally two types of bindless handles:\n\n  1. For GL_ARB_bindless bindless handles. These are part of the\n     GL/Gallium-level API and are always a 64-bit integer.\n\n  2. HW-specific handles.  GL_ARB_bindless handles may be lowered to\n     these.  Also, these are used by many Vulkan drivers to implement\n     descriptor sets, especially for UPDATE_AFTER_BIND descriptors.\n     The details of hardware handles (bit size, format, etc.) is\n     HW-specific.\n\n Because of this overloading and the resulting ambiguity, we currently\n don't validate anything for these."]
pub const nir_tex_src_texture_handle: nir_tex_src_type = 16;
#[doc = " Bindless sampler handle\n\n See nir_tex_src_texture_handle,"]
pub const nir_tex_src_sampler_handle: nir_tex_src_type = 17;
#[doc = " Tex src intrinsic\n\n This is an intrinsic used before function inlining i.e. before we know\n if a bindless value has been given as function param for use as a tex\n src."]
pub const nir_tex_src_sampler_deref_intrinsic: nir_tex_src_type = 18;
#[doc = " Tex src intrinsic\n\n This is an intrinsic used before function inlining i.e. before we know\n if a bindless value has been given as function param for use as a tex\n src."]
pub const nir_tex_src_texture_deref_intrinsic: nir_tex_src_type = 19;
#[doc = " Plane index for multi-plane YCbCr textures"]
pub const nir_tex_src_plane: nir_tex_src_type = 20;
#[doc = " Backend-specific vec4 tex src argument.\n\n Can be used to have NIR optimization (copy propagation, lower_vec_to_regs)\n apply to the packing of the tex srcs.  This lowering must only happen\n after nir_lower_tex().\n\n The nir_tex_instr_src_type() of this argument is float, so no lowering\n will happen if nir_lower_int_to_float is used."]
pub const nir_tex_src_backend1: nir_tex_src_type = 21;
#[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
pub const nir_tex_src_backend2: nir_tex_src_type = 22;
#[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
pub const nir_num_tex_src_types: nir_tex_src_type = 23;
#[doc = " Texture instruction source type"]
pub type nir_tex_src_type = ::std::os::raw::c_uint;
#[doc = " A texture instruction source"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_tex_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " Type of this source"]
    pub src_type: nir_tex_src_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_src"][::std::mem::size_of::<nir_tex_src>() - 40usize];
    ["Alignment of nir_tex_src"][::std::mem::align_of::<nir_tex_src>() - 8usize];
    ["Offset of field: nir_tex_src::src"][::std::mem::offset_of!(nir_tex_src, src) - 0usize];
    ["Offset of field: nir_tex_src::src_type"]
        [::std::mem::offset_of!(nir_tex_src, src_type) - 32usize];
};
impl Default for nir_tex_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Regular texture look-up"]
pub const nir_texop_tex: nir_texop = 0;
#[doc = " Texture look-up with LOD bias"]
pub const nir_texop_txb: nir_texop = 1;
#[doc = " Texture look-up with explicit LOD"]
pub const nir_texop_txl: nir_texop = 2;
#[doc = " Texture look-up with partial derivatives"]
pub const nir_texop_txd: nir_texop = 3;
#[doc = " Texel fetch with explicit LOD"]
pub const nir_texop_txf: nir_texop = 4;
#[doc = " Multisample texture fetch"]
pub const nir_texop_txf_ms: nir_texop = 5;
#[doc = " Multisample texture fetch from framebuffer"]
pub const nir_texop_txf_ms_fb: nir_texop = 6;
#[doc = " Multisample compression value fetch"]
pub const nir_texop_txf_ms_mcs_intel: nir_texop = 7;
#[doc = " Texture size"]
pub const nir_texop_txs: nir_texop = 8;
#[doc = " Texture lod query"]
pub const nir_texop_lod: nir_texop = 9;
#[doc = " Texture gather"]
pub const nir_texop_tg4: nir_texop = 10;
#[doc = " Texture levels query"]
pub const nir_texop_query_levels: nir_texop = 11;
#[doc = " Texture samples query"]
pub const nir_texop_texture_samples: nir_texop = 12;
#[doc = " Query whether all samples are definitely identical."]
pub const nir_texop_samples_identical: nir_texop = 13;
#[doc = " Regular texture look-up, eligible for pre-dispatch"]
pub const nir_texop_tex_prefetch: nir_texop = 14;
#[doc = " Returns the sampler's LOD bias (if sampler LOD bias is lowered)"]
pub const nir_texop_lod_bias: nir_texop = 15;
#[doc = " Multisample fragment color texture fetch"]
pub const nir_texop_fragment_fetch_amd: nir_texop = 16;
#[doc = " Multisample fragment mask texture fetch"]
pub const nir_texop_fragment_mask_fetch_amd: nir_texop = 17;
#[doc = " Returns a buffer or image descriptor."]
pub const nir_texop_descriptor_amd: nir_texop = 18;
#[doc = " Returns a sampler descriptor."]
pub const nir_texop_sampler_descriptor_amd: nir_texop = 19;
#[doc = " Returns the image view's min LOD"]
pub const nir_texop_image_min_lod_agx: nir_texop = 20;
#[doc = " Returns a bool indicating that the sampler uses a custom border colour"]
pub const nir_texop_has_custom_border_color_agx: nir_texop = 21;
#[doc = " Returns the sampler's custom border colour (if has_custom_border_agx)"]
pub const nir_texop_custom_border_color_agx: nir_texop = 22;
#[doc = " Maps to TXQ.DIMENSION"]
pub const nir_texop_hdr_dim_nv: nir_texop = 23;
#[doc = " Maps to TXQ.TEXTURE_TYPE"]
pub const nir_texop_tex_type_nv: nir_texop = 24;
#[doc = " Maps to TXQ.SAMPLER_POS"]
pub const nir_texop_sample_pos_nv: nir_texop = 25;
#[doc = " Texture instruction opcode"]
pub type nir_texop = ::std::os::raw::c_uint;
#[doc = " Represents a texture instruction"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_tex_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Dimensionality of the texture operation\n\n This will typically match the dimensionality of the texture deref type\n if a nir_tex_src_texture_deref is present.  However, it may not if\n texture lowering has occurred."]
    pub sampler_dim: glsl_sampler_dim,
    #[doc = " ALU type of the destination\n\n This is the canonical sampled type for this texture operation and may\n not exactly match the sampled type of the deref type when a\n nir_tex_src_texture_deref is present.  For OpenCL, the sampled type of\n the texture deref will be GLSL_TYPE_VOID and this is allowed to be\n anything.  With SPIR-V, the signedness of integer types is allowed to\n differ.  For all APIs, the bit size may differ if the driver has done\n any sort of mediump or similar lowering since texture types always have\n 32-bit sampled types."]
    pub dest_type: nir_alu_type,
    #[doc = " Texture opcode"]
    pub op: nir_texop,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Array of sources\n\n This array has :c:member:`nir_tex_instr.num_srcs` elements"]
    pub src: *mut nir_tex_src,
    #[doc = " Number of sources"]
    pub num_srcs: ::std::os::raw::c_uint,
    #[doc = " Number of components in the coordinate, if any"]
    pub coord_components: ::std::os::raw::c_uint,
    #[doc = " True if the texture instruction acts on an array texture"]
    pub is_array: bool,
    #[doc = " True if the texture instruction performs a shadow comparison\n\n If this is true, the texture instruction must have a\n nir_tex_src_comparator."]
    pub is_shadow: bool,
    #[doc = " If is_shadow is true, whether this is the old-style shadow that outputs\n 4 components or the new-style shadow that outputs 1 component."]
    pub is_new_style_shadow: bool,
    #[doc = " True if this texture instruction should return a sparse residency code.\n The code is in the last component of the result."]
    pub is_sparse: bool,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Gather offsets"]
    pub tg4_offsets: [[i8; 2usize]; 4usize],
    #[doc = " True if the texture index or handle is not dynamically uniform"]
    pub texture_non_uniform: bool,
    #[doc = " True if the sampler index or handle is not dynamically uniform.\n\n This may be set when VK_EXT_descriptor_indexing is supported and the\n appropriate capability is enabled.\n\n This should always be false in GLSL (GLSL ES 3.20 says \"When aggregated\n into arrays within a shader, opaque types can only be indexed with a\n dynamically uniform integral expression\", and GLSL 4.60 says \"When\n aggregated into arrays within a shader, [texture, sampler, and\n samplerShadow] types can only be indexed with a dynamically uniform\n expression, or texture lookup will result in undefined values.\")."]
    pub sampler_non_uniform: bool,
    #[doc = " True if the offset is not dynamically uniform"]
    pub offset_non_uniform: bool,
    #[doc = " True whether this returns the same result anywhere in the shader and\n  doesn't cause page faults."]
    pub can_speculate: bool,
    #[doc = " The texture index\n\n If this texture instruction has a nir_tex_src_texture_offset source,\n then the texture index is given by texture_index + texture_offset."]
    pub texture_index: ::std::os::raw::c_uint,
    #[doc = " The sampler index\n\n The following operations do not require a sampler and, as such, this\n field should be ignored:\n\n    - nir_texop_txf\n    - nir_texop_txf_ms\n    - nir_texop_txs\n    - nir_texop_query_levels\n    - nir_texop_texture_samples\n    - nir_texop_samples_identical\n\n If this texture instruction has a nir_tex_src_sampler_offset source,\n then the sampler index is given by sampler_index + sampler_offset."]
    pub sampler_index: ::std::os::raw::c_uint,
    pub backend_flags: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_instr"][::std::mem::size_of::<nir_tex_instr>() - 128usize];
    ["Alignment of nir_tex_instr"][::std::mem::align_of::<nir_tex_instr>() - 8usize];
    ["Offset of field: nir_tex_instr::instr"]
        [::std::mem::offset_of!(nir_tex_instr, instr) - 0usize];
    ["Offset of field: nir_tex_instr::sampler_dim"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_dim) - 32usize];
    ["Offset of field: nir_tex_instr::dest_type"]
        [::std::mem::offset_of!(nir_tex_instr, dest_type) - 36usize];
    ["Offset of field: nir_tex_instr::op"][::std::mem::offset_of!(nir_tex_instr, op) - 40usize];
    ["Offset of field: nir_tex_instr::def"][::std::mem::offset_of!(nir_tex_instr, def) - 48usize];
    ["Offset of field: nir_tex_instr::src"][::std::mem::offset_of!(nir_tex_instr, src) - 80usize];
    ["Offset of field: nir_tex_instr::num_srcs"]
        [::std::mem::offset_of!(nir_tex_instr, num_srcs) - 88usize];
    ["Offset of field: nir_tex_instr::coord_components"]
        [::std::mem::offset_of!(nir_tex_instr, coord_components) - 92usize];
    ["Offset of field: nir_tex_instr::is_array"]
        [::std::mem::offset_of!(nir_tex_instr, is_array) - 96usize];
    ["Offset of field: nir_tex_instr::is_shadow"]
        [::std::mem::offset_of!(nir_tex_instr, is_shadow) - 97usize];
    ["Offset of field: nir_tex_instr::is_new_style_shadow"]
        [::std::mem::offset_of!(nir_tex_instr, is_new_style_shadow) - 98usize];
    ["Offset of field: nir_tex_instr::is_sparse"]
        [::std::mem::offset_of!(nir_tex_instr, is_sparse) - 99usize];
    ["Offset of field: nir_tex_instr::tg4_offsets"]
        [::std::mem::offset_of!(nir_tex_instr, tg4_offsets) - 101usize];
    ["Offset of field: nir_tex_instr::texture_non_uniform"]
        [::std::mem::offset_of!(nir_tex_instr, texture_non_uniform) - 109usize];
    ["Offset of field: nir_tex_instr::sampler_non_uniform"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_non_uniform) - 110usize];
    ["Offset of field: nir_tex_instr::offset_non_uniform"]
        [::std::mem::offset_of!(nir_tex_instr, offset_non_uniform) - 111usize];
    ["Offset of field: nir_tex_instr::can_speculate"]
        [::std::mem::offset_of!(nir_tex_instr, can_speculate) - 112usize];
    ["Offset of field: nir_tex_instr::texture_index"]
        [::std::mem::offset_of!(nir_tex_instr, texture_index) - 116usize];
    ["Offset of field: nir_tex_instr::sampler_index"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_index) - 120usize];
    ["Offset of field: nir_tex_instr::backend_flags"]
        [::std::mem::offset_of!(nir_tex_instr, backend_flags) - 124usize];
};
impl Default for nir_tex_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_tex_instr {
    #[inline]
    pub fn component(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_component(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn component_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_component_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn array_is_lowered_cube(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_array_is_lowered_cube(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn array_is_lowered_cube_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_array_is_lowered_cube_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_gather_implicit_lod(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_gather_implicit_lod(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_gather_implicit_lod_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_gather_implicit_lod_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn skip_helpers(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_helpers(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn skip_helpers_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_skip_helpers_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        component: ::std::os::raw::c_uint,
        array_is_lowered_cube: ::std::os::raw::c_uint,
        is_gather_implicit_lod: ::std::os::raw::c_uint,
        skip_helpers: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let component: u32 = unsafe { ::std::mem::transmute(component) };
            component as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let array_is_lowered_cube: u32 =
                unsafe { ::std::mem::transmute(array_is_lowered_cube) };
            array_is_lowered_cube as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_gather_implicit_lod: u32 =
                unsafe { ::std::mem::transmute(is_gather_implicit_lod) };
            is_gather_implicit_lod as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let skip_helpers: u32 = unsafe { ::std::mem::transmute(skip_helpers) };
            skip_helpers as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    #[doc = " Returns true if the texture operation requires a sampler as a general rule\n\n Note that the specific hw/driver backend could require to a sampler\n object/configuration packet in any case, for some other reason.\n\n See also :c:member:`nir_tex_instr.sampler_index`."]
    pub fn nir_tex_instr_need_sampler(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns the number of components returned by this nir_tex_instr\n\n Useful for code building texture instructions when you don't want to think\n about how many components a particular texture op returns.  This does not\n include the sparse residency code."]
    pub fn nir_tex_instr_result_size(instr: *const nir_tex_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Returns true if this texture operation queries something about the texture\n rather than actually sampling it."]
    pub fn nir_tex_instr_is_query(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if this texture instruction does implicit derivatives\n\n This is important as there are extra control-flow rules around derivatives\n and texture instructions which perform them implicitly."]
    pub fn nir_tex_instr_has_implicit_derivative(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns the ALU type of the given texture instruction source"]
    pub fn nir_tex_instr_src_type(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
unsafe extern "C" {
    #[doc = " Returns the number of components required by the given texture instruction\n source"]
    pub fn nir_tex_instr_src_size(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Adds a source to a texture instruction"]
    pub fn nir_tex_instr_add_src(
        tex: *mut nir_tex_instr,
        src_type: nir_tex_src_type,
        src: *mut nir_def,
    );
}
unsafe extern "C" {
    #[doc = " Removes a source from a texture instruction"]
    pub fn nir_tex_instr_remove_src(tex: *mut nir_tex_instr, src_idx: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn nir_tex_instr_has_explicit_tg4_offsets(tex: *mut nir_tex_instr) -> bool;
}
#[repr(C)]
pub struct nir_load_const_instr {
    pub instr: nir_instr,
    pub def: nir_def,
    pub value: __IncompleteArrayField<nir_const_value>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_load_const_instr"][::std::mem::size_of::<nir_load_const_instr>() - 64usize];
    ["Alignment of nir_load_const_instr"][::std::mem::align_of::<nir_load_const_instr>() - 8usize];
    ["Offset of field: nir_load_const_instr::instr"]
        [::std::mem::offset_of!(nir_load_const_instr, instr) - 0usize];
    ["Offset of field: nir_load_const_instr::def"]
        [::std::mem::offset_of!(nir_load_const_instr, def) - 32usize];
    ["Offset of field: nir_load_const_instr::value"]
        [::std::mem::offset_of!(nir_load_const_instr, value) - 64usize];
};
impl Default for nir_load_const_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Return from a function\n\n This instruction is a classic function return.  It jumps to\n nir_function_impl::end_block.  No return value is provided in this\n instruction.  Instead, the function is expected to write any return\n data to a deref passed in from the caller."]
pub const nir_jump_return: nir_jump_type = 0;
#[doc = " Immediately exit the current shader\n\n This instruction is roughly the equivalent of C's \"exit()\" in that it\n immediately terminates the current shader invocation.  From a CFG\n perspective, it looks like a jump to nir_function_impl::end_block but\n it actually jumps to the end block of the shader entrypoint.  A halt\n instruction in the shader entrypoint itself is semantically identical\n to a return.\n\n For shaders with built-in I/O, any outputs written prior to a halt\n instruction remain written and any outputs not written prior to the\n halt have undefined values.  It does NOT cause an implicit discard of\n written results.  If one wants discard results in a fragment shader,\n for instance, a discard or demote intrinsic is required."]
pub const nir_jump_halt: nir_jump_type = 1;
#[doc = " Break out of the inner-most loop\n\n This has the same semantics as C's \"break\" statement."]
pub const nir_jump_break: nir_jump_type = 2;
#[doc = " Jump back to the top of the inner-most loop\n\n This has the same semantics as C's \"continue\" statement assuming that a\n NIR loop is implemented as \"while (1) { body }\"."]
pub const nir_jump_continue: nir_jump_type = 3;
#[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
pub const nir_jump_goto: nir_jump_type = 4;
#[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
pub const nir_jump_goto_if: nir_jump_type = 5;
pub type nir_jump_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_jump_instr {
    pub instr: nir_instr,
    pub type_: nir_jump_type,
    pub condition: nir_src,
    pub target: *mut nir_block,
    pub else_target: *mut nir_block,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_jump_instr"][::std::mem::size_of::<nir_jump_instr>() - 88usize];
    ["Alignment of nir_jump_instr"][::std::mem::align_of::<nir_jump_instr>() - 8usize];
    ["Offset of field: nir_jump_instr::instr"]
        [::std::mem::offset_of!(nir_jump_instr, instr) - 0usize];
    ["Offset of field: nir_jump_instr::type_"]
        [::std::mem::offset_of!(nir_jump_instr, type_) - 32usize];
    ["Offset of field: nir_jump_instr::condition"]
        [::std::mem::offset_of!(nir_jump_instr, condition) - 40usize];
    ["Offset of field: nir_jump_instr::target"]
        [::std::mem::offset_of!(nir_jump_instr, target) - 72usize];
    ["Offset of field: nir_jump_instr::else_target"]
        [::std::mem::offset_of!(nir_jump_instr, else_target) - 80usize];
};
impl Default for nir_jump_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_undef_instr {
    pub instr: nir_instr,
    pub def: nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_undef_instr"][::std::mem::size_of::<nir_undef_instr>() - 64usize];
    ["Alignment of nir_undef_instr"][::std::mem::align_of::<nir_undef_instr>() - 8usize];
    ["Offset of field: nir_undef_instr::instr"]
        [::std::mem::offset_of!(nir_undef_instr, instr) - 0usize];
    ["Offset of field: nir_undef_instr::def"]
        [::std::mem::offset_of!(nir_undef_instr, def) - 32usize];
};
impl Default for nir_undef_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_phi_src {
    pub node: exec_node,
    pub pred: *mut nir_block,
    pub src: nir_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_phi_src"][::std::mem::size_of::<nir_phi_src>() - 56usize];
    ["Alignment of nir_phi_src"][::std::mem::align_of::<nir_phi_src>() - 8usize];
    ["Offset of field: nir_phi_src::node"][::std::mem::offset_of!(nir_phi_src, node) - 0usize];
    ["Offset of field: nir_phi_src::pred"][::std::mem::offset_of!(nir_phi_src, pred) - 16usize];
    ["Offset of field: nir_phi_src::src"][::std::mem::offset_of!(nir_phi_src, src) - 24usize];
};
impl Default for nir_phi_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_phi_instr {
    pub instr: nir_instr,
    #[doc = " list of nir_phi_src"]
    pub srcs: exec_list,
    pub def: nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_phi_instr"][::std::mem::size_of::<nir_phi_instr>() - 96usize];
    ["Alignment of nir_phi_instr"][::std::mem::align_of::<nir_phi_instr>() - 8usize];
    ["Offset of field: nir_phi_instr::instr"]
        [::std::mem::offset_of!(nir_phi_instr, instr) - 0usize];
    ["Offset of field: nir_phi_instr::srcs"][::std::mem::offset_of!(nir_phi_instr, srcs) - 32usize];
    ["Offset of field: nir_phi_instr::def"][::std::mem::offset_of!(nir_phi_instr, def) - 64usize];
};
impl Default for nir_phi_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_parallel_copy_entry {
    pub node: exec_node,
    pub src_is_reg: bool,
    pub dest_is_reg: bool,
    pub src: nir_src,
    pub dest: nir_parallel_copy_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_parallel_copy_entry__bindgen_ty_1 {
    pub def: nir_def,
    pub reg: nir_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parallel_copy_entry__bindgen_ty_1"]
        [::std::mem::size_of::<nir_parallel_copy_entry__bindgen_ty_1>() - 32usize];
    ["Alignment of nir_parallel_copy_entry__bindgen_ty_1"]
        [::std::mem::align_of::<nir_parallel_copy_entry__bindgen_ty_1>() - 8usize];
    ["Offset of field: nir_parallel_copy_entry__bindgen_ty_1::def"]
        [::std::mem::offset_of!(nir_parallel_copy_entry__bindgen_ty_1, def) - 0usize];
    ["Offset of field: nir_parallel_copy_entry__bindgen_ty_1::reg"]
        [::std::mem::offset_of!(nir_parallel_copy_entry__bindgen_ty_1, reg) - 0usize];
};
impl Default for nir_parallel_copy_entry__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parallel_copy_entry"][::std::mem::size_of::<nir_parallel_copy_entry>() - 88usize];
    ["Alignment of nir_parallel_copy_entry"]
        [::std::mem::align_of::<nir_parallel_copy_entry>() - 8usize];
    ["Offset of field: nir_parallel_copy_entry::node"]
        [::std::mem::offset_of!(nir_parallel_copy_entry, node) - 0usize];
    ["Offset of field: nir_parallel_copy_entry::src_is_reg"]
        [::std::mem::offset_of!(nir_parallel_copy_entry, src_is_reg) - 16usize];
    ["Offset of field: nir_parallel_copy_entry::dest_is_reg"]
        [::std::mem::offset_of!(nir_parallel_copy_entry, dest_is_reg) - 17usize];
    ["Offset of field: nir_parallel_copy_entry::src"]
        [::std::mem::offset_of!(nir_parallel_copy_entry, src) - 24usize];
    ["Offset of field: nir_parallel_copy_entry::dest"]
        [::std::mem::offset_of!(nir_parallel_copy_entry, dest) - 56usize];
};
impl Default for nir_parallel_copy_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_parallel_copy_instr {
    pub instr: nir_instr,
    pub entries: exec_list,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parallel_copy_instr"][::std::mem::size_of::<nir_parallel_copy_instr>() - 64usize];
    ["Alignment of nir_parallel_copy_instr"]
        [::std::mem::align_of::<nir_parallel_copy_instr>() - 8usize];
    ["Offset of field: nir_parallel_copy_instr::instr"]
        [::std::mem::offset_of!(nir_parallel_copy_instr, instr) - 0usize];
    ["Offset of field: nir_parallel_copy_instr::entries"]
        [::std::mem::offset_of!(nir_parallel_copy_instr, entries) - 32usize];
};
impl Default for nir_parallel_copy_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_instr_debug_info {
    pub filename: *mut ::std::os::raw::c_char,
    pub line: u32,
    pub column: u32,
    pub spirv_offset: u32,
    pub nir_line: u32,
    pub variable_name: *mut ::std::os::raw::c_char,
    pub instr: nir_instr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_instr_debug_info"][::std::mem::size_of::<nir_instr_debug_info>() - 64usize];
    ["Alignment of nir_instr_debug_info"][::std::mem::align_of::<nir_instr_debug_info>() - 8usize];
    ["Offset of field: nir_instr_debug_info::filename"]
        [::std::mem::offset_of!(nir_instr_debug_info, filename) - 0usize];
    ["Offset of field: nir_instr_debug_info::line"]
        [::std::mem::offset_of!(nir_instr_debug_info, line) - 8usize];
    ["Offset of field: nir_instr_debug_info::column"]
        [::std::mem::offset_of!(nir_instr_debug_info, column) - 12usize];
    ["Offset of field: nir_instr_debug_info::spirv_offset"]
        [::std::mem::offset_of!(nir_instr_debug_info, spirv_offset) - 16usize];
    ["Offset of field: nir_instr_debug_info::nir_line"]
        [::std::mem::offset_of!(nir_instr_debug_info, nir_line) - 20usize];
    ["Offset of field: nir_instr_debug_info::variable_name"]
        [::std::mem::offset_of!(nir_instr_debug_info, variable_name) - 24usize];
    ["Offset of field: nir_instr_debug_info::instr"]
        [::std::mem::offset_of!(nir_instr_debug_info, instr) - 32usize];
};
impl Default for nir_instr_debug_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_scalar {
    pub def: *mut nir_def,
    pub comp: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_scalar"][::std::mem::size_of::<nir_scalar>() - 16usize];
    ["Alignment of nir_scalar"][::std::mem::align_of::<nir_scalar>() - 8usize];
    ["Offset of field: nir_scalar::def"][::std::mem::offset_of!(nir_scalar, def) - 0usize];
    ["Offset of field: nir_scalar::comp"][::std::mem::offset_of!(nir_scalar, comp) - 8usize];
};
impl Default for nir_scalar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_scalar_chase_movs(s: nir_scalar) -> nir_scalar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_binding {
    pub success: bool,
    pub var: *mut nir_variable,
    pub desc_set: ::std::os::raw::c_uint,
    pub binding: ::std::os::raw::c_uint,
    pub num_indices: ::std::os::raw::c_uint,
    pub indices: [nir_src; 4usize],
    pub read_first_invocation: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_binding"][::std::mem::size_of::<nir_binding>() - 168usize];
    ["Alignment of nir_binding"][::std::mem::align_of::<nir_binding>() - 8usize];
    ["Offset of field: nir_binding::success"]
        [::std::mem::offset_of!(nir_binding, success) - 0usize];
    ["Offset of field: nir_binding::var"][::std::mem::offset_of!(nir_binding, var) - 8usize];
    ["Offset of field: nir_binding::desc_set"]
        [::std::mem::offset_of!(nir_binding, desc_set) - 16usize];
    ["Offset of field: nir_binding::binding"]
        [::std::mem::offset_of!(nir_binding, binding) - 20usize];
    ["Offset of field: nir_binding::num_indices"]
        [::std::mem::offset_of!(nir_binding, num_indices) - 24usize];
    ["Offset of field: nir_binding::indices"]
        [::std::mem::offset_of!(nir_binding, indices) - 32usize];
    ["Offset of field: nir_binding::read_first_invocation"]
        [::std::mem::offset_of!(nir_binding, read_first_invocation) - 160usize];
};
impl Default for nir_binding {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_chase_binding(rsrc: nir_src) -> nir_binding;
}
unsafe extern "C" {
    pub fn nir_get_binding_variable(
        shader: *mut nir_shader,
        binding: nir_binding,
    ) -> *mut nir_variable;
}
pub const nir_cf_node_block: nir_cf_node_type = 0;
pub const nir_cf_node_if: nir_cf_node_type = 1;
pub const nir_cf_node_loop: nir_cf_node_type = 2;
pub const nir_cf_node_function: nir_cf_node_type = 3;
pub type nir_cf_node_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_cf_node {
    pub node: exec_node,
    pub type_: nir_cf_node_type,
    pub parent: *mut nir_cf_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cf_node"][::std::mem::size_of::<nir_cf_node>() - 32usize];
    ["Alignment of nir_cf_node"][::std::mem::align_of::<nir_cf_node>() - 8usize];
    ["Offset of field: nir_cf_node::node"][::std::mem::offset_of!(nir_cf_node, node) - 0usize];
    ["Offset of field: nir_cf_node::type_"][::std::mem::offset_of!(nir_cf_node, type_) - 16usize];
    ["Offset of field: nir_cf_node::parent"][::std::mem::offset_of!(nir_cf_node, parent) - 24usize];
};
impl Default for nir_cf_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_block {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_instr"]
    pub instr_list: exec_list,
    #[doc = " generic block index; generated by nir_index_blocks"]
    pub index: ::std::os::raw::c_uint,
    pub divergent: bool,
    pub successors: [*mut nir_block; 2usize],
    pub predecessors: set,
    pub imm_dom: *mut nir_block,
    pub num_dom_children: ::std::os::raw::c_uint,
    pub dom_children: *mut *mut nir_block,
    pub _dom_children_storage: [*mut nir_block; 3usize],
    pub dom_frontier: set,
    pub dom_pre_index: u32,
    pub dom_post_index: u32,
    #[doc = " Value just before the first nir_instr->index in the block, but after\n end_ip that of any predecessor block."]
    pub start_ip: u32,
    #[doc = " Value just after the last nir_instr->index in the block, but before the\n start_ip of any successor block."]
    pub end_ip: u32,
    pub live_in: *mut ::std::os::raw::c_uint,
    pub live_out: *mut ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_block"][::std::mem::size_of::<nir_block>() - 920usize];
    ["Alignment of nir_block"][::std::mem::align_of::<nir_block>() - 8usize];
    ["Offset of field: nir_block::cf_node"][::std::mem::offset_of!(nir_block, cf_node) - 0usize];
    ["Offset of field: nir_block::instr_list"]
        [::std::mem::offset_of!(nir_block, instr_list) - 32usize];
    ["Offset of field: nir_block::index"][::std::mem::offset_of!(nir_block, index) - 64usize];
    ["Offset of field: nir_block::divergent"]
        [::std::mem::offset_of!(nir_block, divergent) - 68usize];
    ["Offset of field: nir_block::successors"]
        [::std::mem::offset_of!(nir_block, successors) - 72usize];
    ["Offset of field: nir_block::predecessors"]
        [::std::mem::offset_of!(nir_block, predecessors) - 88usize];
    ["Offset of field: nir_block::imm_dom"][::std::mem::offset_of!(nir_block, imm_dom) - 464usize];
    ["Offset of field: nir_block::num_dom_children"]
        [::std::mem::offset_of!(nir_block, num_dom_children) - 472usize];
    ["Offset of field: nir_block::dom_children"]
        [::std::mem::offset_of!(nir_block, dom_children) - 480usize];
    ["Offset of field: nir_block::_dom_children_storage"]
        [::std::mem::offset_of!(nir_block, _dom_children_storage) - 488usize];
    ["Offset of field: nir_block::dom_frontier"]
        [::std::mem::offset_of!(nir_block, dom_frontier) - 512usize];
    ["Offset of field: nir_block::dom_pre_index"]
        [::std::mem::offset_of!(nir_block, dom_pre_index) - 888usize];
    ["Offset of field: nir_block::dom_post_index"]
        [::std::mem::offset_of!(nir_block, dom_post_index) - 892usize];
    ["Offset of field: nir_block::start_ip"]
        [::std::mem::offset_of!(nir_block, start_ip) - 896usize];
    ["Offset of field: nir_block::end_ip"][::std::mem::offset_of!(nir_block, end_ip) - 900usize];
    ["Offset of field: nir_block::live_in"][::std::mem::offset_of!(nir_block, live_in) - 904usize];
    ["Offset of field: nir_block::live_out"]
        [::std::mem::offset_of!(nir_block, live_out) - 912usize];
};
impl Default for nir_block {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_block_contains_work(block: *mut nir_block) -> bool;
}
pub const nir_selection_control_none: nir_selection_control = 0;
#[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to remove control flow."]
pub const nir_selection_control_flatten: nir_selection_control = 1;
#[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to keep control flow."]
pub const nir_selection_control_dont_flatten: nir_selection_control = 2;
#[doc = " May be applied by the compiler stack when it knows\n that a branch is divergent, and:\n - either both the if and else are always taken\n - the if or else is empty and the other is always taken"]
pub const nir_selection_control_divergent_always_taken: nir_selection_control = 3;
pub type nir_selection_control = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_if {
    pub cf_node: nir_cf_node,
    pub condition: nir_src,
    pub control: nir_selection_control,
    #[doc = " list of nir_cf_node"]
    pub then_list: exec_list,
    #[doc = " list of nir_cf_node"]
    pub else_list: exec_list,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_if"][::std::mem::size_of::<nir_if>() - 136usize];
    ["Alignment of nir_if"][::std::mem::align_of::<nir_if>() - 8usize];
    ["Offset of field: nir_if::cf_node"][::std::mem::offset_of!(nir_if, cf_node) - 0usize];
    ["Offset of field: nir_if::condition"][::std::mem::offset_of!(nir_if, condition) - 32usize];
    ["Offset of field: nir_if::control"][::std::mem::offset_of!(nir_if, control) - 64usize];
    ["Offset of field: nir_if::then_list"][::std::mem::offset_of!(nir_if, then_list) - 72usize];
    ["Offset of field: nir_if::else_list"][::std::mem::offset_of!(nir_if, else_list) - 104usize];
};
impl Default for nir_if {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_loop_terminator {
    pub nif: *mut nir_if,
    #[doc = " Condition instruction that contains the induction variable"]
    pub conditional_instr: *mut nir_instr,
    #[doc = " Block within ::nif that has the break instruction."]
    pub break_block: *mut nir_block,
    #[doc = " Last block for the then- or else-path that does not contain the break."]
    pub continue_from_block: *mut nir_block,
    #[doc = " True when ::break_block is in the else-path of ::nif."]
    pub continue_from_then: bool,
    pub induction_rhs: bool,
    pub exact_trip_count_unknown: bool,
    pub loop_terminator_link: list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop_terminator"][::std::mem::size_of::<nir_loop_terminator>() - 56usize];
    ["Alignment of nir_loop_terminator"][::std::mem::align_of::<nir_loop_terminator>() - 8usize];
    ["Offset of field: nir_loop_terminator::nif"]
        [::std::mem::offset_of!(nir_loop_terminator, nif) - 0usize];
    ["Offset of field: nir_loop_terminator::conditional_instr"]
        [::std::mem::offset_of!(nir_loop_terminator, conditional_instr) - 8usize];
    ["Offset of field: nir_loop_terminator::break_block"]
        [::std::mem::offset_of!(nir_loop_terminator, break_block) - 16usize];
    ["Offset of field: nir_loop_terminator::continue_from_block"]
        [::std::mem::offset_of!(nir_loop_terminator, continue_from_block) - 24usize];
    ["Offset of field: nir_loop_terminator::continue_from_then"]
        [::std::mem::offset_of!(nir_loop_terminator, continue_from_then) - 32usize];
    ["Offset of field: nir_loop_terminator::induction_rhs"]
        [::std::mem::offset_of!(nir_loop_terminator, induction_rhs) - 33usize];
    ["Offset of field: nir_loop_terminator::exact_trip_count_unknown"]
        [::std::mem::offset_of!(nir_loop_terminator, exact_trip_count_unknown) - 34usize];
    ["Offset of field: nir_loop_terminator::loop_terminator_link"]
        [::std::mem::offset_of!(nir_loop_terminator, loop_terminator_link) - 40usize];
};
impl Default for nir_loop_terminator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_loop_induction_variable {
    pub basis: *mut nir_def,
    pub def: *mut nir_def,
    pub init_src: *mut nir_src,
    pub update_src: *mut nir_alu_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop_induction_variable"]
        [::std::mem::size_of::<nir_loop_induction_variable>() - 32usize];
    ["Alignment of nir_loop_induction_variable"]
        [::std::mem::align_of::<nir_loop_induction_variable>() - 8usize];
    ["Offset of field: nir_loop_induction_variable::basis"]
        [::std::mem::offset_of!(nir_loop_induction_variable, basis) - 0usize];
    ["Offset of field: nir_loop_induction_variable::def"]
        [::std::mem::offset_of!(nir_loop_induction_variable, def) - 8usize];
    ["Offset of field: nir_loop_induction_variable::init_src"]
        [::std::mem::offset_of!(nir_loop_induction_variable, init_src) - 16usize];
    ["Offset of field: nir_loop_induction_variable::update_src"]
        [::std::mem::offset_of!(nir_loop_induction_variable, update_src) - 24usize];
};
impl Default for nir_loop_induction_variable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_loop_info {
    pub instr_cost: ::std::os::raw::c_uint,
    pub has_soft_fp64: bool,
    pub guessed_trip_count: ::std::os::raw::c_uint,
    pub max_trip_count: ::std::os::raw::c_uint,
    pub exact_trip_count_known: bool,
    pub force_unroll: bool,
    pub complex_loop: bool,
    pub limiting_terminator: *mut nir_loop_terminator,
    pub loop_terminator_list: list_head,
    pub induction_vars: *mut hash_table,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop_info"][::std::mem::size_of::<nir_loop_info>() - 56usize];
    ["Alignment of nir_loop_info"][::std::mem::align_of::<nir_loop_info>() - 8usize];
    ["Offset of field: nir_loop_info::instr_cost"]
        [::std::mem::offset_of!(nir_loop_info, instr_cost) - 0usize];
    ["Offset of field: nir_loop_info::has_soft_fp64"]
        [::std::mem::offset_of!(nir_loop_info, has_soft_fp64) - 4usize];
    ["Offset of field: nir_loop_info::guessed_trip_count"]
        [::std::mem::offset_of!(nir_loop_info, guessed_trip_count) - 8usize];
    ["Offset of field: nir_loop_info::max_trip_count"]
        [::std::mem::offset_of!(nir_loop_info, max_trip_count) - 12usize];
    ["Offset of field: nir_loop_info::exact_trip_count_known"]
        [::std::mem::offset_of!(nir_loop_info, exact_trip_count_known) - 16usize];
    ["Offset of field: nir_loop_info::force_unroll"]
        [::std::mem::offset_of!(nir_loop_info, force_unroll) - 17usize];
    ["Offset of field: nir_loop_info::complex_loop"]
        [::std::mem::offset_of!(nir_loop_info, complex_loop) - 18usize];
    ["Offset of field: nir_loop_info::limiting_terminator"]
        [::std::mem::offset_of!(nir_loop_info, limiting_terminator) - 24usize];
    ["Offset of field: nir_loop_info::loop_terminator_list"]
        [::std::mem::offset_of!(nir_loop_info, loop_terminator_list) - 32usize];
    ["Offset of field: nir_loop_info::induction_vars"]
        [::std::mem::offset_of!(nir_loop_info, induction_vars) - 48usize];
};
impl Default for nir_loop_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_loop_control_none: nir_loop_control = 0;
pub const nir_loop_control_unroll: nir_loop_control = 1;
pub const nir_loop_control_dont_unroll: nir_loop_control = 2;
pub type nir_loop_control = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_loop {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    #[doc = " (optional) list of nir_cf_node"]
    pub continue_list: exec_list,
    pub info: *mut nir_loop_info,
    pub control: nir_loop_control,
    pub partially_unrolled: bool,
    #[doc = " Whether some loop-active invocations might take a different control-flow path:\n divergent_continue indicates that a continue statement might be taken by\n only some of the loop-active invocations. A subsequent break is always\n considered divergent."]
    pub divergent_continue: bool,
    pub divergent_break: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop"][::std::mem::size_of::<nir_loop>() - 112usize];
    ["Alignment of nir_loop"][::std::mem::align_of::<nir_loop>() - 8usize];
    ["Offset of field: nir_loop::cf_node"][::std::mem::offset_of!(nir_loop, cf_node) - 0usize];
    ["Offset of field: nir_loop::body"][::std::mem::offset_of!(nir_loop, body) - 32usize];
    ["Offset of field: nir_loop::continue_list"]
        [::std::mem::offset_of!(nir_loop, continue_list) - 64usize];
    ["Offset of field: nir_loop::info"][::std::mem::offset_of!(nir_loop, info) - 96usize];
    ["Offset of field: nir_loop::control"][::std::mem::offset_of!(nir_loop, control) - 104usize];
    ["Offset of field: nir_loop::partially_unrolled"]
        [::std::mem::offset_of!(nir_loop, partially_unrolled) - 108usize];
    ["Offset of field: nir_loop::divergent_continue"]
        [::std::mem::offset_of!(nir_loop, divergent_continue) - 109usize];
    ["Offset of field: nir_loop::divergent_break"]
        [::std::mem::offset_of!(nir_loop, divergent_break) - 110usize];
};
impl Default for nir_loop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const nir_metadata_none: nir_metadata = 0;
#[doc = " Indicates that nir_block::index values are valid.\n\n The start block has index 0 and they increase through a natural walk of\n the CFG.  nir_function_impl::num_blocks is the number of blocks and\n every block index is in the range [0, nir_function_impl::num_blocks].\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
pub const nir_metadata_block_index: nir_metadata = 1;
#[doc = " Indicates that block dominance information is valid\n\n This includes:\n\n   - nir_block::num_dom_children\n   - nir_block::dom_children\n   - nir_block::dom_frontier\n   - nir_block::dom_pre_index\n   - nir_block::dom_post_index\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
pub const nir_metadata_dominance: nir_metadata = 2;
#[doc = " Indicates that SSA def data-flow liveness information is valid\n\n This includes:\n\n   - nir_block::live_in\n   - nir_block::live_out\n\n A pass can preserve this metadata type if it never adds or removes any\n SSA defs or uses of SSA defs (most passes shouldn't preserve this\n metadata type)."]
pub const nir_metadata_live_defs: nir_metadata = 4;
#[doc = " A dummy metadata value to track when a pass forgot to preserve metadata.\n\n A pass should always clear this value even if it doesn't make any\n progress to indicate that it thought about preserving metadata."]
pub const nir_metadata_not_properly_reset: nir_metadata = 8;
#[doc = " Indicates that loop analysis information is valid.\n\n This includes everything pointed to by nir_loop::info.\n\n A pass can preserve this metadata type if it is guaranteed to not affect\n any loop metadata.  However, since loop metadata includes things like\n loop counts which depend on arithmetic in the loop, this is very hard to\n determine.  Most passes shouldn't preserve this metadata type."]
pub const nir_metadata_loop_analysis: nir_metadata = 16;
#[doc = " Indicates that nir_instr::index values are valid.\n\n The start instruction has index 0 and they increase through a natural\n walk of instructions in blocks in the CFG.  The indices my have holes\n after passes such as DCE.\n\n A pass can preserve this metadata type if it never adds or moves any\n instructions (most passes shouldn't preserve this metadata type), but\n can preserve it if it only removes instructions."]
pub const nir_metadata_instr_index: nir_metadata = 32;
#[doc = " Indicates that divergence analysis information is valid.\n\n This includes:\n   - nir_def::divergent\n   - nir_def::loop_invariant\n   - nir_block::divergent\n   - nir_loop::divergent_break\n   - nir_loop::divergent_continue\n\n A pass can preserve this metadata type if it never adds any instructions or\n moves them across loop breaks, as well as if it only removes instructions.\n CF modifications usually invalidate this metadata.  Most passes\n shouldn't preserve this metadata type."]
pub const nir_metadata_divergence: nir_metadata = 64;
#[doc = " Indicates that block dominance lca information is valid\n\n This includes:\n\n   - nir_function_impl::dom_lca_info\n\n A pass can preserve this metadata type if it preserves\n nir_metadata_dominance."]
pub const nir_metadata_dominance_lca: nir_metadata = 128;
#[doc = " All control flow metadata\n\n This includes all metadata preserved by a pass that preserves control flow\n but modifies instructions. For example, a pass using\n nir_shader_instructions_pass will typically preserve this if it does not\n insert control flow.\n\n This is the most common metadata set to preserve, so it has its own alias."]
pub const nir_metadata_control_flow: nir_metadata = 131;
#[doc = " All metadata\n\n This includes all nir_metadata flags except not_properly_reset.  Passes\n which do not change the shader in any way should use this."]
pub const nir_metadata_all: nir_metadata = -9;
#[doc = " Various bits of metadata that can may be created or required by\n optimization and analysis passes"]
pub type nir_metadata = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_function_impl {
    pub cf_node: nir_cf_node,
    #[doc = " pointer to the function of which this is an implementation"]
    pub function: *mut nir_function,
    #[doc = " For entrypoints, a pointer to a nir_function_impl which runs before\n it, once per draw or dispatch, communicating via store_preamble and\n load_preamble intrinsics. If NULL then there is no preamble."]
    pub preamble: *mut nir_function,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    pub end_block: *mut nir_block,
    #[doc = " list for all local variables in the function"]
    pub locals: exec_list,
    #[doc = " next available SSA value index"]
    pub ssa_alloc: ::std::os::raw::c_uint,
    pub num_blocks: ::std::os::raw::c_uint,
    pub dom_lca_info: nir_function_impl_nir_dom_lca_info,
    #[doc = " True if this nir_function_impl uses structured control-flow\n\n Structured nir_function_impls have different validation rules."]
    pub structured: bool,
    pub valid_metadata: nir_metadata,
    pub loop_analysis_indirect_mask: nir_variable_mode,
    pub loop_analysis_force_unroll_sampler_indirect: bool,
}
#[doc = " Information used for LCA queries"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_function_impl_nir_dom_lca_info {
    pub table: range_minimum_query_table,
    pub block_from_idx: *mut *mut nir_block,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_function_impl_nir_dom_lca_info"]
        [::std::mem::size_of::<nir_function_impl_nir_dom_lca_info>() - 24usize];
    ["Alignment of nir_function_impl_nir_dom_lca_info"]
        [::std::mem::align_of::<nir_function_impl_nir_dom_lca_info>() - 8usize];
    ["Offset of field: nir_function_impl_nir_dom_lca_info::table"]
        [::std::mem::offset_of!(nir_function_impl_nir_dom_lca_info, table) - 0usize];
    ["Offset of field: nir_function_impl_nir_dom_lca_info::block_from_idx"]
        [::std::mem::offset_of!(nir_function_impl_nir_dom_lca_info, block_from_idx) - 16usize];
};
impl Default for nir_function_impl_nir_dom_lca_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_function_impl"][::std::mem::size_of::<nir_function_impl>() - 168usize];
    ["Alignment of nir_function_impl"][::std::mem::align_of::<nir_function_impl>() - 8usize];
    ["Offset of field: nir_function_impl::cf_node"]
        [::std::mem::offset_of!(nir_function_impl, cf_node) - 0usize];
    ["Offset of field: nir_function_impl::function"]
        [::std::mem::offset_of!(nir_function_impl, function) - 32usize];
    ["Offset of field: nir_function_impl::preamble"]
        [::std::mem::offset_of!(nir_function_impl, preamble) - 40usize];
    ["Offset of field: nir_function_impl::body"]
        [::std::mem::offset_of!(nir_function_impl, body) - 48usize];
    ["Offset of field: nir_function_impl::end_block"]
        [::std::mem::offset_of!(nir_function_impl, end_block) - 80usize];
    ["Offset of field: nir_function_impl::locals"]
        [::std::mem::offset_of!(nir_function_impl, locals) - 88usize];
    ["Offset of field: nir_function_impl::ssa_alloc"]
        [::std::mem::offset_of!(nir_function_impl, ssa_alloc) - 120usize];
    ["Offset of field: nir_function_impl::num_blocks"]
        [::std::mem::offset_of!(nir_function_impl, num_blocks) - 124usize];
    ["Offset of field: nir_function_impl::dom_lca_info"]
        [::std::mem::offset_of!(nir_function_impl, dom_lca_info) - 128usize];
    ["Offset of field: nir_function_impl::structured"]
        [::std::mem::offset_of!(nir_function_impl, structured) - 152usize];
    ["Offset of field: nir_function_impl::valid_metadata"]
        [::std::mem::offset_of!(nir_function_impl, valid_metadata) - 156usize];
    ["Offset of field: nir_function_impl::loop_analysis_indirect_mask"]
        [::std::mem::offset_of!(nir_function_impl, loop_analysis_indirect_mask) - 160usize];
    ["Offset of field: nir_function_impl::loop_analysis_force_unroll_sampler_indirect"][::std::mem::offset_of!(
        nir_function_impl,
        loop_analysis_force_unroll_sampler_indirect
    )
        - 164usize];
};
impl Default for nir_function_impl {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_parameter {
    pub num_components: u8,
    pub bit_size: u8,
    pub is_return: bool,
    pub implicit_conversion_prohibited: bool,
    pub is_uniform: bool,
    pub mode: nir_variable_mode,
    pub driver_attributes: u32,
    pub type_: *const glsl_type,
    pub name: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parameter"][::std::mem::size_of::<nir_parameter>() - 32usize];
    ["Alignment of nir_parameter"][::std::mem::align_of::<nir_parameter>() - 8usize];
    ["Offset of field: nir_parameter::num_components"]
        [::std::mem::offset_of!(nir_parameter, num_components) - 0usize];
    ["Offset of field: nir_parameter::bit_size"]
        [::std::mem::offset_of!(nir_parameter, bit_size) - 1usize];
    ["Offset of field: nir_parameter::is_return"]
        [::std::mem::offset_of!(nir_parameter, is_return) - 2usize];
    ["Offset of field: nir_parameter::implicit_conversion_prohibited"]
        [::std::mem::offset_of!(nir_parameter, implicit_conversion_prohibited) - 3usize];
    ["Offset of field: nir_parameter::is_uniform"]
        [::std::mem::offset_of!(nir_parameter, is_uniform) - 4usize];
    ["Offset of field: nir_parameter::mode"][::std::mem::offset_of!(nir_parameter, mode) - 8usize];
    ["Offset of field: nir_parameter::driver_attributes"]
        [::std::mem::offset_of!(nir_parameter, driver_attributes) - 12usize];
    ["Offset of field: nir_parameter::type_"]
        [::std::mem::offset_of!(nir_parameter, type_) - 16usize];
    ["Offset of field: nir_parameter::name"][::std::mem::offset_of!(nir_parameter, name) - 24usize];
};
impl Default for nir_parameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_function {
    pub node: exec_node,
    pub name: *const ::std::os::raw::c_char,
    pub shader: *mut nir_shader,
    pub num_params: ::std::os::raw::c_uint,
    pub params: *mut nir_parameter,
    #[doc = " The implementation of this function.\n\n If the function is only declared and not implemented, this is NULL.\n\n Unless setting to NULL or NIR_SERIALIZE_FUNC_HAS_IMPL, set with\n nir_function_set_impl to maintain IR invariants."]
    pub impl_: *mut nir_function_impl,
    pub driver_attributes: u32,
    pub is_entrypoint: bool,
    pub is_exported: bool,
    pub is_preamble: bool,
    pub should_inline: bool,
    pub dont_inline: bool,
    pub workgroup_size: [::std::os::raw::c_uint; 3usize],
    #[doc = " Is this function a subroutine type declaration\n e.g. subroutine void type1(float arg1);"]
    pub is_subroutine: bool,
    pub is_tmp_globals_wrapper: bool,
    #[doc = " Is this function associated to a subroutine type\n e.g. subroutine (type1, type2) function_name { function_body };\n would have num_subroutine_types 2,\n and pointers to the type1 and type2 types."]
    pub num_subroutine_types: ::std::os::raw::c_int,
    pub subroutine_types: *mut *const glsl_type,
    pub subroutine_index: ::std::os::raw::c_int,
    pub pass_flags: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_function"][::std::mem::size_of::<nir_function>() - 104usize];
    ["Alignment of nir_function"][::std::mem::align_of::<nir_function>() - 8usize];
    ["Offset of field: nir_function::node"][::std::mem::offset_of!(nir_function, node) - 0usize];
    ["Offset of field: nir_function::name"][::std::mem::offset_of!(nir_function, name) - 16usize];
    ["Offset of field: nir_function::shader"]
        [::std::mem::offset_of!(nir_function, shader) - 24usize];
    ["Offset of field: nir_function::num_params"]
        [::std::mem::offset_of!(nir_function, num_params) - 32usize];
    ["Offset of field: nir_function::params"]
        [::std::mem::offset_of!(nir_function, params) - 40usize];
    ["Offset of field: nir_function::impl_"][::std::mem::offset_of!(nir_function, impl_) - 48usize];
    ["Offset of field: nir_function::driver_attributes"]
        [::std::mem::offset_of!(nir_function, driver_attributes) - 56usize];
    ["Offset of field: nir_function::is_entrypoint"]
        [::std::mem::offset_of!(nir_function, is_entrypoint) - 60usize];
    ["Offset of field: nir_function::is_exported"]
        [::std::mem::offset_of!(nir_function, is_exported) - 61usize];
    ["Offset of field: nir_function::is_preamble"]
        [::std::mem::offset_of!(nir_function, is_preamble) - 62usize];
    ["Offset of field: nir_function::should_inline"]
        [::std::mem::offset_of!(nir_function, should_inline) - 63usize];
    ["Offset of field: nir_function::dont_inline"]
        [::std::mem::offset_of!(nir_function, dont_inline) - 64usize];
    ["Offset of field: nir_function::workgroup_size"]
        [::std::mem::offset_of!(nir_function, workgroup_size) - 68usize];
    ["Offset of field: nir_function::is_subroutine"]
        [::std::mem::offset_of!(nir_function, is_subroutine) - 80usize];
    ["Offset of field: nir_function::is_tmp_globals_wrapper"]
        [::std::mem::offset_of!(nir_function, is_tmp_globals_wrapper) - 81usize];
    ["Offset of field: nir_function::num_subroutine_types"]
        [::std::mem::offset_of!(nir_function, num_subroutine_types) - 84usize];
    ["Offset of field: nir_function::subroutine_types"]
        [::std::mem::offset_of!(nir_function, subroutine_types) - 88usize];
    ["Offset of field: nir_function::subroutine_index"]
        [::std::mem::offset_of!(nir_function, subroutine_index) - 96usize];
    ["Offset of field: nir_function::pass_flags"]
        [::std::mem::offset_of!(nir_function, pass_flags) - 100usize];
};
impl Default for nir_function {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_intrin_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_intrinsic_instr,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " A vectorization width callback\n\n Returns the maximum vectorization width per instruction.\n 0, if the instruction must not be modified.\n\n The vectorization width must be a power of 2."]
pub type nir_vectorize_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> u8,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_shader {
    pub gctx: *mut gc_ctx,
    #[doc = " list of uniforms (nir_variable)"]
    pub variables: exec_list,
    #[doc = " Set of driver-specific options for the shader.\n\n The memory for the options is expected to be kept in a single static\n copy by the driver."]
    pub options: *const nir_shader_compiler_options,
    #[doc = " Various bits of compile-time information about a given shader"]
    pub info: shader_info,
    #[doc = " list of nir_function"]
    pub functions: exec_list,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_inputs: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_uniforms: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_outputs: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required implicitly bound global memory"]
    pub global_mem_size: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required scratch space"]
    pub scratch_size: ::std::os::raw::c_uint,
    #[doc = " Constant data associated with this shader.\n\n Constant data is loaded through load_constant intrinsics (as compared to\n the NIR load_const instructions which have the constant value inlined\n into them).  This is usually generated by nir_opt_large_constants (so\n shaders don't have to load_const into a temporary array when they want\n to indirect on a const array)."]
    pub constant_data: *mut ::std::os::raw::c_void,
    #[doc = " Size of the constant data associated with the shader, in bytes"]
    pub constant_data_size: ::std::os::raw::c_uint,
    pub xfb_info: *mut nir_xfb_info,
    pub printf_info_count: ::std::os::raw::c_uint,
    pub printf_info: *mut u_printf_info,
    pub has_debug_info: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_shader"][::std::mem::size_of::<nir_shader>() - 544usize];
    ["Alignment of nir_shader"][::std::mem::align_of::<nir_shader>() - 8usize];
    ["Offset of field: nir_shader::gctx"][::std::mem::offset_of!(nir_shader, gctx) - 0usize];
    ["Offset of field: nir_shader::variables"]
        [::std::mem::offset_of!(nir_shader, variables) - 8usize];
    ["Offset of field: nir_shader::options"][::std::mem::offset_of!(nir_shader, options) - 40usize];
    ["Offset of field: nir_shader::info"][::std::mem::offset_of!(nir_shader, info) - 48usize];
    ["Offset of field: nir_shader::functions"]
        [::std::mem::offset_of!(nir_shader, functions) - 440usize];
    ["Offset of field: nir_shader::num_inputs"]
        [::std::mem::offset_of!(nir_shader, num_inputs) - 472usize];
    ["Offset of field: nir_shader::num_uniforms"]
        [::std::mem::offset_of!(nir_shader, num_uniforms) - 476usize];
    ["Offset of field: nir_shader::num_outputs"]
        [::std::mem::offset_of!(nir_shader, num_outputs) - 480usize];
    ["Offset of field: nir_shader::global_mem_size"]
        [::std::mem::offset_of!(nir_shader, global_mem_size) - 484usize];
    ["Offset of field: nir_shader::scratch_size"]
        [::std::mem::offset_of!(nir_shader, scratch_size) - 488usize];
    ["Offset of field: nir_shader::constant_data"]
        [::std::mem::offset_of!(nir_shader, constant_data) - 496usize];
    ["Offset of field: nir_shader::constant_data_size"]
        [::std::mem::offset_of!(nir_shader, constant_data_size) - 504usize];
    ["Offset of field: nir_shader::xfb_info"]
        [::std::mem::offset_of!(nir_shader, xfb_info) - 512usize];
    ["Offset of field: nir_shader::printf_info_count"]
        [::std::mem::offset_of!(nir_shader, printf_info_count) - 520usize];
    ["Offset of field: nir_shader::printf_info"]
        [::std::mem::offset_of!(nir_shader, printf_info) - 528usize];
    ["Offset of field: nir_shader::has_debug_info"]
        [::std::mem::offset_of!(nir_shader, has_debug_info) - 536usize];
};
impl Default for nir_shader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_remove_non_entrypoints(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_remove_non_exported(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_remove_entrypoints(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_fixup_is_exported(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_create(
        mem_ctx: *mut ::std::os::raw::c_void,
        stage: mesa_shader_stage,
        options: *const nir_shader_compiler_options,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_shader_bisect_select(s: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    #[doc = " Adds a variable to the appropriate list in nir_shader"]
    pub fn nir_shader_add_variable(shader: *mut nir_shader, var: *mut nir_variable);
}
unsafe extern "C" {
    pub fn nir_variable_create_zeroed(nir: *mut nir_shader) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_variable_set_name(
        nir: *mut nir_shader,
        var: *mut nir_variable,
        name: *const ::std::os::raw::c_char,
    );
}
unsafe extern "C" {
    pub fn nir_variable_set_namef(
        nir: *mut nir_shader,
        var: *mut nir_variable,
        fmt: *const ::std::os::raw::c_char,
        ...
    );
}
unsafe extern "C" {
    pub fn nir_variable_append_namef(
        nir: *mut nir_shader,
        var: *mut nir_variable,
        fmt: *const ::std::os::raw::c_char,
        ...
    );
}
unsafe extern "C" {
    pub fn nir_variable_steal_name(
        nir: *mut nir_shader,
        dst: *mut nir_variable,
        src: *mut nir_variable,
    );
}
unsafe extern "C" {
    #[doc = " creates a variable, sets a few defaults, and adds it to the list"]
    pub fn nir_variable_create(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    #[doc = " creates a local variable and adds it to the list"]
    pub fn nir_local_variable_create(
        impl_: *mut nir_function_impl,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    #[doc = " Creates a uniform builtin state variable."]
    pub fn nir_state_variable_create(
        shader: *mut nir_shader,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
        tokens: *const gl_state_index16,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_get_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_create_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_variable_with_driver_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_state_variable(
        s: *mut nir_shader,
        tokens: *mut gl_state_index16,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_sampler_variable_with_tex_index(
        shader: *mut nir_shader,
        texture_index: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_sort_variables_with_modes(
        shader: *mut nir_shader,
        compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const nir_variable,
                arg2: *const nir_variable,
            ) -> ::std::os::raw::c_int,
        >,
        modes: nir_variable_mode,
    );
}
unsafe extern "C" {
    #[doc = " creates a function and adds it to the shader's list of functions"]
    pub fn nir_function_create(
        shader: *mut nir_shader,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_function;
}
unsafe extern "C" {
    pub fn nir_function_impl_create(func: *mut nir_function) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[doc = " creates a function_impl that isn't tied to any particular function"]
    pub fn nir_function_impl_create_bare(shader: *mut nir_shader) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_block_create(shader: *mut nir_shader) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_if_create(shader: *mut nir_shader) -> *mut nir_if;
}
unsafe extern "C" {
    pub fn nir_loop_create(shader: *mut nir_shader) -> *mut nir_loop;
}
unsafe extern "C" {
    pub fn nir_cf_node_get_function(node: *mut nir_cf_node) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[doc = " requests that the given pieces of metadata be generated"]
    pub fn nir_metadata_require(impl_: *mut nir_function_impl, required: nir_metadata, ...);
}
unsafe extern "C" {
    #[doc = " Preserves all metadata for the given shader"]
    pub fn nir_shader_preserve_all_metadata(shader: *mut nir_shader);
}
unsafe extern "C" {
    #[doc = " dirties all metadata and fills it with obviously wrong information"]
    pub fn nir_metadata_invalidate(shader: *mut nir_shader);
}
unsafe extern "C" {
    #[doc = " Indicate progress on an implementation, preserving only the specified\n metadata. The supplied progress is returned to improve ergonomics."]
    pub fn nir_progress(
        progress: bool,
        impl_: *mut nir_function_impl,
        preserved: nir_metadata,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " creates an instruction with default swizzle/writemask/etc. with NULL registers"]
    pub fn nir_alu_instr_create(shader: *mut nir_shader, op: nir_op) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    pub fn nir_deref_instr_create(
        shader: *mut nir_shader,
        deref_type: nir_deref_type,
    ) -> *mut nir_deref_instr;
}
unsafe extern "C" {
    pub fn nir_jump_instr_create(
        shader: *mut nir_shader,
        type_: nir_jump_type,
    ) -> *mut nir_jump_instr;
}
unsafe extern "C" {
    pub fn nir_load_const_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_load_const_instr;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_create(
        shader: *mut nir_shader,
        op: nir_intrinsic_op,
    ) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    pub fn nir_call_instr_create(
        shader: *mut nir_shader,
        callee: *mut nir_function,
    ) -> *mut nir_call_instr;
}
unsafe extern "C" {
    #[doc = " Creates a NIR texture instruction"]
    pub fn nir_tex_instr_create(
        shader: *mut nir_shader,
        num_srcs: ::std::os::raw::c_uint,
    ) -> *mut nir_tex_instr;
}
unsafe extern "C" {
    pub fn nir_phi_instr_create(shader: *mut nir_shader) -> *mut nir_phi_instr;
}
unsafe extern "C" {
    pub fn nir_phi_instr_add_src(
        instr: *mut nir_phi_instr,
        pred: *mut nir_block,
        src: *mut nir_def,
    ) -> *mut nir_phi_src;
}
unsafe extern "C" {
    pub fn nir_parallel_copy_instr_create(shader: *mut nir_shader) -> *mut nir_parallel_copy_instr;
}
unsafe extern "C" {
    pub fn nir_undef_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_undef_instr;
}
unsafe extern "C" {
    pub fn nir_alu_binop_identity(
        binop: nir_op,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
pub const nir_cursor_before_block: nir_cursor_option = 0;
pub const nir_cursor_after_block: nir_cursor_option = 1;
pub const nir_cursor_before_instr: nir_cursor_option = 2;
pub const nir_cursor_after_instr: nir_cursor_option = 3;
#[doc = " NIR Cursors and Instruction Insertion API\n @{\n\n A tiny struct representing a point to insert/extract instructions or\n control flow nodes.  Helps reduce the combinatorial explosion of possible\n points to insert/extract.\n\n \\sa nir_control_flow.h"]
pub type nir_cursor_option = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_cursor {
    pub option: nir_cursor_option,
    pub __bindgen_anon_1: nir_cursor__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_cursor__bindgen_ty_1 {
    pub block: *mut nir_block,
    pub instr: *mut nir_instr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cursor__bindgen_ty_1"]
        [::std::mem::size_of::<nir_cursor__bindgen_ty_1>() - 8usize];
    ["Alignment of nir_cursor__bindgen_ty_1"]
        [::std::mem::align_of::<nir_cursor__bindgen_ty_1>() - 8usize];
    ["Offset of field: nir_cursor__bindgen_ty_1::block"]
        [::std::mem::offset_of!(nir_cursor__bindgen_ty_1, block) - 0usize];
    ["Offset of field: nir_cursor__bindgen_ty_1::instr"]
        [::std::mem::offset_of!(nir_cursor__bindgen_ty_1, instr) - 0usize];
};
impl Default for nir_cursor__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cursor"][::std::mem::size_of::<nir_cursor>() - 16usize];
    ["Alignment of nir_cursor"][::std::mem::align_of::<nir_cursor>() - 8usize];
    ["Offset of field: nir_cursor::option"][::std::mem::offset_of!(nir_cursor, option) - 0usize];
};
impl Default for nir_cursor {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_cursors_equal(a: nir_cursor, b: nir_cursor) -> bool;
}
unsafe extern "C" {
    #[doc = " Insert a NIR instruction at the given cursor.\n\n Note: This does not update the cursor."]
    pub fn nir_instr_insert(cursor: nir_cursor, instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_move(cursor: nir_cursor, instr: *mut nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_instr_remove_v(instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_free(instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_free_list(list: *mut exec_list);
}
unsafe extern "C" {
    pub fn nir_instr_free_and_dce(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    #[doc = " @}"]
    pub fn nir_instr_def(instr: *mut nir_instr) -> *mut nir_def;
}
pub type nir_foreach_def_cb = ::std::option::Option<
    unsafe extern "C" fn(def: *mut nir_def, state: *mut ::std::os::raw::c_void) -> bool,
>;
pub type nir_foreach_src_cb = ::std::option::Option<
    unsafe extern "C" fn(src: *mut nir_src, state: *mut ::std::os::raw::c_void) -> bool,
>;
unsafe extern "C" {
    pub fn nir_foreach_phi_src_leaving_block(
        instr: *mut nir_block,
        cb: nir_foreach_src_cb,
        state: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_src_as_const_value(src: nir_src) -> *mut nir_const_value;
}
unsafe extern "C" {
    pub fn nir_src_as_string(src: nir_src) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_src_is_always_uniform(src: nir_src) -> bool;
}
unsafe extern "C" {
    pub fn nir_srcs_equal(src1: nir_src, src2: nir_src) -> bool;
}
unsafe extern "C" {
    pub fn nir_instrs_equal(instr1: *const nir_instr, instr2: *const nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_src_get_block(src: *mut nir_src) -> *mut nir_block;
}
unsafe extern "C" {
    #[doc = " Initialize a nir_src\n\n This is almost never the helper you want to use.  This helper assumes that\n the source is uninitialized garbage and blasts over it without doing any\n tear-down the existing source, including removing it from uses lists.\n Using this helper on a source that currently exists in any uses list will\n result in linked list corruption.  It also assumes that the instruction is\n currently live in the IR and adds the source to the uses list for the given\n nir_def as part of setup.\n\n This is pretty much only useful for adding sources to extant instructions\n or manipulating parallel copy instructions as part of out-of-SSA.\n\n When in doubt, use nir_src_rewrite() instead."]
    pub fn nir_instr_init_src(instr: *mut nir_instr, src: *mut nir_src, def: *mut nir_def);
}
unsafe extern "C" {
    #[doc = " Clear a nir_src\n\n This helper clears a nir_src by removing it from any uses lists and\n resetting its contents to NIR_SRC_INIT.  This is typically used as a\n precursor to removing the source from the instruction by adjusting a\n num_srcs parameter somewhere or overwriting it with nir_instr_move_src()."]
    pub fn nir_instr_clear_src(instr: *mut nir_instr, src: *mut nir_src);
}
unsafe extern "C" {
    pub fn nir_instr_move_src(dest_instr: *mut nir_instr, dest: *mut nir_src, src: *mut nir_src);
}
unsafe extern "C" {
    #[doc = " Returns true if first comes before second in a block."]
    pub fn nir_instr_is_before(first: *mut nir_instr, second: *mut nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_init(
        instr: *mut nir_instr,
        def: *mut nir_def,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses(def: *mut nir_def, new_ssa: *mut nir_def);
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses_src(def: *mut nir_def, new_src: nir_src);
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses_after_instr(
        def: *mut nir_def,
        new_ssa: *mut nir_def,
        after_me: *mut nir_instr,
    );
}
unsafe extern "C" {
    pub fn nir_src_components_read(src: *const nir_src) -> nir_component_mask_t;
}
unsafe extern "C" {
    pub fn nir_def_components_read(def: *const nir_def) -> nir_component_mask_t;
}
unsafe extern "C" {
    pub fn nir_def_all_uses_are_fsat(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_all_uses_ignore_sign_bit(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    #[doc = " Sorts unstructured blocks\n\n NIR requires that unstructured blocks be sorted in reverse post\n depth-first-search order.  This is the standard ordering used in the\n compiler literature which guarantees dominance.  In particular, reverse\n post-DFS order guarantees that dominators occur in the list before the\n blocks they dominate.\n\n NOTE: This function also implicitly deletes any unreachable blocks."]
    pub fn nir_sort_unstructured_blocks(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    #[doc = " Returns the next block\n\n For structured control-flow, this follows the same order as\n nir_block_cf_tree_next().  For unstructured control-flow the blocks are in\n reverse post-DFS order.  (See nir_sort_unstructured_blocks() above.)"]
    pub fn nir_block_unstructured_next(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_unstructured_start_block(impl_: *mut nir_function_impl) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_cf_tree_next(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_cf_tree_prev(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_first(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_last(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_next(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_prev(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_get_following_if(block: *mut nir_block) -> *mut nir_if;
}
unsafe extern "C" {
    pub fn nir_block_get_following_loop(block: *mut nir_block) -> *mut nir_loop;
}
unsafe extern "C" {
    pub fn nir_block_get_predecessors_sorted(
        block: *const nir_block,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_index_ssa_defs(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_index_instrs(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_index_blocks(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_shader_clear_pass_flags(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_index_vars(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_function_impl_index_vars(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_print_shader(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_print_function_body(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_print_shader_annotated(
        shader: *mut nir_shader,
        fp: *mut FILE,
        errors: *mut hash_table,
    );
}
unsafe extern "C" {
    pub fn nir_print_instr(instr: *const nir_instr, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_print_deref(deref: *const nir_deref_instr, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_log_shader_annotated_tagged(
        level: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        shader: *mut nir_shader,
        annotations: *mut hash_table,
    );
}
unsafe extern "C" {
    pub fn nir_shader_as_str(
        nir: *mut nir_shader,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_shader_as_str_annotated(
        nir: *mut nir_shader,
        annotations: *mut hash_table,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_instr_as_str(
        instr: *const nir_instr,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Adds debug information to the shader. The line numbers point to\n the corresponding lines in the printed NIR, starting first_line;"]
    pub fn nir_shader_gather_debug_info(
        shader: *mut nir_shader,
        filename: *const ::std::os::raw::c_char,
        first_line: u32,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Shallow clone of a single instruction."]
    pub fn nir_instr_clone(s: *mut nir_shader, orig: *const nir_instr) -> *mut nir_instr;
}
unsafe extern "C" {
    #[doc = " Clone a single instruction, including a remap table to rewrite sources."]
    pub fn nir_instr_clone_deep(
        s: *mut nir_shader,
        orig: *const nir_instr,
        remap_table: *mut hash_table,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    #[doc = " Shallow clone of a single ALU instruction."]
    pub fn nir_alu_instr_clone(
        s: *mut nir_shader,
        orig: *const nir_alu_instr,
    ) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    pub fn nir_shader_clone(
        mem_ctx: *mut ::std::os::raw::c_void,
        s: *const nir_shader,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_function_clone(ns: *mut nir_shader, fxn: *const nir_function) -> *mut nir_function;
}
unsafe extern "C" {
    pub fn nir_function_impl_clone(
        shader: *mut nir_shader,
        fi: *const nir_function_impl,
    ) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_function_impl_clone_remap_globals(
        shader: *mut nir_shader,
        fi: *const nir_function_impl,
        remap_table: *mut hash_table,
    ) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_constant_clone(
        c: *const nir_constant,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut nir_constant;
}
unsafe extern "C" {
    pub fn nir_variable_clone(c: *const nir_variable, shader: *mut nir_shader)
        -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_shader_replace(dest: *mut nir_shader, src: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_serialize_deserialize(s: *mut nir_shader);
}
#[doc = " An instruction filtering callback with writemask\n\n Returns true if the instruction should be processed with the associated\n writemask and false otherwise."]
pub type nir_instr_writemask_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        writemask: ::std::os::raw::c_uint,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " A simple instruction lowering callback\n\n Many instruction lowering passes can be written as a simple function which\n takes an instruction as its input and returns a sequence of instructions\n that implement the consumed instruction.  This function type represents\n such a lowering function.  When called, a function with this prototype\n should either return NULL indicating that no lowering needs to be done or\n emit a sequence of instructions using the provided builder (whose cursor\n will already be placed after the instruction to be lowered) and return the\n resulting nir_def."]
pub type nir_lower_instr_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut nir_builder,
        arg2: *mut nir_instr,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut nir_def,
>;
unsafe extern "C" {
    #[doc = " Iterate over all the instructions in a nir_function_impl and lower them\n  using the provided callbacks\n\n This function implements the guts of a standard lowering pass for you.  It\n iterates over all of the instructions in a nir_function_impl and calls the\n filter callback on each one.  If the filter callback returns true, it then\n calls the lowering call back on the instruction.  (Splitting it this way\n allows us to avoid some save/restore work for instructions we know won't be\n lowered.)  If the instruction is dead after the lowering is complete, it\n will be removed.  If new instructions are added, the lowering callback will\n also be called on them in case multiple lowerings are required.\n\n If the callback indicates that the original instruction is replaced (either\n through a new SSA def or NIR_LOWER_INSTR_PROGRESS_REPLACE), then the\n instruction is removed along with any now-dead SSA defs it used.\n\n The metadata for the nir_function_impl will also be updated.  If any blocks\n are added (they cannot be removed), dominance and block indices will be\n invalidated."]
    pub fn nir_function_impl_lower_instructions(
        impl_: *mut nir_function_impl,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_lower_instructions(
        shader: *mut nir_shader,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_calc_dominance_impl(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_calc_dominance(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_calc_dominance_lca_impl(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    #[doc = " Computes the lowest common ancestor of two blocks in the dominator tree.\n\n If one of the blocks is null or unreachable, the other block is returned or\n NULL if it's unreachable.\n\n Requires nir_metadata_dominance_lca"]
    pub fn nir_dominance_lca(b1: *mut nir_block, b2: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_dominates(parent: *mut nir_block, child: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_block_is_unreachable(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_dump_dom_tree_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_tree(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_frontier_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_frontier(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_cfg_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_cfg(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_gs_count_vertices_and_primitives(
        shader: *const nir_shader,
        out_vtxcnt: *mut ::std::os::raw::c_int,
        out_prmcnt: *mut ::std::os::raw::c_int,
        out_decomposed_prmcnt: *mut ::std::os::raw::c_int,
        num_streams: ::std::os::raw::c_uint,
    );
}
pub const nir_group_all: nir_load_grouping = 0;
pub const nir_group_same_resource_only: nir_load_grouping = 1;
pub type nir_load_grouping = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_opt_group_loads(
        shader: *mut nir_shader,
        grouping: nir_load_grouping,
        max_distance: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_shrink_vec_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_var_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_per_member_structs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_struct_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_returns_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_returns(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_inline_function_impl(
        b: *mut nir_builder,
        impl_: *const nir_function_impl,
        params: *mut *mut nir_def,
        shader_var_remap: *mut hash_table,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_inline_functions(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_cleanup_functions(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_link_shader_functions(
        shader: *mut nir_shader,
        link_shader: *const nir_shader,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_calls_to_builtins(s: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_find_inlinable_uniforms(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_inline_uniforms(
        shader: *mut nir_shader,
        num_uniforms: ::std::os::raw::c_uint,
        uniform_values: *const u32,
        uniform_dw_offsets: *const u16,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_collect_src_uniforms(
        src: *const nir_src,
        component: ::std::os::raw::c_int,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_add_inlinable_uniforms(
        cond: *const nir_src,
        info: *mut nir_loop_info,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn nir_inline_sysval(shader: *mut nir_shader, op: nir_intrinsic_op, imm: u64) -> bool;
}
unsafe extern "C" {
    pub fn nir_propagate_invariant(shader: *mut nir_shader, invariant_prim: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_var_copy_instr(copy: *mut nir_intrinsic_instr, shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_lower_deref_copy_instr(b: *mut nir_builder, copy: *mut nir_intrinsic_instr);
}
unsafe extern "C" {
    pub fn nir_lower_var_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_memcpy(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_memcpy(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_fixup_deref_modes(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_fixup_deref_types(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_global_vars_to_local(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_constant_to_temp(shader: *mut nir_shader);
}
pub const nir_lower_direct_array_deref_of_vec_load: nir_lower_array_deref_of_vec_options = 1;
pub const nir_lower_indirect_array_deref_of_vec_load: nir_lower_array_deref_of_vec_options = 2;
pub const nir_lower_direct_array_deref_of_vec_store: nir_lower_array_deref_of_vec_options = 4;
pub const nir_lower_indirect_array_deref_of_vec_store: nir_lower_array_deref_of_vec_options = 8;
pub type nir_lower_array_deref_of_vec_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_array_deref_of_vec(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        filter: ::std::option::Option<unsafe extern "C" fn(arg1: *mut nir_variable) -> bool>,
        options: nir_lower_array_deref_of_vec_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_indirect_derefs(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        max_lower_array_len: u32,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_indirect_var_derefs(shader: *mut nir_shader, vars: *const set) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_locals_to_regs(shader: *mut nir_shader, bool_bitsize: u8) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_vars_to_temporaries(
        shader: *mut nir_shader,
        entrypoint: *mut nir_function_impl,
        outputs: bool,
        inputs: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_scratch(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        size_threshold: ::std::os::raw::c_int,
        variable_size_align: glsl_type_size_align_func,
        scratch_layout_size_align: glsl_type_size_align_func,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_scratch_to_var(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_halfz(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_gather_info(shader: *mut nir_shader, entrypoint: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_gather_types(
        impl_: *mut nir_function_impl,
        float_types: *mut ::std::os::raw::c_uint,
        int_types: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn nir_remove_unused_varyings(producer: *mut nir_shader, consumer: *mut nir_shader)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_unused_io_vars(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        used_by_other_stage: *mut u64,
        used_by_other_stage_patches: *mut u64,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_compact_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        default_to_smooth_interp: bool,
    );
}
unsafe extern "C" {
    pub fn nir_link_xfb_varyings(producer: *mut nir_shader, consumer: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_link_opt_varyings(producer: *mut nir_shader, consumer: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_link_varying_precision(producer: *mut nir_shader, consumer: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_clone_uniform_variable(
        nir: *mut nir_shader,
        uniform: *mut nir_variable,
        spirv: bool,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_clone_deref_instr(
        b: *mut nir_builder,
        var: *mut nir_variable,
        deref: *mut nir_deref_instr,
    ) -> *mut nir_deref_instr;
}
pub const nir_progress_producer: nir_opt_varyings_progress = 1;
pub const nir_progress_consumer: nir_opt_varyings_progress = 2;
pub type nir_opt_varyings_progress = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_opt_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        spirv: bool,
        max_uniform_components: ::std::os::raw::c_uint,
        max_ubos_per_stage: ::std::os::raw::c_uint,
        debug_no_algebraic: bool,
    ) -> nir_opt_varyings_progress;
}
unsafe extern "C" {
    pub fn nir_varying_var_mask(nir: *mut nir_shader) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_opt_varyings_bulk(
        shaders: *mut *mut nir_shader,
        num_shaders: u32,
        spirv: bool,
        max_uniform_comps: ::std::os::raw::c_uint,
        max_ubos: ::std::os::raw::c_uint,
        optimize: ::std::option::Option<unsafe extern "C" fn(arg1: *mut nir_shader)>,
    );
}
unsafe extern "C" {
    pub fn nir_slot_is_sysval_output(slot: gl_varying_slot, next_shader: mesa_shader_stage)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_slot_is_varying(slot: gl_varying_slot, next_shader: mesa_shader_stage) -> bool;
}
unsafe extern "C" {
    pub fn nir_slot_is_sysval_output_and_varying(
        slot: gl_varying_slot,
        next_shader: mesa_shader_stage,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_varying(
        intr: *mut nir_intrinsic_instr,
        next_shader: mesa_shader_stage,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_sysval_output(
        intr: *mut nir_intrinsic_instr,
        next_shader: mesa_shader_stage,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_amul(
        shader: *mut nir_shader,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_ubo_vec4(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_sort_variables_by_location(shader: *mut nir_shader, mode: nir_variable_mode);
}
unsafe extern "C" {
    pub fn nir_assign_io_var_locations(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        size: *mut ::std::os::raw::c_uint,
        stage: mesa_shader_stage,
    );
}
unsafe extern "C" {
    pub fn nir_opt_clip_cull_const(shader: *mut nir_shader) -> bool;
}
pub const nir_lower_io_lower_64bit_to_32: nir_lower_io_options = 1;
pub const nir_lower_io_lower_64bit_float_to_32: nir_lower_io_options = 2;
pub const nir_lower_io_lower_64bit_to_32_new: nir_lower_io_options = 4;
#[doc = " Should nir_lower_io() create load_interpolated_input intrinsics?\n\n If not, it generates regular load_input intrinsics and interpolation\n information must be inferred from the list of input nir_variables."]
pub const nir_lower_io_use_interpolated_input_intrinsics: nir_lower_io_options = 8;
pub type nir_lower_io_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
        arg1: nir_lower_io_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_io_add_const_offset_to_base(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_passes(nir: *mut nir_shader, renumber_vs_inputs: bool);
}
unsafe extern "C" {
    pub fn nir_io_add_intrinsic_xfb_info(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_indirect_loads(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_explicit_types(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_info: glsl_type_size_align_func,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_gather_explicit_io_initializers(
        shader: *mut nir_shader,
        dst: *mut ::std::os::raw::c_void,
        dst_size: usize,
        mode: nir_variable_mode,
    );
}
unsafe extern "C" {
    pub fn nir_lower_vec3_to_vec4(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_address_format_bit_size(addr_format: nir_address_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_address_format_num_components(
        addr_format: nir_address_format,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_address_format_null_value(addr_format: nir_address_format)
        -> *const nir_const_value;
}
unsafe extern "C" {
    pub fn nir_build_addr_iadd(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: *mut nir_def,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_iadd_imm(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: i64,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_ieq(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_isub(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_explicit_io_address_from_deref(
        b: *mut nir_builder,
        deref: *mut nir_deref_instr,
        base_addr: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_get_explicit_deref_align(
        deref: *mut nir_deref_instr,
        default_to_type_align: bool,
        align_mul: *mut u32,
        align_offset: *mut u32,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_explicit_io_instr(
        b: *mut nir_builder,
        io_instr: *mut nir_intrinsic_instr,
        addr: *mut nir_def,
        addr_format: nir_address_format,
    );
}
unsafe extern "C" {
    pub fn nir_lower_explicit_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        arg1: nir_address_format,
    ) -> bool;
}
pub const nir_mem_access_shift_method_scalar: nir_mem_access_shift_method = 0;
pub const nir_mem_access_shift_method_shift64: nir_mem_access_shift_method = 1;
pub const nir_mem_access_shift_method_bytealign_amd: nir_mem_access_shift_method = 2;
pub type nir_mem_access_shift_method = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_mem_access_size_align {
    pub num_components: u8,
    pub bit_size: u8,
    pub align: u16,
    pub shift: nir_mem_access_shift_method,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_mem_access_size_align"]
        [::std::mem::size_of::<nir_mem_access_size_align>() - 8usize];
    ["Alignment of nir_mem_access_size_align"]
        [::std::mem::align_of::<nir_mem_access_size_align>() - 4usize];
    ["Offset of field: nir_mem_access_size_align::num_components"]
        [::std::mem::offset_of!(nir_mem_access_size_align, num_components) - 0usize];
    ["Offset of field: nir_mem_access_size_align::bit_size"]
        [::std::mem::offset_of!(nir_mem_access_size_align, bit_size) - 1usize];
    ["Offset of field: nir_mem_access_size_align::align"]
        [::std::mem::offset_of!(nir_mem_access_size_align, align) - 2usize];
    ["Offset of field: nir_mem_access_size_align::shift"]
        [::std::mem::offset_of!(nir_mem_access_size_align, shift) - 4usize];
};
impl Default for nir_mem_access_size_align {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_lower_mem_access_bit_sizes_cb = ::std::option::Option<
    unsafe extern "C" fn(
        intrin: nir_intrinsic_op,
        bytes: u8,
        bit_size: u8,
        align_mul: u32,
        align_offset: u32,
        offset_is_const: bool,
        arg1: gl_access_qualifier,
        cb_data: *const ::std::os::raw::c_void,
    ) -> nir_mem_access_size_align,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_lower_mem_access_bit_sizes_options {
    pub callback: nir_lower_mem_access_bit_sizes_cb,
    pub modes: nir_variable_mode,
    pub may_lower_unaligned_stores_to_atomics: bool,
    pub cb_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_mem_access_bit_sizes_options"]
        [::std::mem::size_of::<nir_lower_mem_access_bit_sizes_options>() - 24usize];
    ["Alignment of nir_lower_mem_access_bit_sizes_options"]
        [::std::mem::align_of::<nir_lower_mem_access_bit_sizes_options>() - 8usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::callback"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, callback) - 0usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::modes"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, modes) - 8usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::may_lower_unaligned_stores_to_atomics"] [:: std :: mem :: offset_of ! (nir_lower_mem_access_bit_sizes_options , may_lower_unaligned_stores_to_atomics) - 12usize] ;
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::cb_data"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, cb_data) - 16usize];
};
impl Default for nir_lower_mem_access_bit_sizes_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_lower_mem_access_bit_sizes(
        shader: *mut nir_shader,
        options: *const nir_lower_mem_access_bit_sizes_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_robust_access(
        s: *mut nir_shader,
        filter: nir_intrin_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
pub type nir_should_vectorize_mem_func = ::std::option::Option<
    unsafe extern "C" fn(
        align_mul: ::std::os::raw::c_uint,
        align_offset: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
        num_components: ::std::os::raw::c_uint,
        hole_size: i64,
        low: *mut nir_intrinsic_instr,
        high: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_load_store_vectorize_options {
    pub callback: nir_should_vectorize_mem_func,
    pub modes: nir_variable_mode,
    pub robust_modes: nir_variable_mode,
    pub cb_data: *mut ::std::os::raw::c_void,
    pub has_shared2_amd: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_load_store_vectorize_options"]
        [::std::mem::size_of::<nir_load_store_vectorize_options>() - 32usize];
    ["Alignment of nir_load_store_vectorize_options"]
        [::std::mem::align_of::<nir_load_store_vectorize_options>() - 8usize];
    ["Offset of field: nir_load_store_vectorize_options::callback"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, callback) - 0usize];
    ["Offset of field: nir_load_store_vectorize_options::modes"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, modes) - 8usize];
    ["Offset of field: nir_load_store_vectorize_options::robust_modes"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, robust_modes) - 12usize];
    ["Offset of field: nir_load_store_vectorize_options::cb_data"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, cb_data) - 16usize];
    ["Offset of field: nir_load_store_vectorize_options::has_shared2_amd"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, has_shared2_amd) - 24usize];
};
impl Default for nir_load_store_vectorize_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_load_store_vectorize(
        shader: *mut nir_shader,
        options: *const nir_load_store_vectorize_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_load_store_update_alignments(shader: *mut nir_shader) -> bool;
}
pub type nir_lower_shader_calls_should_remat_func = ::std::option::Option<
    unsafe extern "C" fn(instr: *mut nir_instr, data: *mut ::std::os::raw::c_void) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_lower_shader_calls_options {
    pub address_format: nir_address_format,
    pub stack_alignment: ::std::os::raw::c_uint,
    pub localized_loads: bool,
    pub vectorizer_callback: nir_should_vectorize_mem_func,
    pub vectorizer_data: *mut ::std::os::raw::c_void,
    pub should_remat_callback: nir_lower_shader_calls_should_remat_func,
    pub should_remat_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_shader_calls_options"]
        [::std::mem::size_of::<nir_lower_shader_calls_options>() - 48usize];
    ["Alignment of nir_lower_shader_calls_options"]
        [::std::mem::align_of::<nir_lower_shader_calls_options>() - 8usize];
    ["Offset of field: nir_lower_shader_calls_options::address_format"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, address_format) - 0usize];
    ["Offset of field: nir_lower_shader_calls_options::stack_alignment"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, stack_alignment) - 4usize];
    ["Offset of field: nir_lower_shader_calls_options::localized_loads"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, localized_loads) - 8usize];
    ["Offset of field: nir_lower_shader_calls_options::vectorizer_callback"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, vectorizer_callback) - 16usize];
    ["Offset of field: nir_lower_shader_calls_options::vectorizer_data"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, vectorizer_data) - 24usize];
    ["Offset of field: nir_lower_shader_calls_options::should_remat_callback"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, should_remat_callback) - 32usize];
    ["Offset of field: nir_lower_shader_calls_options::should_remat_data"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, should_remat_data) - 40usize];
};
impl Default for nir_lower_shader_calls_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_lower_shader_calls(
        shader: *mut nir_shader,
        options: *const nir_lower_shader_calls_options,
        resume_shaders_out: *mut *mut *mut nir_shader,
        num_resume_shaders_out: *mut u32,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_get_io_offset_src_number(instr: *const nir_intrinsic_instr)
        -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nir_get_io_index_src_number(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nir_get_io_arrayed_index_src_number(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nir_get_io_offset_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_get_io_index_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_get_io_arrayed_index_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_get_shader_call_payload_src(call: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_is_output_load(intr: *mut nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_is_arrayed_io(var: *const nir_variable, stage: mesa_shader_stage) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_io_offset {
    pub def: *mut nir_def,
    pub shift: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_offset"][::std::mem::size_of::<nir_io_offset>() - 16usize];
    ["Alignment of nir_io_offset"][::std::mem::align_of::<nir_io_offset>() - 8usize];
    ["Offset of field: nir_io_offset::def"][::std::mem::offset_of!(nir_io_offset, def) - 0usize];
    ["Offset of field: nir_io_offset::shift"]
        [::std::mem::offset_of!(nir_io_offset, shift) - 8usize];
};
impl Default for nir_io_offset {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_io_offset_iadd(
        b: *mut nir_builder,
        intr: *mut nir_intrinsic_instr,
        offset_diff_bytes: ::std::os::raw::c_int,
    ) -> nir_io_offset;
}
unsafe extern "C" {
    pub fn nir_set_io_offset(intr: *mut nir_intrinsic_instr, offset: nir_io_offset);
}
unsafe extern "C" {
    pub fn nir_add_io_offset(
        b: *mut nir_builder,
        intr: *mut nir_intrinsic_instr,
        offset_diff_bytes: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_dead_derefs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_dead_derefs_impl(impl_: *mut nir_function_impl) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_remove_dead_variables_options {
    pub can_remove_var: ::std::option::Option<
        unsafe extern "C" fn(var: *mut nir_variable, data: *mut ::std::os::raw::c_void) -> bool,
    >,
    pub can_remove_var_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_remove_dead_variables_options"]
        [::std::mem::size_of::<nir_remove_dead_variables_options>() - 16usize];
    ["Alignment of nir_remove_dead_variables_options"]
        [::std::mem::align_of::<nir_remove_dead_variables_options>() - 8usize];
    ["Offset of field: nir_remove_dead_variables_options::can_remove_var"]
        [::std::mem::offset_of!(nir_remove_dead_variables_options, can_remove_var) - 0usize];
    ["Offset of field: nir_remove_dead_variables_options::can_remove_var_data"]
        [::std::mem::offset_of!(nir_remove_dead_variables_options, can_remove_var_data) - 8usize];
};
impl Default for nir_remove_dead_variables_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_remove_dead_variables(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        options: *const nir_remove_dead_variables_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_variable_initializers(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_zero_initialize_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_clear_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
pub const nir_move_to_entry_block_only: nir_opt_move_to_top_options = 1;
pub const nir_move_to_top_input_loads: nir_opt_move_to_top_options = 2;
pub const nir_move_to_top_load_smem_amd: nir_opt_move_to_top_options = 4;
pub type nir_opt_move_to_top_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_opt_move_to_top(nir: *mut nir_shader, options: nir_opt_move_to_top_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_move_vec_src_uses_to_dest(shader: *mut nir_shader, skip_const_srcs: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_move_output_stores_to_end(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vec_to_regs(
        shader: *mut nir_shader,
        cb: nir_instr_writemask_filter_cb,
        _data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alpha_to_coverage(
        shader: *mut nir_shader,
        nr_samples: u8,
        has_intrinsic: bool,
        dyn_enable: *mut nir_def,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alpha_to_one(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_flrp(
        shader: *mut nir_shader,
        lowering_mask: ::std::os::raw::c_uint,
        always_precise: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_scale_fdiv(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_to_scalar(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_width(
        shader: *mut nir_shader,
        cb: nir_vectorize_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_vec8_16_srcs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_bitsize(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_float(shader: *mut nir_shader, has_fcsel_ne: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_int32(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_simplify_convert_alu_types(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_const_arrays_to_uniforms(
        shader: *mut nir_shader,
        max_uniform_components: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_convert_alu_types(
        shader: *mut nir_shader,
        should_lower: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut nir_intrinsic_instr) -> bool,
        >,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_constant_convert_alu_types(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_conversion_to_intrinsic(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int_to_float(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_load_const_to_scalar(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_read_invocation_to_scalar(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_phis_to_scalar(
        shader: *mut nir_shader,
        cb: nir_vectorize_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_all_phis_to_scalar(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_array_vars_to_elements(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
    );
}
unsafe extern "C" {
    pub fn nir_lower_io_array_vars_to_elements_no_indirects(
        shader: *mut nir_shader,
        outputs_only: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_to_scalar(
        shader: *mut nir_shader,
        mask: nir_variable_mode,
        filter: nir_instr_filter_cb,
        filter_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_vars_to_scalar(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_vectorize_io_vars(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_tess_level_array_vars_to_vec(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_tcs_impl(
        options: *const nir_shader_compiler_options,
        locations: *mut ::std::os::raw::c_uint,
        num_locations: ::std::os::raw::c_uint,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_tcs(
        options: *const nir_shader_compiler_options,
        vs: *const nir_shader,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_gs(
        options: *const nir_shader_compiler_options,
        prev_stage: *const nir_shader,
        primitive_type: mesa_prim,
        output_primitive_type: mesa_prim,
        emulate_edgeflags: bool,
        force_line_strip_out: bool,
        passthrough_prim_id: bool,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_lower_fragcolor(shader: *mut nir_shader, max_cbufs: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_fragcoord_wtrans(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_frag_coord_to_pixel_coord(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_frag_coord_to_pixel_coord(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_viewport_transform(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_uniforms_to_ubo(
        shader: *mut nir_shader,
        dword_packed: bool,
        load_vec4: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_is_helper_invocation(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_single_sampled(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_sample_shading(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_atomics(shader: *mut nir_shader, filter: nir_instr_filter_cb) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_lower_subgroups_options {
    pub filter: nir_intrin_filter_cb,
    pub filter_data: *const ::std::os::raw::c_void,
    pub subgroup_size: u8,
    pub ballot_bit_size: u8,
    pub ballot_components: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_subgroups_options"]
        [::std::mem::size_of::<nir_lower_subgroups_options>() - 24usize];
    ["Alignment of nir_lower_subgroups_options"]
        [::std::mem::align_of::<nir_lower_subgroups_options>() - 8usize];
    ["Offset of field: nir_lower_subgroups_options::filter"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, filter) - 0usize];
    ["Offset of field: nir_lower_subgroups_options::filter_data"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, filter_data) - 8usize];
    ["Offset of field: nir_lower_subgroups_options::subgroup_size"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, subgroup_size) - 16usize];
    ["Offset of field: nir_lower_subgroups_options::ballot_bit_size"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, ballot_bit_size) - 17usize];
    ["Offset of field: nir_lower_subgroups_options::ballot_components"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, ballot_components) - 18usize];
};
impl Default for nir_lower_subgroups_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_lower_subgroups_options {
    #[inline]
    pub fn lower_to_scalar(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_to_scalar(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_to_scalar_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_to_scalar_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_trivial(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_trivial(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_trivial_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_trivial_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_feq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_feq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_feq_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_feq_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_ieq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_ieq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_ieq_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_ieq_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_bool_eq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_bool_eq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_bool_eq_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_bool_eq_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_first_invocation_to_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_first_invocation_to_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_first_invocation_to_ballot_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_first_invocation_to_ballot_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_read_first_invocation(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_first_invocation(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_read_first_invocation_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_read_first_invocation_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_subgroup_masks(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_subgroup_masks(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_subgroup_masks_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_subgroup_masks_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_relative_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_relative_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_relative_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_relative_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle_to_32bit(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_32bit(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_to_32bit_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_to_32bit_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle_to_swizzle_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_swizzle_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_to_swizzle_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_to_swizzle_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_broadcast_dynamic_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_broadcast_dynamic_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic_to_const(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic_to_const(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_broadcast_dynamic_to_const_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_broadcast_dynamic_to_const_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_vote(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_vote(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_vote_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_vote_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_elect(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_elect(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_elect_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_elect_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_read_invocation_to_cond(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_invocation_to_cond(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_read_invocation_to_cond_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_read_invocation_to_cond_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_rotate_to_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_rotate_to_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_rotate_to_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_rotate_to_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_rotate_clustered_to_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_rotate_clustered_to_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_rotate_clustered_to_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_rotate_clustered_to_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_ballot_bit_count_to_mbcnt_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_ballot_bit_count_to_mbcnt_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_ballot_bit_count_to_mbcnt_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_ballot_bit_count_to_mbcnt_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_inverse_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_inverse_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_inverse_ballot_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_inverse_ballot_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_reduce(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_reduce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_reduce_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_reduce_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_boolean_reduce(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_reduce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_boolean_reduce_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_boolean_reduce_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_boolean_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_boolean_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_boolean_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lower_to_scalar: bool,
        lower_vote_trivial: bool,
        lower_vote_feq: bool,
        lower_vote_ieq: bool,
        lower_vote_bool_eq: bool,
        lower_first_invocation_to_ballot: bool,
        lower_read_first_invocation: bool,
        lower_subgroup_masks: bool,
        lower_relative_shuffle: bool,
        lower_shuffle_to_32bit: bool,
        lower_shuffle_to_swizzle_amd: bool,
        lower_shuffle: bool,
        lower_quad: bool,
        lower_quad_broadcast_dynamic: bool,
        lower_quad_broadcast_dynamic_to_const: bool,
        lower_quad_vote: bool,
        lower_elect: bool,
        lower_read_invocation_to_cond: bool,
        lower_rotate_to_shuffle: bool,
        lower_rotate_clustered_to_shuffle: bool,
        lower_ballot_bit_count_to_mbcnt_amd: bool,
        lower_inverse_ballot: bool,
        lower_reduce: bool,
        lower_boolean_reduce: bool,
        lower_boolean_shuffle: bool,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let lower_to_scalar: u8 = unsafe { ::std::mem::transmute(lower_to_scalar) };
            lower_to_scalar as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let lower_vote_trivial: u8 = unsafe { ::std::mem::transmute(lower_vote_trivial) };
            lower_vote_trivial as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let lower_vote_feq: u8 = unsafe { ::std::mem::transmute(lower_vote_feq) };
            lower_vote_feq as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let lower_vote_ieq: u8 = unsafe { ::std::mem::transmute(lower_vote_ieq) };
            lower_vote_ieq as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_vote_bool_eq: u8 = unsafe { ::std::mem::transmute(lower_vote_bool_eq) };
            lower_vote_bool_eq as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_first_invocation_to_ballot: u8 =
                unsafe { ::std::mem::transmute(lower_first_invocation_to_ballot) };
            lower_first_invocation_to_ballot as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let lower_read_first_invocation: u8 =
                unsafe { ::std::mem::transmute(lower_read_first_invocation) };
            lower_read_first_invocation as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let lower_subgroup_masks: u8 = unsafe { ::std::mem::transmute(lower_subgroup_masks) };
            lower_subgroup_masks as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let lower_relative_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_relative_shuffle) };
            lower_relative_shuffle as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let lower_shuffle_to_32bit: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_32bit) };
            lower_shuffle_to_32bit as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let lower_shuffle_to_swizzle_amd: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_swizzle_amd) };
            lower_shuffle_to_swizzle_amd as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let lower_shuffle: u8 = unsafe { ::std::mem::transmute(lower_shuffle) };
            lower_shuffle as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let lower_quad: u8 = unsafe { ::std::mem::transmute(lower_quad) };
            lower_quad as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let lower_quad_broadcast_dynamic: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic) };
            lower_quad_broadcast_dynamic as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let lower_quad_broadcast_dynamic_to_const: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic_to_const) };
            lower_quad_broadcast_dynamic_to_const as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let lower_quad_vote: u8 = unsafe { ::std::mem::transmute(lower_quad_vote) };
            lower_quad_vote as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let lower_elect: u8 = unsafe { ::std::mem::transmute(lower_elect) };
            lower_elect as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let lower_read_invocation_to_cond: u8 =
                unsafe { ::std::mem::transmute(lower_read_invocation_to_cond) };
            lower_read_invocation_to_cond as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let lower_rotate_to_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_rotate_to_shuffle) };
            lower_rotate_to_shuffle as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let lower_rotate_clustered_to_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_rotate_clustered_to_shuffle) };
            lower_rotate_clustered_to_shuffle as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lower_ballot_bit_count_to_mbcnt_amd: u8 =
                unsafe { ::std::mem::transmute(lower_ballot_bit_count_to_mbcnt_amd) };
            lower_ballot_bit_count_to_mbcnt_amd as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let lower_inverse_ballot: u8 = unsafe { ::std::mem::transmute(lower_inverse_ballot) };
            lower_inverse_ballot as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let lower_reduce: u8 = unsafe { ::std::mem::transmute(lower_reduce) };
            lower_reduce as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let lower_boolean_reduce: u8 = unsafe { ::std::mem::transmute(lower_boolean_reduce) };
            lower_boolean_reduce as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let lower_boolean_shuffle: u8 = unsafe { ::std::mem::transmute(lower_boolean_shuffle) };
            lower_boolean_shuffle as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_subgroups(
        shader: *mut nir_shader,
        options: *const nir_lower_subgroups_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_system_values(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_build_lowered_load_helper_invocation(b: *mut nir_builder) -> *mut nir_def;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_compute_system_values_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub num_workgroups: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_compute_system_values_options"]
        [::std::mem::size_of::<nir_lower_compute_system_values_options>() - 16usize];
    ["Alignment of nir_lower_compute_system_values_options"]
        [::std::mem::align_of::<nir_lower_compute_system_values_options>() - 4usize];
    ["Offset of field: nir_lower_compute_system_values_options::num_workgroups"]
        [::std::mem::offset_of!(nir_lower_compute_system_values_options, num_workgroups) - 4usize];
};
impl nir_lower_compute_system_values_options {
    #[inline]
    pub fn has_base_global_invocation_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_global_invocation_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_base_global_invocation_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_base_global_invocation_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_base_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_base_workgroup_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_base_workgroup_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_global_size(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_global_size(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_global_size_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_global_size_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shuffle_local_ids_for_quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shuffle_local_ids_for_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shuffle_local_ids_for_quad_derivatives_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shuffle_local_ids_for_quad_derivatives_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_local_invocation_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_local_invocation_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_local_invocation_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_local_invocation_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_cs_local_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_cs_local_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_cs_local_id_to_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_cs_local_id_to_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_workgroup_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_workgroup_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_workgroup_id_to_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_workgroup_id_to_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn global_id_is_32bit(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_global_id_is_32bit(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn global_id_is_32bit_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_global_id_is_32bit_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shortcut_1d_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shortcut_1d_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shortcut_1d_workgroup_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shortcut_1d_workgroup_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        has_base_global_invocation_id: bool,
        has_base_workgroup_id: bool,
        has_global_size: bool,
        shuffle_local_ids_for_quad_derivatives: bool,
        lower_local_invocation_index: bool,
        lower_cs_local_id_to_index: bool,
        lower_workgroup_id_to_index: bool,
        global_id_is_32bit: bool,
        shortcut_1d_workgroup_id: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_base_global_invocation_id: u8 =
                unsafe { ::std::mem::transmute(has_base_global_invocation_id) };
            has_base_global_invocation_id as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_base_workgroup_id: u8 = unsafe { ::std::mem::transmute(has_base_workgroup_id) };
            has_base_workgroup_id as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let has_global_size: u8 = unsafe { ::std::mem::transmute(has_global_size) };
            has_global_size as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let shuffle_local_ids_for_quad_derivatives: u8 =
                unsafe { ::std::mem::transmute(shuffle_local_ids_for_quad_derivatives) };
            shuffle_local_ids_for_quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_local_invocation_index: u8 =
                unsafe { ::std::mem::transmute(lower_local_invocation_index) };
            lower_local_invocation_index as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_cs_local_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_cs_local_id_to_index) };
            lower_cs_local_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let lower_workgroup_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_workgroup_id_to_index) };
            lower_workgroup_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let global_id_is_32bit: u8 = unsafe { ::std::mem::transmute(global_id_is_32bit) };
            global_id_is_32bit as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let shortcut_1d_workgroup_id: u8 =
                unsafe { ::std::mem::transmute(shortcut_1d_workgroup_id) };
            shortcut_1d_workgroup_id as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_compute_system_values(
        shader: *mut nir_shader,
        options: *const nir_lower_compute_system_values_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_sysvals_to_varyings_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_sysvals_to_varyings_options"]
        [::std::mem::size_of::<nir_lower_sysvals_to_varyings_options>() - 1usize];
    ["Alignment of nir_lower_sysvals_to_varyings_options"]
        [::std::mem::align_of::<nir_lower_sysvals_to_varyings_options>() - 1usize];
};
impl nir_lower_sysvals_to_varyings_options {
    #[inline]
    pub fn frag_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_frag_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn frag_coord_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_frag_coord_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn front_face(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_front_face(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn front_face_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_front_face_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn point_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn point_coord_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_point_coord_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        frag_coord: bool,
        front_face: bool,
        point_coord: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let frag_coord: u8 = unsafe { ::std::mem::transmute(frag_coord) };
            frag_coord as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let front_face: u8 = unsafe { ::std::mem::transmute(front_face) };
            front_face as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let point_coord: u8 = unsafe { ::std::mem::transmute(point_coord) };
            point_coord as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_sysvals_to_varyings(
        shader: *mut nir_shader,
        options: *const nir_lower_sysvals_to_varyings_options,
    ) -> bool;
}
#[doc = " No packing"]
pub const nir_lower_tex_packing_none: nir_lower_tex_packing = 0;
#[doc = " The sampler returns up to 2 32-bit words of half floats or 16-bit signed\n or unsigned ints based on the sampler type"]
pub const nir_lower_tex_packing_16: nir_lower_tex_packing = 1;
#[doc = " The sampler returns 1 32-bit word of 4x8 unorm"]
pub const nir_lower_tex_packing_8: nir_lower_tex_packing = 2;
pub type nir_lower_tex_packing = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_lower_tex_options {
    #[doc = " bitmask of (1 << GLSL_SAMPLER_DIM_x) to control for which\n sampler types a texture projector is lowered."]
    pub lower_txp: ::std::os::raw::c_uint,
    #[doc = " If true, lower texture projector for any array sampler dims"]
    pub lower_txp_array: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all texelfetch instructions."]
    pub lower_txf_offset: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all rect textures."]
    pub lower_rect_offset: bool,
    #[doc = " If not NULL, this filter will return true for tex instructions that\n should lower away nir_tex_src_offset."]
    pub lower_offset_filter: nir_instr_filter_cb,
    #[doc = " If true, lower rect textures to 2D, using txs to fetch the\n texture dimensions and dividing the texture coords by the\n texture dims to normalize."]
    pub lower_rect: bool,
    #[doc = " If true, lower 1D textures to 2D. This requires the GL/VK driver to map 1D\n textures to 2D textures with height=1.\n\n lower_1d_shadow does this lowering for shadow textures only."]
    pub lower_1d: bool,
    pub lower_1d_shadow: bool,
    #[doc = " If true, convert yuv to rgb."]
    pub lower_y_uv_external: ::std::os::raw::c_uint,
    pub lower_y_vu_external: ::std::os::raw::c_uint,
    pub lower_y_u_v_external: ::std::os::raw::c_uint,
    pub lower_yx_xuxv_external: ::std::os::raw::c_uint,
    pub lower_yx_xvxu_external: ::std::os::raw::c_uint,
    pub lower_xy_uxvx_external: ::std::os::raw::c_uint,
    pub lower_xy_vxux_external: ::std::os::raw::c_uint,
    pub lower_ayuv_external: ::std::os::raw::c_uint,
    pub lower_xyuv_external: ::std::os::raw::c_uint,
    pub lower_yuv_external: ::std::os::raw::c_uint,
    pub lower_yu_yv_external: ::std::os::raw::c_uint,
    pub lower_yv_yu_external: ::std::os::raw::c_uint,
    pub lower_y41x_external: ::std::os::raw::c_uint,
    pub lower_sx10_external: ::std::os::raw::c_uint,
    pub lower_sx12_external: ::std::os::raw::c_uint,
    pub bt709_external: ::std::os::raw::c_uint,
    pub bt2020_external: ::std::os::raw::c_uint,
    pub yuv_full_range_external: ::std::os::raw::c_uint,
    #[doc = " To emulate certain texture wrap modes, this can be used\n to saturate the specified tex coord to [0.0, 1.0].  The\n bits are according to sampler #, ie. if, for example:\n\n   (conf->saturate_s & (1 << n))\n\n is true, then the s coord for sampler n is saturated.\n\n Note that clamping must happen *after* projector lowering\n so any projected texture sample instruction with a clamped\n coordinate gets automatically lowered, regardless of the\n 'lower_txp' setting."]
    pub saturate_s: ::std::os::raw::c_uint,
    pub saturate_t: ::std::os::raw::c_uint,
    pub saturate_r: ::std::os::raw::c_uint,
    pub swizzle_result: ::std::os::raw::c_uint,
    pub swizzles: [[u8; 4usize]; 32usize],
    pub scale_factors: [f32; 32usize],
    #[doc = " Bitmap of textures that need srgb to linear conversion.  If\n (lower_srgb & (1 << texture_index)) then the rgb (xyz) components\n of the texture are lowered to linear."]
    pub lower_srgb: ::std::os::raw::c_uint,
    #[doc = " If true, lower nir_texop_txd on cube maps with nir_texop_txl."]
    pub lower_txd_cube_map: bool,
    #[doc = " If true, lower nir_texop_txd on 3D surfaces with nir_texop_txl."]
    pub lower_txd_3d: bool,
    #[doc = " If true, lower nir_texop_txd any array surfaces with nir_texop_txl."]
    pub lower_txd_array: bool,
    #[doc = " If true, lower nir_texop_txd on shadow samplers (except cube maps)\n with nir_texop_txl. Notice that cube map shadow samplers are lowered\n with lower_txd_cube_map."]
    pub lower_txd_shadow: bool,
    #[doc = " If true, lower nir_texop_txd on all samplers to a nir_texop_txl.\n Implies lower_txd_cube_map and lower_txd_shadow."]
    pub lower_txd: bool,
    #[doc = " If true, lower nir_texop_txd  when it uses min_lod."]
    pub lower_txd_clamp: bool,
    #[doc = " If true, lower nir_texop_txb that try to use shadow compare and min_lod\n at the same time to a nir_texop_lod, some math, and nir_texop_tex."]
    pub lower_txb_shadow_clamp: bool,
    #[doc = " A generic callback to nir_texop_txd."]
    pub lower_txd_cb: ::std::option::Option<
        unsafe extern "C" fn(
            tex: *const nir_tex_instr,
            data: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub lower_txd_data: *const ::std::os::raw::c_void,
    #[doc = " If true, lower nir_texop_txs with a non-0-lod into nir_texop_txs with\n 0-lod followed by a nir_ishr."]
    pub lower_txs_lod: bool,
    #[doc = " If true, lower nir_texop_txs for cube arrays to a nir_texop_txs with a\n 2D array type followed by a nir_idiv by 6."]
    pub lower_txs_cube_array: bool,
    #[doc = " If true, apply a .bagr swizzle on tg4 results to handle Broadcom's\n mixed-up tg4 locations."]
    pub lower_tg4_broadcom_swizzle: bool,
    #[doc = " If true, lowers tg4 with 4 constant offsets to 4 tg4 calls"]
    pub lower_tg4_offsets: bool,
    #[doc = " Lower txf_ms to fragment_mask_fetch and fragment_fetch and samples_identical to\n fragment_mask_fetch."]
    pub lower_to_fragment_fetch_amd: bool,
    #[doc = " To lower packed sampler return formats. This will be called for all\n tex instructions."]
    pub lower_tex_packing_cb: ::std::option::Option<
        unsafe extern "C" fn(
            tex: *const nir_tex_instr,
            data: *const ::std::os::raw::c_void,
        ) -> nir_lower_tex_packing,
    >,
    pub lower_tex_packing_data: *const ::std::os::raw::c_void,
    #[doc = " If true, lower nir_texop_lod to return -FLT_MAX if the sum of the\n absolute values of derivatives is 0 for all coordinates."]
    pub lower_lod_zero_width: bool,
    #[doc = " If true, emulates sampler descriptor LOD bias by adding the sampler\n LOD bias to every texture instruction's LOD."]
    pub lower_sampler_lod_bias: bool,
    pub lower_invalid_implicit_lod: bool,
    pub lower_index_to_offset: bool,
    #[doc = " Payload data to be sent to callback / filter functions."]
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_tex_options"][::std::mem::size_of::<nir_lower_tex_options>() - 432usize];
    ["Alignment of nir_lower_tex_options"]
        [::std::mem::align_of::<nir_lower_tex_options>() - 8usize];
    ["Offset of field: nir_lower_tex_options::lower_txp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txp) - 0usize];
    ["Offset of field: nir_lower_tex_options::lower_txp_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txp_array) - 4usize];
    ["Offset of field: nir_lower_tex_options::lower_txf_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txf_offset) - 5usize];
    ["Offset of field: nir_lower_tex_options::lower_rect_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_rect_offset) - 6usize];
    ["Offset of field: nir_lower_tex_options::lower_offset_filter"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_offset_filter) - 8usize];
    ["Offset of field: nir_lower_tex_options::lower_rect"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_rect) - 16usize];
    ["Offset of field: nir_lower_tex_options::lower_1d"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_1d) - 17usize];
    ["Offset of field: nir_lower_tex_options::lower_1d_shadow"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_1d_shadow) - 18usize];
    ["Offset of field: nir_lower_tex_options::lower_y_uv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_uv_external) - 20usize];
    ["Offset of field: nir_lower_tex_options::lower_y_vu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_vu_external) - 24usize];
    ["Offset of field: nir_lower_tex_options::lower_y_u_v_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_u_v_external) - 28usize];
    ["Offset of field: nir_lower_tex_options::lower_yx_xuxv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yx_xuxv_external) - 32usize];
    ["Offset of field: nir_lower_tex_options::lower_yx_xvxu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yx_xvxu_external) - 36usize];
    ["Offset of field: nir_lower_tex_options::lower_xy_uxvx_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xy_uxvx_external) - 40usize];
    ["Offset of field: nir_lower_tex_options::lower_xy_vxux_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xy_vxux_external) - 44usize];
    ["Offset of field: nir_lower_tex_options::lower_ayuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_ayuv_external) - 48usize];
    ["Offset of field: nir_lower_tex_options::lower_xyuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xyuv_external) - 52usize];
    ["Offset of field: nir_lower_tex_options::lower_yuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yuv_external) - 56usize];
    ["Offset of field: nir_lower_tex_options::lower_yu_yv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yu_yv_external) - 60usize];
    ["Offset of field: nir_lower_tex_options::lower_yv_yu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yv_yu_external) - 64usize];
    ["Offset of field: nir_lower_tex_options::lower_y41x_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y41x_external) - 68usize];
    ["Offset of field: nir_lower_tex_options::lower_sx10_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_sx10_external) - 72usize];
    ["Offset of field: nir_lower_tex_options::lower_sx12_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_sx12_external) - 76usize];
    ["Offset of field: nir_lower_tex_options::bt709_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, bt709_external) - 80usize];
    ["Offset of field: nir_lower_tex_options::bt2020_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, bt2020_external) - 84usize];
    ["Offset of field: nir_lower_tex_options::yuv_full_range_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, yuv_full_range_external) - 88usize];
    ["Offset of field: nir_lower_tex_options::saturate_s"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_s) - 92usize];
    ["Offset of field: nir_lower_tex_options::saturate_t"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_t) - 96usize];
    ["Offset of field: nir_lower_tex_options::saturate_r"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_r) - 100usize];
    ["Offset of field: nir_lower_tex_options::swizzle_result"]
        [::std::mem::offset_of!(nir_lower_tex_options, swizzle_result) - 104usize];
    ["Offset of field: nir_lower_tex_options::swizzles"]
        [::std::mem::offset_of!(nir_lower_tex_options, swizzles) - 108usize];
    ["Offset of field: nir_lower_tex_options::scale_factors"]
        [::std::mem::offset_of!(nir_lower_tex_options, scale_factors) - 236usize];
    ["Offset of field: nir_lower_tex_options::lower_srgb"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_srgb) - 364usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_cube_map"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_cube_map) - 368usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_3d"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_3d) - 369usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_array) - 370usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_shadow"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_shadow) - 371usize];
    ["Offset of field: nir_lower_tex_options::lower_txd"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd) - 372usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_clamp) - 373usize];
    ["Offset of field: nir_lower_tex_options::lower_txb_shadow_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txb_shadow_clamp) - 374usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_cb"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_cb) - 376usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_data"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_data) - 384usize];
    ["Offset of field: nir_lower_tex_options::lower_txs_lod"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txs_lod) - 392usize];
    ["Offset of field: nir_lower_tex_options::lower_txs_cube_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txs_cube_array) - 393usize];
    ["Offset of field: nir_lower_tex_options::lower_tg4_broadcom_swizzle"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tg4_broadcom_swizzle) - 394usize];
    ["Offset of field: nir_lower_tex_options::lower_tg4_offsets"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tg4_offsets) - 395usize];
    ["Offset of field: nir_lower_tex_options::lower_to_fragment_fetch_amd"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_to_fragment_fetch_amd) - 396usize];
    ["Offset of field: nir_lower_tex_options::lower_tex_packing_cb"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tex_packing_cb) - 400usize];
    ["Offset of field: nir_lower_tex_options::lower_tex_packing_data"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tex_packing_data) - 408usize];
    ["Offset of field: nir_lower_tex_options::lower_lod_zero_width"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_lod_zero_width) - 416usize];
    ["Offset of field: nir_lower_tex_options::lower_sampler_lod_bias"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_sampler_lod_bias) - 417usize];
    ["Offset of field: nir_lower_tex_options::lower_invalid_implicit_lod"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_invalid_implicit_lod) - 418usize];
    ["Offset of field: nir_lower_tex_options::lower_index_to_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_index_to_offset) - 419usize];
    ["Offset of field: nir_lower_tex_options::callback_data"]
        [::std::mem::offset_of!(nir_lower_tex_options, callback_data) - 424usize];
};
impl Default for nir_lower_tex_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Lowers complex texture instructions to simpler ones"]
    pub fn nir_lower_tex(shader: *mut nir_shader, options: *const nir_lower_tex_options) -> bool;
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_tex_shadow_swizzle {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_tex_shadow_swizzle"]
        [::std::mem::size_of::<nir_lower_tex_shadow_swizzle>() - 4usize];
    ["Alignment of nir_lower_tex_shadow_swizzle"]
        [::std::mem::align_of::<nir_lower_tex_shadow_swizzle>() - 4usize];
};
impl nir_lower_tex_shadow_swizzle {
    #[inline]
    pub fn swizzle_r(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_r(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_r_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_r_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_g(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_g(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_g_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_g_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_b(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_b(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_b_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_b_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_a(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_a(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_a_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_a_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        swizzle_r: ::std::os::raw::c_uint,
        swizzle_g: ::std::os::raw::c_uint,
        swizzle_b: ::std::os::raw::c_uint,
        swizzle_a: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let swizzle_r: u32 = unsafe { ::std::mem::transmute(swizzle_r) };
            swizzle_r as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let swizzle_g: u32 = unsafe { ::std::mem::transmute(swizzle_g) };
            swizzle_g as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let swizzle_b: u32 = unsafe { ::std::mem::transmute(swizzle_b) };
            swizzle_b as u64
        });
        __bindgen_bitfield_unit.set(9usize, 3u8, {
            let swizzle_a: u32 = unsafe { ::std::mem::transmute(swizzle_a) };
            swizzle_a as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_tex_shadow(
        s: *mut nir_shader,
        n_states: ::std::os::raw::c_uint,
        compare_func: *mut compare_func,
        tex_swizzles: *mut nir_lower_tex_shadow_swizzle,
        is_fixed_point_format: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_update_image_intrinsic_from_var(nir: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_image_options {
    #[doc = " If true, lower cube size operations."]
    pub lower_cube_size: bool,
    #[doc = " Lower multi sample image load and samples_identical to use fragment_mask_load."]
    pub lower_to_fragment_mask_load_amd: bool,
    #[doc = " Lower image_samples to a constant in case the driver doesn't support multisampled\n images."]
    pub lower_image_samples_to_one: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_image_options"][::std::mem::size_of::<nir_lower_image_options>() - 3usize];
    ["Alignment of nir_lower_image_options"]
        [::std::mem::align_of::<nir_lower_image_options>() - 1usize];
    ["Offset of field: nir_lower_image_options::lower_cube_size"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_cube_size) - 0usize];
    ["Offset of field: nir_lower_image_options::lower_to_fragment_mask_load_amd"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_to_fragment_mask_load_amd) - 1usize];
    ["Offset of field: nir_lower_image_options::lower_image_samples_to_one"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_image_samples_to_one) - 2usize];
};
unsafe extern "C" {
    pub fn nir_lower_image(nir: *mut nir_shader, options: *const nir_lower_image_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_image_atomics_to_global(
        s: *mut nir_shader,
        filter: nir_intrin_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_readonly_images_to_tex(shader: *mut nir_shader, per_variable: bool) -> bool;
}
pub const nir_lower_non_uniform_ubo_access: nir_lower_non_uniform_access_type = 1;
pub const nir_lower_non_uniform_ssbo_access: nir_lower_non_uniform_access_type = 2;
pub const nir_lower_non_uniform_texture_access: nir_lower_non_uniform_access_type = 4;
pub const nir_lower_non_uniform_image_access: nir_lower_non_uniform_access_type = 8;
pub const nir_lower_non_uniform_get_ssbo_size: nir_lower_non_uniform_access_type = 16;
pub const nir_lower_non_uniform_texture_offset_access: nir_lower_non_uniform_access_type = 32;
pub const nir_lower_non_uniform_access_type_count: nir_lower_non_uniform_access_type = 6;
pub type nir_lower_non_uniform_access_type = ::std::os::raw::c_uint;
pub type nir_lower_non_uniform_src_access_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_tex_instr,
        arg2: ::std::os::raw::c_uint,
        arg3: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
pub type nir_lower_non_uniform_access_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_src,
        arg2: *mut ::std::os::raw::c_void,
    ) -> nir_component_mask_t,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_lower_non_uniform_access_options {
    pub types: nir_lower_non_uniform_access_type,
    pub tex_src_callback: nir_lower_non_uniform_src_access_callback,
    pub callback: nir_lower_non_uniform_access_callback,
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_non_uniform_access_options"]
        [::std::mem::size_of::<nir_lower_non_uniform_access_options>() - 32usize];
    ["Alignment of nir_lower_non_uniform_access_options"]
        [::std::mem::align_of::<nir_lower_non_uniform_access_options>() - 8usize];
    ["Offset of field: nir_lower_non_uniform_access_options::types"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, types) - 0usize];
    ["Offset of field: nir_lower_non_uniform_access_options::tex_src_callback"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, tex_src_callback) - 8usize];
    ["Offset of field: nir_lower_non_uniform_access_options::callback"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, callback) - 16usize];
    ["Offset of field: nir_lower_non_uniform_access_options::callback_data"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, callback_data) - 24usize];
};
impl Default for nir_lower_non_uniform_access_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_has_non_uniform_access(
        shader: *mut nir_shader,
        types: nir_lower_non_uniform_access_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_non_uniform_access(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_non_uniform_access(
        shader: *mut nir_shader,
        options: *const nir_lower_non_uniform_access_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_idiv_options {
    pub allow_fp16: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_idiv_options"][::std::mem::size_of::<nir_lower_idiv_options>() - 1usize];
    ["Alignment of nir_lower_idiv_options"]
        [::std::mem::align_of::<nir_lower_idiv_options>() - 1usize];
    ["Offset of field: nir_lower_idiv_options::allow_fp16"]
        [::std::mem::offset_of!(nir_lower_idiv_options, allow_fp16) - 0usize];
};
unsafe extern "C" {
    pub fn nir_lower_idiv(shader: *mut nir_shader, options: *const nir_lower_idiv_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_input_attachment_options {
    pub use_ia_coord_intrin: bool,
    pub use_fragcoord_sysval: bool,
    pub use_layer_id_sysval: bool,
    pub use_view_id_for_layer: bool,
    pub unscaled_depth_stencil_ir3: bool,
    pub unscaled_input_attachment_ir3: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_input_attachment_options"]
        [::std::mem::size_of::<nir_input_attachment_options>() - 12usize];
    ["Alignment of nir_input_attachment_options"]
        [::std::mem::align_of::<nir_input_attachment_options>() - 4usize];
    ["Offset of field: nir_input_attachment_options::use_ia_coord_intrin"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_ia_coord_intrin) - 0usize];
    ["Offset of field: nir_input_attachment_options::use_fragcoord_sysval"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_fragcoord_sysval) - 1usize];
    ["Offset of field: nir_input_attachment_options::use_layer_id_sysval"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_layer_id_sysval) - 2usize];
    ["Offset of field: nir_input_attachment_options::use_view_id_for_layer"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_view_id_for_layer) - 3usize];
    ["Offset of field: nir_input_attachment_options::unscaled_depth_stencil_ir3"]
        [::std::mem::offset_of!(nir_input_attachment_options, unscaled_depth_stencil_ir3) - 4usize];
    ["Offset of field: nir_input_attachment_options::unscaled_input_attachment_ir3"][::std::mem::offset_of!(
        nir_input_attachment_options,
        unscaled_input_attachment_ir3
    ) - 8usize];
};
unsafe extern "C" {
    pub fn nir_lower_input_attachments(
        shader: *mut nir_shader,
        options: *const nir_input_attachment_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_vs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_vars: bool,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [gl_state_index16; 4usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_gs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [gl_state_index16; 4usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_fs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
        use_load_interp: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_cull_distance_to_vec4s(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_cull_distance_array_vars(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_disable(
        shader: *mut nir_shader,
        clip_plane_enable: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_frexp(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_two_sided_color(shader: *mut nir_shader, face_sysval: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clamp_color_outputs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_flatshade(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_passthrough_edgeflags(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_patch_vertices(
        nir: *mut nir_shader,
        static_count: ::std::os::raw::c_uint,
        uniform_state_tokens: *const gl_state_index16,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_wpos_ytransform_options {
    pub state_tokens: [gl_state_index16; 4usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_wpos_ytransform_options"]
        [::std::mem::size_of::<nir_lower_wpos_ytransform_options>() - 10usize];
    ["Alignment of nir_lower_wpos_ytransform_options"]
        [::std::mem::align_of::<nir_lower_wpos_ytransform_options>() - 2usize];
    ["Offset of field: nir_lower_wpos_ytransform_options::state_tokens"]
        [::std::mem::offset_of!(nir_lower_wpos_ytransform_options, state_tokens) - 0usize];
};
impl nir_lower_wpos_ytransform_options {
    #[inline]
    pub fn fs_coord_origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_origin_upper_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_origin_upper_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_origin_lower_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_lower_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_origin_lower_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_origin_lower_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_pixel_center_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_pixel_center_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_half_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_half_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_pixel_center_half_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_pixel_center_half_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fs_coord_origin_upper_left: bool,
        fs_coord_origin_lower_left: bool,
        fs_coord_pixel_center_integer: bool,
        fs_coord_pixel_center_half_integer: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fs_coord_origin_upper_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_upper_left) };
            fs_coord_origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fs_coord_origin_lower_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_lower_left) };
            fs_coord_origin_lower_left as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fs_coord_pixel_center_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_integer) };
            fs_coord_pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fs_coord_pixel_center_half_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_half_integer) };
            fs_coord_pixel_center_half_integer as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_wpos_ytransform(
        shader: *mut nir_shader,
        options: *const nir_lower_wpos_ytransform_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_wpos_center(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_pntc_ytransform(
        shader: *mut nir_shader,
        clipplane_state_tokens: *const [gl_state_index16; 4usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_wrmasks(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_fb_read(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_bitmap_options {
    pub sampler: ::std::os::raw::c_uint,
    pub swizzle_xxxx: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_bitmap_options"]
        [::std::mem::size_of::<nir_lower_bitmap_options>() - 8usize];
    ["Alignment of nir_lower_bitmap_options"]
        [::std::mem::align_of::<nir_lower_bitmap_options>() - 4usize];
    ["Offset of field: nir_lower_bitmap_options::sampler"]
        [::std::mem::offset_of!(nir_lower_bitmap_options, sampler) - 0usize];
    ["Offset of field: nir_lower_bitmap_options::swizzle_xxxx"]
        [::std::mem::offset_of!(nir_lower_bitmap_options, swizzle_xxxx) - 4usize];
};
unsafe extern "C" {
    pub fn nir_lower_bitmap(
        shader: *mut nir_shader,
        options: *const nir_lower_bitmap_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_atomics_to_ssbo(
        shader: *mut nir_shader,
        offset_align_state: ::std::os::raw::c_uint,
    ) -> bool;
}
pub const nir_lower_gs_intrinsics_per_stream: nir_lower_gs_intrinsics_flags = 1;
pub const nir_lower_gs_intrinsics_count_primitives: nir_lower_gs_intrinsics_flags = 2;
pub const nir_lower_gs_intrinsics_count_vertices_per_primitive: nir_lower_gs_intrinsics_flags = 4;
pub const nir_lower_gs_intrinsics_overwrite_incomplete: nir_lower_gs_intrinsics_flags = 8;
pub type nir_lower_gs_intrinsics_flags = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_gs_intrinsics(
        shader: *mut nir_shader,
        options: nir_lower_gs_intrinsics_flags,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_halt_to_return(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_tess_coord_z(shader: *mut nir_shader, triangles: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_task_shader_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub payload_offset_in_bytes: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_task_shader_options"]
        [::std::mem::size_of::<nir_lower_task_shader_options>() - 8usize];
    ["Alignment of nir_lower_task_shader_options"]
        [::std::mem::align_of::<nir_lower_task_shader_options>() - 4usize];
    ["Offset of field: nir_lower_task_shader_options::payload_offset_in_bytes"]
        [::std::mem::offset_of!(nir_lower_task_shader_options, payload_offset_in_bytes) - 4usize];
};
impl nir_lower_task_shader_options {
    #[inline]
    pub fn payload_to_shared_for_atomics(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_atomics(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn payload_to_shared_for_atomics_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_payload_to_shared_for_atomics_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn payload_to_shared_for_small_types(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_small_types(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn payload_to_shared_for_small_types_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_payload_to_shared_for_small_types_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        payload_to_shared_for_atomics: bool,
        payload_to_shared_for_small_types: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let payload_to_shared_for_atomics: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_atomics) };
            payload_to_shared_for_atomics as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let payload_to_shared_for_small_types: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_small_types) };
            payload_to_shared_for_small_types as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_task_shader(
        shader: *mut nir_shader,
        options: nir_lower_task_shader_options,
    ) -> bool;
}
pub type nir_lower_bit_size_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
unsafe extern "C" {
    pub fn nir_lower_bit_size(
        shader: *mut nir_shader,
        callback: nir_lower_bit_size_callback,
        callback_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_64bit_phis(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_split_conversions_options {
    pub callback: nir_lower_bit_size_callback,
    pub callback_data: *mut ::std::os::raw::c_void,
    pub has_convert_alu_types: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_split_conversions_options"]
        [::std::mem::size_of::<nir_split_conversions_options>() - 24usize];
    ["Alignment of nir_split_conversions_options"]
        [::std::mem::align_of::<nir_split_conversions_options>() - 8usize];
    ["Offset of field: nir_split_conversions_options::callback"]
        [::std::mem::offset_of!(nir_split_conversions_options, callback) - 0usize];
    ["Offset of field: nir_split_conversions_options::callback_data"]
        [::std::mem::offset_of!(nir_split_conversions_options, callback_data) - 8usize];
    ["Offset of field: nir_split_conversions_options::has_convert_alu_types"]
        [::std::mem::offset_of!(nir_split_conversions_options, has_convert_alu_types) - 16usize];
};
impl Default for nir_split_conversions_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_split_conversions(
        shader: *mut nir_shader,
        options: *const nir_split_conversions_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_64bit_vec3_and_vec4(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int64_op_to_options_mask(opcode: nir_op) -> nir_lower_int64_options;
}
unsafe extern "C" {
    pub fn nir_lower_int64(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int64_float_conversions(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_doubles_op_to_options_mask(opcode: nir_op) -> nir_lower_doubles_options;
}
unsafe extern "C" {
    pub fn nir_lower_doubles(
        shader: *mut nir_shader,
        softfp64: *const nir_shader,
        options: nir_lower_doubles_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_pack(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_get_io_intrinsic(
        instr: *mut nir_instr,
        modes: nir_variable_mode,
        out_mode: *mut nir_variable_mode,
    ) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    pub fn nir_recompute_io_bases(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_mediump_vars(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_mediump_io(
        nir: *mut nir_shader,
        modes: nir_variable_mode,
        varying_mask: u64,
        use_16bit_slots: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_clear_mediump_io_flag(nir: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_opt_tex_srcs_options {
    pub sampler_dims: ::std::os::raw::c_uint,
    pub src_types: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_tex_srcs_options"]
        [::std::mem::size_of::<nir_opt_tex_srcs_options>() - 8usize];
    ["Alignment of nir_opt_tex_srcs_options"]
        [::std::mem::align_of::<nir_opt_tex_srcs_options>() - 4usize];
    ["Offset of field: nir_opt_tex_srcs_options::sampler_dims"]
        [::std::mem::offset_of!(nir_opt_tex_srcs_options, sampler_dims) - 0usize];
    ["Offset of field: nir_opt_tex_srcs_options::src_types"]
        [::std::mem::offset_of!(nir_opt_tex_srcs_options, src_types) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_opt_16bit_tex_image_options {
    pub rounding_mode: nir_rounding_mode,
    pub opt_tex_dest_types: nir_alu_type,
    pub opt_image_dest_types: nir_alu_type,
    pub integer_dest_saturates: bool,
    pub opt_image_store_data: bool,
    pub opt_image_srcs: bool,
    pub opt_srcs_options_count: ::std::os::raw::c_uint,
    pub opt_srcs_options: *mut nir_opt_tex_srcs_options,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_16bit_tex_image_options"]
        [::std::mem::size_of::<nir_opt_16bit_tex_image_options>() - 24usize];
    ["Alignment of nir_opt_16bit_tex_image_options"]
        [::std::mem::align_of::<nir_opt_16bit_tex_image_options>() - 8usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::rounding_mode"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, rounding_mode) - 0usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_tex_dest_types"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_tex_dest_types) - 4usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_dest_types"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_dest_types) - 5usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::integer_dest_saturates"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, integer_dest_saturates) - 6usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_store_data"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_store_data) - 7usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_srcs"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_srcs) - 8usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_srcs_options_count"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_srcs_options_count) - 12usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_srcs_options"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_srcs_options) - 16usize];
};
impl Default for nir_opt_16bit_tex_image_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_16bit_tex_image(
        nir: *mut nir_shader,
        options: *mut nir_opt_16bit_tex_image_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_tex_src_type_constraint {
    pub legalize_type: bool,
    pub bit_size: u8,
    pub match_src: nir_tex_src_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_src_type_constraint"]
        [::std::mem::size_of::<nir_tex_src_type_constraint>() - 8usize];
    ["Alignment of nir_tex_src_type_constraint"]
        [::std::mem::align_of::<nir_tex_src_type_constraint>() - 4usize];
    ["Offset of field: nir_tex_src_type_constraint::legalize_type"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, legalize_type) - 0usize];
    ["Offset of field: nir_tex_src_type_constraint::bit_size"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, bit_size) - 1usize];
    ["Offset of field: nir_tex_src_type_constraint::match_src"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, match_src) - 4usize];
};
impl Default for nir_tex_src_type_constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_tex_src_type_constraints = [nir_tex_src_type_constraint; 23usize];
unsafe extern "C" {
    pub fn nir_legalize_16bit_sampler_srcs(
        nir: *mut nir_shader,
        constraints: *mut nir_tex_src_type_constraint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_point_size(shader: *mut nir_shader, min: f32, max: f32) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_default_point_size(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_texcoord_replace(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
        yinvert: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_texcoord_replace_late(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
    ) -> bool;
}
pub const nir_lower_interpolation_at_sample: nir_lower_interpolation_options = 2;
pub const nir_lower_interpolation_at_offset: nir_lower_interpolation_options = 4;
pub const nir_lower_interpolation_centroid: nir_lower_interpolation_options = 8;
pub const nir_lower_interpolation_pixel: nir_lower_interpolation_options = 16;
pub const nir_lower_interpolation_sample: nir_lower_interpolation_options = 32;
pub type nir_lower_interpolation_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_interpolation(
        shader: *mut nir_shader,
        options: nir_lower_interpolation_options,
    ) -> bool;
}
pub const nir_lower_demote_if_to_cf: nir_lower_discard_if_options = 1;
pub const nir_lower_terminate_if_to_cf: nir_lower_discard_if_options = 2;
pub const nir_move_terminate_out_of_loops: nir_lower_discard_if_options = 4;
pub type nir_lower_discard_if_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_discard_if(
        shader: *mut nir_shader,
        options: nir_lower_discard_if_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_terminate_to_demote(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_memory_model(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_goto_ifs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_continue_constructs(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_multiview_options {
    pub view_mask: u32,
    #[doc = " Bitfield of output locations that may be converted to a per-view array.\n\n If a variable exists in an allowed location, it will be converted to an\n array even if its value does not depend on the view index."]
    pub allowed_per_view_outputs: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_multiview_options"]
        [::std::mem::size_of::<nir_lower_multiview_options>() - 16usize];
    ["Alignment of nir_lower_multiview_options"]
        [::std::mem::align_of::<nir_lower_multiview_options>() - 8usize];
    ["Offset of field: nir_lower_multiview_options::view_mask"]
        [::std::mem::offset_of!(nir_lower_multiview_options, view_mask) - 0usize];
    ["Offset of field: nir_lower_multiview_options::allowed_per_view_outputs"]
        [::std::mem::offset_of!(nir_lower_multiview_options, allowed_per_view_outputs) - 8usize];
};
unsafe extern "C" {
    pub fn nir_shader_uses_view_index(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_can_lower_multiview(
        shader: *mut nir_shader,
        options: nir_lower_multiview_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_multiview(
        shader: *mut nir_shader,
        options: nir_lower_multiview_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_view_index_to_device_index(shader: *mut nir_shader) -> bool;
}
pub const nir_lower_fp16_rtz: nir_lower_fp16_cast_options = 1;
pub const nir_lower_fp16_rtne: nir_lower_fp16_cast_options = 2;
pub const nir_lower_fp16_ru: nir_lower_fp16_cast_options = 4;
pub const nir_lower_fp16_rd: nir_lower_fp16_cast_options = 8;
pub const nir_lower_fp16_all: nir_lower_fp16_cast_options = 15;
pub const nir_lower_fp16_split_fp64: nir_lower_fp16_cast_options = 16;
pub type nir_lower_fp16_cast_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_lower_fp16_casts(
        shader: *mut nir_shader,
        options: nir_lower_fp16_cast_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_normalize_cubemap_coords(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_supports_implicit_lod(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_live_defs_impl(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_get_live_defs(
        cursor: nir_cursor,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *const ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_loop_analyze_impl(
        impl_: *mut nir_function_impl,
        indirect_mask: nir_variable_mode,
        force_unroll_sampler_indirect: bool,
    );
}
unsafe extern "C" {
    pub fn nir_defs_interfere(a: *mut nir_def, b: *mut nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_repair_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_repair_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_convert_loop_to_lcssa(loop_: *mut nir_loop);
}
unsafe extern "C" {
    pub fn nir_convert_to_lcssa(
        shader: *mut nir_shader,
        skip_invariants: bool,
        skip_bool_invariants: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_divergence_analysis_impl(
        impl_: *mut nir_function_impl,
        options: nir_divergence_options,
    );
}
unsafe extern "C" {
    pub fn nir_divergence_analysis(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_vertex_divergence_analysis(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_has_divergent_loop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_rewrite_uses_to_load_reg(b: *mut nir_builder, old: *mut nir_def, reg: *mut nir_def);
}
unsafe extern "C" {
    pub fn nir_convert_from_ssa(
        shader: *mut nir_shader,
        phi_webs_only: bool,
        consider_divergence: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_phis_to_regs_block(
        block: *mut nir_block,
        place_writes_in_imm_preds: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_ssa_defs_to_regs_block(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_rematerialize_deref_in_use_blocks(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_rematerialize_derefs_in_use_blocks_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_samplers(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_cl_images(
        shader: *mut nir_shader,
        lower_image_derefs: bool,
        lower_sampler_derefs: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_dedup_inline_samplers(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_ssbo_options {
    pub native_loads: bool,
    pub native_offset: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_ssbo_options"][::std::mem::size_of::<nir_lower_ssbo_options>() - 2usize];
    ["Alignment of nir_lower_ssbo_options"]
        [::std::mem::align_of::<nir_lower_ssbo_options>() - 1usize];
    ["Offset of field: nir_lower_ssbo_options::native_loads"]
        [::std::mem::offset_of!(nir_lower_ssbo_options, native_loads) - 0usize];
    ["Offset of field: nir_lower_ssbo_options::native_offset"]
        [::std::mem::offset_of!(nir_lower_ssbo_options, native_offset) - 1usize];
};
unsafe extern "C" {
    pub fn nir_lower_ssbo(shader: *mut nir_shader, opts: *const nir_lower_ssbo_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_helper_writes(shader: *mut nir_shader, lower_plain_stores: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_lower_printf_options {
    pub max_buffer_size: ::std::os::raw::c_uint,
    pub ptr_bit_size: ::std::os::raw::c_uint,
    pub hash_format_strings: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_printf_options"]
        [::std::mem::size_of::<nir_lower_printf_options>() - 12usize];
    ["Alignment of nir_lower_printf_options"]
        [::std::mem::align_of::<nir_lower_printf_options>() - 4usize];
    ["Offset of field: nir_lower_printf_options::max_buffer_size"]
        [::std::mem::offset_of!(nir_lower_printf_options, max_buffer_size) - 0usize];
    ["Offset of field: nir_lower_printf_options::ptr_bit_size"]
        [::std::mem::offset_of!(nir_lower_printf_options, ptr_bit_size) - 4usize];
    ["Offset of field: nir_lower_printf_options::hash_format_strings"]
        [::std::mem::offset_of!(nir_lower_printf_options, hash_format_strings) - 8usize];
};
unsafe extern "C" {
    pub fn nir_lower_printf(nir: *mut nir_shader, options: *const nir_lower_printf_options)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_comparison_pre_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_comparison_pre(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_opt_access_options {
    pub is_vulkan: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_access_options"][::std::mem::size_of::<nir_opt_access_options>() - 1usize];
    ["Alignment of nir_opt_access_options"]
        [::std::mem::align_of::<nir_opt_access_options>() - 1usize];
    ["Offset of field: nir_opt_access_options::is_vulkan"]
        [::std::mem::offset_of!(nir_opt_access_options, is_vulkan) - 0usize];
};
unsafe extern "C" {
    pub fn nir_opt_access(shader: *mut nir_shader, options: *const nir_opt_access_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_before_ffma(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_before_lower_int64(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_late(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_distribute_src_mods(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_integer_promotion(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_reassociate_matrix_mul(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_constant_folding(shader: *mut nir_shader) -> bool;
}
pub type nir_combine_barrier_cb = ::std::option::Option<
    unsafe extern "C" fn(
        a: *mut nir_intrinsic_instr,
        b: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
unsafe extern "C" {
    pub fn nir_opt_combine_barriers(
        shader: *mut nir_shader,
        combine_cb: nir_combine_barrier_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_acquire_release_barriers(shader: *mut nir_shader, max_scope: mesa_scope)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_barrier_modes(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_minimize_call_live_states(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_combine_stores(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_copy_prop_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_copy_prop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_copy_prop_vars(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_cse(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dce(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dead_cf(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dead_write_vars(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_deref_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_deref(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_find_array_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_is_frag_coord_z(def: *mut nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_fragdepth(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_gcm(shader: *mut nir_shader, value_number: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_generate_bfi(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_idiv_const(
        shader: *mut nir_shader,
        min_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_mqsad(shader: *mut nir_shader) -> bool;
}
pub const nir_opt_if_optimize_phi_true_false: nir_opt_if_options = 1;
pub const nir_opt_if_avoid_64bit_phis: nir_opt_if_options = 2;
pub type nir_opt_if_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_opt_if(shader: *mut nir_shader, options: nir_opt_if_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_intrinsics(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_large_constants(
        shader: *mut nir_shader,
        size_align: glsl_type_size_align_func,
        threshold: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_licm(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_loop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_loop_unroll(shader: *mut nir_shader) -> bool;
}
pub const nir_move_const_undef: nir_move_options = 1;
pub const nir_move_alu: nir_move_options = 2;
pub const nir_move_copies: nir_move_options = 4;
pub const nir_move_comparisons: nir_move_options = 8;
pub const nir_dont_move_byte_word_vecs: nir_move_options = 16;
pub const nir_move_tex_sample: nir_move_options = 256;
pub const nir_move_tex_load: nir_move_options = 512;
pub const nir_move_tex_load_fragment_mask: nir_move_options = 1024;
pub const nir_move_tex_lod: nir_move_options = 2048;
pub const nir_move_tex_query: nir_move_options = 4096;
pub const nir_move_load_image: nir_move_options = 8192;
pub const nir_move_load_image_fragment_mask: nir_move_options = 16384;
pub const nir_move_query_image: nir_move_options = 32768;
pub const nir_move_load_input: nir_move_options = 65536;
pub const nir_move_load_global: nir_move_options = 131072;
pub const nir_move_load_ubo: nir_move_options = 262144;
pub const nir_move_load_ssbo: nir_move_options = 524288;
pub const nir_move_load_uniform: nir_move_options = 1048576;
pub const nir_move_load_buffer_amd: nir_move_options = 2097152;
pub const nir_move_load_frag_coord: nir_move_options = 4194304;
pub const nir_move_only_convergent: nir_move_options = 1073741824;
pub const nir_move_only_divergent: nir_move_options = 2147483648;
pub type nir_move_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_can_move_instr(instr: *mut nir_instr, options: nir_move_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_sink(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_move(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_opt_offsets_options {
    #[doc = " nir_load_uniform max base offset"]
    pub uniform_max: u32,
    #[doc = " nir_load_ubo_vec4 max base offset"]
    pub ubo_vec4_max: u32,
    #[doc = " nir_var_mem_shared max base offset"]
    pub shared_max: u32,
    #[doc = " nir_var_mem_shared atomic max base offset"]
    pub shared_atomic_max: u32,
    #[doc = " nir_load/store_buffer_amd max base offset"]
    pub buffer_max: u32,
    #[doc = " Callback to get the max base offset for instructions for which the\n corresponding value above is zero."]
    pub max_offset_cb: ::std::option::Option<
        unsafe extern "C" fn(
            intr: *mut nir_intrinsic_instr,
            data: *const ::std::os::raw::c_void,
        ) -> u32,
    >,
    #[doc = " Data to pass to callbacks."]
    pub cb_data: *const ::std::os::raw::c_void,
    #[doc = " Allow the offset calculation to wrap. If false, constant additions that\n might wrap will not be folded into the offset."]
    pub allow_offset_wrap_cb: ::std::option::Option<
        unsafe extern "C" fn(
            intr: *mut nir_intrinsic_instr,
            data: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_offsets_options"][::std::mem::size_of::<nir_opt_offsets_options>() - 48usize];
    ["Alignment of nir_opt_offsets_options"]
        [::std::mem::align_of::<nir_opt_offsets_options>() - 8usize];
    ["Offset of field: nir_opt_offsets_options::uniform_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, uniform_max) - 0usize];
    ["Offset of field: nir_opt_offsets_options::ubo_vec4_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, ubo_vec4_max) - 4usize];
    ["Offset of field: nir_opt_offsets_options::shared_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, shared_max) - 8usize];
    ["Offset of field: nir_opt_offsets_options::shared_atomic_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, shared_atomic_max) - 12usize];
    ["Offset of field: nir_opt_offsets_options::buffer_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, buffer_max) - 16usize];
    ["Offset of field: nir_opt_offsets_options::max_offset_cb"]
        [::std::mem::offset_of!(nir_opt_offsets_options, max_offset_cb) - 24usize];
    ["Offset of field: nir_opt_offsets_options::cb_data"]
        [::std::mem::offset_of!(nir_opt_offsets_options, cb_data) - 32usize];
    ["Offset of field: nir_opt_offsets_options::allow_offset_wrap_cb"]
        [::std::mem::offset_of!(nir_opt_offsets_options, allow_offset_wrap_cb) - 40usize];
};
impl Default for nir_opt_offsets_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_offsets(
        shader: *mut nir_shader,
        options: *const nir_opt_offsets_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_opt_peephole_select_options {
    pub limit: ::std::os::raw::c_uint,
    pub indirect_load_ok: bool,
    pub expensive_alu_ok: bool,
    pub discard_ok: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_peephole_select_options"]
        [::std::mem::size_of::<nir_opt_peephole_select_options>() - 8usize];
    ["Alignment of nir_opt_peephole_select_options"]
        [::std::mem::align_of::<nir_opt_peephole_select_options>() - 4usize];
    ["Offset of field: nir_opt_peephole_select_options::limit"]
        [::std::mem::offset_of!(nir_opt_peephole_select_options, limit) - 0usize];
    ["Offset of field: nir_opt_peephole_select_options::indirect_load_ok"]
        [::std::mem::offset_of!(nir_opt_peephole_select_options, indirect_load_ok) - 4usize];
    ["Offset of field: nir_opt_peephole_select_options::expensive_alu_ok"]
        [::std::mem::offset_of!(nir_opt_peephole_select_options, expensive_alu_ok) - 5usize];
    ["Offset of field: nir_opt_peephole_select_options::discard_ok"]
        [::std::mem::offset_of!(nir_opt_peephole_select_options, discard_ok) - 6usize];
};
unsafe extern "C" {
    pub fn nir_opt_peephole_select(
        shader: *mut nir_shader,
        options: *const nir_opt_peephole_select_options,
    ) -> bool;
}
pub const nir_reassociate_cse_heuristic: nir_reassociate_options = 1;
pub const nir_reassociate_scalar_math: nir_reassociate_options = 2;
pub type nir_reassociate_options = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn nir_opt_reassociate(shader: *mut nir_shader, opts: nir_reassociate_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_reassociate_loop(shader: *mut nir_shader, opts: nir_reassociate_options)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_reassociate_bfi(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_rematerialize_compares(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_remove_phis(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_single_src_phis_block(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_phi_precision(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_phi_to_bool(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_shrink_stores(shader: *mut nir_shader, shrink_image_store: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_shrink_vectors(shader: *mut nir_shader, shrink_start: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_undef(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_undef_to_zero(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_uniform_atomics(shader: *mut nir_shader, fs_atomics_predicated: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_uniform_subgroup(
        shader: *mut nir_shader,
        arg1: *const nir_lower_subgroups_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_vectorize(
        shader: *mut nir_shader,
        filter: nir_vectorize_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_vectorize_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        allow_holes: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_move_discards_to_top(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_ray_queries(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_ray_query_ranges(shader: *mut nir_shader) -> bool;
}
pub type nir_skip_helpers_instrinsic_cb = ::std::option::Option<
    unsafe extern "C" fn(intr: *mut nir_intrinsic_instr, data: *mut ::std::os::raw::c_void) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_opt_load_skip_helpers_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub intrinsic_cb: nir_skip_helpers_instrinsic_cb,
    pub intrinsic_cb_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_load_skip_helpers_options"]
        [::std::mem::size_of::<nir_opt_load_skip_helpers_options>() - 24usize];
    ["Alignment of nir_opt_load_skip_helpers_options"]
        [::std::mem::align_of::<nir_opt_load_skip_helpers_options>() - 8usize];
    ["Offset of field: nir_opt_load_skip_helpers_options::intrinsic_cb"]
        [::std::mem::offset_of!(nir_opt_load_skip_helpers_options, intrinsic_cb) - 8usize];
    ["Offset of field: nir_opt_load_skip_helpers_options::intrinsic_cb_data"]
        [::std::mem::offset_of!(nir_opt_load_skip_helpers_options, intrinsic_cb_data) - 16usize];
};
impl Default for nir_opt_load_skip_helpers_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_opt_load_skip_helpers_options {
    #[inline]
    pub fn no_add_divergence(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_add_divergence(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_add_divergence_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_no_add_divergence_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(no_add_divergence: bool) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let no_add_divergence: u8 = unsafe { ::std::mem::transmute(no_add_divergence) };
            no_add_divergence as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_opt_load_skip_helpers(
        shader: *mut nir_shader,
        options: *mut nir_opt_load_skip_helpers_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_sweep(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_intrinsic_from_system_value(val: gl_system_value) -> nir_intrinsic_op;
}
unsafe extern "C" {
    pub fn nir_system_value_from_intrinsic(intrin: nir_intrinsic_op) -> gl_system_value;
}
unsafe extern "C" {
    pub fn nir_unsigned_upper_bound(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        scalar: nir_scalar,
    ) -> u32;
}
unsafe extern "C" {
    pub fn nir_addition_might_overflow(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        ssa: nir_scalar,
        const_val: ::std::os::raw::c_uint,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_opt_preamble_options {
    pub drawid_uniform: bool,
    pub subgroup_size_uniform: bool,
    pub load_workgroup_size_allowed: bool,
    pub def_size: ::std::option::Option<
        unsafe extern "C" fn(
            def: *mut nir_def,
            size: *mut ::std::os::raw::c_uint,
            align: *mut ::std::os::raw::c_uint,
            class_: *mut nir_preamble_class,
        ),
    >,
    pub preamble_storage_size: [::std::os::raw::c_uint; 3usize],
    pub instr_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(instr: *mut nir_instr, data: *const ::std::os::raw::c_void) -> f32,
    >,
    pub rewrite_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(def: *mut nir_def, data: *const ::std::os::raw::c_void) -> f32,
    >,
    pub avoid_instr_cb: nir_instr_filter_cb,
    pub cb_data: *const ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_preamble_options"]
        [::std::mem::size_of::<nir_opt_preamble_options>() - 64usize];
    ["Alignment of nir_opt_preamble_options"]
        [::std::mem::align_of::<nir_opt_preamble_options>() - 8usize];
    ["Offset of field: nir_opt_preamble_options::drawid_uniform"]
        [::std::mem::offset_of!(nir_opt_preamble_options, drawid_uniform) - 0usize];
    ["Offset of field: nir_opt_preamble_options::subgroup_size_uniform"]
        [::std::mem::offset_of!(nir_opt_preamble_options, subgroup_size_uniform) - 1usize];
    ["Offset of field: nir_opt_preamble_options::load_workgroup_size_allowed"]
        [::std::mem::offset_of!(nir_opt_preamble_options, load_workgroup_size_allowed) - 2usize];
    ["Offset of field: nir_opt_preamble_options::def_size"]
        [::std::mem::offset_of!(nir_opt_preamble_options, def_size) - 8usize];
    ["Offset of field: nir_opt_preamble_options::preamble_storage_size"]
        [::std::mem::offset_of!(nir_opt_preamble_options, preamble_storage_size) - 16usize];
    ["Offset of field: nir_opt_preamble_options::instr_cost_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, instr_cost_cb) - 32usize];
    ["Offset of field: nir_opt_preamble_options::rewrite_cost_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, rewrite_cost_cb) - 40usize];
    ["Offset of field: nir_opt_preamble_options::avoid_instr_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, avoid_instr_cb) - 48usize];
    ["Offset of field: nir_opt_preamble_options::cb_data"]
        [::std::mem::offset_of!(nir_opt_preamble_options, cb_data) - 56usize];
};
impl Default for nir_opt_preamble_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_preamble(
        shader: *mut nir_shader,
        options: *const nir_opt_preamble_options,
        size: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_get_preamble(shader: *mut nir_shader) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_lower_point_smooth(shader: *mut nir_shader, set_barycentrics: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_poly_line_smooth(
        shader: *mut nir_shader,
        num_smooth_aa_sample: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_mod_analysis(
        val: nir_scalar,
        val_type: nir_alu_type,
        div: ::std::os::raw::c_uint,
        mod_: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_tex_shadow(
        shader: *mut nir_shader,
        textures_bitmask: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_trivialize_registers(s: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_static_workgroup_size(s: *const nir_shader) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_use_dominance_state {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn nir_calc_use_dominance_impl(
        impl_: *mut nir_function_impl,
        post_dominance: bool,
    ) -> *mut nir_use_dominance_state;
}
unsafe extern "C" {
    pub fn nir_get_immediate_use_dominator(
        state: *mut nir_use_dominance_state,
        instr: *mut nir_instr,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    pub fn nir_use_dominance_lca(
        state: *mut nir_use_dominance_state,
        i1: *mut nir_instr,
        i2: *mut nir_instr,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    pub fn nir_instr_dominates_use(
        state: *mut nir_use_dominance_state,
        parent: *mut nir_instr,
        child: *mut nir_instr,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_print_use_dominators(
        state: *mut nir_use_dominance_state,
        instructions: *mut *mut nir_instr,
        num_instructions: ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_output_deps {
    pub output: [nir_output_deps__bindgen_ty_1; 112usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_output_deps__bindgen_ty_1 {
    pub instr_list: *mut *mut nir_instr,
    pub num_instr: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_output_deps__bindgen_ty_1"]
        [::std::mem::size_of::<nir_output_deps__bindgen_ty_1>() - 16usize];
    ["Alignment of nir_output_deps__bindgen_ty_1"]
        [::std::mem::align_of::<nir_output_deps__bindgen_ty_1>() - 8usize];
    ["Offset of field: nir_output_deps__bindgen_ty_1::instr_list"]
        [::std::mem::offset_of!(nir_output_deps__bindgen_ty_1, instr_list) - 0usize];
    ["Offset of field: nir_output_deps__bindgen_ty_1::num_instr"]
        [::std::mem::offset_of!(nir_output_deps__bindgen_ty_1, num_instr) - 8usize];
};
impl Default for nir_output_deps__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_output_deps"][::std::mem::size_of::<nir_output_deps>() - 1792usize];
    ["Alignment of nir_output_deps"][::std::mem::align_of::<nir_output_deps>() - 8usize];
    ["Offset of field: nir_output_deps::output"]
        [::std::mem::offset_of!(nir_output_deps, output) - 0usize];
};
impl Default for nir_output_deps {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_gather_output_dependencies(nir: *mut nir_shader, deps: *mut nir_output_deps);
}
unsafe extern "C" {
    pub fn nir_free_output_dependencies(deps: *mut nir_output_deps);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_input_to_output_deps {
    pub output: [nir_input_to_output_deps__bindgen_ty_1; 112usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_input_to_output_deps__bindgen_ty_1 {
    pub inputs: [::std::os::raw::c_uint; 28usize],
    pub defined: bool,
    pub uses_ssbo_reads: bool,
    pub uses_image_reads: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_input_to_output_deps__bindgen_ty_1"]
        [::std::mem::size_of::<nir_input_to_output_deps__bindgen_ty_1>() - 116usize];
    ["Alignment of nir_input_to_output_deps__bindgen_ty_1"]
        [::std::mem::align_of::<nir_input_to_output_deps__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_input_to_output_deps__bindgen_ty_1::inputs"]
        [::std::mem::offset_of!(nir_input_to_output_deps__bindgen_ty_1, inputs) - 0usize];
    ["Offset of field: nir_input_to_output_deps__bindgen_ty_1::defined"]
        [::std::mem::offset_of!(nir_input_to_output_deps__bindgen_ty_1, defined) - 112usize];
    ["Offset of field: nir_input_to_output_deps__bindgen_ty_1::uses_ssbo_reads"][::std::mem::offset_of!(
        nir_input_to_output_deps__bindgen_ty_1,
        uses_ssbo_reads
    ) - 113usize];
    ["Offset of field: nir_input_to_output_deps__bindgen_ty_1::uses_image_reads"][::std::mem::offset_of!(
        nir_input_to_output_deps__bindgen_ty_1,
        uses_image_reads
    ) - 114usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_input_to_output_deps"]
        [::std::mem::size_of::<nir_input_to_output_deps>() - 12992usize];
    ["Alignment of nir_input_to_output_deps"]
        [::std::mem::align_of::<nir_input_to_output_deps>() - 4usize];
    ["Offset of field: nir_input_to_output_deps::output"]
        [::std::mem::offset_of!(nir_input_to_output_deps, output) - 0usize];
};
impl Default for nir_input_to_output_deps {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_gather_input_to_output_dependencies(
        nir: *mut nir_shader,
        out_deps: *mut nir_input_to_output_deps,
    );
}
unsafe extern "C" {
    pub fn nir_print_input_to_output_deps(
        deps: *mut nir_input_to_output_deps,
        nir: *mut nir_shader,
        f: *mut FILE,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nir_output_clipper_var_groups {
    pub pos_only: [::std::os::raw::c_uint; 28usize],
    pub var_only: [::std::os::raw::c_uint; 28usize],
    pub both: [::std::os::raw::c_uint; 28usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_output_clipper_var_groups"]
        [::std::mem::size_of::<nir_output_clipper_var_groups>() - 336usize];
    ["Alignment of nir_output_clipper_var_groups"]
        [::std::mem::align_of::<nir_output_clipper_var_groups>() - 4usize];
    ["Offset of field: nir_output_clipper_var_groups::pos_only"]
        [::std::mem::offset_of!(nir_output_clipper_var_groups, pos_only) - 0usize];
    ["Offset of field: nir_output_clipper_var_groups::var_only"]
        [::std::mem::offset_of!(nir_output_clipper_var_groups, var_only) - 112usize];
    ["Offset of field: nir_output_clipper_var_groups::both"]
        [::std::mem::offset_of!(nir_output_clipper_var_groups, both) - 224usize];
};
unsafe extern "C" {
    pub fn nir_gather_output_clipper_var_groups(
        nir: *mut nir_shader,
        groups: *mut nir_output_clipper_var_groups,
    );
}
unsafe extern "C" {
    pub fn nir_lower_cooperative_matrix_flexible_dimensions(
        shader: *mut nir_shader,
        m_gran: ::std::os::raw::c_uint,
        n_gran: ::std::os::raw::c_uint,
        k_gran: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_unlower_io_to_vars(nir: *mut nir_shader, keep_intrinsics: bool) -> bool;
}
