

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Flags
    ( 

 -- * Flags


-- ** FontMask #flag:FontMask#

    FontMask(..)                            ,


-- ** LayoutDeserializeFlags #flag:LayoutDeserializeFlags#

    LayoutDeserializeFlags(..)              ,


-- ** LayoutSerializeFlags #flag:LayoutSerializeFlags#

    LayoutSerializeFlags(..)                ,


-- ** ShapeFlags #flag:ShapeFlags#

    ShapeFlags(..)                          ,


-- ** ShowFlags #flag:ShowFlags#

    ShowFlags(..)                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags ShowFlags
-- | These flags affect how Pango treats characters that are normally
-- not visible in the output.
-- 
-- /Since: 1.44/
data ShowFlags = 
      ShowFlagsNone
    -- ^ No special treatment for invisible characters
    | ShowFlagsSpaces
    -- ^ Render spaces, tabs and newlines visibly
    | ShowFlagsLineBreaks
    -- ^ Render line breaks visibly
    | ShowFlagsIgnorables
    -- ^ Render default-ignorable Unicode
    --   characters visibly
    | AnotherShowFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShowFlags where
    fromEnum ShowFlagsNone = 0
    fromEnum ShowFlagsSpaces = 1
    fromEnum ShowFlagsLineBreaks = 2
    fromEnum ShowFlagsIgnorables = 4
    fromEnum (AnotherShowFlags k) = k

    toEnum 0 = ShowFlagsNone
    toEnum 1 = ShowFlagsSpaces
    toEnum 2 = ShowFlagsLineBreaks
    toEnum 4 = ShowFlagsIgnorables
    toEnum k = AnotherShowFlags k

instance P.Ord ShowFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ShowFlags = '[]
instance O.HasParentTypes ShowFlags

foreign import ccall "pango_show_flags_get_type" c_pango_show_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ShowFlags where
    glibType = c_pango_show_flags_get_type

instance B.Types.BoxedFlags ShowFlags

instance IsGFlag ShowFlags

-- Flags ShapeFlags
-- | Flags influencing the shaping process.
-- 
-- @PangoShapeFlags@ can be passed to 'GI.Pango.Functions.shapeWithFlags'.
-- 
-- /Since: 1.44/
data ShapeFlags = 
      ShapeFlagsNone
    -- ^ Default value
    | ShapeFlagsRoundPositions
    -- ^ Round glyph positions and widths to whole device units
    --   This option should be set if the target renderer can\'t do subpixel positioning of glyphs
    | AnotherShapeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShapeFlags where
    fromEnum ShapeFlagsNone = 0
    fromEnum ShapeFlagsRoundPositions = 1
    fromEnum (AnotherShapeFlags k) = k

    toEnum 0 = ShapeFlagsNone
    toEnum 1 = ShapeFlagsRoundPositions
    toEnum k = AnotherShapeFlags k

instance P.Ord ShapeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ShapeFlags = '[]
instance O.HasParentTypes ShapeFlags

foreign import ccall "pango_shape_flags_get_type" c_pango_shape_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ShapeFlags where
    glibType = c_pango_shape_flags_get_type

instance B.Types.BoxedFlags ShapeFlags

instance IsGFlag ShapeFlags

-- Flags LayoutSerializeFlags
-- | Flags that influence the behavior of 'GI.Pango.Objects.Layout.layoutSerialize'.
-- 
-- New members may be added to this enumeration over time.
-- 
-- /Since: 1.50/
data LayoutSerializeFlags = 
      LayoutSerializeFlagsDefault
    -- ^ Default behavior
    | LayoutSerializeFlagsContext
    -- ^ Include context information
    | LayoutSerializeFlagsOutput
    -- ^ Include information about the formatted output
    | AnotherLayoutSerializeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LayoutSerializeFlags where
    fromEnum LayoutSerializeFlagsDefault = 0
    fromEnum LayoutSerializeFlagsContext = 1
    fromEnum LayoutSerializeFlagsOutput = 2
    fromEnum (AnotherLayoutSerializeFlags k) = k

    toEnum 0 = LayoutSerializeFlagsDefault
    toEnum 1 = LayoutSerializeFlagsContext
    toEnum 2 = LayoutSerializeFlagsOutput
    toEnum k = AnotherLayoutSerializeFlags k

instance P.Ord LayoutSerializeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes LayoutSerializeFlags = '[]
instance O.HasParentTypes LayoutSerializeFlags

foreign import ccall "pango_layout_serialize_flags_get_type" c_pango_layout_serialize_flags_get_type :: 
    IO GType

instance B.Types.TypedObject LayoutSerializeFlags where
    glibType = c_pango_layout_serialize_flags_get_type

instance B.Types.BoxedFlags LayoutSerializeFlags

instance IsGFlag LayoutSerializeFlags

-- Flags LayoutDeserializeFlags
-- | Flags that influence the behavior of 'GI.Pango.Objects.Layout.layoutDeserialize'.
-- 
-- New members may be added to this enumeration over time.
-- 
-- /Since: 1.50/
data LayoutDeserializeFlags = 
      LayoutDeserializeFlagsDefault
    -- ^ Default behavior
    | LayoutDeserializeFlagsContext
    -- ^ Apply context information
    --   from the serialization to the @PangoContext@
    | AnotherLayoutDeserializeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LayoutDeserializeFlags where
    fromEnum LayoutDeserializeFlagsDefault = 0
    fromEnum LayoutDeserializeFlagsContext = 1
    fromEnum (AnotherLayoutDeserializeFlags k) = k

    toEnum 0 = LayoutDeserializeFlagsDefault
    toEnum 1 = LayoutDeserializeFlagsContext
    toEnum k = AnotherLayoutDeserializeFlags k

instance P.Ord LayoutDeserializeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes LayoutDeserializeFlags = '[]
instance O.HasParentTypes LayoutDeserializeFlags

foreign import ccall "pango_layout_deserialize_flags_get_type" c_pango_layout_deserialize_flags_get_type :: 
    IO GType

instance B.Types.TypedObject LayoutDeserializeFlags where
    glibType = c_pango_layout_deserialize_flags_get_type

instance B.Types.BoxedFlags LayoutDeserializeFlags

instance IsGFlag LayoutDeserializeFlags

-- Flags FontMask
-- | The bits in a @PangoFontMask@ correspond to the set fields in a
-- @PangoFontDescription@.
data FontMask = 
      FontMaskFamily
    -- ^ the font family is specified.
    | FontMaskStyle
    -- ^ the font style is specified.
    | FontMaskVariant
    -- ^ the font variant is specified.
    | FontMaskWeight
    -- ^ the font weight is specified.
    | FontMaskStretch
    -- ^ the font stretch is specified.
    | FontMaskSize
    -- ^ the font size is specified.
    | FontMaskGravity
    -- ^ The font gravity is specified.
    -- 
    -- /Since: 1.16/
    | FontMaskVariations
    -- ^ OpenType font variations are specified.
    -- 
    -- /Since: 1.42/
    | FontMaskFeatures
    -- ^ OpenType font features are specified.
    -- 
    -- /Since: 1.56/
    | FontMaskColor
    -- ^ Font color is specified.
    -- 
    -- /Since: 1.57/
    | AnotherFontMask Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FontMask where
    fromEnum FontMaskFamily = 1
    fromEnum FontMaskStyle = 2
    fromEnum FontMaskVariant = 4
    fromEnum FontMaskWeight = 8
    fromEnum FontMaskStretch = 16
    fromEnum FontMaskSize = 32
    fromEnum FontMaskGravity = 64
    fromEnum FontMaskVariations = 128
    fromEnum FontMaskFeatures = 256
    fromEnum FontMaskColor = 512
    fromEnum (AnotherFontMask k) = k

    toEnum 1 = FontMaskFamily
    toEnum 2 = FontMaskStyle
    toEnum 4 = FontMaskVariant
    toEnum 8 = FontMaskWeight
    toEnum 16 = FontMaskStretch
    toEnum 32 = FontMaskSize
    toEnum 64 = FontMaskGravity
    toEnum 128 = FontMaskVariations
    toEnum 256 = FontMaskFeatures
    toEnum 512 = FontMaskColor
    toEnum k = AnotherFontMask k

instance P.Ord FontMask where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FontMask = '[]
instance O.HasParentTypes FontMask

foreign import ccall "pango_font_mask_get_type" c_pango_font_mask_get_type :: 
    IO GType

instance B.Types.TypedObject FontMask where
    glibType = c_pango_font_mask_get_type

instance B.Types.BoxedFlags FontMask

instance IsGFlag FontMask


