{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base class for widgets which visualize an adjustment.
-- 
-- Widgets that are derived from @GtkRange@ include
-- t'GI.Gtk.Objects.Scale.Scale' and t'GI.Gtk.Objects.Scrollbar.Scrollbar'.
-- 
-- Apart from signals for monitoring the parameters of the adjustment,
-- @GtkRange@ provides properties and methods for setting a
-- “fill level” on range widgets. See 'GI.Gtk.Objects.Range.rangeSetFillLevel'.
-- 
-- = Shortcuts and Gestures
-- 
-- The @GtkRange@ slider is draggable. Holding the \<kbd>Shift\<\/kbd> key while
-- dragging, or initiating the drag with a long-press will enable the
-- fine-tuning mode.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Range
    ( 

-- * Exported types
    Range(..)                               ,
    IsRange                                 ,
    toRange                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAdjustment]("GI.Gtk.Objects.Range#g:method:getAdjustment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFillLevel]("GI.Gtk.Objects.Range#g:method:getFillLevel"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFlippable]("GI.Gtk.Objects.Range#g:method:getFlippable"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInverted]("GI.Gtk.Objects.Range#g:method:getInverted"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRangeRect]("GI.Gtk.Objects.Range#g:method:getRangeRect"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRestrictToFillLevel]("GI.Gtk.Objects.Range#g:method:getRestrictToFillLevel"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRoundDigits]("GI.Gtk.Objects.Range#g:method:getRoundDigits"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowFillLevel]("GI.Gtk.Objects.Range#g:method:getShowFillLevel"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSliderRange]("GI.Gtk.Objects.Range#g:method:getSliderRange"), [getSliderSizeFixed]("GI.Gtk.Objects.Range#g:method:getSliderSizeFixed"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getValue]("GI.Gtk.Objects.Range#g:method:getValue"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAdjustment]("GI.Gtk.Objects.Range#g:method:setAdjustment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFillLevel]("GI.Gtk.Objects.Range#g:method:setFillLevel"), [setFlippable]("GI.Gtk.Objects.Range#g:method:setFlippable"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIncrements]("GI.Gtk.Objects.Range#g:method:setIncrements"), [setInverted]("GI.Gtk.Objects.Range#g:method:setInverted"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRange]("GI.Gtk.Objects.Range#g:method:setRange"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRestrictToFillLevel]("GI.Gtk.Objects.Range#g:method:setRestrictToFillLevel"), [setRoundDigits]("GI.Gtk.Objects.Range#g:method:setRoundDigits"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowFillLevel]("GI.Gtk.Objects.Range#g:method:setShowFillLevel"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSliderSizeFixed]("GI.Gtk.Objects.Range#g:method:setSliderSizeFixed"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setValue]("GI.Gtk.Objects.Range#g:method:setValue"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveRangeMethod                      ,
#endif

-- ** getAdjustment #method:getAdjustment#

#if defined(ENABLE_OVERLOADING)
    RangeGetAdjustmentMethodInfo            ,
#endif
    rangeGetAdjustment                      ,


-- ** getFillLevel #method:getFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeGetFillLevelMethodInfo             ,
#endif
    rangeGetFillLevel                       ,


-- ** getFlippable #method:getFlippable#

#if defined(ENABLE_OVERLOADING)
    RangeGetFlippableMethodInfo             ,
#endif
    rangeGetFlippable                       ,


-- ** getInverted #method:getInverted#

#if defined(ENABLE_OVERLOADING)
    RangeGetInvertedMethodInfo              ,
#endif
    rangeGetInverted                        ,


-- ** getRangeRect #method:getRangeRect#

#if defined(ENABLE_OVERLOADING)
    RangeGetRangeRectMethodInfo             ,
#endif
    rangeGetRangeRect                       ,


-- ** getRestrictToFillLevel #method:getRestrictToFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeGetRestrictToFillLevelMethodInfo   ,
#endif
    rangeGetRestrictToFillLevel             ,


-- ** getRoundDigits #method:getRoundDigits#

#if defined(ENABLE_OVERLOADING)
    RangeGetRoundDigitsMethodInfo           ,
#endif
    rangeGetRoundDigits                     ,


-- ** getShowFillLevel #method:getShowFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeGetShowFillLevelMethodInfo         ,
#endif
    rangeGetShowFillLevel                   ,


-- ** getSliderRange #method:getSliderRange#

#if defined(ENABLE_OVERLOADING)
    RangeGetSliderRangeMethodInfo           ,
#endif
    rangeGetSliderRange                     ,


-- ** getSliderSizeFixed #method:getSliderSizeFixed#

#if defined(ENABLE_OVERLOADING)
    RangeGetSliderSizeFixedMethodInfo       ,
#endif
    rangeGetSliderSizeFixed                 ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    RangeGetValueMethodInfo                 ,
#endif
    rangeGetValue                           ,


-- ** setAdjustment #method:setAdjustment#

#if defined(ENABLE_OVERLOADING)
    RangeSetAdjustmentMethodInfo            ,
#endif
    rangeSetAdjustment                      ,


-- ** setFillLevel #method:setFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeSetFillLevelMethodInfo             ,
#endif
    rangeSetFillLevel                       ,


-- ** setFlippable #method:setFlippable#

#if defined(ENABLE_OVERLOADING)
    RangeSetFlippableMethodInfo             ,
#endif
    rangeSetFlippable                       ,


-- ** setIncrements #method:setIncrements#

#if defined(ENABLE_OVERLOADING)
    RangeSetIncrementsMethodInfo            ,
#endif
    rangeSetIncrements                      ,


-- ** setInverted #method:setInverted#

#if defined(ENABLE_OVERLOADING)
    RangeSetInvertedMethodInfo              ,
#endif
    rangeSetInverted                        ,


-- ** setRange #method:setRange#

#if defined(ENABLE_OVERLOADING)
    RangeSetRangeMethodInfo                 ,
#endif
    rangeSetRange                           ,


-- ** setRestrictToFillLevel #method:setRestrictToFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeSetRestrictToFillLevelMethodInfo   ,
#endif
    rangeSetRestrictToFillLevel             ,


-- ** setRoundDigits #method:setRoundDigits#

#if defined(ENABLE_OVERLOADING)
    RangeSetRoundDigitsMethodInfo           ,
#endif
    rangeSetRoundDigits                     ,


-- ** setShowFillLevel #method:setShowFillLevel#

#if defined(ENABLE_OVERLOADING)
    RangeSetShowFillLevelMethodInfo         ,
#endif
    rangeSetShowFillLevel                   ,


-- ** setSliderSizeFixed #method:setSliderSizeFixed#

#if defined(ENABLE_OVERLOADING)
    RangeSetSliderSizeFixedMethodInfo       ,
#endif
    rangeSetSliderSizeFixed                 ,


-- ** setValue #method:setValue#

#if defined(ENABLE_OVERLOADING)
    RangeSetValueMethodInfo                 ,
#endif
    rangeSetValue                           ,




 -- * Properties


-- ** adjustment #attr:adjustment#
-- | The adjustment that is controlled by the range.

#if defined(ENABLE_OVERLOADING)
    RangeAdjustmentPropertyInfo             ,
#endif
    constructRangeAdjustment                ,
    getRangeAdjustment                      ,
#if defined(ENABLE_OVERLOADING)
    rangeAdjustment                         ,
#endif
    setRangeAdjustment                      ,


-- ** fillLevel #attr:fillLevel#
-- | The fill level (e.g. prebuffering of a network stream).

#if defined(ENABLE_OVERLOADING)
    RangeFillLevelPropertyInfo              ,
#endif
    constructRangeFillLevel                 ,
    getRangeFillLevel                       ,
#if defined(ENABLE_OVERLOADING)
    rangeFillLevel                          ,
#endif
    setRangeFillLevel                       ,


-- ** inverted #attr:inverted#
-- | If 'P.True', the direction in which the slider moves is inverted.

#if defined(ENABLE_OVERLOADING)
    RangeInvertedPropertyInfo               ,
#endif
    constructRangeInverted                  ,
    getRangeInverted                        ,
#if defined(ENABLE_OVERLOADING)
    rangeInverted                           ,
#endif
    setRangeInverted                        ,


-- ** restrictToFillLevel #attr:restrictToFillLevel#
-- | Controls whether slider movement is restricted to an
-- upper boundary set by the fill level.

#if defined(ENABLE_OVERLOADING)
    RangeRestrictToFillLevelPropertyInfo    ,
#endif
    constructRangeRestrictToFillLevel       ,
    getRangeRestrictToFillLevel             ,
#if defined(ENABLE_OVERLOADING)
    rangeRestrictToFillLevel                ,
#endif
    setRangeRestrictToFillLevel             ,


-- ** roundDigits #attr:roundDigits#
-- | The number of digits to round the value to when
-- it changes.
-- 
-- See [Range::changeValue]("GI.Gtk.Objects.Range#g:signal:changeValue").

#if defined(ENABLE_OVERLOADING)
    RangeRoundDigitsPropertyInfo            ,
#endif
    constructRangeRoundDigits               ,
    getRangeRoundDigits                     ,
#if defined(ENABLE_OVERLOADING)
    rangeRoundDigits                        ,
#endif
    setRangeRoundDigits                     ,


-- ** showFillLevel #attr:showFillLevel#
-- | Controls whether fill level indicator graphics are displayed
-- on the trough.

#if defined(ENABLE_OVERLOADING)
    RangeShowFillLevelPropertyInfo          ,
#endif
    constructRangeShowFillLevel             ,
    getRangeShowFillLevel                   ,
#if defined(ENABLE_OVERLOADING)
    rangeShowFillLevel                      ,
#endif
    setRangeShowFillLevel                   ,




 -- * Signals


-- ** adjustBounds #signal:adjustBounds#

    RangeAdjustBoundsCallback               ,
#if defined(ENABLE_OVERLOADING)
    RangeAdjustBoundsSignalInfo             ,
#endif
    afterRangeAdjustBounds                  ,
    onRangeAdjustBounds                     ,


-- ** changeValue #signal:changeValue#

    RangeChangeValueCallback                ,
#if defined(ENABLE_OVERLOADING)
    RangeChangeValueSignalInfo              ,
#endif
    afterRangeChangeValue                   ,
    onRangeChangeValue                      ,


-- ** moveSlider #signal:moveSlider#

    RangeMoveSliderCallback                 ,
#if defined(ENABLE_OVERLOADING)
    RangeMoveSliderSignalInfo               ,
#endif
    afterRangeMoveSlider                    ,
    onRangeMoveSlider                       ,


-- ** valueChanged #signal:valueChanged#

    RangeValueChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    RangeValueChangedSignalInfo             ,
#endif
    afterRangeValueChanged                  ,
    onRangeValueChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Range = Range (SP.ManagedPtr Range)
    deriving (Eq)

instance SP.ManagedPtrNewtype Range where
    toManagedPtr (Range p) = p

foreign import ccall "gtk_range_get_type"
    c_gtk_range_get_type :: IO B.Types.GType

instance B.Types.TypedObject Range where
    glibType = c_gtk_range_get_type

instance B.Types.GObject Range

-- | Type class for types which can be safely cast to t'Range', for instance with `toRange`.
class (SP.GObject o, O.IsDescendantOf Range o) => IsRange o
instance (SP.GObject o, O.IsDescendantOf Range o) => IsRange o

instance O.HasParentTypes Range
type instance O.ParentTypes Range = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to t'Range', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRange :: (MIO.MonadIO m, IsRange o) => o -> m Range
toRange = MIO.liftIO . B.ManagedPtr.unsafeCastTo Range

-- | Convert t'Range' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Range) where
    gvalueGType_ = c_gtk_range_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Range)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Range)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Range ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveRangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRangeMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveRangeMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveRangeMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveRangeMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveRangeMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveRangeMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveRangeMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveRangeMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveRangeMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveRangeMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveRangeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveRangeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveRangeMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveRangeMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveRangeMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveRangeMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveRangeMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveRangeMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveRangeMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveRangeMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveRangeMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveRangeMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveRangeMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveRangeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveRangeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveRangeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveRangeMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveRangeMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveRangeMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveRangeMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveRangeMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveRangeMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveRangeMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveRangeMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveRangeMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveRangeMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveRangeMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveRangeMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveRangeMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveRangeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveRangeMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveRangeMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveRangeMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveRangeMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveRangeMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveRangeMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveRangeMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveRangeMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveRangeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveRangeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveRangeMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveRangeMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveRangeMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveRangeMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveRangeMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveRangeMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveRangeMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveRangeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveRangeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveRangeMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveRangeMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveRangeMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveRangeMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveRangeMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveRangeMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveRangeMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveRangeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveRangeMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveRangeMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveRangeMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveRangeMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveRangeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveRangeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveRangeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveRangeMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveRangeMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveRangeMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveRangeMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveRangeMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveRangeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveRangeMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveRangeMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveRangeMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveRangeMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveRangeMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveRangeMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveRangeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveRangeMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveRangeMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveRangeMethod "getAdjustment" o = RangeGetAdjustmentMethodInfo
    ResolveRangeMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveRangeMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveRangeMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveRangeMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveRangeMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveRangeMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveRangeMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveRangeMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveRangeMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveRangeMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveRangeMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveRangeMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveRangeMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveRangeMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveRangeMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveRangeMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveRangeMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveRangeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveRangeMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveRangeMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveRangeMethod "getFillLevel" o = RangeGetFillLevelMethodInfo
    ResolveRangeMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveRangeMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveRangeMethod "getFlippable" o = RangeGetFlippableMethodInfo
    ResolveRangeMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveRangeMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveRangeMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveRangeMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveRangeMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveRangeMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveRangeMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveRangeMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveRangeMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveRangeMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveRangeMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveRangeMethod "getInverted" o = RangeGetInvertedMethodInfo
    ResolveRangeMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveRangeMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveRangeMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveRangeMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveRangeMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveRangeMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveRangeMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveRangeMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveRangeMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveRangeMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveRangeMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveRangeMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveRangeMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveRangeMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveRangeMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveRangeMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveRangeMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveRangeMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveRangeMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveRangeMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveRangeMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveRangeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveRangeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveRangeMethod "getRangeRect" o = RangeGetRangeRectMethodInfo
    ResolveRangeMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveRangeMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveRangeMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveRangeMethod "getRestrictToFillLevel" o = RangeGetRestrictToFillLevelMethodInfo
    ResolveRangeMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveRangeMethod "getRoundDigits" o = RangeGetRoundDigitsMethodInfo
    ResolveRangeMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveRangeMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveRangeMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveRangeMethod "getShowFillLevel" o = RangeGetShowFillLevelMethodInfo
    ResolveRangeMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveRangeMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveRangeMethod "getSliderRange" o = RangeGetSliderRangeMethodInfo
    ResolveRangeMethod "getSliderSizeFixed" o = RangeGetSliderSizeFixedMethodInfo
    ResolveRangeMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveRangeMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveRangeMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveRangeMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveRangeMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveRangeMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveRangeMethod "getValue" o = RangeGetValueMethodInfo
    ResolveRangeMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveRangeMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveRangeMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveRangeMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveRangeMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveRangeMethod "setAdjustment" o = RangeSetAdjustmentMethodInfo
    ResolveRangeMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveRangeMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveRangeMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveRangeMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveRangeMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveRangeMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveRangeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveRangeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveRangeMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveRangeMethod "setFillLevel" o = RangeSetFillLevelMethodInfo
    ResolveRangeMethod "setFlippable" o = RangeSetFlippableMethodInfo
    ResolveRangeMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveRangeMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveRangeMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveRangeMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveRangeMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveRangeMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveRangeMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveRangeMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveRangeMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveRangeMethod "setIncrements" o = RangeSetIncrementsMethodInfo
    ResolveRangeMethod "setInverted" o = RangeSetInvertedMethodInfo
    ResolveRangeMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveRangeMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveRangeMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveRangeMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveRangeMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveRangeMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveRangeMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveRangeMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveRangeMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveRangeMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveRangeMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveRangeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveRangeMethod "setRange" o = RangeSetRangeMethodInfo
    ResolveRangeMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveRangeMethod "setRestrictToFillLevel" o = RangeSetRestrictToFillLevelMethodInfo
    ResolveRangeMethod "setRoundDigits" o = RangeSetRoundDigitsMethodInfo
    ResolveRangeMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveRangeMethod "setShowFillLevel" o = RangeSetShowFillLevelMethodInfo
    ResolveRangeMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveRangeMethod "setSliderSizeFixed" o = RangeSetSliderSizeFixedMethodInfo
    ResolveRangeMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveRangeMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveRangeMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveRangeMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveRangeMethod "setValue" o = RangeSetValueMethodInfo
    ResolveRangeMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveRangeMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveRangeMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveRangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethod info Range p) => OL.IsLabel t (Range -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethod info Range p, R.HasField t Range p) => R.HasField t Range p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethodInfo info Range) => OL.IsLabel t (O.MethodProxy info Range) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Range::adjust-bounds
-- | Emitted before clamping a value, to give the application a
-- chance to adjust the bounds.
type RangeAdjustBoundsCallback =
    Double
    -- ^ /@value@/: the value before we clamp
    -> IO ()

type C_RangeAdjustBoundsCallback =
    Ptr Range ->                            -- object
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_RangeAdjustBoundsCallback`.
foreign import ccall "wrapper"
    mk_RangeAdjustBoundsCallback :: C_RangeAdjustBoundsCallback -> IO (FunPtr C_RangeAdjustBoundsCallback)

wrap_RangeAdjustBoundsCallback :: 
    GObject a => (a -> RangeAdjustBoundsCallback) ->
    C_RangeAdjustBoundsCallback
wrap_RangeAdjustBoundsCallback gi'cb gi'selfPtr value _ = do
    let value' = realToFrac value
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  value'


-- | Connect a signal handler for the [adjustBounds](#signal:adjustBounds) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' range #adjustBounds callback
-- @
-- 
-- 
onRangeAdjustBounds :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeAdjustBoundsCallback) -> m SignalHandlerId
onRangeAdjustBounds obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeAdjustBoundsCallback wrapped
    wrapped'' <- mk_RangeAdjustBoundsCallback wrapped'
    connectSignalFunPtr obj "adjust-bounds" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [adjustBounds](#signal:adjustBounds) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' range #adjustBounds callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterRangeAdjustBounds :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeAdjustBoundsCallback) -> m SignalHandlerId
afterRangeAdjustBounds obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeAdjustBoundsCallback wrapped
    wrapped'' <- mk_RangeAdjustBoundsCallback wrapped'
    connectSignalFunPtr obj "adjust-bounds" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data RangeAdjustBoundsSignalInfo
instance SignalInfo RangeAdjustBoundsSignalInfo where
    type HaskellCallbackType RangeAdjustBoundsSignalInfo = RangeAdjustBoundsCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_RangeAdjustBoundsCallback cb
        cb'' <- mk_RangeAdjustBoundsCallback cb'
        connectSignalFunPtr obj "adjust-bounds" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range::adjust-bounds"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:signal:adjustBounds"})

#endif

-- signal Range::change-value
-- | Emitted when a scroll action is performed on a range.
-- 
-- It allows an application to determine the type of scroll event
-- that occurred and the resultant new value. The application can
-- handle the event itself and return 'P.True' to prevent further
-- processing. Or, by returning 'P.False', it can pass the event to
-- other handlers until the default GTK handler is reached.
-- 
-- The value parameter is unrounded. An application that overrides
-- the [changeValue](#g:signal:changeValue) signal is responsible for clamping the value
-- to the desired number of decimal digits; the default GTK
-- handler clamps the value based on [Range:roundDigits]("GI.Gtk.Objects.Range#g:attr:roundDigits").
type RangeChangeValueCallback =
    Gtk.Enums.ScrollType
    -- ^ /@scroll@/: the type of scroll action that was performed
    -> Double
    -- ^ /@value@/: the new value resulting from the scroll action
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to prevent other handlers from being invoked for
    --     the signal, 'P.False' to propagate the signal further

type C_RangeChangeValueCallback =
    Ptr Range ->                            -- object
    CUInt ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_RangeChangeValueCallback`.
foreign import ccall "wrapper"
    mk_RangeChangeValueCallback :: C_RangeChangeValueCallback -> IO (FunPtr C_RangeChangeValueCallback)

wrap_RangeChangeValueCallback :: 
    GObject a => (a -> RangeChangeValueCallback) ->
    C_RangeChangeValueCallback
wrap_RangeChangeValueCallback gi'cb gi'selfPtr scroll value _ = do
    let scroll' = (toEnum . fromIntegral) scroll
    let value' = realToFrac value
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scroll' value'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [changeValue](#signal:changeValue) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' range #changeValue callback
-- @
-- 
-- 
onRangeChangeValue :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeChangeValueCallback) -> m SignalHandlerId
onRangeChangeValue obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeChangeValueCallback wrapped
    wrapped'' <- mk_RangeChangeValueCallback wrapped'
    connectSignalFunPtr obj "change-value" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changeValue](#signal:changeValue) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' range #changeValue callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterRangeChangeValue :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeChangeValueCallback) -> m SignalHandlerId
afterRangeChangeValue obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeChangeValueCallback wrapped
    wrapped'' <- mk_RangeChangeValueCallback wrapped'
    connectSignalFunPtr obj "change-value" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data RangeChangeValueSignalInfo
instance SignalInfo RangeChangeValueSignalInfo where
    type HaskellCallbackType RangeChangeValueSignalInfo = RangeChangeValueCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_RangeChangeValueCallback cb
        cb'' <- mk_RangeChangeValueCallback cb'
        connectSignalFunPtr obj "change-value" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range::change-value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:signal:changeValue"})

#endif

-- signal Range::move-slider
-- | Virtual function that moves the slider.
-- 
-- Used for keybindings.
type RangeMoveSliderCallback =
    Gtk.Enums.ScrollType
    -- ^ /@step@/: how to move the slider
    -> IO ()

type C_RangeMoveSliderCallback =
    Ptr Range ->                            -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_RangeMoveSliderCallback`.
foreign import ccall "wrapper"
    mk_RangeMoveSliderCallback :: C_RangeMoveSliderCallback -> IO (FunPtr C_RangeMoveSliderCallback)

wrap_RangeMoveSliderCallback :: 
    GObject a => (a -> RangeMoveSliderCallback) ->
    C_RangeMoveSliderCallback
wrap_RangeMoveSliderCallback gi'cb gi'selfPtr step _ = do
    let step' = (toEnum . fromIntegral) step
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  step'


-- | Connect a signal handler for the [moveSlider](#signal:moveSlider) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' range #moveSlider callback
-- @
-- 
-- 
onRangeMoveSlider :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeMoveSliderCallback) -> m SignalHandlerId
onRangeMoveSlider obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeMoveSliderCallback wrapped
    wrapped'' <- mk_RangeMoveSliderCallback wrapped'
    connectSignalFunPtr obj "move-slider" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveSlider](#signal:moveSlider) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' range #moveSlider callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterRangeMoveSlider :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeMoveSliderCallback) -> m SignalHandlerId
afterRangeMoveSlider obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeMoveSliderCallback wrapped
    wrapped'' <- mk_RangeMoveSliderCallback wrapped'
    connectSignalFunPtr obj "move-slider" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data RangeMoveSliderSignalInfo
instance SignalInfo RangeMoveSliderSignalInfo where
    type HaskellCallbackType RangeMoveSliderSignalInfo = RangeMoveSliderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_RangeMoveSliderCallback cb
        cb'' <- mk_RangeMoveSliderCallback cb'
        connectSignalFunPtr obj "move-slider" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range::move-slider"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:signal:moveSlider"})

#endif

-- signal Range::value-changed
-- | Emitted when the range value changes.
type RangeValueChangedCallback =
    IO ()

type C_RangeValueChangedCallback =
    Ptr Range ->                            -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_RangeValueChangedCallback`.
foreign import ccall "wrapper"
    mk_RangeValueChangedCallback :: C_RangeValueChangedCallback -> IO (FunPtr C_RangeValueChangedCallback)

wrap_RangeValueChangedCallback :: 
    GObject a => (a -> RangeValueChangedCallback) ->
    C_RangeValueChangedCallback
wrap_RangeValueChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' range #valueChanged callback
-- @
-- 
-- 
onRangeValueChanged :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeValueChangedCallback) -> m SignalHandlerId
onRangeValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeValueChangedCallback wrapped
    wrapped'' <- mk_RangeValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' range #valueChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterRangeValueChanged :: (IsRange a, MonadIO m) => a -> ((?self :: a) => RangeValueChangedCallback) -> m SignalHandlerId
afterRangeValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_RangeValueChangedCallback wrapped
    wrapped'' <- mk_RangeValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data RangeValueChangedSignalInfo
instance SignalInfo RangeValueChangedSignalInfo where
    type HaskellCallbackType RangeValueChangedSignalInfo = RangeValueChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_RangeValueChangedCallback cb
        cb'' <- mk_RangeValueChangedCallback cb'
        connectSignalFunPtr obj "value-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range::value-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:signal:valueChanged"})

#endif

-- VVV Prop "adjustment"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Adjustment"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #adjustment
-- @
getRangeAdjustment :: (MonadIO m, IsRange o) => o -> m Gtk.Adjustment.Adjustment
getRangeAdjustment obj = MIO.liftIO $ checkUnexpectedNothing "getRangeAdjustment" $ B.Properties.getObjectPropertyObject obj "adjustment" Gtk.Adjustment.Adjustment

-- | Set the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #adjustment 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeAdjustment :: (MonadIO m, IsRange o, Gtk.Adjustment.IsAdjustment a) => o -> a -> m ()
setRangeAdjustment obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "adjustment" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@adjustment@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeAdjustment :: (IsRange o, MIO.MonadIO m, Gtk.Adjustment.IsAdjustment a) => a -> m (GValueConstruct o)
constructRangeAdjustment val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "adjustment" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data RangeAdjustmentPropertyInfo
instance AttrInfo RangeAdjustmentPropertyInfo where
    type AttrAllowedOps RangeAdjustmentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeAdjustmentPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferTypeConstraint RangeAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferType RangeAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrGetType RangeAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrLabel RangeAdjustmentPropertyInfo = "adjustment"
    type AttrOrigin RangeAdjustmentPropertyInfo = Range
    attrGet = getRangeAdjustment
    attrSet = setRangeAdjustment
    attrTransfer _ v = do
        unsafeCastTo Gtk.Adjustment.Adjustment v
    attrConstruct = constructRangeAdjustment
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.adjustment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:adjustment"
        })
#endif

-- VVV Prop "fill-level"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #fillLevel
-- @
getRangeFillLevel :: (MonadIO m, IsRange o) => o -> m Double
getRangeFillLevel obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "fill-level"

-- | Set the value of the “@fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #fillLevel 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeFillLevel :: (MonadIO m, IsRange o) => o -> Double -> m ()
setRangeFillLevel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "fill-level" val

-- | Construct a t'GValueConstruct' with valid value for the “@fill-level@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeFillLevel :: (IsRange o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructRangeFillLevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "fill-level" val

#if defined(ENABLE_OVERLOADING)
data RangeFillLevelPropertyInfo
instance AttrInfo RangeFillLevelPropertyInfo where
    type AttrAllowedOps RangeFillLevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeFillLevelPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeFillLevelPropertyInfo = (~) Double
    type AttrTransferTypeConstraint RangeFillLevelPropertyInfo = (~) Double
    type AttrTransferType RangeFillLevelPropertyInfo = Double
    type AttrGetType RangeFillLevelPropertyInfo = Double
    type AttrLabel RangeFillLevelPropertyInfo = "fill-level"
    type AttrOrigin RangeFillLevelPropertyInfo = Range
    attrGet = getRangeFillLevel
    attrSet = setRangeFillLevel
    attrTransfer _ v = do
        return v
    attrConstruct = constructRangeFillLevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.fillLevel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:fillLevel"
        })
#endif

-- VVV Prop "inverted"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #inverted
-- @
getRangeInverted :: (MonadIO m, IsRange o) => o -> m Bool
getRangeInverted obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "inverted"

-- | Set the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #inverted 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeInverted :: (MonadIO m, IsRange o) => o -> Bool -> m ()
setRangeInverted obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "inverted" val

-- | Construct a t'GValueConstruct' with valid value for the “@inverted@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeInverted :: (IsRange o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructRangeInverted val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "inverted" val

#if defined(ENABLE_OVERLOADING)
data RangeInvertedPropertyInfo
instance AttrInfo RangeInvertedPropertyInfo where
    type AttrAllowedOps RangeInvertedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeInvertedPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeInvertedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint RangeInvertedPropertyInfo = (~) Bool
    type AttrTransferType RangeInvertedPropertyInfo = Bool
    type AttrGetType RangeInvertedPropertyInfo = Bool
    type AttrLabel RangeInvertedPropertyInfo = "inverted"
    type AttrOrigin RangeInvertedPropertyInfo = Range
    attrGet = getRangeInverted
    attrSet = setRangeInverted
    attrTransfer _ v = do
        return v
    attrConstruct = constructRangeInverted
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.inverted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:inverted"
        })
#endif

-- VVV Prop "restrict-to-fill-level"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@restrict-to-fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #restrictToFillLevel
-- @
getRangeRestrictToFillLevel :: (MonadIO m, IsRange o) => o -> m Bool
getRangeRestrictToFillLevel obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "restrict-to-fill-level"

-- | Set the value of the “@restrict-to-fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #restrictToFillLevel 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeRestrictToFillLevel :: (MonadIO m, IsRange o) => o -> Bool -> m ()
setRangeRestrictToFillLevel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "restrict-to-fill-level" val

-- | Construct a t'GValueConstruct' with valid value for the “@restrict-to-fill-level@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeRestrictToFillLevel :: (IsRange o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructRangeRestrictToFillLevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "restrict-to-fill-level" val

#if defined(ENABLE_OVERLOADING)
data RangeRestrictToFillLevelPropertyInfo
instance AttrInfo RangeRestrictToFillLevelPropertyInfo where
    type AttrAllowedOps RangeRestrictToFillLevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeRestrictToFillLevelPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeRestrictToFillLevelPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint RangeRestrictToFillLevelPropertyInfo = (~) Bool
    type AttrTransferType RangeRestrictToFillLevelPropertyInfo = Bool
    type AttrGetType RangeRestrictToFillLevelPropertyInfo = Bool
    type AttrLabel RangeRestrictToFillLevelPropertyInfo = "restrict-to-fill-level"
    type AttrOrigin RangeRestrictToFillLevelPropertyInfo = Range
    attrGet = getRangeRestrictToFillLevel
    attrSet = setRangeRestrictToFillLevel
    attrTransfer _ v = do
        return v
    attrConstruct = constructRangeRestrictToFillLevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.restrictToFillLevel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:restrictToFillLevel"
        })
#endif

-- VVV Prop "round-digits"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@round-digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #roundDigits
-- @
getRangeRoundDigits :: (MonadIO m, IsRange o) => o -> m Int32
getRangeRoundDigits obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "round-digits"

-- | Set the value of the “@round-digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #roundDigits 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeRoundDigits :: (MonadIO m, IsRange o) => o -> Int32 -> m ()
setRangeRoundDigits obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "round-digits" val

-- | Construct a t'GValueConstruct' with valid value for the “@round-digits@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeRoundDigits :: (IsRange o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructRangeRoundDigits val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "round-digits" val

#if defined(ENABLE_OVERLOADING)
data RangeRoundDigitsPropertyInfo
instance AttrInfo RangeRoundDigitsPropertyInfo where
    type AttrAllowedOps RangeRoundDigitsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeRoundDigitsPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeRoundDigitsPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint RangeRoundDigitsPropertyInfo = (~) Int32
    type AttrTransferType RangeRoundDigitsPropertyInfo = Int32
    type AttrGetType RangeRoundDigitsPropertyInfo = Int32
    type AttrLabel RangeRoundDigitsPropertyInfo = "round-digits"
    type AttrOrigin RangeRoundDigitsPropertyInfo = Range
    attrGet = getRangeRoundDigits
    attrSet = setRangeRoundDigits
    attrTransfer _ v = do
        return v
    attrConstruct = constructRangeRoundDigits
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.roundDigits"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:roundDigits"
        })
#endif

-- VVV Prop "show-fill-level"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' range #showFillLevel
-- @
getRangeShowFillLevel :: (MonadIO m, IsRange o) => o -> m Bool
getRangeShowFillLevel obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-fill-level"

-- | Set the value of the “@show-fill-level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' range [ #showFillLevel 'Data.GI.Base.Attributes.:=' value ]
-- @
setRangeShowFillLevel :: (MonadIO m, IsRange o) => o -> Bool -> m ()
setRangeShowFillLevel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-fill-level" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-fill-level@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructRangeShowFillLevel :: (IsRange o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructRangeShowFillLevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-fill-level" val

#if defined(ENABLE_OVERLOADING)
data RangeShowFillLevelPropertyInfo
instance AttrInfo RangeShowFillLevelPropertyInfo where
    type AttrAllowedOps RangeShowFillLevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint RangeShowFillLevelPropertyInfo = IsRange
    type AttrSetTypeConstraint RangeShowFillLevelPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint RangeShowFillLevelPropertyInfo = (~) Bool
    type AttrTransferType RangeShowFillLevelPropertyInfo = Bool
    type AttrGetType RangeShowFillLevelPropertyInfo = Bool
    type AttrLabel RangeShowFillLevelPropertyInfo = "show-fill-level"
    type AttrOrigin RangeShowFillLevelPropertyInfo = Range
    attrGet = getRangeShowFillLevel
    attrSet = setRangeShowFillLevel
    attrTransfer _ v = do
        return v
    attrConstruct = constructRangeShowFillLevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.showFillLevel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#g:attr:showFillLevel"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Range
type instance O.AttributeList Range = RangeAttributeList
type RangeAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("adjustment", RangeAdjustmentPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("fillLevel", RangeFillLevelPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inverted", RangeInvertedPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("restrictToFillLevel", RangeRestrictToFillLevelPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("roundDigits", RangeRoundDigitsPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showFillLevel", RangeShowFillLevelPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
rangeAdjustment :: AttrLabelProxy "adjustment"
rangeAdjustment = AttrLabelProxy

rangeFillLevel :: AttrLabelProxy "fillLevel"
rangeFillLevel = AttrLabelProxy

rangeInverted :: AttrLabelProxy "inverted"
rangeInverted = AttrLabelProxy

rangeRestrictToFillLevel :: AttrLabelProxy "restrictToFillLevel"
rangeRestrictToFillLevel = AttrLabelProxy

rangeRoundDigits :: AttrLabelProxy "roundDigits"
rangeRoundDigits = AttrLabelProxy

rangeShowFillLevel :: AttrLabelProxy "showFillLevel"
rangeShowFillLevel = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Range = RangeSignalList
type RangeSignalList = ('[ '("adjustBounds", RangeAdjustBoundsSignalInfo), '("changeValue", RangeChangeValueSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveSlider", RangeMoveSliderSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("valueChanged", RangeValueChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Range::get_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_adjustment" gtk_range_get_adjustment :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Get the adjustment which is the “model” object for @GtkRange@.
rangeGetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Gtk.Adjustment.Adjustment
    -- ^ __Returns:__ a @GtkAdjustment@
rangeGetAdjustment range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_adjustment range'
    checkUnexpectedReturnNULL "rangeGetAdjustment" result
    result' <- (newObject Gtk.Adjustment.Adjustment) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetAdjustmentMethodInfo
instance (signature ~ (m Gtk.Adjustment.Adjustment), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetAdjustmentMethodInfo a signature where
    overloadedMethod = rangeGetAdjustment

instance O.OverloadedMethodInfo RangeGetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetAdjustment"
        })


#endif

-- method Range::get_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_fill_level" gtk_range_get_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CDouble

-- | Gets the current position of the fill level indicator.
rangeGetFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: A @GtkRange@
    -> m Double
    -- ^ __Returns:__ The current fill level
rangeGetFillLevel range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_fill_level range'
    let result' = realToFrac result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetFillLevelMethodInfo
instance (signature ~ (m Double), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetFillLevelMethodInfo a signature where
    overloadedMethod = rangeGetFillLevel

instance O.OverloadedMethodInfo RangeGetFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetFillLevel"
        })


#endif

-- method Range::get_flippable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_flippable" gtk_range_get_flippable :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CInt

-- | Gets whether the @GtkRange@ respects text direction.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetFlippable'.
rangeGetFlippable ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the range is flippable
rangeGetFlippable range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_flippable range'
    let result' = (/= 0) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetFlippableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetFlippableMethodInfo a signature where
    overloadedMethod = rangeGetFlippable

instance O.OverloadedMethodInfo RangeGetFlippableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetFlippable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetFlippable"
        })


#endif

-- method Range::get_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_inverted" gtk_range_get_inverted :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CInt

-- | Gets whether the range is inverted.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetInverted'.
rangeGetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the range is inverted
rangeGetInverted range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_inverted range'
    let result' = (/= 0) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetInvertedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetInvertedMethodInfo a signature where
    overloadedMethod = rangeGetInverted

instance O.OverloadedMethodInfo RangeGetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetInverted"
        })


#endif

-- method Range::get_range_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "range_rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the range rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_range_rect" gtk_range_get_range_rect :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    Ptr Gdk.Rectangle.Rectangle ->          -- range_rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | This function returns the area that contains the range’s trough,
-- in coordinates relative to /@range@/\'s origin.
-- 
-- This function is useful mainly for @GtkRange@ subclasses.
rangeGetRangeRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m (Gdk.Rectangle.Rectangle)
rangeGetRangeRect range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    rangeRect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gtk_range_get_range_rect range' rangeRect
    rangeRect' <- (wrapBoxed Gdk.Rectangle.Rectangle) rangeRect
    touchManagedPtr range
    return rangeRect'

#if defined(ENABLE_OVERLOADING)
data RangeGetRangeRectMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetRangeRectMethodInfo a signature where
    overloadedMethod = rangeGetRangeRect

instance O.OverloadedMethodInfo RangeGetRangeRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetRangeRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetRangeRect"
        })


#endif

-- method Range::get_restrict_to_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_restrict_to_fill_level" gtk_range_get_restrict_to_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CInt

-- | Gets whether the range is restricted to the fill level.
rangeGetRestrictToFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: A @GtkRange@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@range@/ is restricted to the fill level.
rangeGetRestrictToFillLevel range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_restrict_to_fill_level range'
    let result' = (/= 0) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetRestrictToFillLevelMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetRestrictToFillLevelMethodInfo a signature where
    overloadedMethod = rangeGetRestrictToFillLevel

instance O.OverloadedMethodInfo RangeGetRestrictToFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetRestrictToFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetRestrictToFillLevel"
        })


#endif

-- method Range::get_round_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_round_digits" gtk_range_get_round_digits :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO Int32

-- | Gets the number of digits to round the value to when
-- it changes.
-- 
-- See [Range::changeValue]("GI.Gtk.Objects.Range#g:signal:changeValue").
rangeGetRoundDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Int32
    -- ^ __Returns:__ the number of digits to round to
rangeGetRoundDigits range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_round_digits range'
    touchManagedPtr range
    return result

#if defined(ENABLE_OVERLOADING)
data RangeGetRoundDigitsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetRoundDigitsMethodInfo a signature where
    overloadedMethod = rangeGetRoundDigits

instance O.OverloadedMethodInfo RangeGetRoundDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetRoundDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetRoundDigits"
        })


#endif

-- method Range::get_show_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_show_fill_level" gtk_range_get_show_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CInt

-- | Gets whether the range displays the fill level graphically.
rangeGetShowFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: A @GtkRange@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@range@/ shows the fill level.
rangeGetShowFillLevel range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_show_fill_level range'
    let result' = (/= 0) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetShowFillLevelMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetShowFillLevelMethodInfo a signature where
    overloadedMethod = rangeGetShowFillLevel

instance O.OverloadedMethodInfo RangeGetShowFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetShowFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetShowFillLevel"
        })


#endif

-- method Range::get_slider_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "slider_start"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the slider's start"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "slider_end"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the slider's end"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_slider_range" gtk_range_get_slider_range :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    Ptr Int32 ->                            -- slider_start : TBasicType TInt
    Ptr Int32 ->                            -- slider_end : TBasicType TInt
    IO ()

-- | This function returns sliders range along the long dimension,
-- in widget->window coordinates.
-- 
-- This function is useful mainly for @GtkRange@ subclasses.
rangeGetSliderRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m ((Int32, Int32))
rangeGetSliderRange range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    sliderStart <- allocMem :: IO (Ptr Int32)
    sliderEnd <- allocMem :: IO (Ptr Int32)
    gtk_range_get_slider_range range' sliderStart sliderEnd
    sliderStart' <- peek sliderStart
    sliderEnd' <- peek sliderEnd
    touchManagedPtr range
    freeMem sliderStart
    freeMem sliderEnd
    return (sliderStart', sliderEnd')

#if defined(ENABLE_OVERLOADING)
data RangeGetSliderRangeMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetSliderRangeMethodInfo a signature where
    overloadedMethod = rangeGetSliderRange

instance O.OverloadedMethodInfo RangeGetSliderRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetSliderRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetSliderRange"
        })


#endif

-- method Range::get_slider_size_fixed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_slider_size_fixed" gtk_range_get_slider_size_fixed :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CInt

-- | This function is useful mainly for @GtkRange@ subclasses.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetSliderSizeFixed'.
rangeGetSliderSizeFixed ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Bool
    -- ^ __Returns:__ whether the range’s slider has a fixed size.
rangeGetSliderSizeFixed range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_slider_size_fixed range'
    let result' = (/= 0) result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetSliderSizeFixedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetSliderSizeFixedMethodInfo a signature where
    overloadedMethod = rangeGetSliderSizeFixed

instance O.OverloadedMethodInfo RangeGetSliderSizeFixedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetSliderSizeFixed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetSliderSizeFixed"
        })


#endif

-- method Range::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_get_value" gtk_range_get_value :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    IO CDouble

-- | Gets the current value of the range.
rangeGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> m Double
    -- ^ __Returns:__ current value of the range.
rangeGetValue range = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    result <- gtk_range_get_value range'
    let result' = realToFrac result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsRange a) => O.OverloadedMethod RangeGetValueMethodInfo a signature where
    overloadedMethod = rangeGetValue

instance O.OverloadedMethodInfo RangeGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeGetValue"
        })


#endif

-- method Range::set_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAdjustment`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_adjustment" gtk_range_set_adjustment :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Sets the adjustment to be used as the “model” object for the @GtkRange@
-- 
-- The adjustment indicates the current range value, the minimum and
-- maximum range values, the step\/page increments used for keybindings
-- and scrolling, and the page size.
-- 
-- The page size is normally 0 for @GtkScale@ and nonzero for @GtkScrollbar@,
-- and indicates the size of the visible area of the widget being scrolled.
-- The page size affects the size of the scrollbar slider.
rangeSetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> b
    -- ^ /@adjustment@/: a @GtkAdjustment@
    -> m ()
rangeSetAdjustment range adjustment = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    adjustment' <- unsafeManagedPtrCastPtr adjustment
    gtk_range_set_adjustment range' adjustment'
    touchManagedPtr range
    touchManagedPtr adjustment
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetAdjustmentMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsRange a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod RangeSetAdjustmentMethodInfo a signature where
    overloadedMethod = rangeSetAdjustment

instance O.OverloadedMethodInfo RangeSetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetAdjustment"
        })


#endif

-- method Range::set_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fill_level"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new position of the fill level indicator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_fill_level" gtk_range_set_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CDouble ->                              -- fill_level : TBasicType TDouble
    IO ()

-- | Set the new position of the fill level indicator.
-- 
-- The “fill level” is probably best described by its most prominent
-- use case, which is an indicator for the amount of pre-buffering in
-- a streaming media player. In that use case, the value of the range
-- would indicate the current play position, and the fill level would
-- be the position up to which the file\/stream has been downloaded.
-- 
-- This amount of prebuffering can be displayed on the range’s trough
-- and is themeable separately from the trough. To enable fill level
-- display, use 'GI.Gtk.Objects.Range.rangeSetShowFillLevel'. The range defaults
-- to not showing the fill level.
-- 
-- Additionally, it’s possible to restrict the range’s slider position
-- to values which are smaller than the fill level. This is controlled
-- by 'GI.Gtk.Objects.Range.rangeSetRestrictToFillLevel' and is by default
-- enabled.
rangeSetFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Double
    -- ^ /@fillLevel@/: the new position of the fill level indicator
    -> m ()
rangeSetFillLevel range fillLevel = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let fillLevel' = realToFrac fillLevel
    gtk_range_set_fill_level range' fillLevel'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetFillLevelMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetFillLevelMethodInfo a signature where
    overloadedMethod = rangeSetFillLevel

instance O.OverloadedMethodInfo RangeSetFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetFillLevel"
        })


#endif

-- method Range::set_flippable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flippable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make the range flippable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_flippable" gtk_range_set_flippable :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CInt ->                                 -- flippable : TBasicType TBoolean
    IO ()

-- | Sets whether the @GtkRange@ respects text direction.
-- 
-- If a range is flippable, it will switch its direction
-- if it is horizontal and its direction is 'GI.Gtk.Enums.TextDirectionRtl'.
-- 
-- See 'GI.Gtk.Objects.Widget.widgetGetDirection'.
rangeSetFlippable ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Bool
    -- ^ /@flippable@/: 'P.True' to make the range flippable
    -> m ()
rangeSetFlippable range flippable = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let flippable' = (P.fromIntegral . P.fromEnum) flippable
    gtk_range_set_flippable range' flippable'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetFlippableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetFlippableMethodInfo a signature where
    overloadedMethod = rangeSetFlippable

instance O.OverloadedMethodInfo RangeSetFlippableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetFlippable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetFlippable"
        })


#endif

-- method Range::set_increments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "step size" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "page size" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_increments" gtk_range_set_increments :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CDouble ->                              -- step : TBasicType TDouble
    CDouble ->                              -- page : TBasicType TDouble
    IO ()

-- | Sets the step and page sizes for the range.
-- 
-- The step size is used when the user clicks the @GtkScrollbar@
-- arrows or moves a @GtkScale@ via arrow keys. The page size
-- is used for example when moving via Page Up or Page Down keys.
rangeSetIncrements ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Double
    -- ^ /@step@/: step size
    -> Double
    -- ^ /@page@/: page size
    -> m ()
rangeSetIncrements range step page = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let step' = realToFrac step
    let page' = realToFrac page
    gtk_range_set_increments range' step' page'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetIncrementsMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetIncrementsMethodInfo a signature where
    overloadedMethod = rangeSetIncrements

instance O.OverloadedMethodInfo RangeSetIncrementsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetIncrements",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetIncrements"
        })


#endif

-- method Range::set_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to invert the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_inverted" gtk_range_set_inverted :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether to invert the range.
-- 
-- Ranges normally move from lower to higher values as the
-- slider moves from top to bottom or left to right. Inverted
-- ranges have higher values at the top or on the right rather
-- than on the bottom or left.
rangeSetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Bool
    -- ^ /@setting@/: 'P.True' to invert the range
    -> m ()
rangeSetInverted range setting = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_range_set_inverted range' setting'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetInvertedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetInvertedMethodInfo a signature where
    overloadedMethod = rangeSetInverted

instance O.OverloadedMethodInfo RangeSetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetInverted"
        })


#endif

-- method Range::set_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum range value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum range value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_range" gtk_range_set_range :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CDouble ->                              -- min : TBasicType TDouble
    CDouble ->                              -- max : TBasicType TDouble
    IO ()

-- | Sets the allowable values in the @GtkRange@.
-- 
-- The range value is clamped to be between /@min@/ and /@max@/.
-- (If the range has a non-zero page size, it is clamped
-- between /@min@/ and /@max@/ - page-size.)
rangeSetRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Double
    -- ^ /@min@/: minimum range value
    -> Double
    -- ^ /@max@/: maximum range value
    -> m ()
rangeSetRange range min max = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let min' = realToFrac min
    let max' = realToFrac max
    gtk_range_set_range range' min' max'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetRangeMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetRangeMethodInfo a signature where
    overloadedMethod = rangeSetRange

instance O.OverloadedMethodInfo RangeSetRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetRange"
        })


#endif

-- method Range::set_restrict_to_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "restrict_to_fill_level"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Whether the fill level restricts slider movement."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_restrict_to_fill_level" gtk_range_set_restrict_to_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CInt ->                                 -- restrict_to_fill_level : TBasicType TBoolean
    IO ()

-- | Sets whether the slider is restricted to the fill level.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetFillLevel' for a general description
-- of the fill level concept.
rangeSetRestrictToFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: A @GtkRange@
    -> Bool
    -- ^ /@restrictToFillLevel@/: Whether the fill level restricts slider movement.
    -> m ()
rangeSetRestrictToFillLevel range restrictToFillLevel = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let restrictToFillLevel' = (P.fromIntegral . P.fromEnum) restrictToFillLevel
    gtk_range_set_restrict_to_fill_level range' restrictToFillLevel'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetRestrictToFillLevelMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetRestrictToFillLevelMethodInfo a signature where
    overloadedMethod = rangeSetRestrictToFillLevel

instance O.OverloadedMethodInfo RangeSetRestrictToFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetRestrictToFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetRestrictToFillLevel"
        })


#endif

-- method Range::set_round_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "round_digits"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the precision in digits, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_round_digits" gtk_range_set_round_digits :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    Int32 ->                                -- round_digits : TBasicType TInt
    IO ()

-- | Sets the number of digits to round the value to when
-- it changes.
-- 
-- See [Range::changeValue]("GI.Gtk.Objects.Range#g:signal:changeValue").
rangeSetRoundDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Int32
    -- ^ /@roundDigits@/: the precision in digits, or -1
    -> m ()
rangeSetRoundDigits range roundDigits = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    gtk_range_set_round_digits range' roundDigits
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetRoundDigitsMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetRoundDigitsMethodInfo a signature where
    overloadedMethod = rangeSetRoundDigits

instance O.OverloadedMethodInfo RangeSetRoundDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetRoundDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetRoundDigits"
        })


#endif

-- method Range::set_show_fill_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_fill_level"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Whether a fill level indicator graphics is shown."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_show_fill_level" gtk_range_set_show_fill_level :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CInt ->                                 -- show_fill_level : TBasicType TBoolean
    IO ()

-- | Sets whether a graphical fill level is show on the trough.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetFillLevel' for a general description
-- of the fill level concept.
rangeSetShowFillLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: A @GtkRange@
    -> Bool
    -- ^ /@showFillLevel@/: Whether a fill level indicator graphics is shown.
    -> m ()
rangeSetShowFillLevel range showFillLevel = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let showFillLevel' = (P.fromIntegral . P.fromEnum) showFillLevel
    gtk_range_set_show_fill_level range' showFillLevel'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetShowFillLevelMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetShowFillLevelMethodInfo a signature where
    overloadedMethod = rangeSetShowFillLevel

instance O.OverloadedMethodInfo RangeSetShowFillLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetShowFillLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetShowFillLevel"
        })


#endif

-- method Range::set_slider_size_fixed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size_fixed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make the slider size constant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_slider_size_fixed" gtk_range_set_slider_size_fixed :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CInt ->                                 -- size_fixed : TBasicType TBoolean
    IO ()

-- | Sets whether the range’s slider has a fixed size, or a size that
-- depends on its adjustment’s page size.
-- 
-- This function is useful mainly for @GtkRange@ subclasses.
rangeSetSliderSizeFixed ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Bool
    -- ^ /@sizeFixed@/: 'P.True' to make the slider size constant
    -> m ()
rangeSetSliderSizeFixed range sizeFixed = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let sizeFixed' = (P.fromIntegral . P.fromEnum) sizeFixed
    gtk_range_set_slider_size_fixed range' sizeFixed'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetSliderSizeFixedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetSliderSizeFixedMethodInfo a signature where
    overloadedMethod = rangeSetSliderSizeFixed

instance O.OverloadedMethodInfo RangeSetSliderSizeFixedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetSliderSizeFixed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetSliderSizeFixed"
        })


#endif

-- method Range::set_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkRange`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new value of the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_range_set_value" gtk_range_set_value :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Gtk", name = "Range"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the current value of the range.
-- 
-- If the value is outside the minimum or maximum range values,
-- it will be clamped to fit inside them. The range emits the
-- [Range::valueChanged]("GI.Gtk.Objects.Range#g:signal:valueChanged") signal if the value changes.
rangeSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsRange a) =>
    a
    -- ^ /@range@/: a @GtkRange@
    -> Double
    -- ^ /@value@/: new value of the range
    -> m ()
rangeSetValue range value = liftIO $ do
    range' <- unsafeManagedPtrCastPtr range
    let value' = realToFrac value
    gtk_range_set_value range' value'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeSetValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsRange a) => O.OverloadedMethod RangeSetValueMethodInfo a signature where
    overloadedMethod = rangeSetValue

instance O.OverloadedMethodInfo RangeSetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Range.rangeSetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Range.html#v:rangeSetValue"
        })


#endif


