{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.GObject.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace GObject"
 , ""
 , "# Can be ignored in the bindings."
 , "ignore signal_set_va_marshaller"
 , ""
 , "# Requires support for non-GObject objects, which we do not support."
 , "ignore TypePluginClass"
 , ""
 , "# Wrong introspection data."
 , "set-attr GObject/signal_emitv/@parameters/return_value caller-allocates 1"
 , "set-attr GObject/signal_emitv/@parameters/return_value direction out"
 , ""
 , "# Marked as (skip), but it is useful and we can generate bindings"
 , "# without issue."
 , "set-attr GObject/Object/set_data_full introspectable 1"
 , ""
 , "# These class structs are useful to expose"
 , "set-attr GObject/InitiallyUnownedClass haskell-gi-force-visible 1"
 , "set-attr GObject/TypeClass haskell-gi-force-visible 1"
 , "set-attr GObject/ObjectClass haskell-gi-force-visible 1"
 , ""
 , "# There is a typo in the introspection data"
 , "set-attr GObject/ParamSpec glib:unref-func g_param_spec_unref"
 , ""
 , "# Work around problem with newer versions where the closure attribute"
 , "# points to the closure arg."
 , "set-attr GObject/signal_handlers_unblock_matched/@parameters/data closure -1"
 , "set-attr GObject/signal_handlers_block_matched/@parameters/data closure -1"
 , "set-attr GObject/signal_handlers_disconnect_matched/@parameters/data closure -1"
 , "set-attr GObject/signal_handler_find/@parameters/data closure -1"
 , "set-attr GObject/signal_add_emission_hook/@parameters/hook_data closure -1"
 , ""
 , "# Generated from gobject 2.48.0 with xsltproc Nullable.xslt GObject-2.0.gir"
 , "set-attr GObject/BindingTransformFunc/@parameters/user_data nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__BOXED_BOXED/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__BOXED_BOXED/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__BOXED_BOXEDv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__BOXED_BOXEDv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__FLAGS/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__FLAGS/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__FLAGSv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_BOOLEAN__FLAGSv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_STRING__OBJECT_POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_STRING__OBJECT_POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_STRING__OBJECT_POINTERv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_STRING__OBJECT_POINTERv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOOLEAN/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOOLEAN/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOOLEANv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOOLEANv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOXED/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOXED/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOXEDv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__BOXEDv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__CHAR/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__CHAR/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__CHARv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__CHARv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__DOUBLE/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__DOUBLE/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__DOUBLEv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__DOUBLEv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ENUM/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ENUM/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ENUMv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ENUMv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLAGS/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLAGS/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLAGSv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLAGSv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLOAT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLOAT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLOATv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__FLOATv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__INT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__INT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__INTv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__INTv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__LONG/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__LONG/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__LONGv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__LONGv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__OBJECT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__OBJECT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__OBJECTv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__OBJECTv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__PARAM/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__PARAM/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__PARAMv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__PARAMv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__POINTERv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__POINTERv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__STRING/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__STRING/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__STRINGv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__STRINGv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UCHAR/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UCHAR/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UCHARv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UCHARv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT_POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT_POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT_POINTERv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINT_POINTERv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINTv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__UINTv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ULONG/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ULONG/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ULONGv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__ULONGv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VARIANT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VARIANT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VARIANTv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VARIANTv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VOID/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VOID/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VOIDv/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_VOID__VOIDv/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_generic/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/CClosure/marshal_generic/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/marshal_generic_va/@parameters/return_value nullable 1"
 , "set-attr GObject/CClosure/marshal_generic_va/@parameters/marshal_data nullable 1"
 , "set-attr GObject/CClosure/new/@parameters/callback_func nullable 1"
 , "set-attr GObject/CClosure/new/@parameters/user_data nullable 1"
 , "set-attr GObject/CClosure/new_swap/@parameters/callback_func nullable 1"
 , "set-attr GObject/CClosure/new_swap/@parameters/user_data nullable 1"
 , "set-attr GObject/ClassFinalizeFunc/@parameters/class_data nullable 1"
 , "set-attr GObject/ClassInitFunc/@parameters/class_data nullable 1"
 , "set-attr GObject/Closure/new_simple/@parameters/data nullable 1"
 , "set-attr GObject/Closure/add_finalize_notifier/@parameters/notify_data nullable 1"
 , "set-attr GObject/Closure/add_finalize_notifier/@parameters/notify_func nullable 1"
 , "set-attr GObject/Closure/add_invalidate_notifier/@parameters/notify_data nullable 1"
 , "set-attr GObject/Closure/add_invalidate_notifier/@parameters/notify_func nullable 1"
 , "set-attr GObject/Closure/add_marshal_guards/@parameters/pre_marshal_data nullable 1"
 , "set-attr GObject/Closure/add_marshal_guards/@parameters/pre_marshal_notify nullable 1"
 , "set-attr GObject/Closure/add_marshal_guards/@parameters/post_marshal_data nullable 1"
 , "set-attr GObject/Closure/add_marshal_guards/@parameters/post_marshal_notify nullable 1"
 , "set-attr GObject/Closure/invoke/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/Closure/remove_finalize_notifier/@parameters/notify_data nullable 1"
 , "set-attr GObject/Closure/remove_invalidate_notifier/@parameters/notify_data nullable 1"
 , "set-attr GObject/Closure/set_meta_marshal/@parameters/marshal_data nullable 1"
 , "set-attr GObject/Closure/set_meta_marshal/@parameters/meta_marshal nullable 1"
 , "set-attr GObject/ClosureMarshal/@parameters/return_value nullable 1"
 , "set-attr GObject/ClosureMarshal/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/ClosureMarshal/@parameters/marshal_data nullable 1"
 , "set-attr GObject/ClosureNotify/@parameters/data nullable 1"
 , "set-attr GObject/InterfaceFinalizeFunc/@parameters/iface_data nullable 1"
 , "set-attr GObject/InterfaceInitFunc/@parameters/iface_data nullable 1"
 , "set-attr GObject/Object/compat_control/@parameters/data nullable 1"
 , "set-attr GObject/Object/add_toggle_ref/@parameters/data nullable 1"
 , "set-attr GObject/Object/bind_property_full/@parameters/transform_to nullable 1"
 , "set-attr GObject/Object/bind_property_full/@parameters/transform_from nullable 1"
 , "set-attr GObject/Object/bind_property_full/@parameters/user_data nullable 1"
 , "set-attr GObject/Object/dup_data/@return-value nullable 1"
 , "set-attr GObject/Object/dup_data/@parameters/dup_func nullable 1"
 , "set-attr GObject/Object/dup_data/@parameters/user_data nullable 1"
 , "set-attr GObject/Object/dup_qdata/@return-value nullable 1"
 , "set-attr GObject/Object/dup_qdata/@parameters/dup_func nullable 1"
 , "set-attr GObject/Object/dup_qdata/@parameters/user_data nullable 1"
 , "set-attr GObject/Object/get_data/@return-value nullable 1"
 , "set-attr GObject/Object/get_qdata/@return-value nullable 1"
 , "set-attr GObject/Object/remove_toggle_ref/@parameters/data nullable 1"
 , "set-attr GObject/Object/replace_data/@parameters/oldval nullable 1"
 , "set-attr GObject/Object/replace_data/@parameters/newval nullable 1"
 , "set-attr GObject/Object/replace_data/@parameters/destroy nullable 1"
 , "set-attr GObject/Object/replace_data/@parameters/old_destroy nullable 1"
 , "set-attr GObject/Object/replace_qdata/@parameters/oldval nullable 1"
 , "set-attr GObject/Object/replace_qdata/@parameters/newval nullable 1"
 , "set-attr GObject/Object/replace_qdata/@parameters/destroy nullable 1"
 , "set-attr GObject/Object/replace_qdata/@parameters/old_destroy nullable 1"
 , "set-attr GObject/Object/set_data/@parameters/data nullable 1"
 , "set-attr GObject/Object/set_data_full/@parameters/data nullable 1"
 , "set-attr GObject/Object/set_qdata/@parameters/data nullable 1"
 , "set-attr GObject/Object/set_qdata_full/@parameters/data nullable 1"
 , "set-attr GObject/Object/steal_data/@return-value nullable 1"
 , "set-attr GObject/Object/steal_qdata/@return-value nullable 1"
 , "set-attr GObject/Object/weak_ref/@parameters/data nullable 1"
 , "set-attr GObject/Object/weak_unref/@parameters/data nullable 1"
 , "set-attr GObject/ParamSpec/get_qdata/@return-value nullable 1"
 , "set-attr GObject/ParamSpec/set_qdata/@parameters/data nullable 1"
 , "set-attr GObject/ParamSpec/set_qdata_full/@parameters/data nullable 1"
 , "set-attr GObject/ParamSpec/steal_qdata/@return-value nullable 1"
 , "set-attr GObject/SignalAccumulator/@parameters/data nullable 1"
 , "set-attr GObject/SignalEmissionHook/@parameters/data nullable 1"
 , "set-attr GObject/ToggleNotify/@parameters/data nullable 1"
 , "set-attr GObject/TypeClass/get_private/@return-value nullable 1"
 , "set-attr GObject/TypeClass/adjust_private_offset/@parameters/g_class nullable 1"
 , "set-attr GObject/TypeClassCacheFunc/@parameters/cache_data nullable 1"
 , "set-attr GObject/TypeInstance/get_private/@return-value nullable 1"
 , "set-attr GObject/TypeInterfaceCheckFunc/@parameters/check_data nullable 1"
 , "set-attr GObject/VaClosureMarshal/@parameters/return_value nullable 1"
 , "set-attr GObject/VaClosureMarshal/@parameters/marshal_data nullable 1"
 , "set-attr GObject/Value/dup_boxed/@return-value nullable 1"
 , "set-attr GObject/Value/get_boxed/@return-value nullable 1"
 , "set-attr GObject/Value/get_pointer/@return-value nullable 1"
 , "set-attr GObject/Value/peek_pointer/@return-value nullable 1"
 , "set-attr GObject/Value/set_boxed/@parameters/v_boxed nullable 1"
 , "set-attr GObject/Value/set_boxed_take_ownership/@parameters/v_boxed nullable 1"
 , "set-attr GObject/Value/set_instance/@parameters/instance nullable 1"
 , "set-attr GObject/Value/set_object/@parameters/v_object nullable 1"
 , "set-attr GObject/Value/set_object_take_ownership/@parameters/v_object nullable 1"
 , "set-attr GObject/Value/set_param/@parameters/param nullable 1"
 , "set-attr GObject/Value/set_param_take_ownership/@parameters/param nullable 1"
 , "set-attr GObject/Value/set_pointer/@parameters/v_pointer nullable 1"
 , "set-attr GObject/Value/set_static_boxed/@parameters/v_boxed nullable 1"
 , "set-attr GObject/Value/set_static_string/@parameters/v_string nullable 1"
 , "set-attr GObject/Value/set_string/@parameters/v_string nullable 1"
 , "set-attr GObject/Value/set_string_take_ownership/@parameters/v_string nullable 1"
 , "set-attr GObject/Value/set_variant/@parameters/variant nullable 1"
 , "set-attr GObject/Value/take_boxed/@parameters/v_boxed nullable 1"
 , "set-attr GObject/Value/take_object/@parameters/v_object nullable 1"
 , "set-attr GObject/Value/take_param/@parameters/param nullable 1"
 , "set-attr GObject/Value/take_string/@parameters/v_string nullable 1"
 , "set-attr GObject/Value/take_variant/@parameters/variant nullable 1"
 , "set-attr GObject/ValueArray/append/@parameters/value nullable 1"
 , "set-attr GObject/ValueArray/insert/@parameters/value nullable 1"
 , "set-attr GObject/ValueArray/prepend/@parameters/value nullable 1"
 , "set-attr GObject/ValueArray/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GObject/WeakNotify/@parameters/data nullable 1"
 , "set-attr GObject/WeakRef/init/@parameters/object nullable 1"
 , "set-attr GObject/WeakRef/set/@parameters/object nullable 1"
 , "set-attr GObject/cclosure_marshal_BOOLEAN__BOXED_BOXED/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_BOOLEAN__BOXED_BOXED/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_BOOLEAN__FLAGS/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_BOOLEAN__FLAGS/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_STRING__OBJECT_POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_STRING__OBJECT_POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__BOOLEAN/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__BOOLEAN/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__BOXED/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__BOXED/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__CHAR/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__CHAR/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__DOUBLE/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__DOUBLE/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__ENUM/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__ENUM/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__FLAGS/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__FLAGS/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__FLOAT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__FLOAT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__INT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__INT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__LONG/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__LONG/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__OBJECT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__OBJECT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__PARAM/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__PARAM/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__STRING/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__STRING/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UCHAR/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UCHAR/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UINT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UINT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UINT_POINTER/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__UINT_POINTER/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__ULONG/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__ULONG/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__VARIANT/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__VARIANT/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__VOID/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_VOID__VOID/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_marshal_generic/@parameters/invocation_hint nullable 1"
 , "set-attr GObject/cclosure_marshal_generic/@parameters/marshal_data nullable 1"
 , "set-attr GObject/cclosure_new/@parameters/callback_func nullable 1"
 , "set-attr GObject/cclosure_new/@parameters/user_data nullable 1"
 , "set-attr GObject/cclosure_new_swap/@parameters/callback_func nullable 1"
 , "set-attr GObject/cclosure_new_swap/@parameters/user_data nullable 1"
 , "set-attr GObject/param_spec_string/@parameters/default_value nullable 1"
 , "set-attr GObject/param_spec_variant/@parameters/default_value nullable 1"
 , "set-attr GObject/signal_accumulator_first_wins/@parameters/dummy nullable 1"
 , "set-attr GObject/signal_accumulator_true_handled/@parameters/dummy nullable 1"
 , "set-attr GObject/signal_add_emission_hook/@parameters/hook_data nullable 1"
 , "set-attr GObject/signal_connect_data/@parameters/data nullable 1"
 , "set-attr GObject/signal_connect_object/@parameters/gobject nullable 1"
 , "set-attr GObject/signal_handler_find/@parameters/closure nullable 1"
 , "set-attr GObject/signal_handler_find/@parameters/func nullable 1"
 , "set-attr GObject/signal_handler_find/@parameters/data nullable 1"
 , "set-attr GObject/signal_handlers_block_matched/@parameters/closure nullable 1"
 , "set-attr GObject/signal_handlers_block_matched/@parameters/func nullable 1"
 , "set-attr GObject/signal_handlers_block_matched/@parameters/data nullable 1"
 , "set-attr GObject/signal_handlers_disconnect_matched/@parameters/closure nullable 1"
 , "set-attr GObject/signal_handlers_disconnect_matched/@parameters/func nullable 1"
 , "set-attr GObject/signal_handlers_disconnect_matched/@parameters/data nullable 1"
 , "set-attr GObject/signal_handlers_unblock_matched/@parameters/closure nullable 1"
 , "set-attr GObject/signal_handlers_unblock_matched/@parameters/func nullable 1"
 , "set-attr GObject/signal_handlers_unblock_matched/@parameters/data nullable 1"
 , "set-attr GObject/signal_new/@parameters/accu_data nullable 1"
 , "set-attr GObject/signal_new/@parameters/c_marshaller nullable 1"
 , "set-attr GObject/signal_new_class_handler/@parameters/accu_data nullable 1"
 , "set-attr GObject/signal_new_class_handler/@parameters/c_marshaller nullable 1"
 , "set-attr GObject/signal_new_valist/@parameters/accu_data nullable 1"
 , "set-attr GObject/signal_new_valist/@parameters/c_marshaller nullable 1"
 , "set-attr GObject/signal_newv/@parameters/class_closure nullable 1"
 , "set-attr GObject/signal_newv/@parameters/accumulator nullable 1"
 , "set-attr GObject/signal_newv/@parameters/accu_data nullable 1"
 , "set-attr GObject/signal_newv/@parameters/c_marshaller nullable 1"
 , "set-attr GObject/type_add_class_cache_func/@parameters/cache_data nullable 1"
 , "set-attr GObject/type_add_interface_check/@parameters/check_data nullable 1"
 , "set-attr GObject/type_class_adjust_private_offset/@parameters/g_class nullable 1"
 , "set-attr GObject/type_get_qdata/@return-value nullable 1"
 , "set-attr GObject/type_remove_class_cache_func/@parameters/cache_data nullable 1"
 , "set-attr GObject/type_remove_interface_check/@parameters/check_data nullable 1"
 , "set-attr GObject/type_set_qdata/@parameters/data nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.GObject.Config"
 , "GI.GObject"
 , "GI.GObject.Callbacks"
 , "GI.GObject.Constants"
 , "GI.GObject.Flags"
 , "GI.GObject.Functions"
 , "GI.GObject.Interfaces"
 , "GI.GObject.Interfaces.TypePlugin"
 , "GI.GObject.Objects"
 , "GI.GObject.Objects.Binding"
 , "GI.GObject.Objects.BindingGroup"
 , "GI.GObject.Objects.InitiallyUnowned"
 , "GI.GObject.Objects.Object"
 , "GI.GObject.Objects.ParamSpec"
 , "GI.GObject.Objects.ParamSpecBoolean"
 , "GI.GObject.Objects.ParamSpecBoxed"
 , "GI.GObject.Objects.ParamSpecChar"
 , "GI.GObject.Objects.ParamSpecDouble"
 , "GI.GObject.Objects.ParamSpecEnum"
 , "GI.GObject.Objects.ParamSpecFlags"
 , "GI.GObject.Objects.ParamSpecFloat"
 , "GI.GObject.Objects.ParamSpecGType"
 , "GI.GObject.Objects.ParamSpecInt"
 , "GI.GObject.Objects.ParamSpecInt64"
 , "GI.GObject.Objects.ParamSpecLong"
 , "GI.GObject.Objects.ParamSpecObject"
 , "GI.GObject.Objects.ParamSpecOverride"
 , "GI.GObject.Objects.ParamSpecParam"
 , "GI.GObject.Objects.ParamSpecPointer"
 , "GI.GObject.Objects.ParamSpecString"
 , "GI.GObject.Objects.ParamSpecUChar"
 , "GI.GObject.Objects.ParamSpecUInt"
 , "GI.GObject.Objects.ParamSpecUInt64"
 , "GI.GObject.Objects.ParamSpecULong"
 , "GI.GObject.Objects.ParamSpecUnichar"
 , "GI.GObject.Objects.ParamSpecValueArray"
 , "GI.GObject.Objects.ParamSpecVariant"
 , "GI.GObject.Objects.SignalGroup"
 , "GI.GObject.Objects.TypeModule"
 , "GI.GObject.Structs"
 , "GI.GObject.Structs.CClosure"
 , "GI.GObject.Structs.ClosureNotifyData"
 , "GI.GObject.Structs.EnumClass"
 , "GI.GObject.Structs.EnumValue"
 , "GI.GObject.Structs.FlagsClass"
 , "GI.GObject.Structs.FlagsValue"
 , "GI.GObject.Structs.InitiallyUnownedClass"
 , "GI.GObject.Structs.InterfaceInfo"
 , "GI.GObject.Structs.ObjectClass"
 , "GI.GObject.Structs.ObjectConstructParam"
 , "GI.GObject.Structs.ParamSpecPool"
 , "GI.GObject.Structs.ParamSpecTypeInfo"
 , "GI.GObject.Structs.Parameter"
 , "GI.GObject.Structs.SignalInvocationHint"
 , "GI.GObject.Structs.SignalQuery"
 , "GI.GObject.Structs.TypeClass"
 , "GI.GObject.Structs.TypeFundamentalInfo"
 , "GI.GObject.Structs.TypeInfo"
 , "GI.GObject.Structs.TypeInstance"
 , "GI.GObject.Structs.TypeInterface"
 , "GI.GObject.Structs.TypeQuery"
 , "GI.GObject.Structs.TypeValueTable"
 , "GI.GObject.Structs.ValueArray"
 , "GI.GObject.Structs.WeakRef"
 , "GI.GObject.Unions"
 , "GI.GObject.Unions.TypeCValue"
 , "GI.GObject.Unions.Value_Data_Union_"]
