/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_frequency_modulator_fc = R"doc(Frequency modulator block.

float input; complex baseband output


Takes a real, baseband signal (x_m[n]) and output a frequency modulated signal (y[n]) according to:





Where x[n] is the input sample at time n and  is the frequency deviation. Common values for   are 5 kHz for narrowband FM channels such as for voice systems and 75 KHz for wideband FM, like audio broadcast FM stations.


In this block, the input argument is , not the frequency deviation. The sensitivity specifies how much the phase changes based on the new input sample. Given a maximum deviation, , and sample rate , the sensitivity is defined as:

Constructor Specific Documentation:

Build a frequency modulator block.

Args:
    sensitivity : radians/sample = amplitude * sensitivity)doc";


static const char* __doc_gr_analog_frequency_modulator_fc_frequency_modulator_fc_0 =
    R"doc()doc";


static const char* __doc_gr_analog_frequency_modulator_fc_frequency_modulator_fc_1 =
    R"doc()doc";


static const char* __doc_gr_analog_frequency_modulator_fc_make = R"doc(Frequency modulator block.

float input; complex baseband output


Takes a real, baseband signal (x_m[n]) and output a frequency modulated signal (y[n]) according to:





Where x[n] is the input sample at time n and  is the frequency deviation. Common values for   are 5 kHz for narrowband FM channels such as for voice systems and 75 KHz for wideband FM, like audio broadcast FM stations.


In this block, the input argument is , not the frequency deviation. The sensitivity specifies how much the phase changes based on the new input sample. Given a maximum deviation, , and sample rate , the sensitivity is defined as:

Constructor Specific Documentation:

Build a frequency modulator block.

Args:
    sensitivity : radians/sample = amplitude * sensitivity)doc";


static const char* __doc_gr_analog_frequency_modulator_fc_set_sensitivity = R"doc()doc";


static const char* __doc_gr_analog_frequency_modulator_fc_sensitivity = R"doc()doc";
