/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.view;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIImportConstants;
import jakarta.faces.component.UIViewAction;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public abstract class ViewMetadata {
    public abstract UIViewRoot createMetadataView(FacesContext var1);

    public abstract String getViewId();

    public static Collection<UIViewParameter> getViewParameters(UIViewRoot root) {
        LinkedList<UIViewParameter> result = null;
        UIComponent metadataFacet = root.getFacet("jakarta_faces_metadata");
        if (metadataFacet == null) {
            return Collections.emptyList();
        }
        if (metadataFacet.getChildCount() > 0) {
            for (UIComponent component : metadataFacet.getChildren()) {
                if (result == null) {
                    result = new LinkedList<UIViewParameter>();
                }
                if (!(component instanceof UIViewParameter)) continue;
                result.add((UIViewParameter)component);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(result);
    }

    public static Collection<UIViewAction> getViewActions(UIViewRoot root) {
        LinkedList<UIViewAction> result = null;
        UIComponent metadataFacet = root.getFacet("jakarta_faces_metadata");
        if (metadataFacet == null) {
            return Collections.emptyList();
        }
        if (metadataFacet.getChildCount() > 0) {
            for (UIComponent component : metadataFacet.getChildren()) {
                if (result == null) {
                    result = new LinkedList<UIViewAction>();
                }
                if (!(component instanceof UIViewAction)) continue;
                result.add((UIViewAction)component);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(result);
    }

    public static boolean hasMetadata(UIViewRoot root) {
        UIComponent metadataFacet = root.getFacet("jakarta_faces_metadata");
        return metadataFacet != null ? metadataFacet.getChildCount() > 0 : false;
    }

    public static Collection<UIImportConstants> getImportConstants(UIViewRoot root) {
        LinkedList<UIImportConstants> result = null;
        UIComponent metadataFacet = root.getFacet("jakarta_faces_metadata");
        if (metadataFacet == null) {
            return Collections.emptyList();
        }
        if (metadataFacet.getChildCount() > 0) {
            for (UIComponent component : metadataFacet.getChildren()) {
                if (result == null) {
                    result = new LinkedList<UIImportConstants>();
                }
                if (!(component instanceof UIImportConstants)) continue;
                result.add((UIImportConstants)component);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(result);
    }
}

