/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ProtocolMetaData;

public class DataSourceMetaData
implements Externalizable {
    private static final long serialVersionUID = 5531437575034018602L;
    private transient String jdbcUrl;
    private transient String jdbcDriver;
    private transient String defaultPassword;
    private transient String defaultUserName;
    private transient ProtocolMetaData metaData;

    public DataSourceMetaData() {
    }

    public DataSourceMetaData(String jdbcDriver, String jdbcUrl, String defaultUserName, String defaultPassword) {
        this.defaultPassword = defaultPassword;
        this.defaultUserName = defaultUserName;
        this.jdbcDriver = jdbcDriver;
        this.jdbcUrl = jdbcUrl;
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.jdbcDriver = (String)in.readObject();
        this.jdbcUrl = (String)in.readObject();
        this.defaultUserName = (String)in.readObject();
        this.defaultPassword = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.jdbcDriver);
        out.writeObject(this.jdbcUrl);
        out.writeObject(this.defaultUserName);
        out.writeObject(this.defaultPassword);
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public String getDefaultUserName() {
        return this.defaultUserName;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }
}

