/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared.lang;

import jakarta.el.ExpressionFactory;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class ClassUtils {
    private static final Logger log = Logger.getLogger(ClassUtils.class.getName());
    public static final Class<boolean[]> BOOLEAN_ARRAY_CLASS = boolean[].class;
    public static final Class<byte[]> BYTE_ARRAY_CLASS = byte[].class;
    public static final Class<char[]> CHAR_ARRAY_CLASS = char[].class;
    public static final Class<short[]> SHORT_ARRAY_CLASS = short[].class;
    public static final Class<int[]> INT_ARRAY_CLASS = int[].class;
    public static final Class<long[]> LONG_ARRAY_CLASS = long[].class;
    public static final Class<float[]> FLOAT_ARRAY_CLASS = float[].class;
    public static final Class<double[]> DOUBLE_ARRAY_CLASS = double[].class;
    public static final Class<Object[]> OBJECT_ARRAY_CLASS = Object[].class;
    public static final Class<Boolean[]> BOOLEAN_OBJECT_ARRAY_CLASS = Boolean[].class;
    public static final Class<Byte[]> BYTE_OBJECT_ARRAY_CLASS = Byte[].class;
    public static final Class<Character[]> CHARACTER_OBJECT_ARRAY_CLASS = Character[].class;
    public static final Class<Short[]> SHORT_OBJECT_ARRAY_CLASS = Short[].class;
    public static final Class<Integer[]> INTEGER_OBJECT_ARRAY_CLASS = Integer[].class;
    public static final Class<Long[]> LONG_OBJECT_ARRAY_CLASS = Long[].class;
    public static final Class<Float[]> FLOAT_OBJECT_ARRAY_CLASS = Float[].class;
    public static final Class<Double[]> DOUBLE_OBJECT_ARRAY_CLASS = Double[].class;
    public static final Class<String[]> STRING_OBJECT_ARRAY_CLASS = String[].class;
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    public static final Map<String, Class<?>> COMMON_TYPES = new HashMap(64);

    public static <T> Class<T> classForName(String type) throws ClassNotFoundException {
        Assert.notNull(type, "type");
        try {
            return Class.forName(type, false, ClassUtils.getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, ClassUtils.class.getClassLoader());
        }
    }

    public static Class simpleClassForName(String type) {
        return ClassUtils.simpleClassForName(type, true);
    }

    public static Class simpleClassForName(String type, boolean logException) {
        Class returnClass;
        block2: {
            returnClass = null;
            try {
                returnClass = ClassUtils.classForName(type);
            }
            catch (ClassNotFoundException e) {
                if (!logException) break block2;
                log.log(Level.SEVERE, "Class " + type + " not found", e);
                throw new FacesException(e);
            }
        }
        return returnClass;
    }

    public static Class<?> javaTypeToClass(String type) throws ClassNotFoundException {
        Assert.notNull(type, "type");
        Class<?> clazz = COMMON_TYPES.get(type);
        if (clazz != null) {
            return clazz;
        }
        int len = type.length();
        if (len > 2 && type.charAt(len - 1) == ']' && type.charAt(len - 2) == '[') {
            String componentType = type.substring(0, len - 2);
            Class componentTypeClass = ClassUtils.classForName(componentType);
            return Array.newInstance(componentTypeClass, 0).getClass();
        }
        return ClassUtils.classForName(type);
    }

    public static Class<?> simpleJavaTypeToClass(String type) {
        try {
            return ClassUtils.javaTypeToClass(type);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "Class " + type + " not found", e);
            throw new FacesException(e);
        }
    }

    public static Class javaDefaultTypeToClass(String type) throws ClassNotFoundException {
        Assert.notNull(type, "type");
        Class<?> clazz = COMMON_TYPES.get(type);
        if (clazz != null) {
            return clazz;
        }
        int len = ((String)type).length();
        if (len > 2 && ((String)type).charAt(len - 1) == ']' && ((String)type).charAt(len - 2) == '[') {
            String componentType = ((String)type).substring(0, len - 2);
            Class componentTypeClass = ClassUtils.classForName(componentType);
            return Array.newInstance(componentTypeClass, 0).getClass();
        }
        if (((String)type).indexOf(46) == -1) {
            type = "java.lang." + (String)type;
        }
        return ClassUtils.classForName((String)type);
    }

    public static URL getResource(String resource) {
        URL url = ClassUtils.getContextClassLoader().getResource(resource);
        if (url == null) {
            url = ClassUtils.class.getClassLoader().getResource(resource);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream stream = ClassUtils.getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassUtils.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    public static Collection<URL> getResources(String resource, Object defaultObject) {
        try {
            Enumeration<URL> resources = ClassUtils.getCurrentLoader(defaultObject).getResources(resource);
            ArrayList<URL> lst = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                lst.add(resources.nextElement());
            }
            return lst;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new FacesException(e);
        }
    }

    public static Object newInstance(String type) throws FacesException {
        if (type == null) {
            return null;
        }
        return ClassUtils.newInstance(ClassUtils.simpleClassForName(type));
    }

    public static Object newInstance(String type, Class<?> expectedType) throws FacesException {
        Class[] classArray;
        if (expectedType == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = expectedType;
        }
        return ClassUtils.newInstance(type, classArray);
    }

    public static Object newInstance(String type, Class<?>[] expectedTypes) {
        if (type == null) {
            return null;
        }
        Class clazzForName = ClassUtils.simpleClassForName(type);
        if (expectedTypes != null) {
            int size = expectedTypes.length;
            for (int i = 0; i < size; ++i) {
                if (expectedTypes[i].isAssignableFrom(clazzForName)) continue;
                throw new FacesException("'" + type + "' does not implement expected type '" + expectedTypes[i] + "'");
            }
        }
        return ClassUtils.newInstance(clazzForName);
    }

    public static <T> T newInstance(Class<T> clazz) throws FacesException {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new FacesException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] constructorArgClasses, Object ... constructorArgs) throws NoSuchMethodException {
        if (constructorArgs.length == 0) {
            return ClassUtils.newInstance(clazz);
        }
        Constructor<T> constructor = clazz.getConstructor(constructorArgClasses);
        try {
            return constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
    }

    public static Object convertToType(Object value, Class<?> desiredClass) {
        if (value == null) {
            return null;
        }
        try {
            ExpressionFactory expFactory = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
            return expFactory.coerceToType(value, desiredClass);
        }
        catch (Exception e) {
            String message = "Cannot coerce " + value.getClass().getName() + " to " + desiredClass.getName();
            log.log(Level.SEVERE, message, e);
            throw new FacesException(message, e);
        }
    }

    public static Object convertToTypeNoLogging(FacesContext facesContext, Object value, Class<?> desiredClass) throws Exception {
        if (value == null) {
            return null;
        }
        ExpressionFactory expFactory = facesContext.getApplication().getExpressionFactory();
        return expFactory.coerceToType(value, desiredClass);
    }

    public static ClassLoader getCurrentLoader(Object defaultObject) {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    public static ClassLoader getCurrentLoader(Class<?> clazz) {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null && clazz != null) {
            loader = clazz.getClassLoader();
        }
        return loader;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                return (ClassLoader)AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException(pae);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ClassUtils.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class<?>[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Class<Object> c = ClassUtils.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = ClassUtils.classForName(nc);
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = ClassUtils.classForName(name);
            }
        }
        return c;
    }

    static {
        COMMON_TYPES.put("byte", Byte.TYPE);
        COMMON_TYPES.put("char", Character.TYPE);
        COMMON_TYPES.put("double", Double.TYPE);
        COMMON_TYPES.put("float", Float.TYPE);
        COMMON_TYPES.put("int", Integer.TYPE);
        COMMON_TYPES.put("long", Long.TYPE);
        COMMON_TYPES.put("short", Short.TYPE);
        COMMON_TYPES.put("boolean", Boolean.TYPE);
        COMMON_TYPES.put("void", Void.TYPE);
        COMMON_TYPES.put("java.lang.Object", Object.class);
        COMMON_TYPES.put("java.lang.Boolean", Boolean.class);
        COMMON_TYPES.put("java.lang.Byte", Byte.class);
        COMMON_TYPES.put("java.lang.Character", Character.class);
        COMMON_TYPES.put("java.lang.Short", Short.class);
        COMMON_TYPES.put("java.lang.Integer", Integer.class);
        COMMON_TYPES.put("java.lang.Long", Long.class);
        COMMON_TYPES.put("java.lang.Float", Float.class);
        COMMON_TYPES.put("java.lang.Double", Double.class);
        COMMON_TYPES.put("java.lang.String", String.class);
        COMMON_TYPES.put("byte[]", BYTE_ARRAY_CLASS);
        COMMON_TYPES.put("char[]", CHAR_ARRAY_CLASS);
        COMMON_TYPES.put("double[]", DOUBLE_ARRAY_CLASS);
        COMMON_TYPES.put("float[]", FLOAT_ARRAY_CLASS);
        COMMON_TYPES.put("int[]", INT_ARRAY_CLASS);
        COMMON_TYPES.put("long[]", LONG_ARRAY_CLASS);
        COMMON_TYPES.put("short[]", SHORT_ARRAY_CLASS);
        COMMON_TYPES.put("boolean[]", BOOLEAN_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Object[]", OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Boolean[]", BOOLEAN_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Byte[]", BYTE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Character[]", CHARACTER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Short[]", SHORT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Integer[]", INTEGER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Long[]", LONG_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Float[]", FLOAT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Double[]", DOUBLE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.String[]", STRING_OBJECT_ARRAY_CLASS);
    }
}

