/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PhaseId;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.CompositeFaceletHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.FacetHandler;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TextHandler;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentRule;
import org.apache.myfaces.view.facelets.tag.composite.CompositeMetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;
import org.apache.myfaces.view.facelets.tag.composite.InsertFacetHandler;
import org.apache.myfaces.view.facelets.tag.composite.RetargetMethodExpressionRule;
import org.apache.myfaces.view.facelets.tag.faces.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.faces.ClearBindingValueExpressionListener;
import org.apache.myfaces.view.facelets.tag.faces.ComponentBuilderHandler;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.faces.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.faces.PreDisposeViewEvent;
import org.apache.myfaces.view.facelets.tag.faces.ValueHolderRule;
import org.apache.myfaces.view.facelets.tag.faces.core.AjaxHandler;

public class CompositeComponentResourceTagHandler
extends ComponentHandler
implements ComponentBuilderHandler,
TemplateClient {
    public static final String CREATE_CC_ON_POST_ADD_TO_VIEW = "oamf.cc.CREATE_CC_POST_ADD_TO_VIEW";
    private final Resource _resource;
    private Metadata _mapper;
    private Class<?> _lastType = Object.class;
    protected volatile Map<String, FaceletHandler> _facetHandlersMap;
    protected final ArrayList<FaceletHandler> _componentHandlers;
    protected final ArrayList<FaceletHandler> _facetHandlers;
    private boolean _dynamicCompositeComponent;

    public CompositeComponentResourceTagHandler(ComponentConfig config, Resource resource) {
        super(config);
        this._resource = resource;
        this._facetHandlers = TagHandlerUtils.findNextByType(this.nextHandler, FacetHandler.class, InsertFacetHandler.class);
        this._componentHandlers = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, ComponentContainerHandler.class, TextHandler.class);
        this._dynamicCompositeComponent = false;
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        FacesContext facesContext = ctx.getFacesContext();
        UIComponent component = facesContext.getApplication().createComponent(facesContext, this._resource);
        if (this.getBinding() != null) {
            ValueExpression bindingVE = this.getBinding().getValueExpression(ctx, Object.class);
            component.setValueExpression("binding", bindingVE);
            if (!bindingVE.isReadOnly(facesContext.getELContext())) {
                if (PhaseId.RESTORE_VIEW.equals(facesContext.getCurrentPhaseId())) {
                    bindingVE.setValue((ELContext)ctx, (Object)component);
                }
                ComponentSupport.getViewRoot(ctx, component).getAttributes().put("oam.CALL_PRE_DISPOSE_VIEW", Boolean.TRUE);
                component.subscribeToEvent(PreDisposeViewEvent.class, (ComponentSystemEventListener)new ClearBindingValueExpressionListener());
            }
        }
        if (!facesContext.isProjectStage(ProjectStage.Production)) {
            BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                TagAttribute attrValue;
                Object value;
                Boolean required;
                ValueExpression ve = (ValueExpression)propertyDescriptor.getValue("required");
                if (ve == null || (required = (value = ve.getValue(facesContext.getELContext())) instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString())) == null || !required.booleanValue() || (attrValue = this.tag.getAttributes().get(propertyDescriptor.getName())) != null) continue;
                throw new TagException(this.tag, "Attribute '" + propertyDescriptor.getName() + "' is required");
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException {
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        if (mctx.isDynamicCompositeComponentHandler()) {
            this._dynamicCompositeComponent = true;
            try {
                mctx.setDynamicCompositeComponentHandler(false);
                Integer step = (Integer)c.getAttributes().get(CREATE_CC_ON_POST_ADD_TO_VIEW);
                if (step == null) {
                    c.getAttributes().put(CREATE_CC_ON_POST_ADD_TO_VIEW, 0);
                }
                if (step == 0) {
                }
                if (step == 1) {
                    this.applyNextHandlerIfNotAppliedDynamically(ctx, c);
                    this.applyCompositeComponentFacelet(ctx, c);
                    this.applyFinalInitializationSteps(ctx, mctx, c);
                    c.getAttributes().put(CREATE_CC_ON_POST_ADD_TO_VIEW, 2);
                }
                this.applyCompositeComponentFacelet(ctx, c);
            }
            finally {
                mctx.setDynamicCompositeComponentHandler(true);
            }
        } else {
            this.applyNextHandlerIfNotApplied(ctx, c);
            this.applyCompositeComponentFacelet(ctx, c);
            if (ComponentHandler.isNew((UIComponent)c)) {
                this.applyFinalInitializationSteps(ctx, mctx, c);
            }
        }
    }

    protected void applyFinalInitializationSteps(FaceletContext ctx, FaceletCompositionContext mctx, UIComponent c) {
        FacesContext facesContext = ctx.getFacesContext();
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
        List<AttachedObjectHandler> handlers = mctx.getAttachedObjectHandlers(c);
        if (handlers != null) {
            vdl.retargetAttachedObjects(facesContext, c, handlers);
            mctx.removeAttachedObjectHandlers(c);
        }
        vdl.retargetMethodExpressions(facesContext, c);
        if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
            c.markInitialState();
            c.getFacet("jakarta.faces.component.COMPOSITE_FACET_NAME").markInitialState();
        }
    }

    protected void applyNextHandlerIfNotApplied(FaceletContext ctx, UIComponent c) throws IOException {
        Map facetPropertyDescriptorMap;
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)c.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        boolean insertChildrenUsed = beanDescriptor.getValue("org.apache.myfaces.INSERT_CHILDREN_USED") != null;
        List insertFacetList = (List)beanDescriptor.getValue("org.apache.myfaces.INSERT_FACET_USED");
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            for (FaceletHandler handler : ((CompositeFaceletHandler)this.nextHandler).getHandlers()) {
                if (handler instanceof FacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((FacetHandler)handler).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (handler instanceof InsertFacetHandler) {
                    if (insertFacetList != null && insertFacetList.contains(((InsertFacetHandler)handler).getFacetName(ctx))) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                if (insertChildrenUsed) {
                    if (handler instanceof ComponentHandler || handler instanceof ComponentContainerHandler || handler instanceof TextHandler) continue;
                    handler.apply(ctx, c);
                    continue;
                }
                handler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof FacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((FacetHandler)this.nextHandler).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (this.nextHandler instanceof InsertFacetHandler) {
            if (insertFacetList == null || !insertFacetList.contains(((InsertFacetHandler)this.nextHandler).getFacetName(ctx))) {
                this.nextHandler.apply(ctx, c);
            }
        } else if (insertChildrenUsed) {
            if (!(this.nextHandler instanceof ComponentHandler || this.nextHandler instanceof ComponentContainerHandler || this.nextHandler instanceof TextHandler)) {
                this.nextHandler.apply(ctx, c);
            }
        } else {
            this.nextHandler.apply(ctx, c);
        }
        if ((facetPropertyDescriptorMap = (Map)beanDescriptor.getValue("jakarta.faces.component.FACETS_KEY")) != null) {
            ArrayList<String> facetsRequiredNotFound = null;
            for (Map.Entry entry : facetPropertyDescriptorMap.entrySet()) {
                Boolean required;
                ValueExpression requiredExpr = (ValueExpression)((PropertyDescriptor)entry.getValue()).getValue("required");
                if (requiredExpr == null || !Boolean.TRUE.equals(required = (Boolean)requiredExpr.getValue(ctx.getFacesContext().getELContext()))) continue;
                this.initFacetHandlersMap(ctx);
                if (this._facetHandlersMap.containsKey(entry.getKey())) continue;
                if (facetsRequiredNotFound == null) {
                    facetsRequiredNotFound = new ArrayList<String>(facetPropertyDescriptorMap.size());
                }
                facetsRequiredNotFound.add((String)entry.getKey());
            }
            if (facetsRequiredNotFound != null && !facetsRequiredNotFound.isEmpty()) {
                throw new TagException(this.getTag(), "The following facets are required by the component: " + facetsRequiredNotFound);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCompositeComponentFacelet(FaceletContext faceletContext, UIComponent compositeComponentBase) throws IOException {
        Iterator<AjaxHandler> it;
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(faceletContext);
        AbstractFaceletContext actx = (AbstractFaceletContext)faceletContext;
        UIPanel compositeFacetPanel = (UIPanel)compositeComponentBase.getFacets().get("jakarta.faces.component.COMPOSITE_FACET_NAME");
        if (compositeFacetPanel == null) {
            compositeFacetPanel = (UIPanel)faceletContext.getFacesContext().getApplication().createComponent(faceletContext.getFacesContext(), "jakarta.faces.Panel", null);
            compositeFacetPanel.getAttributes().put("oam.vf.addedByHandler", Boolean.TRUE);
            compositeComponentBase.getFacets().put("jakarta.faces.component.COMPOSITE_FACET_NAME", compositeFacetPanel);
            UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
            if (uniqueIdVendor == null) {
                uniqueIdVendor = ComponentSupport.getViewRoot(faceletContext, compositeComponentBase);
            }
            if (uniqueIdVendor != null) {
                String uid = uniqueIdVendor.createUniqueId(faceletContext.getFacesContext(), mctx.getSharedStringBuilder().append(compositeComponentBase.getId()).append("__f_").append("cc_facet").toString());
                compositeFacetPanel.setId(uid);
            }
        }
        if ((it = ((AbstractFaceletContext)faceletContext).getAjaxHandlers()) != null) {
            while (it.hasNext()) {
                mctx.addAttachedObjectHandler(compositeComponentBase, (AttachedObjectHandler)it.next());
            }
        }
        VariableMapper orig = faceletContext.getVariableMapper();
        try {
            faceletContext.setVariableMapper((VariableMapper)new VariableMapperWrapper(orig));
            actx.pushCompositeComponentClient(this);
            Resource resourceForCurrentView = faceletContext.getFacesContext().getApplication().getResourceHandler().createResource(this._resource.getResourceName(), this._resource.getLibraryName());
            if (resourceForCurrentView == null) {
                throw new TagException(this.getTag(), "Composite Component " + this.getTag().getQName() + " requires a default instance that can be found by the installed ResourceHandler.");
            }
            resourceForCurrentView = new CompositeResouceWrapper(resourceForCurrentView);
            actx.applyCompositeComponent((UIComponent)compositeFacetPanel, resourceForCurrentView);
        }
        finally {
            actx.popCompositeComponentClient();
            faceletContext.setVariableMapper(orig);
        }
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            UIComponent component = (UIComponent)instance;
            Class<?> type = instance.getClass();
            if (this._mapper == null || !this._lastType.equals(type)) {
                this._lastType = type;
                BeanInfo beanInfo = (BeanInfo)component.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
                this._mapper = this.createMetaRuleset(type, beanInfo).finish();
            }
            this._mapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createMetaRuleset(Class<?> type, BeanInfo beanInfo) {
        CompositeMetaRulesetImpl m = new CompositeMetaRulesetImpl(this.getTag(), type, beanInfo);
        m.ignore("binding").ignore("id");
        m.addRule(CompositeComponentRule.INSTANCE);
        m.addRule(RetargetMethodExpressionRule.INSTANCE);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.INSTANCE);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.INSTANCE);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.INSTANCE);
            }
        }
        return m;
    }

    private void initFacetHandlersMap(FaceletContext ctx) {
        if (this._facetHandlersMap == null) {
            HashMap<String, FaceletHandler> map = new HashMap<String, FaceletHandler>(this._facetHandlers.size());
            for (FaceletHandler handler : this._facetHandlers) {
                if (handler instanceof FacetHandler) {
                    map.put(((FacetHandler)handler).getFacetName(ctx), handler);
                    continue;
                }
                if (!(handler instanceof InsertFacetHandler)) continue;
                map.put(((InsertFacetHandler)handler).getFacetName(ctx), handler);
            }
            this._facetHandlersMap = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        block30: {
            block31: {
                if (!this._dynamicCompositeComponent) break block30;
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
                UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
                Integer step = (Integer)innerCompositeComponent.getAttributes().get(CREATE_CC_ON_POST_ADD_TO_VIEW);
                if (step != null && step == 1) {
                    if (name != null) {
                        if (innerCompositeComponent.getFacetCount() == 0) {
                            this.checkFacetRequired(ctx, name);
                            return true;
                        }
                        UIComponent facet = innerCompositeComponent.getFacet(name);
                        if (facet != null) {
                            innerCompositeComponent.getFacets().remove(name);
                            parent.getFacets().put(name, facet);
                            return true;
                        }
                        this.checkFacetRequired(ctx, name);
                        return true;
                    }
                    if (innerCompositeComponent.getChildCount() > 0) {
                        String facetName = (String)parent.getAttributes().get("facelets.FACET_NAME");
                        ArrayList<UIComponent> children = new ArrayList<UIComponent>(innerCompositeComponent.getChildCount());
                        while (innerCompositeComponent.getChildCount() > 0) {
                            children.add((UIComponent)innerCompositeComponent.getChildren().remove(0));
                        }
                        while (!children.isEmpty()) {
                            UIComponent child = (UIComponent)children.remove(0);
                            child.getAttributes().put("org.apache.myfaces.INSERT_CHILDREN_USED", Boolean.TRUE);
                            if (facetName != null) {
                                ComponentSupport.addFacet(ctx, parent, child, facetName);
                                continue;
                            }
                            parent.getChildren().add(child);
                        }
                    }
                    return true;
                }
                if (step == null || step <= 1 || name != null) break block31;
                String facetName = (String)parent.getAttributes().get("facelets.FACET_NAME");
                ArrayList<UIComponent> children = null;
                if (facetName == null) {
                    children = new ArrayList(parent.getChildCount());
                    int i = 0;
                    while (parent.getChildCount() - i > 0) {
                        UIComponent child = (UIComponent)parent.getChildren().get(i);
                        if (Boolean.TRUE.equals(child.getAttributes().get("org.apache.myfaces.INSERT_CHILDREN_USED"))) {
                            children.add((UIComponent)parent.getChildren().remove(i));
                            continue;
                        }
                        ++i;
                    }
                } else {
                    children = new ArrayList<UIComponent>();
                    UIComponent child = parent.getFacet(facetName);
                    if (Boolean.TRUE.equals(child.getAttributes().get("org.apache.myfaces.INSERT_CHILDREN_USED"))) {
                        parent.getFacets().remove(facetName);
                        children.add(child);
                    } else {
                        UIComponent parentToApply = child;
                        int i = 0;
                        while (parentToApply.getChildCount() - i > 0) {
                            child = (UIComponent)parentToApply.getChildren().get(i);
                            if (Boolean.TRUE.equals(child.getAttributes().get("org.apache.myfaces.INSERT_CHILDREN_USED"))) {
                                children.add((UIComponent)parentToApply.getChildren().remove(i));
                                continue;
                            }
                            ++i;
                        }
                    }
                }
                while (!children.isEmpty()) {
                    UIComponent child = (UIComponent)children.remove(0);
                    if (facetName != null) {
                        ComponentSupport.addFacet(ctx, parent, child, facetName);
                        continue;
                    }
                    parent.getChildren().add(child);
                }
            }
            return true;
        }
        if (name != null) {
            if (this._facetHandlers == null || this._facetHandlers.isEmpty()) {
                this.checkFacetRequired(ctx, name);
                return true;
            }
            this.initFacetHandlersMap(ctx);
            FaceletHandler handler = this._facetHandlersMap.get(name);
            if (handler != null) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
                UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
                fcc.popCompositeComponentToStack();
                TemplateContext itc = actx.popTemplateContext();
                try {
                    handler.apply(ctx, parent);
                }
                finally {
                    actx.pushTemplateContext(itc);
                    fcc.pushCompositeComponentToStack(innerCompositeComponent);
                }
                return true;
            }
            this.checkFacetRequired(ctx, name);
            return true;
        }
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
        UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
        fcc.popCompositeComponentToStack();
        TemplateContext itc = actx.popTemplateContext();
        try {
            for (int i = 0; i < this._componentHandlers.size(); ++i) {
                this._componentHandlers.get(i).apply(ctx, parent);
            }
        }
        finally {
            actx.pushTemplateContext(itc);
            fcc.pushCompositeComponentToStack(innerCompositeComponent);
        }
        return true;
    }

    private void checkFacetRequired(FaceletContext ctx, String name) {
        ValueExpression requiredExpr;
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        FaceletCompositionContext fcc = actx.getFaceletCompositionContext();
        UIComponent innerCompositeComponent = fcc.getCompositeComponentFromStack();
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)innerCompositeComponent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        Map insertFacetPropertyDescriptorMap = (Map)beanDescriptor.getValue("org.apache.myfaces.INSERT_FACET_KEYS");
        if (insertFacetPropertyDescriptorMap != null && insertFacetPropertyDescriptorMap.containsKey(name) && (requiredExpr = (ValueExpression)((PropertyDescriptor)insertFacetPropertyDescriptorMap.get(name)).getValue("required")) != null && Boolean.TRUE.equals(requiredExpr.getValue(ctx.getFacesContext().getELContext()))) {
            throw new TagException(this.tag, "Cannot find facet with name '" + name + "' in composite component");
        }
    }

    protected void applyNextHandlerIfNotAppliedDynamically(FaceletContext ctx, UIComponent c) throws IOException {
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)c.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        Map facetPropertyDescriptorMap = (Map)beanDescriptor.getValue("jakarta.faces.component.FACETS_KEY");
        if (facetPropertyDescriptorMap != null) {
            ArrayList<String> facetsRequiredNotFound = null;
            for (Map.Entry entry : facetPropertyDescriptorMap.entrySet()) {
                Boolean required;
                ValueExpression requiredExpr = (ValueExpression)((PropertyDescriptor)entry.getValue()).getValue("required");
                if (requiredExpr == null || !Boolean.TRUE.equals(required = (Boolean)requiredExpr.getValue(ctx.getFacesContext().getELContext())) || c.getFacet((String)entry.getKey()) != null) continue;
                if (facetsRequiredNotFound == null) {
                    facetsRequiredNotFound = new ArrayList<String>(facetPropertyDescriptorMap.size());
                }
                facetsRequiredNotFound.add((String)entry.getKey());
            }
            if (facetsRequiredNotFound != null && !facetsRequiredNotFound.isEmpty()) {
                throw new TagException(this.getTag(), "The following facets are required by the component: " + facetsRequiredNotFound);
            }
        }
    }
}

