/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.token;

import java.security.cert.X509Certificate;
import org.apache.wss4j.common.crypto.BouncyCastleUtils;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DOMX509SKI {
    private final Element element;
    private final byte[] skiBytes;

    public DOMX509SKI(Document doc, X509Certificate remoteCertificate) {
        this.skiBytes = BouncyCastleUtils.getSubjectKeyIdentifierBytes(remoteCertificate);
        this.element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SKI");
        this.element.setTextContent(XMLUtils.encodeToString((byte[])this.skiBytes));
    }

    public DOMX509SKI(Element skiElement) {
        this.element = skiElement;
        String text = org.apache.wss4j.common.util.XMLUtils.getElementText(this.element);
        this.skiBytes = text == null ? new byte[0] : XMLUtils.decode((String)text);
    }

    public Element getElement() {
        return this.element;
    }

    public byte[] getSKIBytes() {
        return this.skiBytes;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

