/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementIterator
implements Iterator<Element> {
    private final NodeList children;
    private int currentPosition;

    public ElementIterator(Element parent) {
        this.children = parent.getChildNodes();
    }

    @Override
    public boolean hasNext() {
        if (this.children == null || this.children.getLength() < this.currentPosition) {
            return false;
        }
        do {
            Node nd;
            if ((nd = this.children.item(this.currentPosition)) instanceof Element) {
                return true;
            }
            ++this.currentPosition;
        } while (this.currentPosition < this.children.getLength());
        return false;
    }

    @Override
    public Element next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The Element does not have more children");
        }
        return (Element)this.children.item(this.currentPosition++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported with this DOM Element iterator.");
    }
}

