/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.component.UIComponent;
import java.util.HashMap;
import java.util.Map;

public class CommonHtmlEvents {
    public static final String EVENTS_MARKED = "oam.EVENTS_MARKED";
    public static final long ACTION = 1L;
    public static final long CLICK = 2L;
    public static final long DBLCLICK = 4L;
    public static final long MOUSEDOWN = 8L;
    public static final long MOUSEUP = 16L;
    public static final long MOUSEOVER = 32L;
    public static final long MOUSEMOVE = 64L;
    public static final long MOUSEOUT = 128L;
    public static final long KEYPRESS = 256L;
    public static final long KEYDOWN = 512L;
    public static final long KEYUP = 1024L;
    public static final long FOCUS = 2048L;
    public static final long BLUR = 4096L;
    public static final long SELECT = 8192L;
    public static final long CHANGE = 16384L;
    public static final long VALUECHANGE = 32768L;
    public static final long LOAD = 65536L;
    public static final long UNLOAD = 131072L;
    public static final long INPUT = 262144L;
    public static final long INVALID = 524288L;
    public static final long RESET = 0x100000L;
    public static final long CONTEXTMENU = 0x200000L;
    public static final long SUBMIT = 0x400000L;
    public static final long WHEEL = 0x800000L;
    public static final long COPY = 0x1000000L;
    public static final long CUT = 0x2000000L;
    public static final long PASTE = 0x4000000L;
    public static final long DRAG = 0x8000000L;
    public static final long DRAGEND = 0x10000000L;
    public static final long DRAGENTER = 0x20000000L;
    public static final long DRAGLEAVE = 0x40000000L;
    public static final long DRAGOVER = 0x80000000L;
    public static final long DRAGSTART = 0x100000000L;
    public static final long DROP = 0x200000000L;
    public static final long SCROLL = 0x400000000L;
    public static final Map<String, Long> COMMON_EVENTS_KEY_BY_NAME = new HashMap<String, Long>(24, 1.0f);

    public static void markEvent(UIComponent component, String name) {
        Long propertyConstant = COMMON_EVENTS_KEY_BY_NAME.get(name);
        if (propertyConstant == null) {
            return;
        }
        Long commonPropertiesSet = (Long)component.getAttributes().get(EVENTS_MARKED);
        if (commonPropertiesSet == null) {
            commonPropertiesSet = 0L;
        }
        component.getAttributes().put(EVENTS_MARKED, commonPropertiesSet | propertyConstant);
    }

    public static long getMarkedEvents(UIComponent component) {
        Long commonEvents = (Long)component.getAttributes().get(EVENTS_MARKED);
        if (commonEvents == null) {
            commonEvents = 0L;
        }
        return commonEvents;
    }

    static {
        COMMON_EVENTS_KEY_BY_NAME.put("change", 16384L);
        COMMON_EVENTS_KEY_BY_NAME.put("select", 8192L);
        COMMON_EVENTS_KEY_BY_NAME.put("click", 2L);
        COMMON_EVENTS_KEY_BY_NAME.put("dblclick", 4L);
        COMMON_EVENTS_KEY_BY_NAME.put("mousedown", 8L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseup", 16L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseover", 32L);
        COMMON_EVENTS_KEY_BY_NAME.put("mousemove", 64L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseout", 128L);
        COMMON_EVENTS_KEY_BY_NAME.put("keypress", 256L);
        COMMON_EVENTS_KEY_BY_NAME.put("keydown", 512L);
        COMMON_EVENTS_KEY_BY_NAME.put("keyup", 1024L);
        COMMON_EVENTS_KEY_BY_NAME.put("focus", 2048L);
        COMMON_EVENTS_KEY_BY_NAME.put("blur", 4096L);
        COMMON_EVENTS_KEY_BY_NAME.put("load", 65536L);
        COMMON_EVENTS_KEY_BY_NAME.put("unload", 131072L);
        COMMON_EVENTS_KEY_BY_NAME.put("input", 262144L);
        COMMON_EVENTS_KEY_BY_NAME.put("invalid", 524288L);
        COMMON_EVENTS_KEY_BY_NAME.put("reset", 0x100000L);
        COMMON_EVENTS_KEY_BY_NAME.put("contextmenu", 0x200000L);
        COMMON_EVENTS_KEY_BY_NAME.put("submit", 0x400000L);
        COMMON_EVENTS_KEY_BY_NAME.put("wheel", 0x800000L);
        COMMON_EVENTS_KEY_BY_NAME.put("copy", 0x1000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("cut", 0x2000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("paste", 0x4000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("drag", 0x8000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("dragend", 0x10000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("dragenter", 0x20000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("dragleave", 0x40000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("dragover", 0x80000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("dragstart", 0x100000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("drop", 0x200000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("scroll", 0x400000000L);
        COMMON_EVENTS_KEY_BY_NAME.put("valueChange", 32768L);
        COMMON_EVENTS_KEY_BY_NAME.put("action", 1L);
    }
}

