/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.RequestHandler;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

class AuthRequestHandler
extends RequestHandler {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("auth"), (String)"org.apache.openejb.server.util.resources");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    protected AuthRequestHandler(EjbDaemon daemon) {
        super(daemon);
    }

    @Override
    public String getName() {
        return "Authentication";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        AuthenticationRequest req = new AuthenticationRequest();
        req.setMetaData(metaData);
        AuthenticationResponse res = new AuthenticationResponse();
        res.setMetaData(metaData);
        try {
            req.readExternal((ObjectInput)in);
            String securityRealm = req.getRealm();
            String username = req.getUsername();
            String password = req.getCredentials();
            SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
            Object token = securityService.login(securityRealm, username, password);
            ClientMetaData client = new ClientMetaData();
            client.setMetaData(metaData);
            client.setClientIdentity(token);
            res.setIdentity(client);
            res.setResponseCode(1);
        }
        catch (Throwable t) {
            res.setResponseCode(3);
            res.setDeniedCause(t);
        }
        finally {
            if (DEBUG) {
                try {
                    LOGGER.debug("AUTH REQUEST: " + req + " -- RESPONSE: " + res);
                }
                catch (Exception securityRealm) {}
            }
        }
        return res;
    }

    @Override
    public void processResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        if (AuthenticationResponse.class.isInstance(response)) {
            AuthenticationResponse res = (AuthenticationResponse)response;
            res.setMetaData(metaData);
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (Exception e) {
                LOGGER.fatal("Could not write AuthenticationResponse to output stream", (Throwable)e);
            }
        } else {
            LOGGER.error("AuthRequestHandler cannot process an instance of: " + response.getClass().getName());
        }
    }
}

