/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.tags;

import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.runtime.io.ExternalDocumentationIO;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class TagIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Tag, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_REFS = "refs";
    private static final String PROP_REF = "ref";
    private static final String PROP_EXTERNAL_DOCS = "externalDocs";
    private final ExternalDocumentationIO<V, A, O, AB, OB> externalDocIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public TagIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.TAG, Names.create(Tag.class));
        this.externalDocIO = new ExternalDocumentationIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    public List<String> readReferences(AnnotationTarget target) {
        Stream tagsRefs = Optional.ofNullable((String[])this.scannerContext().annotations().getAnnotationValue(target, Names.TAGS, PROP_REFS)).map(Arrays::stream).orElseGet(Stream::empty);
        Stream<String> tagRefs = this.getRepeatableAnnotations(target).stream().filter(this::isReference).map(tag -> (String)this.value((AnnotationInstance)tag, PROP_REF));
        return Stream.concat(tagsRefs, tagRefs).collect(Collectors.toList());
    }

    public List<Tag> readList(AnnotationTarget target) {
        return this.readList((V)this.getRepeatableAnnotations(target));
    }

    public List<Tag> readList(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readList).orElse(null);
    }

    public List<Tag> readList(AnnotationInstance[] annotations) {
        return this.readList((V)Arrays.asList(annotations));
    }

    public List<Tag> readList(Collection<AnnotationInstance> annotations) {
        return annotations.stream().filter(TagIO.not(this::isReference)).map(this::read).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Tag read(AnnotationInstance annotation) {
        Objects.requireNonNull(annotation, "Tag annotation must not be null");
        IoLogging.logger.singleAnnotation("@Tag");
        TagImpl tag = new TagImpl();
        tag.setName((String)this.value(annotation, PROP_NAME));
        tag.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        tag.setExternalDocs((ExternalDocumentation)this.externalDocIO.read(annotation.value(PROP_EXTERNAL_DOCS)));
        tag.setExtensions(this.extensionIO.readExtensible(annotation));
        return tag;
    }

    public List<Tag> readList(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isArray).map(this.jsonIO()::asArray).map(this.jsonIO()::entries).map(Collection::stream).map(elements -> {
            IoLogging.logger.jsonArray("Tag");
            return elements.filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).collect(Collectors.toCollection(ArrayList::new));
        }).orElse(null);
    }

    @Override
    public Tag readObject(O node) {
        IoLogging.logger.singleJsonNode("Tag");
        TagImpl tag = new TagImpl();
        tag.setName(this.jsonIO().getString(node, PROP_NAME));
        tag.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        tag.setExternalDocs((ExternalDocumentation)this.externalDocIO.readValue(this.jsonIO().getValue(node, PROP_EXTERNAL_DOCS)));
        tag.setExtensions(this.extensionIO.readMap(node));
        return tag;
    }

    @Override
    public Optional<A> write(List<Tag> models) {
        return this.optionalJsonArray(models).map(array -> {
            models.forEach(model -> this.write((Tag)model).ifPresent(v -> this.jsonIO().add(array, v)));
            return array;
        }).map(this.jsonIO()::buildArray);
    }

    @Override
    public Optional<O> write(Tag model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
            this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            this.setIfPresent(node, PROP_EXTERNAL_DOCS, this.externalDocIO.write(model.getExternalDocs()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

