/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.asn1.DerWriter;
import io.churchkey.asn1.Oid;
import io.churchkey.ec.EcPoints;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class EcCurveParams {
    public static final ThreadLocal<String> name = new ThreadLocal();
    public static final Oid primeField = new Oid(1, 2, 840, 10045, 1, 1);
    public static final Oid characteristicTwoField = new Oid(1, 2, 840, 10045, 1, 2);
    public static final Oid tpBasis = new Oid(1, 2, 840, 10045, 1, 2, 3, 2);
    public static final Oid ppBasis = new Oid(1, 2, 840, 10045, 1, 2, 3, 3);

    private EcCurveParams() {
    }

    public static Oid parseOid(byte[] data) throws IOException {
        DerParser d1 = new DerParser(data);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        return d1o1.asOID();
    }

    public static ECParameterSpec parse(byte[] data) throws IOException {
        DerParser d1 = new DerParser(data);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        return EcCurveParams.parseSequence(d1o1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECParameterSpec parseSequence(Asn1Object d1o1) throws IOException {
        void var1_12;
        Asn1Object d3o2;
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Oid oid = d3o1.asOID();
        if (primeField.equals(oid)) {
            d3o2 = d3.readObject().assertType(Asn1Type.INTEGER);
            ECFieldFp eCFieldFp = new ECFieldFp(d3o2.toInteger());
        } else {
            if (!characteristicTwoField.equals(oid)) throw new UnsupportedOperationException(oid.toString());
            d3o2 = d3.readObject().assertType(Asn1Type.SEQUENCE);
            DerParser d4 = new DerParser(d3o2.getValue());
            Asn1Object d4o1 = d4.readObject().assertType(Asn1Type.INTEGER);
            Asn1Object d4o2 = d4.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
            Oid basis = d4o2.asOID();
            if (ppBasis.equals(basis)) {
                Asn1Object d4o3 = d4.readObject().assertType(Asn1Type.SEQUENCE);
                DerParser d5 = new DerParser(d4o3.getValue());
                Asn1Object d5o1 = d5.readObject().assertType(Asn1Type.INTEGER);
                Asn1Object d5o2 = d5.readObject().assertType(Asn1Type.INTEGER);
                Asn1Object d5o3 = d5.readObject().assertType(Asn1Type.INTEGER);
                ECFieldF2m eCFieldF2m = new ECFieldF2m(d4o1.asInteger().intValue(), new int[]{d5o3.asInteger().intValue(), d5o2.asInteger().intValue(), d5o1.asInteger().intValue()});
            } else {
                if (!tpBasis.equals(basis)) throw new UnsupportedOperationException("Unsupported characteristic-two-basis " + basis);
                Asn1Object d5o1 = d4.readObject().assertType(Asn1Type.INTEGER);
                ECFieldF2m eCFieldF2m = new ECFieldF2m(d4o1.asInteger().intValue(), new int[]{d5o1.asInteger().intValue()});
            }
        }
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.OCTET_STRING);
        d3o2 = d32.readObject().assertType(Asn1Type.OCTET_STRING);
        Asn1Object d3o3 = d32.readObject();
        BigInteger a = d3o12.toInteger();
        BigInteger b = d3o2.toInteger();
        EllipticCurve ellipticCurve = d3o3 == null ? new EllipticCurve((ECField)var1_12, a, b) : new EllipticCurve((ECField)var1_12, a, b, d3o3.getPureValueBytes());
        Asn1Object d2o4 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        Asn1Object d2o5 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o6 = d2.readObject().assertType(Asn1Type.INTEGER);
        ECPoint point = EcPoints.fromBytes(d2o4.getPureValueBytes());
        return new ECParameterSpec(ellipticCurve, point, d2o5.toInteger(), d2o6.toInteger().intValue());
    }

    public static byte[] encode(ECParameterSpec spec) {
        EllipticCurve curve = spec.getCurve();
        ECField field = curve.getField();
        if (field instanceof ECFieldFp) {
            return curve.getSeed() == null ? EcCurveParams.prime(spec) : EcCurveParams.primeWithSeed(spec);
        }
        if (field instanceof ECFieldF2m) {
            return EcCurveParams.binary(spec);
        }
        throw new UnsupportedOperationException("Unsupported ECField type: " + field.getClass().getName());
    }

    private static byte[] binary(ECParameterSpec spec) {
        ECFieldF2m field = (ECFieldF2m)spec.getCurve().getField();
        byte[] seed = spec.getCurve().getSeed();
        int[] terms = field.getMidTermsOfReductionPolynomial();
        if (terms.length == 1) {
            return seed == null ? EcCurveParams.tpBasis(spec) : EcCurveParams.tpBasisWithSeed(spec);
        }
        if (terms.length == 3) {
            return seed == null ? EcCurveParams.ppBasis(spec) : EcCurveParams.ppBasisWithSeed(spec);
        }
        throw new UnsupportedOperationException("Unsupported number of binary terms " + terms.length);
    }

    private static byte[] tpBasisWithSeed(ECParameterSpec spec) {
        ECFieldF2m field = (ECFieldF2m)spec.getCurve().getField();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(characteristicTwoField).sequence(DerWriter.write().integer(field.getM()).objectIdentifier(tpBasis).integer(field.getMidTermsOfReductionPolynomial()[0]))).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB()).bitString(spec.getCurve().getSeed())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }

    private static byte[] tpBasis(ECParameterSpec spec) {
        ECFieldF2m field = (ECFieldF2m)spec.getCurve().getField();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(characteristicTwoField).sequence(DerWriter.write().integer(field.getM()).objectIdentifier(tpBasis).integer(field.getMidTermsOfReductionPolynomial()[0]))).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }

    private static byte[] ppBasisWithSeed(ECParameterSpec spec) {
        ECFieldF2m field = (ECFieldF2m)spec.getCurve().getField();
        int[] terms = field.getMidTermsOfReductionPolynomial();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(characteristicTwoField).sequence(DerWriter.write().integer(field.getM()).objectIdentifier(ppBasis).sequence(DerWriter.write().integer(terms[2]).integer(terms[1]).integer(terms[0])))).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB()).bitString(spec.getCurve().getSeed())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }

    private static byte[] ppBasis(ECParameterSpec spec) {
        ECFieldF2m field = (ECFieldF2m)spec.getCurve().getField();
        int[] terms = field.getMidTermsOfReductionPolynomial();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(characteristicTwoField).sequence(DerWriter.write().integer(field.getM()).objectIdentifier(ppBasis).sequence(DerWriter.write().integer(terms[2]).integer(terms[1]).integer(terms[0])))).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }

    private static byte[] primeWithSeed(ECParameterSpec spec) {
        ECFieldFp field = (ECFieldFp)spec.getCurve().getField();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(primeField).integer(field.getP())).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB()).bitString(spec.getCurve().getSeed())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }

    private static byte[] prime(ECParameterSpec spec) {
        ECFieldFp field = (ECFieldFp)spec.getCurve().getField();
        return DerWriter.write().sequence(DerWriter.write().integer(BigInteger.ONE).sequence(DerWriter.write().objectIdentifier(primeField).integer(field.getP())).sequence(DerWriter.write().octetString(spec.getCurve().getA()).octetString(spec.getCurve().getB())).octetString(EcPoints.toBytes(spec.getGenerator())).integer(spec.getOrder()).integer(spec.getCofactor())).bytes();
    }
}

