/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.util.internal.ObjectUtil;
import org.apache.tinkerpop.gremlin.server.handler.Frame;

public final class FrameMessageSizeEstimator
implements MessageSizeEstimator {
    private static final FrameMessageSizeEstimator instance = new FrameMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public FrameMessageSizeEstimator(int unknownSize) {
        ObjectUtil.checkPositiveOrZero((int)unknownSize, (String)"unknownSize");
        this.handle = new HandleImpl(unknownSize);
    }

    public static FrameMessageSizeEstimator instance() {
        return instance;
    }

    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int unknownSize) {
            this.unknownSize = unknownSize;
        }

        public int size(Object msg) {
            if (msg instanceof Frame) {
                return this.size0(((Frame)msg).getMsg());
            }
            return this.size0(msg);
        }

        private int size0(Object msg) {
            if (msg instanceof ByteBuf) {
                return ((ByteBuf)msg).readableBytes();
            }
            if (msg instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg).content().readableBytes();
            }
            if (msg instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

