/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Collection;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public interface ListFunction {
    public static Collection asCollection(Object iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        if (iterable != null && iterable.getClass().isArray() || iterable instanceof Iterable) {
            return IteratorUtils.asList(iterable);
        }
        return null;
    }

    public static Set asSet(Object iterable) {
        if (iterable instanceof Iterable || iterable != null && iterable.getClass().isArray()) {
            return IteratorUtils.asSet(iterable);
        }
        return null;
    }

    public String getStepName();

    default public Collection convertArgumentToCollection(Object arg) {
        if (null == arg) {
            throw new IllegalArgumentException(String.format("Argument provided for %s step can't be null.", this.getStepName()));
        }
        Collection incoming = ListFunction.asCollection(arg);
        if (null == incoming) {
            throw new IllegalArgumentException(String.format("%s step can only take an array or an Iterable as an argument, encountered %s", this.getStepName(), arg.getClass()));
        }
        return incoming;
    }

    default public <S> Collection convertTraverserToCollection(Traverser.Admin<S> traverser) {
        Object items = traverser.get();
        if (null == items) {
            throw new IllegalArgumentException(String.format("Incoming traverser for %s step can't be null.", this.getStepName()));
        }
        Collection incoming = ListFunction.asCollection(items);
        if (null == incoming) {
            throw new IllegalArgumentException(String.format("%s step can only take an array or an Iterable type for incoming traversers, encountered %s", this.getStepName(), items.getClass()));
        }
        return incoming;
    }

    default public <S, E> Collection convertTraversalToCollection(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        E array = TraversalUtil.apply(traverser, traversal);
        if (null == array) {
            throw new IllegalArgumentException(String.format("Provided traversal argument for %s step must yield an iterable type, not null", this.getStepName()));
        }
        Collection input = ListFunction.asCollection(array);
        if (null == input) {
            throw new IllegalArgumentException(String.format("Provided traversal argument for %s step must yield an iterable type, encountered %s", this.getStepName(), array.getClass()));
        }
        return input;
    }

    default public Set convertArgumentToSet(Object arg) {
        if (null == arg) {
            throw new IllegalArgumentException(String.format("Argument provided for %s step can't be null.", this.getStepName()));
        }
        Set incoming = ListFunction.asSet(arg);
        if (null == incoming) {
            throw new IllegalArgumentException(String.format("%s step can only take an array or an Iterable as an argument, encountered %s", this.getStepName(), arg.getClass()));
        }
        return incoming;
    }

    default public <S> Set convertTraverserToSet(Traverser.Admin<S> traverser) {
        Object items = traverser.get();
        if (null == items) {
            throw new IllegalArgumentException(String.format("Incoming traverser for %s step can't be null.", this.getStepName()));
        }
        Set incoming = ListFunction.asSet(items);
        if (null == incoming) {
            throw new IllegalArgumentException(String.format("%s step can only take an array or an Iterable type for incoming traversers, encountered %s", this.getStepName(), items.getClass()));
        }
        return incoming;
    }

    default public <S, E> Set convertTraversalToSet(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        E array = TraversalUtil.apply(traverser, traversal);
        if (null == array) {
            throw new IllegalArgumentException(String.format("Provided traversal argument for %s step must yield an iterable type, not null", this.getStepName()));
        }
        Set input = ListFunction.asSet(array);
        if (null == input) {
            throw new IllegalArgumentException(String.format("Provided traversal argument for %s step must yield an iterable type, encountered %s", this.getStepName(), array.getClass()));
        }
        return input;
    }
}

