/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.GraphOp;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.structure.Transaction;

public class DriverRemoteTransaction
implements Transaction,
RemoteConnection {
    private final DriverRemoteConnection sessionBasedConnection;
    protected Consumer<Transaction> closeConsumer = Transaction.CLOSE_BEHAVIOR.COMMIT;

    public DriverRemoteTransaction(DriverRemoteConnection sessionBasedConnection) {
        this.sessionBasedConnection = sessionBasedConnection;
    }

    public <T extends TraversalSource> T begin(Class<T> traversalSourceClass) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Transaction cannot begin as the session is already closed - create a new Transaction");
        }
        try {
            return (T)((TraversalSource)traversalSourceClass.getConstructor(RemoteConnection.class).newInstance(this));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void open() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Transaction cannot be opened as the session is already closed - create a new Transaction");
        }
    }

    public void commit() {
        this.closeRemoteTransaction(GraphOp.TX_COMMIT, "Transaction commit for %s failed");
    }

    public void rollback() {
        this.closeRemoteTransaction(GraphOp.TX_ROLLBACK, "Transaction rollback for %s failed");
    }

    private void closeRemoteTransaction(GraphOp closeTxWith, String failureMsg) {
        try {
            this.sessionBasedConnection.submitAsync(closeTxWith.getBytecode()).join().hasNext();
            this.sessionBasedConnection.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format(failureMsg, this.sessionBasedConnection.getSessionId()), ex);
        }
    }

    public boolean isOpen() {
        return !this.sessionBasedConnection.client.isClosing();
    }

    public void close() {
        this.closeConsumer.accept(this);
    }

    public void readWrite() {
        throw new UnsupportedOperationException("Remote transaction behaviors are not auto-managed - they are always manually controlled");
    }

    public Transaction onReadWrite(Consumer<Transaction> consumer) {
        throw new UnsupportedOperationException("Remote transaction behaviors are not configurable - they are always manually controlled");
    }

    public Transaction onClose(Consumer<Transaction> consumer) {
        this.closeConsumer = consumer;
        return this;
    }

    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        throw new UnsupportedOperationException("Remote transactions cannot have listeners attached");
    }

    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        throw new UnsupportedOperationException("Remote transactions cannot have listeners attached");
    }

    public void clearTransactionListeners() {
        throw new UnsupportedOperationException("Remote transactions cannot have listeners attached");
    }

    public Transaction tx() {
        return Transaction.NO_OP;
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        return this.sessionBasedConnection.submitAsync(bytecode);
    }
}

