/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.workertoken;

import com.codahale.metrics.Meter;
import java.io.Closeable;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.generated.PrivateWorkerKey;
import org.apache.storm.generated.WorkerTokenInfo;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.sasl.PasswordProvider;
import org.apache.storm.security.auth.workertoken.WorkerTokenSigner;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.cache.CacheBuilder;
import org.apache.storm.shade.com.google.common.cache.CacheLoader;
import org.apache.storm.shade.com.google.common.cache.LoadingCache;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerTokenAuthorizer
implements PasswordProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerTokenAuthorizer.class);
    private final LoadingCache<WorkerTokenInfo, PrivateWorkerKey> keyCache;
    private final IStormClusterState state;
    private static final Meter passwordFailures = new Meter();

    public WorkerTokenAuthorizer(Map<String, Object> conf, ThriftConnectionType connectionType) {
        this(connectionType.getWtType(), WorkerTokenAuthorizer.buildStateIfNeeded(conf, connectionType));
    }

    @VisibleForTesting
    WorkerTokenAuthorizer(final WorkerTokenServiceType serviceType, final IStormClusterState state) {
        LoadingCache tmpKeyCache = null;
        if (state != null) {
            tmpKeyCache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<WorkerTokenInfo, PrivateWorkerKey>(){

                public PrivateWorkerKey load(WorkerTokenInfo wtInfo) {
                    return state.getPrivateWorkerKey(serviceType, wtInfo.get_topologyId(), wtInfo.get_secretVersion());
                }
            });
        }
        this.keyCache = tmpKeyCache;
        this.state = state;
    }

    private static IStormClusterState buildStateIfNeeded(Map<String, Object> conf, ThriftConnectionType connectionType) {
        IStormClusterState state = null;
        if (ClientAuthUtils.areWorkerTokensEnabledServer(connectionType, conf)) {
            try {
                state = ClusterUtils.mkStormClusterState(conf, new ClusterStateContext(DaemonType.UNKNOWN, conf));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return state;
    }

    @VisibleForTesting
    byte[] getSignedPasswordFor(byte[] user, WorkerTokenInfo deser) {
        PrivateWorkerKey key;
        assert (this.keyCache != null);
        if (deser.is_set_expirationTimeMillis() && deser.get_expirationTimeMillis() <= Time.currentTimeMillis()) {
            throw new IllegalArgumentException("Token is not valid, token has expired.");
        }
        try {
            key = (PrivateWorkerKey)this.keyCache.getUnchecked((Object)deser);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            throw new IllegalArgumentException("Token is not valid, private key not found.", e);
        }
        if (key.is_set_expirationTimeMillis() && key.get_expirationTimeMillis() <= Time.currentTimeMillis()) {
            throw new IllegalArgumentException("Token is not valid, key has expired.");
        }
        return WorkerTokenSigner.createPassword(user, new SecretKeySpec(key.get_key(), "HmacSHA256"));
    }

    @Override
    public Optional<char[]> getPasswordFor(String userName) {
        if (this.keyCache == null) {
            return Optional.empty();
        }
        byte[] user = null;
        WorkerTokenInfo deser = null;
        try {
            user = Base64.getDecoder().decode(userName);
            deser = Utils.deserialize(user, WorkerTokenInfo.class);
        }
        catch (Exception e) {
            LOG.info("Could not decode {}, might just be a plain digest request...", (Object)userName, (Object)e);
            return Optional.empty();
        }
        try {
            byte[] password = this.getSignedPasswordFor(user, deser);
            return Optional.of(Base64.getEncoder().encodeToString(password).toCharArray());
        }
        catch (Exception e) {
            passwordFailures.mark();
            LOG.error("Could not get password for token {}/{}", new Object[]{deser.get_userName(), deser.get_topologyId(), e});
            return Optional.empty();
        }
    }

    public static Meter getPasswordFailuresMeter() {
        return passwordFailures;
    }

    @Override
    public String userName(String userName) {
        byte[] user = Base64.getDecoder().decode(userName);
        WorkerTokenInfo deser = Utils.deserialize(user, WorkerTokenInfo.class);
        return deser.get_userName();
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.disconnect();
        }
    }
}

