/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.constraints;

import java.util.Map;
import java.util.Objects;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.constraints.BaseConstraint;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.filter.Predicate;

@Evolving
public class Check
extends BaseConstraint {
    private final String predicateSql;
    private final Predicate predicate;

    private Check(String name, String predicateSql, Predicate predicate, boolean enforced, Constraint.ValidationStatus validationStatus, boolean rely) {
        super(name, enforced, validationStatus, rely);
        this.predicateSql = predicateSql;
        this.predicate = predicate;
    }

    public String predicateSql() {
        return this.predicateSql;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    @Override
    protected String definition() {
        return String.format("CHECK (%s)", this.predicateSql != null ? this.predicateSql : this.predicate);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Check that = (Check)other;
        return Objects.equals(this.name(), that.name()) && Objects.equals(this.predicateSql, that.predicateSql) && Objects.equals(this.predicate, that.predicate) && this.enforced() == that.enforced() && Objects.equals((Object)this.validationStatus(), (Object)that.validationStatus()) && this.rely() == that.rely();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name(), this.predicateSql, this.predicate, this.enforced(), this.validationStatus(), this.rely()});
    }

    public static class Builder
    extends BaseConstraint.Builder<Builder, Check> {
        private String predicateSql;
        private Predicate predicate;

        Builder(String name) {
            super(name);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder predicateSql(String predicateSql) {
            this.predicateSql = predicateSql;
            return this;
        }

        public Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public Check build() {
            if (this.predicateSql == null && this.predicate == null) {
                throw new SparkIllegalArgumentException("INTERNAL_ERROR", Map.of("message", "Predicate SQL and expression can't be both null in CHECK"));
            }
            return new Check(this.name(), this.predicateSql, this.predicate, this.enforced(), this.validationStatus(), this.rely());
        }
    }
}

