/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.DefaultValue;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;

@Evolving
public class ColumnDefaultValue
extends DefaultValue {
    private final Literal<?> value;

    public ColumnDefaultValue(String sql2, Literal<?> value) {
        this(sql2, null, value);
    }

    public ColumnDefaultValue(Expression expr, Literal<?> value) {
        this(null, expr, value);
    }

    public ColumnDefaultValue(String sql2, Expression expr, Literal<?> value) {
        super(sql2, expr);
        this.value = value;
    }

    @Nonnull
    public Literal<?> getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefaultValue)) {
            return false;
        }
        ColumnDefaultValue that = (ColumnDefaultValue)o;
        return Objects.equals(this.getSql(), that.getSql()) && Objects.equals(this.getExpression(), that.getExpression()) && this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSql(), this.getExpression(), this.value);
    }

    @Override
    public String toString() {
        return String.format("ColumnDefaultValue{sql=%s, expression=%s, value=%s}", this.getSql(), this.getExpression(), this.value);
    }
}

