/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeArrayWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.package$ExpressionCanonicalizer$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GenerateUnsafeProjection$
extends CodeGenerator<Seq<Expression>, UnsafeProjection> {
    public static final GenerateUnsafeProjection$ MODULE$ = new GenerateUnsafeProjection$();

    public boolean canSupport(DataType dataType) {
        ArrayType arrayType;
        DataType dataType2 = UserDefinedType$.MODULE$.sqlType(dataType);
        if (NullType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof CalendarIntervalType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.MODULE$.canSupport(field.dataType())));
        }
        if (dataType2 instanceof ArrayType && this.canSupport((arrayType = (ArrayType)dataType2).elementType())) {
            return true;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            if (this.canSupport(kt) && this.canSupport(vt)) {
                return true;
            }
        }
        return false;
    }

    private String writeStructToBuffer(CodegenContext ctx, String input, String index, Seq<GenerateUnsafeProjection.Schema> schemas, String rowWriter) {
        String tmpInput = ctx.freshName("tmpInput");
        Seq fieldEvals = (Seq)((IterableOps)schemas.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GenerateUnsafeProjection.Schema schema = (GenerateUnsafeProjection.Schema)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (schema != null) {
                    DataType dt = schema.dataType();
                    boolean nullable = schema.nullable();
                    FalseLiteral$ isNull = nullable ? JavaCode$.MODULE$.isNullExpression(tmpInput + ".isNullAt(" + i + ")") : FalseLiteral$.MODULE$;
                    return ExprCode$.MODULE$.apply(isNull, JavaCode$.MODULE$.expression(CodeGenerator$.MODULE$.getValue(tmpInput, dt, Integer.toString(i)), dt));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        String rowWriterClass = UnsafeRowWriter.class.getName();
        String structRowWriter = ctx.addMutableState(rowWriterClass, "rowWriter", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + rowWriterClass + "(" + rowWriter + ", " + fieldEvals.length() + ");", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String previousCursor = ctx.freshName("previousCursor");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final InternalRow " + tmpInput + " = " + input + ";\n       |if (" + tmpInput + " instanceof UnsafeRow) {\n       |  " + rowWriter + ".write(" + index + ", (UnsafeRow) " + tmpInput + ");\n       |} else {\n       |  // Remember the current cursor so that we can calculate how many bytes are\n       |  // written later.\n       |  final int " + previousCursor + " = " + rowWriter + ".cursor();\n       |  " + this.writeExpressionsToBuffer(ctx, tmpInput, (Seq<ExprCode>)fieldEvals, schemas, structRowWriter, this.writeExpressionsToBuffer$default$6()) + "\n       |  " + rowWriter + ".setOffsetAndSizeFromPreviousCursor(" + index + ", " + previousCursor + ");\n       |}\n     "));
    }

    private String writeExpressionsToBuffer(CodegenContext ctx, String row, Seq<ExprCode> inputs, Seq<GenerateUnsafeProjection.Schema> schemas, String rowWriter, boolean isTopLevel) {
        String string;
        String resetWriter = isTopLevel ? (((IterableOnceOps)inputs.map((Function1 & Serializable)x$1 -> x$1.isNull())).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.$anonfun$writeExpressionsToBuffer$2(x$2))) ? "" : rowWriter + ".zeroOutNullBytes();") : rowWriter + ".resetRowWriter();";
        Seq writeFields = (Seq)((IterableOps)((IterableOps)inputs.zip(schemas)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    ExprCode input = (ExprCode)tuple22._1();
                    GenerateUnsafeProjection.Schema schema = (GenerateUnsafeProjection.Schema)tuple22._2();
                    if (schema != null) {
                        DecimalType decimalType;
                        DataType dataType = schema.dataType();
                        boolean nullable = schema.nullable();
                        DataType dt = UserDefinedType$.MODULE$.sqlType(dataType);
                        DataType dataType2 = dt;
                        String setNull = dataType2 instanceof DecimalType && (decimalType = (DecimalType)dataType2).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS() ? rowWriter + ".write(" + index + ", (Decimal) null, " + decimalType.precision() + ", " + decimalType.scale() + ");" : (CalendarIntervalType$.MODULE$.equals(dataType2) ? rowWriter + ".write(" + index + ", (CalendarInterval) null);" : rowWriter + ".setNullAt(" + index + ");");
                        String writeField = MODULE$.writeElement(ctx, ExprValue$.MODULE$.exprValueToString(input.value()), Integer.toString(index), dt, rowWriter);
                        if (!nullable) {
                            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + input.code() + "\n             |" + writeField.trim() + "\n           "));
                        }
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + input.code() + "\n             |if (" + input.isNull() + ") {\n             |  " + setNull.trim() + "\n             |} else {\n             |  " + writeField.trim() + "\n             |}\n           "));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (isTopLevel && (row == null || ctx.currentVars() != null)) {
            string = writeFields.mkString("\n");
        } else {
            Predef$.MODULE$.assert(row != null, (Function0 & Serializable)() -> "the input row name cannot be null when generating code to write it.");
            string = ctx.splitExpressions((Seq<String>)writeFields, "writeFields", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"InternalRow"), (Object)row), (List)Nil$.MODULE$), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        }
        String writeFieldsCode = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + resetWriter + "\n       |" + writeFieldsCode + "\n     "));
    }

    private boolean writeExpressionsToBuffer$default$6() {
        return false;
    }

    private String writeArrayToBuffer(CodegenContext ctx, String input, DataType elementType, boolean containsNull, String rowWriter) {
        DecimalType decimalType;
        String tmpInput = ctx.freshName("tmpInput");
        String numElements = ctx.freshName("numElements");
        String index = ctx.freshName("index");
        DataType et = UserDefinedType$.MODULE$.sqlType(elementType);
        String jt = CodeGenerator$.MODULE$.javaType(et);
        DataType dataType = et;
        int elementOrOffsetSize = dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS() ? 8 : (CodeGenerator$.MODULE$.isPrimitiveType(jt) ? et.defaultSize() : 8);
        String arrayWriterClass = UnsafeArrayWriter.class.getName();
        String arrayWriter = ctx.addMutableState(arrayWriterClass, "arrayWriter", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + arrayWriterClass + "(" + rowWriter + ", " + elementOrOffsetSize + ");", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String element = CodeGenerator$.MODULE$.getValue(tmpInput, et, index);
        String elementAssignment = containsNull ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + tmpInput + ".isNullAt(" + index + ")) {\n         |  " + arrayWriter + ".setNull" + elementOrOffsetSize + "Bytes(" + index + ");\n         |} else {\n         |  " + this.writeElement(ctx, element, index, et, arrayWriter) + "\n         |}\n       ")) : this.writeElement(ctx, element, index, et, arrayWriter);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final ArrayData " + tmpInput + " = " + input + ";\n       |if (" + tmpInput + " instanceof UnsafeArrayData) {\n       |  " + rowWriter + ".write((UnsafeArrayData) " + tmpInput + ");\n       |} else {\n       |  final int " + numElements + " = " + tmpInput + ".numElements();\n       |  " + arrayWriter + ".initialize(" + numElements + ");\n       |\n       |  for (int " + index + " = 0; " + index + " < " + numElements + "; " + index + "++) {\n       |    " + elementAssignment + "\n       |  }\n       |}\n     "));
    }

    private String writeMapToBuffer(CodegenContext ctx, String input, String index, DataType keyType, DataType valueType, boolean valueContainsNull, String rowWriter) {
        String tmpInput = ctx.freshName("tmpInput");
        String tmpCursor = ctx.freshName("tmpCursor");
        String previousCursor = ctx.freshName("previousCursor");
        String keyArray = this.writeArrayToBuffer(ctx, tmpInput + ".keyArray()", keyType, false, rowWriter);
        String valueArray = this.writeArrayToBuffer(ctx, tmpInput + ".valueArray()", valueType, valueContainsNull, rowWriter);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final MapData " + tmpInput + " = " + input + ";\n       |if (" + tmpInput + " instanceof UnsafeMapData) {\n       |  " + rowWriter + ".write(" + index + ", (UnsafeMapData) " + tmpInput + ");\n       |} else {\n       |  // Remember the current cursor so that we can calculate how many bytes are\n       |  // written later.\n       |  final int " + previousCursor + " = " + rowWriter + ".cursor();\n       |\n       |  // preserve 8 bytes to write the key array numBytes later.\n       |  " + rowWriter + ".grow(8);\n       |  " + rowWriter + ".increaseCursor(8);\n       |\n       |  // Remember the current cursor so that we can write numBytes of key array later.\n       |  final int " + tmpCursor + " = " + rowWriter + ".cursor();\n       |\n       |  " + keyArray + "\n       |\n       |  // Write the numBytes of key array into the first 8 bytes.\n       |  Platform.putLong(\n       |    " + rowWriter + ".getBuffer(),\n       |    " + tmpCursor + " - 8,\n       |    " + rowWriter + ".cursor() - " + tmpCursor + ");\n       |\n       |  " + valueArray + "\n       |  " + rowWriter + ".setOffsetAndSizeFromPreviousCursor(" + index + ", " + previousCursor + ");\n       |}\n     "));
    }

    private String writeElement(CodegenContext ctx, String input, String index, DataType dt, String writer) {
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.writeStructToBuffer(ctx, input, index, (Seq<GenerateUnsafeProjection.Schema>)((Seq)structType.map((Function1 & Serializable)e -> new GenerateUnsafeProjection.Schema(e.dataType(), e.nullable()))), writer);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean en = arrayType.containsNull();
            String previousCursor = ctx.freshName("previousCursor");
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |// Remember the current cursor so that we can calculate how many bytes are\n         |// written later.\n         |final int " + previousCursor + " = " + writer + ".cursor();\n         |" + this.writeArrayToBuffer(ctx, input, et, en, writer) + "\n         |" + writer + ".setOffsetAndSizeFromPreviousCursor(" + index + ", " + previousCursor + ");\n       "));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean vn = mapType.valueContainsNull();
            return this.writeMapToBuffer(ctx, input, index, kt, vt, vn, writer);
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return writer + ".write(" + index + ", " + input + ", " + precision + ", " + scale + ");";
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return "";
        }
        return writer + ".write(" + index + ", " + input + ");";
    }

    public ExprCode createCode(CodegenContext ctx, Seq<Expression> expressions, boolean useSubexprElimination) {
        Seq<ExprCode> exprEvals = ctx.generateExpressions(expressions, useSubexprElimination);
        Seq exprSchemas = (Seq)expressions.map((Function1 & Serializable)e -> new GenerateUnsafeProjection.Schema(e.dataType(), e.nullable()));
        int numVarLenFields = exprSchemas.count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.$anonfun$createCode$2(x0$1)));
        String rowWriterClass = UnsafeRowWriter.class.getName();
        String rowWriter = ctx.addMutableState(rowWriterClass, "rowWriter", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + rowWriterClass + "(" + expressions.length() + ", " + numVarLenFields * 32 + ");", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String evalSubexpr = ctx.subexprFunctionsCode();
        String writeExpressions = this.writeExpressionsToBuffer(ctx, ctx.INPUT_ROW(), exprEvals, (Seq<GenerateUnsafeProjection.Schema>)exprSchemas, rowWriter, true);
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", "\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{rowWriter, evalSubexpr, writeExpressions})).stripMargin();
        return new ExprCode(code, FalseLiteral$.MODULE$, JavaCode$.MODULE$.expression(rowWriter + ".getRow()", UnsafeRow.class));
    }

    @Override
    public Seq<Expression> canonicalize(Seq<Expression> in) {
        return (Seq)in.map((Function1 & Serializable)plan2 -> package$ExpressionCanonicalizer$.MODULE$.execute(plan2));
    }

    @Override
    public Seq<Expression> bind(Seq<Expression> in, Seq<Attribute> inputSchema) {
        return BindReferences$.MODULE$.bindReferences(in, package$.MODULE$.AttributeSeq(inputSchema));
    }

    public UnsafeProjection generate(Seq<Expression> expressions, boolean subexpressionEliminationEnabled) {
        return this.create(this.canonicalize(expressions), subexpressionEliminationEnabled);
    }

    @Override
    public UnsafeProjection create(Seq<Expression> references2) {
        return this.create(references2, false);
    }

    private UnsafeProjection create(Seq<Expression> expressions, boolean subexpressionEliminationEnabled) {
        CodegenContext ctx = this.newCodeGenContext();
        ExprCode eval = this.createCode(ctx, expressions, subexpressionEliminationEnabled);
        String codeBody = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |public java.lang.Object generate(Object[] references) {\n         |  return new SpecificUnsafeProjection(references);\n         |}\n         |\n         |class SpecificUnsafeProjection extends " + UnsafeProjection.class.getName() + " {\n         |\n         |  private Object[] references;\n         |  " + ctx.declareMutableStates() + "\n         |\n         |  public SpecificUnsafeProjection(Object[] references) {\n         |    this.references = references;\n         |    " + ctx.initMutableStates() + "\n         |  }\n         |\n         |  public void initialize(int partitionIndex) {\n         |    " + ctx.initPartition() + "\n         |  }\n         |\n         |  // Scala.Function1 need this\n         |  public java.lang.Object apply(java.lang.Object row) {\n         |    return apply((InternalRow) row);\n         |  }\n         |\n         |  public UnsafeRow apply(InternalRow " + ctx.INPUT_ROW() + ") {\n         |    " + eval.code() + "\n         |    return " + eval.value() + ";\n         |  }\n         |\n         |  " + ctx.declareAddedFunctions() + "\n         |}\n       "));
        CodeAndComment code = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(codeBody, ctx.getPlaceHolderToComments()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "code for " + expressions.mkString(",") + ":\n" + CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2()));
        Tuple2<GeneratedClass, ByteCodeStats> tuple2 = CodeGenerator$.MODULE$.compile(code);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratedClass clazz = (GeneratedClass)tuple2._1();
        GeneratedClass clazz2 = clazz;
        return (UnsafeProjection)clazz2.generate((Object[])ctx.references().toArray(ClassTag$.MODULE$.Any()));
    }

    public boolean createCode$default$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$writeExpressionsToBuffer$2(ExprValue x$2) {
        ExprValue exprValue = x$2;
        FalseLiteral$ falseLiteral$ = FalseLiteral$.MODULE$;
        return !(exprValue != null ? !exprValue.equals(falseLiteral$) : falseLiteral$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$createCode$2(GenerateUnsafeProjection.Schema x0$1) {
        GenerateUnsafeProjection.Schema schema = x0$1;
        if (schema != null) {
            DataType dt = schema.dataType();
            return !UnsafeRow.isFixedLength(dt);
        }
        throw new MatchError((Object)schema);
    }

    private GenerateUnsafeProjection$() {
    }
}

