/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToCharacterBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(expr, format) - Convert `expr` to a string based on the `format`.\n      Throws an exception if the conversion fails. The format can consist of the following\n      characters, case insensitive:\n        '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n          string matches a sequence of digits in the input value, generating a result string of the\n          same length as the corresponding sequence in the format string. The result string is\n          left-padded with zeros if the 0/9 sequence comprises more digits than the matching part of\n          the decimal value, starts with 0, and is before the decimal point. Otherwise, it is\n          padded with spaces.\n        '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n        ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n          a 0 or 9 to the left and right of each grouping separator.\n        '$': Specifies the location of the $ currency sign. This character may only be specified\n          once.\n        'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n          the beginning or end of the format string). Note that 'S' prints '+' for positive values\n          but 'MI' prints a space.\n        'PR': Only allowed at the end of the format string; specifies that the result string will be\n          wrapped by angle brackets if the input value is negative.\n          ('<1>').\n      If `expr` is a datetime, `format` shall be a valid datetime pattern, see <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>.\n      If `expr` is a binary, it is converted to a string in one of the formats:\n        'base64': a base 64 string.\n        'hex': a string in the hexadecimal format.\n        'utf-8': the input binary is decoded to UTF-8 string.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(454, '999');\n       454\n      > SELECT _FUNC_(454.00, '000D00');\n       454.00\n      > SELECT _FUNC_(12454, '99G999');\n       12,454\n      > SELECT _FUNC_(78.12, '$99.99');\n       $78.12\n      > SELECT _FUNC_(-12454.8, '99G999D9S');\n       12,454.8-\n      > SELECT _FUNC_(date'2016-04-08', 'y');\n       2016\n      > SELECT _FUNC_(x'537061726b2053514c', 'base64');\n       U3BhcmsgU1FM\n      > SELECT _FUNC_(x'537061726b2053514c', 'hex');\n       537061726B2053514C\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005E;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n!\u0003V8DQ\u0006\u0014\u0018m\u0019;fe\n+\u0018\u000e\u001c3fe*\u0011aaB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\t\u0013\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0014\u00035\tQA\u0001\nU_\u000eC\u0017M]1di\u0016\u0014()^5mI\u0016\u00148cA\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0011\u000e\u0003yQ!aH\u0004\u0002\u0011\u0005t\u0017\r\\=tSNL!!\t\u0010\u0003#\u0015C\bO]3tg&|gNQ;jY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002%\u0005)!-^5mIR\u0019a%\u000b\u001c\u0011\u0005M9\u0013B\u0001\u0015\u0006\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006U\r\u0001\raK\u0001\tMVt7MT1nKB\u0011Af\r\b\u0003[E\u0002\"A\f\r\u000e\u0003=R!\u0001M\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u0019\u0011\u001511\u00011\u00018!\rATH\n\b\u0003smr!A\f\u001e\n\u0003eI!\u0001\u0010\r\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u0004'\u0016\f(B\u0001\u001f\u0019Q)\t\u0011\tR#H\u0011*[UJ\u0014\t\u0003'\tK!aQ\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\na)AH\f\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003EZ8s[\u0006$\u0018\u0006I\u0017!\u0007>tg/\u001a:uA\u0001,\u0007\u0010\u001d:aAQ|\u0007%\u0019\u0011tiJLgn\u001a\u0011cCN,G\rI8oAQDW\r\t1g_Jl\u0017\r\u001e1/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\"\u0014xn^:!C:\u0004S\r_2faRLwN\u001c\u0011jM\u0002\"\b.\u001a\u0011d_:4XM]:j_:\u0004c-Y5mg:\u0002C\u000b[3!M>\u0014X.\u0019;!G\u0006t\u0007eY8og&\u001cH\u000fI8gAQDW\r\t4pY2|w/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!G\"\f'/Y2uKJ\u001cH\u0006I2bg\u0016\u0004\u0013N\\:f]NLG/\u001b<fu)\u0001\u0003\u0005\t\u0011!A\u0001\u0002s\u0005M\u0014!_J\u0004s%O\u0014;AM\u0003XmY5gS\u0016\u001c\b%\u00198!Kb\u0004Xm\u0019;fI\u0002\"\u0017nZ5uA\t,Go^3f]\u0002\u0002\u0004%\u00198eAer\u0003%\u0011\u0011tKF,XM\\2fA=4\u0007\u0005\r\u0011pe\u0002J\u0004%\u001b8!i\",\u0007EZ8s[\u0006$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!gR\u0014\u0018N\\4![\u0006$8\r[3tA\u0005\u00043/Z9vK:\u001cW\rI8gA\u0011Lw-\u001b;tA%t\u0007\u0005\u001e5fA%t\u0007/\u001e;!m\u0006dW/\u001a\u0017!O\u0016tWM]1uS:<\u0007%\u0019\u0011sKN,H\u000e\u001e\u0011tiJLgn\u001a\u0011pM\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0018-\\3!Y\u0016tw\r\u001e5!CN\u0004C\u000f[3!G>\u0014(/Z:q_:$\u0017N\\4!g\u0016\fX/\u001a8dK\u0002Jg\u000e\t;iK\u00022wN]7bi\u0002\u001aHO]5oO:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!gR\u0014\u0018N\\4!SNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011mK\u001a$X\u0006]1eI\u0016$\u0007e^5uQ\u0002RXM]8tA%4\u0007\u0005\u001e5fAAz\u0013\bI:fcV,gnY3!G>l\u0007O]5tKN\u0004Sn\u001c:fA\u0011Lw-\u001b;tAQD\u0017M\u001c\u0011uQ\u0016\u0004S.\u0019;dQ&tw\r\t9beR\u0004sN\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011eK\u000eLW.\u00197!m\u0006dW/\u001a\u0017!gR\f'\u000f^:!o&$\b\u000e\t\u0019-A\u0005tG\rI5tA\t,gm\u001c:fAQDW\r\t3fG&l\u0017\r\u001c\u0011q_&tGO\f\u0011Pi\",'o^5tK2\u0002\u0013\u000e\u001e\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t9bI\u0012,G\rI<ji\"\u00043\u000f]1dKNt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0014/O\u0001z'\u000fI\u0014EOi\u00023\u000b]3dS\u001aLWm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI8gAQDW\r\t3fG&l\u0017\r\u001c\u0011q_&tG\u000f\t\u0015paRLwN\\1mY\u0001zg\u000e\\=!C2dwn^3eA=t7-Z\u0015/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001:Cf\n\u0011pe\u0002:si\n\u001e!'B,7-\u001b4jKN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002zg\r\t;iK\u0002:'o\\;qS:<\u0007\u0005\u000b;i_V\u001c\u0018M\u001c3tS\u0001\u001aX\r]1sCR|'\u000f\t\u0015-S9\u0002C\u000b[3sK\u0002jWo\u001d;!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011bAA\u0002sN\u001d\u0011:AQ|\u0007\u0005\u001e5fA1,g\r\u001e\u0011b]\u0012\u0004#/[4ii\u0002zg\rI3bG\"\u0004sM]8va&tw\rI:fa\u0006\u0014\u0018\r^8s])\u0001\u0003\u0005\t\u0011!A\u0001\u0002s\u0005J\u0014;AM\u0003XmY5gS\u0016\u001c\b\u0005\u001e5fA1|7-\u0019;j_:\u0004sN\u001a\u0011uQ\u0016\u0004C\u0005I2veJ,gnY=!g&<gN\f\u0011UQ&\u001c\be\u00195be\u0006\u001cG/\u001a:![\u0006L\be\u001c8ms\u0002\u0012W\rI:qK\u000eLg-[3e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u001c8dK:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003eJ*(A=\u0014\beJ'JOi\u00023\u000b]3dS\u001aLWm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI8gA\u0005\u0004s%L\u0014!_J\u0004seK\u0014!g&<g\u000e\t\u0015paRLwN\\1mY\u0001zg\u000e\\=!C2dwn^3eA=t7-\u001a\u0011bi*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u0012WmZ5o]&tw\rI8sA\u0015tG\rI8gAQDW\r\t4pe6\fG\u000fI:ue&tw-\u000b\u0018!\u001d>$X\r\t;iCR\u0004seU\u0014!aJLg\u000e^:!O-:\u0003EZ8sAA|7/\u001b;jm\u0016\u0004c/\u00197vKNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011ckR\u0004s%T%(AA\u0014\u0018N\u001c;tA\u0005\u00043\u000f]1dK:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003e\n)SOi\u0002sJ\u001c7zA\u0005dGn\\<fI\u0002\nG\u000f\t;iK\u0002*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011tiJLgnZ\u001e!gB,7-\u001b4jKN\u0004C\u000f[1uAQDW\r\t:fgVdG\u000fI:ue&tw\rI<jY2\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001:(/\u00199qK\u0012\u0004#-\u001f\u0011b]\u001edW\r\t2sC\u000e\\W\r^:!S\u001a\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011wC2,X\rI5tA9,w-\u0019;jm\u0016t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!Q\u001db\u0014GP\u0014*])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y3yaJ\u0004\u0007%[:!C\u0002\"\u0017\r^3uS6,G\u0006\t1g_Jl\u0017\r\u001e1!g\"\fG\u000e\u001c\u0011cK\u0002\n\u0007E^1mS\u0012\u0004C-\u0019;fi&lW\r\t9biR,'O\u001c\u0017!g\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ngH\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001,\u0007\u0010\u001d:aA%\u001c\b%\u0019\u0011cS:\f'/\u001f\u0017!SR\u0004\u0013n\u001d\u0011d_:4XM\u001d;fI\u0002\"x\u000eI1!gR\u0014\u0018N\\4!S:\u0004sN\\3!_\u001a\u0004C\u000f[3!M>\u0014X.\u0019;tu)\u0001\u0003\u0005\t\u0011!A\u0001\u0002sEY1tKZ\"tE\u000f\u0011bA\t\f7/\u001a\u00117i\u0001\u001aHO]5oO:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003e\n5fq\u001eR\u0004%\u0019\u0011tiJLgn\u001a\u0011j]\u0002\"\b.\u001a\u0011iKb\fG-Z2j[\u0006d\u0007EZ8s[\u0006$hF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011(kR4W\u0006O\u0014;AQDW\rI5oaV$\bEY5oCJL\b%[:!I\u0016\u001cw\u000eZ3eAQ|\u0007%\u0016+G[a\u00023\u000f\u001e:j]\u001et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013!S\u0001\u0005t)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CC'\u000e\u001b-A\u001dJ\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"T\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)iU\"d\u0006\r\u0019-A\u001d\u0002\u0004\u0007\r#1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b6i9\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eQ*D\u0007\f\u0011(se:\u0015(O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\r\u00175kQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\u000e\u001d/cIb\u0003e\n\u0013:s9J\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0011:\u0004HL\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0013G\r\u001b6i9BD\u0006I\u0014:s\u001dK\u0014(\u000f#:'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193YQ*DG\f\u001d.\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"\u0017\r^3(eA\nd'\f\u00195[ABt\u0005\f\u0011(s\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006_\u00146g]\u0002d'M\u001c3m\t\u0014\u0004'N\u001a6cQ\u001aw\u0005\f\u0011(E\u0006\u001cXM\u000e\u001b(SmR\u0001\u0005\t\u0011!A\u0001\u0002Sk\r\"iG6\u001cx-V\u0019G\u001b*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003pJ\u001b4oA2\u0014g\u000e\u001a7EJ\u0002TgM\u001b2i\r<C\u0006I\u0014iKb<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116g]\u0002d'M\u001c3m\t\u0013\u0004'N\u001a6cQ\u001a%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3oG>$W\rK\u0014bE\u000e<C\u0006I\u0014vi\u001al\u0003hJ\u0015-A\u001d*HOZ\u00179O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192d\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017%\u0001'\u0002\u000bMrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0003=\u000bAb\u001d;sS:<wLZ;oGND#\u0002A!E\u000b\u001eC%jS'O\u0001")
public final class ToCharacterBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return ToCharacterBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return ToCharacterBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return ToCharacterBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName);
    }

    public static Option<FunctionSignature> functionSignature() {
        return ToCharacterBuilder$.MODULE$.functionSignature();
    }
}

