/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Minute;
import org.apache.spark.sql.catalyst.expressions.Minute$;
import org.apache.spark.sql.catalyst.expressions.MinutesOfTime;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimeType;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the minute component of the given expression.\n\n    If `expr` is a TIMESTAMP or a string that can be cast to timestamp,\n    it returns the minute of that timestamp.\n    If `expr` is a TIME type (since 4.1.0), it returns the minute of the time-of-day.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       58\n      > SELECT _FUNC_(TIME'23:59:59.999999');\n       59\n  ", since="1.5.0", group="datetime_funcs")
public final class MinuteExpressionBuilder$
implements ExpressionBuilder {
    public static final MinuteExpressionBuilder$ MODULE$ = new MinuteExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String name, Seq<Expression> expressions) {
        if (expressions.isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(name, (Seq<Object>)new .colon.colon((Object)"> 0", (List)Nil$.MODULE$), expressions.length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Expression child = (Expression)expressions.head();
        DataType dataType = child.dataType();
        if (dataType instanceof TimeType) {
            return new MinutesOfTime(child);
        }
        return new Minute(child, Minute$.MODULE$.apply$default$2());
    }

    private MinuteExpressionBuilder$() {
    }
}

