/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000f\u001f\u0001-BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004O\u0001\u0001\u0006IA\u0010\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019\u0001\u0007\u0001)A\u0005#\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00027\u0001A\u0003%1\rC\u0003n\u0001\u0011%a\u000e\u0003\u0005\u0002\b\u0001!\t\u0001IA\u0005\u0011!\t9\u0002\u0001C\u0001A\u0005e\u0001\u0002CA\u0010\u0001\u0011\u0005\u0001%!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002\"CA%\u0001E\u0005I\u0011BA&\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GB\u0011\"a\u001b\u0001#\u0003%I!a\u0013\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!I\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\t\u0003o\u0002A\u0011\u0001\u0011\u0002z!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAI\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011BA=\u0011!\t)\n\u0001C\u0001A\u0005]\u0005bBAK\u0001\u0011%\u00111\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\tY\f\u0001C\u0005\u0003{C\u0001\"!1\u0001\t\u0003\u0001\u0013\u0011\u0010\u0005\t\u0003\u0007\u0004A\u0011\u0001\u0011\u0002F\nQ2\u000b]1sW\u000e{gN\\3diN+7o]5p]6\u000bg.Y4fe*\u0011q\u0004I\u0001\bg\u0016\u0014h/[2f\u0015\t\t#%A\u0004d_:tWm\u0019;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a#\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0011\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002uA\u00111\bA\u0007\u0002=\u0005a1/Z:tS>t7\u000b^8sKV\ta\b\u0005\u0003@\r\"[U\"\u0001!\u000b\u0005\u0005\u0013\u0015AC2p]\u000e,(O]3oi*\u00111\tR\u0001\u0005kRLGNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0003%!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002<\u0013&\u0011!J\b\u0002\u000b'\u0016\u001c8/[8o\u0017\u0016L\bCA\u001eM\u0013\tieDA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u000eg\u0016\u001c8/[8o'R|'/\u001a\u0011\u0002'\rdwn]3e'\u0016\u001c8/[8og\u000e\u000b7\r[3\u0016\u0003E\u0003BAU.I;6\t1K\u0003\u0002U+\u0006)1-Y2iK*\u0011akV\u0001\u0007G>lWn\u001c8\u000b\u0005aK\u0016AB4p_\u001edWMC\u0001[\u0003\r\u0019w.\\\u0005\u00039N\u0013QaQ1dQ\u0016\u0004\"a\u000f0\n\u0005}s\"!E*fgNLwN\u001c%pY\u0012,'/\u00138g_\u0006!2\r\\8tK\u0012\u001cVm]:j_:\u001c8)Y2iK\u0002\n\u0011c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s+\u0005\u0019\u0007c\u00013hS6\tQM\u0003\u0002g\u0001\u00061\u0011\r^8nS\u000eL!\u0001[3\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"a\u00106\n\u0005-\u0004%\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006\u00112o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:!\u0003E1\u0018\r\\5eCR,7+Z:tS>t\u0017\n\u001a\u000b\u0006_J$\u00181\u0001\t\u0003[AL!!\u001d\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\"\u0001\r\u0001S\u0001\u0004W\u0016L\b\"B;\t\u0001\u00041\u0018aC:fgNLwN\\+V\u0013\u0012\u0003\"a\u001e@\u000f\u0005ad\bCA=/\u001b\u0005Q(BA>+\u0003\u0019a$o\\8u}%\u0011QPL\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{:Ba!!\u0002\t\u0001\u00041\u0018a\u00079sKZLw.^:ms>\u00137/\u001a:wK\u0012\u001cVm]:j_:LE-\u0001\u000ehKR|%o\u0011:fCR,\u0017j]8mCR,GmU3tg&|g\u000eF\u0003L\u0003\u0017\ti\u0001C\u0003t\u0013\u0001\u0007\u0001\nC\u0004\u0002\u0010%\u0001\r!!\u0005\u00029A\u0014XM^5pkNd\u0017p\u00142tKJ4X\rZ*fgN\u001c\u0018n\u001c8JIB!Q&a\u0005w\u0013\r\t)B\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002%\u001d,G/S:pY\u0006$X\rZ*fgNLwN\u001c\u000b\u0006\u0017\u0006m\u0011Q\u0004\u0005\u0006g*\u0001\r\u0001\u0013\u0005\b\u0003\u001fQ\u0001\u0019AA\t\u0003m9W\r^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8JMB\u0013Xm]3oiR!\u00111EA\u0013!\u0011i\u00131C&\t\u000bM\\\u0001\u0019\u0001%\u0002\u0015\u001d,GoU3tg&|g\u000eF\u0003L\u0003W\ti\u0003C\u0003t\u0019\u0001\u0007\u0001\nC\u0004\u000201\u0001\r!!\r\u0002\u000f\u0011,g-Y;miB)Q&a\u0005\u00024A!Q&!\u000eL\u0013\r\t9D\f\u0002\n\rVt7\r^5p]B\n1C]3n_Z,7+Z:tS>t\u0007j\u001c7eKJ$b!a\t\u0002>\u0005}\u0002\"B:\u000e\u0001\u0004A\u0005\"CA!\u001bA\u0005\t\u0019AA\"\u00039\tG\u000e\\8x%\u0016\u001cwN\u001c8fGR\u00042!LA#\u0013\r\t9E\f\u0002\b\u0005>|G.Z1o\u0003u\u0011X-\\8wKN+7o]5p]\"{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012TCAA'U\u0011\t\u0019%a\u0014,\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0017/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\n)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u001d5vi\u0012|wO\\*fgNLwN\u001c%pY\u0012,'\u000fF\u0003p\u0003K\nI\u0007\u0003\u0004\u0002h=\u0001\raS\u0001\u000eg\u0016\u001c8/[8o\u0011>dG-\u001a:\t\u0013\u0005\u0005s\u0002%AA\u0002\u0005\r\u0013aH:ikR$wn\u001e8TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005a1\r\\8tKN+7o]5p]R)q.!\u001d\u0002t!)1/\u0005a\u0001\u0011\"I\u0011\u0011I\t\u0011\u0002\u0003\u0007\u00111I\u0001\u0017G2|7/Z*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005A1\u000f[;uI><h\u000eF\u0001p\u0003Ia\u0017n\u001d;BGRLg/Z*fgNLwN\\:\u0016\u0005\u0005}\u0004#BAA\u0003\u0017kf\u0002BAB\u0003\u000fs1!_AC\u0013\u0005y\u0013bAAE]\u00059\u0001/Y2lC\u001e,\u0017\u0002BAG\u0003\u001f\u00131aU3r\u0015\r\tIIL\u0001\u0013Y&\u001cHo\u00117pg\u0016$7+Z:tS>t7/\u0001\ftG\",G-\u001e7f!\u0016\u0014\u0018n\u001c3jG\u000eCWmY6t\u0003M\u0001XM]5pI&\u001cW*Y5oi\u0016t\u0017M\\2f)\ry\u0017\u0011\u0014\u0005\b\u00037;\u0002\u0019AAO\u0003a!WMZ1vYRLe.Y2uSZ,G+[7f_V$Xj\u001d\t\u0004[\u0005}\u0015bAAQ]\t!Aj\u001c8h)\u0015y\u0017QUAT\u0011\u001d\tY\n\u0007a\u0001\u0003;Cq!!+\u0019\u0001\u0004\t\u0019%A\njO:|'/Z\"vgR|W\u000eV5nK>,H/\u0001\noK^L5o\u001c7bi\u0016$7+Z:tS>tGCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[E\u000591\r\\1tg&\u001c\u0017\u0002BA]\u0003g\u0013Ab\u00159be.\u001cVm]:j_:\fQC^1mS\u0012\fG/Z*fgNLwN\\\"sK\u0006$X\rF\u0002p\u0003\u007fCQa\u001d\u000eA\u0002!\u000bQ#\u001b8wC2LG-\u0019;f\u00032d7+Z:tS>t7/\u0001\u000bqkR\u001cVm]:j_:4uN\u001d+fgRLgn\u001a\u000b\u0004_\u0006\u001d\u0007BBA49\u0001\u00071\n")
public class SparkConnectSessionManager
implements Logging {
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent(key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key, boolean allowReconnect) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s2 -> {
            block0: {
                if (allowReconnect) break block0;
                this.closedSessionsCache().put(s2.key(), s2.getSessionHolderInfo());
            }
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private boolean removeSessionHolder$default$2() {
        return false;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder, boolean allowReconnect) {
        sessionHolder.close();
        if (!allowReconnect) {
            this.closedSessionsCache().put(sessionHolder.key(), sessionHolder.getSessionHolderInfo());
            return;
        }
    }

    public void closeSession(SessionKey key, boolean allowReconnect) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key, allowReconnect);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2, allowReconnect);
            return BoxedUnit.UNIT;
        });
    }

    public boolean closeSession$default$2() {
        return false;
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    private boolean shutdownSessionHolder$default$2() {
        return false;
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_HOLD_INFO$.MODULE$, (Object)info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                this.removeSessionHolder(info.key(), this.removeSessionHolder$default$2());
                try {
                    this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
                    }
                    throw throwable;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession active = SparkSession$.MODULE$.active();
        if (active.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return active.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent(key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        this.sessionStore().forEach((key, sessionHolder) -> {
            this.removeSessionHolder((SessionKey)key, this.removeSessionHolder$default$2());
            this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
        });
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = new AtomicReference();
    }
}

