/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.StreamingQueryManagerCommand;
import org.apache.spark.connect.proto.StreamingQueryManagerCommandResult;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.connect.RemoteStreamingQuery$;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.StreamingQuery;
import org.apache.spark.sql.connect.StreamingQueryListenerBus;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0007c\u0001!\ta\u0006\u001a\t\u0011U\u0002\u0001R1A\u0005\nYB\u0001\"\u0015\u0001C\u0002\u0013\u0005\u0011D\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\r]\u0003A\u0011A\rY\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015)\u0007\u0001\"\u0001n\u0011\u0015y\u0007\u0001\"\u0001Y\u0011\u0019y\u0007\u0001\"\u0001\u0002&!1\u00111\t\u0001\u0005\u0002aCq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u0013Qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180T1oC\u001e,'O\u0003\u0002\u0017/\u000591m\u001c8oK\u000e$(B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"MA\u0011!%J\u0007\u0002G)\u0011AeF\u0001\ngR\u0014X-Y7j]\u001eL!\u0001F\u0012\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%J\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005-B#a\u0002'pO\u001eLgnZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003]=j\u0011!F\u0005\u0003aU\u0011Ab\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtDCA\u001a5!\tq\u0003\u0001C\u0003-\u0005\u0001\u0007Q&A\u0007mSN$XM\\3s\u0007\u0006\u001c\u0007.Z\u000b\u0002oA!\u0001hP!O\u001b\u0005I$B\u0001\u001e<\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003yu\nA!\u001e;jY*\ta(\u0001\u0003kCZ\f\u0017B\u0001!:\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011!i\u0013\b\u0003\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005);\u0005C\u0001\u0012P\u0013\t\u00016E\u0001\fTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u0003e\u0019HO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014()^:\u0016\u0003M\u0003\"A\f+\n\u0005U+\"!G*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:CkN\f!d\u001d;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\"vg\u0002\nQa\u00197pg\u0016$\u0012!\u0017\t\u00035nk\u0011aR\u0005\u00039\u001e\u0013A!\u00168ji\u00061\u0011m\u0019;jm\u0016,\u0012a\u0018\t\u00045\u0002\u0014\u0017BA1H\u0005\u0015\t%O]1z!\tq3-\u0003\u0002e+\tq1\u000b\u001e:fC6LgnZ)vKJL\u0018aA4fiR\u0011!m\u001a\u0005\u0006Q\"\u0001\r![\u0001\u0003S\u0012\u0004\"A[6\u000e\u0003mJ!\u0001\\\u001e\u0003\tU+\u0016\n\u0012\u000b\u0003E:DQ\u0001[\u0005A\u0002\u0005\u000b1#Y<bSR\fe.\u001f+fe6Lg.\u0019;j_:D3AC9x!\rQ&\u000f^\u0005\u0003g\u001e\u0013a\u0001\u001e5s_^\u001c\bC\u0001\u0012v\u0013\t18EA\fTiJ,\u0017-\\5oOF+XM]=Fq\u000e,\u0007\u000f^5p]F*a$\u0011=\u0002$E21%_?\u0002\u001ay,\"A_>\u0016\u0003\u0005#a\u0001`\u0010C\u0002\u0005\r!!\u0001+\n\u0005y|\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u0002\u001d\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BA\u0003\u0003\u0017\u00012AWA\u0004\u0013\r\tIa\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\ti!a\u0005\u000f\u0007i\u000by!C\u0002\u0002\u0012\u001d\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!!\u0003+ie><\u0018M\u00197f\u0015\r\t\tbR\u0019\nG\u0005m\u0011QDA\u0010\u0003\u0003q1AWA\u000f\u0013\r\t\taR\u0019\u0006Ei;\u0015\u0011\u0005\u0002\u0006g\u000e\fG.Y\u0019\u0003MQ$B!a\n\u0002.A\u0019!,!\u000b\n\u0007\u0005-rIA\u0004C_>dW-\u00198\t\u000f\u0005=2\u00021\u0001\u00022\u0005IA/[7f_V$Xj\u001d\t\u00045\u0006M\u0012bAA\u001b\u000f\n!Aj\u001c8hQ\u0011Y\u0011/!\u000f2\ry\t\u00151HA!c\u0019\u0019\u00130`A\u001f}FJ1%a\u0007\u0002\u001e\u0005}\u0012\u0011A\u0019\u0006Ei;\u0015\u0011E\u0019\u0003MQ\fqB]3tKR$VM]7j]\u0006$X\rZ\u0001\fC\u0012$G*[:uK:,'\u000fF\u0002Z\u0003\u0013Ba!a\u0013\u000e\u0001\u0004q\u0015\u0001\u00037jgR,g.\u001a:\u0002\u001dI,Wn\u001c<f\u0019&\u001cH/\u001a8feR\u0019\u0011,!\u0015\t\r\u0005-c\u00021\u0001O\u00035a\u0017n\u001d;MSN$XM\\3sgR\u0011\u0011q\u000b\t\u00045\u0002t\u0015!E3yK\u000e,H/Z'b]\u0006<WM]\"nIR!\u0011QLA6!\u0011\ty&a\u001a\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\nQ\u0001\u001d:pi>T!AF\r\n\t\u0005%\u0014\u0011\r\u0002#'R\u0014X-Y7j]\u001e\fV/\u001a:z\u001b\u0006t\u0017mZ3s\u0007>lW.\u00198e%\u0016\u001cX\u000f\u001c;\t\u000f\u00055\u0004\u00031\u0001\u0002p\u0005A1/\u001a;D[\u00124e\u000e\u0005\u0004[\u0003c\n)(W\u0005\u0004\u0003g:%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t9(! \u000f\t\u0005}\u0013\u0011P\u0005\u0005\u0003w\n\t'\u0001\u000fTiJ,\u0017-\\5oOF+XM]=NC:\fw-\u001a:D_6l\u0017M\u001c3\n\t\u0005}\u0014\u0011\u0011\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tY(!\u0019\u0002#\r\f7\r[3MSN$XM\\3s\u0005fLE\rF\u0003Z\u0003\u000f\u000bI\tC\u0003i#\u0001\u0007\u0011\t\u0003\u0004\u0002LE\u0001\rAT\u0001\u0010O\u0016$\u0018\n\u001a\"z\u0019&\u001cH/\u001a8feR\u0019\u0011)a$\t\r\u0005-#\u00031\u0001O\u0003Q\u0011X-\\8wK\u000e\u000b7\r[3e\u0019&\u001cH/\u001a8feR\u0019a*!&\t\u000b!\u001c\u0002\u0019A!)\u0007\u0001\tI\n\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\ty*G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAR\u0003;\u0013\u0001\"\u0012<pYZLgn\u001a")
public class StreamingQueryManager
extends org.apache.spark.sql.streaming.StreamingQueryManager
implements Logging {
    private ConcurrentMap<String, StreamingQueryListener> listenerCache;
    private final SparkSession sparkSession;
    private final StreamingQueryListenerBus streamingQueryListenerBus;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache$lzycompute() {
        StreamingQueryManager streamingQueryManager = this;
        synchronized (streamingQueryManager) {
            if (!this.bitmap$0) {
                this.listenerCache = new ConcurrentHashMap<String, StreamingQueryListener>();
                this.bitmap$0 = true;
            }
        }
        return this.listenerCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache() {
        if (!this.bitmap$0) {
            return this.listenerCache$lzycompute();
        }
        return this.listenerCache;
    }

    public StreamingQueryListenerBus streamingQueryListenerBus() {
        return this.streamingQueryListenerBus;
    }

    public void close() {
        this.streamingQueryListenerBus().close();
    }

    public StreamingQuery[] active() {
        return (StreamingQuery[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            x$1.setActive(true);
            return BoxedUnit.UNIT;
        }).getActive().getActiveQueriesList()).asScala().map((Function1 & Serializable)q -> RemoteStreamingQuery$.MODULE$.fromStreamingQueryInstanceResponse($this.sparkSession, (StreamingQueryManagerCommandResult.StreamingQueryInstance)q))).toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
    }

    public StreamingQuery get(UUID id) {
        return this.get(id.toString());
    }

    public StreamingQuery get(String id) {
        StreamingQueryManagerCommandResult response = this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable)x$2 -> {
            x$2.setGetQuery(id);
            return BoxedUnit.UNIT;
        });
        if (response.hasQuery()) {
            return RemoteStreamingQuery$.MODULE$.fromStreamingQueryInstanceResponse(this.sparkSession, response.getQuery());
        }
        return null;
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable)x$3 -> {
            StreamingQueryManager.$anonfun$awaitAnyTermination$1(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        Predef$.MODULE$.require(timeoutMs > 0L, (Function0 & Serializable)() -> "Timeout has to be positive");
        return this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable)x$4 -> {
            StreamingQueryManager.$anonfun$awaitAnyTermination$3(timeoutMs, x$4);
            return BoxedUnit.UNIT;
        }).getAwaitAnyTermination().getTerminated();
    }

    public void resetTerminated() {
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable)x$5 -> {
            x$5.setResetTerminated(true);
            return BoxedUnit.UNIT;
        });
    }

    public void addListener(StreamingQueryListener listener) {
        this.streamingQueryListenerBus().append(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.streamingQueryListenerBus().remove(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return this.streamingQueryListenerBus().list();
    }

    private StreamingQueryManagerCommandResult executeManagerCmd(Function1<StreamingQueryManagerCommand.Builder, BoxedUnit> setCmdFn) {
        Command.Builder cmdBuilder = Command.newBuilder();
        StreamingQueryManagerCommand.Builder managerCmdBuilder = cmdBuilder.getStreamingQueryManagerCommandBuilder();
        setCmdFn.apply((Object)managerCmdBuilder);
        ExecutePlanResponse resp = (ExecutePlanResponse)this.sparkSession.execute(cmdBuilder.build()).head();
        if (!resp.hasStreamingQueryManagerCommandResult()) {
            throw new RuntimeException("Unexpected missing response for streaming query manager command");
        }
        return resp.getStreamingQueryManagerCommandResult();
    }

    private void cacheListenerById(String id, StreamingQueryListener listener) {
        this.listenerCache().putIfAbsent(id, listener);
    }

    private String getIdByListener(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            this.listenerCache().forEach((k, v) -> {
                if (listener.equals(v)) {
                    throw new NonLocalReturnControl(object, k);
                }
            });
            throw InvalidPlanInput$.MODULE$.apply("No id with listener " + listener + " is found.");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    private StreamingQueryListener removeCachedListener(String id) {
        return (StreamingQueryListener)this.listenerCache().remove(id);
    }

    public static final /* synthetic */ void $anonfun$awaitAnyTermination$1(StreamingQueryManagerCommand.Builder x$3) {
        x$3.getAwaitAnyTerminationBuilder().build();
    }

    public static final /* synthetic */ void $anonfun$awaitAnyTermination$3(long timeoutMs$1, StreamingQueryManagerCommand.Builder x$4) {
        x$4.getAwaitAnyTerminationBuilder().setTimeoutMs(timeoutMs$1);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.streamingQueryListenerBus = new StreamingQueryListenerBus(sparkSession);
    }
}

