/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\reb\u0001B\u001e=\t\u001eCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001a\u0001\u0005B\u0015DQa\u001d\u0001\u0005BQDQA \u0001\u0005B}D\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005%\u0002\u0001)A\u0005\u0003\u001fA\u0011\"a\u000b\u0001\u0005\u0004%I!!\u0004\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u001fA\u0011\"a\f\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005E\u0002\u0001)A\u0005\u0003\u001fAq!a\r\u0001\t\u0003\n)D\u0002\u0004\u0002<\u0001\u0001\u0011Q\b\u0005\u0007C2!\t!a\u0012\t\u000f\u0005-C\u0002\"\u0015\u0002N!9\u00111\u000b\u0007\u0005B\u0005U\u0003bBA=\u0019\u0011\u0005\u00131\u0010\u0005\b\u0003\u007fbA\u0011IAA\u0011\u001d\ty\t\u0004C!\u0003#CA\"!(\r!\u0003\u0005\t\u0011!C\u0001\u0003?Cq!!+\u0001\t\u0003\nY\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u00111\u001f\u0001\u0005B\u0005U\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011\t\u0003\u0001C!\u0005GAqA!\r\u0001\t\u0003\u0012\u0019\u0004C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t%\u0003\u0001\"\u0011\u0003L!9!q\u000b\u0001\u0005B\tecA\u0002BD\u0001\u0001\u0011I\tC\u0005\u0003\u0012~\u0011\t\u0011)A\u0005\u0011\"Q!1S\u0010\u0003\u0002\u0003\u0006IA!&\t\r\u0005|B\u0011\u0001BT\u0011\u001d\tyi\bC!\u0005_CqA!-\u0001\t\u0003\u0012\u0019\fC\u0004\u00038\u0002!\tE!/\t\u000f\t}\u0006\u0001\"\u0011\u0003B\"A!1\u0019\u0001\u0002\u0002\u0013\u0005!\rC\u0005\u0003F\u0002\t\t\u0011\"\u0011\u0003H\"I!\u0011\u001a\u0001\u0002\u0002\u0013\u0005!1\u001a\u0005\n\u0005\u001b\u0004\u0011\u0011!C\u0001\u0005\u001fD\u0011Ba5\u0001\u0003\u0003%\tE!6\t\u0013\t}\u0007!!A\u0005\u0002\t\u0005\b\"\u0003Bs\u0001\u0005\u0005I\u0011\tBt\u0011%\u0011Y\u000fAA\u0001\n\u0003\u0012i\u000fC\u0005\u0003p\u0002\t\t\u0011\"\u0011\u0003r\"I!1\u001f\u0001\u0002\u0002\u0013\u0005#Q_\u0004\b\u0005sd\u0004\u0012\u0002B~\r\u0019YD\b#\u0003\u0003~\"1\u0011M\rC\u0001\u0007\u001fA\u0011b!\u00053\u0005\u0004%)aa\u0005\t\u0011\re!\u0007)A\u0007\u0007+A\u0011ba\u00073\u0005\u0004%)a!\b\t\u0011\r\r\"\u0007)A\u0007\u0007?A\u0001b!\n3\u0003\u0003%\tI\u0019\u0005\n\u0007O\u0011\u0014\u0011!CA\u0007SA\u0011ba\f3\u0003\u0003%Ia!\r\u0003%5\u001b8+\u001d7TKJ4XM\u001d#jC2,7\r\u001e\u0006\u0003{y\nAA\u001b3cG*\u0011q\bQ\u0001\u0004gFd'BA!C\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\u0004\u0001M)\u0001\u0001\u0013'P+B\u0011\u0011JS\u0007\u0002y%\u00111\n\u0010\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cG\u000f\u0005\u0002J\u001b&\u0011a\n\u0010\u0002\u0012\u001d>dUmZ1ds*#%iQ#se>\u0014\bC\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&a\u0002)s_\u0012,8\r\u001e\t\u0003-zs!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i3\u0015A\u0002\u001fs_>$h(C\u0001S\u0013\ti\u0016+A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'\u0001D*fe&\fG.\u001b>bE2,'BA/R\u0003\u0019a\u0014N\\5u}Q\t1\r\u0005\u0002J\u0001\u0005I1-\u00198IC:$G.\u001a\u000b\u0003M&\u0004\"\u0001U4\n\u0005!\f&a\u0002\"p_2,\u0017M\u001c\u0005\u0006U\n\u0001\ra[\u0001\u0004kJd\u0007C\u00017q\u001d\tig\u000e\u0005\u0002Y#&\u0011q.U\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p#\u0006I\u0012n](cU\u0016\u001cGOT8u\r>,h\u000eZ#yG\u0016\u0004H/[8o)\t1W\u000fC\u0003w\u0007\u0001\u0007q/A\u0001f!\tAH0D\u0001z\u0015\ty$PC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uL(\u0001D*R\u0019\u0016C8-\u001a9uS>t\u0017\u0001D2p[BLG.\u001a,bYV,G\u0003BA\u0001\u0003\u000f\u00012\u0001UA\u0002\u0013\r\t)!\u0015\u0002\u0004\u0003:L\bbBA\u0005\t\u0001\u0007\u0011\u0011A\u0001\u0006m\u0006dW/Z\u0001\u001cgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0005\u0005=\u0001CBA\t\u00037\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001aE\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0005\u0003\u0007M+G\u000f\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)C_\u0001\u0005Y\u0006tw-C\u0002r\u0003G\tAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\rtkB\u0004xN\u001d;fIN#(/\u001b8h\rVt7\r^5p]N\f\u0011d];qa>\u0014H/\u001a3TiJLgn\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u00112/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8t\u0003M\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:!\u0003MI7oU;qa>\u0014H/\u001a3Gk:\u001cG/[8o)\r1\u0017q\u0007\u0005\u0007\u0003sY\u0001\u0019A6\u0002\u0011\u0019,hn\u0019(b[\u0016\u0014Q#T:Tc2\u001cVM\u001d<feN\u000bFJQ;jY\u0012,'oE\u0002\r\u0003\u007f\u0001B!!\u0011\u0002D5\t\u0001!C\u0002\u0002F)\u0013aB\u0013#C\u0007N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0002JA\u0019\u0011\u0011\t\u0007\u0002#A\u0014X\rZ5dCR,Gk\\%oiN\u000bF\nF\u0002l\u0003\u001fBa!!\u0015\u000f\u0001\u0004Y\u0017!B5oaV$\u0018A\u0004<jg&$8k\u001c:u\u001fJ$WM\u001d\u000b\bW\u0006]\u00131LA8\u0011\u0019\tIf\u0004a\u0001W\u000691o\u001c:u\u0017\u0016L\bbBA/\u001f\u0001\u0007\u0011qL\u0001\u000eg>\u0014H\u000fR5sK\u000e$\u0018n\u001c8\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tIGP\u0001\nG>tg.Z2u_JLA!!\u001c\u0002d\ti1k\u001c:u\t&\u0014Xm\u0019;j_:Dq!!\u001d\u0010\u0001\u0004\t\u0019(\u0001\u0007ok2dwJ\u001d3fe&tw\r\u0005\u0003\u0002b\u0005U\u0014\u0002BA<\u0003G\u0012ABT;mY>\u0013H-\u001a:j]\u001e\f1\u0003Z5bY\u0016\u001cGOR;oGRLwN\u001c(b[\u0016$2a[A?\u0011\u0019\tI\u0004\u0005a\u0001W\u0006\u0001b/[:jiN\u000bFJR;oGRLwN\u001c\u000b\u0006W\u0006\r\u0015Q\u0011\u0005\u0007\u0003s\t\u0002\u0019A6\t\u000f\u0005\u001d\u0015\u00031\u0001\u0002\n\u00061\u0011N\u001c9viN\u0004B\u0001UAFW&\u0019\u0011QR)\u0003\u000b\u0005\u0013(/Y=\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0007-\f\u0019\nC\u0004\u0002\u0016J\u0001\r!a&\u0002\t\u0015D\bO\u001d\t\u0005\u0003C\nI*\u0003\u0003\u0002\u001c\u0006\r$AC#yaJ,7o]5p]\u0006!\u0002O]8uK\u000e$X\r\u001a\u0013j]B,H\u000fV8T#2#B!!)\u0002(R!\u0011qDAR\u0011%\t)kEA\u0001\u0002\u0004\t9*A\u0002yIEB\u0011\"!*\u0014\u0003\u0003\u0005\r!!\u0013\u0002#\r|W\u000e]5mK\u0016C\bO]3tg&|g\u000e\u0006\u0003\u0002.\u0006M\u0006\u0003\u0002)\u00020.L1!!-R\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\u0013\u000bA\u0002\u0005]\u0015aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0015\u0005e\u0016qYAi\u0003+\fI\u000eE\u0003Q\u0003_\u000bY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tMP\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u000b\fyL\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tI-\u0006a\u0001\u0003\u0017\fqa]9m)f\u0004X\rE\u0002Q\u0003\u001bL1!a4R\u0005\rIe\u000e\u001e\u0005\u0007\u0003',\u0002\u0019A6\u0002\u0011QL\b/\u001a(b[\u0016Dq!a6\u0016\u0001\u0004\tY-\u0001\u0003tSj,\u0007bBAn+\u0001\u0007\u0011Q\\\u0001\u0003[\u0012\u0004B!!0\u0002`&!\u0011\u0011]A`\u0005=iU\r^1eCR\f')^5mI\u0016\u0014\u0018aC4fi*#%i\u0011+za\u0016$B!a:\u0002pB)\u0001+a,\u0002jB\u0019\u0011*a;\n\u0007\u00055HH\u0001\u0005KI\n\u001cG+\u001f9f\u0011\u001d\t\tP\u0006a\u0001\u0003w\u000b!\u0001\u001a;\u00021%\u001c8)Y:dC\u0012Lgn\u001a+sk:\u001c\u0017\r^3UC\ndW\r\u0006\u0002\u0002xB!\u0001+a,g\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000b-\fiP!\u0004\t\u000f\u0005}\b\u00041\u0001\u0003\u0002\u0005Aq\u000e\u001c3UC\ndW\r\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\u0011\u00119!a\u001a\u0002\u000f\r\fG/\u00197pO&!!1\u0002B\u0003\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\b\u0005\u001fA\u0002\u0019\u0001B\u0001\u0003!qWm\u001e+bE2,\u0017!E4fi\u0006#GmQ8mk6t\u0017+^3ssR91N!\u0006\u0003\u001a\tu\u0001B\u0002B\f3\u0001\u00071.A\u0005uC\ndWMT1nK\"1!1D\rA\u0002-\f!bY8mk6tg*Y7f\u0011\u0019\u0011y\"\u0007a\u0001W\u0006AA-\u0019;b)f\u0004X-\u0001\u000bhKR\u0014VM\\1nK\u000e{G.^7o#V,'/\u001f\u000b\nW\n\u0015\"q\u0005B\u0015\u0005[AaAa\u0006\u001b\u0001\u0004Y\u0007B\u0002B\u000e5\u0001\u00071\u000e\u0003\u0004\u0003,i\u0001\ra[\u0001\b]\u0016<h*Y7f\u0011\u001d\u0011yC\u0007a\u0001\u0003\u0017\fa\u0002\u001a2NC*|'OV3sg&|g.A\u0010hKR,\u0006\u000fZ1uK\u000e{G.^7o\u001dVdG.\u00192jY&$\u00180U;fef$ra\u001bB\u001b\u0005o\u0011I\u0004\u0003\u0004\u0003\u0018m\u0001\ra\u001b\u0005\u0007\u00057Y\u0002\u0019A6\t\r\tm2\u00041\u0001g\u0003)I7OT;mY\u0006\u0014G.Z\u0001\u0015O\u0016$H+\u00192mK\u000e{W.\\3oiF+XM]=\u0015\u000b-\u0014\tE!\u0012\t\r\t\rC\u00041\u0001l\u0003\u0015!\u0018M\u00197f\u0011\u0019\u00119\u0005\ba\u0001W\u000691m\\7nK:$\u0018AD4fi2KW.\u001b;DY\u0006,8/\u001a\u000b\u0004W\n5\u0003b\u0002B(;\u0001\u0007!\u0011K\u0001\u0006Y&l\u0017\u000e\u001e\t\u0005\u0003C\u0011\u0019&\u0003\u0003\u0003V\u0005\r\"aB%oi\u0016<WM]\u0001\u0012G2\f7o]5gs\u0016C8-\u001a9uS>tG\u0003\u0004B.\u0005_\u0012\tH!\u001e\u0003\u0000\t\r%C\u0002B/\u0005C\u00129G\u0002\u0004\u0003`\u0001\u0001!1\f\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004-\n\r\u0014b\u0001B3A\nIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005S\u0012Y'D\u0001A\u0013\r\u0011i\u0007\u0011\u0002\u000f'B\f'o\u001b+ie><\u0018M\u00197f\u0011\u00191h\u00041\u0001\u0003b!1!1\u000f\u0010A\u0002-\f\u0011bY8oI&$\u0018n\u001c8\t\u000f\t]d\u00041\u0001\u0003z\u0005\tR.Z:tC\u001e,\u0007+\u0019:b[\u0016$XM]:\u0011\u000b1\u0014Yh[6\n\u0007\tu$OA\u0002NCBDaA!!\u001f\u0001\u0004Y\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:DaA!\"\u001f\u0001\u00041\u0017!C5t%VtG/[7f\u0005ii5oU9m'\u0016\u0014h/\u001a:T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s'\ry\"1\u0012\t\u0004\u0013\n5\u0015b\u0001BHy\t\u0019\"\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3fe\u00069A-[1mK\u000e$\u0018aB8qi&|gn\u001d\t\u0005\u0005/\u0013\u0019+\u0004\u0002\u0003\u001a*\u0019QHa'\u000b\t\tu%qT\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0003\"z\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\t\u0015&\u0011\u0014\u0002\f\u0015\u0012\u00135i\u00149uS>t7\u000f\u0006\u0004\u0003*\n-&Q\u0016\t\u0004\u0003\u0003z\u0002B\u0002BIE\u0001\u0007\u0001\nC\u0004\u0003\u0014\n\u0002\rA!&\u0015\u0003-\facZ3u\u0015\u0012\u00147mU)M#V,'/\u001f\"vS2$WM\u001d\u000b\u0005\u0005\u0017\u0013)\fC\u0004\u0003\u0014\u0012\u0002\rA!&\u0002/%\u001c8+\u001f8uCb,%O]8s\u0005\u0016\u001cH/\u00124g_J$Hc\u00014\u0003<\"1!QX\u0013A\u0002]\f\u0011\"\u001a=dKB$\u0018n\u001c8\u0002\u001bM,\b\u000f]8siNd\u0015.\\5u+\u00051\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0010\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005!\u0011\u001b\u0005\n\u0003KS\u0013\u0011!a\u0001\u0003\u0017\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005/\u0004bA!7\u0003\\\u0006\u0005QBAA\f\u0013\u0011\u0011i.a\u0006\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004M\n\r\b\"CASY\u0005\u0005\t\u0019AA\u0001\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}!\u0011\u001e\u0005\n\u0003Kk\u0013\u0011!a\u0001\u0003\u0017\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0017\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\ta!Z9vC2\u001cHc\u00014\u0003x\"I\u0011Q\u0015\u0019\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0013\u001bN\u001c\u0016\u000f\\*feZ,'\u000fR5bY\u0016\u001cG\u000f\u0005\u0002JeM)!Ga@\u0004\u0006A\u0019\u0001k!\u0001\n\u0007\r\r\u0011K\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0007\u000f\u0019i!\u0004\u0002\u0004\n)\u001911\u0002>\u0002\u0005%|\u0017bA0\u0004\nQ\u0011!1`\u0001\t\u000f\u0016{U*\u0012+S3V\u00111QC\b\u0003\u0007/i\"a\u00002\u0002\u0013\u001d+u*T#U%f\u0003\u0013!C$F\u001f\u001e\u0013\u0016\t\u0015%Z+\t\u0019yb\u0004\u0002\u0004\"u\u0011q`Y\u0001\u000b\u000f\u0016{uIU!Q\u0011f\u0003\u0013!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004M\u000e-\u0002\u0002CB\u0017s\u0005\u0005\t\u0019A2\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00044A!\u0011\u0011EB\u001b\u0013\u0011\u00199$a\t\u0003\r=\u0013'.Z2u\u0001")
public class MsSqlServerDialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedStringFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MsSqlServerDialect x$0) {
        return MsSqlServerDialect$.MODULE$.unapply(x$0);
    }

    public static MsSqlServerDialect apply() {
        return MsSqlServerDialect$.MODULE$.apply();
    }

    public static int GEOGRAPHY() {
        return MsSqlServerDialect$.MODULE$.GEOGRAPHY();
    }

    public static int GEOMETRY() {
        return MsSqlServerDialect$.MODULE$.GEOMETRY();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:sqlserver");
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getErrorCode() == 208;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            if (bl) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("0x", "", "");
        }
        return super.compileValue(object);
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedStringFunctions() {
        return this.supportedStringFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MsSqlServerSQLBuilder msSqlServerSQLBuilder = new MsSqlServerSQLBuilder(this);
        try {
            some = new Some((Object)msSqlServerSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        if (typeName.contains("datetimeoffset")) {
            if (SQLConf$.MODULE$.get().legacyMsSqlServerDatetimeOffsetMappingEnabled()) {
                return new Some((Object)StringType$.MODULE$);
            }
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ((5 == n ? true : -6 == n) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (7 == n && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (-157 == n ? true : -158 == n) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NVARCHAR(MAX)", -9));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BIT", -7));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARBINARY(MAX)", -3));
        }
        if (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", -6));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "EXEC sp_rename " + this.getFullyQualifiedQuotedTableName(oldTable) + ", " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return "EXEC sp_rename '" + tableName + "." + this.quoteIdentifier(columnName) + "', " + this.quoteIdentifier(newName) + ", 'COLUMN'";
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "TOP (" + limit + ")";
        }
        return "";
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 3729: {
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 15335: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MsSqlServerSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        String exceptionMessage = (String)Option$.MODULE$.apply((Object)exception.getMessage()).map((Function1 & Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT)).getOrElse((Function0 & Serializable)() -> "");
        return exceptionMessage.contains("incorrect syntax") || exceptionMessage.contains("syntax error");
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    public MsSqlServerDialect copy() {
        return new MsSqlServerDialect();
    }

    public String productPrefix() {
        return "MsSqlServerDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MsSqlServerDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MsSqlServerDialect && ((MsSqlServerDialect)x$1).canEqual(this);
    }

    public MsSqlServerDialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedStringFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD", "LPAD"}));
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus(this.supportedStringFunctions());
    }

    public class MsSqlServerSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public /* synthetic */ String protected$inputToSQL(MsSqlServerSQLBuilder x$1, Expression x$12) {
            return x$1.inputToSQL(x$12);
        }

        @Override
        public String predicateToIntSQL(String input) {
            return "IIF(" + input + ", 1, 0)";
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        @Override
        public String dialectFunctionName(String funcName) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -446106967: {
                    if (!"VAR_SAMP".equals(string)) break;
                    return "VAR";
                }
                case -102600828: {
                    if (!"STDDEV_POP".equals(string)) break;
                    return "STDEVP";
                }
                case 955438329: {
                    if (!"VAR_POP".equals(string)) break;
                    return "VARP";
                }
                case 1114417534: {
                    if (!"STDDEV_SAMP".equals(string)) break;
                    return "STDEV";
                }
            }
            return super.dialectFunctionName(funcName);
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case 2343079: {
                    Object object;
                    if (!"LPAD".equals(string)) break;
                    String[] stringArray = inputs;
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String str = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String len = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String pad = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                    Tuple3 tuple3 = new Tuple3((Object)str, (Object)len, (Object)pad);
                    String str2 = (String)tuple3._1();
                    String len2 = (String)tuple3._2();
                    String pad2 = (String)tuple3._3();
                    return "RIGHT(CONCAT(REPLICATE(" + pad2 + ", " + len2 + "), " + str2 + "), " + len2 + ")";
                }
                case 2521825: {
                    Object object;
                    if (!"RPAD".equals(string)) break;
                    String[] stringArray = inputs;
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String str = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String len = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String pad = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                    Tuple3 tuple3 = new Tuple3((Object)str, (Object)len, (Object)pad);
                    String str3 = (String)tuple3._1();
                    String len3 = (String)tuple3._2();
                    String pad3 = (String)tuple3._3();
                    return "LEFT(CONCAT(" + str3 + ", REPLICATE(" + pad3 + ", " + len3 + ")), " + len3 + ")";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String build(Expression expr) {
            block19: {
                block20: {
                    Object object;
                    Expression expression = expr;
                    if (!(expression instanceof Predicate)) break block19;
                    Predicate predicate = (Predicate)expression;
                    String string = predicate.name();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -807639319: {
                            if ("CASE_WHEN".equals(string)) {
                                String[] stringArray = (String[])ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])predicate.children()), 2).flatMap((Function1 & Serializable)x0$1 -> {
                                    Object object;
                                    Object object2;
                                    Expression[] expressionArray = x0$1;
                                    if (expressionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)expressionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                                        Expression whenExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                                        Expression thenExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.protected$inputToSQL(this, whenExpression), this.inputToSQLNoBool(thenExpression)});
                                    }
                                    if (expressionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)expressionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                                        Expression elseExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.inputToSQLNoBool(elseExpression)});
                                    }
                                    throw new MatchError((Object)expressionArray);
                                }).toArray(ClassTag$.MODULE$.apply(String.class));
                                return this.visitCaseWhen(stringArray) + " = 1";
                            }
                            break block20;
                        }
                        case 60: {
                            if ("<".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 61: {
                            if ("=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 62: {
                            if (">".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1921: {
                            if ("<=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1922: {
                            if ("<>".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1983: {
                            if (">=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 59613: {
                            if ("<=>".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        default: {
                            break block20;
                        }
                    }
                    String[] stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])predicate.children()), (Function1 & Serializable)input -> this.inputToSQLNoBool((Expression)input), ClassTag$.MODULE$.apply(String.class));
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String l = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String r = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    Tuple2 tuple2 = new Tuple2((Object)l, (Object)r);
                    String l2 = (String)tuple2._1();
                    String r2 = (String)tuple2._2();
                    return this.visitBinaryComparison(predicate.name(), l2, r2);
                }
                return super.build(expr);
            }
            return super.build(expr);
        }

        public /* synthetic */ MsSqlServerDialect org$apache$spark$sql$jdbc$MsSqlServerDialect$MsSqlServerSQLBuilder$$$outer() {
            return (MsSqlServerDialect)this.$outer;
        }

        public MsSqlServerSQLBuilder(MsSqlServerDialect $outer) {
        }
    }

    public class MsSqlServerSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MsSqlServerDialect $outer;

        @Override
        public String build() {
            String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
            return this.options.prepareQuery() + "SELECT " + limitClause + " " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
        }

        public /* synthetic */ MsSqlServerDialect org$apache$spark$sql$jdbc$MsSqlServerDialect$MsSqlServerSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MsSqlServerSQLQueryBuilder(MsSqlServerDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

