/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat$;
import org.apache.spark.sql.execution.datasources.csv.CsvOutputWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUb\u0001B\u000f\u001f\u00016BQA\u0013\u0001\u0005\u0002-CQA\u0014\u0001\u0005B=CQ\u0001\u0017\u0001\u0005BeCQA\u001d\u0001\u0005BMDq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u00022\u0001!\t%a\r\t\r\u0005u\u0004\u0001\"\u0011P\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u0000\u0001!I!a%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006\u0002CAY\u0001\u0005\u0005I\u0011A&\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CAc\u0001\u0005\u0005I\u0011AAd\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003c\u0004\u0011\u0011!C!\u0003gD\u0011\"a>\u0001\u0003\u0003%\t%!?\t\u0013\u0005m\b!!A\u0005B\u0005ux!\u0003B\u0001=\u0005\u0005\t\u0012\u0001B\u0002\r!ib$!A\t\u0002\t\u0015\u0001B\u0002&\u0018\t\u0003\u0011i\u0002C\u0005\u0002~]\t\t\u0011\"\u0012\u0003 !A!\u0011E\f\u0002\u0002\u0013\u00055\nC\u0005\u0003$]\t\t\u0011\"!\u0003&!I!1F\f\u0002\u0002\u0013%!Q\u0006\u0002\u000e\u0007N3f)\u001b7f\r>\u0014X.\u0019;\u000b\u0005}\u0001\u0013aA2tm*\u0011\u0011EI\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002$I\u0005IQ\r_3dkRLwN\u001c\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0006\u00019\u0012\u0004H\u0010\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u00121\u0003V3yi\n\u000b7/\u001a3GS2,gi\u001c:nCR\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0013\u0002\u000fM|WO]2fg&\u0011q\u0007\u000e\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0004Qe>$Wo\u0019;\u0011\u0005}:eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019E&\u0001\u0004=e>|GOP\u0005\u0002w%\u0011aIO\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Gu\u00051A(\u001b8jiz\"\u0012\u0001\u0014\t\u0003\u001b\u0002i\u0011AH\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\u0015\t\u0003#Vs!AU*\u0011\u0005\u0005S\u0014B\u0001+;\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QS\u0014aC5t'Bd\u0017\u000e^1cY\u0016$BAW/dQB\u0011\u0011hW\u0005\u00039j\u0012qAQ8pY\u0016\fg\u000eC\u0003_\u0007\u0001\u0007q,\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002aC6\tA%\u0003\u0002cI\ta1\u000b]1sWN+7o]5p]\")Am\u0001a\u0001K\u00069q\u000e\u001d;j_:\u001c\b\u0003B)g!BK!aZ,\u0003\u00075\u000b\u0007\u000fC\u0003j\u0007\u0001\u0007!.\u0001\u0003qCRD\u0007CA6q\u001b\u0005a'BA7o\u0003\t17O\u0003\u0002pQ\u00051\u0001.\u00193p_BL!!\u001d7\u0003\tA\u000bG\u000f[\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003u{z|\bcA\u001dvo&\u0011aO\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a\\X\"A=\u000b\u0005i$\u0013!\u0002;za\u0016\u001c\u0018B\u0001?z\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006=\u0012\u0001\ra\u0018\u0005\u0006I\u0012\u0001\r!\u001a\u0005\b\u0003\u0003!\u0001\u0019AA\u0002\u0003\u00151\u0017\u000e\\3t!\u0015y\u0014QAA\u0005\u0013\r\t9!\u0013\u0002\u0004'\u0016\f\bcA6\u0002\f%\u0019\u0011Q\u00027\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u0002\u0014\u0005e\u00111DA\u0016\u0003[\u00012aLA\u000b\u0013\r\t9\u0002\t\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006=\u0016\u0001\ra\u0018\u0005\b\u0003;)\u0001\u0019AA\u0010\u0003\rQwN\u0019\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u00058\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA\u0015\u0003G\u00111AS8c\u0011\u0015!W\u00011\u0001f\u0011\u0019\ty#\u0002a\u0001o\u0006QA-\u0019;b'\u000eDW-\\1\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003k\t\u0019&!\u0016\u0002X\u0005m\u0013qLA6\u0003[\u0002r!OA\u001c\u0003w\t\t%C\u0002\u0002:i\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007=\ni$C\u0002\u0002@\u0001\u0012q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006\u007f\u0005\r\u0013qI\u0005\u0004\u0003\u000bJ%\u0001C%uKJ\fGo\u001c:\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014%\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA)\u0003\u0017\u00121\"\u00138uKJt\u0017\r\u001c*po\")aL\u0002a\u0001?\"1\u0011q\u0006\u0004A\u0002]Da!!\u0017\u0007\u0001\u00049\u0018a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005uc\u00011\u0001x\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!\u0019\u0007\u0001\u0004\t\u0019'A\u0004gS2$XM]:\u0011\u000b}\n)!!\u001a\u0011\u0007M\n9'C\u0002\u0002jQ\u0012aAR5mi\u0016\u0014\b\"\u00023\u0007\u0001\u0004)\u0007bBA8\r\u0001\u0007\u0011\u0011O\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]d.\u0001\u0003d_:4\u0017\u0002BA>\u0003k\u0012QbQ8oM&<WO]1uS>t\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$2AWAB\u0011\u001d\t)\t\u0003a\u0001\u0003\u000f\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0004q\u0006%\u0015bAAFs\nAA)\u0019;b)f\u0004X-A\ntkB\u0004xN\u001d;SK\u0006$G)\u0019;b)f\u0004X\rF\u0002[\u0003#Cq!!\"\n\u0001\u0004\t9\tF\u0003[\u0003+\u000b9\nC\u0004\u0002\u0006*\u0001\r!a\"\t\r\u0005e%\u00021\u0001[\u00031\tG\u000e\\8x-\u0006\u0014\u0018.\u00198u\u0003i\tG\u000e\\8x\tV\u0004H.[2bi\u0016$7i\u001c7v[:t\u0015-\\3t+\u0005Q\u0016!D4fi\u000e\u001bho\u00149uS>t7\u000f\u0006\u0004\u0002$\u00065\u0016q\u0016\t\u0005\u0003K\u000bI+\u0004\u0002\u0002(*\u0019q$a\u0013\n\t\u0005-\u0016q\u0015\u0002\u000b\u0007N3v\n\u001d;j_:\u001c\b\"\u00020\r\u0001\u0004y\u0006\"\u00023\r\u0001\u0004)\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\\!\u0011\tI,a1\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bA\u0001\\1oO*\u0011\u0011\u0011Y\u0001\u0005U\u00064\u0018-C\u0002W\u0003w\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!3\u0011\u0007e\nY-C\u0002\u0002Nj\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a5\u0002ZB\u0019\u0011(!6\n\u0007\u0005]'HA\u0002B]fD\u0011\"a7\u0011\u0003\u0003\u0005\r!!3\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u000f\u0005\u0004\u0002d\u0006%\u00181[\u0007\u0003\u0003KT1!a:;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\n)/\u0001\u0005dC:,\u0015/^1m)\rQ\u0016q\u001e\u0005\n\u00037\u0014\u0012\u0011!a\u0001\u0003'\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qWA{\u0011%\tYnEA\u0001\u0002\u0004\tI-\u0001\u0005iCND7i\u001c3f)\t\tI-\u0001\u0004fcV\fGn\u001d\u000b\u00045\u0006}\b\"CAn+\u0005\u0005\t\u0019AAj\u00035\u00195K\u0016$jY\u00164uN]7biB\u0011QjF\n\u0006/\t\u001d!1\u0003\t\u0006\u0005\u0013\u0011y\u0001T\u0007\u0003\u0005\u0017Q1A!\u0004;\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0005\u0003\f\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0011\t\tU!1D\u0007\u0003\u0005/QAA!\u0007\u0002@\u0006\u0011\u0011n\\\u0005\u0004\u0011\n]AC\u0001B\u0002)\t\t9,A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\u0007i\u00139\u0003\u0003\u0005\u0003*m\t\t\u00111\u0001M\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005_\u0001B!!/\u00032%!!1GA^\u0005\u0019y%M[3di\u0002")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister,
Product,
Serializable {
    public static boolean unapply(CSVFileFormat x$0) {
        return CSVFileFormat$.MODULE$.unapply(x$0);
    }

    public static CSVFileFormat apply() {
        return CSVFileFormat$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public String shortName() {
        return "csv";
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        CSVOptions parsedOptions = this.getCsvOptions(sparkSession, options);
        return CSVDataSource$.MODULE$.apply(parsedOptions).isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        CSVOptions parsedOptions = this.getCsvOptions(sparkSession, options);
        return CSVDataSource$.MODULE$.apply(parsedOptions).inferSchema(sparkSession, files, parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        dataSchema.foreach((Function1 & Serializable)field -> {
            CSVFileFormat.$anonfun$prepareWrite$1(this, field);
            return BoxedUnit.UNIT;
        });
        CSVOptions parsedOptions = this.getCsvOptions(sparkSession, options);
        parsedOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(job.getConfiguration(), codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, parsedOptions){
            private final CSVOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new CsvOutputWriter(path, dataSchema, context, this.parsedOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return "." + this.parsedOptions$1.extension() + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        CSVOptions parsedOptions = this.getCsvOptions(sparkSession, options);
        boolean isColumnPruningEnabled = parsedOptions.isColumnPruningEnabled(requiredSchema);
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw QueryCompilationErrors$.MODULE$.queryFromRawFilesIncludeCorruptRecordColumnError();
            }
        }
        Seq actualFilters = (Seq)filters.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])x$1.references()), (Object)parsedOptions.columnNameOfCorruptRecord())));
        return (Function1 & Serializable)file -> {
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$3(parsedOptions, x$2))));
            StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$4(parsedOptions, x$3))));
            UnivocityParser parser = new UnivocityParser(actualDataSchema, actualRequiredSchema, parsedOptions, actualFilters);
            StructType schema = isColumnPruningEnabled ? actualRequiredSchema : actualDataSchema;
            boolean isStartOfFile = file.start() == 0L;
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(schema, parsedOptions, "CSV file: " + file.urlEncodedPath(), isStartOfFile);
            return CSVDataSource$.MODULE$.apply(parsedOptions).readFile(conf, (PartitionedFile)file, parser, headerChecker, requiredSchema);
        };
    }

    public String toString() {
        return "CSV";
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return this.supportDataType(dataType, false);
    }

    @Override
    public boolean supportReadDataType(DataType dataType) {
        return this.supportDataType(dataType, true);
    }

    private boolean supportDataType(DataType dataType, boolean allowVariant) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof VariantType) {
            return allowVariant;
        }
        if (dataType2 instanceof TimeType) {
            return false;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return true;
    }

    private CSVOptions getCsvOptions(SparkSession sparkSession, Map<String, String> options) {
        SQLConf conf = this.sqlConf(sparkSession);
        return new CSVOptions(options, conf.csvColumnPruning(), conf.sessionLocalTimeZone(), conf.columnNameOfCorruptRecord());
    }

    public CSVFileFormat copy() {
        return new CSVFileFormat();
    }

    public String productPrefix() {
        return "CSVFileFormat";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CSVFileFormat;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof CSVFileFormat && ((CSVFileFormat)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$prepareWrite$1(CSVFileFormat $this, StructField field) {
        if (!$this.supportDataType(field.dataType(), false)) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError("CSV", field);
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$3(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(CSVOptions parsedOptions$2, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public CSVFileFormat() {
        Product.$init$((Product)this);
    }
}

