/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import com.twitter.chill.MeatLocker;
import com.twitter.chill.MeatLocker$;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.mllib.stat.test.StreamingTestMethod;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.StatCounter;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function2;
import scala.StringContext;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class WelchTTest$
implements StreamingTestMethod,
Logging {
    public static final WelchTTest$ MODULE$ = new WelchTTest$();
    private static final MeatLocker<TTest> tTester;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        StreamingTestMethod.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
        tTester = MeatLocker$.MODULE$.apply((Object)new TTest());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public StatisticalSummaryValues toApacheCommonsStats(StatCounter summaryStats) {
        return StreamingTestMethod.toApacheCommonsStats$(this, summaryStats);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public final String methodName() {
        return "Welch's 2-sample t-test";
    }

    @Override
    public final String nullHypothesis() {
        return "Both groups have same mean";
    }

    private final MeatLocker<TTest> tTester() {
        return tTester;
    }

    @Override
    public DStream<StreamingTestResult> doTest(DStream<Tuple2<StatCounter, StatCounter>> data) {
        return data.map(((Function2 & Serializable)(Function2 & Serializable)(statsA, statsB) -> MODULE$.test((StatCounter)statsA, (StatCounter)statsB)).tupled(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
    }

    private StreamingTestResult test(StatCounter statsA, StatCounter statsB) {
        return new StreamingTestResult(((TTest)this.tTester().get()).tTest((StatisticalSummary)this.toApacheCommonsStats(statsA), (StatisticalSummary)this.toApacheCommonsStats(statsB)), WelchTTest$.welchDF$1(this.toApacheCommonsStats(statsA), this.toApacheCommonsStats(statsB)), ((TTest)this.tTester().get()).t((StatisticalSummary)this.toApacheCommonsStats(statsA), (StatisticalSummary)this.toApacheCommonsStats(statsB)), "Welch's 2-sample t-test", "Both groups have same mean");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WelchTTest$.class);
    }

    private static final double welchDF$1(StatisticalSummaryValues sample1, StatisticalSummaryValues sample2) {
        double s1 = sample1.getVariance();
        long n1 = sample1.getN();
        double s2 = sample2.getVariance();
        long n2 = sample2.getN();
        double a = package$.MODULE$.pow(s1, 2.0) / (double)n1;
        double b = package$.MODULE$.pow(s2, 2.0) / (double)n2;
        return package$.MODULE$.pow(a + b, 2.0) / (package$.MODULE$.pow(a, 2.0) / (double)(n1 - 1L) + package$.MODULE$.pow(b, 2.0) / (double)(n2 - 1L));
    }

    private WelchTTest$() {
    }
}

