/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001B\u0017/\u0001eB\u0001\"\u001a\u0001\u0003\u0006\u0004%\tE\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005O\"A\u0001\u000f\u0001BC\u0002\u0013%\u0011\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003s\u0011!9\bA!b\u0001\n\u0013A\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0011y\u0004!Q1A\u0005B}D!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011!\tI\u0001\u0001C\u0001a\u0005-\u0001bBA\u0005\u0001\u0011\u0005\u0011Q\u0003\u0005\t\u0003\u0013\u0001A\u0011\u0001\u0019\u00020!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002BBA\u001e\u0001\u0011\u0005\u0013\u000f\u0003\u0005\u0002@\u0001\u0011\r\u0011\"\u0001\u0000\u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0001BBA&\u0001\u0011\u0005\u0003\u0010C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011)\t\t\u000e\u0001EC\u0002\u0013\u0005\u00111\u001b\u0005\t\u0003/\u0004A\u0011\u0001\u0019\u0002Z\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bb\u0002B\u0004\u0001\u0011\u0005#\u0011B\u0004\b\u0005+q\u0003\u0012\u0001B\f\r\u0019ic\u0006#\u0001\u0003\u001a!9\u0011\u0011B\u000e\u0005\u0002\tU\u0002b\u0002B\u001c7\u0011\u0005#\u0011\b\u0005\b\u0005\u0007ZB\u0011\tB#\r\u001d\u0011ie\u0007\u0001\u001c\u0005\u001fB\u0011B!\u0015 \u0005\u0003\u0005\u000b\u0011\u0002#\t\u000f\u0005%q\u0004\"\u0001\u0003T!9!1L\u0010\u0005R\tucA\u0002B47\u0011\u0011I\u0007C\u0004\u0002\n\r\"\tAa\u001b\t\u0013\t=4E1A\u0005\n\tE\u0004\u0002\u0003B?G\u0001\u0006IAa\u001d\t\u0013\t}4E1A\u0005\n\tE\u0004\u0002\u0003BAG\u0001\u0006IAa\u001d\t\u000f\t\r3\u0005\"\u0011\u0003\u0004\"A!qQ\u000e\u0005\u0002A\u0012I\t\u0003\u0006\u0003&n\t\n\u0011\"\u00011\u0005OC\u0011Ba/\u001c\u0003\u0003%IA!0\u0003%\u001d\u0013EKU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003_A\n!B]3he\u0016\u001c8/[8o\u0015\t\t$'\u0001\u0002nY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001QTiS)X!\u0011YDH\u0010#\u000e\u00039J!!\u0010\u0018\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0019\u0002\r1Lg.\u00197h\u0013\t\u0019\u0005I\u0001\u0004WK\u000e$xN\u001d\t\u0003w\u0001\u0001\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0019\u0002\tQ\u0014X-Z\u0005\u0003\u0015\u001e\u0013!c\u0012\"U%\u0016<'/Z:t_J\u0004\u0016M]1ngB\u0019a\t\u0014(\n\u00055;%!\u0005+sK\u0016,en]3nE2,Wj\u001c3fYB\u00111hT\u0005\u0003!:\u00121\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+1\u0003\u0011)H/\u001b7\n\u0005Y\u001b&AC'M/JLG/\u00192mKB\u0011\u0001L\u0019\b\u00033~s!AW/\u000e\u0003mS!\u0001\u0018\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0016!B:dC2\f\u0017B\u00011b\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AX\u0005\u0003G\u0012\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001Y1\u0002\u0007ULG-F\u0001h!\tAGN\u0004\u0002jUB\u0011!,Y\u0005\u0003W\u0006\fa\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111.Y\u0001\u0005k&$\u0007%\u0001\u0004`iJ,Wm]\u000b\u0002eB\u00191\u000f\u001e(\u000e\u0003\u0005L!!^1\u0003\u000b\u0005\u0013(/Y=\u0002\u000f}#(/Z3tA\u0005aq\f\u001e:fK^+\u0017n\u001a5ugV\t\u0011\u0010E\u0002tij\u0004\"a]>\n\u0005q\f'A\u0002#pk\ndW-A\u0007`iJ,WmV3jO\"$8\u000fI\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u0002\u0002A\u00191/a\u0001\n\u0007\u0005\u0015\u0011MA\u0002J]R\fAB\\;n\r\u0016\fG/\u001e:fg\u0002\na\u0001P5oSRtD#\u0003#\u0002\u000e\u0005=\u0011\u0011CA\n\u0011\u0015)\u0017\u00021\u0001h\u0011\u0015\u0001\u0018\u00021\u0001s\u0011\u00159\u0018\u00021\u0001z\u0011\u0019q\u0018\u00021\u0001\u0002\u0002Q9A)a\u0006\u0002\u001a\u0005m\u0001\"B3\u000b\u0001\u00049\u0007\"\u00029\u000b\u0001\u0004\u0011\b\"B<\u000b\u0001\u0004I\b&\u0002\u0006\u0002 \u0005-\u0002\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\"'\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002$\t)1+\u001b8dK\u0006\u0012\u0011QF\u0001\u0006c9\"d\u0006\r\u000b\u0002\t\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016,\"!!\u000e\u0011\u0007M\f9$C\u0002\u0002:\u0005\u0014A\u0001T8oO\u0006)AO]3fg\"*Q\"a\b\u0002,\u0005Yq-\u001a;Ok6$&/Z3tQ\u0015q\u0011qDA\"C\t\t)%A\u00033]Ar\u0003'\u0001\u0007hKRtU/\u001c+sK\u0016\u001c\b\u0005K\u0003\u0010\u0003?\t\u0019%A\u0006ue\u0016,w+Z5hQR\u001c\b&\u0002\t\u0002 \u0005-\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005M\u00131\r\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0015!\u0018\u0010]3t\u0015\r\tiFM\u0001\u0004gFd\u0017\u0002BA1\u0003/\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t)'\u0005a\u0001\u0003'\naa]2iK6\f\u0007&B\t\u0002 \u0005-\u0012!\u0003;sC:\u001chm\u001c:n)\u0011\ti'!#\u0011\t\u0005=\u00141\u0011\b\u0005\u0003c\n\tI\u0004\u0003\u0002t\u0005}d\u0002BA;\u0003{rA!a\u001e\u0002|9\u0019!,!\u001f\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014bAA/e%\u0019\u0001-a\u0017\n\t\u0005\u0015\u0015q\u0011\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1\u0001YA.\u0011\u001d\tYI\u0005a\u0001\u0003\u001b\u000bq\u0001Z1uCN,G\u000f\r\u0003\u0002\u0010\u0006m\u0005CBAI\u0003'\u000b9*\u0004\u0002\u0002\\%!\u0011QSA.\u0005\u001d!\u0015\r^1tKR\u0004B!!'\u0002\u001c2\u0001A\u0001DAO\u0003\u0013\u000b\t\u0011!A\u0003\u0002\u0005}%aA0%eE!\u0011\u0011UAT!\r\u0019\u00181U\u0005\u0004\u0003K\u000b'a\u0002(pi\"Lgn\u001a\t\u0004g\u0006%\u0016bAAVC\n\u0019\u0011I\\=\u0002\u000fA\u0014X\rZ5diR\u0019!0!-\t\r\u0005M6\u00031\u0001?\u0003!1W-\u0019;ve\u0016\u001c\u0018\u0001B2paf$2\u0001RA]\u0011\u001d\tY\f\u0006a\u0001\u0003{\u000bQ!\u001a=ue\u0006\u0004B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007\u0004\u0014!\u00029be\u0006l\u0017\u0002BAd\u0003\u0003\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006)\u0005}\u00111F\u0001\ti>\u001cFO]5oOR\tq\rK\u0003\u0016\u0003?\tY#\u0001\ngK\u0006$XO]3J[B|'\u000f^1oG\u0016\u001cX#\u0001 )\u000bY\ty\"a\u0011\u0002\u000bQ|w\n\u001c3\u0016\u0005\u0005m\u0007\u0003BAo\u0003Sl!!a8\u000b\t\u0005\u0005\u00181]\u0001\u0006[>$W\r\u001c\u0006\u0004\u0011\u0006\u0015(bAAte\u0005)Q\u000e\u001c7jE&!\u00111^Ap\u0005e9%/\u00193jK:$(i\\8ti\u0016$GK]3fg6{G-\u001a7\u0002+\u00154\u0018\r\\;bi\u0016,\u0015m\u00195Ji\u0016\u0014\u0018\r^5p]R)\u00110!=\u0002~\"9\u00111\u0012\rA\u0002\u0005M\b\u0007BA{\u0003s\u0004b!!%\u0002\u0014\u0006]\b\u0003BAM\u0003s$A\"a?\u0002r\u0006\u0005\t\u0011!B\u0001\u0003?\u00131a\u0018\u00134\u0011\u0019\ty\u0010\u0007a\u0001O\u0006!An\\:tQ\u0015A\u0012q\u0004B\u0002C\t\u0011)!A\u00033]Qr\u0003'A\u0003xe&$X-\u0006\u0002\u0003\fA\u0019!K!\u0004\n\u0007\t=1K\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015I\u0012qDA\"Q\u0015\u0001\u0011qDA\u0016\u0003I9%\t\u0016*fOJ,7o]5p]6{G-\u001a7\u0011\u0005mZ2cB\u000e\u0003\u001c\t\u0005\"q\u0005\t\u0004g\nu\u0011b\u0001B\u0010C\n1\u0011I\\=SK\u001a\u0004BA\u0015B\u0012\t&\u0019!QE*\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0005%|'B\u0001B\u0019\u0003\u0011Q\u0017M^1\n\u0007\r\u0014Y\u0003\u0006\u0002\u0003\u0018\u0005!!/Z1e+\t\u0011Y\u0004\u0005\u0003S\u0005{!\u0015b\u0001B '\nAQ\n\u0014*fC\u0012,'\u000fK\u0003\u001e\u0003?\t\u0019%\u0001\u0003m_\u0006$Gc\u0001#\u0003H!1!\u0011\n\u0010A\u0002\u001d\fA\u0001]1uQ\"*a$a\b\u0002D\tArI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m/JLG/\u001a:\u0014\u0007}\u0011Y!\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011)F!\u0017\u0011\u0007\t]s$D\u0001\u001c\u0011\u0019\u0011\t&\ta\u0001\t\u0006A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003`\t\u0015\u0004cA:\u0003b%\u0019!1M1\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005\u0013\u0012\u0003\u0019A4\u00031\u001d\u0013EKU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002$\u0005w!\"A!\u001c\u0011\u0007\t]3%A\u0005dY\u0006\u001c8OT1nKV\u0011!1\u000f\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011\u0010B\u0018\u0003\u0011a\u0017M\\4\n\u00075\u00149(\u0001\u0006dY\u0006\u001c8OT1nK\u0002\nQ\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0017A\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW\r\t\u000b\u0004\t\n\u0015\u0005B\u0002B%S\u0001\u0007q-A\u0004ge>lw\n\u001c3\u0015\u0013\u0011\u0013YIa$\u0003\u001a\n\r\u0006b\u0002BGU\u0001\u0007\u00111\\\u0001\t_2$Wj\u001c3fY\"9!\u0011\u0013\u0016A\u0002\tM\u0015A\u00029be\u0016tG\u000fE\u0002<\u0005+K1Aa&/\u000519%\t\u0016*fOJ,7o]8s\u0011\u001d\u0011YJ\u000ba\u0001\u0005;\u000b1cY1uK\u001e|'/[2bY\u001a+\u0017\r^;sKN\u0004r\u0001\u001bBP\u0003\u0003\t\t!C\u0002\u0003\":\u00141!T1q\u0011!q(\u0006%AA\u0002\u0005\u0005\u0011!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0016\u0016\u0005\u0003\u0003\u0011Yk\u000b\u0002\u0003.B!!q\u0016B\\\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016!C;oG\",7m[3e\u0015\r\t)#Y\u0005\u0005\u0005s\u0013\tLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa0\u0011\t\tU$\u0011Y\u0005\u0005\u0005\u0007\u00149H\u0001\u0004PE*,7\r\u001e\u0015\u00067\u0005}\u00111\t\u0015\u00065\u0005}\u00111\t")
public class GBTRegressionModel
extends RegressionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTRegressionModel load(String path) {
        return GBTRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.featuresCol()), outputSchema.apply(this.$(this.featuresCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(GBTRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": GBTRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.UUID$.MODULE$, (Object)this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "GBTRegressionModel: uid=" + this.uid() + ", numTrees=" + this.getNumTrees() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD<Instance> data = DatasetUtils$.MODULE$.extractInstances(this, dataset, DatasetUtils$.MODULE$.extractInstances$default$3());
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> "GBTRegressionModel given trees, treeWeights of non-matching lengths (" + this._trees().length + ", " + this._treeWeights().length + ", respectively).");
        this.getNumTrees = this.trees().length;
        Statics.releaseFence();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    public GBTRegressionModel() {
        this("", (DecisionTreeRegressionModel[])((Object[])new DecisionTreeRegressionModel[]{new DecisionTreeRegressionModel()}), new double[]{Double.NaN}, -1);
    }

    private static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numTrees")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "GBTRegressionModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

