/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.EventLogFileReader;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesFileReader;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.deploy.history.SingleFileEventLogFileReader;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EventLogFileReader$
implements Logging {
    public static final EventLogFileReader$ MODULE$ = new EventLogFileReader$();
    private static final ConcurrentHashMap<String, CompressionCodec> codecMap;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        codecMap = new ConcurrentHashMap();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, CompressionCodec> codecMap() {
        return codecMap;
    }

    public EventLogFileReader apply(FileSystem fs, Path path, Option<Object> lastIndex) {
        Option<Object> option = lastIndex;
        if (option instanceof Some) {
            return new RollingEventLogFilesFileReader(fs, path);
        }
        if (None$.MODULE$.equals(option)) {
            return new SingleFileEventLogFileReader(fs, path);
        }
        throw new MatchError(option);
    }

    public Option<EventLogFileReader> apply(FileSystem fs, Path path) {
        return this.apply(fs, fs.getFileStatus(path));
    }

    public Option<EventLogFileReader> apply(FileSystem fs, FileStatus status2) {
        if (this.isSingleEventLog(status2)) {
            return new Some((Object)new SingleFileEventLogFileReader(fs, status2.getPath(), (Option<FileStatus>)Option$.MODULE$.apply((Object)status2)));
        }
        if (this.isRollingEventLogs(status2)) {
            FileStatus[] files = fs.listStatus(status2.getPath());
            if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status))) && ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status)))) {
                return new Some((Object)new RollingEventLogFilesFileReader(fs, status2.getPath()));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Rolling event log directory have no event log file at " + status2.getPath());
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public InputStream openEventLog(Path log, FileSystem fs) {
        InputStream inputStream;
        BufferedInputStream in = new BufferedInputStream((InputStream)fs.open(log));
        try {
            Option codec = EventLogFileWriter$.MODULE$.codecName(log).map((Function1 & Serializable)c -> MODULE$.codecMap().computeIfAbsent((String)c, x$1 -> CompressionCodec$.MODULE$.createCodec(new SparkConf(), (String)x$1)));
            inputStream = (InputStream)codec.map((Function1 & Serializable)x$2 -> x$2.compressedContinuousInputStream(in)).getOrElse((Function0 & Serializable)() -> in);
        }
        catch (Throwable e) {
            in.close();
            throw e;
        }
        return inputStream;
    }

    private boolean isSingleEventLog(FileStatus status) {
        return !status.isDirectory() && !status.getPath().getName().startsWith(".");
    }

    private boolean isRollingEventLogs(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogDir(status);
    }

    private EventLogFileReader$() {
    }
}

