/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.r.RAuthHelper;
import org.apache.spark.api.r.RBackend;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.api.r.SerDe$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.R$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.StringContext;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RBackend$
implements Logging {
    public static final RBackend$ MODULE$ = new RBackend$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MODULE$.initializeLogIfNecessary(true);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: RBackend <tempFilePath>");
            System.exit(-1);
        }
        RBackend sparkRBackend = new RBackend();
        try {
            Tuple2<Object, RAuthHelper> tuple2 = sparkRBackend.init();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int boundPort = tuple2._1$mcI$sp();
            RAuthHelper authHelper = (RAuthHelper)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)boundPort), (Object)authHelper);
            int boundPort2 = tuple22._1$mcI$sp();
            RAuthHelper authHelper2 = (RAuthHelper)tuple22._2();
            ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
            int listenPort = serverSocket.getLocalPort();
            SparkConf conf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$3 -> x$3.conf()).getOrElse((Function0 & Serializable)() -> new SparkConf());
            int backendConnectionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(R$.MODULE$.R_BACKEND_CONNECTION_TIMEOUT()));
            String path = args[0];
            File f = new File(path + ".tmp");
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
            dos.writeInt(boundPort2);
            dos.writeInt(listenPort);
            SerDe$.MODULE$.writeString(dos, (String)RUtils$.MODULE$.rPackages().getOrElse((Function0 & Serializable)() -> ""));
            dos.writeInt(backendConnectionTimeout);
            SerDe$.MODULE$.writeString(dos, authHelper2.secret());
            dos.close();
            f.renameTo(new File(path));
            new Thread(serverSocket, authHelper2, sparkRBackend){
                private final ServerSocket serverSocket$1;
                private final RAuthHelper authHelper$2;
                private final RBackend sparkRBackend$1;

                public void run() {
                    byte[] buf = new byte[1024];
                    this.serverSocket$1.setSoTimeout(10000);
                    try {
                        int remainingAttempts = 10;
                        Socket inSocket = null;
                        while (inSocket == null) {
                            inSocket = this.serverSocket$1.accept();
                            try {
                                this.authHelper$2.authClient(inSocket);
                            }
                            catch (Exception e) {
                                if (--remainingAttempts == 0) {
                                    String msg = "Too many failed authentication attempts.";
                                    RBackend$.MODULE$.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                                    throw new IllegalStateException(msg);
                                }
                                RBackend$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Client connection failed authentication.");
                                inSocket = null;
                            }
                        }
                        this.serverSocket$1.close();
                        inSocket.getInputStream().read(buf);
                    }
                    finally {
                        this.serverSocket$1.close();
                        this.sparkRBackend$1.close();
                        System.exit(0);
                    }
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                    this.authHelper$2 = authHelper$2;
                    this.sparkRBackend$1 = sparkRBackend$1;
                    super("wait for socket to close");
                    this.setDaemon(true);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(java.lang.String ), $anonfun$run$2()}, serializedLambda);
                }
            }.start();
            sparkRBackend.run();
        }
        catch (IOException e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Server shutting down: failed with exception ", (Throwable)e);
            sparkRBackend.close();
            System.exit(1);
        }
        System.exit(0);
    }

    private RBackend$() {
    }
}

