// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

use tonic_build::Config;

fn main() -> Result<(), Box<dyn std::error::Error>> {
    #[allow(unused_mut)]
    let mut config = Config::new();

    #[cfg(feature = "vendored")]
    {
        config.protoc_executable(protobuf_src::protoc());
    }

    tonic_build::configure()
        .build_server(false)
        .type_attribute(".", "#[derive(serde::Serialize, serde::Deserialize)]")
        .compile_protos_with_config(
            config,
            &[
                "./skywalking-data-collect-protocol/language-agent/Meter.proto",
                "./skywalking-data-collect-protocol/language-agent/Tracing.proto",
                "./skywalking-data-collect-protocol/logging/Logging.proto",
                "./skywalking-data-collect-protocol/management/Management.proto",
            ],
            &["./skywalking-data-collect-protocol"],
        )?;

    Ok(())
}
